// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//      http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.
//
////////////////////////////////////////////////////////////////////////////////

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.28.1
// 	protoc        v3.21.12
// source: third_party/tink/proto/jwt_hmac.proto

package jwt_hmac_go_proto

import (
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	reflect "reflect"
	sync "sync"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// See https://datatracker.ietf.org/doc/html/rfc7518#section-3.2
type JwtHmacAlgorithm int32

const (
	JwtHmacAlgorithm_HS_UNKNOWN JwtHmacAlgorithm = 0
	JwtHmacAlgorithm_HS256      JwtHmacAlgorithm = 1 // HMAC using SHA-256
	JwtHmacAlgorithm_HS384      JwtHmacAlgorithm = 2 // HMAC using SHA-384
	JwtHmacAlgorithm_HS512      JwtHmacAlgorithm = 3 // HMAC using SHA-512
)

// Enum value maps for JwtHmacAlgorithm.
var (
	JwtHmacAlgorithm_name = map[int32]string{
		0: "HS_UNKNOWN",
		1: "HS256",
		2: "HS384",
		3: "HS512",
	}
	JwtHmacAlgorithm_value = map[string]int32{
		"HS_UNKNOWN": 0,
		"HS256":      1,
		"HS384":      2,
		"HS512":      3,
	}
)

func (x JwtHmacAlgorithm) Enum() *JwtHmacAlgorithm {
	p := new(JwtHmacAlgorithm)
	*p = x
	return p
}

func (x JwtHmacAlgorithm) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (JwtHmacAlgorithm) Descriptor() protoreflect.EnumDescriptor {
	return file_third_party_tink_proto_jwt_hmac_proto_enumTypes[0].Descriptor()
}

func (JwtHmacAlgorithm) Type() protoreflect.EnumType {
	return &file_third_party_tink_proto_jwt_hmac_proto_enumTypes[0]
}

func (x JwtHmacAlgorithm) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use JwtHmacAlgorithm.Descriptor instead.
func (JwtHmacAlgorithm) EnumDescriptor() ([]byte, []int) {
	return file_third_party_tink_proto_jwt_hmac_proto_rawDescGZIP(), []int{0}
}

// key_type: type.googleapis.com/google.crypto.tink.JwtHmacKey
type JwtHmacKey struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version   uint32                `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Algorithm JwtHmacAlgorithm      `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.crypto.tink.JwtHmacAlgorithm" json:"algorithm,omitempty"`
	KeyValue  []byte                `protobuf:"bytes,3,opt,name=key_value,json=keyValue,proto3" json:"key_value,omitempty"`
	CustomKid *JwtHmacKey_CustomKid `protobuf:"bytes,4,opt,name=custom_kid,json=customKid,proto3" json:"custom_kid,omitempty"`
}

func (x *JwtHmacKey) Reset() {
	*x = JwtHmacKey{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_jwt_hmac_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtHmacKey) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtHmacKey) ProtoMessage() {}

func (x *JwtHmacKey) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_jwt_hmac_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtHmacKey.ProtoReflect.Descriptor instead.
func (*JwtHmacKey) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_jwt_hmac_proto_rawDescGZIP(), []int{0}
}

func (x *JwtHmacKey) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtHmacKey) GetAlgorithm() JwtHmacAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return JwtHmacAlgorithm_HS_UNKNOWN
}

func (x *JwtHmacKey) GetKeyValue() []byte {
	if x != nil {
		return x.KeyValue
	}
	return nil
}

func (x *JwtHmacKey) GetCustomKid() *JwtHmacKey_CustomKid {
	if x != nil {
		return x.CustomKid
	}
	return nil
}

type JwtHmacKeyFormat struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Version   uint32           `protobuf:"varint,1,opt,name=version,proto3" json:"version,omitempty"`
	Algorithm JwtHmacAlgorithm `protobuf:"varint,2,opt,name=algorithm,proto3,enum=google.crypto.tink.JwtHmacAlgorithm" json:"algorithm,omitempty"`
	KeySize   uint32           `protobuf:"varint,3,opt,name=key_size,json=keySize,proto3" json:"key_size,omitempty"`
}

func (x *JwtHmacKeyFormat) Reset() {
	*x = JwtHmacKeyFormat{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_jwt_hmac_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtHmacKeyFormat) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtHmacKeyFormat) ProtoMessage() {}

func (x *JwtHmacKeyFormat) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_jwt_hmac_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtHmacKeyFormat.ProtoReflect.Descriptor instead.
func (*JwtHmacKeyFormat) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_jwt_hmac_proto_rawDescGZIP(), []int{1}
}

func (x *JwtHmacKeyFormat) GetVersion() uint32 {
	if x != nil {
		return x.Version
	}
	return 0
}

func (x *JwtHmacKeyFormat) GetAlgorithm() JwtHmacAlgorithm {
	if x != nil {
		return x.Algorithm
	}
	return JwtHmacAlgorithm_HS_UNKNOWN
}

func (x *JwtHmacKeyFormat) GetKeySize() uint32 {
	if x != nil {
		return x.KeySize
	}
	return 0
}

// Optional, custom kid header value to be used with "RAW" keys.
// "TINK" keys with this value set will be rejected.
type JwtHmacKey_CustomKid struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Value string `protobuf:"bytes,1,opt,name=value,proto3" json:"value,omitempty"`
}

func (x *JwtHmacKey_CustomKid) Reset() {
	*x = JwtHmacKey_CustomKid{}
	if protoimpl.UnsafeEnabled {
		mi := &file_third_party_tink_proto_jwt_hmac_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *JwtHmacKey_CustomKid) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*JwtHmacKey_CustomKid) ProtoMessage() {}

func (x *JwtHmacKey_CustomKid) ProtoReflect() protoreflect.Message {
	mi := &file_third_party_tink_proto_jwt_hmac_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use JwtHmacKey_CustomKid.ProtoReflect.Descriptor instead.
func (*JwtHmacKey_CustomKid) Descriptor() ([]byte, []int) {
	return file_third_party_tink_proto_jwt_hmac_proto_rawDescGZIP(), []int{0, 0}
}

func (x *JwtHmacKey_CustomKid) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

var File_third_party_tink_proto_jwt_hmac_proto protoreflect.FileDescriptor

var file_third_party_tink_proto_jwt_hmac_proto_rawDesc = []byte{
	0x0a, 0x25, 0x74, 0x68, 0x69, 0x72, 0x64, 0x5f, 0x70, 0x61, 0x72, 0x74, 0x79, 0x2f, 0x74, 0x69,
	0x6e, 0x6b, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x6a, 0x77, 0x74, 0x5f, 0x68, 0x6d, 0x61,
	0x63, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x22, 0xf3, 0x01, 0x0a, 0x0a,
	0x4a, 0x77, 0x74, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65,
	0x72, 0x73, 0x69, 0x6f, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72,
	0x73, 0x69, 0x6f, 0x6e, 0x12, 0x42, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68,
	0x6d, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x4a, 0x77, 0x74,
	0x48, 0x6d, 0x61, 0x63, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x09, 0x61,
	0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x12, 0x1b, 0x0a, 0x09, 0x6b, 0x65, 0x79, 0x5f,
	0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0c, 0x52, 0x08, 0x6b, 0x65, 0x79,
	0x56, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x47, 0x0a, 0x0a, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x5f,
	0x6b, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x4a,
	0x77, 0x74, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79, 0x2e, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d,
	0x4b, 0x69, 0x64, 0x52, 0x09, 0x63, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4b, 0x69, 0x64, 0x1a, 0x21,
	0x0a, 0x09, 0x43, 0x75, 0x73, 0x74, 0x6f, 0x6d, 0x4b, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x22, 0x8b, 0x01, 0x0a, 0x10, 0x4a, 0x77, 0x74, 0x48, 0x6d, 0x61, 0x63, 0x4b, 0x65, 0x79,
	0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x18, 0x0a, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f,
	0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x76, 0x65, 0x72, 0x73, 0x69, 0x6f, 0x6e,
	0x12, 0x42, 0x0a, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x18, 0x02, 0x20,
	0x01, 0x28, 0x0e, 0x32, 0x24, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79,
	0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x4a, 0x77, 0x74, 0x48, 0x6d, 0x61, 0x63,
	0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69, 0x74, 0x68, 0x6d, 0x52, 0x09, 0x61, 0x6c, 0x67, 0x6f, 0x72,
	0x69, 0x74, 0x68, 0x6d, 0x12, 0x19, 0x0a, 0x08, 0x6b, 0x65, 0x79, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x03, 0x20, 0x01, 0x28, 0x0d, 0x52, 0x07, 0x6b, 0x65, 0x79, 0x53, 0x69, 0x7a, 0x65, 0x2a,
	0x43, 0x0a, 0x10, 0x4a, 0x77, 0x74, 0x48, 0x6d, 0x61, 0x63, 0x41, 0x6c, 0x67, 0x6f, 0x72, 0x69,
	0x74, 0x68, 0x6d, 0x12, 0x0e, 0x0a, 0x0a, 0x48, 0x53, 0x5f, 0x55, 0x4e, 0x4b, 0x4e, 0x4f, 0x57,
	0x4e, 0x10, 0x00, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x53, 0x32, 0x35, 0x36, 0x10, 0x01, 0x12, 0x09,
	0x0a, 0x05, 0x48, 0x53, 0x33, 0x38, 0x34, 0x10, 0x02, 0x12, 0x09, 0x0a, 0x05, 0x48, 0x53, 0x35,
	0x31, 0x32, 0x10, 0x03, 0x42, 0x53, 0x0a, 0x1c, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x6f, 0x2e, 0x74, 0x69, 0x6e, 0x6b, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x31, 0x67, 0x69, 0x74, 0x68, 0x75, 0x62, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x69, 0x6e, 0x6b, 0x2f, 0x67,
	0x6f, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x6a, 0x77, 0x74, 0x5f, 0x68, 0x6d, 0x61, 0x63,
	0x5f, 0x67, 0x6f, 0x5f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x33,
}

var (
	file_third_party_tink_proto_jwt_hmac_proto_rawDescOnce sync.Once
	file_third_party_tink_proto_jwt_hmac_proto_rawDescData = file_third_party_tink_proto_jwt_hmac_proto_rawDesc
)

func file_third_party_tink_proto_jwt_hmac_proto_rawDescGZIP() []byte {
	file_third_party_tink_proto_jwt_hmac_proto_rawDescOnce.Do(func() {
		file_third_party_tink_proto_jwt_hmac_proto_rawDescData = protoimpl.X.CompressGZIP(file_third_party_tink_proto_jwt_hmac_proto_rawDescData)
	})
	return file_third_party_tink_proto_jwt_hmac_proto_rawDescData
}

var file_third_party_tink_proto_jwt_hmac_proto_enumTypes = make([]protoimpl.EnumInfo, 1)
var file_third_party_tink_proto_jwt_hmac_proto_msgTypes = make([]protoimpl.MessageInfo, 3)
var file_third_party_tink_proto_jwt_hmac_proto_goTypes = []interface{}{
	(JwtHmacAlgorithm)(0),        // 0: google.crypto.tink.JwtHmacAlgorithm
	(*JwtHmacKey)(nil),           // 1: google.crypto.tink.JwtHmacKey
	(*JwtHmacKeyFormat)(nil),     // 2: google.crypto.tink.JwtHmacKeyFormat
	(*JwtHmacKey_CustomKid)(nil), // 3: google.crypto.tink.JwtHmacKey.CustomKid
}
var file_third_party_tink_proto_jwt_hmac_proto_depIdxs = []int32{
	0, // 0: google.crypto.tink.JwtHmacKey.algorithm:type_name -> google.crypto.tink.JwtHmacAlgorithm
	3, // 1: google.crypto.tink.JwtHmacKey.custom_kid:type_name -> google.crypto.tink.JwtHmacKey.CustomKid
	0, // 2: google.crypto.tink.JwtHmacKeyFormat.algorithm:type_name -> google.crypto.tink.JwtHmacAlgorithm
	3, // [3:3] is the sub-list for method output_type
	3, // [3:3] is the sub-list for method input_type
	3, // [3:3] is the sub-list for extension type_name
	3, // [3:3] is the sub-list for extension extendee
	0, // [0:3] is the sub-list for field type_name
}

func init() { file_third_party_tink_proto_jwt_hmac_proto_init() }
func file_third_party_tink_proto_jwt_hmac_proto_init() {
	if File_third_party_tink_proto_jwt_hmac_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_third_party_tink_proto_jwt_hmac_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtHmacKey); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_jwt_hmac_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtHmacKeyFormat); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_third_party_tink_proto_jwt_hmac_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*JwtHmacKey_CustomKid); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_third_party_tink_proto_jwt_hmac_proto_rawDesc,
			NumEnums:      1,
			NumMessages:   3,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_third_party_tink_proto_jwt_hmac_proto_goTypes,
		DependencyIndexes: file_third_party_tink_proto_jwt_hmac_proto_depIdxs,
		EnumInfos:         file_third_party_tink_proto_jwt_hmac_proto_enumTypes,
		MessageInfos:      file_third_party_tink_proto_jwt_hmac_proto_msgTypes,
	}.Build()
	File_third_party_tink_proto_jwt_hmac_proto = out.File
	file_third_party_tink_proto_jwt_hmac_proto_rawDesc = nil
	file_third_party_tink_proto_jwt_hmac_proto_goTypes = nil
	file_third_party_tink_proto_jwt_hmac_proto_depIdxs = nil
}
