// Copyright 2022 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/eventarc/v1/trigger.proto

package eventarcpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	code "google.golang.org/genproto/googleapis/rpc/code"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	timestamppb "google.golang.org/protobuf/types/known/timestamppb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// A representation of the trigger resource.
type Trigger struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The resource name of the trigger. Must be unique within the location of the
	// project and must be in
	// `projects/{project}/locations/{location}/triggers/{trigger}` format.
	Name string `protobuf:"bytes,1,opt,name=name,proto3" json:"name,omitempty"`
	// Output only. Server-assigned unique identifier for the trigger. The value is a UUID4
	// string and guaranteed to remain unchanged until the resource is deleted.
	Uid string `protobuf:"bytes,2,opt,name=uid,proto3" json:"uid,omitempty"`
	// Output only. The creation time.
	CreateTime *timestamppb.Timestamp `protobuf:"bytes,5,opt,name=create_time,json=createTime,proto3" json:"create_time,omitempty"`
	// Output only. The last-modified time.
	UpdateTime *timestamppb.Timestamp `protobuf:"bytes,6,opt,name=update_time,json=updateTime,proto3" json:"update_time,omitempty"`
	// Required. Unordered list. The list of filters that applies to event attributes. Only events that
	// match all the provided filters are sent to the destination.
	EventFilters []*EventFilter `protobuf:"bytes,8,rep,name=event_filters,json=eventFilters,proto3" json:"event_filters,omitempty"`
	// Optional. The IAM service account email associated with the trigger. The
	// service account represents the identity of the trigger.
	//
	// The principal who calls this API must have the `iam.serviceAccounts.actAs`
	// permission in the service account. See
	// https://cloud.google.com/iam/docs/understanding-service-accounts?hl=en#sa_common
	// for more information.
	//
	// For Cloud Run destinations, this service account is used to generate
	// identity tokens when invoking the service. See
	// https://cloud.google.com/run/docs/triggering/pubsub-push#create-service-account
	// for information on how to invoke authenticated Cloud Run services.
	// To create Audit Log triggers, the service account should also
	// have the `roles/eventarc.eventReceiver` IAM role.
	ServiceAccount string `protobuf:"bytes,9,opt,name=service_account,json=serviceAccount,proto3" json:"service_account,omitempty"`
	// Required. Destination specifies where the events should be sent to.
	Destination *Destination `protobuf:"bytes,10,opt,name=destination,proto3" json:"destination,omitempty"`
	// Optional. To deliver messages, Eventarc might use other GCP
	// products as a transport intermediary. This field contains a reference to
	// that transport intermediary. This information can be used for debugging
	// purposes.
	Transport *Transport `protobuf:"bytes,11,opt,name=transport,proto3" json:"transport,omitempty"`
	// Optional. User labels attached to the triggers that can be used to group resources.
	Labels map[string]string `protobuf:"bytes,12,rep,name=labels,proto3" json:"labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Optional. The name of the channel associated with the trigger in
	// `projects/{project}/locations/{location}/channels/{channel}` format.
	// You must provide a channel to receive events from Eventarc SaaS partners.
	Channel string `protobuf:"bytes,13,opt,name=channel,proto3" json:"channel,omitempty"`
	// Output only. The reason(s) why a trigger is in FAILED state.
	Conditions map[string]*StateCondition `protobuf:"bytes,15,rep,name=conditions,proto3" json:"conditions,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// Output only. This checksum is computed by the server based on the value of other
	// fields, and might be sent only on create requests to ensure that the
	// client has an up-to-date value before proceeding.
	Etag string `protobuf:"bytes,99,opt,name=etag,proto3" json:"etag,omitempty"`
}

func (x *Trigger) Reset() {
	*x = Trigger{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Trigger) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Trigger) ProtoMessage() {}

func (x *Trigger) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Trigger.ProtoReflect.Descriptor instead.
func (*Trigger) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_trigger_proto_rawDescGZIP(), []int{0}
}

func (x *Trigger) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *Trigger) GetUid() string {
	if x != nil {
		return x.Uid
	}
	return ""
}

func (x *Trigger) GetCreateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.CreateTime
	}
	return nil
}

func (x *Trigger) GetUpdateTime() *timestamppb.Timestamp {
	if x != nil {
		return x.UpdateTime
	}
	return nil
}

func (x *Trigger) GetEventFilters() []*EventFilter {
	if x != nil {
		return x.EventFilters
	}
	return nil
}

func (x *Trigger) GetServiceAccount() string {
	if x != nil {
		return x.ServiceAccount
	}
	return ""
}

func (x *Trigger) GetDestination() *Destination {
	if x != nil {
		return x.Destination
	}
	return nil
}

func (x *Trigger) GetTransport() *Transport {
	if x != nil {
		return x.Transport
	}
	return nil
}

func (x *Trigger) GetLabels() map[string]string {
	if x != nil {
		return x.Labels
	}
	return nil
}

func (x *Trigger) GetChannel() string {
	if x != nil {
		return x.Channel
	}
	return ""
}

func (x *Trigger) GetConditions() map[string]*StateCondition {
	if x != nil {
		return x.Conditions
	}
	return nil
}

func (x *Trigger) GetEtag() string {
	if x != nil {
		return x.Etag
	}
	return ""
}

// Filters events based on exact matches on the CloudEvents attributes.
type EventFilter struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of a CloudEvents attribute. Currently, only a subset of attributes
	// are supported for filtering.
	//
	// All triggers MUST provide a filter for the 'type' attribute.
	Attribute string `protobuf:"bytes,1,opt,name=attribute,proto3" json:"attribute,omitempty"`
	// Required. The value for the attribute.
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// Optional. The operator used for matching the events with the value of the
	// filter. If not specified, only events that have an exact key-value pair
	// specified in the filter are matched. The only allowed value is
	// `match-path-pattern`.
	Operator string `protobuf:"bytes,3,opt,name=operator,proto3" json:"operator,omitempty"`
}

func (x *EventFilter) Reset() {
	*x = EventFilter{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *EventFilter) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*EventFilter) ProtoMessage() {}

func (x *EventFilter) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use EventFilter.ProtoReflect.Descriptor instead.
func (*EventFilter) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_trigger_proto_rawDescGZIP(), []int{1}
}

func (x *EventFilter) GetAttribute() string {
	if x != nil {
		return x.Attribute
	}
	return ""
}

func (x *EventFilter) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *EventFilter) GetOperator() string {
	if x != nil {
		return x.Operator
	}
	return ""
}

// A condition that is part of the trigger state computation.
type StateCondition struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The canonical code of the condition.
	Code code.Code `protobuf:"varint,1,opt,name=code,proto3,enum=google.rpc.Code" json:"code,omitempty"`
	// Human-readable message.
	Message string `protobuf:"bytes,2,opt,name=message,proto3" json:"message,omitempty"`
}

func (x *StateCondition) Reset() {
	*x = StateCondition{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StateCondition) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StateCondition) ProtoMessage() {}

func (x *StateCondition) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StateCondition.ProtoReflect.Descriptor instead.
func (*StateCondition) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_trigger_proto_rawDescGZIP(), []int{2}
}

func (x *StateCondition) GetCode() code.Code {
	if x != nil {
		return x.Code
	}
	return code.Code(0)
}

func (x *StateCondition) GetMessage() string {
	if x != nil {
		return x.Message
	}
	return ""
}

// Represents a target of an invocation over HTTP.
type Destination struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Descriptor_:
	//
	//	*Destination_CloudRun
	//	*Destination_CloudFunction
	//	*Destination_Gke
	//	*Destination_Workflow
	Descriptor_ isDestination_Descriptor_ `protobuf_oneof:"descriptor"`
}

func (x *Destination) Reset() {
	*x = Destination{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Destination) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Destination) ProtoMessage() {}

func (x *Destination) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Destination.ProtoReflect.Descriptor instead.
func (*Destination) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_trigger_proto_rawDescGZIP(), []int{3}
}

func (m *Destination) GetDescriptor_() isDestination_Descriptor_ {
	if m != nil {
		return m.Descriptor_
	}
	return nil
}

func (x *Destination) GetCloudRun() *CloudRun {
	if x, ok := x.GetDescriptor_().(*Destination_CloudRun); ok {
		return x.CloudRun
	}
	return nil
}

func (x *Destination) GetCloudFunction() string {
	if x, ok := x.GetDescriptor_().(*Destination_CloudFunction); ok {
		return x.CloudFunction
	}
	return ""
}

func (x *Destination) GetGke() *GKE {
	if x, ok := x.GetDescriptor_().(*Destination_Gke); ok {
		return x.Gke
	}
	return nil
}

func (x *Destination) GetWorkflow() string {
	if x, ok := x.GetDescriptor_().(*Destination_Workflow); ok {
		return x.Workflow
	}
	return ""
}

type isDestination_Descriptor_ interface {
	isDestination_Descriptor_()
}

type Destination_CloudRun struct {
	// Cloud Run fully-managed resource that receives the events. The resource
	// should be in the same project as the trigger.
	CloudRun *CloudRun `protobuf:"bytes,1,opt,name=cloud_run,json=cloudRun,proto3,oneof"`
}

type Destination_CloudFunction struct {
	// The Cloud Function resource name. Only Cloud Functions V2 is supported.
	// Format: `projects/{project}/locations/{location}/functions/{function}`
	CloudFunction string `protobuf:"bytes,2,opt,name=cloud_function,json=cloudFunction,proto3,oneof"`
}

type Destination_Gke struct {
	// A GKE service capable of receiving events. The service should be running
	// in the same project as the trigger.
	Gke *GKE `protobuf:"bytes,3,opt,name=gke,proto3,oneof"`
}

type Destination_Workflow struct {
	// The resource name of the Workflow whose Executions are triggered by
	// the events. The Workflow resource should be deployed in the same project
	// as the trigger.
	// Format: `projects/{project}/locations/{location}/workflows/{workflow}`
	Workflow string `protobuf:"bytes,4,opt,name=workflow,proto3,oneof"`
}

func (*Destination_CloudRun) isDestination_Descriptor_() {}

func (*Destination_CloudFunction) isDestination_Descriptor_() {}

func (*Destination_Gke) isDestination_Descriptor_() {}

func (*Destination_Workflow) isDestination_Descriptor_() {}

// Represents the transport intermediaries created for the trigger to
// deliver events.
type Transport struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Intermediary:
	//
	//	*Transport_Pubsub
	Intermediary isTransport_Intermediary `protobuf_oneof:"intermediary"`
}

func (x *Transport) Reset() {
	*x = Transport{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Transport) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Transport) ProtoMessage() {}

func (x *Transport) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Transport.ProtoReflect.Descriptor instead.
func (*Transport) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_trigger_proto_rawDescGZIP(), []int{4}
}

func (m *Transport) GetIntermediary() isTransport_Intermediary {
	if m != nil {
		return m.Intermediary
	}
	return nil
}

func (x *Transport) GetPubsub() *Pubsub {
	if x, ok := x.GetIntermediary().(*Transport_Pubsub); ok {
		return x.Pubsub
	}
	return nil
}

type isTransport_Intermediary interface {
	isTransport_Intermediary()
}

type Transport_Pubsub struct {
	// The Pub/Sub topic and subscription used by Eventarc as a transport
	// intermediary.
	Pubsub *Pubsub `protobuf:"bytes,1,opt,name=pubsub,proto3,oneof"`
}

func (*Transport_Pubsub) isTransport_Intermediary() {}

// Represents a Cloud Run destination.
type CloudRun struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the Cloud Run service being addressed. See
	// https://cloud.google.com/run/docs/reference/rest/v1/namespaces.services.
	//
	// Only services located in the same project as the trigger object
	// can be addressed.
	Service string `protobuf:"bytes,1,opt,name=service,proto3" json:"service,omitempty"`
	// Optional. The relative path on the Cloud Run service the events should be sent to.
	//
	// The value must conform to the definition of a URI path segment (section 3.3
	// of RFC2396). Examples: "/route", "route", "route/subroute".
	Path string `protobuf:"bytes,2,opt,name=path,proto3" json:"path,omitempty"`
	// Required. The region the Cloud Run service is deployed in.
	Region string `protobuf:"bytes,3,opt,name=region,proto3" json:"region,omitempty"`
}

func (x *CloudRun) Reset() {
	*x = CloudRun{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CloudRun) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CloudRun) ProtoMessage() {}

func (x *CloudRun) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CloudRun.ProtoReflect.Descriptor instead.
func (*CloudRun) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_trigger_proto_rawDescGZIP(), []int{5}
}

func (x *CloudRun) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *CloudRun) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

func (x *CloudRun) GetRegion() string {
	if x != nil {
		return x.Region
	}
	return ""
}

// Represents a GKE destination.
type GKE struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The name of the cluster the GKE service is running in. The cluster must be
	// running in the same project as the trigger being created.
	Cluster string `protobuf:"bytes,1,opt,name=cluster,proto3" json:"cluster,omitempty"`
	// Required. The name of the Google Compute Engine in which the cluster resides, which
	// can either be compute zone (for example, us-central1-a) for the zonal
	// clusters or region (for example, us-central1) for regional clusters.
	Location string `protobuf:"bytes,2,opt,name=location,proto3" json:"location,omitempty"`
	// Required. The namespace the GKE service is running in.
	Namespace string `protobuf:"bytes,3,opt,name=namespace,proto3" json:"namespace,omitempty"`
	// Required. Name of the GKE service.
	Service string `protobuf:"bytes,4,opt,name=service,proto3" json:"service,omitempty"`
	// Optional. The relative path on the GKE service the events should be sent to.
	//
	// The value must conform to the definition of a URI path segment (section 3.3
	// of RFC2396). Examples: "/route", "route", "route/subroute".
	Path string `protobuf:"bytes,5,opt,name=path,proto3" json:"path,omitempty"`
}

func (x *GKE) Reset() {
	*x = GKE{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GKE) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GKE) ProtoMessage() {}

func (x *GKE) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GKE.ProtoReflect.Descriptor instead.
func (*GKE) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_trigger_proto_rawDescGZIP(), []int{6}
}

func (x *GKE) GetCluster() string {
	if x != nil {
		return x.Cluster
	}
	return ""
}

func (x *GKE) GetLocation() string {
	if x != nil {
		return x.Location
	}
	return ""
}

func (x *GKE) GetNamespace() string {
	if x != nil {
		return x.Namespace
	}
	return ""
}

func (x *GKE) GetService() string {
	if x != nil {
		return x.Service
	}
	return ""
}

func (x *GKE) GetPath() string {
	if x != nil {
		return x.Path
	}
	return ""
}

// Represents a Pub/Sub transport.
type Pubsub struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The name of the Pub/Sub topic created and managed by Eventarc as
	// a transport for the event delivery. Format:
	// `projects/{PROJECT_ID}/topics/{TOPIC_NAME}`.
	//
	// You can set an existing topic for triggers of the type
	// `google.cloud.pubsub.topic.v1.messagePublished`. The topic you provide
	// here is not deleted by Eventarc at trigger deletion.
	Topic string `protobuf:"bytes,1,opt,name=topic,proto3" json:"topic,omitempty"`
	// Output only. The name of the Pub/Sub subscription created and managed by Eventarc
	// as a transport for the event delivery. Format:
	// `projects/{PROJECT_ID}/subscriptions/{SUBSCRIPTION_NAME}`.
	Subscription string `protobuf:"bytes,2,opt,name=subscription,proto3" json:"subscription,omitempty"`
}

func (x *Pubsub) Reset() {
	*x = Pubsub{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Pubsub) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Pubsub) ProtoMessage() {}

func (x *Pubsub) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_eventarc_v1_trigger_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Pubsub.ProtoReflect.Descriptor instead.
func (*Pubsub) Descriptor() ([]byte, []int) {
	return file_google_cloud_eventarc_v1_trigger_proto_rawDescGZIP(), []int{7}
}

func (x *Pubsub) GetTopic() string {
	if x != nil {
		return x.Topic
	}
	return ""
}

func (x *Pubsub) GetSubscription() string {
	if x != nil {
		return x.Subscription
	}
	return ""
}

var File_google_cloud_eventarc_v1_trigger_proto protoreflect.FileDescriptor

var file_google_cloud_eventarc_v1_trigger_proto_rawDesc = []byte{
	0x0a, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12, 0x18, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e,
	0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66,
	0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f,
	0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1f,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f,
	0x74, 0x69, 0x6d, 0x65, 0x73, 0x74, 0x61, 0x6d, 0x70, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a,
	0x15, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x72, 0x70, 0x63, 0x2f, 0x63, 0x6f, 0x64, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xf0, 0x07, 0x0a, 0x07, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x12, 0x17, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x15, 0x0a, 0x03, 0x75,
	0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75,
	0x69, 0x64, 0x12, 0x40, 0x0a, 0x0b, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x5f, 0x74, 0x69, 0x6d,
	0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65, 0x73, 0x74,
	0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65,
	0x54, 0x69, 0x6d, 0x65, 0x12, 0x40, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x74,
	0x69, 0x6d, 0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x54, 0x69, 0x6d, 0x65,
	0x73, 0x74, 0x61, 0x6d, 0x70, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x54, 0x69, 0x6d, 0x65, 0x12, 0x52, 0x0a, 0x0d, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x5f,
	0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x18, 0x08, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65,
	0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x76, 0x65, 0x6e, 0x74, 0x46, 0x69,
	0x6c, 0x74, 0x65, 0x72, 0x42, 0x06, 0xe0, 0x41, 0x06, 0xe0, 0x41, 0x02, 0x52, 0x0c, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x73, 0x12, 0x52, 0x0a, 0x0f, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x29, 0xe0, 0x41, 0x01, 0xfa, 0x41, 0x23, 0x0a, 0x21, 0x69, 0x61, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x52, 0x0e,
	0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12, 0x4c,
	0x0a, 0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x0a, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x44,
	0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x0b, 0x64, 0x65, 0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x46, 0x0a, 0x09,
	0x74, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x18, 0x0b, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x23, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x72, 0x61, 0x6e, 0x73,
	0x70, 0x6f, 0x72, 0x74, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x74, 0x72, 0x61, 0x6e, 0x73,
	0x70, 0x6f, 0x72, 0x74, 0x12, 0x4a, 0x0a, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x0c,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e,
	0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x06, 0x6c, 0x61, 0x62, 0x65, 0x6c, 0x73,
	0x12, 0x1d, 0x0a, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x18, 0x0d, 0x20, 0x01, 0x28,
	0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x07, 0x63, 0x68, 0x61, 0x6e, 0x6e, 0x65, 0x6c, 0x12,
	0x56, 0x0a, 0x0a, 0x63, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x18, 0x0f, 0x20,
	0x03, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x54,
	0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x2e, 0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e,
	0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x63, 0x6f, 0x6e,
	0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x12, 0x17, 0x0a, 0x04, 0x65, 0x74, 0x61, 0x67, 0x18,
	0x63, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x04, 0x65, 0x74, 0x61, 0x67,
	0x1a, 0x39, 0x0a, 0x0b, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12,
	0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65,
	0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x1a, 0x67, 0x0a, 0x0f, 0x43,
	0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x3e, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32,
	0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x3a, 0x73, 0xea, 0x41, 0x70, 0x0a, 0x1f, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x61, 0x72, 0x63, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63,
	0x6f, 0x6d, 0x2f, 0x54, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x12, 0x3a, 0x70, 0x72, 0x6f, 0x6a,
	0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c,
	0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x7d, 0x2f, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73, 0x2f, 0x7b, 0x74, 0x72,
	0x69, 0x67, 0x67, 0x65, 0x72, 0x7d, 0x2a, 0x08, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x73,
	0x32, 0x07, 0x74, 0x72, 0x69, 0x67, 0x67, 0x65, 0x72, 0x22, 0x6c, 0x0a, 0x0b, 0x45, 0x76, 0x65,
	0x6e, 0x74, 0x46, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x21, 0x0a, 0x09, 0x61, 0x74, 0x74, 0x72,
	0x69, 0x62, 0x75, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x09, 0x61, 0x74, 0x74, 0x72, 0x69, 0x62, 0x75, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x1f, 0x0a, 0x08, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x6f, 0x72, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x08, 0x6f,
	0x70, 0x65, 0x72, 0x61, 0x74, 0x6f, 0x72, 0x22, 0x50, 0x0a, 0x0e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x6e, 0x64, 0x69, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x24, 0x0a, 0x04, 0x63, 0x6f, 0x64,
	0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x10, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x72, 0x70, 0x63, 0x2e, 0x43, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x63, 0x6f, 0x64, 0x65, 0x12,
	0x18, 0x0a, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x07, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x22, 0xb2, 0x02, 0x0a, 0x0b, 0x44, 0x65,
	0x73, 0x74, 0x69, 0x6e, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x41, 0x0a, 0x09, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e,
	0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e,
	0x48, 0x00, 0x52, 0x08, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x52, 0x75, 0x6e, 0x12, 0x59, 0x0a, 0x0e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x5f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x30, 0xfa, 0x41, 0x2d, 0x0a, 0x2b, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x46, 0x75,
	0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x48, 0x00, 0x52, 0x0d, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x46,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x31, 0x0a, 0x03, 0x67, 0x6b, 0x65, 0x18, 0x03,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e,
	0x47, 0x4b, 0x45, 0x48, 0x00, 0x52, 0x03, 0x67, 0x6b, 0x65, 0x12, 0x44, 0x0a, 0x08, 0x77, 0x6f,
	0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x26, 0xfa, 0x41,
	0x23, 0x0a, 0x21, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b,
	0x66, 0x6c, 0x6f, 0x77, 0x48, 0x00, 0x52, 0x08, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77,
	0x42, 0x0c, 0x0a, 0x0a, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x6f, 0x72, 0x22, 0x57,
	0x0a, 0x09, 0x54, 0x72, 0x61, 0x6e, 0x73, 0x70, 0x6f, 0x72, 0x74, 0x12, 0x3a, 0x0a, 0x06, 0x70,
	0x75, 0x62, 0x73, 0x75, 0x62, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x20, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76, 0x65, 0x6e, 0x74,
	0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x2e, 0x50, 0x75, 0x62, 0x73, 0x75, 0x62, 0x48, 0x00, 0x52,
	0x06, 0x70, 0x75, 0x62, 0x73, 0x75, 0x62, 0x42, 0x0e, 0x0a, 0x0c, 0x69, 0x6e, 0x74, 0x65, 0x72,
	0x6d, 0x65, 0x64, 0x69, 0x61, 0x72, 0x79, 0x22, 0x7e, 0x0a, 0x08, 0x43, 0x6c, 0x6f, 0x75, 0x64,
	0x52, 0x75, 0x6e, 0x12, 0x3c, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x22, 0xe0, 0x41, 0x02, 0xfa, 0x41, 0x1c, 0x0a, 0x1a, 0x72, 0x75,
	0x6e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x12, 0x1b, 0x0a, 0x06, 0x72, 0x65,
	0x67, 0x69, 0x6f, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52,
	0x06, 0x72, 0x65, 0x67, 0x69, 0x6f, 0x6e, 0x22, 0xa0, 0x01, 0x0a, 0x03, 0x47, 0x4b, 0x45, 0x12,
	0x1d, 0x0a, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x63, 0x6c, 0x75, 0x73, 0x74, 0x65, 0x72, 0x12, 0x1f,
	0x0a, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x21, 0x0a, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61, 0x63, 0x65, 0x18, 0x03, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x70, 0x61,
	0x63, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x18, 0x04, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x12, 0x17, 0x0a, 0x04, 0x70, 0x61, 0x74, 0x68, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42,
	0x03, 0xe0, 0x41, 0x01, 0x52, 0x04, 0x70, 0x61, 0x74, 0x68, 0x22, 0x4c, 0x0a, 0x06, 0x50, 0x75,
	0x62, 0x73, 0x75, 0x62, 0x12, 0x19, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x05, 0x74, 0x6f, 0x70, 0x69, 0x63, 0x12,
	0x27, 0x0a, 0x0c, 0x73, 0x75, 0x62, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0c, 0x73, 0x75, 0x62, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0xb8, 0x03, 0xea, 0x41, 0x6b, 0x0a, 0x2b,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x43, 0x6c,
	0x6f, 0x75, 0x64, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x12, 0x3c, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f,
	0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b,
	0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0xea, 0x41, 0x59, 0x0a, 0x21, 0x69, 0x61,
	0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d,
	0x2f, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x12,
	0x34, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65,
	0x63, 0x74, 0x7d, 0x2f, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x41, 0x63, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x61, 0x63, 0x63,
	0x6f, 0x75, 0x6e, 0x74, 0x7d, 0xea, 0x41, 0x1f, 0x0a, 0x1a, 0x72, 0x75, 0x6e, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x01, 0x2a, 0xea, 0x41, 0x61, 0x0a, 0x21, 0x77, 0x6f, 0x72, 0x6b,
	0x66, 0x6c, 0x6f, 0x77, 0x73, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73,
	0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x57, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x12, 0x3c, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74,
	0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2f, 0x7b, 0x6c, 0x6f, 0x63,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x73,
	0x2f, 0x7b, 0x77, 0x6f, 0x72, 0x6b, 0x66, 0x6c, 0x6f, 0x77, 0x7d, 0x0a, 0x1c, 0x63, 0x6f, 0x6d,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2e, 0x76, 0x31, 0x42, 0x0c, 0x54, 0x72, 0x69, 0x67, 0x67,
	0x65, 0x72, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x38, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x65,
	0x76, 0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x65, 0x76,
	0x65, 0x6e, 0x74, 0x61, 0x72, 0x63, 0x70, 0x62, 0x3b, 0x65, 0x76, 0x65, 0x6e, 0x74, 0x61, 0x72,
	0x63, 0x70, 0x62, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_eventarc_v1_trigger_proto_rawDescOnce sync.Once
	file_google_cloud_eventarc_v1_trigger_proto_rawDescData = file_google_cloud_eventarc_v1_trigger_proto_rawDesc
)

func file_google_cloud_eventarc_v1_trigger_proto_rawDescGZIP() []byte {
	file_google_cloud_eventarc_v1_trigger_proto_rawDescOnce.Do(func() {
		file_google_cloud_eventarc_v1_trigger_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_eventarc_v1_trigger_proto_rawDescData)
	})
	return file_google_cloud_eventarc_v1_trigger_proto_rawDescData
}

var file_google_cloud_eventarc_v1_trigger_proto_msgTypes = make([]protoimpl.MessageInfo, 10)
var file_google_cloud_eventarc_v1_trigger_proto_goTypes = []interface{}{
	(*Trigger)(nil),               // 0: google.cloud.eventarc.v1.Trigger
	(*EventFilter)(nil),           // 1: google.cloud.eventarc.v1.EventFilter
	(*StateCondition)(nil),        // 2: google.cloud.eventarc.v1.StateCondition
	(*Destination)(nil),           // 3: google.cloud.eventarc.v1.Destination
	(*Transport)(nil),             // 4: google.cloud.eventarc.v1.Transport
	(*CloudRun)(nil),              // 5: google.cloud.eventarc.v1.CloudRun
	(*GKE)(nil),                   // 6: google.cloud.eventarc.v1.GKE
	(*Pubsub)(nil),                // 7: google.cloud.eventarc.v1.Pubsub
	nil,                           // 8: google.cloud.eventarc.v1.Trigger.LabelsEntry
	nil,                           // 9: google.cloud.eventarc.v1.Trigger.ConditionsEntry
	(*timestamppb.Timestamp)(nil), // 10: google.protobuf.Timestamp
	(code.Code)(0),                // 11: google.rpc.Code
}
var file_google_cloud_eventarc_v1_trigger_proto_depIdxs = []int32{
	10, // 0: google.cloud.eventarc.v1.Trigger.create_time:type_name -> google.protobuf.Timestamp
	10, // 1: google.cloud.eventarc.v1.Trigger.update_time:type_name -> google.protobuf.Timestamp
	1,  // 2: google.cloud.eventarc.v1.Trigger.event_filters:type_name -> google.cloud.eventarc.v1.EventFilter
	3,  // 3: google.cloud.eventarc.v1.Trigger.destination:type_name -> google.cloud.eventarc.v1.Destination
	4,  // 4: google.cloud.eventarc.v1.Trigger.transport:type_name -> google.cloud.eventarc.v1.Transport
	8,  // 5: google.cloud.eventarc.v1.Trigger.labels:type_name -> google.cloud.eventarc.v1.Trigger.LabelsEntry
	9,  // 6: google.cloud.eventarc.v1.Trigger.conditions:type_name -> google.cloud.eventarc.v1.Trigger.ConditionsEntry
	11, // 7: google.cloud.eventarc.v1.StateCondition.code:type_name -> google.rpc.Code
	5,  // 8: google.cloud.eventarc.v1.Destination.cloud_run:type_name -> google.cloud.eventarc.v1.CloudRun
	6,  // 9: google.cloud.eventarc.v1.Destination.gke:type_name -> google.cloud.eventarc.v1.GKE
	7,  // 10: google.cloud.eventarc.v1.Transport.pubsub:type_name -> google.cloud.eventarc.v1.Pubsub
	2,  // 11: google.cloud.eventarc.v1.Trigger.ConditionsEntry.value:type_name -> google.cloud.eventarc.v1.StateCondition
	12, // [12:12] is the sub-list for method output_type
	12, // [12:12] is the sub-list for method input_type
	12, // [12:12] is the sub-list for extension type_name
	12, // [12:12] is the sub-list for extension extendee
	0,  // [0:12] is the sub-list for field type_name
}

func init() { file_google_cloud_eventarc_v1_trigger_proto_init() }
func file_google_cloud_eventarc_v1_trigger_proto_init() {
	if File_google_cloud_eventarc_v1_trigger_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_eventarc_v1_trigger_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Trigger); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_eventarc_v1_trigger_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*EventFilter); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_eventarc_v1_trigger_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StateCondition); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_eventarc_v1_trigger_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Destination); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_eventarc_v1_trigger_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Transport); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_eventarc_v1_trigger_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CloudRun); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_eventarc_v1_trigger_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GKE); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_eventarc_v1_trigger_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Pubsub); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_eventarc_v1_trigger_proto_msgTypes[3].OneofWrappers = []interface{}{
		(*Destination_CloudRun)(nil),
		(*Destination_CloudFunction)(nil),
		(*Destination_Gke)(nil),
		(*Destination_Workflow)(nil),
	}
	file_google_cloud_eventarc_v1_trigger_proto_msgTypes[4].OneofWrappers = []interface{}{
		(*Transport_Pubsub)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_eventarc_v1_trigger_proto_rawDesc,
			NumEnums:      0,
			NumMessages:   10,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_eventarc_v1_trigger_proto_goTypes,
		DependencyIndexes: file_google_cloud_eventarc_v1_trigger_proto_depIdxs,
		MessageInfos:      file_google_cloud_eventarc_v1_trigger_proto_msgTypes,
	}.Build()
	File_google_cloud_eventarc_v1_trigger_proto = out.File
	file_google_cloud_eventarc_v1_trigger_proto_rawDesc = nil
	file_google_cloud_eventarc_v1_trigger_proto_goTypes = nil
	file_google_cloud_eventarc_v1_trigger_proto_depIdxs = nil
}
