// Copyright 2023 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.25.2
// source: google/cloud/aiplatform/v1beta1/content.proto

package aiplatformpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	date "google.golang.org/genproto/googleapis/type/date"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	durationpb "google.golang.org/protobuf/types/known/durationpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Harm categories that will block the content.
type HarmCategory int32

const (
	// The harm category is unspecified.
	HarmCategory_HARM_CATEGORY_UNSPECIFIED HarmCategory = 0
	// The harm category is hate speech.
	HarmCategory_HARM_CATEGORY_HATE_SPEECH HarmCategory = 1
	// The harm category is dangerous content.
	HarmCategory_HARM_CATEGORY_DANGEROUS_CONTENT HarmCategory = 2
	// The harm category is harassment.
	HarmCategory_HARM_CATEGORY_HARASSMENT HarmCategory = 3
	// The harm category is sexually explicit content.
	HarmCategory_HARM_CATEGORY_SEXUALLY_EXPLICIT HarmCategory = 4
)

// Enum value maps for HarmCategory.
var (
	HarmCategory_name = map[int32]string{
		0: "HARM_CATEGORY_UNSPECIFIED",
		1: "HARM_CATEGORY_HATE_SPEECH",
		2: "HARM_CATEGORY_DANGEROUS_CONTENT",
		3: "HARM_CATEGORY_HARASSMENT",
		4: "HARM_CATEGORY_SEXUALLY_EXPLICIT",
	}
	HarmCategory_value = map[string]int32{
		"HARM_CATEGORY_UNSPECIFIED":       0,
		"HARM_CATEGORY_HATE_SPEECH":       1,
		"HARM_CATEGORY_DANGEROUS_CONTENT": 2,
		"HARM_CATEGORY_HARASSMENT":        3,
		"HARM_CATEGORY_SEXUALLY_EXPLICIT": 4,
	}
)

func (x HarmCategory) Enum() *HarmCategory {
	p := new(HarmCategory)
	*p = x
	return p
}

func (x HarmCategory) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (HarmCategory) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[0].Descriptor()
}

func (HarmCategory) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[0]
}

func (x HarmCategory) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use HarmCategory.Descriptor instead.
func (HarmCategory) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{0}
}

// Probability based thresholds levels for blocking.
type SafetySetting_HarmBlockThreshold int32

const (
	// Unspecified harm block threshold.
	SafetySetting_HARM_BLOCK_THRESHOLD_UNSPECIFIED SafetySetting_HarmBlockThreshold = 0
	// Block low threshold and above (i.e. block more).
	SafetySetting_BLOCK_LOW_AND_ABOVE SafetySetting_HarmBlockThreshold = 1
	// Block medium threshold and above.
	SafetySetting_BLOCK_MEDIUM_AND_ABOVE SafetySetting_HarmBlockThreshold = 2
	// Block only high threshold (i.e. block less).
	SafetySetting_BLOCK_ONLY_HIGH SafetySetting_HarmBlockThreshold = 3
	// Block none.
	SafetySetting_BLOCK_NONE SafetySetting_HarmBlockThreshold = 4
)

// Enum value maps for SafetySetting_HarmBlockThreshold.
var (
	SafetySetting_HarmBlockThreshold_name = map[int32]string{
		0: "HARM_BLOCK_THRESHOLD_UNSPECIFIED",
		1: "BLOCK_LOW_AND_ABOVE",
		2: "BLOCK_MEDIUM_AND_ABOVE",
		3: "BLOCK_ONLY_HIGH",
		4: "BLOCK_NONE",
	}
	SafetySetting_HarmBlockThreshold_value = map[string]int32{
		"HARM_BLOCK_THRESHOLD_UNSPECIFIED": 0,
		"BLOCK_LOW_AND_ABOVE":              1,
		"BLOCK_MEDIUM_AND_ABOVE":           2,
		"BLOCK_ONLY_HIGH":                  3,
		"BLOCK_NONE":                       4,
	}
)

func (x SafetySetting_HarmBlockThreshold) Enum() *SafetySetting_HarmBlockThreshold {
	p := new(SafetySetting_HarmBlockThreshold)
	*p = x
	return p
}

func (x SafetySetting_HarmBlockThreshold) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetySetting_HarmBlockThreshold) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[1].Descriptor()
}

func (SafetySetting_HarmBlockThreshold) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[1]
}

func (x SafetySetting_HarmBlockThreshold) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetySetting_HarmBlockThreshold.Descriptor instead.
func (SafetySetting_HarmBlockThreshold) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{6, 0}
}

// Harm probability levels in the content.
type SafetyRating_HarmProbability int32

const (
	// Harm probability unspecified.
	SafetyRating_HARM_PROBABILITY_UNSPECIFIED SafetyRating_HarmProbability = 0
	// Negligible level of harm.
	SafetyRating_NEGLIGIBLE SafetyRating_HarmProbability = 1
	// Low level of harm.
	SafetyRating_LOW SafetyRating_HarmProbability = 2
	// Medium level of harm.
	SafetyRating_MEDIUM SafetyRating_HarmProbability = 3
	// High level of harm.
	SafetyRating_HIGH SafetyRating_HarmProbability = 4
)

// Enum value maps for SafetyRating_HarmProbability.
var (
	SafetyRating_HarmProbability_name = map[int32]string{
		0: "HARM_PROBABILITY_UNSPECIFIED",
		1: "NEGLIGIBLE",
		2: "LOW",
		3: "MEDIUM",
		4: "HIGH",
	}
	SafetyRating_HarmProbability_value = map[string]int32{
		"HARM_PROBABILITY_UNSPECIFIED": 0,
		"NEGLIGIBLE":                   1,
		"LOW":                          2,
		"MEDIUM":                       3,
		"HIGH":                         4,
	}
)

func (x SafetyRating_HarmProbability) Enum() *SafetyRating_HarmProbability {
	p := new(SafetyRating_HarmProbability)
	*p = x
	return p
}

func (x SafetyRating_HarmProbability) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (SafetyRating_HarmProbability) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[2].Descriptor()
}

func (SafetyRating_HarmProbability) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[2]
}

func (x SafetyRating_HarmProbability) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use SafetyRating_HarmProbability.Descriptor instead.
func (SafetyRating_HarmProbability) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{7, 0}
}

// The reason why the model stopped generating tokens.
// If empty, the model has not stopped generating the tokens.
type Candidate_FinishReason int32

const (
	// The finish reason is unspecified.
	Candidate_FINISH_REASON_UNSPECIFIED Candidate_FinishReason = 0
	// Natural stop point of the model or provided stop sequence.
	Candidate_STOP Candidate_FinishReason = 1
	// The maximum number of tokens as specified in the request was reached.
	Candidate_MAX_TOKENS Candidate_FinishReason = 2
	// The token generation was stopped as the response was flagged for safety
	// reasons. NOTE: When streaming the Candidate.content will be empty if
	// content filters blocked the output.
	Candidate_SAFETY Candidate_FinishReason = 3
	// The token generation was stopped as the response was flagged for
	// unauthorized citations.
	Candidate_RECITATION Candidate_FinishReason = 4
	// All other reasons that stopped the token generation
	Candidate_OTHER Candidate_FinishReason = 5
)

// Enum value maps for Candidate_FinishReason.
var (
	Candidate_FinishReason_name = map[int32]string{
		0: "FINISH_REASON_UNSPECIFIED",
		1: "STOP",
		2: "MAX_TOKENS",
		3: "SAFETY",
		4: "RECITATION",
		5: "OTHER",
	}
	Candidate_FinishReason_value = map[string]int32{
		"FINISH_REASON_UNSPECIFIED": 0,
		"STOP":                      1,
		"MAX_TOKENS":                2,
		"SAFETY":                    3,
		"RECITATION":                4,
		"OTHER":                     5,
	}
)

func (x Candidate_FinishReason) Enum() *Candidate_FinishReason {
	p := new(Candidate_FinishReason)
	*p = x
	return p
}

func (x Candidate_FinishReason) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (Candidate_FinishReason) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[3].Descriptor()
}

func (Candidate_FinishReason) Type() protoreflect.EnumType {
	return &file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes[3]
}

func (x Candidate_FinishReason) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use Candidate_FinishReason.Descriptor instead.
func (Candidate_FinishReason) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{10, 0}
}

// The base structured datatype containing multi-part content of a message.
//
// A `Content` includes a `role` field designating the producer of the `Content`
// and a `parts` field containing multi-part data that contains the content of
// the message turn.
type Content struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The producer of the content. Must be either 'user' or 'model'.
	//
	// Useful to set for multi-turn conversations, otherwise can be left blank
	// or unset.
	Role string `protobuf:"bytes,1,opt,name=role,proto3" json:"role,omitempty"`
	// Required. Ordered `Parts` that constitute a single message. Parts may have
	// different IANA MIME types.
	Parts []*Part `protobuf:"bytes,2,rep,name=parts,proto3" json:"parts,omitempty"`
}

func (x *Content) Reset() {
	*x = Content{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Content) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Content) ProtoMessage() {}

func (x *Content) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Content.ProtoReflect.Descriptor instead.
func (*Content) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{0}
}

func (x *Content) GetRole() string {
	if x != nil {
		return x.Role
	}
	return ""
}

func (x *Content) GetParts() []*Part {
	if x != nil {
		return x.Parts
	}
	return nil
}

// A datatype containing media that is part of a multi-part `Content` message.
//
// A `Part` consists of data which has an associated datatype. A `Part` can only
// contain one of the accepted types in `Part.data`.
//
// A `Part` must have a fixed IANA MIME type identifying the type and subtype
// of the media if `inline_data` or `file_data` field is filled with raw bytes.
type Part struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Types that are assignable to Data:
	//
	//	*Part_Text
	//	*Part_InlineData
	//	*Part_FileData
	//	*Part_FunctionCall
	//	*Part_FunctionResponse
	Data isPart_Data `protobuf_oneof:"data"`
	// Types that are assignable to Metadata:
	//
	//	*Part_VideoMetadata
	Metadata isPart_Metadata `protobuf_oneof:"metadata"`
}

func (x *Part) Reset() {
	*x = Part{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Part) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Part) ProtoMessage() {}

func (x *Part) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Part.ProtoReflect.Descriptor instead.
func (*Part) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{1}
}

func (m *Part) GetData() isPart_Data {
	if m != nil {
		return m.Data
	}
	return nil
}

func (x *Part) GetText() string {
	if x, ok := x.GetData().(*Part_Text); ok {
		return x.Text
	}
	return ""
}

func (x *Part) GetInlineData() *Blob {
	if x, ok := x.GetData().(*Part_InlineData); ok {
		return x.InlineData
	}
	return nil
}

func (x *Part) GetFileData() *FileData {
	if x, ok := x.GetData().(*Part_FileData); ok {
		return x.FileData
	}
	return nil
}

func (x *Part) GetFunctionCall() *FunctionCall {
	if x, ok := x.GetData().(*Part_FunctionCall); ok {
		return x.FunctionCall
	}
	return nil
}

func (x *Part) GetFunctionResponse() *FunctionResponse {
	if x, ok := x.GetData().(*Part_FunctionResponse); ok {
		return x.FunctionResponse
	}
	return nil
}

func (m *Part) GetMetadata() isPart_Metadata {
	if m != nil {
		return m.Metadata
	}
	return nil
}

func (x *Part) GetVideoMetadata() *VideoMetadata {
	if x, ok := x.GetMetadata().(*Part_VideoMetadata); ok {
		return x.VideoMetadata
	}
	return nil
}

type isPart_Data interface {
	isPart_Data()
}

type Part_Text struct {
	// Optional. Text part (can be code).
	Text string `protobuf:"bytes,1,opt,name=text,proto3,oneof"`
}

type Part_InlineData struct {
	// Optional. Inlined bytes data.
	InlineData *Blob `protobuf:"bytes,2,opt,name=inline_data,json=inlineData,proto3,oneof"`
}

type Part_FileData struct {
	// Optional. URI based data.
	FileData *FileData `protobuf:"bytes,3,opt,name=file_data,json=fileData,proto3,oneof"`
}

type Part_FunctionCall struct {
	// Optional. A predicted [FunctionCall] returned from the model that
	// contains a string representing the [FunctionDeclaration.name] with the
	// parameters and their values.
	FunctionCall *FunctionCall `protobuf:"bytes,5,opt,name=function_call,json=functionCall,proto3,oneof"`
}

type Part_FunctionResponse struct {
	// Optional. The result output of a [FunctionCall] that contains a string
	// representing the [FunctionDeclaration.name] and a structured JSON object
	// containing any output from the function call. It is used as context to
	// the model.
	FunctionResponse *FunctionResponse `protobuf:"bytes,6,opt,name=function_response,json=functionResponse,proto3,oneof"`
}

func (*Part_Text) isPart_Data() {}

func (*Part_InlineData) isPart_Data() {}

func (*Part_FileData) isPart_Data() {}

func (*Part_FunctionCall) isPart_Data() {}

func (*Part_FunctionResponse) isPart_Data() {}

type isPart_Metadata interface {
	isPart_Metadata()
}

type Part_VideoMetadata struct {
	// Optional. Video metadata. The metadata should only be specified while the
	// video data is presented in inline_data or file_data.
	VideoMetadata *VideoMetadata `protobuf:"bytes,4,opt,name=video_metadata,json=videoMetadata,proto3,oneof"`
}

func (*Part_VideoMetadata) isPart_Metadata() {}

// Raw media bytes.
//
// Text should not be sent as raw bytes, use the 'text' field.
type Blob struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The IANA standard MIME type of the source data.
	MimeType string `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Required. Raw bytes for media formats.
	Data []byte `protobuf:"bytes,2,opt,name=data,proto3" json:"data,omitempty"`
}

func (x *Blob) Reset() {
	*x = Blob{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Blob) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Blob) ProtoMessage() {}

func (x *Blob) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Blob.ProtoReflect.Descriptor instead.
func (*Blob) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{2}
}

func (x *Blob) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *Blob) GetData() []byte {
	if x != nil {
		return x.Data
	}
	return nil
}

// URI based data.
type FileData struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The IANA standard MIME type of the source data.
	MimeType string `protobuf:"bytes,1,opt,name=mime_type,json=mimeType,proto3" json:"mime_type,omitempty"`
	// Required. URI.
	FileUri string `protobuf:"bytes,2,opt,name=file_uri,json=fileUri,proto3" json:"file_uri,omitempty"`
}

func (x *FileData) Reset() {
	*x = FileData{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *FileData) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*FileData) ProtoMessage() {}

func (x *FileData) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use FileData.ProtoReflect.Descriptor instead.
func (*FileData) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{3}
}

func (x *FileData) GetMimeType() string {
	if x != nil {
		return x.MimeType
	}
	return ""
}

func (x *FileData) GetFileUri() string {
	if x != nil {
		return x.FileUri
	}
	return ""
}

// Metadata describes the input video content.
type VideoMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. The start offset of the video.
	StartOffset *durationpb.Duration `protobuf:"bytes,1,opt,name=start_offset,json=startOffset,proto3" json:"start_offset,omitempty"`
	// Optional. The end offset of the video.
	EndOffset *durationpb.Duration `protobuf:"bytes,2,opt,name=end_offset,json=endOffset,proto3" json:"end_offset,omitempty"`
}

func (x *VideoMetadata) Reset() {
	*x = VideoMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VideoMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VideoMetadata) ProtoMessage() {}

func (x *VideoMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VideoMetadata.ProtoReflect.Descriptor instead.
func (*VideoMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{4}
}

func (x *VideoMetadata) GetStartOffset() *durationpb.Duration {
	if x != nil {
		return x.StartOffset
	}
	return nil
}

func (x *VideoMetadata) GetEndOffset() *durationpb.Duration {
	if x != nil {
		return x.EndOffset
	}
	return nil
}

// Generation config.
type GenerationConfig struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Optional. Controls the randomness of predictions.
	Temperature *float32 `protobuf:"fixed32,1,opt,name=temperature,proto3,oneof" json:"temperature,omitempty"`
	// Optional. If specified, nucleus sampling will be used.
	TopP *float32 `protobuf:"fixed32,2,opt,name=top_p,json=topP,proto3,oneof" json:"top_p,omitempty"`
	// Optional. If specified, top-k sampling will be used.
	TopK *float32 `protobuf:"fixed32,3,opt,name=top_k,json=topK,proto3,oneof" json:"top_k,omitempty"`
	// Optional. Number of candidates to generate.
	CandidateCount *int32 `protobuf:"varint,4,opt,name=candidate_count,json=candidateCount,proto3,oneof" json:"candidate_count,omitempty"`
	// Optional. The maximum number of output tokens to generate per message.
	MaxOutputTokens *int32 `protobuf:"varint,5,opt,name=max_output_tokens,json=maxOutputTokens,proto3,oneof" json:"max_output_tokens,omitempty"`
	// Optional. Stop sequences.
	StopSequences []string `protobuf:"bytes,6,rep,name=stop_sequences,json=stopSequences,proto3" json:"stop_sequences,omitempty"`
}

func (x *GenerationConfig) Reset() {
	*x = GenerationConfig{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GenerationConfig) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GenerationConfig) ProtoMessage() {}

func (x *GenerationConfig) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GenerationConfig.ProtoReflect.Descriptor instead.
func (*GenerationConfig) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{5}
}

func (x *GenerationConfig) GetTemperature() float32 {
	if x != nil && x.Temperature != nil {
		return *x.Temperature
	}
	return 0
}

func (x *GenerationConfig) GetTopP() float32 {
	if x != nil && x.TopP != nil {
		return *x.TopP
	}
	return 0
}

func (x *GenerationConfig) GetTopK() float32 {
	if x != nil && x.TopK != nil {
		return *x.TopK
	}
	return 0
}

func (x *GenerationConfig) GetCandidateCount() int32 {
	if x != nil && x.CandidateCount != nil {
		return *x.CandidateCount
	}
	return 0
}

func (x *GenerationConfig) GetMaxOutputTokens() int32 {
	if x != nil && x.MaxOutputTokens != nil {
		return *x.MaxOutputTokens
	}
	return 0
}

func (x *GenerationConfig) GetStopSequences() []string {
	if x != nil {
		return x.StopSequences
	}
	return nil
}

// Safety settings.
type SafetySetting struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. Harm category.
	Category HarmCategory `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.aiplatform.v1beta1.HarmCategory" json:"category,omitempty"`
	// Required. The harm block threshold.
	Threshold SafetySetting_HarmBlockThreshold `protobuf:"varint,2,opt,name=threshold,proto3,enum=google.cloud.aiplatform.v1beta1.SafetySetting_HarmBlockThreshold" json:"threshold,omitempty"`
}

func (x *SafetySetting) Reset() {
	*x = SafetySetting{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SafetySetting) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetySetting) ProtoMessage() {}

func (x *SafetySetting) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetySetting.ProtoReflect.Descriptor instead.
func (*SafetySetting) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{6}
}

func (x *SafetySetting) GetCategory() HarmCategory {
	if x != nil {
		return x.Category
	}
	return HarmCategory_HARM_CATEGORY_UNSPECIFIED
}

func (x *SafetySetting) GetThreshold() SafetySetting_HarmBlockThreshold {
	if x != nil {
		return x.Threshold
	}
	return SafetySetting_HARM_BLOCK_THRESHOLD_UNSPECIFIED
}

// Safety rating corresponding to the generated content.
type SafetyRating struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Harm category.
	Category HarmCategory `protobuf:"varint,1,opt,name=category,proto3,enum=google.cloud.aiplatform.v1beta1.HarmCategory" json:"category,omitempty"`
	// Output only. Harm probability levels in the content.
	Probability SafetyRating_HarmProbability `protobuf:"varint,2,opt,name=probability,proto3,enum=google.cloud.aiplatform.v1beta1.SafetyRating_HarmProbability" json:"probability,omitempty"`
	// Output only. Indicates whether the content was filtered out because of this
	// rating.
	Blocked bool `protobuf:"varint,3,opt,name=blocked,proto3" json:"blocked,omitempty"`
}

func (x *SafetyRating) Reset() {
	*x = SafetyRating{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SafetyRating) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SafetyRating) ProtoMessage() {}

func (x *SafetyRating) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SafetyRating.ProtoReflect.Descriptor instead.
func (*SafetyRating) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{7}
}

func (x *SafetyRating) GetCategory() HarmCategory {
	if x != nil {
		return x.Category
	}
	return HarmCategory_HARM_CATEGORY_UNSPECIFIED
}

func (x *SafetyRating) GetProbability() SafetyRating_HarmProbability {
	if x != nil {
		return x.Probability
	}
	return SafetyRating_HARM_PROBABILITY_UNSPECIFIED
}

func (x *SafetyRating) GetBlocked() bool {
	if x != nil {
		return x.Blocked
	}
	return false
}

// A collection of source attributions for a piece of content.
type CitationMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. List of citations.
	Citations []*Citation `protobuf:"bytes,1,rep,name=citations,proto3" json:"citations,omitempty"`
}

func (x *CitationMetadata) Reset() {
	*x = CitationMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CitationMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CitationMetadata) ProtoMessage() {}

func (x *CitationMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CitationMetadata.ProtoReflect.Descriptor instead.
func (*CitationMetadata) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{8}
}

func (x *CitationMetadata) GetCitations() []*Citation {
	if x != nil {
		return x.Citations
	}
	return nil
}

// Source attributions for content.
type Citation struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Start index into the content.
	StartIndex int32 `protobuf:"varint,1,opt,name=start_index,json=startIndex,proto3" json:"start_index,omitempty"`
	// Output only. End index into the content.
	EndIndex int32 `protobuf:"varint,2,opt,name=end_index,json=endIndex,proto3" json:"end_index,omitempty"`
	// Output only. Url reference of the attribution.
	Uri string `protobuf:"bytes,3,opt,name=uri,proto3" json:"uri,omitempty"`
	// Output only. Title of the attribution.
	Title string `protobuf:"bytes,4,opt,name=title,proto3" json:"title,omitempty"`
	// Output only. License of the attribution.
	License string `protobuf:"bytes,5,opt,name=license,proto3" json:"license,omitempty"`
	// Output only. Publication date of the attribution.
	PublicationDate *date.Date `protobuf:"bytes,6,opt,name=publication_date,json=publicationDate,proto3" json:"publication_date,omitempty"`
}

func (x *Citation) Reset() {
	*x = Citation{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Citation) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Citation) ProtoMessage() {}

func (x *Citation) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Citation.ProtoReflect.Descriptor instead.
func (*Citation) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{9}
}

func (x *Citation) GetStartIndex() int32 {
	if x != nil {
		return x.StartIndex
	}
	return 0
}

func (x *Citation) GetEndIndex() int32 {
	if x != nil {
		return x.EndIndex
	}
	return 0
}

func (x *Citation) GetUri() string {
	if x != nil {
		return x.Uri
	}
	return ""
}

func (x *Citation) GetTitle() string {
	if x != nil {
		return x.Title
	}
	return ""
}

func (x *Citation) GetLicense() string {
	if x != nil {
		return x.License
	}
	return ""
}

func (x *Citation) GetPublicationDate() *date.Date {
	if x != nil {
		return x.PublicationDate
	}
	return nil
}

// A response candidate generated from the model.
type Candidate struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Output only. Index of the candidate.
	Index int32 `protobuf:"varint,1,opt,name=index,proto3" json:"index,omitempty"`
	// Output only. Content parts of the candidate.
	Content *Content `protobuf:"bytes,2,opt,name=content,proto3" json:"content,omitempty"`
	// Output only. The reason why the model stopped generating tokens.
	// If empty, the model has not stopped generating the tokens.
	FinishReason Candidate_FinishReason `protobuf:"varint,3,opt,name=finish_reason,json=finishReason,proto3,enum=google.cloud.aiplatform.v1beta1.Candidate_FinishReason" json:"finish_reason,omitempty"`
	// Output only. List of ratings for the safety of a response candidate.
	//
	// There is at most one rating per category.
	SafetyRatings []*SafetyRating `protobuf:"bytes,4,rep,name=safety_ratings,json=safetyRatings,proto3" json:"safety_ratings,omitempty"`
	// Output only. Describes the reason the mode stopped generating tokens in
	// more detail. This is only filled when `finish_reason` is set.
	FinishMessage *string `protobuf:"bytes,5,opt,name=finish_message,json=finishMessage,proto3,oneof" json:"finish_message,omitempty"`
	// Output only. Source attribution of the generated content.
	CitationMetadata *CitationMetadata `protobuf:"bytes,6,opt,name=citation_metadata,json=citationMetadata,proto3" json:"citation_metadata,omitempty"`
}

func (x *Candidate) Reset() {
	*x = Candidate{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Candidate) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Candidate) ProtoMessage() {}

func (x *Candidate) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Candidate.ProtoReflect.Descriptor instead.
func (*Candidate) Descriptor() ([]byte, []int) {
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP(), []int{10}
}

func (x *Candidate) GetIndex() int32 {
	if x != nil {
		return x.Index
	}
	return 0
}

func (x *Candidate) GetContent() *Content {
	if x != nil {
		return x.Content
	}
	return nil
}

func (x *Candidate) GetFinishReason() Candidate_FinishReason {
	if x != nil {
		return x.FinishReason
	}
	return Candidate_FINISH_REASON_UNSPECIFIED
}

func (x *Candidate) GetSafetyRatings() []*SafetyRating {
	if x != nil {
		return x.SafetyRatings
	}
	return nil
}

func (x *Candidate) GetFinishMessage() string {
	if x != nil && x.FinishMessage != nil {
		return *x.FinishMessage
	}
	return ""
}

func (x *Candidate) GetCitationMetadata() *CitationMetadata {
	if x != nil {
		return x.CitationMetadata
	}
	return nil
}

var File_google_cloud_aiplatform_v1beta1_content_proto protoreflect.FileDescriptor

var file_google_cloud_aiplatform_v1beta1_content_proto_rawDesc = []byte{
	0x0a, 0x2d, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x61,
	0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61,
	0x31, 0x2f, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x12,
	0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69,
	0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31,
	0x1a, 0x1f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65,
	0x6c, 0x64, 0x5f, 0x62, 0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x1a, 0x2a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x76, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x2f, 0x74, 0x6f, 0x6f, 0x6c, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x64,
	0x75, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x16, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x74, 0x79, 0x70, 0x65, 0x2f, 0x64, 0x61, 0x74, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0x64, 0x0a, 0x07, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x12, 0x17, 0x0a, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x52, 0x04, 0x72, 0x6f, 0x6c, 0x65, 0x12, 0x40, 0x0a, 0x05, 0x70, 0x61, 0x72,
	0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x50, 0x61, 0x72, 0x74, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x70, 0x61, 0x72, 0x74, 0x73, 0x22, 0xf3, 0x03, 0x0a, 0x04,
	0x50, 0x61, 0x72, 0x74, 0x12, 0x19, 0x0a, 0x04, 0x74, 0x65, 0x78, 0x74, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x04, 0x74, 0x65, 0x78, 0x74, 0x12,
	0x4d, 0x0a, 0x0b, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x42, 0x6c, 0x6f, 0x62, 0x42, 0x03, 0xe0, 0x41, 0x01,
	0x48, 0x00, 0x52, 0x0a, 0x69, 0x6e, 0x6c, 0x69, 0x6e, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x4d,
	0x0a, 0x09, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x64, 0x61, 0x74, 0x61, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65,
	0x74, 0x61, 0x31, 0x2e, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41,
	0x01, 0x48, 0x00, 0x52, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61, 0x12, 0x59, 0x0a,
	0x0d, 0x66, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76,
	0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x43,
	0x61, 0x6c, 0x6c, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0c, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x43, 0x61, 0x6c, 0x6c, 0x12, 0x65, 0x0a, 0x11, 0x66, 0x75, 0x6e, 0x63,
	0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x72, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31,
	0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x46, 0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65,
	0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x10, 0x66,
	0x75, 0x6e, 0x63, 0x74, 0x69, 0x6f, 0x6e, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12,
	0x5c, 0x0a, 0x0e, 0x76, 0x69, 0x64, 0x65, 0x6f, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x2e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72,
	0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x0d,
	0x76, 0x69, 0x64, 0x65, 0x6f, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x06, 0x0a,
	0x04, 0x64, 0x61, 0x74, 0x61, 0x42, 0x0a, 0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74,
	0x61, 0x22, 0x41, 0x0a, 0x04, 0x42, 0x6c, 0x6f, 0x62, 0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d,
	0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41,
	0x02, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79, 0x70, 0x65, 0x12, 0x17, 0x0a, 0x04, 0x64,
	0x61, 0x74, 0x61, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0c, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x04,
	0x64, 0x61, 0x74, 0x61, 0x22, 0x4c, 0x0a, 0x08, 0x46, 0x69, 0x6c, 0x65, 0x44, 0x61, 0x74, 0x61,
	0x12, 0x20, 0x0a, 0x09, 0x6d, 0x69, 0x6d, 0x65, 0x5f, 0x74, 0x79, 0x70, 0x65, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x6d, 0x69, 0x6d, 0x65, 0x54, 0x79,
	0x70, 0x65, 0x12, 0x1e, 0x0a, 0x08, 0x66, 0x69, 0x6c, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x18, 0x02,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x07, 0x66, 0x69, 0x6c, 0x65, 0x55,
	0x72, 0x69, 0x22, 0x91, 0x01, 0x0a, 0x0d, 0x56, 0x69, 0x64, 0x65, 0x6f, 0x4d, 0x65, 0x74, 0x61,
	0x64, 0x61, 0x74, 0x61, 0x12, 0x41, 0x0a, 0x0c, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x6f, 0x66,
	0x66, 0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0b, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x12, 0x3d, 0x0a, 0x0a, 0x65, 0x6e, 0x64, 0x5f, 0x6f,
	0x66, 0x66, 0x73, 0x65, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x19, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x44, 0x75,
	0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x09, 0x65, 0x6e, 0x64,
	0x4f, 0x66, 0x66, 0x73, 0x65, 0x74, 0x22, 0xdf, 0x02, 0x0a, 0x10, 0x47, 0x65, 0x6e, 0x65, 0x72,
	0x61, 0x74, 0x69, 0x6f, 0x6e, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x2a, 0x0a, 0x0b, 0x74,
	0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x02,
	0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x00, 0x52, 0x0b, 0x74, 0x65, 0x6d, 0x70, 0x65, 0x72, 0x61,
	0x74, 0x75, 0x72, 0x65, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x70,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x01, 0x52, 0x04, 0x74,
	0x6f, 0x70, 0x50, 0x88, 0x01, 0x01, 0x12, 0x1d, 0x0a, 0x05, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x02, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x02, 0x52, 0x04, 0x74, 0x6f,
	0x70, 0x4b, 0x88, 0x01, 0x01, 0x12, 0x31, 0x0a, 0x0f, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61,
	0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75, 0x6e, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03,
	0xe0, 0x41, 0x01, 0x48, 0x03, 0x52, 0x0e, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65,
	0x43, 0x6f, 0x75, 0x6e, 0x74, 0x88, 0x01, 0x01, 0x12, 0x34, 0x0a, 0x11, 0x6d, 0x61, 0x78, 0x5f,
	0x6f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x18, 0x05, 0x20,
	0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x48, 0x04, 0x52, 0x0f, 0x6d, 0x61, 0x78, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x88, 0x01, 0x01, 0x12, 0x2a,
	0x0a, 0x0e, 0x73, 0x74, 0x6f, 0x70, 0x5f, 0x73, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x01, 0x52, 0x0d, 0x73, 0x74, 0x6f,
	0x70, 0x53, 0x65, 0x71, 0x75, 0x65, 0x6e, 0x63, 0x65, 0x73, 0x42, 0x0e, 0x0a, 0x0c, 0x5f, 0x74,
	0x65, 0x6d, 0x70, 0x65, 0x72, 0x61, 0x74, 0x75, 0x72, 0x65, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74,
	0x6f, 0x70, 0x5f, 0x70, 0x42, 0x08, 0x0a, 0x06, 0x5f, 0x74, 0x6f, 0x70, 0x5f, 0x6b, 0x42, 0x12,
	0x0a, 0x10, 0x5f, 0x63, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x63, 0x6f, 0x75,
	0x6e, 0x74, 0x42, 0x14, 0x0a, 0x12, 0x5f, 0x6d, 0x61, 0x78, 0x5f, 0x6f, 0x75, 0x74, 0x70, 0x75,
	0x74, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x73, 0x22, 0xdc, 0x02, 0x0a, 0x0d, 0x53, 0x61, 0x66,
	0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x4e, 0x0a, 0x08, 0x63, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c,
	0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48,
	0x61, 0x72, 0x6d, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x02,
	0x52, 0x08, 0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x64, 0x0a, 0x09, 0x74, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x41, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x53, 0x65, 0x74, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x48, 0x61,
	0x72, 0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x09, 0x74, 0x68, 0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64,
	0x22, 0x94, 0x01, 0x0a, 0x12, 0x48, 0x61, 0x72, 0x6d, 0x42, 0x6c, 0x6f, 0x63, 0x6b, 0x54, 0x68,
	0x72, 0x65, 0x73, 0x68, 0x6f, 0x6c, 0x64, 0x12, 0x24, 0x0a, 0x20, 0x48, 0x41, 0x52, 0x4d, 0x5f,
	0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x54, 0x48, 0x52, 0x45, 0x53, 0x48, 0x4f, 0x4c, 0x44, 0x5f,
	0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x17, 0x0a,
	0x13, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4c, 0x4f, 0x57, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41,
	0x42, 0x4f, 0x56, 0x45, 0x10, 0x01, 0x12, 0x1a, 0x0a, 0x16, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f,
	0x4d, 0x45, 0x44, 0x49, 0x55, 0x4d, 0x5f, 0x41, 0x4e, 0x44, 0x5f, 0x41, 0x42, 0x4f, 0x56, 0x45,
	0x10, 0x02, 0x12, 0x13, 0x0a, 0x0f, 0x42, 0x4c, 0x4f, 0x43, 0x4b, 0x5f, 0x4f, 0x4e, 0x4c, 0x59,
	0x5f, 0x48, 0x49, 0x47, 0x48, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x42, 0x4c, 0x4f, 0x43, 0x4b,
	0x5f, 0x4e, 0x4f, 0x4e, 0x45, 0x10, 0x04, 0x22, 0xc7, 0x02, 0x0a, 0x0c, 0x53, 0x61, 0x66, 0x65,
	0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x12, 0x4e, 0x0a, 0x08, 0x63, 0x61, 0x74, 0x65,
	0x67, 0x6f, 0x72, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x48, 0x61, 0x72,
	0x6d, 0x43, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x63, 0x61, 0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x64, 0x0a, 0x0b, 0x70, 0x72, 0x6f, 0x62,
	0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x3d, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e,
	0x53, 0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x2e, 0x48, 0x61, 0x72,
	0x6d, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x42, 0x03, 0xe0, 0x41,
	0x03, 0x52, 0x0b, 0x70, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x1d,
	0x0a, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x42,
	0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x62, 0x6c, 0x6f, 0x63, 0x6b, 0x65, 0x64, 0x22, 0x62, 0x0a,
	0x0f, 0x48, 0x61, 0x72, 0x6d, 0x50, 0x72, 0x6f, 0x62, 0x61, 0x62, 0x69, 0x6c, 0x69, 0x74, 0x79,
	0x12, 0x20, 0x0a, 0x1c, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x50, 0x52, 0x4f, 0x42, 0x41, 0x42, 0x49,
	0x4c, 0x49, 0x54, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x4e, 0x45, 0x47, 0x4c, 0x49, 0x47, 0x49, 0x42, 0x4c, 0x45,
	0x10, 0x01, 0x12, 0x07, 0x0a, 0x03, 0x4c, 0x4f, 0x57, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x4d,
	0x45, 0x44, 0x49, 0x55, 0x4d, 0x10, 0x03, 0x12, 0x08, 0x0a, 0x04, 0x48, 0x49, 0x47, 0x48, 0x10,
	0x04, 0x22, 0x60, 0x0a, 0x10, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74,
	0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x4c, 0x0a, 0x09, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x69, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x09, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x73, 0x22, 0xe6, 0x01, 0x0a, 0x08, 0x43, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e,
	0x12, 0x24, 0x0a, 0x0b, 0x73, 0x74, 0x61, 0x72, 0x74, 0x5f, 0x69, 0x6e, 0x64, 0x65, 0x78, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0a, 0x73, 0x74, 0x61, 0x72,
	0x74, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x20, 0x0a, 0x09, 0x65, 0x6e, 0x64, 0x5f, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x08,
	0x65, 0x6e, 0x64, 0x49, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x15, 0x0a, 0x03, 0x75, 0x72, 0x69, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x03, 0x75, 0x72, 0x69, 0x12,
	0x19, 0x0a, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x05, 0x74, 0x69, 0x74, 0x6c, 0x65, 0x12, 0x1d, 0x0a, 0x07, 0x6c, 0x69,
	0x63, 0x65, 0x6e, 0x73, 0x65, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x07, 0x6c, 0x69, 0x63, 0x65, 0x6e, 0x73, 0x65, 0x12, 0x41, 0x0a, 0x10, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x64, 0x61, 0x74, 0x65, 0x18, 0x06, 0x20,
	0x01, 0x28, 0x0b, 0x32, 0x11, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x74, 0x79, 0x70,
	0x65, 0x2e, 0x44, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0f, 0x70, 0x75, 0x62,
	0x6c, 0x69, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x44, 0x61, 0x74, 0x65, 0x22, 0xc6, 0x04, 0x0a,
	0x09, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74, 0x65, 0x12, 0x19, 0x0a, 0x05, 0x69, 0x6e,
	0x64, 0x65, 0x78, 0x18, 0x01, 0x20, 0x01, 0x28, 0x05, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x05,
	0x69, 0x6e, 0x64, 0x65, 0x78, 0x12, 0x47, 0x0a, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d,
	0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74,
	0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x07, 0x63, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x12, 0x61,
	0x0a, 0x0d, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x72, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x18,
	0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63,
	0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e,
	0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x61, 0x6e, 0x64, 0x69, 0x64, 0x61, 0x74,
	0x65, 0x2e, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x52, 0x65, 0x61, 0x73, 0x6f, 0x6e, 0x42, 0x03,
	0xe0, 0x41, 0x03, 0x52, 0x0c, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x52, 0x65, 0x61, 0x73, 0x6f,
	0x6e, 0x12, 0x59, 0x0a, 0x0e, 0x73, 0x61, 0x66, 0x65, 0x74, 0x79, 0x5f, 0x72, 0x61, 0x74, 0x69,
	0x6e, 0x67, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x53, 0x61, 0x66, 0x65,
	0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x52, 0x0d, 0x73,
	0x61, 0x66, 0x65, 0x74, 0x79, 0x52, 0x61, 0x74, 0x69, 0x6e, 0x67, 0x73, 0x12, 0x2f, 0x0a, 0x0e,
	0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x6d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x09, 0x42, 0x03, 0xe0, 0x41, 0x03, 0x48, 0x00, 0x52, 0x0d, 0x66, 0x69, 0x6e,
	0x69, 0x73, 0x68, 0x4d, 0x65, 0x73, 0x73, 0x61, 0x67, 0x65, 0x88, 0x01, 0x01, 0x12, 0x63, 0x0a,
	0x11, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x5f, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x18, 0x06, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x31, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f,
	0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2e, 0x43, 0x69, 0x74, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x42, 0x03, 0xe0, 0x41, 0x03,
	0x52, 0x10, 0x63, 0x69, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x22, 0x6e, 0x0a, 0x0c, 0x46, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x52, 0x65, 0x61, 0x73,
	0x6f, 0x6e, 0x12, 0x1d, 0x0a, 0x19, 0x46, 0x49, 0x4e, 0x49, 0x53, 0x48, 0x5f, 0x52, 0x45, 0x41,
	0x53, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x08, 0x0a, 0x04, 0x53, 0x54, 0x4f, 0x50, 0x10, 0x01, 0x12, 0x0e, 0x0a, 0x0a, 0x4d,
	0x41, 0x58, 0x5f, 0x54, 0x4f, 0x4b, 0x45, 0x4e, 0x53, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x41, 0x46, 0x45, 0x54, 0x59, 0x10, 0x03, 0x12, 0x0e, 0x0a, 0x0a, 0x52, 0x45, 0x43, 0x49, 0x54,
	0x41, 0x54, 0x49, 0x4f, 0x4e, 0x10, 0x04, 0x12, 0x09, 0x0a, 0x05, 0x4f, 0x54, 0x48, 0x45, 0x52,
	0x10, 0x05, 0x42, 0x11, 0x0a, 0x0f, 0x5f, 0x66, 0x69, 0x6e, 0x69, 0x73, 0x68, 0x5f, 0x6d, 0x65,
	0x73, 0x73, 0x61, 0x67, 0x65, 0x2a, 0xb4, 0x01, 0x0a, 0x0c, 0x48, 0x61, 0x72, 0x6d, 0x43, 0x61,
	0x74, 0x65, 0x67, 0x6f, 0x72, 0x79, 0x12, 0x1d, 0x0a, 0x19, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43,
	0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x1d, 0x0a, 0x19, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43, 0x41,
	0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x48, 0x41, 0x54, 0x45, 0x5f, 0x53, 0x50, 0x45, 0x45,
	0x43, 0x48, 0x10, 0x01, 0x12, 0x23, 0x0a, 0x1f, 0x48, 0x41, 0x52, 0x4d, 0x5f, 0x43, 0x41, 0x54,
	0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x44, 0x41, 0x4e, 0x47, 0x45, 0x52, 0x4f, 0x55, 0x53, 0x5f,
	0x43, 0x4f, 0x4e, 0x54, 0x45, 0x4e, 0x54, 0x10, 0x02, 0x12, 0x1c, 0x0a, 0x18, 0x48, 0x41, 0x52,
	0x4d, 0x5f, 0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x48, 0x41, 0x52, 0x41, 0x53,
	0x53, 0x4d, 0x45, 0x4e, 0x54, 0x10, 0x03, 0x12, 0x23, 0x0a, 0x1f, 0x48, 0x41, 0x52, 0x4d, 0x5f,
	0x43, 0x41, 0x54, 0x45, 0x47, 0x4f, 0x52, 0x59, 0x5f, 0x53, 0x45, 0x58, 0x55, 0x41, 0x4c, 0x4c,
	0x59, 0x5f, 0x45, 0x58, 0x50, 0x4c, 0x49, 0x43, 0x49, 0x54, 0x10, 0x04, 0x42, 0xe3, 0x01, 0x0a,
	0x23, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75,
	0x64, 0x2e, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x2e, 0x76, 0x31, 0x62,
	0x65, 0x74, 0x61, 0x31, 0x42, 0x0c, 0x43, 0x6f, 0x6e, 0x74, 0x65, 0x6e, 0x74, 0x50, 0x72, 0x6f,
	0x74, 0x6f, 0x50, 0x01, 0x5a, 0x43, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f, 0x2f, 0x61, 0x69, 0x70, 0x6c, 0x61, 0x74,
	0x66, 0x6f, 0x72, 0x6d, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0x2f,
	0x61, 0x69, 0x70, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0x3b, 0x61, 0x69, 0x70,
	0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x70, 0x62, 0xaa, 0x02, 0x1f, 0x47, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x41, 0x49, 0x50, 0x6c, 0x61, 0x74, 0x66,
	0x6f, 0x72, 0x6d, 0x2e, 0x56, 0x31, 0x42, 0x65, 0x74, 0x61, 0x31, 0xca, 0x02, 0x1f, 0x47, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x5c, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x5c, 0x41, 0x49, 0x50, 0x6c, 0x61,
	0x74, 0x66, 0x6f, 0x72, 0x6d, 0x5c, 0x56, 0x31, 0x62, 0x65, 0x74, 0x61, 0x31, 0xea, 0x02, 0x22,
	0x47, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x3a, 0x3a, 0x43, 0x6c, 0x6f, 0x75, 0x64, 0x3a, 0x3a, 0x41,
	0x49, 0x50, 0x6c, 0x61, 0x74, 0x66, 0x6f, 0x72, 0x6d, 0x3a, 0x3a, 0x56, 0x31, 0x62, 0x65, 0x74,
	0x61, 0x31, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_aiplatform_v1beta1_content_proto_rawDescOnce sync.Once
	file_google_cloud_aiplatform_v1beta1_content_proto_rawDescData = file_google_cloud_aiplatform_v1beta1_content_proto_rawDesc
)

func file_google_cloud_aiplatform_v1beta1_content_proto_rawDescGZIP() []byte {
	file_google_cloud_aiplatform_v1beta1_content_proto_rawDescOnce.Do(func() {
		file_google_cloud_aiplatform_v1beta1_content_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_aiplatform_v1beta1_content_proto_rawDescData)
	})
	return file_google_cloud_aiplatform_v1beta1_content_proto_rawDescData
}

var file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes = make([]protoimpl.MessageInfo, 11)
var file_google_cloud_aiplatform_v1beta1_content_proto_goTypes = []interface{}{
	(HarmCategory)(0),                     // 0: google.cloud.aiplatform.v1beta1.HarmCategory
	(SafetySetting_HarmBlockThreshold)(0), // 1: google.cloud.aiplatform.v1beta1.SafetySetting.HarmBlockThreshold
	(SafetyRating_HarmProbability)(0),     // 2: google.cloud.aiplatform.v1beta1.SafetyRating.HarmProbability
	(Candidate_FinishReason)(0),           // 3: google.cloud.aiplatform.v1beta1.Candidate.FinishReason
	(*Content)(nil),                       // 4: google.cloud.aiplatform.v1beta1.Content
	(*Part)(nil),                          // 5: google.cloud.aiplatform.v1beta1.Part
	(*Blob)(nil),                          // 6: google.cloud.aiplatform.v1beta1.Blob
	(*FileData)(nil),                      // 7: google.cloud.aiplatform.v1beta1.FileData
	(*VideoMetadata)(nil),                 // 8: google.cloud.aiplatform.v1beta1.VideoMetadata
	(*GenerationConfig)(nil),              // 9: google.cloud.aiplatform.v1beta1.GenerationConfig
	(*SafetySetting)(nil),                 // 10: google.cloud.aiplatform.v1beta1.SafetySetting
	(*SafetyRating)(nil),                  // 11: google.cloud.aiplatform.v1beta1.SafetyRating
	(*CitationMetadata)(nil),              // 12: google.cloud.aiplatform.v1beta1.CitationMetadata
	(*Citation)(nil),                      // 13: google.cloud.aiplatform.v1beta1.Citation
	(*Candidate)(nil),                     // 14: google.cloud.aiplatform.v1beta1.Candidate
	(*FunctionCall)(nil),                  // 15: google.cloud.aiplatform.v1beta1.FunctionCall
	(*FunctionResponse)(nil),              // 16: google.cloud.aiplatform.v1beta1.FunctionResponse
	(*durationpb.Duration)(nil),           // 17: google.protobuf.Duration
	(*date.Date)(nil),                     // 18: google.type.Date
}
var file_google_cloud_aiplatform_v1beta1_content_proto_depIdxs = []int32{
	5,  // 0: google.cloud.aiplatform.v1beta1.Content.parts:type_name -> google.cloud.aiplatform.v1beta1.Part
	6,  // 1: google.cloud.aiplatform.v1beta1.Part.inline_data:type_name -> google.cloud.aiplatform.v1beta1.Blob
	7,  // 2: google.cloud.aiplatform.v1beta1.Part.file_data:type_name -> google.cloud.aiplatform.v1beta1.FileData
	15, // 3: google.cloud.aiplatform.v1beta1.Part.function_call:type_name -> google.cloud.aiplatform.v1beta1.FunctionCall
	16, // 4: google.cloud.aiplatform.v1beta1.Part.function_response:type_name -> google.cloud.aiplatform.v1beta1.FunctionResponse
	8,  // 5: google.cloud.aiplatform.v1beta1.Part.video_metadata:type_name -> google.cloud.aiplatform.v1beta1.VideoMetadata
	17, // 6: google.cloud.aiplatform.v1beta1.VideoMetadata.start_offset:type_name -> google.protobuf.Duration
	17, // 7: google.cloud.aiplatform.v1beta1.VideoMetadata.end_offset:type_name -> google.protobuf.Duration
	0,  // 8: google.cloud.aiplatform.v1beta1.SafetySetting.category:type_name -> google.cloud.aiplatform.v1beta1.HarmCategory
	1,  // 9: google.cloud.aiplatform.v1beta1.SafetySetting.threshold:type_name -> google.cloud.aiplatform.v1beta1.SafetySetting.HarmBlockThreshold
	0,  // 10: google.cloud.aiplatform.v1beta1.SafetyRating.category:type_name -> google.cloud.aiplatform.v1beta1.HarmCategory
	2,  // 11: google.cloud.aiplatform.v1beta1.SafetyRating.probability:type_name -> google.cloud.aiplatform.v1beta1.SafetyRating.HarmProbability
	13, // 12: google.cloud.aiplatform.v1beta1.CitationMetadata.citations:type_name -> google.cloud.aiplatform.v1beta1.Citation
	18, // 13: google.cloud.aiplatform.v1beta1.Citation.publication_date:type_name -> google.type.Date
	4,  // 14: google.cloud.aiplatform.v1beta1.Candidate.content:type_name -> google.cloud.aiplatform.v1beta1.Content
	3,  // 15: google.cloud.aiplatform.v1beta1.Candidate.finish_reason:type_name -> google.cloud.aiplatform.v1beta1.Candidate.FinishReason
	11, // 16: google.cloud.aiplatform.v1beta1.Candidate.safety_ratings:type_name -> google.cloud.aiplatform.v1beta1.SafetyRating
	12, // 17: google.cloud.aiplatform.v1beta1.Candidate.citation_metadata:type_name -> google.cloud.aiplatform.v1beta1.CitationMetadata
	18, // [18:18] is the sub-list for method output_type
	18, // [18:18] is the sub-list for method input_type
	18, // [18:18] is the sub-list for extension type_name
	18, // [18:18] is the sub-list for extension extendee
	0,  // [0:18] is the sub-list for field type_name
}

func init() { file_google_cloud_aiplatform_v1beta1_content_proto_init() }
func file_google_cloud_aiplatform_v1beta1_content_proto_init() {
	if File_google_cloud_aiplatform_v1beta1_content_proto != nil {
		return
	}
	file_google_cloud_aiplatform_v1beta1_tool_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Content); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Part); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Blob); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*FileData); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VideoMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GenerationConfig); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SafetySetting); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SafetyRating); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CitationMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Citation); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Candidate); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[1].OneofWrappers = []interface{}{
		(*Part_Text)(nil),
		(*Part_InlineData)(nil),
		(*Part_FileData)(nil),
		(*Part_FunctionCall)(nil),
		(*Part_FunctionResponse)(nil),
		(*Part_VideoMetadata)(nil),
	}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[5].OneofWrappers = []interface{}{}
	file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes[10].OneofWrappers = []interface{}{}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_aiplatform_v1beta1_content_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   11,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_aiplatform_v1beta1_content_proto_goTypes,
		DependencyIndexes: file_google_cloud_aiplatform_v1beta1_content_proto_depIdxs,
		EnumInfos:         file_google_cloud_aiplatform_v1beta1_content_proto_enumTypes,
		MessageInfos:      file_google_cloud_aiplatform_v1beta1_content_proto_msgTypes,
	}.Build()
	File_google_cloud_aiplatform_v1beta1_content_proto = out.File
	file_google_cloud_aiplatform_v1beta1_content_proto_rawDesc = nil
	file_google_cloud_aiplatform_v1beta1_content_proto_goTypes = nil
	file_google_cloud_aiplatform_v1beta1_content_proto_depIdxs = nil
}
