// Copyright 2020 Google LLC
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.32.0
// 	protoc        v4.23.2
// source: google/cloud/osconfig/agentendpoint/v1/tasks.proto

package agentendpointpb

import (
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Specifies the current agent behavior.
type TaskDirective int32

const (
	// Unspecified is invalid.
	TaskDirective_TASK_DIRECTIVE_UNSPECIFIED TaskDirective = 0
	// The task should continue to progress.
	TaskDirective_CONTINUE TaskDirective = 1
	// Task should not be started, or if already in progress, should stop
	// at first safe stopping point.  Task should be considered done and will
	// never repeat.
	TaskDirective_STOP TaskDirective = 2
)

// Enum value maps for TaskDirective.
var (
	TaskDirective_name = map[int32]string{
		0: "TASK_DIRECTIVE_UNSPECIFIED",
		1: "CONTINUE",
		2: "STOP",
	}
	TaskDirective_value = map[string]int32{
		"TASK_DIRECTIVE_UNSPECIFIED": 0,
		"CONTINUE":                   1,
		"STOP":                       2,
	}
)

func (x TaskDirective) Enum() *TaskDirective {
	p := new(TaskDirective)
	*p = x
	return p
}

func (x TaskDirective) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskDirective) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[0].Descriptor()
}

func (TaskDirective) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[0]
}

func (x TaskDirective) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskDirective.Descriptor instead.
func (TaskDirective) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{0}
}

// Specifies the type of task to perform.
type TaskType int32

const (
	// Unspecified is invalid.
	TaskType_TASK_TYPE_UNSPECIFIED TaskType = 0
	// The apply patches task.
	TaskType_APPLY_PATCHES TaskType = 1
	// The exec step task.
	TaskType_EXEC_STEP_TASK TaskType = 2
	// The apply config task
	TaskType_APPLY_CONFIG_TASK TaskType = 3
)

// Enum value maps for TaskType.
var (
	TaskType_name = map[int32]string{
		0: "TASK_TYPE_UNSPECIFIED",
		1: "APPLY_PATCHES",
		2: "EXEC_STEP_TASK",
		3: "APPLY_CONFIG_TASK",
	}
	TaskType_value = map[string]int32{
		"TASK_TYPE_UNSPECIFIED": 0,
		"APPLY_PATCHES":         1,
		"EXEC_STEP_TASK":        2,
		"APPLY_CONFIG_TASK":     3,
	}
)

func (x TaskType) Enum() *TaskType {
	p := new(TaskType)
	*p = x
	return p
}

func (x TaskType) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (TaskType) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[1].Descriptor()
}

func (TaskType) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[1]
}

func (x TaskType) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use TaskType.Descriptor instead.
func (TaskType) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{1}
}

// The intermediate states of applying patches.
type ApplyPatchesTaskProgress_State int32

const (
	// Unspecified is invalid.
	ApplyPatchesTaskProgress_STATE_UNSPECIFIED ApplyPatchesTaskProgress_State = 0
	// The agent has started the patch task.
	ApplyPatchesTaskProgress_STARTED ApplyPatchesTaskProgress_State = 4
	// The agent is currently downloading patches.
	ApplyPatchesTaskProgress_DOWNLOADING_PATCHES ApplyPatchesTaskProgress_State = 1
	// The agent is currently applying patches.
	ApplyPatchesTaskProgress_APPLYING_PATCHES ApplyPatchesTaskProgress_State = 2
	// The agent is currently rebooting the instance.
	ApplyPatchesTaskProgress_REBOOTING ApplyPatchesTaskProgress_State = 3
)

// Enum value maps for ApplyPatchesTaskProgress_State.
var (
	ApplyPatchesTaskProgress_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		4: "STARTED",
		1: "DOWNLOADING_PATCHES",
		2: "APPLYING_PATCHES",
		3: "REBOOTING",
	}
	ApplyPatchesTaskProgress_State_value = map[string]int32{
		"STATE_UNSPECIFIED":   0,
		"STARTED":             4,
		"DOWNLOADING_PATCHES": 1,
		"APPLYING_PATCHES":    2,
		"REBOOTING":           3,
	}
)

func (x ApplyPatchesTaskProgress_State) Enum() *ApplyPatchesTaskProgress_State {
	p := new(ApplyPatchesTaskProgress_State)
	*p = x
	return p
}

func (x ApplyPatchesTaskProgress_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApplyPatchesTaskProgress_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[2].Descriptor()
}

func (ApplyPatchesTaskProgress_State) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[2]
}

func (x ApplyPatchesTaskProgress_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApplyPatchesTaskProgress_State.Descriptor instead.
func (ApplyPatchesTaskProgress_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{2, 0}
}

// The final states of applying patches.
type ApplyPatchesTaskOutput_State int32

const (
	// Unspecified is invalid.
	ApplyPatchesTaskOutput_STATE_UNSPECIFIED ApplyPatchesTaskOutput_State = 0
	// Applying patches completed successfully.
	ApplyPatchesTaskOutput_SUCCEEDED ApplyPatchesTaskOutput_State = 1
	// Applying patches completed successfully, but a reboot is required.
	ApplyPatchesTaskOutput_SUCCEEDED_REBOOT_REQUIRED ApplyPatchesTaskOutput_State = 2
	// Applying patches failed.
	ApplyPatchesTaskOutput_FAILED ApplyPatchesTaskOutput_State = 3
)

// Enum value maps for ApplyPatchesTaskOutput_State.
var (
	ApplyPatchesTaskOutput_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "SUCCEEDED_REBOOT_REQUIRED",
		3: "FAILED",
	}
	ApplyPatchesTaskOutput_State_value = map[string]int32{
		"STATE_UNSPECIFIED":         0,
		"SUCCEEDED":                 1,
		"SUCCEEDED_REBOOT_REQUIRED": 2,
		"FAILED":                    3,
	}
)

func (x ApplyPatchesTaskOutput_State) Enum() *ApplyPatchesTaskOutput_State {
	p := new(ApplyPatchesTaskOutput_State)
	*p = x
	return p
}

func (x ApplyPatchesTaskOutput_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApplyPatchesTaskOutput_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[3].Descriptor()
}

func (ApplyPatchesTaskOutput_State) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[3]
}

func (x ApplyPatchesTaskOutput_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApplyPatchesTaskOutput_State.Descriptor instead.
func (ApplyPatchesTaskOutput_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{3, 0}
}

// The intermediate states of exec steps.
type ExecStepTaskProgress_State int32

const (
	// Unspecified is invalid.
	ExecStepTaskProgress_STATE_UNSPECIFIED ExecStepTaskProgress_State = 0
	// The agent has started the exec step task.
	ExecStepTaskProgress_STARTED ExecStepTaskProgress_State = 1
)

// Enum value maps for ExecStepTaskProgress_State.
var (
	ExecStepTaskProgress_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTED",
	}
	ExecStepTaskProgress_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTED":           1,
	}
)

func (x ExecStepTaskProgress_State) Enum() *ExecStepTaskProgress_State {
	p := new(ExecStepTaskProgress_State)
	*p = x
	return p
}

func (x ExecStepTaskProgress_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecStepTaskProgress_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[4].Descriptor()
}

func (ExecStepTaskProgress_State) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[4]
}

func (x ExecStepTaskProgress_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecStepTaskProgress_State.Descriptor instead.
func (ExecStepTaskProgress_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{5, 0}
}

// The final states of exec steps.
type ExecStepTaskOutput_State int32

const (
	// Unspecified is invalid.
	ExecStepTaskOutput_STATE_UNSPECIFIED ExecStepTaskOutput_State = 0
	// The exec step completed normally.
	ExecStepTaskOutput_COMPLETED ExecStepTaskOutput_State = 1
	// The exec step was terminated because it took too long.
	ExecStepTaskOutput_TIMED_OUT ExecStepTaskOutput_State = 2
	// The exec step task was cancelled before it started.
	ExecStepTaskOutput_CANCELLED ExecStepTaskOutput_State = 3
)

// Enum value maps for ExecStepTaskOutput_State.
var (
	ExecStepTaskOutput_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "COMPLETED",
		2: "TIMED_OUT",
		3: "CANCELLED",
	}
	ExecStepTaskOutput_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"COMPLETED":         1,
		"TIMED_OUT":         2,
		"CANCELLED":         3,
	}
)

func (x ExecStepTaskOutput_State) Enum() *ExecStepTaskOutput_State {
	p := new(ExecStepTaskOutput_State)
	*p = x
	return p
}

func (x ExecStepTaskOutput_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExecStepTaskOutput_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[5].Descriptor()
}

func (ExecStepTaskOutput_State) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[5]
}

func (x ExecStepTaskOutput_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExecStepTaskOutput_State.Descriptor instead.
func (ExecStepTaskOutput_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{6, 0}
}

// The intermediate states of apply config task.
type ApplyConfigTaskProgress_State int32

const (
	// Invalid state
	ApplyConfigTaskProgress_STATE_UNSPECIFIED ApplyConfigTaskProgress_State = 0
	// The agent has started the task.
	ApplyConfigTaskProgress_STARTED ApplyConfigTaskProgress_State = 1
	// The agent is in the process of applying the configuration.
	ApplyConfigTaskProgress_APPLYING_CONFIG ApplyConfigTaskProgress_State = 2
)

// Enum value maps for ApplyConfigTaskProgress_State.
var (
	ApplyConfigTaskProgress_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "STARTED",
		2: "APPLYING_CONFIG",
	}
	ApplyConfigTaskProgress_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"STARTED":           1,
		"APPLYING_CONFIG":   2,
	}
)

func (x ApplyConfigTaskProgress_State) Enum() *ApplyConfigTaskProgress_State {
	p := new(ApplyConfigTaskProgress_State)
	*p = x
	return p
}

func (x ApplyConfigTaskProgress_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApplyConfigTaskProgress_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[6].Descriptor()
}

func (ApplyConfigTaskProgress_State) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[6]
}

func (x ApplyConfigTaskProgress_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApplyConfigTaskProgress_State.Descriptor instead.
func (ApplyConfigTaskProgress_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{8, 0}
}

// The final state of this task.
type ApplyConfigTaskOutput_State int32

const (
	// Unspecified is invalid.
	ApplyConfigTaskOutput_STATE_UNSPECIFIED ApplyConfigTaskOutput_State = 0
	// The apply config task completed successfully.
	ApplyConfigTaskOutput_SUCCEEDED ApplyConfigTaskOutput_State = 1
	// The apply config task failed.
	ApplyConfigTaskOutput_FAILED ApplyConfigTaskOutput_State = 2
	// The apply config task was cancelled.
	ApplyConfigTaskOutput_CANCELLED ApplyConfigTaskOutput_State = 3
)

// Enum value maps for ApplyConfigTaskOutput_State.
var (
	ApplyConfigTaskOutput_State_name = map[int32]string{
		0: "STATE_UNSPECIFIED",
		1: "SUCCEEDED",
		2: "FAILED",
		3: "CANCELLED",
	}
	ApplyConfigTaskOutput_State_value = map[string]int32{
		"STATE_UNSPECIFIED": 0,
		"SUCCEEDED":         1,
		"FAILED":            2,
		"CANCELLED":         3,
	}
)

func (x ApplyConfigTaskOutput_State) Enum() *ApplyConfigTaskOutput_State {
	p := new(ApplyConfigTaskOutput_State)
	*p = x
	return p
}

func (x ApplyConfigTaskOutput_State) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ApplyConfigTaskOutput_State) Descriptor() protoreflect.EnumDescriptor {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[7].Descriptor()
}

func (ApplyConfigTaskOutput_State) Type() protoreflect.EnumType {
	return &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes[7]
}

func (x ApplyConfigTaskOutput_State) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ApplyConfigTaskOutput_State.Descriptor instead.
func (ApplyConfigTaskOutput_State) EnumDescriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{9, 0}
}

// A unit of work to be performed by the agent.
type Task struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Unique task id.
	TaskId string `protobuf:"bytes,1,opt,name=task_id,json=taskId,proto3" json:"task_id,omitempty"`
	// The type of task to perform.
	//
	// Task details must include the appropriate message based on this enum as
	// specified below:
	// APPLY_PATCHES = ApplyPatchesTask
	// EXEC_STEP = ExecStepTask
	// APPLY_CONFIG_TASK = ApplyConfigTask
	TaskType TaskType `protobuf:"varint,2,opt,name=task_type,json=taskType,proto3,enum=google.cloud.osconfig.agentendpoint.v1.TaskType" json:"task_type,omitempty"`
	// Current directive to the agent.
	TaskDirective TaskDirective `protobuf:"varint,3,opt,name=task_directive,json=taskDirective,proto3,enum=google.cloud.osconfig.agentendpoint.v1.TaskDirective" json:"task_directive,omitempty"`
	// Specific details about the current task to perform.
	//
	// Types that are assignable to TaskDetails:
	//
	//	*Task_ApplyPatchesTask
	//	*Task_ExecStepTask
	//	*Task_ApplyConfigTask
	TaskDetails isTask_TaskDetails `protobuf_oneof:"task_details"`
	// Labels describing the task.  Used for logging by the agent.
	ServiceLabels map[string]string `protobuf:"bytes,6,rep,name=service_labels,json=serviceLabels,proto3" json:"service_labels,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *Task) Reset() {
	*x = Task{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Task) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Task) ProtoMessage() {}

func (x *Task) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Task.ProtoReflect.Descriptor instead.
func (*Task) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{0}
}

func (x *Task) GetTaskId() string {
	if x != nil {
		return x.TaskId
	}
	return ""
}

func (x *Task) GetTaskType() TaskType {
	if x != nil {
		return x.TaskType
	}
	return TaskType_TASK_TYPE_UNSPECIFIED
}

func (x *Task) GetTaskDirective() TaskDirective {
	if x != nil {
		return x.TaskDirective
	}
	return TaskDirective_TASK_DIRECTIVE_UNSPECIFIED
}

func (m *Task) GetTaskDetails() isTask_TaskDetails {
	if m != nil {
		return m.TaskDetails
	}
	return nil
}

func (x *Task) GetApplyPatchesTask() *ApplyPatchesTask {
	if x, ok := x.GetTaskDetails().(*Task_ApplyPatchesTask); ok {
		return x.ApplyPatchesTask
	}
	return nil
}

func (x *Task) GetExecStepTask() *ExecStepTask {
	if x, ok := x.GetTaskDetails().(*Task_ExecStepTask); ok {
		return x.ExecStepTask
	}
	return nil
}

func (x *Task) GetApplyConfigTask() *ApplyConfigTask {
	if x, ok := x.GetTaskDetails().(*Task_ApplyConfigTask); ok {
		return x.ApplyConfigTask
	}
	return nil
}

func (x *Task) GetServiceLabels() map[string]string {
	if x != nil {
		return x.ServiceLabels
	}
	return nil
}

type isTask_TaskDetails interface {
	isTask_TaskDetails()
}

type Task_ApplyPatchesTask struct {
	// Details about the apply patches task to perform.
	ApplyPatchesTask *ApplyPatchesTask `protobuf:"bytes,4,opt,name=apply_patches_task,json=applyPatchesTask,proto3,oneof"`
}

type Task_ExecStepTask struct {
	// Details about the exec step task to perform.
	ExecStepTask *ExecStepTask `protobuf:"bytes,5,opt,name=exec_step_task,json=execStepTask,proto3,oneof"`
}

type Task_ApplyConfigTask struct {
	// Details about the apply config step task to perform.
	ApplyConfigTask *ApplyConfigTask `protobuf:"bytes,7,opt,name=apply_config_task,json=applyConfigTask,proto3,oneof"`
}

func (*Task_ApplyPatchesTask) isTask_TaskDetails() {}

func (*Task_ExecStepTask) isTask_TaskDetails() {}

func (*Task_ApplyConfigTask) isTask_TaskDetails() {}

// Message which instructs agent to apply patches.
type ApplyPatchesTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Specific information about how patches should be applied.
	PatchConfig *PatchConfig `protobuf:"bytes,1,opt,name=patch_config,json=patchConfig,proto3" json:"patch_config,omitempty"`
	// If true, the agent will report its status as it goes through the motions
	// but won't actually run any updates or perform any reboots.
	DryRun bool `protobuf:"varint,3,opt,name=dry_run,json=dryRun,proto3" json:"dry_run,omitempty"`
}

func (x *ApplyPatchesTask) Reset() {
	*x = ApplyPatchesTask{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyPatchesTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyPatchesTask) ProtoMessage() {}

func (x *ApplyPatchesTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyPatchesTask.ProtoReflect.Descriptor instead.
func (*ApplyPatchesTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{1}
}

func (x *ApplyPatchesTask) GetPatchConfig() *PatchConfig {
	if x != nil {
		return x.PatchConfig
	}
	return nil
}

func (x *ApplyPatchesTask) GetDryRun() bool {
	if x != nil {
		return x.DryRun
	}
	return false
}

// Information reported from the agent about applying patches execution.
type ApplyPatchesTaskProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The current state of this patch execution.
	State ApplyPatchesTaskProgress_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskProgress_State" json:"state,omitempty"`
}

func (x *ApplyPatchesTaskProgress) Reset() {
	*x = ApplyPatchesTaskProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyPatchesTaskProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyPatchesTaskProgress) ProtoMessage() {}

func (x *ApplyPatchesTaskProgress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyPatchesTaskProgress.ProtoReflect.Descriptor instead.
func (*ApplyPatchesTaskProgress) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{2}
}

func (x *ApplyPatchesTaskProgress) GetState() ApplyPatchesTaskProgress_State {
	if x != nil {
		return x.State
	}
	return ApplyPatchesTaskProgress_STATE_UNSPECIFIED
}

// Information reported from the agent about applying patches execution.
type ApplyPatchesTaskOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The final state of this task.
	State ApplyPatchesTaskOutput_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskOutput_State" json:"state,omitempty"`
}

func (x *ApplyPatchesTaskOutput) Reset() {
	*x = ApplyPatchesTaskOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyPatchesTaskOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyPatchesTaskOutput) ProtoMessage() {}

func (x *ApplyPatchesTaskOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyPatchesTaskOutput.ProtoReflect.Descriptor instead.
func (*ApplyPatchesTaskOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{3}
}

func (x *ApplyPatchesTaskOutput) GetState() ApplyPatchesTaskOutput_State {
	if x != nil {
		return x.State
	}
	return ApplyPatchesTaskOutput_STATE_UNSPECIFIED
}

// Message which instructs agent to execute the following command.
type ExecStepTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Details of the exec step to run.
	ExecStep *ExecStep `protobuf:"bytes,1,opt,name=exec_step,json=execStep,proto3" json:"exec_step,omitempty"`
}

func (x *ExecStepTask) Reset() {
	*x = ExecStepTask{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecStepTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecStepTask) ProtoMessage() {}

func (x *ExecStepTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecStepTask.ProtoReflect.Descriptor instead.
func (*ExecStepTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{4}
}

func (x *ExecStepTask) GetExecStep() *ExecStep {
	if x != nil {
		return x.ExecStep
	}
	return nil
}

// Information reported from the agent about the exec step execution.
type ExecStepTaskProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The current state of this exec step.
	State ExecStepTaskProgress_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.osconfig.agentendpoint.v1.ExecStepTaskProgress_State" json:"state,omitempty"`
}

func (x *ExecStepTaskProgress) Reset() {
	*x = ExecStepTaskProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecStepTaskProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecStepTaskProgress) ProtoMessage() {}

func (x *ExecStepTaskProgress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecStepTaskProgress.ProtoReflect.Descriptor instead.
func (*ExecStepTaskProgress) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{5}
}

func (x *ExecStepTaskProgress) GetState() ExecStepTaskProgress_State {
	if x != nil {
		return x.State
	}
	return ExecStepTaskProgress_STATE_UNSPECIFIED
}

// Information reported from the agent about the exec step execution.
type ExecStepTaskOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The final state of the exec step.
	State ExecStepTaskOutput_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.osconfig.agentendpoint.v1.ExecStepTaskOutput_State" json:"state,omitempty"`
	// Required. The exit code received from the script which ran as part of the exec step.
	ExitCode int32 `protobuf:"varint,2,opt,name=exit_code,json=exitCode,proto3" json:"exit_code,omitempty"`
}

func (x *ExecStepTaskOutput) Reset() {
	*x = ExecStepTaskOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExecStepTaskOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExecStepTaskOutput) ProtoMessage() {}

func (x *ExecStepTaskOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExecStepTaskOutput.ProtoReflect.Descriptor instead.
func (*ExecStepTaskOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{6}
}

func (x *ExecStepTaskOutput) GetState() ExecStepTaskOutput_State {
	if x != nil {
		return x.State
	}
	return ExecStepTaskOutput_STATE_UNSPECIFIED
}

func (x *ExecStepTaskOutput) GetExitCode() int32 {
	if x != nil {
		return x.ExitCode
	}
	return 0
}

// Message which instructs OS Config agent to apply the desired state
// configuration.
type ApplyConfigTask struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// List of os policies to be applied for the instance.
	OsPolicies []*ApplyConfigTask_OSPolicy `protobuf:"bytes,1,rep,name=os_policies,json=osPolicies,proto3" json:"os_policies,omitempty"`
}

func (x *ApplyConfigTask) Reset() {
	*x = ApplyConfigTask{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyConfigTask) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyConfigTask) ProtoMessage() {}

func (x *ApplyConfigTask) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyConfigTask.ProtoReflect.Descriptor instead.
func (*ApplyConfigTask) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{7}
}

func (x *ApplyConfigTask) GetOsPolicies() []*ApplyConfigTask_OSPolicy {
	if x != nil {
		return x.OsPolicies
	}
	return nil
}

// Information reported from the agent regarding the progress of the task of
// applying desired state configuration.
type ApplyConfigTaskProgress struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The current state of this task.
	State ApplyConfigTaskProgress_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskProgress_State" json:"state,omitempty"`
}

func (x *ApplyConfigTaskProgress) Reset() {
	*x = ApplyConfigTaskProgress{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyConfigTaskProgress) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyConfigTaskProgress) ProtoMessage() {}

func (x *ApplyConfigTaskProgress) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyConfigTaskProgress.ProtoReflect.Descriptor instead.
func (*ApplyConfigTaskProgress) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{8}
}

func (x *ApplyConfigTaskProgress) GetState() ApplyConfigTaskProgress_State {
	if x != nil {
		return x.State
	}
	return ApplyConfigTaskProgress_STATE_UNSPECIFIED
}

// Information reported from the agent regarding the output of the task of
// applying desired state configuration.
type ApplyConfigTaskOutput struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The final state of this task.
	State ApplyConfigTaskOutput_State `protobuf:"varint,1,opt,name=state,proto3,enum=google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput_State" json:"state,omitempty"`
	// Results of applying desired state config for the OS policies.
	OsPolicyResults []*ApplyConfigTaskOutput_OSPolicyResult `protobuf:"bytes,2,rep,name=os_policy_results,json=osPolicyResults,proto3" json:"os_policy_results,omitempty"`
}

func (x *ApplyConfigTaskOutput) Reset() {
	*x = ApplyConfigTaskOutput{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyConfigTaskOutput) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyConfigTaskOutput) ProtoMessage() {}

func (x *ApplyConfigTaskOutput) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyConfigTaskOutput.ProtoReflect.Descriptor instead.
func (*ApplyConfigTaskOutput) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{9}
}

func (x *ApplyConfigTaskOutput) GetState() ApplyConfigTaskOutput_State {
	if x != nil {
		return x.State
	}
	return ApplyConfigTaskOutput_STATE_UNSPECIFIED
}

func (x *ApplyConfigTaskOutput) GetOsPolicyResults() []*ApplyConfigTaskOutput_OSPolicyResult {
	if x != nil {
		return x.OsPolicyResults
	}
	return nil
}

// Message representing an OS policy.
type ApplyConfigTask_OSPolicy struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// User provided policy id.
	// Used for reporting and logging by the agent.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The policy mode
	Mode OSPolicy_Mode `protobuf:"varint,2,opt,name=mode,proto3,enum=google.cloud.osconfig.agentendpoint.v1.OSPolicy_Mode" json:"mode,omitempty"`
	// Reference to the `OSPolicyAssignment` API resource that this `OSPolicy`
	// belongs to.
	// Format:
	// projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id@revision_id}
	// Used for reporting and logging by the agent.
	OsPolicyAssignment string `protobuf:"bytes,3,opt,name=os_policy_assignment,json=osPolicyAssignment,proto3" json:"os_policy_assignment,omitempty"`
	// List of resources associated with the policy to be set to their
	// desired state.
	Resources []*OSPolicy_Resource `protobuf:"bytes,4,rep,name=resources,proto3" json:"resources,omitempty"`
}

func (x *ApplyConfigTask_OSPolicy) Reset() {
	*x = ApplyConfigTask_OSPolicy{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyConfigTask_OSPolicy) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyConfigTask_OSPolicy) ProtoMessage() {}

func (x *ApplyConfigTask_OSPolicy) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyConfigTask_OSPolicy.ProtoReflect.Descriptor instead.
func (*ApplyConfigTask_OSPolicy) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{7, 0}
}

func (x *ApplyConfigTask_OSPolicy) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *ApplyConfigTask_OSPolicy) GetMode() OSPolicy_Mode {
	if x != nil {
		return x.Mode
	}
	return OSPolicy_MODE_UNSPECIFIED
}

func (x *ApplyConfigTask_OSPolicy) GetOsPolicyAssignment() string {
	if x != nil {
		return x.OsPolicyAssignment
	}
	return ""
}

func (x *ApplyConfigTask_OSPolicy) GetResources() []*OSPolicy_Resource {
	if x != nil {
		return x.Resources
	}
	return nil
}

// Result of applying desired state config for an OS policy.
type ApplyConfigTaskOutput_OSPolicyResult struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The OS policy id
	OsPolicyId string `protobuf:"bytes,1,opt,name=os_policy_id,json=osPolicyId,proto3" json:"os_policy_id,omitempty"`
	// Reference to the `OSPolicyAssignment` API resource that this `OSPolicy`
	// belongs to.
	// Format:
	// projects/{project_number}/locations/{location}/osPolicyAssignments/{os_policy_assignment_id@revision_id}
	// Used for reporting and logging by the agent.
	OsPolicyAssignment string `protobuf:"bytes,2,opt,name=os_policy_assignment,json=osPolicyAssignment,proto3" json:"os_policy_assignment,omitempty"`
	// Results of applying desired state config for the OS policy resources.
	OsPolicyResourceCompliances []*OSPolicyResourceCompliance `protobuf:"bytes,3,rep,name=os_policy_resource_compliances,json=osPolicyResourceCompliances,proto3" json:"os_policy_resource_compliances,omitempty"`
}

func (x *ApplyConfigTaskOutput_OSPolicyResult) Reset() {
	*x = ApplyConfigTaskOutput_OSPolicyResult{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ApplyConfigTaskOutput_OSPolicyResult) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ApplyConfigTaskOutput_OSPolicyResult) ProtoMessage() {}

func (x *ApplyConfigTaskOutput_OSPolicyResult) ProtoReflect() protoreflect.Message {
	mi := &file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ApplyConfigTaskOutput_OSPolicyResult.ProtoReflect.Descriptor instead.
func (*ApplyConfigTaskOutput_OSPolicyResult) Descriptor() ([]byte, []int) {
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP(), []int{9, 0}
}

func (x *ApplyConfigTaskOutput_OSPolicyResult) GetOsPolicyId() string {
	if x != nil {
		return x.OsPolicyId
	}
	return ""
}

func (x *ApplyConfigTaskOutput_OSPolicyResult) GetOsPolicyAssignment() string {
	if x != nil {
		return x.OsPolicyAssignment
	}
	return ""
}

func (x *ApplyConfigTaskOutput_OSPolicyResult) GetOsPolicyResourceCompliances() []*OSPolicyResourceCompliance {
	if x != nil {
		return x.OsPolicyResourceCompliances
	}
	return nil
}

var File_google_cloud_osconfig_agentendpoint_v1_tasks_proto protoreflect.FileDescriptor

var file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDesc = []byte{
	0x0a, 0x32, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x74, 0x61, 0x73, 0x6b, 0x73, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x12, 0x26, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x1a, 0x1f, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x62,
	0x65, 0x68, 0x61, 0x76, 0x69, 0x6f, 0x72, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x19, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x61, 0x70, 0x69, 0x2f, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72,
	0x63, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x3a, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31,
	0x2f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x63, 0x6f, 0x6d, 0x6d, 0x6f, 0x6e, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x36, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e,
	0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x76, 0x31, 0x2f, 0x6f, 0x73, 0x5f,
	0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x37, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2f, 0x76, 0x31, 0x2f, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x6a, 0x6f, 0x62, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xb5, 0x05, 0x0a, 0x04, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x17,
	0x0a, 0x07, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x06, 0x74, 0x61, 0x73, 0x6b, 0x49, 0x64, 0x12, 0x4d, 0x0a, 0x09, 0x74, 0x61, 0x73, 0x6b, 0x5f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x52, 0x08, 0x74, 0x61,
	0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x5c, 0x0a, 0x0e, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x64,
	0x69, 0x72, 0x65, 0x63, 0x74, 0x69, 0x76, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x69, 0x72, 0x65,
	0x63, 0x74, 0x69, 0x76, 0x65, 0x52, 0x0d, 0x74, 0x61, 0x73, 0x6b, 0x44, 0x69, 0x72, 0x65, 0x63,
	0x74, 0x69, 0x76, 0x65, 0x12, 0x68, 0x0a, 0x12, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x5f, 0x70, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x5f, 0x74, 0x61, 0x73, 0x6b, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x38, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x50,
	0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x54, 0x61, 0x73, 0x6b, 0x48, 0x00, 0x52, 0x10, 0x61, 0x70,
	0x70, 0x6c, 0x79, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x5c,
	0x0a, 0x0e, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x73, 0x74, 0x65, 0x70, 0x5f, 0x74, 0x61, 0x73, 0x6b,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x34, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x54, 0x61, 0x73, 0x6b, 0x48, 0x00, 0x52, 0x0c,
	0x65, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x54, 0x61, 0x73, 0x6b, 0x12, 0x65, 0x0a, 0x11,
	0x61, 0x70, 0x70, 0x6c, 0x79, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x5f, 0x74, 0x61, 0x73,
	0x6b, 0x18, 0x07, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x37, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x61, 0x73, 0x6b,
	0x48, 0x00, 0x52, 0x0f, 0x61, 0x70, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54,
	0x61, 0x73, 0x6b, 0x12, 0x66, 0x0a, 0x0e, 0x73, 0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x5f, 0x6c,
	0x61, 0x62, 0x65, 0x6c, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x3f, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x53, 0x65, 0x72, 0x76, 0x69, 0x63,
	0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x0d, 0x73, 0x65,
	0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x1a, 0x40, 0x0a, 0x12, 0x53,
	0x65, 0x72, 0x76, 0x69, 0x63, 0x65, 0x4c, 0x61, 0x62, 0x65, 0x6c, 0x73, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03,
	0x6b, 0x65, 0x79, 0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x42, 0x0e, 0x0a,
	0x0c, 0x74, 0x61, 0x73, 0x6b, 0x5f, 0x64, 0x65, 0x74, 0x61, 0x69, 0x6c, 0x73, 0x22, 0x83, 0x01,
	0x0a, 0x10, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x54, 0x61,
	0x73, 0x6b, 0x12, 0x56, 0x0a, 0x0c, 0x70, 0x61, 0x74, 0x63, 0x68, 0x5f, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x33, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x50, 0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x52, 0x0b, 0x70,
	0x61, 0x74, 0x63, 0x68, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x12, 0x17, 0x0a, 0x07, 0x64, 0x72,
	0x79, 0x5f, 0x72, 0x75, 0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x08, 0x52, 0x06, 0x64, 0x72, 0x79,
	0x52, 0x75, 0x6e, 0x22, 0xe8, 0x01, 0x0a, 0x18, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x50, 0x61, 0x74,
	0x63, 0x68, 0x65, 0x73, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73,
	0x12, 0x61, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x46, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64,
	0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x50, 0x61,
	0x74, 0x63, 0x68, 0x65, 0x73, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73,
	0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x74,
	0x61, 0x74, 0x65, 0x22, 0x69, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11,
	0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45,
	0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x04,
	0x12, 0x17, 0x0a, 0x13, 0x44, 0x4f, 0x57, 0x4e, 0x4c, 0x4f, 0x41, 0x44, 0x49, 0x4e, 0x47, 0x5f,
	0x50, 0x41, 0x54, 0x43, 0x48, 0x45, 0x53, 0x10, 0x01, 0x12, 0x14, 0x0a, 0x10, 0x41, 0x50, 0x50,
	0x4c, 0x59, 0x49, 0x4e, 0x47, 0x5f, 0x50, 0x41, 0x54, 0x43, 0x48, 0x45, 0x53, 0x10, 0x02, 0x12,
	0x0d, 0x0a, 0x09, 0x52, 0x45, 0x42, 0x4f, 0x4f, 0x54, 0x49, 0x4e, 0x47, 0x10, 0x03, 0x22, 0xd3,
	0x01, 0x0a, 0x16, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x54,
	0x61, 0x73, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x5f, 0x0a, 0x05, 0x73, 0x74, 0x61,
	0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x44, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76,
	0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x50, 0x61, 0x74, 0x63, 0x68, 0x65, 0x73, 0x54, 0x61,
	0x73, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42, 0x03,
	0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x58, 0x0a, 0x05, 0x53, 0x74,
	0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55,
	0x43, 0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x1d, 0x0a, 0x19, 0x53, 0x55, 0x43,
	0x43, 0x45, 0x45, 0x44, 0x45, 0x44, 0x5f, 0x52, 0x45, 0x42, 0x4f, 0x4f, 0x54, 0x5f, 0x52, 0x45,
	0x51, 0x55, 0x49, 0x52, 0x45, 0x44, 0x10, 0x02, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c,
	0x45, 0x44, 0x10, 0x03, 0x22, 0x5d, 0x0a, 0x0c, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70,
	0x54, 0x61, 0x73, 0x6b, 0x12, 0x4d, 0x0a, 0x09, 0x65, 0x78, 0x65, 0x63, 0x5f, 0x73, 0x74, 0x65,
	0x70, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e,
	0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31,
	0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x52, 0x08, 0x65, 0x78, 0x65, 0x63, 0x53,
	0x74, 0x65, 0x70, 0x22, 0xa2, 0x01, 0x0a, 0x14, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70,
	0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x12, 0x5d, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x42, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e,
	0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e,
	0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70, 0x54, 0x61, 0x73,
	0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65, 0x73, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22, 0x2b, 0x0a, 0x05, 0x53,
	0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e,
	0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x53,
	0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x22, 0xe0, 0x01, 0x0a, 0x12, 0x45, 0x78, 0x65,
	0x63, 0x53, 0x74, 0x65, 0x70, 0x54, 0x61, 0x73, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12,
	0x5b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x40,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73,
	0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70,
	0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x65, 0x63, 0x53, 0x74, 0x65, 0x70,
	0x54, 0x61, 0x73, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x42, 0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x20, 0x0a, 0x09,
	0x65, 0x78, 0x69, 0x74, 0x5f, 0x63, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x05, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x08, 0x65, 0x78, 0x69, 0x74, 0x43, 0x6f, 0x64, 0x65, 0x22, 0x4b,
	0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45,
	0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d,
	0x0a, 0x09, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0d, 0x0a,
	0x09, 0x54, 0x49, 0x4d, 0x45, 0x44, 0x5f, 0x4f, 0x55, 0x54, 0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10, 0x03, 0x22, 0x98, 0x03, 0x0a, 0x0f,
	0x41, 0x70, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x61, 0x73, 0x6b, 0x12,
	0x61, 0x0a, 0x0b, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x69, 0x65, 0x73, 0x18, 0x01,
	0x20, 0x03, 0x28, 0x0b, 0x32, 0x40, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c,
	0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65,
	0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70,
	0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x61, 0x73, 0x6b, 0x2e, 0x4f, 0x53,
	0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x0a, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x69,
	0x65, 0x73, 0x1a, 0xa1, 0x02, 0x0a, 0x08, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x12,
	0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12,
	0x49, 0x0a, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x35, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63,
	0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f,
	0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x2e,
	0x4d, 0x6f, 0x64, 0x65, 0x52, 0x04, 0x6d, 0x6f, 0x64, 0x65, 0x12, 0x61, 0x0a, 0x14, 0x6f, 0x73,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x6f, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x57, 0x0a,
	0x09, 0x72, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x39, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e,
	0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e,
	0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x2e, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x52, 0x09, 0x72, 0x65, 0x73,
	0x6f, 0x75, 0x72, 0x63, 0x65, 0x73, 0x22, 0xb8, 0x01, 0x0a, 0x17, 0x41, 0x70, 0x70, 0x6c, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x12, 0x5b, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0e, 0x32, 0x45, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64,
	0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79,
	0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x61, 0x73, 0x6b, 0x50, 0x72, 0x6f, 0x67, 0x72, 0x65,
	0x73, 0x73, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x22,
	0x40, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65, 0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54,
	0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0b, 0x0a, 0x07, 0x53, 0x54, 0x41, 0x52, 0x54, 0x45, 0x44, 0x10, 0x01, 0x12, 0x13, 0x0a, 0x0f,
	0x41, 0x50, 0x50, 0x4c, 0x59, 0x49, 0x4e, 0x47, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x10,
	0x02, 0x22, 0xdd, 0x04, 0x0a, 0x15, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x54, 0x61, 0x73, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x12, 0x5e, 0x0a, 0x05, 0x73,
	0x74, 0x61, 0x74, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x43, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66,
	0x69, 0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74,
	0x2e, 0x76, 0x31, 0x2e, 0x41, 0x70, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54,
	0x61, 0x73, 0x6b, 0x4f, 0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x53, 0x74, 0x61, 0x74, 0x65, 0x42,
	0x03, 0xe0, 0x41, 0x02, 0x52, 0x05, 0x73, 0x74, 0x61, 0x74, 0x65, 0x12, 0x78, 0x0a, 0x11, 0x6f,
	0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x73,
	0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x4c, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x41, 0x70, 0x70, 0x6c, 0x79, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x54, 0x61, 0x73, 0x6b, 0x4f,
	0x75, 0x74, 0x70, 0x75, 0x74, 0x2e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x52, 0x0f, 0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65,
	0x73, 0x75, 0x6c, 0x74, 0x73, 0x1a, 0x9f, 0x02, 0x0a, 0x0e, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69,
	0x63, 0x79, 0x52, 0x65, 0x73, 0x75, 0x6c, 0x74, 0x12, 0x20, 0x0a, 0x0c, 0x6f, 0x73, 0x5f, 0x70,
	0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0a,
	0x6f, 0x73, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x49, 0x64, 0x12, 0x61, 0x0a, 0x14, 0x6f, 0x73,
	0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x42, 0x2f, 0xfa, 0x41, 0x2c, 0x0a, 0x2a, 0x6f,
	0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41,
	0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x52, 0x12, 0x6f, 0x73, 0x50, 0x6f, 0x6c,
	0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x12, 0x87, 0x01,
	0x0a, 0x1e, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x72, 0x65, 0x73, 0x6f,
	0x75, 0x72, 0x63, 0x65, 0x5f, 0x63, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x73,
	0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x42, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2e, 0x61,
	0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e, 0x76, 0x31, 0x2e,
	0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65,
	0x43, 0x6f, 0x6d, 0x70, 0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x52, 0x1b, 0x6f, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x52, 0x65, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x43, 0x6f, 0x6d, 0x70,
	0x6c, 0x69, 0x61, 0x6e, 0x63, 0x65, 0x73, 0x22, 0x48, 0x0a, 0x05, 0x53, 0x74, 0x61, 0x74, 0x65,
	0x12, 0x15, 0x0a, 0x11, 0x53, 0x54, 0x41, 0x54, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43,
	0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0d, 0x0a, 0x09, 0x53, 0x55, 0x43, 0x43, 0x45,
	0x45, 0x44, 0x45, 0x44, 0x10, 0x01, 0x12, 0x0a, 0x0a, 0x06, 0x46, 0x41, 0x49, 0x4c, 0x45, 0x44,
	0x10, 0x02, 0x12, 0x0d, 0x0a, 0x09, 0x43, 0x41, 0x4e, 0x43, 0x45, 0x4c, 0x4c, 0x45, 0x44, 0x10,
	0x03, 0x2a, 0x47, 0x0a, 0x0d, 0x54, 0x61, 0x73, 0x6b, 0x44, 0x69, 0x72, 0x65, 0x63, 0x74, 0x69,
	0x76, 0x65, 0x12, 0x1e, 0x0a, 0x1a, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x44, 0x49, 0x52, 0x45, 0x43,
	0x54, 0x49, 0x56, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44,
	0x10, 0x00, 0x12, 0x0c, 0x0a, 0x08, 0x43, 0x4f, 0x4e, 0x54, 0x49, 0x4e, 0x55, 0x45, 0x10, 0x01,
	0x12, 0x08, 0x0a, 0x04, 0x53, 0x54, 0x4f, 0x50, 0x10, 0x02, 0x2a, 0x63, 0x0a, 0x08, 0x54, 0x61,
	0x73, 0x6b, 0x54, 0x79, 0x70, 0x65, 0x12, 0x19, 0x0a, 0x15, 0x54, 0x41, 0x53, 0x4b, 0x5f, 0x54,
	0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10,
	0x00, 0x12, 0x11, 0x0a, 0x0d, 0x41, 0x50, 0x50, 0x4c, 0x59, 0x5f, 0x50, 0x41, 0x54, 0x43, 0x48,
	0x45, 0x53, 0x10, 0x01, 0x12, 0x12, 0x0a, 0x0e, 0x45, 0x58, 0x45, 0x43, 0x5f, 0x53, 0x54, 0x45,
	0x50, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x10, 0x02, 0x12, 0x15, 0x0a, 0x11, 0x41, 0x50, 0x50, 0x4c,
	0x59, 0x5f, 0x43, 0x4f, 0x4e, 0x46, 0x49, 0x47, 0x5f, 0x54, 0x41, 0x53, 0x4b, 0x10, 0x03, 0x42,
	0x8b, 0x02, 0xea, 0x41, 0x80, 0x01, 0x0a, 0x2a, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70, 0x69, 0x73, 0x2e, 0x63, 0x6f, 0x6d, 0x2f,
	0x4f, 0x53, 0x50, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65,
	0x6e, 0x74, 0x12, 0x52, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x73, 0x2f, 0x7b, 0x70, 0x72,
	0x6f, 0x6a, 0x65, 0x63, 0x74, 0x7d, 0x2f, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73,
	0x2f, 0x7b, 0x6c, 0x6f, 0x63, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x7d, 0x2f, 0x6f, 0x73, 0x50, 0x6f,
	0x6c, 0x69, 0x63, 0x79, 0x41, 0x73, 0x73, 0x69, 0x67, 0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x73, 0x2f,
	0x7b, 0x6f, 0x73, 0x5f, 0x70, 0x6f, 0x6c, 0x69, 0x63, 0x79, 0x5f, 0x61, 0x73, 0x73, 0x69, 0x67,
	0x6e, 0x6d, 0x65, 0x6e, 0x74, 0x7d, 0x0a, 0x2a, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x63, 0x6c, 0x6f, 0x75, 0x64, 0x2e, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x2e, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2e,
	0x76, 0x31, 0x42, 0x05, 0x54, 0x61, 0x73, 0x6b, 0x73, 0x50, 0x01, 0x5a, 0x50, 0x63, 0x6c, 0x6f,
	0x75, 0x64, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x63, 0x6f, 0x6d, 0x2f, 0x67, 0x6f,
	0x2f, 0x6f, 0x73, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x2f, 0x61, 0x67, 0x65, 0x6e, 0x74, 0x65,
	0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x2f, 0x61, 0x70, 0x69, 0x76, 0x31, 0x2f, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x70, 0x62, 0x3b, 0x61, 0x67,
	0x65, 0x6e, 0x74, 0x65, 0x6e, 0x64, 0x70, 0x6f, 0x69, 0x6e, 0x74, 0x70, 0x62, 0x62, 0x06, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x33,
}

var (
	file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescOnce sync.Once
	file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescData = file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDesc
)

func file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescGZIP() []byte {
	file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescOnce.Do(func() {
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescData)
	})
	return file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDescData
}

var file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes = make([]protoimpl.EnumInfo, 8)
var file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes = make([]protoimpl.MessageInfo, 13)
var file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_goTypes = []interface{}{
	(TaskDirective)(0),                           // 0: google.cloud.osconfig.agentendpoint.v1.TaskDirective
	(TaskType)(0),                                // 1: google.cloud.osconfig.agentendpoint.v1.TaskType
	(ApplyPatchesTaskProgress_State)(0),          // 2: google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskProgress.State
	(ApplyPatchesTaskOutput_State)(0),            // 3: google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskOutput.State
	(ExecStepTaskProgress_State)(0),              // 4: google.cloud.osconfig.agentendpoint.v1.ExecStepTaskProgress.State
	(ExecStepTaskOutput_State)(0),                // 5: google.cloud.osconfig.agentendpoint.v1.ExecStepTaskOutput.State
	(ApplyConfigTaskProgress_State)(0),           // 6: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskProgress.State
	(ApplyConfigTaskOutput_State)(0),             // 7: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput.State
	(*Task)(nil),                                 // 8: google.cloud.osconfig.agentendpoint.v1.Task
	(*ApplyPatchesTask)(nil),                     // 9: google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTask
	(*ApplyPatchesTaskProgress)(nil),             // 10: google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskProgress
	(*ApplyPatchesTaskOutput)(nil),               // 11: google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskOutput
	(*ExecStepTask)(nil),                         // 12: google.cloud.osconfig.agentendpoint.v1.ExecStepTask
	(*ExecStepTaskProgress)(nil),                 // 13: google.cloud.osconfig.agentendpoint.v1.ExecStepTaskProgress
	(*ExecStepTaskOutput)(nil),                   // 14: google.cloud.osconfig.agentendpoint.v1.ExecStepTaskOutput
	(*ApplyConfigTask)(nil),                      // 15: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTask
	(*ApplyConfigTaskProgress)(nil),              // 16: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskProgress
	(*ApplyConfigTaskOutput)(nil),                // 17: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput
	nil,                                          // 18: google.cloud.osconfig.agentendpoint.v1.Task.ServiceLabelsEntry
	(*ApplyConfigTask_OSPolicy)(nil),             // 19: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTask.OSPolicy
	(*ApplyConfigTaskOutput_OSPolicyResult)(nil), // 20: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput.OSPolicyResult
	(*PatchConfig)(nil),                          // 21: google.cloud.osconfig.agentendpoint.v1.PatchConfig
	(*ExecStep)(nil),                             // 22: google.cloud.osconfig.agentendpoint.v1.ExecStep
	(OSPolicy_Mode)(0),                           // 23: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Mode
	(*OSPolicy_Resource)(nil),                    // 24: google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource
	(*OSPolicyResourceCompliance)(nil),           // 25: google.cloud.osconfig.agentendpoint.v1.OSPolicyResourceCompliance
}
var file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_depIdxs = []int32{
	1,  // 0: google.cloud.osconfig.agentendpoint.v1.Task.task_type:type_name -> google.cloud.osconfig.agentendpoint.v1.TaskType
	0,  // 1: google.cloud.osconfig.agentendpoint.v1.Task.task_directive:type_name -> google.cloud.osconfig.agentendpoint.v1.TaskDirective
	9,  // 2: google.cloud.osconfig.agentendpoint.v1.Task.apply_patches_task:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTask
	12, // 3: google.cloud.osconfig.agentendpoint.v1.Task.exec_step_task:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStepTask
	15, // 4: google.cloud.osconfig.agentendpoint.v1.Task.apply_config_task:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyConfigTask
	18, // 5: google.cloud.osconfig.agentendpoint.v1.Task.service_labels:type_name -> google.cloud.osconfig.agentendpoint.v1.Task.ServiceLabelsEntry
	21, // 6: google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTask.patch_config:type_name -> google.cloud.osconfig.agentendpoint.v1.PatchConfig
	2,  // 7: google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskProgress.state:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskProgress.State
	3,  // 8: google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskOutput.state:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyPatchesTaskOutput.State
	22, // 9: google.cloud.osconfig.agentendpoint.v1.ExecStepTask.exec_step:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStep
	4,  // 10: google.cloud.osconfig.agentendpoint.v1.ExecStepTaskProgress.state:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStepTaskProgress.State
	5,  // 11: google.cloud.osconfig.agentendpoint.v1.ExecStepTaskOutput.state:type_name -> google.cloud.osconfig.agentendpoint.v1.ExecStepTaskOutput.State
	19, // 12: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTask.os_policies:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyConfigTask.OSPolicy
	6,  // 13: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskProgress.state:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskProgress.State
	7,  // 14: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput.state:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput.State
	20, // 15: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput.os_policy_results:type_name -> google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput.OSPolicyResult
	23, // 16: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTask.OSPolicy.mode:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Mode
	24, // 17: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTask.OSPolicy.resources:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicy.Resource
	25, // 18: google.cloud.osconfig.agentendpoint.v1.ApplyConfigTaskOutput.OSPolicyResult.os_policy_resource_compliances:type_name -> google.cloud.osconfig.agentendpoint.v1.OSPolicyResourceCompliance
	19, // [19:19] is the sub-list for method output_type
	19, // [19:19] is the sub-list for method input_type
	19, // [19:19] is the sub-list for extension type_name
	19, // [19:19] is the sub-list for extension extendee
	0,  // [0:19] is the sub-list for field type_name
}

func init() { file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_init() }
func file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_init() {
	if File_google_cloud_osconfig_agentendpoint_v1_tasks_proto != nil {
		return
	}
	file_google_cloud_osconfig_agentendpoint_v1_config_common_proto_init()
	file_google_cloud_osconfig_agentendpoint_v1_os_policy_proto_init()
	file_google_cloud_osconfig_agentendpoint_v1_patch_jobs_proto_init()
	if !protoimpl.UnsafeEnabled {
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Task); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyPatchesTask); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyPatchesTaskProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyPatchesTaskOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecStepTask); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecStepTaskProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExecStepTaskOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyConfigTask); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyConfigTaskProgress); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyConfigTaskOutput); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyConfigTask_OSPolicy); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ApplyConfigTaskOutput_OSPolicyResult); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes[0].OneofWrappers = []interface{}{
		(*Task_ApplyPatchesTask)(nil),
		(*Task_ExecStepTask)(nil),
		(*Task_ApplyConfigTask)(nil),
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDesc,
			NumEnums:      8,
			NumMessages:   13,
			NumExtensions: 0,
			NumServices:   0,
		},
		GoTypes:           file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_goTypes,
		DependencyIndexes: file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_depIdxs,
		EnumInfos:         file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_enumTypes,
		MessageInfos:      file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_msgTypes,
	}.Build()
	File_google_cloud_osconfig_agentendpoint_v1_tasks_proto = out.File
	file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_rawDesc = nil
	file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_goTypes = nil
	file_google_cloud_osconfig_agentendpoint_v1_tasks_proto_depIdxs = nil
}
