//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cMachineGun.cpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================

//==============================================================================
// Includes
#include "cMachineGun.hpp"
#include "cWorld.hpp"
#include "cMixer.hpp"
#include "cBullet.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace ShootingStar;
//==============================================================================


//! Constructor
cMachineGun::cMachineGun (void):
cWeapon (50, 100, 1500),
mSound (cMixer::GetInstance ().LoadSound ("machinegun.wav"))
{
	SetAmmo (50, 2);
};

//! Destructor
cMachineGun::~cMachineGun (void)
{
	// Empty
};

void 
cMachineGun::Fire (const cVector2f &position, float angle)
{
	cMixer::GetInstance ().PlaySound (mSound);

	SpawnSuuliekki ();

	// Spawn a bullet object
	cBullet *pBullet = new cBullet;
	pBullet->SetPosition (position);
	pBullet->SetRotation (angle);
	pBullet->SetOwner (GetOwner ());
	
	pBullet->Rotate (-1.0f + 2.0f * rand () / (RAND_MAX + 1.0f));
	pBullet->Move (0.0f, 16.0f);
	pBullet->SetVelocity (pBullet->GetDirection () * 2.0f);
	pBullet->SetDamage (3);
	cWorld::GetInstance ().SpawnObject (pBullet);
}

//==============================================================================
// EOF
//==============================================================================
