//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cSprite.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cSprite_hpp
#define cSprite_hpp
//==============================================================================
// Includes
#include "cRenderable.hpp"
#include "cAnimationHandle.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//==============================================================================
//! Animated object
/*!
	\todo animation management
*/
//------------------------------------------------------------------------------
class cSprite: public cRenderable
{
	// Constructor & Destructor
	public:
		//! Constructor
		cSprite (void);
		//! Destructor
		virtual ~cSprite (void);
	
	// Public methods
	public:
		//! Rendering interface
		virtual void Render (Uint32 deltaTime);
		//! Updating interface
		virtual void Update (Uint32 deltaTime);
	
	// Member variables
	public:
		cAnimationHandle mAnimation;
};
//==============================================================================

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cSprite_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
