//==============================================================================
// This program is free software; you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation; either version 2 of the License, or
// (at your option) any later version.
//
// This program is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU Library General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with this program; if not, write to the Free Software
// Foundation, Inc., 59 Temple Place - Suite 330, Boston, MA 02111-1307, USA.
//==============================================================================

//==============================================================================
// File: cAnimationManager.hpp
// Project: Shooting Star
// Author: Jarmo Hekkanen <jarski@2ndpoint.fi>
// Copyrights (c) 2003 2ndPoint ry (www.2ndpoint.fi)
//------------------------------------------------------------------------------
// Revision history
//==============================================================================
#ifndef cAnimationManager_hpp
#define cAnimationManager_hpp
//==============================================================================
// Includes
#include <string>
#include <map>
#include "cAnimation.hpp"
#include "Types.hpp"
//------------------------------------------------------------------------------
// Namespaces
using namespace std;
namespace ShootingStar {
//------------------------------------------------------------------------------
// Forward declarations
//==============================================================================
	
//! Singleton animation manager
class cAnimationManager
{
	// Constructor & Destructor
	private:
		//! Constructor
		cAnimationManager (void);
	public:
		//! Destructor
		~cAnimationManager (void);
	
	// Public methods
	public:
		//! Return singleton
		static cAnimationManager &GetInstance (void);
		//! Set data dir
		void SetDataDir (const string &dir) { mDataDir = dir; };
		//! Return data dir
		const string &GetDataDir (void) const { return mDataDir; };
		
		//! Load animation
		Uint32 LoadAnimation (string filename);
		//! Free all animations
		void FreeAllAnimations (void);
	
	// Member variables
	private:
		map<string, cAnimation> mAnimations;
		string mDataDir;
};

//==============================================================================
}		// End of the ShootingStar namespace
#endif // cAnimationManager_hpp
//------------------------------------------------------------------------------
// EOF
//==============================================================================
