require_relative "spec/spec_helper"

ready "search matching a large list of choices" do
  before do
    config = Configuration.from_inputs(PATHS[0,500], Configuration.default_options)
    @search = Search.from_config(config)
  end

  go "filtering with no matches" do
    @search.append_search_string("zxzxzx").best_matches
  end

  go "filtering with many matches" do
    @search.append_search_string("e").best_matches
  end

  go "progressive query appending, sequential, few matches" do
    @search
    .append_search_string("x")
    .append_search_string("t")
    .append_search_string("c")
    .append_search_string("o")
    .append_search_string("n")
    .append_search_string("f")
  end

  go "progressive query appending, sequential, many matches" do
    @search
    .append_search_string("g")
    .append_search_string("e")
    .append_search_string("m")
    .append_search_string("r")
    .append_search_string("u")
    .append_search_string("b")
    .append_search_string("y")
  end

  go "progressive query appending, non-sequential, few matches" do
    @search
    .append_search_string("x")
    .append_search_string("c")
    .append_search_string("o")
    .append_search_string("n")
    .append_search_string("f")
  end

  go "progressive query appending, non-sequential, many matches" do
    @search
    .append_search_string("g")
    .append_search_string("m")
    .append_search_string("r")
    .append_search_string("u")
    .append_search_string("b")
    .append_search_string("y")
  end
end

PATHS = [
  "./.gem",
  "./.gem/ruby",
  "./.gem/ruby/2.1.0",
  "./.gem/ruby/2.1.0/bin",
  "./.gem/ruby/2.1.0/bin/autospec",
  "./.gem/ruby/2.1.0/bin/benchmark_ips",
  "./.gem/ruby/2.1.0/bin/bundle",
  "./.gem/ruby/2.1.0/bin/bundler",
  "./.gem/ruby/2.1.0/bin/htmldiff",
  "./.gem/ruby/2.1.0/bin/ldiff",
  "./.gem/ruby/2.1.0/bin/rspec",
  "./.gem/ruby/2.1.0/build_info",
  "./.gem/ruby/2.1.0/build_info/diff-lcs-1.2.4.info",
  "./.gem/ruby/2.1.0/build_info/rspec-core-2.14.6.info",
  "./.gem/ruby/2.1.0/build_info/rspec-expectations-2.14.3.info",
  "./.gem/ruby/2.1.0/build_info/rspec-mocks-2.14.4.info",
  "./.gem/ruby/2.1.0/cache",
  "./.gem/ruby/2.1.0/cache/benchmark-ips-1.2.0.gem",
  "./.gem/ruby/2.1.0/cache/bundler-1.5.3.gem",
  "./.gem/ruby/2.1.0/cache/diff-lcs-1.2.4.gem",
  "./.gem/ruby/2.1.0/cache/diff-lcs-1.2.5.gem",
  "./.gem/ruby/2.1.0/cache/gem-open-0.1.7.gem",
  "./.gem/ruby/2.1.0/cache/rspec-2.14.1.gem",
  "./.gem/ruby/2.1.0/cache/rspec-core-2.14.6.gem",
  "./.gem/ruby/2.1.0/cache/rspec-core-2.14.7.gem",
  "./.gem/ruby/2.1.0/cache/rspec-expectations-2.14.3.gem",
  "./.gem/ruby/2.1.0/cache/rspec-expectations-2.14.5.gem",
  "./.gem/ruby/2.1.0/cache/rspec-mocks-2.14.4.gem",
  "./.gem/ruby/2.1.0/cache/rspec-mocks-2.14.6.gem",
  "./.gem/ruby/2.1.0/doc",
  "./.gem/ruby/2.1.0/extensions",
  "./.gem/ruby/2.1.0/gems",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/.autotest",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/.gemtest",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/bin",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/bin/benchmark_ips",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/History.txt",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/lib",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/lib/benchmark",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/lib/benchmark/compare.rb",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/lib/benchmark/helpers.rb",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/lib/benchmark/ips.rb",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/lib/benchmark/timing.rb",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/Manifest.txt",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/Rakefile",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/README.txt",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/test",
  "./.gem/ruby/2.1.0/gems/benchmark-ips-1.2.0/test/test_benchmark_ips.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/.gitignore",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/.rspec",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/.travis.yml",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/bin",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/bin/bundle",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/bin/bundle_ruby",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/bin/bundler",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/bundler.gemspec",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/CHANGELOG.md",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/CONTRIBUTING.md",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/DEVELOPMENT.md",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/ISSUES.md",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/capistrano.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/cli.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/constants.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/current_ruby.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/definition.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/dep_proxy.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/dependency.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/deployment.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/deprecate.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/dsl.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/endpoint_specification.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/env.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/environment.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/fetcher.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/friendly_errors.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/gem_helper.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/gem_helpers.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/gem_installer.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/gem_path_manipulation.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/gem_tasks.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/graph.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/index.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/injector.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/installer.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/lazy_specification.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/lockfile_parser.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-config",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-config.txt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-exec",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-exec.txt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-install",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-install.txt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-package",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-package.txt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-platform",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-platform.txt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-update",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle-update.txt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/bundle.txt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/gemfile.5",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/man/gemfile.5.txt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/match_platform.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/parallel_workers",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/parallel_workers/thread_worker.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/parallel_workers/unix_worker.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/parallel_workers/worker.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/parallel_workers.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/psyched_yaml.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/remote_specification.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/resolver.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/retry.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/ruby_dsl.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/ruby_version.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/rubygems_ext.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/rubygems_integration.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/runtime.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/safe_catch.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/settings.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/setup.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/shared_helpers.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/similarity_detector.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/source",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/source/git",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/source/git/git_proxy.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/source/git.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/source/path",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/source/path/installer.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/source/path.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/source/rubygems.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/source.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/spec_set.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/ssl_certs",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/ssl_certs/.document",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/ssl_certs/Class3PublicPrimaryCertificationAuthority.pem",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/ssl_certs/DigiCertHighAssuranceEVRootCA.pem",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/ssl_certs/EntrustnetSecureServerCertificationAuthority.pem",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/ssl_certs/GeoTrustGlobalCA.pem",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/Executable",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/Executable.standalone",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/Gemfile",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/.travis.yml.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/bin",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/bin/newgem.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/Gemfile.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/gitignore.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/lib",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/lib/newgem",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/lib/newgem/version.rb.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/lib/newgem.rb.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/LICENSE.txt.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/newgem.gemspec.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/Rakefile.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/README.md.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/rspec.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/spec",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/spec/newgem_spec.rb.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/spec/spec_helper.rb.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/test",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/test/minitest_helper.rb.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/templates/newgem/test/test_newgem.rb.tt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/ui.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/.document",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/net",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/net/http",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/net/http/faster.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/net/http/persistent",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/net/http/persistent/ssl_reuse.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/net/http/persistent.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/actions",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/actions/create_file.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/actions/create_link.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/actions/directory.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/actions/empty_directory.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/actions/file_manipulation.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/actions/inject_into_file.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/actions.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/base.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/command.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/core_ext",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/core_ext/hash_with_indifferent_access.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/core_ext/io_binary_read.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/core_ext/ordered_hash.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/error.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/group.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/invocation.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/line_editor",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/line_editor/basic.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/line_editor/readline.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/line_editor.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/parser",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/parser/argument.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/parser/arguments.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/parser/option.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/parser/options.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/parser.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/rake_compat.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/runner.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/shell",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/shell/basic.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/shell/color.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/shell/html.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/shell.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/util.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor/version.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendor/thor.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendored_persistent.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vendored_thor.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/version.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler/vlad.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/lib/bundler.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/LICENSE.md",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/man",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/man/bundle-config.ronn",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/man/bundle-exec.ronn",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/man/bundle-install.ronn",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/man/bundle-package.ronn",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/man/bundle-platform.ronn",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/man/bundle-update.ronn",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/man/bundle.ronn",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/man/gemfile.5.ronn",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/man/index.txt",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/Rakefile",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/README.md",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler/bundler_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler/cli_rspec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler/definition_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler/dsl_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler/friendly_errors_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler/gem_helper_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler/psyched_yaml_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler/retry_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler/safe_catch_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/bundler/source_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/cache",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/cache/gems_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/cache/git_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/cache/path_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/cache/platform_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/binstubs_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/check_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/clean_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/config_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/console_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/exec_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/help_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/init_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/inject_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/licenses_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/newgem_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/open_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/outdated_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/commands/show_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/binstubs_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/bundler_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/deploy_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gemfile",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gemfile/gemspec_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gemfile/git_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gemfile/path_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gemfile_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/c_ext_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/dependency_api_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/env_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/flex_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/groups_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/mirror_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/packed_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/platform_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/post_install_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/resolving_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/simple_case_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/standalone_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/sudo_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gems/win32_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/gemspecs_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/path_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/post_bundle_message_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/prereleases_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/security_policy_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/install/upgrade_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/lock",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/lock/git_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/lock/lockfile_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/other",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/other/bundle_ruby_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/other/cli_dispatch_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/other/ext_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/other/platform_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/quality_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/realworld",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/realworld/dependency_api_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/realworld/edgecases_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/realworld/parallel_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/resolver",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/resolver/basic_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/resolver/platform_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/runtime",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/runtime/executable_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/runtime/load_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/runtime/platform_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/runtime/require_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/runtime/setup_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/runtime/with_clean_env_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/spec_helper.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endopint_marshal_fail_basic_authentication.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_500.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_api_missing.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_basic_authentication.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_creds_diff_host.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_extra.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_extra_missing.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_fallback.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_host_redirect.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_marshal_fail.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_redirect.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/artifice/endpoint_timeout.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/builders.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/fakeweb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/fakeweb/rack-1.0.0.marshal",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/fakeweb/windows.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/hax.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/helpers.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/indexes.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/matchers.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/path.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/permissions.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/platforms.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/ruby_ext.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/rubygems_ext.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/streams.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/support/sudo.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/update",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/update/gems_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/update/git_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/spec/update/source_spec.rb",
  "./.gem/ruby/2.1.0/gems/bundler-1.5.3/UPGRADING.md",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/.autotest",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/.gemtest",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/.hoerc",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/.rspec",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/.travis.yml",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/autotest",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/autotest/discover.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/bin",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/bin/htmldiff",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/bin/ldiff",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/Contributing.rdoc",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/docs",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/docs/artistic.txt",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/docs/COPYING.txt",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/Gemfile",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/History.rdoc",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs/array.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs/block.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs/callbacks.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs/change.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs/htmldiff.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs/hunk.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs/internals.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs/ldiff.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs/string.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff/lcs.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/lib/diff-lcs.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/License.rdoc",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/Manifest.txt",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/Rakefile",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/README.rdoc",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec/change_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec/diff_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec/hunk_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec/issues_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec/lcs_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec/patch_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec/sdiff_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec/spec_helper.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec/traverse_balanced_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.4/spec/traverse_sequences_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/.autotest",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/.gemtest",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/.hoerc",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/.rspec",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/.travis.yml",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/autotest",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/autotest/discover.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/bin",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/bin/htmldiff",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/bin/ldiff",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/Contributing.rdoc",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/docs",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/docs/artistic.txt",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/docs/COPYING.txt",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/Gemfile",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/History.rdoc",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs/array.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs/block.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs/callbacks.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs/change.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs/htmldiff.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs/hunk.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs/internals.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs/ldiff.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs/string.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff/lcs.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/lib/diff-lcs.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/License.rdoc",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/Manifest.txt",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/Rakefile",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/README.rdoc",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec/change_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec/diff_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec/hunk_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec/issues_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec/lcs_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec/patch_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec/sdiff_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec/spec_helper.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec/traverse_balanced_spec.rb",
  "./.gem/ruby/2.1.0/gems/diff-lcs-1.2.5/spec/traverse_sequences_spec.rb",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/.gitignore",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/gem-open.gemspec",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/Gemfile",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/Gemfile.lock",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/lib",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/lib/rubygems",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/lib/rubygems/commands",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/lib/rubygems/commands/open.rb",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/lib/rubygems_plugin.rb",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/Rakefile",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/README.rdoc",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/test",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/test/gem_open_test.rb",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/test/resources",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/test/resources/activesupport-2.3.5.gemspec",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/test/resources/activesupport-3.0.0.beta3.gemspec",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/test/resources/imgur2-1.2.0.gemspec",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/test/resources/rails-2.3.5.gemspec",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/test/resources/sinatra-1.0.gemspec",
  "./.gem/ruby/2.1.0/gems/gem-open-0.1.7/test/resources/sinatra-sugar-0.4.1.gemspec",
  "./.gem/ruby/2.1.0/gems/rspec-2.14.1",
  "./.gem/ruby/2.1.0/gems/rspec-2.14.1/lib",
  "./.gem/ruby/2.1.0/gems/rspec-2.14.1/lib/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-2.14.1/lib/rspec/version.rb",
  "./.gem/ruby/2.1.0/gems/rspec-2.14.1/lib/rspec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-2.14.1/License.txt",
  "./.gem/ruby/2.1.0/gems/rspec-2.14.1/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/.document",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/.yardopts",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/Changelog.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/exe",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/exe/autospec",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/exe/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/Autotest.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/example_name_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/exit_status.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/format_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/init.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/line_number_appended_to_path.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/line_number_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/order.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/pattern_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/rake_task.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/require_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/ruby.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/tag.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/command_line/warnings_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/alias_example_to.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/backtrace_clean_patterns.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/custom_settings.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/default_path.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/deprecation_stream.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/fail_fast.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/failure_exit_code.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/order_and_seed.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/output_stream.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/pattern.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/profile.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/read_options_from_file.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/run_all_when_everything_filtered.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/show_failures_in_pending_blocks.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/configuration/treat_symbols_as_metadata_keys_with_true_values.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/example_groups",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/example_groups/basic_structure.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/example_groups/shared_context.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/example_groups/shared_examples.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/expectation_framework_integration",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/expectation_framework_integration/configure_expectation_framework.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/filtering",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/filtering/exclusion_filters.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/filtering/if_and_unless.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/filtering/inclusion_filters.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/formatters",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/formatters/configurable_colors.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/formatters/custom_formatter.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/formatters/json_formatter.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/formatters/text_formatter.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/helper_methods",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/helper_methods/arbitrary_methods.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/helper_methods/let.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/helper_methods/modules.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/hooks",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/hooks/around_hooks.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/hooks/before_and_after_hooks.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/hooks/filtering.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/metadata",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/metadata/current_example.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/metadata/described_class.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/metadata/user_defined.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/mock_framework_integration",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/mock_framework_integration/use_any_framework.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/mock_framework_integration/use_flexmock.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/mock_framework_integration/use_mocha.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/mock_framework_integration/use_rr.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/mock_framework_integration/use_rspec.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/pending",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/pending/pending_examples.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/spec_files",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/spec_files/arbitrary_file_suffix.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/step_definitions",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/step_definitions/additional_cli_steps.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/subject",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/subject/attribute_of_subject.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/subject/explicit_subject.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/subject/implicit_receiver.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/subject/implicit_subject.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/support",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/support/env.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/support/rubinius.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/features/Upgrade.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/autotest",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/autotest/discover.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/autotest/rspec2.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/autorun.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/backtrace_cleaner.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/backward_compatibility.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/command_line.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/configuration.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/configuration_options.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/deprecation.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/drb_command_line.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/drb_options.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/dsl.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/example.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/example_group.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/extensions/instance_eval_with_args.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/extensions/kernel.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/extensions/module_eval_with_args.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/extensions/ordered.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/filter_manager.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/base_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/base_text_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/deprecation_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/documentation_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/helpers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/html_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/html_printer.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/json_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/progress_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/snippet_extractor.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters/text_mate_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/formatters.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/hooks.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/memoized_helpers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/metadata.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/metadata_hash_builder.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/mocking",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/mocking/with_absolutely_nothing.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/mocking/with_flexmock.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/mocking/with_mocha.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/mocking/with_rr.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/mocking/with_rspec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/option_parser.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/pending.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/project_initializer.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/rake_task.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/reporter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/ruby_project.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/runner.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/shared_context.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/shared_example_group",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/shared_example_group/collection.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/shared_example_group.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/version.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core/world.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/lib/rspec/core.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/License.txt",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/autotest",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/autotest/discover_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/autotest/failed_results_re_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/autotest/rspec_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/command_line",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/command_line/order_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/backtrace_cleaner_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/command_line_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/command_line_spec_output.txt",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/configuration_options_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/configuration_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/deprecation_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/deprecations_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/drb_command_line_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/drb_options_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/dsl_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/example_group_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/example_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/filter_manager_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/base_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/base_text_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/deprecation_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/documentation_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/helpers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/html_formatted-1.8.7-jruby.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/html_formatted-1.8.7-rbx.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/html_formatted-1.8.7.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/html_formatted-1.9.2.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/html_formatted-1.9.3-jruby.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/html_formatted-1.9.3-rbx.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/html_formatted-1.9.3.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/html_formatted-2.0.0.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/html_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/json_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/progress_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/snippet_extractor_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/text_mate_formatted-1.8.7-jruby.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/text_mate_formatted-1.8.7-rbx.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/text_mate_formatted-1.8.7.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/text_mate_formatted-1.9.2.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/text_mate_formatted-1.9.3-jruby.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/text_mate_formatted-1.9.3-rbx.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/text_mate_formatted-1.9.3.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/text_mate_formatted-2.0.0.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/formatters/text_mate_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/hooks_filtering_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/hooks_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/kernel_extensions_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/memoized_helpers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/metadata_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/option_parser_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/pending_example_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/project_initializer_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/rake_task_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/reporter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/resources",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/resources/a_bar.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/resources/a_foo.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/resources/a_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/resources/custom_example_group_runner.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/resources/formatter_specs.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/resources/utf8_encoded.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/rspec_matchers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/ruby_project_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/runner_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/shared_context_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/shared_example_group",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/shared_example_group/collection_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/shared_example_group_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core/world_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/rspec/core_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/spec_helper.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/config_options_helper.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/helper_methods.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/in_sub_process.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/isolate_load_path_mutation.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/isolated_directory.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/isolated_home_directory.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/matchers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/mathn_integration_support.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/sandboxed_mock_space.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/shared_example_groups.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.6/spec/support/spec_files.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/.document",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/.yardopts",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/Changelog.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/exe",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/exe/autospec",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/exe/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/Autotest.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/example_name_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/exit_status.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/format_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/init.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/line_number_appended_to_path.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/line_number_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/order.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/pattern_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/rake_task.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/require_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/ruby.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/tag.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/command_line/warnings_option.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/alias_example_to.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/backtrace_clean_patterns.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/custom_settings.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/default_path.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/deprecation_stream.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/fail_fast.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/failure_exit_code.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/order_and_seed.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/output_stream.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/pattern.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/profile.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/read_options_from_file.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/run_all_when_everything_filtered.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/show_failures_in_pending_blocks.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/configuration/treat_symbols_as_metadata_keys_with_true_values.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/example_groups",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/example_groups/basic_structure.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/example_groups/shared_context.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/example_groups/shared_examples.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/expectation_framework_integration",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/expectation_framework_integration/configure_expectation_framework.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/filtering",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/filtering/exclusion_filters.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/filtering/if_and_unless.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/filtering/inclusion_filters.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/formatters",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/formatters/configurable_colors.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/formatters/custom_formatter.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/formatters/json_formatter.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/formatters/text_formatter.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/helper_methods",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/helper_methods/arbitrary_methods.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/helper_methods/let.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/helper_methods/modules.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/hooks",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/hooks/around_hooks.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/hooks/before_and_after_hooks.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/hooks/filtering.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/metadata",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/metadata/current_example.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/metadata/described_class.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/metadata/user_defined.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/mock_framework_integration",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/mock_framework_integration/use_any_framework.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/mock_framework_integration/use_flexmock.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/mock_framework_integration/use_mocha.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/mock_framework_integration/use_rr.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/mock_framework_integration/use_rspec.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/pending",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/pending/pending_examples.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/spec_files",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/spec_files/arbitrary_file_suffix.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/step_definitions",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/step_definitions/additional_cli_steps.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/subject",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/subject/attribute_of_subject.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/subject/explicit_subject.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/subject/implicit_receiver.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/subject/implicit_subject.feature",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/support",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/support/env.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/support/rubinius.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/features/Upgrade.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/autotest",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/autotest/discover.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/autotest/rspec2.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/autorun.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/backtrace_cleaner.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/backward_compatibility.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/command_line.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/configuration.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/configuration_options.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/deprecation.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/drb_command_line.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/drb_options.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/dsl.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/example.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/example_group.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/extensions/instance_eval_with_args.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/extensions/kernel.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/extensions/module_eval_with_args.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/extensions/ordered.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/filter_manager.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/base_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/base_text_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/deprecation_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/documentation_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/helpers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/html_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/html_printer.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/json_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/progress_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/snippet_extractor.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters/text_mate_formatter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/formatters.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/hooks.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/memoized_helpers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/metadata.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/metadata_hash_builder.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/mocking",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/mocking/with_absolutely_nothing.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/mocking/with_flexmock.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/mocking/with_mocha.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/mocking/with_rr.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/mocking/with_rspec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/option_parser.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/pending.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/project_initializer.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/rake_task.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/reporter.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/ruby_project.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/runner.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/shared_context.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/shared_example_group",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/shared_example_group/collection.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/shared_example_group.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/version.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core/world.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/lib/rspec/core.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/License.txt",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/autotest",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/autotest/discover_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/autotest/failed_results_re_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/autotest/rspec_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/command_line",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/command_line/order_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/backtrace_cleaner_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/command_line_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/command_line_spec_output.txt",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/configuration_options_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/configuration_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/deprecation_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/deprecations_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/drb_command_line_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/drb_options_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/dsl_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/example_group_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/example_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/filter_manager_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/base_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/base_text_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/deprecation_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/documentation_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/helpers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/html_formatted-1.8.7-jruby.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/html_formatted-1.8.7-rbx.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/html_formatted-1.8.7.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/html_formatted-1.9.2.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/html_formatted-1.9.3-jruby.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/html_formatted-1.9.3-rbx.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/html_formatted-1.9.3.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/html_formatted-2.0.0.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/html_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/json_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/progress_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/snippet_extractor_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/text_mate_formatted-1.8.7-jruby.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/text_mate_formatted-1.8.7-rbx.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/text_mate_formatted-1.8.7.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/text_mate_formatted-1.9.2.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/text_mate_formatted-1.9.3-jruby.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/text_mate_formatted-1.9.3-rbx.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/text_mate_formatted-1.9.3.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/text_mate_formatted-2.0.0.html",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/formatters/text_mate_formatter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/hooks_filtering_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/hooks_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/kernel_extensions_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/memoized_helpers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/metadata_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/option_parser_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/pending_example_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/project_initializer_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/rake_task_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/reporter_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/resources",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/resources/a_bar.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/resources/a_foo.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/resources/a_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/resources/custom_example_group_runner.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/resources/formatter_specs.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/resources/utf8_encoded.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/rspec_matchers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/ruby_project_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/runner_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/shared_context_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/shared_example_group",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/shared_example_group/collection_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/shared_example_group_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core/world_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/rspec/core_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/spec_helper.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/config_options_helper.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/helper_methods.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/in_sub_process.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/isolate_load_path_mutation.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/isolated_directory.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/isolated_home_directory.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/matchers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/mathn_integration_support.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/sandboxed_mock_space.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/shared_example_groups.rb",
  "./.gem/ruby/2.1.0/gems/rspec-core-2.14.7/spec/support/spec_files.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/.document",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/.yardopts",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/Changelog.md",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/be.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/be_within.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/cover.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/end_with.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/equality.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/exist.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/expect_change.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/expect_error.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/have.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/include.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/match.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/operators.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/predicates.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/respond_to.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/satisfy.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/start_with.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/throw_symbol.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/types.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/built_in_matchers/yield.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/custom_matchers",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/custom_matchers/access_running_example.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/custom_matchers/define_diffable_matcher.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/custom_matchers/define_matcher.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/custom_matchers/define_matcher_outside_rspec.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/custom_matchers/define_matcher_with_fluent_interface.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/customized_message.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/diffing.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/implicit_docstrings.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/step_definitions",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/step_definitions/additional_cli_steps.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/support",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/support/env.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/support/rubinius.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/syntax_configuration.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/test_frameworks",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/test_frameworks/test_unit.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/features/Upgrade.md",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/deprecation.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/differ.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/errors.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/expectation_target.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/extensions/array.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/extensions/object.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/extensions.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/fail_with.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/handler.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/syntax.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations/version.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/expectations.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/be_close.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/base_matcher.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/be.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/be_instance_of.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/be_kind_of.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/be_within.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/change.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/cover.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/eq.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/eql.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/equal.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/exist.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/has.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/have.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/include.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/match.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/match_array.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/raise_error.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/respond_to.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/satisfy.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/start_and_end_with.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/throw_symbol.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in/yield.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/built_in.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/compatibility.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/configuration.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/dsl.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/extensions/instance_eval_with_args.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/generated_descriptions.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/matcher.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/method_missing.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/operator_matcher.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/pretty.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers/test_unit_integration.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec/matchers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/lib/rspec-expectations.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/License.txt",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/expectations",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/expectations/differ_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/expectations/expectation_target_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/expectations/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/expectations/extensions/kernel_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/expectations/fail_with_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/expectations/handler_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/expectations/syntax_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/expectations_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/base_matcher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/be_close_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/be_instance_of_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/be_kind_of_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/be_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/be_within_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/change_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/configuration_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/cover_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/description_generation_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/dsl_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/eq_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/eql_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/equal_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/exist_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/has_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/have_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/include_matcher_integration_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/include_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/match_array_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/match_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/matcher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/matchers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/method_missing_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/operator_matcher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/raise_error_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/respond_to_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/satisfy_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/start_with_end_with_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/throw_symbol_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/rspec/matchers/yield_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/spec_helper.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/support",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/support/classes.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/support/in_sub_process.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/support/matchers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/support/ruby_version.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.3/spec/support/shared_examples.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/.document",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/.yardopts",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/Changelog.md",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/be.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/be_within.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/cover.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/end_with.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/equality.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/exist.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/expect_change.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/expect_error.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/have.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/include.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/match.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/operators.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/predicates.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/respond_to.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/satisfy.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/start_with.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/throw_symbol.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/types.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/built_in_matchers/yield.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/custom_matchers",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/custom_matchers/access_running_example.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/custom_matchers/define_diffable_matcher.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/custom_matchers/define_matcher.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/custom_matchers/define_matcher_outside_rspec.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/custom_matchers/define_matcher_with_fluent_interface.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/customized_message.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/diffing.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/implicit_docstrings.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/step_definitions",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/step_definitions/additional_cli_steps.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/support",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/support/env.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/support/rubinius.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/syntax_configuration.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/test_frameworks",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/test_frameworks/test_unit.feature",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/features/Upgrade.md",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/deprecation.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/differ.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/errors.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/expectation_target.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/extensions/array.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/extensions/object.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/extensions.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/fail_with.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/handler.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/syntax.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations/version.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/expectations.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/be_close.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/base_matcher.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/be.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/be_instance_of.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/be_kind_of.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/be_within.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/change.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/cover.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/eq.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/eql.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/equal.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/exist.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/has.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/have.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/include.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/match.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/match_array.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/raise_error.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/respond_to.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/satisfy.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/start_and_end_with.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/throw_symbol.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in/yield.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/built_in.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/compatibility.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/configuration.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/dsl.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/extensions/instance_eval_with_args.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/generated_descriptions.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/matcher.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/method_missing.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/operator_matcher.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/pretty.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers/test_unit_integration.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec/matchers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/lib/rspec-expectations.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/License.txt",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/expectations",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/expectations/differ_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/expectations/expectation_target_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/expectations/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/expectations/extensions/kernel_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/expectations/fail_with_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/expectations/handler_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/expectations/syntax_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/expectations_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/base_matcher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/be_close_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/be_instance_of_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/be_kind_of_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/be_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/be_within_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/change_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/configuration_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/cover_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/description_generation_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/dsl_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/eq_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/eql_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/equal_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/exist_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/has_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/have_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/include_matcher_integration_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/include_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/match_array_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/match_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/matcher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/matchers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/method_missing_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/operator_matcher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/raise_error_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/respond_to_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/satisfy_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/start_with_end_with_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/throw_symbol_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/rspec/matchers/yield_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/spec_helper.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/support",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/support/classes.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/support/in_sub_process.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/support/matchers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/support/ruby_version.rb",
  "./.gem/ruby/2.1.0/gems/rspec-expectations-2.14.5/spec/support/shared_examples.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/.document",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/.yardopts",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/Changelog.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/argument_matchers",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/argument_matchers/explicit.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/argument_matchers/general_matchers.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/argument_matchers/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/argument_matchers/type_matchers.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations/allow_any_instance_of.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations/any_instance.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations/block_local_expectations.feature.pending",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations/call_original.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations/expect_any_instance_of.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations/expect_message_using_expect.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations/expect_message_using_should_receive.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations/receive_counts.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/message_expectations/warn_when_expectation_is_set_on_nil.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/method_stubs",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/method_stubs/any_instance.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/method_stubs/as_null_object.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/method_stubs/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/method_stubs/simple_return_value_with_allow.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/method_stubs/simple_return_value_with_stub.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/method_stubs/stub_chain.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/method_stubs/stub_implementation.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/method_stubs/to_ary.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/mutating_constants",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/mutating_constants/hiding_defined_constant.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/mutating_constants/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/mutating_constants/stub_defined_constant.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/mutating_constants/stub_undefined_constant.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/outside_rspec",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/outside_rspec/configuration.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/outside_rspec/standalone.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/Scope.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/spies",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/spies/spy_partial_mock_method.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/spies/spy_pure_mock_method.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/spies/spy_unstubbed_method.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/step_definitions",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/step_definitions/additional_cli_steps.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/support",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/support/env.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/support/rubinius.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/test_frameworks",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/test_frameworks/test_unit.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/features/Upgrade.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/any_instance",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/any_instance/chain.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/any_instance/expectation_chain.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/any_instance/message_chains.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/any_instance/recorder.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/any_instance/stub_chain.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/any_instance/stub_chain_chain.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/argument_list_matcher.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/argument_matchers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/configuration.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/deprecation.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/error_generator.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/errors.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/example_methods.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/extensions/instance_exec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/extensions/marshal.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/framework.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/instance_method_stasher.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/matchers",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/matchers/have_received.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/matchers/receive.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/message_expectation.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/method_double.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/mock.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/mutate_const.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/order_group.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/proxy.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/proxy_for_nil.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/space.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/standalone.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/stub_chain.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/syntax.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/targets.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/test_double.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks/version.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/rspec/mocks.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/spec",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/lib/spec/mocks.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/License.txt",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/and_call_original_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/and_yield_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/any_instance",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/any_instance/message_chains_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/any_instance_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/any_number_of_times_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/argument_expectation_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/at_least_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/at_most_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/block_return_value_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/bug_report_10260_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/bug_report_10263_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/bug_report_11545_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/bug_report_496_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/bug_report_600_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/bug_report_7611_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/bug_report_8165_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/bug_report_830_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/bug_report_957_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/combining_implementation_instructions_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/configuration_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/double_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/extensions/marshal_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/failing_argument_matchers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/hash_excluding_matcher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/hash_including_matcher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/instance_method_stasher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/matchers",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/matchers/have_received_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/matchers/receive_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/methods_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/mock_ordering_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/mock_space_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/mock_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/multiple_return_value_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/mutate_const_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/nil_expectation_warning_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/null_object_mock_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/once_counts_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/options_hash_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/partial_mock_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/partial_mock_using_mocks_directly_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/passing_argument_matchers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/precise_counts_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/record_messages_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/serialization_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/space_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/stash_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/stub_chain_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/stub_implementation_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/stub_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/stubbed_message_expectations_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/syntax_agnostic_message_matchers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/test_double_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/to_ary_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks/twice_counts_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/rspec/mocks_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.4/spec/spec_helper.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/.document",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/.yardopts",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/Changelog.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/argument_matchers",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/argument_matchers/explicit.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/argument_matchers/general_matchers.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/argument_matchers/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/argument_matchers/type_matchers.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations/allow_any_instance_of.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations/any_instance.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations/block_local_expectations.feature.pending",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations/call_original.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations/expect_any_instance_of.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations/expect_message_using_expect.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations/expect_message_using_should_receive.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations/receive_counts.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/message_expectations/warn_when_expectation_is_set_on_nil.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/method_stubs",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/method_stubs/any_instance.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/method_stubs/as_null_object.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/method_stubs/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/method_stubs/simple_return_value_with_allow.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/method_stubs/simple_return_value_with_stub.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/method_stubs/stub_chain.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/method_stubs/stub_implementation.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/method_stubs/to_ary.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/mutating_constants",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/mutating_constants/hiding_defined_constant.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/mutating_constants/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/mutating_constants/stub_defined_constant.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/mutating_constants/stub_undefined_constant.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/outside_rspec",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/outside_rspec/configuration.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/outside_rspec/standalone.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/Scope.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/spies",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/spies/spy_partial_mock_method.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/spies/spy_pure_mock_method.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/spies/spy_unstubbed_method.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/step_definitions",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/step_definitions/additional_cli_steps.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/support",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/support/env.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/support/rubinius.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/test_frameworks",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/test_frameworks/test_unit.feature",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/features/Upgrade.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/any_instance",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/any_instance/chain.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/any_instance/expectation_chain.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/any_instance/message_chains.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/any_instance/recorder.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/any_instance/stub_chain.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/any_instance/stub_chain_chain.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/argument_list_matcher.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/argument_matchers.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/configuration.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/deprecation.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/error_generator.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/errors.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/example_methods.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/extensions/instance_exec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/extensions/marshal.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/framework.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/instance_method_stasher.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/matchers",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/matchers/have_received.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/matchers/receive.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/message_expectation.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/method_double.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/mock.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/mutate_const.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/order_group.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/proxy.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/proxy_for_nil.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/space.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/standalone.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/stub_chain.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/syntax.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/targets.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/test_double.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks/version.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/rspec/mocks.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/spec",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/lib/spec/mocks.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/License.txt",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/README.md",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/and_call_original_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/and_yield_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/any_instance",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/any_instance/message_chains_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/any_instance_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/any_number_of_times_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/argument_expectation_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/at_least_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/at_most_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/block_return_value_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/bug_report_10260_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/bug_report_10263_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/bug_report_11545_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/bug_report_496_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/bug_report_600_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/bug_report_7611_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/bug_report_8165_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/bug_report_830_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/bug_report_957_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/combining_implementation_instructions_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/configuration_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/double_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/extensions",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/extensions/marshal_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/failing_argument_matchers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/hash_excluding_matcher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/hash_including_matcher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/instance_method_stasher_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/matchers",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/matchers/have_received_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/matchers/receive_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/methods_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/mock_ordering_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/mock_space_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/mock_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/multiple_return_value_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/mutate_const_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/nil_expectation_warning_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/null_object_mock_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/once_counts_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/options_hash_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/partial_mock_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/partial_mock_using_mocks_directly_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/passing_argument_matchers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/precise_counts_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/record_messages_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/serialization_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/space_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/stash_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/stub_chain_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/stub_implementation_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/stub_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/stubbed_message_expectations_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/syntax_agnostic_message_matchers_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/test_double_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/to_ary_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks/twice_counts_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/rspec/mocks_spec.rb",
  "./.gem/ruby/2.1.0/gems/rspec-mocks-2.14.6/spec/spec_helper.rb",
  "./.gem/ruby/2.1.0/specifications",
  "./.gem/ruby/2.1.0/specifications/benchmark-ips-1.2.0.gemspec",
  "./.gem/ruby/2.1.0/specifications/bundler-1.5.3.gemspec",
  "./.gem/ruby/2.1.0/specifications/diff-lcs-1.2.4.gemspec",
  "./.gem/ruby/2.1.0/specifications/diff-lcs-1.2.5.gemspec",
  "./.gem/ruby/2.1.0/specifications/gem-open-0.1.7.gemspec",
  "./.gem/ruby/2.1.0/specifications/rspec-2.14.1.gemspec",
  "./.gem/ruby/2.1.0/specifications/rspec-core-2.14.6.gemspec",
  "./.gem/ruby/2.1.0/specifications/rspec-core-2.14.7.gemspec",
  "./.gem/ruby/2.1.0/specifications/rspec-expectations-2.14.3.gemspec",
  "./.gem/ruby/2.1.0/specifications/rspec-expectations-2.14.5.gemspec",
  "./.gem/ruby/2.1.0/specifications/rspec-mocks-2.14.4.gemspec",
  "./.gem/ruby/2.1.0/specifications/rspec-mocks-2.14.6.gemspec",
  "./.git",
  "./.git/COMMIT_EDITMSG",
  "./.git/config",
  "./.git/description",
  "./.git/FETCH_HEAD",
  "./.git/HEAD",
  "./.git/hooks",
  "./.git/hooks/applypatch-msg.sample",
  "./.git/hooks/commit-msg.sample",
  "./.git/hooks/post-update.sample",
  "./.git/hooks/pre-applypatch.sample",
  "./.git/hooks/pre-commit.sample",
  "./.git/hooks/pre-rebase.sample",
  "./.git/hooks/prepare-commit-msg.sample",
  "./.git/hooks/update.sample",
  "./.git/index",
  "./.git/info",
  "./.git/info/exclude",
  "./.git/logs",
  "./.git/logs/HEAD",
  "./.git/logs/refs",
  "./.git/logs/refs/heads",
  "./.git/logs/refs/heads/book",
  "./.git/logs/refs/heads/filter_ansi_out",
  "./.git/logs/refs/heads/key-combos",
  "./.git/logs/refs/heads/master",
  "./.git/logs/refs/heads/multiple_queries",
  "./.git/logs/refs/heads/scoring_experiment_dev",
  "./.git/logs/refs/heads/scoring_redesign",
  "./.git/logs/refs/heads/tty_fix",
  "./.git/logs/refs/remotes",
  "./.git/logs/refs/remotes/charliesome",
  "./.git/logs/refs/remotes/charliesome/dont-truncate-search-if-longer-than-window",
  "./.git/logs/refs/remotes/charliesome/master",
  "./.git/logs/refs/remotes/charliesome/use-control-key-syntax",
  "./.git/logs/refs/remotes/koffeinfrei",
  "./.git/logs/refs/remotes/koffeinfrei/master",
  "./.git/logs/refs/remotes/koffeinfrei/tty_fix",
  "./.git/logs/refs/remotes/koffeinfrei/word-boundary-match",
  "./.git/logs/refs/remotes/marcomorain",
  "./.git/logs/refs/remotes/marcomorain/master",
  "./.git/logs/refs/remotes/marcomorain/select-no-matches",
  "./.git/logs/refs/remotes/marcomorain/test-filtered-search",
  "./.git/logs/refs/remotes/mavcunha",
  "./.git/logs/refs/remotes/mavcunha/master",
  "./.git/logs/refs/remotes/mavcunha/tty_fix",
  "./.git/logs/refs/remotes/michaelavila",
  "./.git/logs/refs/remotes/michaelavila/key-combos",
  "./.git/logs/refs/remotes/michaelavila/master",
  "./.git/logs/refs/remotes/michaelavila/tty_fix",
  "./.git/logs/refs/remotes/origin",
  "./.git/logs/refs/remotes/origin/master",
  "./.git/logs/refs/remotes/origin/scoring_redesign",
  "./.git/logs/refs/remotes/origin/tty_fix",
  "./.git/logs/refs/remotes/rschmitt",
  "./.git/logs/refs/remotes/rschmitt/fork",
  "./.git/logs/refs/remotes/rschmitt/master",
  "./.git/logs/refs/remotes/rschmitt/readme",
  "./.git/logs/refs/remotes/sharplet",
  "./.git/logs/refs/remotes/sharplet/master",
  "./.git/logs/refs/remotes/sharplet/no-choices",
  "./.git/logs/refs/remotes/sharplet/tty_fix",
  "./.git/logs/refs/remotes/sos4nt",
  "./.git/logs/refs/remotes/sos4nt/feature",
  "./.git/logs/refs/remotes/sos4nt/feature/cursor-keys",
  "./.git/logs/refs/remotes/sos4nt/master",
  "./.git/logs/refs/remotes/sos4nt/patch-1",
  "./.git/logs/refs/remotes/sos4nt/tty_fix",
  "./.git/logs/refs/stash",
  "./.git/lost-found",
  "./.git/lost-found/commit",
  "./.git/lost-found/commit/03eb973c4c01f89ae3d662e6a76ad971e3726b26",
  "./.git/lost-found/commit/0504837d1f5539b432b21b92b22e273d253e6d46",
  "./.git/lost-found/commit/0580bba3a5aa3d73ec3da2ca68a8ff03162bf1a3",
  "./.git/lost-found/commit/05e815fbd18dff9fa78f51608998b8bc9d7fda4d",
  "./.git/lost-found/commit/08c4fee8650e12ad3aa6a3515aaf968f8cb58068",
  "./.git/lost-found/commit/0a65ebd403065f1e6b4c2756103a0dfed7979d6a",
  "./.git/lost-found/commit/0cc171b417e971cde832bfd5e0299cb469e6bdd2",
  "./.git/lost-found/commit/0e2624dc03d0c58eea8989860d726b37f359643d",
  "./.git/lost-found/commit/0fc5bc9e3a2aa98ebef461bcba0d3c75506bdf53",
  "./.git/lost-found/commit/14f94e09f148aa8d8f6bc52aca039e49ac0a6a33",
  "./.git/lost-found/commit/1bbcf31fbb19ae0087c5b9a6cbc5ccd60edf43ee",
  "./.git/lost-found/commit/1c74812f130fbfd947519e20c9c95d1ebb21aa4b",
  "./.git/lost-found/commit/1de4cd1ec811a5fbe656d5d94cf48133cd66d3d2",
  "./.git/lost-found/commit/211998a695fa741e144208bdf87b172b41cc3041",
  "./.git/lost-found/commit/220b688f4ccb6c3e9b16db03b1fa367144c2b7ee",
  "./.git/lost-found/commit/24a07426f77c3f16391f90beaa7b8ab54145f745",
  "./.git/lost-found/commit/27b8b47f38fd805c648873fed7be3546f0215a4d",
  "./.git/lost-found/commit/298f74065f30509ee85be98e83632f827402b18f",
  "./.git/lost-found/commit/299e30d90a920923994e5fdcdffb8f78e907d122",
  "./.git/lost-found/commit/327d871101d4075069094e25f1c640846ff9b6bc",
  "./.git/lost-found/commit/32e68e9f0b98c6ad123258d6738f879b43d6bbf5",
  "./.git/lost-found/commit/33da098d704acc8628480d48c08dbb2b7f622c23",
  "./.git/lost-found/commit/35387310b791bf23053cd65a1569210a8649a38e",
  "./.git/lost-found/commit/38915c0491715f04a2679bcdc85ffeb7cdc0657f",
  "./.git/lost-found/commit/39ce99df34849c67fd2580b8133913233a1501df",
  "./.git/lost-found/commit/3d0dde4c2a76d37aaa2d617c0b311e6032b39ab1",
  "./.git/lost-found/commit/3d6a75e37fcff22dd9818034432ea852227f7a8f",
  "./.git/lost-found/commit/3e66df540fd88d35c66df119c19e08f30a117b57",
  "./.git/lost-found/commit/41a7022a3214ef50669a82702e0d4a7e476f1b8f",
  "./.git/lost-found/commit/4247f5aecd3f28080696035727892cea3efd6053",
  "./.git/lost-found/commit/4313c8b4111b53e3e207b680ed73a6bb85aab88a",
  "./.git/lost-found/commit/4593a3143fd735b7d680630da0c7e5c9cb189001",
  "./.git/lost-found/commit/4b8750d0ac0dd687b816948b3f9c7270ced4146e",
  "./.git/lost-found/commit/525e206a0ce04899c7a108e38c1c5a3c9a380f9c",
  "./.git/lost-found/commit/5276dd9e9299005c231689a9467957f0e2341f82",
  "./.git/lost-found/commit/5529092e7b5cae59ab0b0afc41fdaf57272ae165",
  "./.git/lost-found/commit/5b176fb4589da491b38dd474ff95b8e7a7ac4744",
  "./.git/lost-found/commit/5b86712f6689c0fcda8c8c3b508077d71136ac81",
  "./.git/lost-found/commit/5d49c469addf9ef1f18a911f84cd4039e3cb93f9",
  "./.git/lost-found/commit/5fbfd2475ce846da5be9ac52d44afea1c47daae3",
  "./.git/lost-found/commit/60ae6a4da97eb38e436779a1c8f3cbaa9c74b0c2",
  "./.git/lost-found/commit/61bea65fb6e0c335cc61180162af683aaa99ab2c",
  "./.git/lost-found/commit/63c2417afe207774007229677783b59557fabebe",
  "./.git/lost-found/commit/6743beb9fafc2846bb2e4a7332cadcdefb647bcc",
  "./.git/lost-found/commit/6d77b2690cec99b73874466666633e6d5bd3e119",
  "./.git/lost-found/commit/70e54d24ea4bc2114c5e470929a8c1f0b9fc222d",
  "./.git/lost-found/commit/71895a8199e8abb5aba7784c5077aab7887f2ae6",
  "./.git/lost-found/commit/73fa7b8705779ebd1314b71013214842c066f00e",
  "./.git/lost-found/commit/7498d5fa8ccafaeb44138811e9bf2bc2dfc587fe",
  "./.git/lost-found/commit/7a8af6818f39dff4fb1c595146d68c51e3fb7b70",
  "./.git/lost-found/commit/7d86432c6d75003ee1d31ab7bf7c8b3da7ca62b3",
  "./.git/lost-found/commit/7e16136b175883f35dbd93f8335e7b857712f174",
  "./.git/lost-found/commit/80399f08fd539ac4c361ec70fac771e20bf2fa83",
  "./.git/lost-found/commit/80e0d2fad41d8a04cb2b0f9b37cff4da2f4fd17a",
  "./.git/lost-found/commit/8173ae8d1b86dfc1833b0ef985201c96a5e9d910",
  "./.git/lost-found/commit/850124e12e3e3caf954dec5932142c7feaff24ed",
  "./.git/lost-found/commit/8733ac10bfe63a3fa35a42dfa2da8231811959df",
  "./.git/lost-found/commit/873f1405c8b4792dd2acedccfea72a694180d434",
  "./.git/lost-found/commit/8b4e7196afdae6d4aa8c02271f842bfe49d4d768",
  "./.git/lost-found/commit/95bab1a9923f27c5f4a0c19176efb472f4f8df5d",
  "./.git/lost-found/commit/974d362e05dd55738e14b41d60e0938f30feab1f",
  "./.git/lost-found/commit/9a175ca82f0475f85f875dc0ad95e99282592646",
  "./.git/lost-found/commit/a04818f88cbba5d38f2716463004a8720fbe6c88",
  "./.git/lost-found/commit/a0dce7b4f70ec807c0d42abce41b4ee7c55f1624",
  "./.git/lost-found/commit/a1351c46fd505347397e50731fa2a1392c4b095a",
  "./.git/lost-found/commit/a8ddc8d7b5f479721cc8d642e448afa262bfcca0",
  "./.git/lost-found/commit/ac0718496e32473b5f2f816ebbcbe3c43ee496d9",
  "./.git/lost-found/commit/af7b8908128ab8e3bb1dbf63b0d016a1ee825bea",
  "./.git/lost-found/commit/b0cffd1b60ad69feb1bd19e48772833df9fca9ae",
  "./.git/lost-found/commit/b32c623a49098aff266d9f29ea3b050da51a6fa6",
  "./.git/lost-found/commit/b32f404a81e4ae631cb1669bfbbed788ce008395",
  "./.git/lost-found/commit/b6660d83329ab536772b45598d14907e689b2d47",
  "./.git/lost-found/commit/b7869dead228e00b5644f1f7ee5c19f5b10d5155",
  "./.git/lost-found/commit/b9409e1eaef02a6f23e516f48f776c6676f590bb",
  "./.git/lost-found/commit/ba8524a3f867500e5609649d837ef67c3b0ff893",
  "./.git/lost-found/commit/bfa39e3afb1fed63bcfbded02d5958fba7894a05",
  "./.git/lost-found/commit/c27eb9b69e8b7f5c64d50090f0a969b95b942fc8",
  "./.git/lost-found/commit/c2b245838c4d43e7d3fa20f4f542159b2f771327",
  "./.git/lost-found/commit/c802a5f64aec9fb03bf2854aaf0e073ddd22c9ce",
  "./.git/lost-found/commit/c97f12bbb0ebc92f183073ddf0edf72b28560b92",
  "./.git/lost-found/commit/cfd492c73b217c63a8f9be6ac7f994a0f9cf5e9f",
  "./.git/lost-found/commit/d6c227ebb63f428cb3a1e6fee07d927bb206ab15",
  "./.git/lost-found/commit/d9c0baa3d14849c43aac680096325e0dd9a0ba11",
  "./.git/lost-found/commit/dac916b2f34d26107f69cdfe265ac3d6dcabeca6",
  "./.git/lost-found/commit/db60f95ef4bec54f4f0040e3e3617b5416ec1e9d",
  "./.git/lost-found/commit/db9984ee3874faddb2d6c880c80256d9d25a672f",
  "./.git/lost-found/commit/dd05f26b4dc7b7f7789c476a3e3a36d52853cc05",
  "./.git/lost-found/commit/ddbbbc570e02c3d82f4df512e9e5d37a32b01092",
  "./.git/lost-found/commit/e1562fc5c8f85bcdc6688abf4442aefd87fd3263",
  "./.git/lost-found/commit/e6c2d0fb0379ec112ad33e969e9c3867d57fc8bf",
  "./.git/lost-found/commit/e9841e25c1af085112f9c80d7ed907630ebc69f9",
  "./.git/lost-found/commit/eb12679e8835250776daf7dc66be8e5bf37c97ae",
  "./.git/lost-found/commit/eb776a9da6d31276517909296feb8734b95b804f",
  "./.git/lost-found/commit/ed05c80991c52387a07d581ff66772a43660a338",
  "./.git/lost-found/commit/f0272df64fbf1f68636164bc1709633a92ac19aa",
  "./.git/lost-found/commit/f0ffe31f8c57070312f6af60a64f5bbdcc9c5bdb",
  "./.git/lost-found/commit/f33498b937f59129e596b3db0c3953908ea69d32",
  "./.git/lost-found/commit/f6660489102c01a238c2a52dcff4926862cdfd51",
  "./.git/lost-found/commit/f7b2f13663654b1e77b0386e2b297153bda77153",
  "./.git/lost-found/commit/fb5b24d7779309792c958af35e9a2d6e65009e38",
  "./.git/lost-found/commit/fe1235d137c89d2c3853dab7851fb11e635fd8da",
  "./.git/lost-found/commit/ff3afc98d40cd2f1f341c3de78932fde1dcecdfc",
  "./.git/lost-found/commit/ff79ac18b75fcd9c0134d9f8c42fa6e2b6a2657e",
  "./.git/lost-found/other",
  "./.git/lost-found/other/007140bc4d0c543d2a12055c7467a1da45829625",
  "./.git/lost-found/other/0de298deb7b6f4b2327f75af1eb7a607cbaedc4a",
  "./.git/lost-found/other/1bc8fe8bc34666e32fb78d0987d26bec0d423f80",
  "./.git/lost-found/other/23978b0c49fcb2df9e9f8362d122ec948d716fdf",
  "./.git/lost-found/other/2f4f2f4abd53db527138a497fb6a46953c768e3c",
  "./.git/lost-found/other/2f584ccb93d46321fd0491ac75434919dd0ba2a8",
  "./.git/lost-found/other/31ff057710bf01f0aab7380f78164400a3aa6e8b",
  "./.git/lost-found/other/3b374d097fd855864e999a869d95e773421de5b4",
  "./.git/lost-found/other/3e4352a4e5474c452985764709adbc95f4c7a13c",
  "./.git/lost-found/other/4c222d54d01db4f57cda8a169b134e0d6919cf1b",
  "./.git/lost-found/other/5137c6bb5acd6ed0312328dba9602ed5baa8859e",
  "./.git/lost-found/other/5a281932d79ca3c1eb8538ab62ad989bb7e7e00e",
  "./.git/lost-found/other/632d12d955b931b6c806786004d75b58c572aa04",
  "./.git/lost-found/other/6760b0fee10c1e2797f425b6362fbde85ea855a1",
  "./.git/lost-found/other/6a67805dcd095948790e847c3006770386ee548d",
  "./.git/lost-found/other/6f64dca9fbcf1544878e2f8dfce77f56df8ffa1c",
  "./.git/lost-found/other/72ea5553e3f62a8096b2c2e3320ffbdf93152378",
  "./.git/lost-found/other/734e1ddb0fbd1aa8acf0d2cd1ad0d4d1ee26f408",
  "./.git/lost-found/other/74b790407d457e5c14c7bd075bfdfec6e0f189d0",
  "./.git/lost-found/other/775547aaa210ce6d7df4b7e722b3070002b4478b",
  "./.git/lost-found/other/803ba4b568449024269dc28c0b738e86c9382e0d",
  "./.git/lost-found/other/8a93b8778510c53923551f2720ebaf17cfc6ecb1",
  "./.git/lost-found/other/922785ff0ebb10f31b3bb4c3071fd6b1a604bc2e",
  "./.git/lost-found/other/96987c45f78a04e3deb9c15336f5cab0d82c82bc",
  "./.git/lost-found/other/98e798583772337da56e02864fade1267e017448",
  "./.git/lost-found/other/99636a74295091299978054acab85210693ccd18",
  "./.git/lost-found/other/a8591eb66b987a023c3bd2191cf9ef54696746c4",
  "./.git/lost-found/other/aa7cbca05860d98f08af801efbea255110bb8dc2",
  "./.git/lost-found/other/b3472fe00d00fffac612393f3eeefea78d26289b",
  "./.git/lost-found/other/c4025779188831d30e3a5147bbce1c5b0620402e",
  "./.git/lost-found/other/ca069a9b0f8505a1315d5d512ed38a31983b6f33",
  "./.git/lost-found/other/d61b94e47eb4da2127e30017d12f620217508bc0",
  "./.git/lost-found/other/df6ee2ecf8ff541a08fe79efda007b6a7d5ac056",
  "./.git/lost-found/other/e031777e6dd8bb5a9b38f0bba64a38e5ec76b92d",
  "./.git/lost-found/other/e69de29bb2d1d6434b8b29ae775ad8c2e48c5391",
  "./.git/lost-found/other/ed13b9e2b9c2f063ade92819e13fe635c209f4e7",
  "./.git/lost-found/other/f50d0f07f0ede468d6b2bd1f53ace46edd127393",
  "./.git/lost-found/other/ff5dc593382f574bc54140d5d1c216ee4a469189",
  "./.git/objects",
  "./.git/objects/00",
  "./.git/objects/00/23d5e14641dd7eb78dde6bc53028bfdb7c56ee",
  "./.git/objects/00/3d12b57d40d2d60f751763cd282cf6595ada7a",
  "./.git/objects/00/58b671f9d820dfcb318f6915b455e78d57fc29",
  "./.git/objects/00/590f99ebee8bb31cafadf4aa05625f68c02eb0",
  "./.git/objects/00/5f4a73c46b7a1ee52499c3099f89d0b50435a7",
  "./.git/objects/00/7140bc4d0c543d2a12055c7467a1da45829625",
  "./.git/objects/00/bd1bb541ba38d8787e4fa629750b94ec3c9389",
  "./.git/objects/00/ca033512cbd210420d676a88420b213ed5661f",
  "./.git/objects/00/f9f19acf01888fbc2ef07d681cfb2594d57b11",
  "./.git/objects/01",
  "./.git/objects/01/0a170750a34c2577fdd4121604c08c15f582fc",
  "./.git/objects/01/24053b715002156127253cdd3f723aed4f5653",
  "./.git/objects/01/47688d3be5b289c96de0dd6ff0e3649eba885d",
  "./.git/objects/01/a82d7ec82aa33d095f5260080d3937e342212c",
  "./.git/objects/01/b4a4433f6c32ac1006898f0c2b147447065556",
  "./.git/objects/01/c500d4aac366c5025bb8a09d5bca23cd29fb1d",
  "./.git/objects/01/cc0bb24117b42f1c209aee312ccc12c10c636f",
  "./.git/objects/01/e2d3ad85ac04a3376d2de92a99ba5fb8a3384c",
  "./.git/objects/01/edfac30915e37452301a5ce7a376bc58fdef8d",
  "./.git/objects/02",
  "./.git/objects/02/192596ff10285a2a0577f2d3fdeb359e14b170",
  "./.git/objects/02/db54cb6299d297b4146b0f10c144d3dccaebf7",
  "./.git/objects/02/ed0d0f74be29b41a8217661af46c6e9c910d05",
  "./.git/objects/03",
  "./.git/objects/03/51b27f6cfc160e259930f88228a6b86c7a6f8b",
  "./.git/objects/03/a40eb05099f409de5a50def4117e8c09121fe7",
  "./.git/objects/03/b8b1e2e7bf6c91455952d83b38812856337973",
  "./.git/objects/03/dd65384f5d350383f5e74e3fa640f980ad532d",
  "./.git/objects/03/eb973c4c01f89ae3d662e6a76ad971e3726b26",
  "./.git/objects/04",
  "./.git/objects/04/0a0331806a068fc4bbb4d3c084aae3dbc0e4d4",
  "./.git/objects/04/93e04b327dec7293afead85feb4cc25726cfac",
  "./.git/objects/05",
  "./.git/objects/05/04837d1f5539b432b21b92b22e273d253e6d46",
  "./.git/objects/05/0db6c6320863289eea5577167ad2f59cde2422",
  "./.git/objects/05/52b69059b7a52c4aba2c1a0be238982cce8cc3",
  "./.git/objects/05/80bba3a5aa3d73ec3da2ca68a8ff03162bf1a3",
  "./.git/objects/05/c720dad13efda93cd455a127d8ab7fdba3d60a",
  "./.git/objects/05/e815fbd18dff9fa78f51608998b8bc9d7fda4d",
  "./.git/objects/05/f223c3d5ee5ce2f97b4cc991e84b71b0d0bb11",
  "./.git/objects/06",
  "./.git/objects/06/09b4eb1f275be9d6a50a999d4b7cb0fdd80c7d",
  "./.git/objects/06/2ef29a4469934259fadd741c100c3d32de3d45",
  "./.git/objects/06/5658dc8b7fc2dbd9fa62224d4bfaacb7154db0",
  "./.git/objects/06/5d006d036a227a251808806c440f3e2020224d",
  "./.git/objects/06/98d6b617fec5b14b2aedc3a1a3d85db45676b7",
  "./.git/objects/06/a354e67dc254e0b437fd25d68de098fd424ef5",
  "./.git/objects/06/c32c240210f63a3163bdef6db3c3434a9871b9",
  "./.git/objects/07",
  "./.git/objects/07/2eab9ce5917fe158ed4677271ddcdee4fa7750",
  "./.git/objects/07/43bbd697f87e7d7c0e874351c82871a719886d",
  "./.git/objects/07/71a22029e3fdd70d1611cd5fa942e385510d38",
  "./.git/objects/08",
  "./.git/objects/08/450acf9fcdadc51900e756143935eceabb093d",
  "./.git/objects/08/6594678e9f0d2bb7483b6a455b4d4f4c6eb5c7",
  "./.git/objects/08/78397c5ada5a245e86cdb6572dced288317f57",
  "./.git/objects/08/8fa70171662dff328e201dcfc67e517d9bb2c3",
  "./.git/objects/08/bec5a42eddb4f6812b9a4542c5e6b5d2666991",
  "./.git/objects/08/c4fee8650e12ad3aa6a3515aaf968f8cb58068",
  "./.git/objects/08/dc24eb079778ce79e0d27e35f074bf55ffe549",
  "./.git/objects/09",
  "./.git/objects/09/587851215044f883752b4a8f60863d86477576",
  "./.git/objects/09/80e5a3a3a0c430e84f7db827ce680f08ed6a8c",
  "./.git/objects/09/a0820fa06e05ffce849bd21904300e97d65ee0",
  "./.git/objects/09/cea1ee02b2aaafcce3730f760f11da0d1a5655",
  "./.git/objects/09/f5b2f2135de5a7194497bfb1d42e6735f20f20",
  "./.git/objects/0a",
  "./.git/objects/0a/65ebd403065f1e6b4c2756103a0dfed7979d6a",
  "./.git/objects/0a/7cee5d935ec670d9c4e8f7a5938c955962f93f",
  "./.git/objects/0a/def42d975cf6f6bc9580b26ad5e71e13dcae6f",
  "./.git/objects/0b",
  "./.git/objects/0b/055aad0e3b4690f101df5c116250fc27524a1b",
  "./.git/objects/0b/27dae5e40bf58500b0dce508418130d8233997",
  "./.git/objects/0b/2dc7e0b276a25479a4b53de15860c3091fff14",
  "./.git/objects/0b/b56c0218d5397a1dc668e8361f79057b6d9e14",
  "./.git/objects/0b/c54b4c39d30108bc1024aee6971eeb9ee2441c",
  "./.git/objects/0c",
  "./.git/objects/0c/072f92003f6afa9479aed0f3cf1db122212e7b",
  "./.git/objects/0c/41cc86d77df44e9bc3de8dc74d3e29c6a159c6",
  "./.git/objects/0c/7d6cf6df80f59c964632973980f8ace23f431b",
  "./.git/objects/0c/89993c73a56eb7b334092f7e4e165dd295d684",
  "./.git/objects/0c/bda286777584f665c94c4f267717f16b9703d1",
  "./.git/objects/0c/c171b417e971cde832bfd5e0299cb469e6bdd2",
  "./.git/objects/0c/e1d2bbf67091d968093af8739b321ed72bfe20",
  "./.git/objects/0d",
  "./.git/objects/0d/1f50238da81f638fd61b4d4f0fc42d0db753a6",
  "./.git/objects/0d/4dde48d3fc2673154b2c3f7bbdfa4560246079",
  "./.git/objects/0d/7ce7969b53ae139e90315d482ef373b39c7fdd",
  "./.git/objects/0d/9fa8bb95ad2e9c13c1637010abc97dbd917849",
  "./.git/objects/0d/e298deb7b6f4b2327f75af1eb7a607cbaedc4a",
  "./.git/objects/0e",
  "./.git/objects/0e/06dd3497f3cbbd36fcdacda0345f68472d84c4",
  "./.git/objects/0e/25dcb146b816f2976e2158a07dd01eba308579",
  "./.git/objects/0e/2624dc03d0c58eea8989860d726b37f359643d",
  "./.git/objects/0e/8691a284c1ec3c260f77e494554b3b48b0b2e8",
  "./.git/objects/0e/ab28bbd20e07b3ec2f8dc71c19704e0352d117",
  "./.git/objects/0e/aef6825e6efd251193945e21ceb9c5c22d9973",
  "./.git/objects/0e/e63f2ad090fba145640fc383ae21d11ca685a2",
  "./.git/objects/0f",
  "./.git/objects/0f/1c3fa45ebe4a42933aee91b6c28db89402b366",
  "./.git/objects/0f/34eb9c0f38091ceafcfb8275d4e2d5ff3ecf70",
  "./.git/objects/0f/93a4a0d4e23beef15022fdcb8448cc1698100b",
  "./.git/objects/0f/c4fdfb24cab2dd012542f32cdbe902cd716629",
  "./.git/objects/0f/c5bc9e3a2aa98ebef461bcba0d3c75506bdf53",
  "./.git/objects/10",
  "./.git/objects/10/1dcac19b306f54dde36316cc2a24821b9e1be8",
  "./.git/objects/10/2aab53b1cc554d25c791aa7ccb06d92e671ffd",
  "./.git/objects/10/38dcd8d5c5a536c7b677f478a8f6e60462a752",
  "./.git/objects/10/64513a10531e3a021f879cc6e94b64f6dc747e",
  "./.git/objects/10/864966d56bd712d374c9ba2ab1a775cce99e04",
  "./.git/objects/11",
  "./.git/objects/11/116673ce8fce9aba0266f552470364808175be",
  "./.git/objects/11/259b70655c543272b744a64dd77eca75d5f82b",
  "./.git/objects/11/406587f7a1b64725c7109438cb2a5d5097cd47",
  "./.git/objects/11/5c0520f6241d366c9d1f4fc04fb635b35995f6",
  "./.git/objects/11/afb999efde7ced7ff2793b2cda1642226f948f",
  "./.git/objects/12",
  "./.git/objects/12/191a26fd727f32677f5696ca4a032c5454a9e3",
  "./.git/objects/12/30448b7e795b3ce1e29c9a4ef4d40ac0e5b5a8",
  "./.git/objects/12/de53c73b49a5c3e37f88b69f81291cfb6a6414",
  "./.git/objects/13",
  "./.git/objects/13/213487436eeef5aeb5a262269a6285218db815",
  "./.git/objects/13/285e7ee470af36226824ad9c005869b8fabc3e",
  "./.git/objects/13/2c79b24a0375f55f368eb3401b2296132d6b42",
  "./.git/objects/13/3fc8243451df34456c5f083c59075640920118",
  "./.git/objects/13/5a4bf4ebf1f702c0f38a6c369e56ca42d62e95",
  "./.git/objects/13/9a2b1b2bb414c5e01231eeccca1cef7ac4e636",
  "./.git/objects/13/db9b6157509964a036bc19f0ed821403402b30",
  "./.git/objects/14",
  "./.git/objects/14/0f413fd80297f530d009f76c5c4c84852eb7bd",
  "./.git/objects/14/f94e09f148aa8d8f6bc52aca039e49ac0a6a33",
  "./.git/objects/15",
  "./.git/objects/15/11299ecd5f9124feff4c47e6dd1ae82f7a1810",
  "./.git/objects/15/423256e70368a1e83efafdac4416aaebef0606",
  "./.git/objects/15/4deb4bb618591b36945603106c1aab6fc8aecc",
  "./.git/objects/15/548341bcf4b5a5524183ac506a98ca4c60873b",
  "./.git/objects/15/753cc21b5de0a26505a4b1a6621cefe340405c",
  "./.git/objects/15/c4d2a9405f799a2048fa3526f37ce4d0e0be4f",
  "./.git/objects/15/c80f6ff560377eafa285318cd05741c127f3f6",
  "./.git/objects/16",
  "./.git/objects/16/67d6006efb16e5d799bcb599750e5037c8f145",
  "./.git/objects/16/9454301518fa4684894d9f3a3d5e3052ed1ec0",
  "./.git/objects/16/9c84dc3f45ebd18e0961e29e0ae0bf607fcd3d",
  "./.git/objects/16/a6fe9bf8d4560b42e8825ea63daa7234e98513",
  "./.git/objects/16/e3c26f896be9b0bb2354aa3c5c4f8049c33cac",
  "./.git/objects/16/fdf5a18c9236ab2490eb6f571af5c2eeabf807",
  "./.git/objects/17",
  "./.git/objects/17/3b09db0ed012ba85b6e8bd0789b746c2c6a758",
  "./.git/objects/17/4d9c1dfb738ea2f1c41d23f57e5155f0778b7a",
  "./.git/objects/17/7b8ef0d25c9832c00c0f77e8e18f5ae09594bf",
  "./.git/objects/17/8376bd2f2cd4810dc8e42e0b713a6855aa5eb4",
  "./.git/objects/17/be15471dbf9af4a34e598fa8302114d9ab88fd",
  "./.git/objects/18",
  "./.git/objects/18/4b6a85a54a87d26d58e6b5f836079c1fe01eb0",
  "./.git/objects/18/83eeaa55fe88a0d9145af07bbfd56d572140f0",
  "./.git/objects/18/954ccb4e5cc9f5507f03d33929a3248d97f841",
  "./.git/objects/19",
  "./.git/objects/19/35be9138a6f184eb8f3b9ee64f93d5fdc933bf",
  "./.git/objects/19/4cf57dd7faa73f8ab669fac262a3c710e79221",
  "./.git/objects/19/fb9e48f3ef024ab92ba1af31e0e85967202393",
  "./.git/objects/1a",
  "./.git/objects/1a/0282d8c812c22061166d4302f0b17c37e57a17",
  "./.git/objects/1a/1aeadab7933b1a93fd891f6f26fd7ff1762c29",
  "./.git/objects/1a/46d514bbabbe573ed1de5b62fb20af1ceeb73a",
  "./.git/objects/1a/559f8fae0a628dfc775b4ba04c02aedc2b68dd",
  "./.git/objects/1a/a9528563b4abd386045024ab63c4aad48b91b9",
  "./.git/objects/1a/de8c5d93ba16b270d11276a84daefe1a014e4c",
  "./.git/objects/1b",
  "./.git/objects/1b/31dd31f6e4c6926be0a24987a4fb715c1dc2a0",
  "./.git/objects/1b/976e9d59b052dbb1927935be453a74abf89c79",
  "./.git/objects/1b/9c0e497a84fc1239b4e318e5a42a8b3a4b45c8",
  "./.git/objects/1b/bcf31fbb19ae0087c5b9a6cbc5ccd60edf43ee",
  "./.git/objects/1b/c8fe8bc34666e32fb78d0987d26bec0d423f80",
  "./.git/objects/1c",
  "./.git/objects/1c/25650e5cd704785a77bca17910b590d4642c8b",
  "./.git/objects/1c/69fce1083c2b6b340b42e1e18d641f3d36d9c4",
  "./.git/objects/1c/74812f130fbfd947519e20c9c95d1ebb21aa4b",
  "./.git/objects/1c/92f637cb3172c4fbb07c677935dded0ffea63d",
  "./.git/objects/1c/db7342c8b78532dadf3a37445710beab73da2a",
  "./.git/objects/1d",
  "./.git/objects/1d/0e62e0fb5d2576c5aaae3107ffaeeff6a5268f",
  "./.git/objects/1d/1d7b198d9f14aa951a7e31669564726bd6389a",
  "./.git/objects/1d/419ea3dc662b39a9ff804952a85730b9236d07",
  "./.git/objects/1d/43c3c7e3f2905f25e9b88bf33eed80bc8b4c32",
  "./.git/objects/1d/6037ad97ef22d4416206d845219b3568fb25d5",
  "./.git/objects/1d/66e20ef7ccb5f3887e1127742bcd88805265a9",
  "./.git/objects/1d/aaaff70f4dd300eff9005c2aa771708b31ed9d",
  "./.git/objects/1d/d7f2d650375711a89705ebb26ecfafcf8a3aea",
  "./.git/objects/1d/e4cd1ec811a5fbe656d5d94cf48133cd66d3d2",
  "./.git/objects/1d/ebc02d45f49b086ab01a0b1343d936f332b4ce",
  "./.git/objects/1e",
  "./.git/objects/1e/18b5613019348a8ef6d8e9fefcbe11d66cd870",
  "./.git/objects/1e/436d8a0357064cbc24521ce54f3723ff315baa",
  "./.git/objects/1e/52e4b9d8f0a272512a73188c37a302d27f3fa6",
  "./.git/objects/1e/d1961e08fc6a19e6b2094d715ab201f069f1bf",
  "./.git/objects/1e/fac5a9569524de421c9f95e23287e9ec6446dd",
  "./.git/objects/1f",
  "./.git/objects/1f/29c4fa006595deb9da81984c397fd21ee1fcc5",
  "./.git/objects/1f/fa6a3fb93eacf9ca5ecbee46fa0e16a7d8b0e4",
  "./.git/objects/20",
  "./.git/objects/20/74b59794e313256211ce8d4fffa25bf40f25ca",
  "./.git/objects/20/b2380a00a089bc911ebacdd2dc307198b8d43e",
  "./.git/objects/20/e3b187dc0f81ea2b3470a033aa288a78565a45",
  "./.git/objects/20/fa6568c22745a431d3d75fa10c3210be8f0eff",
  "./.git/objects/21",
  "./.git/objects/21/0ea2d1b45a0b6def1e6e1fc0b281094f7e68dc",
  "./.git/objects/21/1998a695fa741e144208bdf87b172b41cc3041",
  "./.git/objects/21/2b7a69ff4ded9486bdb4b2309cbb40e9bb7d00",
  "./.git/objects/21/427ded8b3acd53013a1ae6f0b963255fbed00b",
  "./.git/objects/21/c2f0c1e26f149dc949970a6accdab168837b41",
  "./.git/objects/22",
  "./.git/objects/22/0b688f4ccb6c3e9b16db03b1fa367144c2b7ee",
  "./.git/objects/22/1a199b425bd06e31da63dada142ef4f024d14e",
  "./.git/objects/22/e865a75108b96ce533a665ae670b2397b91c69",
  "./.git/objects/22/ef688d40031cceb6f7e354cc78eec242697a13",
  "./.git/objects/23",
  "./.git/objects/23/377461420fd62bbb66d3b5c72d8345148edde4",
  "./.git/objects/23/553d4e40ea2576f61be86722e550e18dbf9519",
  "./.git/objects/23/7871b91e674717f63ae80c4c9fb954ba5171c9",
  "./.git/objects/23/978b0c49fcb2df9e9f8362d122ec948d716fdf",
  "./.git/objects/23/f43c642e84babfe36242697895f352109e2ce3",
  "./.git/objects/24",
  "./.git/objects/24/6199f4c1aa5ad6692f1bc4feb44b11a5d02026",
  "./.git/objects/24/7a71da3409d8aa3b85b8e01ef4e25d49b2c1b9",
  "./.git/objects/24/973f86720d593639f5f01627ac5c4f63810d0d",
  "./.git/objects/24/a07426f77c3f16391f90beaa7b8ab54145f745",
  "./.git/objects/24/be5eda13ff10095bb2a658d05a0e54f712c71e",
  "./.git/objects/24/beae543bc0ee098bd06d2d8641b9c510d459e1",
  "./.git/objects/24/c476e0fb2c3f5ebd3fe5cf4d9ccb8094d2f922",
  "./.git/objects/24/d31400121e3cb8ad06baa5799640e814e40531",
  "./.git/objects/25",
  "./.git/objects/25/211a0f98122fb3c7f9e89ad2dfcd338e09f4dc",
  "./.git/objects/25/3684527e153c800c7c04288470066beb32eb90",
  "./.git/objects/25/3a251476ce1d6987211bab7f27f620c152a7f4",
  "./.git/objects/25/7da2f7cc6576031a94ae9d16138fbc467c6052",
  "./.git/objects/25/deb416b613e4c320b5f75b8abec3d54323da27",
  "./.git/objects/25/ff0c1c294622904e31ab2ad2057b235eab44b0",
  "./.git/objects/26",
  "./.git/objects/26/9a54b849a22e5e96d9ce700b0a8e648b3979f2",
  "./.git/objects/26/b2ab7a30276ddc95f6ca65a3921da700e8309c",
  "./.git/objects/26/d832b555601be8cb4559f8d3708420e42c73d1",
  "./.git/objects/26/ddb167d0c48110e4c8e10479cdac50f3baa2d8",
  "./.git/objects/26/f29951a989a63d321a218c304927c049dc8659",
  "./.git/objects/27",
  "./.git/objects/27/369a7f0bf644071119de1cbf415050cbeaa456",
  "./.git/objects/27/37235cf45a157904a4bc916cd33317c69769c9",
  "./.git/objects/27/8696f970eb20cb69ee388404ac483a304c6e56",
  "./.git/objects/27/b1804d218b7692d4ac88a9e3dd1ccd4c59eca3",
  "./.git/objects/27/b8b47f38fd805c648873fed7be3546f0215a4d",
  "./.git/objects/28",
  "./.git/objects/28/1d7ca81fa264e07fa4bd7ec7ba9736e5a7b571",
  "./.git/objects/28/62c46b057e8d8664c420e37f6604e2f6c98412",
  "./.git/objects/28/930a71badcd6c108686c902dff79722aae3677",
  "./.git/objects/29",
  "./.git/objects/29/02b49e0254da8458d713aa43ea41caef75c77e",
  "./.git/objects/29/8f74065f30509ee85be98e83632f827402b18f",
  "./.git/objects/29/9e30d90a920923994e5fdcdffb8f78e907d122",
  "./.git/objects/29/9f8380012924cd18a56f7628e530dfd2294fc0",
  "./.git/objects/29/b5f8273fcaa2d0e36104b0155b3d3f6c4e30e2",
  "./.git/objects/2a",
  "./.git/objects/2a/022a16574f510ca81361fa76aca4c806f1ad01",
  "./.git/objects/2a/288f1882b3cabbd9121a2ccbd741b966eed1b7",
  "./.git/objects/2a/384f272656e6d4897040471d9b6393ec1a0a7c",
  "./.git/objects/2a/932fc779d499005c1d42a0f4aa58d2366234be",
  "./.git/objects/2a/f3684453365eebfddf5156e95c32878a3fcc84",
  "./.git/objects/2b",
  "./.git/objects/2b/47483e5d8ba9d2b28811c7d63d866a0361b02b",
  "./.git/objects/2b/6117ca99105c44350c87a2d00095df43fdeb2c",
  "./.git/objects/2b/b6a33f6deb1bc529864c9f9e2a520d4c9f8e86",
  "./.git/objects/2b/cfe61d60c9d159c98afbc642a11501758e7dbd",
  "./.git/objects/2c",
  "./.git/objects/2c/3d2c6565b331a4befc8d12b3745a95e1c7674c",
  "./.git/objects/2c/3d2e9c02b73b1d988fe49f8eaf5c942114356f",
  "./.git/objects/2c/83cd379b33f870f9762c6517c6925cdade110d",
  "./.git/objects/2c/973da688ad83f66184facce92beb1d5929fa42",
  "./.git/objects/2c/a168aaa2024e765ed849ef651b3427633bc78c",
  "./.git/objects/2c/e135e3f64af8be3b51e8461cc8cfd15bae2e40",
  "./.git/objects/2c/f0693ba49db8622193b0bc25a95570300427cd",
  "./.git/objects/2c/f84854d374c28c0a41abacc77feae384b86386",
  "./.git/objects/2d",
  "./.git/objects/2d/443d6c7d9a3d1a3b603cf0ed839150cb43dbc3",
  "./.git/objects/2d/59b8c19967747266629104b5a4201da8f5ab90",
  "./.git/objects/2d/64b7f796c47e80cd86ca2ab0f29d9aaa6d143e",
  "./.git/objects/2d/d9320bac5451c3047ce9f056db83b686901c5c",
  "./.git/objects/2d/e69770f782094ba9c11846b78e1189976313d7",
  "./.git/objects/2d/fdb57156f077a7d6f94f7f86b6f56a93d46644",
  "./.git/objects/2e",
  "./.git/objects/2e/5ced9c69e31f848323054483b323a2c55ac7d9",
  "./.git/objects/2e/64be6a7a62455a71413ec4d2d29cb2197f4d95",
  "./.git/objects/2e/7877c52b395003885b631c92df76902d5aa771",
  "./.git/objects/2e/94c148f6055e0f1332a0debc45a21767d5bd39",
  "./.git/objects/2e/9df9c73c533965f970011554d08ad0a3e95943",
  "./.git/objects/2e/b2d0b42b62e04a72ac165e4b66d3ad2ff63ed9",
  "./.git/objects/2e/ef5fbbfc6ed332ca39626b4494ab5ee5c55aa8",
  "./.git/objects/2f",
  "./.git/objects/2f/0ab25d464925b0e58daa73d49ef30c30a81713",
  "./.git/objects/2f/39c111e3d3173f440cd5dd7d5fb6dee580dbb3",
  "./.git/objects/2f/4f2f4abd53db527138a497fb6a46953c768e3c",
  "./.git/objects/2f/584ccb93d46321fd0491ac75434919dd0ba2a8",
  "./.git/objects/2f/78875b7df2b2a573d11b72b9efa142aabcf05c",
  "./.git/objects/2f/7f7e1f961133a7a1b1aa4219c557fe753223ab",
  "./.git/objects/2f/a1f1293d6942b8d827274aebbfeea6b9b70878",
  "./.git/objects/2f/c0441e630c8543ab110f1c63261f7f370fb5a0",
  "./.git/objects/2f/f20c1f902044b589375fbcd645b8487d77a418",
  "./.git/objects/30",
  "./.git/objects/30/1e7016376cabe4909e7b1448b03ce683f59935",
  "./.git/objects/30/5b9283f1d28cd5c72216d72076d511b73e22f2",
  "./.git/objects/30/6a95eb2c3d1b6073f3543a0674445d61e74eee",
  "./.git/objects/30/868a500d89d6ec65f65dd447b2862041187d04",
  "./.git/objects/30/a1fabecb0004f6a67d406973df7fe4c4c2ecdf",
  "./.git/objects/30/c4ee62e61b7a1e3b0ed6a1fa38bb7706e724da",
  "./.git/objects/30/cd41cf34e9ea33a649365f3877bb21b42095d3",
  "./.git/objects/31",
  "./.git/objects/31/011ae72764201a36a42b1bc4e989c460081bda",
  "./.git/objects/31/06236cd5402a72f6152b0a3bc48f9cc5b4434e",
  "./.git/objects/31/19882ff2aba0bf25c8b9f8516fda28960ca254",
  "./.git/objects/31/ff057710bf01f0aab7380f78164400a3aa6e8b",
  "./.git/objects/32",
  "./.git/objects/32/401759e1f22c70622e982d1fb21244989c60dc",
  "./.git/objects/32/73e60ffa3d8398252443c977439c018765baf6",
  "./.git/objects/32/7d871101d4075069094e25f1c640846ff9b6bc",
  "./.git/objects/32/ccbfcb1df3925f1b155775d296b6bcfbce5ff5",
  "./.git/objects/32/e68e9f0b98c6ad123258d6738f879b43d6bbf5",
  "./.git/objects/32/ffa05651f39b80c6e97958edccb967b9f48249",
  "./.git/objects/33",
  "./.git/objects/33/2783ac8adfd1f2ea004a1bc9df336db4d1c321",
  "./.git/objects/33/347dafe67b571bec544b4f703fd676e5e0b47e",
  "./.git/objects/33/39c5d5ab0c857323b40c34a7e86f93906fb155",
  "./.git/objects/33/72f6880c05ccb24b63f1bc4256c153844ad1c9",
  "./.git/objects/33/c95aa94fa87ca925ca186c2112ee44dfe00532",
  "./.git/objects/33/cedace29e842ec28fc8ecbff3634e195294f47",
  "./.git/objects/33/da098d704acc8628480d48c08dbb2b7f622c23",
  "./.git/objects/33/f14df8770af80aa4c3c1c0a473b08305c8932e",
  "./.git/objects/33/fedd7087e60a91ebd632842595d6853f3b4d46",
  "./.git/objects/34",
  "./.git/objects/34/a7f9ceb502d03626fc80399a838c1102481181",
  "./.git/objects/34/e9e4a44121a388f7b1d444d32e067f0ece82ea",
  "./.git/objects/35",
  "./.git/objects/35/387310b791bf23053cd65a1569210a8649a38e",
  "./.git/objects/35/478042bbb43f2c22ca10e113d1d14e1903b40f",
  "./.git/objects/35/5660a74731787ab801d3f0b3eba1a9bb513581",
  "./.git/objects/35/8ed37fec765bdbb5d8c85d0ac2f6c0d7608e82",
  "./.git/objects/35/df7aaddf751743c1b3004c05042fc8c0c5918e",
  "./.git/objects/35/e826b202e52ecf353aef36429005a3c0daac69",
  "./.git/objects/35/ef110858530ce547987fa084957e66757b2eff",
  "./.git/objects/36",
  "./.git/objects/36/0829829549de0e5cf29b90307ff5b8bdc1be1a",
  "./.git/objects/36/19f5a054ecb8c5eb19f37d974b2ed17e15a6e6",
  "./.git/objects/36/369b642e34c0ee2435608d254e07091c623037",
  "./.git/objects/36/43a39647f2bb0b17127a8a1482dcdb6c89b8ec",
  "./.git/objects/36/b48df6a5513cece4aee03fb8c2197eab3b0f3f",
  "./.git/objects/36/c00198a48b1b4a4c0275371bffdce46e373da2",
  "./.git/objects/36/d500941e8d3540c8fafcc3cf5b1958ec5fdfc2",
  "./.git/objects/36/ef4271d9e24dfbfa1a94afb1f14fa1d0fc0845",
  "./.git/objects/36/f8bd0fc251bff7c280d653b0b9e308c202757f",
  "./.git/objects/37",
  "./.git/objects/37/3f303e086aa2e6d5f7ed315b4bbd3a0bd7a185",
  "./.git/objects/37/3fd2686049504bcd30886c32b815e8f87d2ada",
  "./.git/objects/37/58ce252ec3de8b791df73a564bcb4ba9e3d722",
  "./.git/objects/37/5ed457ee7f257ea08ac124628c3ce8ab6cf15f",
  "./.git/objects/38",
  "./.git/objects/38/21c949e0aa90569ce23268512ead32f9b931ef",
  "./.git/objects/38/915c0491715f04a2679bcdc85ffeb7cdc0657f",
  "./.git/objects/38/b607cfe0601c2e6e9b2d9cb8e131dfa2dc2cb2",
  "./.git/objects/38/f9b8dbc6a6adac8370115eb56d99fc7e99fe35",
  "./.git/objects/39",
  "./.git/objects/39/439087953218e915c539fee78a0de07cc74c06",
  "./.git/objects/39/9f9eddeb93767253fe87391dd45e91c6d85065",
  "./.git/objects/39/aa9ff261ed31038183e876f0a3a9be9ba974c9",
  "./.git/objects/39/b4260b2efc37dffc0b9e0a590a151c741cb2b4",
  "./.git/objects/39/ce99df34849c67fd2580b8133913233a1501df",
  "./.git/objects/39/d74d42faab7a5ecc309efaa982ec9852dbff79",
  "./.git/objects/3a",
  "./.git/objects/3a/182f7c6829d0803143763205a1c4da3cbe9cbe",
  "./.git/objects/3a/231c7f7dac6c1a7bac4590766fb08b17bdca77",
  "./.git/objects/3a/f0244a767a22bb69edced1b97bb529f4779506",
  "./.git/objects/3b",
  "./.git/objects/3b/374d097fd855864e999a869d95e773421de5b4",
  "./.git/objects/3b/3fd888a1f1669bd3666c62d9278fef9b370e28",
  "./.git/objects/3b/839eb7eddba0780496f7b8d8820f8defc1238f",
  "./.git/objects/3b/b722a389dc39b30df7c241b9203d1ce6f69aa0",
  "./.git/objects/3b/ea9a22763354c0b222e7742b972e7c16fa3406",
  "./.git/objects/3c",
  "./.git/objects/3c/0c2848bca1097607914f59743277a8eccf0980",
  "./.git/objects/3c/40f9584d7b7226bcbdee38550dc32ac6f8e0df",
  "./.git/objects/3c/675eeb5157a24d02f34719f61e13b15f1a2afd",
  "./.git/objects/3c/6b23cf746fbf44c91749466563a3e48f7f3de9",
  "./.git/objects/3c/c03fa3d2043c525074cda7d4b599e3901e9769",
  "./.git/objects/3d",
  "./.git/objects/3d/0d21d63f04bd998fa1784794b9cde5f154949a",
  "./.git/objects/3d/0dde4c2a76d37aaa2d617c0b311e6032b39ab1",
  "./.git/objects/3d/357db4e36544dc1ecf66edb724275a78f55c23",
  "./.git/objects/3d/41215ed0d6488a8c416ed73a6489daf8f8d6e1",
  "./.git/objects/3d/6090b1f3a21a318e2eb3285b790bc0947d144e",
  "./.git/objects/3d/6a75e37fcff22dd9818034432ea852227f7a8f",
  "./.git/objects/3d/8c42060aab14a4131ac22e6df7382714b56235",
  "./.git/objects/3d/e13a0d7ce97557414915ecb378a1d9697995c3",
  "./.git/objects/3e",
  "./.git/objects/3e/4352a4e5474c452985764709adbc95f4c7a13c",
  "./.git/objects/3e/66df540fd88d35c66df119c19e08f30a117b57",
  "./.git/objects/3e/875a93eefa2f85f3b7997eeec2e8d0dd51d115",
  "./.git/objects/3e/89343be5a73b9d78f7391a12be096202aa642d",
  "./.git/objects/3e/f2933f55a234fe1f0188b9800a53943013677d",
  "./.git/objects/3f",
  "./.git/objects/3f/26ec9b9bc101d4a6e894a2f9fc19f989bfadd0",
  "./.git/objects/40",
  "./.git/objects/40/01b8a5efa3079ef696c253187e6608d710b765",
  "./.git/objects/40/074d22db1c0d96055f207311f60c508eb3a274",
  "./.git/objects/40/624789152aef805cd2b517f1da2afc8e44ab64",
  "./.git/objects/40/6a4b9f756baf577ced06bcdd5e35ade67d5015",
  "./.git/objects/40/91dc38999833e766b816bc02cfa9278bf511a6",
  "./.git/objects/40/aec9b976aa295413ed4f8767210f9a50f31865",
  "./.git/objects/41",
  "./.git/objects/41/6f80128cc5707dce14b5b343f19846b14ceaa9",
  "./.git/objects/41/a7022a3214ef50669a82702e0d4a7e476f1b8f",
  "./.git/objects/41/a984912010ca9bff0a78ec8772d0ab639274ba",
  "./.git/objects/42",
  "./.git/objects/42/03e4c4e774ff6dac84925c45a97a707dc1e793",
  "./.git/objects/42/36ea6539a2400f6f1ca31a87e91da6e9f88683",
  "./.git/objects/42/43d6a3c7890fcd95214b68a6317cd1bb0b9cff",
  "./.git/objects/42/47f5aecd3f28080696035727892cea3efd6053",
  "./.git/objects/42/a3dffcfa3235b55060ecab8499f3fef35ac789",
  "./.git/objects/42/d25d70668eceed24146309ad1ab8b275ab301d",
  "./.git/objects/42/fa4dc540da39891bcaf4f89e5819ba737b5b2b",
  "./.git/objects/43",
  "./.git/objects/43/06b62f150f1e2b973b08973e0e81c9a58b93dc",
  "./.git/objects/43/13c8b4111b53e3e207b680ed73a6bb85aab88a",
  "./.git/objects/43/3a4047605dbcc539cede44753a26e5812c6aca",
  "./.git/objects/43/5b48ae06a2c12df12800e1b3d1ad355d4cebaf",
  "./.git/objects/43/dbaf4385b14a0cf98d4fcd446ef5622121c18d",
  "./.git/objects/44",
  "./.git/objects/44/564a41df909d2ec1fdd69c241e5798128ec7e4",
  "./.git/objects/44/989756d4aeacaed91febf680805c199b51be23",
  "./.git/objects/44/bcc84743a9f7705be6c4361459f329f44a046b",
  "./.git/objects/44/e0519c30a08a9d2c638403a687f30e17a3c08f",
  "./.git/objects/45",
  "./.git/objects/45/13c5191a05872e9a3ba6d1163e05595f5ea5e5",
  "./.git/objects/45/8b03e27f13ac5ff9717bd1c62d72c4061c3aa3",
  "./.git/objects/45/93a3143fd735b7d680630da0c7e5c9cb189001",
  "./.git/objects/45/f52e98d41db01516c7b6335db8878992e01745",
  "./.git/objects/46",
  "./.git/objects/46/1af8794a08b1cf836bbb26d3d5cd6a5b654cad",
  "./.git/objects/46/3e47ff94bcee31ddd82b998eb306a9291a6480",
  "./.git/objects/46/6d0963f737e0a693f031599f36e6be69e1b58c",
  "./.git/objects/46/814eff8ef49036db7e6cd03c518cb15fa884a6",
  "./.git/objects/46/aa3bf3ef8a13460c85f6045ce6c46541c0ebd0",
  "./.git/objects/46/c214b8181ea711da6ac5564935d30883353630",
  "./.git/objects/46/c74ba378e5baf11da537dab425bb1024f9f3c8",
  "./.git/objects/46/d4742f4dc88be9e5ee81bbcb6d2b1156a6ac5b",
  "./.git/objects/46/e042e15701e1d3db15cfff48dcbe574f0a3c45",
  "./.git/objects/46/e6e321326ca3791c0c785430bf5c0b93c2b555",
  "./.git/objects/47",
  "./.git/objects/47/6ee24ac73d8493a4026a592baeaa344b292956",
  "./.git/objects/47/78711652395d963c08b17b1e0a33551e9240a1",
  "./.git/objects/47/b8bde69001a1cbab7a1d0d9e53bf64956657b5",
  "./.git/objects/47/c409746bd6e20e3cae7a313cf54bff88682d08",
  "./.git/objects/47/c8b396522aaf88227a3a7db55f590b5678fbf1",
  "./.git/objects/48",
  "./.git/objects/48/107cc15a2cd28eea3005d616cd3181047402ae",
  "./.git/objects/48/29ec582e51fad3f4fc575a21ae01d2b7143d9e",
  "./.git/objects/48/919c63471bb3c974a10c4e6dd2ed8987b23147",
  "./.git/objects/48/aa6dac15f1dd6896305c14eba00affa53fc802",
  "./.git/objects/48/e0ef14ef6e2e81b36cae014d5037e3febe91b8",
  "./.git/objects/48/ec00ddd606912eea5315b37619485fe70870d1",
  "./.git/objects/48/ee045859112d0fba3c3d797428f90fdb1e5d85",
  "./.git/objects/49",
  "./.git/objects/49/2ef8057a90225d79891d31765e6568c85d0ffa",
  "./.git/objects/49/4cc1e2003c821b6010b28a56b2d446ba44b524",
  "./.git/objects/49/576c12e0846fe50fb18ddf2fef8d56f0162d99",
  "./.git/objects/49/9939b75da8cfec92586bc4122baccca8b78c21",
  "./.git/objects/49/a3ae37c9d5b3361e5c25f44aa052f16f1777b8",
  "./.git/objects/49/ed9ce5183025b7ca765c66932956338be95ffe",
  "./.git/objects/4a",
  "./.git/objects/4a/08fa71e394b7cb0dfb6d63b986a68cf1cb3671",
  "./.git/objects/4a/0e67ea5afec066b40f67653925d58fe462bb65",
  "./.git/objects/4a/536abd460f9ef6bf52c1f17c48fd502e02d5c9",
  "./.git/objects/4a/8f4a993960b94eee3fa67dcdd22491596069d0",
  "./.git/objects/4a/ac4e988d1f303d38010a9d74701664c3c3024a",
  "./.git/objects/4a/cdbcdacb96898249376f3ff1ed08552c887346",
  "./.git/objects/4b",
  "./.git/objects/4b/5169390a9719e2cd7f29d86f91de25ec83cdf3",
  "./.git/objects/4b/8200694e828c89a8852e911856b9cd7df4adce",
  "./.git/objects/4b/8750d0ac0dd687b816948b3f9c7270ced4146e",
  "./.git/objects/4b/b8c6f3e7cb999295648032d591d19c80d976db",
  "./.git/objects/4b/e1eb808d5cdb260ef4b5cd6a72f955eb354f54",
  "./.git/objects/4c",
  "./.git/objects/4c/222d54d01db4f57cda8a169b134e0d6919cf1b",
  "./.git/objects/4c/754a2442c67cce789770eda0c239506bacfc6c",
  "./.git/objects/4c/96376a2429ec4b42519d348702061c929b3ddc",
  "./.git/objects/4c/97aab35921da727ea1747e324f60204118cac4",
  "./.git/objects/4c/a0abb2b51daa278c90a911df1a04e971549237",
  "./.git/objects/4c/ce2db21b6319248c3e74332315aaa36695d86f",
  "./.git/objects/4d",
  "./.git/objects/4d/1d9ee357f3cbd8b51d0cf464a30213e60cb7fb",
  "./.git/objects/4d/39535755b7491ad49d283960714540404f1aa9",
  "./.git/objects/4d/4fed451f98afc95b29c98b2c26f871ff125f45",
  "./.git/objects/4d/8bbea3b9a0e7e8342cdcbd9a1cd63e8d8a5668",
  "./.git/objects/4e",
  "./.git/objects/4e/60a9fb9b36c87ffce7eca7ba912441662a4f90",
  "./.git/objects/4e/a8d54f9efb8bac94012a1602918d5fececfe64",
  "./.git/objects/4f",
  "./.git/objects/4f/1ab83568c3b893b37b8027f8ed7ff18617be3e",
  "./.git/objects/4f/25fbd0bec63d9ac80ce49e720d90b63fea0eb1",
  "./.git/objects/4f/42ef5e9c4135f6ca1f0a8231ebe7f0c3d1f5cc",
  "./.git/objects/4f/5bdef6703352bea1239e4c43e971e0fa90b7fd",
  "./.git/objects/4f/7611ed0215807de63f7342583105676d74a6e6",
  "./.git/objects/4f/b46de340c3a596f00f56a5fda176c59c980050",
  "./.git/objects/4f/bb22e1ddff0cdc419c41eda6b4151f4214ffae",
  "./.git/objects/4f/de1ced73ee16c1a6b7afd009a4a8ddf0cc8318",
  "./.git/objects/4f/f2ce67cecdaf9ea6974f60367009f148556b2b",
  "./.git/objects/4f/f3bc937dd9a04c18434f892dbf803eea8abec9",
  "./.git/objects/50",
  "./.git/objects/50/190f55edaa7be5f8540ff1626839c71ae115a3",
  "./.git/objects/50/2dde76388ce365f49ab99e19bd7b38601d7a65",
  "./.git/objects/50/3535eec582b9e51895e20e91f13fa377488fdd",
  "./.git/objects/50/35c95db67b642157a97d6e0117dbc8fc844562",
  "./.git/objects/50/4dfd867447c740ccf306a53e537d524fde8bfe",
  "./.git/objects/50/598dbac4685a6938edcf23ab50c94398b76b93",
  "./.git/objects/50/ba89a18912bad7e1ebafc585a45435864fcb8b",
  "./.git/objects/50/f1b91a88430d59f0aa4d616a2689bb998afd3a",
  "./.git/objects/51",
  "./.git/objects/51/0a1e68675a8543ab661a1daa733628da0eddff",
  "./.git/objects/51/110f48524d25b6e6a1b1876642b324f39f5903",
  "./.git/objects/51/18137b394d341413e1b3e18589998cb18a6e85",
  "./.git/objects/51/37c6bb5acd6ed0312328dba9602ed5baa8859e",
  "./.git/objects/51/518913f1dd5a1e83a0db69dbcdb948e1171baa",
  "./.git/objects/51/8a591d11c8a5226324279794d7f6723db55072",
  "./.git/objects/51/af1c7bc52756585774a647d89bb4e09aa67dda",
  "./.git/objects/51/c6d347c53c2fa35a7fe1cbd7046628646b6eae",
  "./.git/objects/52",
  "./.git/objects/52/1ba72394ad2425c22b2b64d5d48db6d877e4b7",
  "./.git/objects/52/3ef3a34294640939f3aaf3a054a5fa30df2827",
  "./.git/objects/52/5e206a0ce04899c7a108e38c1c5a3c9a380f9c",
  "./.git/objects/52/76dd9e9299005c231689a9467957f0e2341f82",
  "./.git/objects/52/890298e894281162191979fca2fef0ae5391db",
  "./.git/objects/53",
  "./.git/objects/53/067e2071dfc5bbb734188ec8b185236e2d4118",
  "./.git/objects/53/137281b2014722ddbc13c7b527bad4ac1bd19e",
  "./.git/objects/53/1b2f7da7ba972783f5a800e4ff520adc4b3c1f",
  "./.git/objects/53/9118d570fb1a63bacc4101fb5261d6f57ef163",
  "./.git/objects/53/b802c3ef313188a69063b4aa001bf58c2fe9f9",
  "./.git/objects/53/ebf0f797226d4c07c4a6d551893391e6cd0e4d",
  "./.git/objects/53/f272e0f20557545c6843c3532aea09c1a81032",
  "./.git/objects/54",
  "./.git/objects/54/6552e8945a60ad56b66334439c43bd126ea335",
  "./.git/objects/54/68bb2b7939f1b1837b8f6c57512fe23303e8f2",
  "./.git/objects/54/b6fce6c09352cd956d2b5499d213e7442a4c77",
  "./.git/objects/54/e8ba9a7d24780dfe06d07972cb9ddf49599474",
  "./.git/objects/54/eeafae6704d05e903260f43c7a52f247990228",
  "./.git/objects/55",
  "./.git/objects/55/15f872bad6b145fedbf75f6785349cb6f637d4",
  "./.git/objects/55/29092e7b5cae59ab0b0afc41fdaf57272ae165",
  "./.git/objects/55/b66bb4ec85a4ae8b286c904092db6a32bbd9af",
  "./.git/objects/55/d069af170312b3b486a153f27fb3e89d0a74c4",
  "./.git/objects/55/e0b1906a6d756028d73ec15a685add7b961720",
  "./.git/objects/55/feff96901ebcae72fbe99faa9706df491f9350",
  "./.git/objects/57",
  "./.git/objects/57/66870a3979d84eaf584f8ef1e7f18d3cb9d785",
  "./.git/objects/57/6a9d951ac1e0b2e96c107544b15c911ddaeee3",
  "./.git/objects/57/b1f40b247fd13a7b848e5d188b54c591a98683",
  "./.git/objects/57/b22361f7f6baaa12863eceb05a070193268a50",
  "./.git/objects/57/d78d82d493d3f9789a9902b7e643e832f7c464",
  "./.git/objects/57/e6874d7f498b1982d076b5ff2b0f7e69addbe0",
  "./.git/objects/58",
  "./.git/objects/58/2274b2429ee648d46376c7352b85948a1407f5",
  "./.git/objects/58/36c8253f4fb77390e66c780034d4513187e40d",
  "./.git/objects/58/a288fa957bd1d81f947292441b228987b3826f",
  "./.git/objects/58/f65f97ae1d151715cd548044f9a08ec4ce1773",
  "./.git/objects/59",
  "./.git/objects/59/49f9e64ee97b3e914a44cce928cab5537532f1",
  "./.git/objects/59/68f3dfa1289fcdf484abe14fb41dd5ca09b202",
  "./.git/objects/59/98d569365050febb4e5a545e38e4fefa53971b",
  "./.git/objects/59/98f2e55ea92d370f64db5f23f87f322b43aadd",
  "./.git/objects/5a",
  "./.git/objects/5a/1e4677c4308f655500baf48bfccd34c79c0954",
  "./.git/objects/5a/281932d79ca3c1eb8538ab62ad989bb7e7e00e",
  "./.git/objects/5a/51a4fe48001a07917fd5d94794c8f9798cc434",
  "./.git/objects/5a/72cc9f0262b628340e07a8ea247350980f19b4",
  "./.git/objects/5a/86eff83aba666a7be5cddc081b36ebcbea0fa9",
  "./.git/objects/5a/91bd6ce595749e57be72fd7224aa402aade9f7",
  "./.git/objects/5a/a2c94f1ffb2aea4ccee12934a21298d53b8e85",
  "./.git/objects/5a/ca791f13a1842c279a46b67ddd89fadc72fc52",
  "./.git/objects/5a/e12e8343a4146bb8456e1534dd597d8a82c276",
  "./.git/objects/5a/f17abf82bf2bc0f5ca2dd51226ddf4b89002a4",
  "./.git/objects/5b",
  "./.git/objects/5b/176fb4589da491b38dd474ff95b8e7a7ac4744",
  "./.git/objects/5b/367622e584e46f6b0f3c5356bd42a7702e5477",
  "./.git/objects/5b/605573f3531fefb3529fd03b6a67a7f66e2552",
  "./.git/objects/5b/777d5ed339ee38c261ea4711a068c33746cf32",
  "./.git/objects/5b/86712f6689c0fcda8c8c3b508077d71136ac81",
  "./.git/objects/5b/a5be7a64bf6b97d714823d59ecd92138ac44e6",
  "./.git/objects/5b/e7ef8d62407ebabc259e2019073f4c2b37c17b",
  "./.git/objects/5b/f7b0011b7dac63fadc2c037e7938c5f964f037",
  "./.git/objects/5c",
  "./.git/objects/5c/26229ce2828bb83aa3bc8cb21414a8165724ed",
  "./.git/objects/5c/782bac1c660689fbdf366efb65b3479c71ffca",
  "./.git/objects/5c/8072d023e8ca2c43b683d09ff3dfcd93f5b056",
  "./.git/objects/5c/d0284337c3c4b59da243e5c329b162c59ff7f3",
  "./.git/objects/5c/deaeba74e4605913801a6d690e67927c41e6ee",
  "./.git/objects/5d",
  "./.git/objects/5d/354acdd45c0735d8b3d1b4e3419b04a00691f8",
  "./.git/objects/5d/49c469addf9ef1f18a911f84cd4039e3cb93f9",
  "./.git/objects/5d/ac14ba70554a9e96e09636d0d0cf582c8d6241",
  "./.git/objects/5d/c4bc69b14c96af892b172256acf203a3a1555c",
  "./.git/objects/5e",
  "./.git/objects/5e/35edcbc10c4dad322abe091803516aec7587ad",
  "./.git/objects/5e/391ce8215cf4e438e39d7915262b468867b961",
  "./.git/objects/5e/5887827ea8445e2c66706d76d57a43d52db118",
  "./.git/objects/5e/78c0b217bbc5dc503c040a0c1ec7a99e83ebc7",
  "./.git/objects/5e/7b3e38bcad9f4cda9749cca6404d6a55809a2b",
  "./.git/objects/5e/cdc1a0ccacfc49162a5176804b7a11dfb8296a",
  "./.git/objects/5f",
  "./.git/objects/5f/08018fe605bae4cf8deae526fc89aabfc0fe4c",
  "./.git/objects/5f/5bfeff83ab355a66f8f792e7b2509305bb84f5",
  "./.git/objects/5f/9c20efdf7b443e612e40b3e56659fbbd3f5791",
  "./.git/objects/5f/bfd2475ce846da5be9ac52d44afea1c47daae3",
  "./.git/objects/60",
  "./.git/objects/60/02070d96e981046d82004c1874f3d3a76785cf",
  "./.git/objects/60/ae6a4da97eb38e436779a1c8f3cbaa9c74b0c2",
  "./.git/objects/60/d348fa3cf4aab9d9f03bc79d440771f89b5b75",
  "./.git/objects/60/eb739c59706b36045723c0a6250b5e3b99bf0c",
  "./.git/objects/60/f0edb2eea2ae766b5cab43208f83d7dcce9aa8",
  "./.git/objects/61",
  "./.git/objects/61/29056809155efea10a53ad71e42841b1f18cc6",
  "./.git/objects/61/3436604b09f0b037444ea5a2b7164f2d4f4939",
  "./.git/objects/61/6e28c2ca01a76aa789da0a50b3f6bf4731de3f",
  "./.git/objects/61/bea65fb6e0c335cc61180162af683aaa99ab2c",
  "./.git/objects/62",
  "./.git/objects/62/4ed6551acd9c211341c74651de739ab47954be",
  "./.git/objects/62/59b44b068ac4bb091569156363227d5f93ee65",
  "./.git/objects/62/7f6cd5fdcbb9453a86d00c4751857bcd19e659",
  "./.git/objects/62/81df594ea46562ce737160ffe4725628f2bcb3",
  "./.git/objects/62/92da6350244026a2c8e07f25b8ad6febceb8c2",
  "./.git/objects/63",
  "./.git/objects/63/2d12d955b931b6c806786004d75b58c572aa04",
  "./.git/objects/63/2fcb4659bbf1f27e96647b06cf665d13c09b18",
  "./.git/objects/63/55b2e29f089d3bd42eb3533be3c123df64dbbf",
  "./.git/objects/63/c2417afe207774007229677783b59557fabebe",
  "./.git/objects/63/e5b12fd626182cb3099ff64221200e6f338c07",
  "./.git/objects/64",
  "./.git/objects/64/108575c1bb0db53ab6be5930110ab011eadf28",
  "./.git/objects/64/376d65a27c528c4e3a8b84b1b31baeffa4917f",
  "./.git/objects/64/4254d05dcc86a94973705eb6b101b23429fd13",
  "./.git/objects/65",
  "./.git/objects/65/1e094a7060071a946324f71bda697d012af9a7",
  "./.git/objects/65/333f9d7b63b89f9b7d1429ee8fe8983f341b32",
  "./.git/objects/65/4dfd27cf3356a52abaed4b9af601da05e21f65",
  "./.git/objects/65/610a1fe91462768f2cb05a610b2bc24cb9b056",
  "./.git/objects/66",
  "./.git/objects/66/6dffbdffb8b04948abecbc1a0b3c07544443b1",
  "./.git/objects/66/8cdc67b972d588d18b589c70e501f5e86887f6",
  "./.git/objects/66/fbe78aac840564eeb5f88e6ec078a650829f73",
  "./.git/objects/67",
  "./.git/objects/67/038d7de620c078fedf8aa2355b26a0ce92c134",
  "./.git/objects/67/06fea262e7f49fed3ef066e369ba1d0890b6a4",
  "./.git/objects/67/07a120fb427d06d0c372eb0341502ee85a8506",
  "./.git/objects/67/21570835f637e5287097c7c3326c20cb0fea7a",
  "./.git/objects/67/43beb9fafc2846bb2e4a7332cadcdefb647bcc",
  "./.git/objects/67/60b0fee10c1e2797f425b6362fbde85ea855a1",
  "./.git/objects/67/62cf35b3099cc3b234b5c7bda97f9456dd5d21",
  "./.git/objects/67/7a38bec45f8de0e9a0449888e5384156273f36",
  "./.git/objects/67/b8bc0d291d0e5bccb3a96c3a24d26c1760adf6",
  "./.git/objects/67/e933c416482d314648b365f71f4951211bd58d",
  "./.git/objects/67/f3e17146811f9ddb41f42f992c22a3fb2ee117",
  "./.git/objects/68",
  "./.git/objects/68/8803fd003e169e03a0a6962a2bbe97b4ba63cd",
  "./.git/objects/68/d12eb81f9c63c1f95ce8cb463ac6802f6ffe70",
  "./.git/objects/68/fdfe9c4e4b6d67b2659f800ff3cbf31aea49ea",
  "./.git/objects/69",
  "./.git/objects/69/2c53f378271bc5d53f6dab8b52730cdfdd0610",
  "./.git/objects/69/929011fe627543d766336f6b14e04df32d9d6c",
  "./.git/objects/6a",
  "./.git/objects/6a/2d55e1f42628e338e2b1325fbd975c28a95c59",
  "./.git/objects/6a/2e0841207c12cf3526eddf4fb50bcd45c0b9c0",
  "./.git/objects/6a/67805dcd095948790e847c3006770386ee548d",
  "./.git/objects/6a/715f5df63c18ca6c48070334b32fa0149e19c5",
  "./.git/objects/6a/83bb47138c272a8f3218dc49281bd9a05c7325",
  "./.git/objects/6a/cf05e570a10fa25089fba2695cfeb554bbabf4",
  "./.git/objects/6b",
  "./.git/objects/6b/3f610e7bc1b5eace8e67e0cdfa23346d34a4cb",
  "./.git/objects/6b/d94e87012f1e22b4d2c82b453524ef485d992e",
  "./.git/objects/6b/f1024eea64d3846de1924a23ed023f9a4db93c",
  "./.git/objects/6c",
  "./.git/objects/6c/ffb690bd9d56c591d6fcfd2298b92ad45ac34f",
  "./.git/objects/6d",
  "./.git/objects/6d/123fc27b881cc74a13739980c594edf96b8506",
  "./.git/objects/6d/2f989b1bccc8ba627cec4777e56e709b195fa3",
  "./.git/objects/6d/31600977109ef6b9cde5888fb4f037279208fe",
  "./.git/objects/6d/342839dcd51c420e56ad228961d74d9a30510a",
  "./.git/objects/6d/7671607629803fa55554d56951a908a2d6cec4",
  "./.git/objects/6d/77b2690cec99b73874466666633e6d5bd3e119",
  "./.git/objects/6d/ac3dfe6db3da404b0212dce7d388e1a7293264",
  "./.git/objects/6d/c13a2e01d8cd65659eb8fd7f88c8ea733ffe04",
  "./.git/objects/6d/d365e519881f14310b7102d7f06d4c16db90a4",
  "./.git/objects/6d/ebb3e2426504790acde5270ce2520d0d0edd51",
  "./.git/objects/6e",
  "./.git/objects/6e/5e91e370b1fe44bd8fb059b72a307df3bf9f6c",
  "./.git/objects/6e/cea48362d87c7e8364c9f8b26d7d01ccb52a21",
  "./.git/objects/6e/e122437c6b1c66458fb9d93ca826590d34634c",
  "./.git/objects/6f",
  "./.git/objects/6f/17e26b6cc6fd947d87f91f1e33484c5661b7c0",
  "./.git/objects/6f/3b76ea3ed5e1f1115194e96994a75946bc8893",
  "./.git/objects/6f/55cb746b8e501be3cf85967ba840cc1116a661",
  "./.git/objects/6f/64dca9fbcf1544878e2f8dfce77f56df8ffa1c",
  "./.git/objects/6f/d251bf7261d3c87a25f0236a08b4887e8e9c19",
  "./.git/objects/6f/fcc838913f5a864cb6598274f87d4a3225c0a6",
  "./.git/objects/70",
  "./.git/objects/70/876a379323f7ffa66bc54f7a761b22e7c3e7c5",
  "./.git/objects/70/98275fbe3a14a66c7d69ed9e4da636ce686d1a",
  "./.git/objects/70/9d4f58aea46be0045767c29de8f1da09a301d2",
  "./.git/objects/70/e434a12330e5a84dad3239a9445766950ef3d1",
  "./.git/objects/70/e54d24ea4bc2114c5e470929a8c1f0b9fc222d",
  "./.git/objects/70/e7f10acf5a3c06224c2fa67dd638d72594557d",
  "./.git/objects/71",
  "./.git/objects/71/1b8ca5796bf92c488a1781d5ed5000516f67ce",
  "./.git/objects/71/26dcca57e6a02860bcef9e946f468192085c04",
  "./.git/objects/71/590ecc985b2cee720c74b060399f34abcdbcca",
  "./.git/objects/71/6e5f5d7980a775b4f8b9a2908209cf94e71d52",
  "./.git/objects/71/86cad81f8eecf4b8b911d3a5b45c48b1906b0d",
  "./.git/objects/71/895a8199e8abb5aba7784c5077aab7887f2ae6",
  "./.git/objects/71/a4494f091d2b579bcc51f94af18197a7128774",
  "./.git/objects/72",
  "./.git/objects/72/80cbdcff0537625f397678dfeec2bdd4844a26",
  "./.git/objects/72/cdf2a42d85df5d11c32067f70b150e12703cc4",
  "./.git/objects/72/ea5553e3f62a8096b2c2e3320ffbdf93152378",
  "./.git/objects/73",
  "./.git/objects/73/2c67db5f00ad991e3eb6011803065f24f795cb",
  "./.git/objects/73/441b4fa3c123a3c01b46134c0d864e448ec46f",
  "./.git/objects/73/468ac2ec8884e1f5d9fdb91d00c22842e4207a",
  "./.git/objects/73/4e1ddb0fbd1aa8acf0d2cd1ad0d4d1ee26f408",
  "./.git/objects/73/53823f2f67c23d7e4c000b4d791881e7cb6245",
  "./.git/objects/73/7e06fd907ea91bb26e85c7150d6886dafda82c",
  "./.git/objects/73/87f137c529701302869b906403d9dee6407927",
  "./.git/objects/73/952c14e31bb2372bd86e13fd09950b5489f7b3",
  "./.git/objects/73/996ff124ab90412971fcc7d106f3b29df748ef",
  "./.git/objects/73/e3af194411913a03b0a45215a820ac60274de8",
  "./.git/objects/73/fa7b8705779ebd1314b71013214842c066f00e",
  "./.git/objects/74",
  "./.git/objects/74/2e6ed5937723da2a2f39a5d193a32b00d82fd6",
  "./.git/objects/74/5a55f9e11b76ddb9dc6784a6d5b6a7f3b1e0bf",
  "./.git/objects/74/71fac9a5886627644c3f42ea9f67b35e92e4ec",
  "./.git/objects/74/7f00211e03b0431e4e81f24fc2557912f2f835",
  "./.git/objects/74/83346b20fbdd73b8fd3513fac70262ed97b525",
  "./.git/objects/74/98d5fa8ccafaeb44138811e9bf2bc2dfc587fe",
  "./.git/objects/74/b790407d457e5c14c7bd075bfdfec6e0f189d0",
  "./.git/objects/74/ba4cbc2badcf735c6ed94b8105dd43e0d29fb9",
  "./.git/objects/74/cc6eac959c2447eb54531568d4007a430c3729",
  "./.git/objects/75",
  "./.git/objects/75/1e22aec9e1b19b838e96d0bd7f80c9d2611c24",
  "./.git/objects/75/7e5b1c90d2dea6c96f6aa18005feba69d1bd85",
  "./.git/objects/75/99f17c0b56d3a7c5276903be7c783b17728d85",
  "./.git/objects/75/9e78780ce3ef1754b94913dd42cb95be96e3de",
  "./.git/objects/75/a718d5dbd41ebd9f8bb39c9fd91f648636ff68",
  "./.git/objects/75/b13b77f8695298cc279b001622e4e34f5fa40b",
  "./.git/objects/75/da75492e088a04f326cdc473d7465d7d06b55a",
  "./.git/objects/76",
  "./.git/objects/76/11146ca90519f1e56ff52b0fd8e46d223c2542",
  "./.git/objects/76/259c0fa1f5bdd151aec9b9d03685484a807dc3",
  "./.git/objects/76/81b2611e0eedcae03550f20174dfd2fd86f46e",
  "./.git/objects/76/837ea126dbe777ab468016c85caa3864b3d8b8",
  "./.git/objects/77",
  "./.git/objects/77/30124d7c2c7174f7fcec4e3ff397f686cb72a7",
  "./.git/objects/77/5547aaa210ce6d7df4b7e722b3070002b4478b",
  "./.git/objects/77/b8ceca92468cb632c1cbf850b0787f9a45a24f",
  "./.git/objects/77/c8305875a64b9bb4b6b8922774fa98d65640c9",
  "./.git/objects/78",
  "./.git/objects/78/06814da680b74f910035a8c1ee7eaf6838548a",
  "./.git/objects/78/3990a149dff2de43e3e8cd301a974ba3cefd02",
  "./.git/objects/78/5c07c630fc335609c158ff70b55719744c1400",
  "./.git/objects/78/abfd5dd8f12ba03ae6cc8cd313b3677e3d176c",
  "./.git/objects/78/ce72dae29250bbca9b64870829ddb748e8aa38",
  "./.git/objects/78/d72461dd450a4e2be182018d8d68e48f02bc12",
  "./.git/objects/79",
  "./.git/objects/79/2c26009f6ff5707f8ef9b83e064e1bb5740d9e",
  "./.git/objects/79/418767bd4d8349e74d8b484c96aa93c8469d36",
  "./.git/objects/79/658897bbd60637a41672d25b71bb42025d8650",
  "./.git/objects/79/84ac926bf224b6839e05b797962afa34bf92b6",
  "./.git/objects/79/965c3c1f24651e4f4b3042768ec74757f62b7d",
  "./.git/objects/79/9b61ca5cee730c27abeefaec471d633d265d5b",
  "./.git/objects/79/bf024f1ad5960f0437b0bc7699035d01dde52c",
  "./.git/objects/7a",
  "./.git/objects/7a/0009647dba68334e76a779c178ced30da7cf3b",
  "./.git/objects/7a/3e6456a44aacfc2bedecc0f5be483504a40c31",
  "./.git/objects/7a/7cf57851b4ece446d3dd75e7fb4f8dd533df30",
  "./.git/objects/7a/8af6818f39dff4fb1c595146d68c51e3fb7b70",
  "./.git/objects/7a/cf024582abaee2b67bda479b6848c030f41f2f",
  "./.git/objects/7a/d1e86c0d9a5eaeeec54249fd97c9c3f9c47b82",
  "./.git/objects/7a/dd6fdf2cb42fdb137bd4ba35990546ac5e25c0",
  "./.git/objects/7a/f02c2cb8e1583e2bf58cdeaa646e513e509975",
  "./.git/objects/7b",
  "./.git/objects/7b/8b88e469db0747a8e695f75cef3cba02349652",
  "./.git/objects/7b/f1b487c13350504d38ef52a3aaa543cd2b3883",
  "./.git/objects/7c",
  "./.git/objects/7c/11faeb9b76dfb4e0f8c9908c863ea22ee95a04",
  "./.git/objects/7c/2f90453503e872fef13dfca52175b13d731a24",
  "./.git/objects/7c/552a01eeb788f48c7e7d3aafb1b284b3d54444",
  "./.git/objects/7c/7bfe739b4bea6cffbdd24474519d5d01f8e0cc",
  "./.git/objects/7c/81299f7df514e8a60af8bd01a71fd9d7e70500",
  "./.git/objects/7c/ca54155bebe0b7c09899ebcb642576ca96d3cb",
  "./.git/objects/7c/f6477b9b05fce98a8edac9709b9e334d85878c",
  "./.git/objects/7c/f88a15d379e977cc81cc9d1b460cd1c8106657",
  "./.git/objects/7d",
  "./.git/objects/7d/078f716568bb9a7d294cb3bbcf27aa45d0099f",
  "./.git/objects/7d/109bf65db7b46f9584ab78ab47b988aca9c8a1",
  "./.git/objects/7d/3cb9871e5ec0624ad0317d7cf99c2be4adc4fe",
  "./.git/objects/7d/549824e75810e0fffd132e2571b604a3824d2e",
  "./.git/objects/7d/86432c6d75003ee1d31ab7bf7c8b3da7ca62b3",
  "./.git/objects/7d/b4a54263b9abca30053e7d38c716a90580a259",
  "./.git/objects/7e",
  "./.git/objects/7e/16136b175883f35dbd93f8335e7b857712f174",
  "./.git/objects/7e/345d07133aab094b91fbfc4cb9e0f12283a621",
  "./.git/objects/7e/554ea77d47ed503ae126791a55390aa5b4b5f7",
  "./.git/objects/7e/9f3d45f3ec9772eb9d60ccfadc880528fe0606",
  "./.git/objects/7e/a269999b782dbf0d371c3eee87ac8604d48d0f",
  "./.git/objects/7e/fbea08438a9b803a0517bedd1c35fe51fe2737",
  "./.git/objects/7f",
  "./.git/objects/7f/65b0397bf3de2c91360fd65a657af8d06f5c12",
  "./.git/objects/80",
  "./.git/objects/80/399f08fd539ac4c361ec70fac771e20bf2fa83",
  "./.git/objects/80/3ba4b568449024269dc28c0b738e86c9382e0d",
  "./.git/objects/80/c35fad7faf7a42d053f6d3a392f5e8d7ce62ad",
  "./.git/objects/80/d59959aea46daed5d7f6f47d667a79a420379c",
  "./.git/objects/80/e0d2fad41d8a04cb2b0f9b37cff4da2f4fd17a",
  "./.git/objects/81",
  "./.git/objects/81/24f26177ae048b60ae0e2b76fe792782b13aba",
  "./.git/objects/81/73ae8d1b86dfc1833b0ef985201c96a5e9d910",
  "./.git/objects/81/810795dd498dd91c2187b06d4153fb2121919a",
  "./.git/objects/81/c83efbf9abce0920b747a8b1a362dc179cef89",
  "./.git/objects/81/d04fa6b1cadf6e0c14619d3184dbe9c31d3bb7",
  "./.git/objects/81/e6d7655fbe42c91dab22135afd4caee750b331",
  "./.git/objects/82",
  "./.git/objects/82/57f6128829024ede70ac5bc715670498606f5b",
  "./.git/objects/82/821674caa3c273c0250edafc0dd480c558266a",
  "./.git/objects/82/aa97aa1b22e9ef53cdd4f75b17f57401e65044",
  "./.git/objects/82/abe1cdb6dcb7309651a68e4cd2fee3256ff00b",
  "./.git/objects/83",
  "./.git/objects/83/1a3b7dbd173a4031d3f9f1d8a5a0deb281e32f",
  "./.git/objects/83/3fc5e0af4d1e63cec31de96b3b6c2af141c0f7",
  "./.git/objects/83/b28634fa7dc148afed9b9788bcb45d7f1f0001",
  "./.git/objects/83/f3d931050b4c011254484abe6ee12eccee414b",
  "./.git/objects/84",
  "./.git/objects/84/0f78ea1908e6756abb92784b748ac227254419",
  "./.git/objects/84/1ad3cbbccbbcba0e847dfa50372b73c41bdff9",
  "./.git/objects/84/1b16554ada5e84f62d0dccff756d84f9e9821a",
  "./.git/objects/84/28e5fa4b3ef1db9e1557f3ec024cae0753e464",
  "./.git/objects/84/3a9a00a944ab6432f31bbfa669401daef719fa",
  "./.git/objects/84/c7e0fb0efb29be745bdc13afb6e09700e9fce0",
  "./.git/objects/84/e1913f7a2bc9dc02fc688e5b79866b6723bf9a",
  "./.git/objects/85",
  "./.git/objects/85/0124e12e3e3caf954dec5932142c7feaff24ed",
  "./.git/objects/85/3c8c88cc3465ff7dc76712af5d3d0be64649bd",
  "./.git/objects/85/952d7f01fb666d69c9f6e7d03af467e831295e",
  "./.git/objects/85/ede4efd8c7c43c53c3819301cc0df068d360c8",
  "./.git/objects/86",
  "./.git/objects/86/0614028e5f8b16b9ca10710ecd4c45376f53b9",
  "./.git/objects/86/355fd3decb77919956283a95c856f41705b86f",
  "./.git/objects/86/927355752ef1ef23d66371e416828dcbde2ebb",
  "./.git/objects/86/b4931cefecf6b9eb0b339dae098bbf46076eab",
  "./.git/objects/86/dbb4604345768051f238ac6b5475d65b8a41f7",
  "./.git/objects/87",
  "./.git/objects/87/33ac10bfe63a3fa35a42dfa2da8231811959df",
  "./.git/objects/87/361d45f7cccde3ebb45ae42568502449023170",
  "./.git/objects/87/3f1405c8b4792dd2acedccfea72a694180d434",
  "./.git/objects/87/ad866e7c1c095f69f12b2d97fcb222cabbfbd3",
  "./.git/objects/87/ae8827a47bb57caf350649c77f4bbf038645f0",
  "./.git/objects/87/e288a49c32de3c16fe10ca1e449574bf209a75",
  "./.git/objects/88",
  "./.git/objects/88/2e21811b319c967a044808831dd69b5239ddbf",
  "./.git/objects/88/33c4ff6c755d22c41d057ba5a21f09b0b7a901",
  "./.git/objects/88/be9f73b555db12bd682438bcbadfe9dcb5b928",
  "./.git/objects/88/e99fb43bd9f45183dd9b7e962c62a524a3642a",
  "./.git/objects/89",
  "./.git/objects/89/3fe175f50d8e1d37fae9030fcaf9b7823520b1",
  "./.git/objects/89/5c530e4a2286e33846ccfe9070a4498e781422",
  "./.git/objects/8a",
  "./.git/objects/8a/2a352c5fd78ea3b52224eb28af5001e499e5cb",
  "./.git/objects/8a/2d1f3f75ad2e699c817580513795178942bd07",
  "./.git/objects/8a/8b675dec3c11894fd48a22f26d8c395de37a58",
  "./.git/objects/8a/9274ca82a589acef8ee1d3c64edfec7cf092dc",
  "./.git/objects/8a/93b8778510c53923551f2720ebaf17cfc6ecb1",
  "./.git/objects/8a/b66f815d005644323d878b4ebaa875712bc919",
  "./.git/objects/8b",
  "./.git/objects/8b/137891791fe96927ad78e64b0aad7bded08bdc",
  "./.git/objects/8b/4e42fe298cfdcdf09be9baed9798839a91b883",
  "./.git/objects/8b/4e7196afdae6d4aa8c02271f842bfe49d4d768",
  "./.git/objects/8b/888577b2b30e2c1dc97ed86b553de7b7bc950e",
  "./.git/objects/8b/b227a4866e2b51eb56d0abbe61d7fd6d10d248",
  "./.git/objects/8b/c0d2b1f0231a5ea2303e1c17fa48ebf8e33714",
  "./.git/objects/8b/c68dba0fb57e16e1329e29b38d1691d8091565",
  "./.git/objects/8c",
  "./.git/objects/8c/ddc94b2606df85752dbf67e44fc70b8e96e765",
  "./.git/objects/8d",
  "./.git/objects/8d/4f3b268c1e49bf7015573cb803bb7a82099f0c",
  "./.git/objects/8d/4feb57c749fd878ae1fb9abee2c5361f9cfeca",
  "./.git/objects/8d/5a27738886f4f1b19eed54866d344bac13487d",
  "./.git/objects/8d/a55f32e876589041f592a04cf874906a49643c",
  "./.git/objects/8d/ac5294265f1399806fe0a326fac6ad61f470ea",
  "./.git/objects/8e",
  "./.git/objects/8e/7fcce68fe3ca756aabf89923a244026efacccf",
  "./.git/objects/8e/e69d804e36074c9b087bf6f638b645377df6a5",
  "./.git/objects/8f",
  "./.git/objects/8f/734ec81c34878bbd9b662571239e02aa0ab15f",
  "./.git/objects/8f/870799c51b1d5b12b4908916ffa1272d677fe1",
  "./.git/objects/8f/ef4cfa5344b8b2c18e1790a3180a0dfdb16116",
  "./.git/objects/90",
  "./.git/objects/90/3669b3ca66acae85011b4d5563868dcd9f486e",
  "./.git/objects/90/59a4b4f291ca068dd52d3ea3a24caae82e6eb1",
  "./.git/objects/90/5c394515d506bad0dadc22fc405176626295a4",
  "./.git/objects/90/89a92663724c04ef8b5dc8b18da02b1c415144",
  "./.git/objects/90/a60e856a7ed65b262e5e96af8d6f99aa6f1933",
  "./.git/objects/90/b41d6f0d776f0c2ff5fd19918eacfc26ac1ceb",
  "./.git/objects/91",
  "./.git/objects/91/014e27f474265c31b31d2d45240d1ebc6ac52a",
  "./.git/objects/91/0a091416813399d3b46bb096196ac39b89e73d",
  "./.git/objects/91/37e6e2ad18b08c1ae5ed7e1dd1fb678be13a29",
  "./.git/objects/91/bdeb9fd673d91f57f16ec4d3ef8e2e65474543",
  "./.git/objects/91/e0b04babd1d4cff75ddb35949482e76da938ba",
  "./.git/objects/92",
  "./.git/objects/92/2785ff0ebb10f31b3bb4c3071fd6b1a604bc2e",
  "./.git/objects/92/9456030cff16221174cf72296348d03990429e",
  "./.git/objects/92/95ebfac4fa1ffe56f22129ce7a5993c35306a7",
  "./.git/objects/92/f1ec320fe4da70988429f6d349a878aeeb5cbc",
  "./.git/objects/93",
  "./.git/objects/93/23dc0a042906a19e0d30e2209b0c05954918dd",
  "./.git/objects/93/25f2f6d9d0956842b3dffd00bb58b8d13d3a1c",
  "./.git/objects/93/3a1b6e889b6bf9190e1fc6e2b2192c35ce2bf0",
  "./.git/objects/93/622c7df34327549a2397b1ca7c00007d953ad5",
  "./.git/objects/93/fd70a4ead21c13f03225fc8697ef61281da1d1",
  "./.git/objects/94",
  "./.git/objects/94/df68e749f2316eeb15c26ed74274523cec08a0",
  "./.git/objects/94/eb83500243684785e811b3eec9563b799f0d36",
  "./.git/objects/94/fa675c710376fbef30f9f2bc3fbb48816eaebc",
  "./.git/objects/95",
  "./.git/objects/95/06cfa7bf43872d15b043b89a740856c63bf97c",
  "./.git/objects/95/14d749f689a8ce4e2165aa6328c3d972cb3c1d",
  "./.git/objects/95/1de1dc53827ccbb5fd95ca5a3f0b7ca31a9807",
  "./.git/objects/95/2010273ed45bcef2522f5327a33a5875fde325",
  "./.git/objects/95/2287791a5428eee51ce952eed1ddc2593d3ad9",
  "./.git/objects/95/4cbad0a7f5d85d05264358ba17a6b40b499de5",
  "./.git/objects/95/bab1a9923f27c5f4a0c19176efb472f4f8df5d",
  "./.git/objects/96",
  "./.git/objects/96/0a6db6fe7d72a2a00280f66316401b3524458c",
  "./.git/objects/96/2bb3e14fbbfa31dec5b01aa7bb19663974325b",
  "./.git/objects/96/35755416ee2091b022d59a9ac35daaebe22f0c",
  "./.git/objects/96/3a650a782b02240b323f9d426abeb990017ace",
  "./.git/objects/96/529791cd6369a7506442797f2caa557eb8d32c",
  "./.git/objects/96/987c45f78a04e3deb9c15336f5cab0d82c82bc",
  "./.git/objects/96/d820420cc7cd79e7e5f5dc0925cd546b0dc698",
  "./.git/objects/97",
  "./.git/objects/97/4d362e05dd55738e14b41d60e0938f30feab1f",
  "./.git/objects/97/66e4a1836f01ded934c3872440ba055e2e60fc",
  "./.git/objects/97/67197db8a8ed5ae614d4ff52c03d819545071d",
  "./.git/objects/97/7a23d08466b369edb233bc71ae8938c9796304",
  "./.git/objects/97/7aa4ce1b5b34e7d52e81f70300f3aa66e99f45",
  "./.git/objects/97/ab87d5662239be98c30c7173c33716cbc8eecb",
  "./.git/objects/97/c7ba364faa7a1dbe486d9f60ba64184f3cf0c2",
  "./.git/objects/97/dbf6c324049e47654d72b5dc100a31b3348fb7",
  "./.git/objects/97/ed13872f80ad32541c3dd4d0d64d79d05efd4f",
  "./.git/objects/97/f61b95594f1df19d70a33b475908e0f0365c04",
  "./.git/objects/98",
  "./.git/objects/98/091032fbb44b9efd67e88e07485471d0844648",
  "./.git/objects/98/0b788dac36664647a592383bf7192a6e750adf",
  "./.git/objects/98/617e3b0c48f32528ab7edc2dff4937c03168b3",
  "./.git/objects/98/e798583772337da56e02864fade1267e017448",
  "./.git/objects/99",
  "./.git/objects/99/636a74295091299978054acab85210693ccd18",
  "./.git/objects/99/760e07c1b5be9035361ac8f61ae96fef6ebc87",
  "./.git/objects/99/8ee089c257ffb815b61ffa73681852c3b4c29b",
  "./.git/objects/99/947fc250df2469d3997a730241812382161183",
  "./.git/objects/99/dcf412ac10212a9c514f22419d1456f9d363b6",
  "./.git/objects/99/df2baa822e9e18a96ab56f58800bd3095deacb",
  "./.git/objects/99/fa2528f8f734f9453f32989c5b63644e466132",
  "./.git/objects/9a",
  "./.git/objects/9a/012c5ed6ef069b3da4023c0175e9b609523b28",
  "./.git/objects/9a/175ca82f0475f85f875dc0ad95e99282592646",
  "./.git/objects/9a/305cb20c617d56f133a03042472161c087a3b1",
  "./.git/objects/9a/972e13adac2667c371f31b622484e5920ba705",
  "./.git/objects/9a/b82c2b00ae5900b8003d419eb80393bcb0ff77",
  "./.git/objects/9a/b8e2ac5fe9aa1ba94195b8705b2f8f809137b6",
  "./.git/objects/9a/d6694a782d9eae176508f0a6971f5eba80bc2f",
  "./.git/objects/9b",
  "./.git/objects/9b/002b52cac1c71134455a0225a7919bb9fd456b",
  "./.git/objects/9b/2554cbbc2317654d7a32cca3f92fdd0e7119e7",
  "./.git/objects/9b/43886a2bb04c516e20bd43c8e8ab9aca62d530",
  "./.git/objects/9b/5ab327ccdb7fa1872eeff580848c8159988fb5",
  "./.git/objects/9b/7ececb6d8b9d2c9b5215282afa76e510d290e0",
  "./.git/objects/9b/abfc2492433c8af067ebbff8b9bb4e28708ad9",
  "./.git/objects/9c",
  "./.git/objects/9c/14eaa0c7f30e62a6f52ee42fb2193252a83ce6",
  "./.git/objects/9c/4d884ec6b9271ae5c63dfd8a26d28d021fe0b6",
  "./.git/objects/9c/548c3e53e11d1b52345825faf0316cb6e2c376",
  "./.git/objects/9c/6350bc1b7a0f112c6ff36981a83c8e9eb4d053",
  "./.git/objects/9c/8d5a7eabdea4b18c0a474aba5d066081b538de",
  "./.git/objects/9c/9c8020c9cd45247ea768d0c919a1ad53fbf371",
  "./.git/objects/9c/a14eede7ad82a7bbcd0c146da65461281956cd",
  "./.git/objects/9c/ccf6df8ef80fe4d72fb6adde89b76c6b62d4eb",
  "./.git/objects/9c/e9b392c43dfcddf9635ae47dbbe6a9e6079d39",
  "./.git/objects/9d",
  "./.git/objects/9d/0160f512d364b5f066a79842da3dbb0bb568bf",
  "./.git/objects/9d/1437535f3e07eedbab8d0a54318516625adbfc",
  "./.git/objects/9d/28125b17171e4ef5789c75638a77b6a34e59ba",
  "./.git/objects/9d/46793567e18c82b5fc4adce6cacaa7fb38ebef",
  "./.git/objects/9e",
  "./.git/objects/9e/1f8e02eace2bd5d5974a21dcdabbb3d1e385c4",
  "./.git/objects/9e/6c427468fcb60034be501b93d2af8f0f4f392c",
  "./.git/objects/9e/d3f73e8fa803419061373a5834e7bf30d75321",
  "./.git/objects/9f",
  "./.git/objects/9f/22cc1a898dcc911661495ea67c6fcecd2727e2",
  "./.git/objects/9f/3a468472801c8bbb8c58961cea7297892356e7",
  "./.git/objects/9f/79aaf88725b6ef2d6a072f59125148e9290a56",
  "./.git/objects/9f/b5361c712bcc918d0dd3891c9d4e468e167977",
  "./.git/objects/a0",
  "./.git/objects/a0/2943d482a703ffe69ad3b6884adc46472ed93b",
  "./.git/objects/a0/4818f88cbba5d38f2716463004a8720fbe6c88",
  "./.git/objects/a0/82f2d4835c8bf5eb06e0219bdb3567b5c3d77d",
  "./.git/objects/a0/855271dabb57440936af2e67ebcf7fea0b9cce",
  "./.git/objects/a0/855ecf506aa0ae0789b69d49783b8179a76058",
  "./.git/objects/a0/ae1142e89eccfed33de220e6b90e23489bf2cc",
  "./.git/objects/a0/dce7b4f70ec807c0d42abce41b4ee7c55f1624",
  "./.git/objects/a0/e416709a82edcf355c209271a5d44daf5d2803",
  "./.git/objects/a0/e5b83e88e1a3491b9e335cba6a9a178a94186f",
  "./.git/objects/a0/edd718605b8746b1dd6fabb54c1ef9b2a7f8f8",
  "./.git/objects/a1",
  "./.git/objects/a1/09a498c0d3ddb3de12f558a853a64c5f393ba6",
  "./.git/objects/a1/351c46fd505347397e50731fa2a1392c4b095a",
  "./.git/objects/a1/43c1886f77c9277896195555df3bcd53675360",
  "./.git/objects/a1/55a79e3f25619bfa2cbc3a8cd4fb5b4aa15d1f",
  "./.git/objects/a2",
  "./.git/objects/a2/40788ed1171baa23d5637982e0021a6c1c40fe",
  "./.git/objects/a2/8b361f3836eb6b11d15d279c6f10b4ddbff649",
  "./.git/objects/a2/bd4ae6877ec447b41ee426c78429d98d1a05ce",
  "./.git/objects/a2/cddb9b8875dd1d03ab775b207607b261fdaa45",
  "./.git/objects/a3",
  "./.git/objects/a3/35fdc9c9426979fa366cd2ebb21402a8d32f44",
  "./.git/objects/a3/4b7cca246ba29da97dbe58a6e93d9fb9e67560",
  "./.git/objects/a3/4d667bab3db0d737dccd853863ef29faf2a925",
  "./.git/objects/a3/af6d032a09661eef67e6c43e03d64a9b9031a2",
  "./.git/objects/a3/c2222fc25b28c7c16fc4d0072b0ad6557d4fa1",
  "./.git/objects/a3/d2fd571a3612b3c7d10bf53538f5d83429ec65",
  "./.git/objects/a3/f05f0b6975d5e381b11c6105d1fa47e2a69622",
  "./.git/objects/a4",
  "./.git/objects/a4/7383fbd3e01b4648e695e38a1e321391915c9f",
  "./.git/objects/a4/964cc1c4adf4dec8090c2c65fb5db088399410",
  "./.git/objects/a4/cec6cd7e1b49fd7f250d2c4491e749113fe620",
  "./.git/objects/a4/d7fb31eb9e3d189b6a36fae9f110dd8bb6cc43",
  "./.git/objects/a5",
  "./.git/objects/a5/083a049d037e0707ba1ba2199a67b25e09a8ba",
  "./.git/objects/a5/2809cd9207bae0cab459f7d5b2a093bdf3be78",
  "./.git/objects/a5/cfc63efb4815e863d7b1ec0b22d8f57e293279",
  "./.git/objects/a5/d8b97350f821f9ad980520722385f935595661",
  "./.git/objects/a5/d9003d6da8d81142dd09134fa27a14931275ad",
  "./.git/objects/a5/eff400483f31ca10833af91024708448505d49",
  "./.git/objects/a6",
  "./.git/objects/a6/2b993eddaf7826e5d0ed6264e6c56d415a321f",
  "./.git/objects/a6/50634baa43c5860a4b07fdfdba93ae52d386f6",
  "./.git/objects/a6/61ffc2c7b43bb3d1d87e2a2e39687b8ec82b6c",
  "./.git/objects/a6/c210ef5a20ccf3f8a917bb331aedc60df91bd7",
  "./.git/objects/a6/dc6064803be7095481a12b29603337d4c49eea",
  "./.git/objects/a7",
  "./.git/objects/a7/2e26d9bf5ec0b4ad2ecb71cde71519bb657c77",
  "./.git/objects/a7/2f813acb3279736f76a4527b901bcfde8e3d2f",
  "./.git/objects/a7/587df96ebf7d328f38cbdcdf2d0babb53a52d3",
  "./.git/objects/a7/7adcdd5f89aabe0c4d519d6b78f60209c114e2",
  "./.git/objects/a8",
  "./.git/objects/a8/363946b76587a86e8642f8e6a81b597ef22622",
  "./.git/objects/a8/591eb66b987a023c3bd2191cf9ef54696746c4",
  "./.git/objects/a8/796d9ea65abda5d690acb40aca2db684048369",
  "./.git/objects/a8/9bec9278c80695d5e66e4a5cb67d690054475a",
  "./.git/objects/a8/9d7551f0723605bdf7c83a78ebc58743814465",
  "./.git/objects/a8/ce849c6a03fe0fdfb996f0c34e038de7726ce2",
  "./.git/objects/a8/ddc8d7b5f479721cc8d642e448afa262bfcca0",
  "./.git/objects/a9",
  "./.git/objects/a9/0017c1056cdea358bfe8a7c359fd0b5527a667",
  "./.git/objects/a9/8af9fcdef45b58835c1609e03c7db0d894209f",
  "./.git/objects/a9/bf3126ef7e435105023407fd3aec8b8d9b6cee",
  "./.git/objects/a9/ca1fcc9727ac6c3aa01668e75e07346375a889",
  "./.git/objects/aa",
  "./.git/objects/aa/33cad061f7bb69a6de8241a358202064350571",
  "./.git/objects/aa/7cbca05860d98f08af801efbea255110bb8dc2",
  "./.git/objects/aa/9ea457c8661d1139ef324ecd2e5b5a6f7627d6",
  "./.git/objects/aa/b9a09de5be6779664e14d7c0d27381ce9769be",
  "./.git/objects/aa/cfdb289c323064886f7137fe9af811bdaa2033",
  "./.git/objects/ab",
  "./.git/objects/ab/267923521bdcdf93a62b6bce7a378b1f404730",
  "./.git/objects/ab/67d5c76a6a2d042fa04b9bf18b825c7fe8c19f",
  "./.git/objects/ab/6f59ff241e5cfbc9ba7ca1a99c36fbc3ca1820",
  "./.git/objects/ab/bc200213edb9a88c325c59e0e88424e1ec56bb",
  "./.git/objects/ac",
  "./.git/objects/ac/0718496e32473b5f2f816ebbcbe3c43ee496d9",
  "./.git/objects/ac/198bdd413fc93b79814b3c823a2e88f86a66a0",
  "./.git/objects/ac/6c1e75074be8eff03834109f23276ac2413acd",
  "./.git/objects/ac/852819376ca3fed89ed742c0f8c0c37e406607",
  "./.git/objects/ac/9b3129b2eea2fa1c2adaa80e75d7f0066670d2",
  "./.git/objects/ac/e0cef5c5435b51841a00754def39af9b0052ba",
  "./.git/objects/ac/f7188b921a3d9f74369dcaa7f11864f64273bc",
  "./.git/objects/ad",
  "./.git/objects/ad/7239c719cf383a3a774f5a0c9ce99521d6ebcc",
  "./.git/objects/ad/858a04bdbc2dbf3be646a2759a6f5feacd5053",
  "./.git/objects/ad/a3272a9dc153546e81e2c6b2348caf1304731c",
  "./.git/objects/ad/c696f84ea821feb3ab93ac18728f7f23120c3a",
  "./.git/objects/ae",
  "./.git/objects/ae/02010f24997cfc1e5ce82f73609d3925803cf4",
  "./.git/objects/ae/548122e1283bbb227acb5c149bdff8a7fd6155",
  "./.git/objects/ae/8ed5c7300686c6917a23d253cda678d8f268f5",
  "./.git/objects/ae/9f3f61fb8317211a5d5b1da5482126932b4b3f",
  "./.git/objects/ae/f0250b7f704139a0147509840dfbb5491e4170",
  "./.git/objects/ae/f5006c59616b1de4f713a0a62237b94ea8ee13",
  "./.git/objects/af",
  "./.git/objects/af/26bb32d6ebd7f8d119030654321ea7efeb0711",
  "./.git/objects/af/40e2c96de11f1e5f43ec15407979882b283430",
  "./.git/objects/af/7b8908128ab8e3bb1dbf63b0d016a1ee825bea",
  "./.git/objects/af/8c35e25db934bf17bef23679c6bf6b3fec5934",
  "./.git/objects/b0",
  "./.git/objects/b0/46401f9700665de42e59d4a182eaa06a954780",
  "./.git/objects/b0/5eb3b127dbf769b9a43b9eec02ae37d97c2f41",
  "./.git/objects/b0/5f8c6d2cf2b8bfc7b09c719f16783f514492d6",
  "./.git/objects/b0/948dfb0a88e296f1a6c29f75688234d8650b59",
  "./.git/objects/b0/a49cebbf519de985d5ff38cb24ee5d3438f5d1",
  "./.git/objects/b0/c4577b2fe8f7722b1e2e40e54a1469c2ee5ac0",
  "./.git/objects/b0/cffd1b60ad69feb1bd19e48772833df9fca9ae",
  "./.git/objects/b1",
  "./.git/objects/b1/0e3d86f2a9d808b0a324fed8606b40c8420eef",
  "./.git/objects/b1/4fe678c35767a563581c0bc6d628d0137dabaf",
  "./.git/objects/b1/543da8d9c5870ce28cd74796aecc1e3b3ca023",
  "./.git/objects/b1/65320d0cdbbff36d1c262793e9d43a8d7606e3",
  "./.git/objects/b1/7915c5d6e08c46b2e54d83efae6119c72b1303",
  "./.git/objects/b1/806f1ca9f71490a9c3d618b65f422533b55e10",
  "./.git/objects/b1/92b428741a8c0839b388da2719dbf298d42c36",
  "./.git/objects/b1/988ed7e5724ae7e3e264d10a20fa0ebc0e9690",
  "./.git/objects/b1/aabb3b5d2e9765f4fc8083fafc27ca539324a6",
  "./.git/objects/b2",
  "./.git/objects/b2/3f108561f871f4b9b167eb53fe1afec223deac",
  "./.git/objects/b2/6c2ffc53de62093efba7056ad29941735a15bc",
  "./.git/objects/b2/9b3cf15282c5f7288958313f4dfab5bb06a53f",
  "./.git/objects/b2/de6d2c7c8f6264aa1900f80a8d8bbdb58f6599",
  "./.git/objects/b3",
  "./.git/objects/b3/2c623a49098aff266d9f29ea3b050da51a6fa6",
  "./.git/objects/b3/2f404a81e4ae631cb1669bfbbed788ce008395",
  "./.git/objects/b3/44853a1972312acc34ad41714bae261a4879a9",
  "./.git/objects/b3/472fe00d00fffac612393f3eeefea78d26289b",
  "./.git/objects/b3/5762b4fe7a41c961c556b897a76468cdf938d7",
  "./.git/objects/b3/a62f89cedfd5ed1fabe57c536d6aec2b684ccc",
  "./.git/objects/b3/e0c8a9ffcffa522465856191f8218ee0e9e106",
  "./.git/objects/b4",
  "./.git/objects/b4/523cb9001a4fadf71b063e1a0e3ff0d7e55cd4",
  "./.git/objects/b4/6e43e9a2de3766fd0e244e32beb92aff8d5914",
  "./.git/objects/b4/d09973828c950cc4a22536899d13498bfa444b",
  "./.git/objects/b4/fbe9af2de1afc6656469b38715d64f40a6aba9",
  "./.git/objects/b5",
  "./.git/objects/b5/343b745cc1a833b643c685ee5a64affcca1a8f",
  "./.git/objects/b5/4378438d0a8d0de78ade5d2a79c96db025e9dc",
  "./.git/objects/b5/9f43b0da2dad24a86aedd452ecdbffaa29a594",
  "./.git/objects/b5/a1e56a29309610f071a5d8948dd3da126c2da7",
  "./.git/objects/b5/cb0297d94337fef1a505540136fc602acd9c96",
  "./.git/objects/b5/e52d63b573016143aa09a7b6a2059bdf1a5171",
  "./.git/objects/b6",
  "./.git/objects/b6/3bc078719b02d7e883ade8c7944f35c912a902",
  "./.git/objects/b6/53a8cc5026236621eededb73acff6dc9008ca1",
  "./.git/objects/b6/5fd2b205adfec5f7123d2c5b27815b86ba5596",
  "./.git/objects/b6/660d83329ab536772b45598d14907e689b2d47",
  "./.git/objects/b6/c8a520673e5b362fcfbc0099906095f81489d7",
  "./.git/objects/b7",
  "./.git/objects/b7/0572db4e36360aadc7e6361c4bbb7a02334f9b",
  "./.git/objects/b7/67c02265dd76e29410654884ac4bce39b4c4d8",
  "./.git/objects/b7/869dead228e00b5644f1f7ee5c19f5b10d5155",
  "./.git/objects/b7/e45694482176a482fd6a40392b27d1a47ed687",
  "./.git/objects/b8",
  "./.git/objects/b8/45bbfa6cc0651c77e1444f461b2178649ac3d4",
  "./.git/objects/b8/71989054b0edc3da7c5490212237b650c4282f",
  "./.git/objects/b8/aaaaba277563744647161c66327f739ba2e079",
  "./.git/objects/b8/d2130ad608c0cadba9607d337383972d9db653",
  "./.git/objects/b8/df14cc0851c2afe1596cf251b869031077a63d",
  "./.git/objects/b9",
  "./.git/objects/b9/409e1eaef02a6f23e516f48f776c6676f590bb",
  "./.git/objects/b9/71df8650534e32eee147d18ea020d999edd191",
  "./.git/objects/b9/772ec0be71f1ab9e10e041b7eb05862f2a11a5",
  "./.git/objects/b9/b1e26bae346984e04ad32f07c7a46e29ac809a",
  "./.git/objects/b9/bb611d73c4b5adb7e4cbd75d561879780755cb",
  "./.git/objects/b9/bbdc5284813fd218bd9b1300d3f0d6c893f564",
  "./.git/objects/b9/cc99f99fe987d6fa04f475c1b113ecaae405a9",
  "./.git/objects/b9/fbcd57e7ff8e16c83626c60cd717d779b9fb50",
  "./.git/objects/ba",
  "./.git/objects/ba/0364b6ec9099e1aeb56aab06c96fa3fabad9a3",
  "./.git/objects/ba/48f03658765d977cc7916d6967a0b2b33f3883",
  "./.git/objects/ba/839011786dce1e152feb6911db0fbe4230db42",
  "./.git/objects/ba/8524a3f867500e5609649d837ef67c3b0ff893",
  "./.git/objects/ba/de6cec6b01ab1c62d24a4db45158d47bfa9444",
  "./.git/objects/ba/e5e6e22427af129d8fc7663adb64deadaa2848",
  "./.git/objects/ba/fb31594b2160c24cb7096a50c219ff323a4c27",
  "./.git/objects/bb",
  "./.git/objects/bb/61d0b46f9bfcb72f88e1c4833eceea36e4a193",
  "./.git/objects/bb/748b5d946d7f01a68e4d413bfea17e49d6ebf2",
  "./.git/objects/bb/9f29afc3fb08f5150b20dcf9017f33144af3f2",
  "./.git/objects/bb/e3dc1d70dc168ce45e12601ed5d44f27ecccf4",
  "./.git/objects/bc",
  "./.git/objects/bc/21cd541db722aa94bd6b37b1e0f929c5a625fd",
  "./.git/objects/bc/24a6d47b1719aa913263d09647f4f987dbc7e3",
  "./.git/objects/bc/4e7b769e8fde82b25bc0dfcdbb706fa22871f2",
  "./.git/objects/bc/74b85b9e2c4c17da3a058236e9e91ab1c0e4bf",
  "./.git/objects/bc/7685219d18308d68829edae7c44adb9695bb67",
  "./.git/objects/bc/85df41119235599e77a7d8a59d97b89be40442",
  "./.git/objects/bc/e299fe206533243b1818d4f9e9a79f070679e5",
  "./.git/objects/bc/fe61d0e89b4abf2851cc160d2b7cbf11d73441",
  "./.git/objects/bd",
  "./.git/objects/bd/659bbc5ed379874d8ad546f02ea4d649ab03d5",
  "./.git/objects/bd/7245db843596fb7eefda1bad938c080a69b458",
  "./.git/objects/bd/c046e99b5707486eb091b97e9b1ae19413ddf3",
  "./.git/objects/bd/fd815939d990aeb6a4e16b603d68abfbb1b020",
  "./.git/objects/be",
  "./.git/objects/be/0004d76ef5171cf46fd500a499d32293fea4fb",
  "./.git/objects/be/1092426ab620df79b836920f85f78494e5dfba",
  "./.git/objects/be/44c9e6083c72d0ce5cf5a1903a0f61a1b42a89",
  "./.git/objects/be/86a2c2833cf9936f1444354ec50cf6105a8066",
  "./.git/objects/be/ca99f8f67d15edf4ee3dbd6ddc87d4d29dd902",
  "./.git/objects/bf",
  "./.git/objects/bf/406551b096387a398841efd202c3a51a7043c0",
  "./.git/objects/bf/47a90085377fd5650a1db50ecd0959763d5c32",
  "./.git/objects/bf/86aa51a244466d2cbe375dba5e49b82b3183f8",
  "./.git/objects/bf/8d6fcd6e3fecd74904417c3e70d67713a8630f",
  "./.git/objects/bf/a39e3afb1fed63bcfbded02d5958fba7894a05",
  "./.git/objects/bf/ee91959acef75aeef81a0367a4d7d1f315e5c3",
  "./.git/objects/c0",
  "./.git/objects/c0/0a7b2c886f542bed34a2aa0a52578234392d5e",
  "./.git/objects/c0/81b0921c24ac9bd06f36e68cc6aa56974daab2",
  "./.git/objects/c0/f342f0c21f4f51f1c693eecdf01e2429ab0016",
  "./.git/objects/c0/f6d1567ce5b927f670d06aa61792b5ad932c7e",
  "./.git/objects/c0/ff71225915f18057f48a18a483489a37c5c3e2",
  "./.git/objects/c1",
  "./.git/objects/c1/06849d575fcf38e2de56e6e533cd183faf4662",
  "./.git/objects/c1/646413f490628c4efd26ed6b21385676c6cac9",
  "./.git/objects/c1/ad094deeb9be049bb3651a84f703734a3e7fe7",
  "./.git/objects/c1/d13ef446c1f1e3adf52fc08acd6833d7cffeef",
  "./.git/objects/c1/d2301174a3dd10e32c34d12554ab856decf51b",
  "./.git/objects/c1/dc1079f4441cdd89310d3cbfecc14878c104b2",
  "./.git/objects/c1/ec5e9e552e403cdd41304d24dde726e41edfcf",
  "./.git/objects/c2",
  "./.git/objects/c2/0125b387f27b5c1c33036c52584687717d9a8b",
  "./.git/objects/c2/3f47d50d328e04ced587bd755ac8ffb911838f",
  "./.git/objects/c2/6dfebd79e64d769ecef7ff198c9511b1fbcdd4",
  "./.git/objects/c2/7777a67381aa2f1122caa365f05d8ccc3fc372",
  "./.git/objects/c2/7eb9b69e8b7f5c64d50090f0a969b95b942fc8",
  "./.git/objects/c2/81d63be352a3b95e53ca7e069c92f5cd4ab72d",
  "./.git/objects/c2/98bb96d30dc2f0d9f2c4571d15f5e075f2aa3c",
  "./.git/objects/c2/b245838c4d43e7d3fa20f4f542159b2f771327",
  "./.git/objects/c3",
  "./.git/objects/c3/0c49055fda9acb59273176ac7fe1673db83b86",
  "./.git/objects/c3/40f0c1c43c83416df88c469213a9622bb51d6e",
  "./.git/objects/c3/4b345f7e0137748298c9cc443dbe83ed932976",
  "./.git/objects/c3/57972d0fa938da0674a72e348f965f9459bff5",
  "./.git/objects/c3/eea59cbc068ecf00f7c5ad83796c041f951459",
  "./.git/objects/c3/f910e9b2830ab584f3654ccfef18b9552f9a7b",
  "./.git/objects/c4",
  "./.git/objects/c4/025779188831d30e3a5147bbce1c5b0620402e",
  "./.git/objects/c4/18bf4441be5be9257c5ed46d730148a94c9abd",
  "./.git/objects/c4/20e9e0d9fd1d886de32d75dcdf8ea165541cf1",
  "./.git/objects/c4/580cface47fe4adf6a03fcf05453e14675f6b0",
  "./.git/objects/c4/81013f28ff422b3fc9febf13c6557ad009a28a",
  "./.git/objects/c4/9b3854f049176956ae67ec4408d32633d8ed5c",
  "./.git/objects/c4/c738073a5f2e3058eb81c2df5a6bcc5361c75c",
  "./.git/objects/c4/c8f0c5990c1a56fef75e208b2792f04767db70",
  "./.git/objects/c5",
  "./.git/objects/c5/170001395c03e19537a8aad1a5a7b9aba41c8e",
  "./.git/objects/c5/78c99505b0fca8b24d9803b49a1f0caf022b24",
  "./.git/objects/c5/9e5807089c9814af46e46efc86f57699e7a271",
  "./.git/objects/c5/a2ee97186713cf55f5e689ec56bcff4c83d2bf",
  "./.git/objects/c5/c14615a357d70460f2db4a783e762e202efc4f",
  "./.git/objects/c5/f9b4bf2088982fafb3b3fc1c1699c4b22a384d",
  "./.git/objects/c6",
  "./.git/objects/c6/4b93ad82be0afcb53b75555afa143d7787619c",
  "./.git/objects/c6/86f253b729cf34852d9bec3375d7942c1e0b90",
  "./.git/objects/c6/98609fcea0149f794fc3248c3ccfb45bf51f7d",
  "./.git/objects/c6/f98e76adde1cb0ec6138c598f14cab5de7a342",
  "./.git/objects/c7",
  "./.git/objects/c7/1a5471db6cdb0f56d731a89e22661ce51064dd",
  "./.git/objects/c7/5ed1e8f6589a043c0cc184bba7fb2c8ab084ff",
  "./.git/objects/c7/7660c08bb3a4562c516221353a28a8878f72ee",
  "./.git/objects/c7/98cca622a80361e113516ad71aad185b1effad",
  "./.git/objects/c7/bfb7502c013c0f266ebf76fb9ea0ffafc45cba",
  "./.git/objects/c7/c2a5d875aaf54e6392ef299f618e68ae90b2d6",
  "./.git/objects/c7/cc25a29903155baa1303554e5ecd2ffca4ce85",
  "./.git/objects/c7/cd2a703d426c837fd5d258f5cb8202b3b6670e",
  "./.git/objects/c8",
  "./.git/objects/c8/02a5f64aec9fb03bf2854aaf0e073ddd22c9ce",
  "./.git/objects/c8/08b7bcd5e60584ac859fd7ab7ab1abc2d553c1",
  "./.git/objects/c8/65ecb6aa7a150c076a17f66412bd93965ba865",
  "./.git/objects/c8/87dff8de9d919e98e4a8d0b4493f6edae460a0",
  "./.git/objects/c8/aa365394c095b595b8eca6c3e792059d3105c0",
  "./.git/objects/c8/c38a2b5dadb40b2e1e00cffa4d4a2dcee823de",
  "./.git/objects/c9",
  "./.git/objects/c9/0b5d53995b369f8fc7402242aa45457d349257",
  "./.git/objects/c9/7f12bbb0ebc92f183073ddf0edf72b28560b92",
  "./.git/objects/c9/9fbc18a918a66a86c0926f6044c1e309350d59",
  "./.git/objects/c9/c921bbff3bcf64258a05e0330c84d66eb1e761",
  "./.git/objects/ca",
  "./.git/objects/ca/069a9b0f8505a1315d5d512ed38a31983b6f33",
  "./.git/objects/ca/6f945e7046afdfecf86be61aca106f75cab4ae",
  "./.git/objects/ca/7249358109d9fdb0adc51f9b5571346733adcf",
  "./.git/objects/ca/9d0f8478980f962b302332807ec9dbde8da204",
  "./.git/objects/ca/a9c743a6f70a3c7a1c3da4493970cb8fcf7cae",
  "./.git/objects/cb",
  "./.git/objects/cb/1ccc4b9e3e28f9fd891a27c7a55919d018c23d",
  "./.git/objects/cb/58facae5926adc7cea292d1fe78b7c28442520",
  "./.git/objects/cb/7442f6863eb8b33211c16fcdef950c67136c27",
  "./.git/objects/cb/a065aebbc8bc01d79b31524e498bb1e6501c2c",
  "./.git/objects/cb/de8396fb106cabdcc8b095f99f8a74a7abe8f3",
  "./.git/objects/cc",
  "./.git/objects/cc/2858961627d601638a61c16c3bc784c94a13af",
  "./.git/objects/cc/53c35d1f7c4364c5e2be75b383dfbecd2574ee",
  "./.git/objects/cc/6e71fab36603a4026aba4b511a1b5aa0f5f605",
  "./.git/objects/cd",
  "./.git/objects/cd/3ad94fdcd02e36462233f2a0f62f2b853d8bfc",
  "./.git/objects/cd/3ae2c2d7ca6bf8bcac252ed0028f35f83a0a68",
  "./.git/objects/cd/40de7aff335c9ace3e5b5a69e2059765c0e224",
  "./.git/objects/cd/4f427457415ce51b68aded686cbdc1717672e5",
  "./.git/objects/cd/6a4ead71a0a7c9972f9886d1c5da71f653f9d4",
  "./.git/objects/cd/b7cd3471e5c7a6d09a35f900139a84c379266e",
  "./.git/objects/cd/c8c4c4e8529a773cbe40dd0f7f29112860ed04",
  "./.git/objects/cd/dcd9652abefe8f24138120f335c115a0e5e075",
  "./.git/objects/cd/e1a38762cbd5127c95ee44fd85304cfa089a17",
  "./.git/objects/ce",
  "./.git/objects/ce/0999e28ba0ce2efeb8b7facf668caafc08c226",
  "./.git/objects/ce/0ea52ce4111275e166ca737c9217eef4ac90ef",
  "./.git/objects/ce/31b88719bfecbdba056af1ec5ca7e6d9eb29dc",
  "./.git/objects/ce/7458c0d67bed241ca27585c2952cd8920411dc",
  "./.git/objects/ce/7d41c3597c6a510544ed028693e331bcd5a271",
  "./.git/objects/ce/ba51ab5bf166a227dfe0bf4e65850c0a110921",
  "./.git/objects/ce/ba677095131f136ef349cb55754a7fceea4215",
  "./.git/objects/ce/d53fc500be2b94b5c6cf31d35e3800afb4eac2",
  "./.git/objects/cf",
  "./.git/objects/cf/1fa4568871cde8fa3d85cab0a5c21f1113ff8d",
  "./.git/objects/cf/77edcf51255b5d79eb9c9ff076e364305dd8d1",
  "./.git/objects/cf/8b71bf7ba06f4b14a6abe5b991c9ec49aa49c2",
  "./.git/objects/cf/a6dc6373188f317ce68bf763defc593933215d",
  "./.git/objects/cf/ae44ce3ecd645bbb74a3e6e569b70e64c0775f",
  "./.git/objects/cf/d492c73b217c63a8f9be6ac7f994a0f9cf5e9f",
  "./.git/objects/cf/d5f97905d9406954dfa39a4d42afbbebbf7157",
  "./.git/objects/d0",
  "./.git/objects/d0/0e22610ffe9d0bfc0fba5bd459cef3f7ac75ca",
  "./.git/objects/d0/776a869f5c8669502d852a8502d630ef937ad8",
  "./.git/objects/d0/78349f4630623494e1767574494cfbd2414272",
  "./.git/objects/d0/78b2d41306c3dc3e9a4f3623c2dde38ddee951",
  "./.git/objects/d0/9b5d63a8e257a3b16cfb313706bfb4a703088d",
  "./.git/objects/d0/c06216564b5c90935ab4bfa56bc5277d2de2ea",
  "./.git/objects/d1",
  "./.git/objects/d1/5f7361f81dd298c133148420ddb73732eb9514",
  "./.git/objects/d1/97cd9b09734ddffec4478f40e59c423e8f3803",
  "./.git/objects/d1/b717c87a719bcf6e7d1c72a225b0c368b85534",
  "./.git/objects/d1/e0d35861cabff6dbbf4c24b68d94fe025d2c3d",
  "./.git/objects/d1/e1658cafc44603bef16752dfb117036a2f5db1",
  "./.git/objects/d2",
  "./.git/objects/d2/14e867ba3d00c2d5790dbd0c86174bef59155a",
  "./.git/objects/d2/38663afd176588e95c13f1d38503b4c88c41be",
  "./.git/objects/d2/57149418879f5992c27899b8efc80ca17ec6e9",
  "./.git/objects/d2/7865f49382293dd1211e4b1e568d6ab9304c52",
  "./.git/objects/d2/9f8ad72713f89b61bd39f00e3d69230566dec7",
  "./.git/objects/d2/d0288157853c003242bfb5d28a2570b64c8623",
  "./.git/objects/d2/dba45f26d92dc58a4943ba86b1f47470c26790",
  "./.git/objects/d2/ddd489734e46c481c94101f1c55d488b16c247",
  "./.git/objects/d2/f37c2c7a3c393c2244cea575809efdcc4aa596",
  "./.git/objects/d3",
  "./.git/objects/d3/38a0c2c6d5615f2c53f7a215a84c2d5931e5d2",
  "./.git/objects/d3/5413f46c2caec744fcaba642f865a020fbeaa3",
  "./.git/objects/d3/72769bcd16976371793271ab2c1840e00d41bc",
  "./.git/objects/d3/bac322aad6324a2ba972be8aa2d0f509b4e839",
  "./.git/objects/d3/f28fc3759d83622b4388bfc90b1120aaca66a7",
  "./.git/objects/d4",
  "./.git/objects/d4/20ffa36aefda3c2c9e051136c530ab6b51d5d5",
  "./.git/objects/d4/2e150a497ab84d1880e6fd2be9adc6ab7fb761",
  "./.git/objects/d4/aeb83344c7ff53a4ce0003ecf9ded7f6d82292",
  "./.git/objects/d4/cd1e3348824da24641c305eb9f31c89af09072",
  "./.git/objects/d4/ecf8b78a84ec0f2dd6856f6b8f0814bd5ea011",
  "./.git/objects/d5",
  "./.git/objects/d5/0fe0b8f586c5f55c271e4f9dd1ad3ecc669ec3",
  "./.git/objects/d5/4798d673ff9070245e642d2e3b22ed958a72ec",
  "./.git/objects/d5/5ca9bf3997cbd1f7c58f0010c513eb047744ca",
  "./.git/objects/d5/8dfd02f723ab74c4b29b2ae08874f208b9cf67",
  "./.git/objects/d5/f6ff925a321834de2b0dc24cd34817364afd7c",
  "./.git/objects/d6",
  "./.git/objects/d6/1b94e47eb4da2127e30017d12f620217508bc0",
  "./.git/objects/d6/65f2a281249296c1f1ea7a3fadfd6538bd3edd",
  "./.git/objects/d6/6dd2990b4f3edfdb000f314cc813da668eeeba",
  "./.git/objects/d6/9a6f70074ecdfd02cf203677ae715c45390dd6",
  "./.git/objects/d6/c227ebb63f428cb3a1e6fee07d927bb206ab15",
  "./.git/objects/d6/e07530ab99d879b6ef101f461a53d7cd6d4af7",
  "./.git/objects/d7",
  "./.git/objects/d7/1af40c13f58f66cd1cbb4a8ea811084498c463",
  "./.git/objects/d7/1d318641294e34a77ecd7c39d6dea9a314baf0",
  "./.git/objects/d7/83ea29e236014f26d2e88e0b910e2bb39070d3",
  "./.git/objects/d7/9677a0b580ad6a983269d1b9d06c9c78d35191",
  "./.git/objects/d7/99e2ffefa492f94efead2848911fc4b9e67a94",
  "./.git/objects/d7/bef9d28e991acf5a07118a470b50577d84cea8",
  "./.git/objects/d7/f4411d212c4189e0580267ecc3ad7f7f7dff80",
  "./.git/objects/d8",
  "./.git/objects/d8/04fbd18cfda91158f4e3e00fe01ff5753d7318",
  "./.git/objects/d8/199e104425493c4eb1e87f4ae2dc2f03fe8435",
  "./.git/objects/d8/93d68f76bd5639422f9d33e051ea5f178f8c0b",
  "./.git/objects/d8/9e23ac6d5c575186bf1def37493a5870586248",
  "./.git/objects/d8/d2e48427304e5dedb22368e5332cfafaa0ee54",
  "./.git/objects/d8/e40ea360044860d729c41221857af47960dc42",
  "./.git/objects/d9",
  "./.git/objects/d9/0bae11c4c03c8a56bae35f79b0a96f1ad0d44d",
  "./.git/objects/d9/4dcbe3727697d9c16137c7e7ce589fd535707a",
  "./.git/objects/d9/54f000f4d4064ecf3748c0c728bc49b0778903",
  "./.git/objects/d9/b7bc7bc68ba364d9163bf60bdf90a614d97440",
  "./.git/objects/d9/c0baa3d14849c43aac680096325e0dd9a0ba11",
  "./.git/objects/da",
  "./.git/objects/da/0b8413c35fe55b65cf3f4591fba6553fe1af1f",
  "./.git/objects/da/85bb761969f6233dd5922efc8e83de428061b1",
  "./.git/objects/da/c916b2f34d26107f69cdfe265ac3d6dcabeca6",
  "./.git/objects/db",
  "./.git/objects/db/1eac01ef2260d41307738c021a72b8fd0afc34",
  "./.git/objects/db/256c08bccf3d5ee7334973bfb24dbc7973771a",
  "./.git/objects/db/60f95ef4bec54f4f0040e3e3617b5416ec1e9d",
  "./.git/objects/db/71c479cfc83cc6c81e4cce93177a74f092f703",
  "./.git/objects/db/9984ee3874faddb2d6c880c80256d9d25a672f",
  "./.git/objects/db/c7d7884a2ac45966e85bf2f9c366cd8613fd81",
  "./.git/objects/db/f8177b9050cab59e73755d40f308ec249f25a0",
  "./.git/objects/dc",
  "./.git/objects/dc/38d6ce8b7fe76bb034c4e63deffdeaac5aa5c7",
  "./.git/objects/dc/95c25a806a40d48d36682673612f359ebb721d",
  "./.git/objects/dc/be8c8143ba2b6bbd1195d4d69f918dbb998b58",
  "./.git/objects/dc/c476d5f45f4c53e7b57acdc9a704623402b234",
  "./.git/objects/dd",
  "./.git/objects/dd/05f26b4dc7b7f7789c476a3e3a36d52853cc05",
  "./.git/objects/dd/983e95f2d36d4c120e00511f03d474eb84c403",
  "./.git/objects/dd/bbbc570e02c3d82f4df512e9e5d37a32b01092",
  "./.git/objects/dd/c043bd6a953070810fed92c1b50fe1db9c5424",
  "./.git/objects/dd/ed5503c68bcf2c8dc76fdada4499efca5db53b",
  "./.git/objects/de",
  "./.git/objects/de/3cfc87e9fa1cd1e4db78a17a2340bbfedca998",
  "./.git/objects/de/5cad4eae54e3bb76c5c82fdad8ff095392246a",
  "./.git/objects/de/97ac1a71e8544c48b27a3b3fc507bb31aaed8b",
  "./.git/objects/df",
  "./.git/objects/df/002e6cbb37f857725ac1e510633199991fdaec",
  "./.git/objects/df/6ee2ecf8ff541a08fe79efda007b6a7d5ac056",
  "./.git/objects/df/824e35346df10e060ef3f9bcb141fa8ae33d75",
  "./.git/objects/df/97e3ae052bf6ef670777b45c0774edc383b5d7",
  "./.git/objects/e0",
  "./.git/objects/e0/31777e6dd8bb5a9b38f0bba64a38e5ec76b92d",
  "./.git/objects/e0/44df490e075ff6fe028c761fe997c182bf3182",
  "./.git/objects/e0/4ec0f56fb97b26b78a6cdbe5d2a83292c071b3",
  "./.git/objects/e0/58b16806469cddcb8d89efaed78fb371385fe1",
  "./.git/objects/e0/67db4fead6496a5b1034e62bb9ab16ce478686",
  "./.git/objects/e0/792495c3df09ff8e150bc1625ffa944d3286ff",
  "./.git/objects/e0/7c014fdcdc6b433131e927c80be5938d484187",
  "./.git/objects/e0/b8a5ffcb2d2564fbc63010d04c828fb7277b2f",
  "./.git/objects/e0/bf77fba10644a7aecdcefaa9c2e985dd3afb9c",
  "./.git/objects/e0/f1612c8f16866842401293d9b905f736a56d1d",
  "./.git/objects/e1",
  "./.git/objects/e1/21a06054568019189685faedfd993a5970360b",
  "./.git/objects/e1/562fc5c8f85bcdc6688abf4442aefd87fd3263",
  "./.git/objects/e1/9776073e9715495b0ca9f2542e81e197b636d5",
  "./.git/objects/e2",
  "./.git/objects/e2/1067632fc9d35d58d1796ad39a1bd155213d90",
  "./.git/objects/e2/39af9e80bcb41c8f63e232e7b5015059448fb1",
  "./.git/objects/e2/3b0aa80c5d7e39b63515194f4c90bfd2cb9364",
  "./.git/objects/e2/57048aaa0f40e50eecc4088cf35d5fecce831b",
  "./.git/objects/e2/663f00a9d160fcd24fd163af43602b5d904e46",
  "./.git/objects/e2/6a853249c7974985c3a32b1539fd533fefc51d",
  "./.git/objects/e2/8a3b13a10dd3c10c7688ca796fb7fb906217f5",
  "./.git/objects/e2/c1d3a495cc13f5a11e842bc03cb84202c8d746",
  "./.git/objects/e3",
  "./.git/objects/e3/220d9d30ce0cddd9546537cdf653a47fa4cad3",
  "./.git/objects/e3/7102308af6069f60aa9641f02a4b5bea1c5c83",
  "./.git/objects/e3/8d91707f982d6a9189117b5864ed0ce93ed4b3",
  "./.git/objects/e3/a198e3a0a32be32c9a2592bd2728636f74f4d0",
  "./.git/objects/e4",
  "./.git/objects/e4/1d1d21d48f8bb8795c42b9b0474d8c4d2ce347",
  "./.git/objects/e4/3b0f988953ae3a84b00331d0ccf5f7d51cb3cf",
  "./.git/objects/e4/3ddce87efdd6d15d70df66c61c2754f4c9a435",
  "./.git/objects/e4/5abeaf1a6faa8f0fb4881c555bbd8e06df5fbb",
  "./.git/objects/e4/7c516a1b98d8d2fa3e7007a8150a97291698a5",
  "./.git/objects/e4/910422c0354424e0fa1d55aa816643fd10148f",
  "./.git/objects/e4/e5119b430662f188208d170abecc504c524e5b",
  "./.git/objects/e4/fcf0a633425b680ef242eb75e2dfd4c6f136e1",
  "./.git/objects/e5",
  "./.git/objects/e5/547780974aef2e1566033fca057b1024a1250d",
  "./.git/objects/e5/89f564f55f11ab1abb3a997b3822f9a23c5281",
  "./.git/objects/e5/f7f1768b328877c9882b5cb31ca19e0dcad596",
  "./.git/objects/e6",
  "./.git/objects/e6/23afd4305b61d76eff6bfcdf1b918f648da1b2",
  "./.git/objects/e6/9a4c940d016e57e1c482afc17ec5d82f6b3220",
  "./.git/objects/e6/9de29bb2d1d6434b8b29ae775ad8c2e48c5391",
  "./.git/objects/e6/c2d0fb0379ec112ad33e969e9c3867d57fc8bf",
  "./.git/objects/e6/d12f2ae6f8542946109707f004f1fb2c183192",
  "./.git/objects/e6/d8e6ddd142cbd7f72ea93ffbe384dfda44d152",
  "./.git/objects/e7",
  "./.git/objects/e7/822d1a259aece99ab9e9efe9d63eda3a6d5787",
  "./.git/objects/e7/8dc560071a4b4ad8b7289905d763136841c98e",
  "./.git/objects/e7/a60261d6b5929474f60564198c80e92d008851",
  "./.git/objects/e7/caa134000d13d8ea7a37cd73d11fd55f1ce266",
  "./.git/objects/e8",
  "./.git/objects/e8/39f172b1ea2bd62b38e5d07180b725df346953",
  "./.git/objects/e8/62cfd7bb58b731578256c7a08639c05357ee63",
  "./.git/objects/e8/c19bfb1629d213398bf9a497665bfbf7a230ee",
  "./.git/objects/e8/f1811b1e730715630f716e01480e34093c4b82",
  "./.git/objects/e9",
  "./.git/objects/e9/115cc34f1efb3284dc07e2a1f6769b8d18e955",
  "./.git/objects/e9/6fc793d7f7596a88b97982c65fae1ea7c15bb3",
  "./.git/objects/e9/75c00b6046e0b71d02429193c74c78943a4283",
  "./.git/objects/e9/76b306ff2f650071651e0d1d6f2c316a09e8a1",
  "./.git/objects/e9/841e25c1af085112f9c80d7ed907630ebc69f9",
  "./.git/objects/e9/867f4b72f23d7e1491f9d6a4919a12cb72cd60",
  "./.git/objects/e9/a9c3357589e40d0f7a191dc7ad73268ca8e556",
  "./.git/objects/ea",
  "./.git/objects/ea/1078706e0026af77c7451cb514b9e87c4f077b",
  "./.git/objects/ea/107de529b2783e6adc6d68db28434b5ed2a375",
  "./.git/objects/ea/3cfb1505fe4b84b90d36dc8b410dd60772a6a6",
  "./.git/objects/ea/8ab29779f86bb70f62ab4702407e3ee720b060",
  "./.git/objects/ea/d7e040473f698606bdcae973119b656a8240ef",
  "./.git/objects/eb",
  "./.git/objects/eb/01b000cc0308a06e5295137a42a810609b7dc1",
  "./.git/objects/eb/12679e8835250776daf7dc66be8e5bf37c97ae",
  "./.git/objects/eb/1fcae79847b9c3fc5dc1043484afe320b2398a",
  "./.git/objects/eb/5327baa9c64d85e410f1c673ce8f683d3b08ed",
  "./.git/objects/eb/599e0d0e4469109b12600ebba2d59cb90488ab",
  "./.git/objects/eb/776a9da6d31276517909296feb8734b95b804f",
  "./.git/objects/eb/90d8be93ae771a8322a14aca5cc85c0b4d3df1",
  "./.git/objects/eb/e5350d01a4dd155c1d029159ae23fb8a66e4bd",
  "./.git/objects/ec",
  "./.git/objects/ec/355b6a1b172d812d7a17eca4edea87b2cfe1ac",
  "./.git/objects/ec/7457b8a9ea0556c5872c66556f447ca8a40c88",
  "./.git/objects/ec/832140a7fc6d68b6aa4339228b4368f9d04a71",
  "./.git/objects/ec/9970f2417de51b1b8c56847045a4ee8f098682",
  "./.git/objects/ec/ddee85162af1cf6bd0231328395d0c86e497de",
  "./.git/objects/ec/e980f1e9f7bb3e0fd4b8f2b4a5dd005db1c459",
  "./.git/objects/ed",
  "./.git/objects/ed/05c80991c52387a07d581ff66772a43660a338",
  "./.git/objects/ed/13b9e2b9c2f063ade92819e13fe635c209f4e7",
  "./.git/objects/ed/4718021ecf4f794e49ad690c68316d71a6adfc",
  "./.git/objects/ed/4aac3156d3c4988f345b027f0a7f389671e3dc",
  "./.git/objects/ed/4cc746c2e7922e04ff057c2bdd121cc7c58e02",
  "./.git/objects/ed/7cfd12561409cec365b803be04495e7fe9c30b",
  "./.git/objects/ed/e32b18d08a022b633e934a7085bb436808a05a",
  "./.git/objects/ee",
  "./.git/objects/ee/7e888210e6d2d574c69cdf50fb28c657ac698c",
  "./.git/objects/ee/86abe97b188e4bd3d78b2e1ba9230bf2819ad2",
  "./.git/objects/ee/87901ee9301f1e297e79bda5400a07e7ddcf04",
  "./.git/objects/ee/8c7a9b666a9d6ef23e0c4d900d372c4cfdda94",
  "./.git/objects/ee/bda19feb37f06a97f43bdd750b0911fc15b932",
  "./.git/objects/ee/c425f11c5f1cfa595c30bbe4e1ceafbe0e2f00",
  "./.git/objects/ef",
  "./.git/objects/ef/05c8e580575f49f11527552df9870244405c22",
  "./.git/objects/ef/3b6b0ed36a748fa2dc995fe21ed331fc22c205",
  "./.git/objects/ef/53df0ecf1ee3fb01eef33e519e77223ff46156",
  "./.git/objects/ef/5a39f0cb4975abb957faa3e419ac71afc6451a",
  "./.git/objects/ef/a522863fc4c3c024c49059f71a5f289243bbe3",
  "./.git/objects/ef/d0563b8d721b8664c36a1dbaff456f5c4dacad",
  "./.git/objects/ef/dca9aab1d63709dbde04c8db4303d544392dbd",
  "./.git/objects/f0",
  "./.git/objects/f0/272df64fbf1f68636164bc1709633a92ac19aa",
  "./.git/objects/f0/753a388d5d91f9a0df47e4e5f17cd518cca2a2",
  "./.git/objects/f0/7e80843b076e1118abf9dd2872dfca23128ebb",
  "./.git/objects/f0/feca70c964e2255a80b3752a81dbe30f3d6bab",
  "./.git/objects/f0/ffe31f8c57070312f6af60a64f5bbdcc9c5bdb",
  "./.git/objects/f1",
  "./.git/objects/f1/39e76be1534b57096c22e7775bc45e0777249e",
  "./.git/objects/f1/6aabf9a4dc1994c8f7c78a1cb59c3d430f8dd5",
  "./.git/objects/f2",
  "./.git/objects/f2/ae49b67c652fd76157435280d5d3e4b6a8f245",
  "./.git/objects/f2/dcfd30def11668ffe73fd0e1b805037e3093a0",
  "./.git/objects/f2/e18e19897319f5d8a1b1a6bdcb95e441ce8d13",
  "./.git/objects/f3",
  "./.git/objects/f3/3498b937f59129e596b3db0c3953908ea69d32",
  "./.git/objects/f3/77fa578a494f451e682aab077917e22c1dfb71",
  "./.git/objects/f3/b0b7080b4a1ba3b0bc84f459dd57bcf7b7b92f",
  "./.git/objects/f4",
  "./.git/objects/f4/0d94190be8de4b28000b1bac1d9482d2dbf410",
  "./.git/objects/f4/19b540351a1d28ba757de786d96571eb61eef1",
  "./.git/objects/f4/284dec01837812a9019c17f22e21a49fc0715b",
  "./.git/objects/f4/627d814a364878a0e203e8e42b3b23466a5657",
  "./.git/objects/f4/c29744c2f31cc2571352fd90b6e926b18a7b5e",
  "./.git/objects/f4/c375e0c8f9b3d00c27d4904d75959eb6779e9c",
  "./.git/objects/f5",
  "./.git/objects/f5/0d0f07f0ede468d6b2bd1f53ace46edd127393",
  "./.git/objects/f5/adbece558805632eb77e22074b2b3487527137",
  "./.git/objects/f5/c20773de03446737da7bcbd8802eb4dc376195",
  "./.git/objects/f6",
  "./.git/objects/f6/0c9c35761e82e14be094d1f49a5699a012a22a",
  "./.git/objects/f6/36ab1c6c648678e9d1b9a90de7162c17ac35a3",
  "./.git/objects/f6/4cee8f17ce50b33d2bb25048c2a1d6e684470e",
  "./.git/objects/f6/4e4ff96e8c6495effece52ced92841f89c75c2",
  "./.git/objects/f6/660489102c01a238c2a52dcff4926862cdfd51",
  "./.git/objects/f6/6b1b8cd9ff175c8d76bcbda386403d2c8ffbb6",
  "./.git/objects/f6/9c16df0e8c48e837902ee11ebb4aaed6bfc370",
  "./.git/objects/f6/9e927f2b3fd941b86cd4e0fd11d0c8cceb13b8",
  "./.git/objects/f6/e016e439890f818aa84c3f04b44eb717451900",
  "./.git/objects/f7",
  "./.git/objects/f7/07f3abf92482013401f5529c3b4d8d62cb3ea9",
  "./.git/objects/f7/3067b15dfa829695aebf888c5ecec76859ad91",
  "./.git/objects/f7/368c0d68866e1fc8794834a6a0f7585ae0152c",
  "./.git/objects/f7/3c205fce2d4a6deb3ee23c8547195cb38da30a",
  "./.git/objects/f7/8a9a07f8ac2d606cff3625556a6a2970ac2306",
  "./.git/objects/f7/b2f13663654b1e77b0386e2b297153bda77153",
  "./.git/objects/f8",
  "./.git/objects/f8/276767891e522d2768a4e7ce014269d54fe6ba",
  "./.git/objects/f8/2cbd6c6f51e15273f1626c9d438e069ba1d010",
  "./.git/objects/f8/421bab4234c2147796cd49010650d473ee99b0",
  "./.git/objects/f8/4e088fa5c43ca9f93257ca9acd274c67496625",
  "./.git/objects/f8/54dd8c3d86807e15e4e19fefb2a56b17e5da53",
  "./.git/objects/f8/567e15885192023df6ed708089def983c33567",
  "./.git/objects/f8/616b6a607f1a5a3aebd9468525a1aaa42f96de",
  "./.git/objects/f8/8d824f4c896b37aef8e93a143c73da0638d9c6",
  "./.git/objects/f9",
  "./.git/objects/f9/6c79ac2ea13eb824dbc8df5f81ab5f6e686745",
  "./.git/objects/f9/f36ddef638fbd573ac66512b8339c221e0ab87",
  "./.git/objects/f9/fea8fcc6cd6f7af85cb05335f0a53876449620",
  "./.git/objects/fa",
  "./.git/objects/fa/040dfd78ffcacd8bc8de7d8bead4196db72f86",
  "./.git/objects/fa/2bbd4178265145e1cf28039936d8e2aaa23a8c",
  "./.git/objects/fa/36f46be2327f1af849a5f9cbfa526c51d58ad6",
  "./.git/objects/fa/40ec46a35a3f639d561ca6bcf71561ffd1d8be",
  "./.git/objects/fa/588c41f039317b999a5adf2d348abaa921cfd6",
  "./.git/objects/fa/5c4f25e90b3d24aecdfbb75825470a07afcb6f",
  "./.git/objects/fa/64aa3d146ed97cac38ad2696a5f5d702d8b82a",
  "./.git/objects/fa/77b7e2fb787df4cf5cf1678cd46021ab106497",
  "./.git/objects/fa/a37ae339011d3e0ff428973e4d431118cb9a1d",
  "./.git/objects/fa/ec666e92d54771f3719495c52bfa056c3eef24",
  "./.git/objects/fb",
  "./.git/objects/fb/52ca229bc6a9e7772c292b7ba866330404756e",
  "./.git/objects/fb/5b24d7779309792c958af35e9a2d6e65009e38",
  "./.git/objects/fb/b4d0fd21936b2dd78d992f07455a037d4149e2",
  "./.git/objects/fb/c99e606d098b2aa59949052f40260c7950c80c",
  "./.git/objects/fb/d95d05ce8848a50ebf09423c220013d6ad2c51",
  "./.git/objects/fb/f2363b4c410f29005b26168f9df3a400a14b9d",
  "./.git/objects/fc",
  "./.git/objects/fc/42e0da3a490676af7d21a3a66a0696a9deb6e1",
  "./.git/objects/fc/5295de485c026ad56e736a0229d4853817a6c1",
  "./.git/objects/fc/a5082c1afab5e4f05112e4c3604eb337d49489",
  "./.git/objects/fc/bb3885cc5f28789869564d5f43af144fa091b3",
  "./.git/objects/fc/c0503caae6392f2f823278cbb9216912926f82",
  "./.git/objects/fc/ccd452f442f8a0f307060aca43d858d360a1be",
  "./.git/objects/fc/e65db0ad2d171d55d5afa628649ff54d387b7a",
  "./.git/objects/fd",
  "./.git/objects/fd/017c09534d9a8f005e2a21bbb2a5d91b1b1649",
  "./.git/objects/fd/93e07706b57613d5a0bad2857837483529a044",
  "./.git/objects/fd/a459d6fcd219dd0301012e4781f093da3e74a2",
  "./.git/objects/fd/e98969afc0cf4e0b7ddc0025bdaddac1de2220",
  "./.git/objects/fe",
  "./.git/objects/fe/1235d137c89d2c3853dab7851fb11e635fd8da",
  "./.git/objects/fe/2393814152d416b98a9816f7949b9d0a1fa6fc",
  "./.git/objects/fe/5716af4a54b4c20d08ab6e85a9a6e2ee5fb106",
  "./.git/objects/fe/652b23e564a4583033552561f7346bf93cb926",
  "./.git/objects/fe/e8b1fb25370a44d43309473c99b3f8903af8d5",
  "./.git/objects/ff",
  "./.git/objects/ff/344e2bda9b93c089002d9e66803e79a7cdb315",
  "./.git/objects/ff/3afc98d40cd2f1f341c3de78932fde1dcecdfc",
  "./.git/objects/ff/5dc593382f574bc54140d5d1c216ee4a469189",
  "./.git/objects/ff/5f100ea2da0470a009e3c1172e75842acd8c5e",
  "./.git/objects/ff/79ac18b75fcd9c0134d9f8c42fa6e2b6a2657e",
  "./.git/objects/ff/8e53488ccd99bfbe183c6fe8df5f2fa0580d84",
  "./.git/objects/ff/8f50e314b87d8cea93dbbdfc1f1141289264e3",
  "./.git/objects/ff/b37f89223d49eb57d6b3377ddc96a486a90d85",
  "./.git/objects/info",
  "./.git/objects/pack",
  "./.git/ORIG_HEAD",
  "./.git/refs",
  "./.git/refs/heads",
  "./.git/refs/heads/book",
  "./.git/refs/heads/filter_ansi_out",
  "./.git/refs/heads/key-combos",
  "./.git/refs/heads/master",
  "./.git/refs/heads/multiple_queries",
  "./.git/refs/heads/scoring_experiment_dev",
  "./.git/refs/heads/scoring_redesign",
  "./.git/refs/heads/tty_fix",
  "./.git/refs/remotes",
  "./.git/refs/remotes/charliesome",
  "./.git/refs/remotes/charliesome/dont-truncate-search-if-longer-than-window",
  "./.git/refs/remotes/charliesome/master",
  "./.git/refs/remotes/charliesome/use-control-key-syntax",
  "./.git/refs/remotes/koffeinfrei",
  "./.git/refs/remotes/koffeinfrei/master",
  "./.git/refs/remotes/koffeinfrei/tty_fix",
  "./.git/refs/remotes/koffeinfrei/word-boundary-match",
  "./.git/refs/remotes/marcomorain",
  "./.git/refs/remotes/marcomorain/master",
  "./.git/refs/remotes/marcomorain/select-no-matches",
  "./.git/refs/remotes/marcomorain/test-filtered-search",
  "./.git/refs/remotes/mavcunha",
  "./.git/refs/remotes/mavcunha/master",
  "./.git/refs/remotes/mavcunha/tty_fix",
  "./.git/refs/remotes/michaelavila",
  "./.git/refs/remotes/michaelavila/key-combos",
  "./.git/refs/remotes/michaelavila/master",
  "./.git/refs/remotes/michaelavila/tty_fix",
  "./.git/refs/remotes/origin",
  "./.git/refs/remotes/origin/master",
  "./.git/refs/remotes/origin/scoring_redesign",
  "./.git/refs/remotes/origin/tty_fix",
  "./.git/refs/remotes/rschmitt",
  "./.git/refs/remotes/rschmitt/fork",
  "./.git/refs/remotes/rschmitt/master",
  "./.git/refs/remotes/rschmitt/readme",
  "./.git/refs/remotes/sharplet",
  "./.git/refs/remotes/sharplet/master",
  "./.git/refs/remotes/sharplet/no-choices",
  "./.git/refs/remotes/sharplet/tty_fix",
  "./.git/refs/remotes/sos4nt",
  "./.git/refs/remotes/sos4nt/feature",
  "./.git/refs/remotes/sos4nt/feature/cursor-keys",
  "./.git/refs/remotes/sos4nt/master",
  "./.git/refs/remotes/sos4nt/patch-1",
  "./.git/refs/remotes/sos4nt/tty_fix",
  "./.git/refs/stash",
  "./.git/refs/tags",
  "./.git/refs/tags/v0.0.1",
  "./.git/refs/tags/v0.0.2",
  "./.git/refs/tags/v0.0.3",
  "./.gitignore",
  "./.readygo",
  "./.ruby-gemset",
  "./.ruby-version",
  "./.travis.yml",
  "./benchmark.rb",
  "./demo.gif",
  "./extconf.rb",
  "./Gemfile",
  "./Gemfile.lock",
  "./LICENSE.txt",
  "./README.md",
  "./readygo.rb",
  "./selecta",
  "./selecta.gemspec",
  "./spec",
  "./spec/configuration_spec.rb",
  "./spec/invalid_utf8.txt",
  "./spec/score_spec.rb",
  "./spec/search_spec.rb",
  "./spec/spec_helper.rb",
  "./temp.html",
  "./test.txt",
]
