/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.installer.wizard.components.panels;

import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.Insets;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.netbeans.installer.Installer;
import org.netbeans.installer.product.Registry;
import org.netbeans.installer.product.components.Product;
import org.netbeans.installer.utils.ErrorManager;
import org.netbeans.installer.utils.FileUtils;
import org.netbeans.installer.utils.LogManager;
import org.netbeans.installer.utils.ResourceUtils;
import org.netbeans.installer.utils.StringUtils;
import org.netbeans.installer.utils.SystemUtils;
import org.netbeans.installer.utils.exceptions.NativeException;
import org.netbeans.installer.utils.helper.swing.NbiLabel;
import org.netbeans.installer.utils.helper.swing.NbiPanel;
import org.netbeans.installer.utils.helper.swing.NbiTextPane;
import org.netbeans.installer.wizard.components.panels.ErrorMessagePanel;
import org.netbeans.installer.wizard.containers.SwingContainer;
import org.netbeans.installer.wizard.ui.SwingUi;
import org.netbeans.installer.wizard.ui.WizardUi;

public class PreInstallSummaryPanel
extends ErrorMessagePanel {
    public static final String DEFAULT_TITLE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.title");
    public static final String MESSAGE_TEXT_PROPERTY = "message.text";
    public static final String MESSAGE_CONTENT_TYPE_PROPERTY = "message.content.type";
    public static final String COMPONENTS_TO_INSTALL_LABEL_TEXT_PROPERTY = "components.to.install.label.text";
    public static final String COMPONENTS_TO_INSTALL_TEXT_PROPERTY = "components.to.install.text";
    public static final String COMPONENTS_TO_INSTALL_CONTENT_TYPE_PROPERTY = "components.to.install.content.type";
    public static final String COMPONENTS_TO_UNINSTALL_LABEL_TEXT_PROPERTY = "components.to.uninstall.label.text";
    public static final String COMPONENTS_TO_UNINSTALL_TEXT_PROPERTY = "components.to.uninstall.text";
    public static final String COMPONENTS_TO_UNINSTALL_CONTENT_TYPE_PROPERTY = "components.to.uninstall.content.type";
    public static final String COMPONENTS_LIST_SEPARATOR_PROPERTY = "components.list.separator";
    public static final String DOWNLOAD_SIZE_LABEL_TEXT_PROPERTY = "download.size.label.text";
    public static final String REQUIRED_DISK_SPACE_LABEL_TEXT_PROPERTY = "required.disk.space.label.text";
    public static final String INSTALL_BUTTON_TEXT_PROPERTY = "install.button.text";
    public static final String ERROR_NOT_ENOUGH_SPACE_PROPERTY = "error.not.enough.space";
    public static final String ERROR_CANNOT_CHECK_SPACE_PROPERTY = "error.cannot.check.space";
    public static final String ERROR_LOGIC_ACCESS_PROPERTY = "error.logic.access";
    public static final String ERROR_FSROOTS_PROPERTY = "error.fsroots";
    public static final String ERROR_NON_EXISTENT_ROOT_PROPERTY = "error.non.existent.root";
    public static final String ERROR_CANNOT_WRITE_PROPERTY = "error.cannot.write";
    public static final String DEFAULT_MESSAGE_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.message.text");
    public static final String DEFAULT_MESSAGE_CONTENT_TYPE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.message.content.type");
    public static final String DEFAULT_COMPONENTS_TO_INSTALL_LABEL_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.components.to.install.label.text");
    public static final String DEFAULT_COMPONENTS_TO_INSTALL_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.components.to.install.text");
    public static final String DEFAULT_COMPONENTS_TO_INSTALL_CONTENT_TYPE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.components.to.install.content.type");
    public static final String DEFAULT_COMPONENTS_TO_UNINSTALL_LABEL_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.components.to.uninstall.label.text");
    public static final String DEFAULT_COMPONENTS_TO_UNINSTALL_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.components.to.uninstall.text");
    public static final String DEFAULT_COMPONENTS_TO_UNINSTALL_CONTENT_TYPE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.components.to.uninstall.content.type");
    public static final String DEFAULT_COMPONENTS_LIST_SEPARATOR = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.components.list.separator");
    public static final String DEFAULT_DOWNLOAD_SIZE_LABEL_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.download.size.label.text");
    public static final String DEFAULT_REQUIRED_DISK_SPACE_LABEL_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.required.disk.space.label.text");
    public static final String DEFAULT_INSTALL_BUTTON_TEXT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.install.button.text");
    public static final String DEFAULT_ERROR_NOT_ENOUGH_SPACE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.not.enough.space");
    public static final String DEFAULT_ERROR_CANNOT_CHECK_SPACE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.cannot.check.space");
    public static final String DEFAULT_ERROR_LOGIC_ACCESS = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.logic.access");
    public static final String DEFAULT_ERROR_FSROOTS = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.fsroots");
    public static final String DEFAULT_ERROR_NON_EXISTENT_ROOT = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.non.existent.root");
    public static final String DEFAULT_ERROR_CANNOT_WRITE = ResourceUtils.getString(PreInstallSummaryPanel.class, "PrISP.error.cannot.write");
    public static final long REQUIRED_SPACE_ADDITION = 0xA00000L;

    public PreInstallSummaryPanel() {
        this.setProperty("title", DEFAULT_TITLE);
        this.setProperty(MESSAGE_TEXT_PROPERTY, DEFAULT_MESSAGE_TEXT);
        this.setProperty(MESSAGE_CONTENT_TYPE_PROPERTY, DEFAULT_MESSAGE_CONTENT_TYPE);
        this.setProperty(COMPONENTS_TO_INSTALL_LABEL_TEXT_PROPERTY, DEFAULT_COMPONENTS_TO_INSTALL_LABEL_TEXT);
        this.setProperty(COMPONENTS_TO_INSTALL_TEXT_PROPERTY, DEFAULT_COMPONENTS_TO_INSTALL_TEXT);
        this.setProperty(COMPONENTS_TO_INSTALL_CONTENT_TYPE_PROPERTY, DEFAULT_COMPONENTS_TO_INSTALL_CONTENT_TYPE);
        this.setProperty(COMPONENTS_TO_UNINSTALL_LABEL_TEXT_PROPERTY, DEFAULT_COMPONENTS_TO_UNINSTALL_LABEL_TEXT);
        this.setProperty(COMPONENTS_TO_UNINSTALL_TEXT_PROPERTY, DEFAULT_COMPONENTS_TO_UNINSTALL_TEXT);
        this.setProperty(COMPONENTS_TO_UNINSTALL_CONTENT_TYPE_PROPERTY, DEFAULT_COMPONENTS_TO_UNINSTALL_CONTENT_TYPE);
        this.setProperty(COMPONENTS_LIST_SEPARATOR_PROPERTY, DEFAULT_COMPONENTS_LIST_SEPARATOR);
        this.setProperty(DOWNLOAD_SIZE_LABEL_TEXT_PROPERTY, DEFAULT_DOWNLOAD_SIZE_LABEL_TEXT);
        this.setProperty(REQUIRED_DISK_SPACE_LABEL_TEXT_PROPERTY, DEFAULT_REQUIRED_DISK_SPACE_LABEL_TEXT);
        this.setProperty(INSTALL_BUTTON_TEXT_PROPERTY, DEFAULT_INSTALL_BUTTON_TEXT);
        this.setProperty(ERROR_NOT_ENOUGH_SPACE_PROPERTY, DEFAULT_ERROR_NOT_ENOUGH_SPACE);
        this.setProperty(ERROR_CANNOT_CHECK_SPACE_PROPERTY, DEFAULT_ERROR_CANNOT_CHECK_SPACE);
        this.setProperty(ERROR_LOGIC_ACCESS_PROPERTY, DEFAULT_ERROR_LOGIC_ACCESS);
        this.setProperty(ERROR_FSROOTS_PROPERTY, DEFAULT_ERROR_FSROOTS);
        this.setProperty(ERROR_NON_EXISTENT_ROOT_PROPERTY, DEFAULT_ERROR_NON_EXISTENT_ROOT);
        this.setProperty(ERROR_CANNOT_WRITE_PROPERTY, DEFAULT_ERROR_CANNOT_WRITE);
    }

    @Override
    public boolean canExecuteForward() {
        return Registry.getInstance().getProductsToInstall().size() + Registry.getInstance().getProductsToUninstall().size() > 0;
    }

    @Override
    public boolean canExecuteBackward() {
        return Registry.getInstance().getProductsToInstall().size() + Registry.getInstance().getProductsToUninstall().size() > 0;
    }

    @Override
    public WizardUi getWizardUi() {
        if (this.wizardUi == null) {
            this.wizardUi = new PreInstallSummaryPanelUi(this);
        }
        return this.wizardUi;
    }

    public static class PreInstallSummaryPanelSwingUi
    extends ErrorMessagePanel.ErrorMessagePanelSwingUi {
        protected PreInstallSummaryPanel panel;
        private NbiTextPane messagePane;
        private NbiLabel componentsToInstallLabel;
        private NbiTextPane componentsToInstallPane;
        private NbiLabel componentsToUninstallLabel;
        private NbiTextPane componentsToUninstallPane;
        private NbiLabel downloadSizeLabel;
        private NbiLabel requiredDiskSpaceLabel;
        private NbiPanel spacer;

        public PreInstallSummaryPanelSwingUi(PreInstallSummaryPanel panel, SwingContainer container) {
            super(panel, container);
            this.panel = panel;
            this.initComponents();
        }

        @Override
        protected void initializeContainer() {
            super.initializeContainer();
            this.container.getNextButton().setText(this.panel.getProperty(PreInstallSummaryPanel.INSTALL_BUTTON_TEXT_PROPERTY));
        }

        @Override
        protected void initialize() {
            String messageContentType = this.panel.getProperty(PreInstallSummaryPanel.MESSAGE_CONTENT_TYPE_PROPERTY);
            this.messagePane.setContentType(messageContentType);
            String messageText = this.panel.getProperty(PreInstallSummaryPanel.MESSAGE_TEXT_PROPERTY);
            this.messagePane.setText(messageText);
            List<Product> componentsToInstall = Registry.getInstance().getProductsToInstall();
            List<Product> componentsToUninstall = Registry.getInstance().getProductsToUninstall();
            if (componentsToUninstall.size() > 0) {
                this.componentsToUninstallLabel.setVisible(true);
                this.componentsToUninstallPane.setVisible(true);
                String componentsToUninstallLabelText = this.panel.getProperty(PreInstallSummaryPanel.COMPONENTS_TO_UNINSTALL_LABEL_TEXT_PROPERTY);
                this.componentsToUninstallLabel.setText(componentsToUninstallLabelText);
                String componentsToUninstallContentType = this.panel.getProperty(PreInstallSummaryPanel.COMPONENTS_TO_UNINSTALL_CONTENT_TYPE_PROPERTY);
                this.componentsToUninstallPane.setContentType(componentsToUninstallContentType);
                String componentsToUninstallText = StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.COMPONENTS_TO_UNINSTALL_TEXT_PROPERTY), StringUtils.asString(componentsToUninstall, this.panel.getProperty(PreInstallSummaryPanel.COMPONENTS_LIST_SEPARATOR_PROPERTY)));
                this.componentsToUninstallPane.setText(componentsToUninstallText);
            } else {
                this.componentsToUninstallLabel.setVisible(false);
                this.componentsToUninstallPane.setVisible(false);
            }
            if (componentsToInstall.size() > 0) {
                this.componentsToInstallLabel.setVisible(true);
                this.componentsToInstallPane.setVisible(true);
                this.downloadSizeLabel.setVisible(true);
                this.requiredDiskSpaceLabel.setVisible(true);
                String componentsToInstallLabelText = this.panel.getProperty(PreInstallSummaryPanel.COMPONENTS_TO_INSTALL_LABEL_TEXT_PROPERTY);
                this.componentsToInstallLabel.setText(componentsToInstallLabelText);
                String componentsToInstallContentType = this.panel.getProperty(PreInstallSummaryPanel.COMPONENTS_TO_INSTALL_CONTENT_TYPE_PROPERTY);
                this.componentsToInstallPane.setContentType(componentsToInstallContentType);
                String componentsToInstallText = StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.COMPONENTS_TO_INSTALL_TEXT_PROPERTY), StringUtils.asString(componentsToInstall, this.panel.getProperty(PreInstallSummaryPanel.COMPONENTS_LIST_SEPARATOR_PROPERTY)));
                this.componentsToInstallPane.setText(componentsToInstallText);
                long downloadSize = 0L;
                for (Product component : componentsToInstall) {
                    downloadSize += component.getDownloadSize();
                }
                long requiredDiskSpace = 0L;
                for (Product component : componentsToInstall) {
                    requiredDiskSpace += component.getRequiredDiskSpace();
                }
                String downloadSizeLabelText = StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.DOWNLOAD_SIZE_LABEL_TEXT_PROPERTY), StringUtils.formatSize(downloadSize));
                this.downloadSizeLabel.setText(downloadSizeLabelText);
                String requiredDiskSpaceLabelText = StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.REQUIRED_DISK_SPACE_LABEL_TEXT_PROPERTY), StringUtils.formatSize(requiredDiskSpace));
                this.requiredDiskSpaceLabel.setText(requiredDiskSpaceLabelText);
            } else {
                this.componentsToInstallLabel.setVisible(false);
                this.componentsToInstallPane.setVisible(false);
                this.downloadSizeLabel.setVisible(false);
                this.requiredDiskSpaceLabel.setVisible(false);
            }
        }

        @Override
        protected String validateInput() {
            try {
                if (!Boolean.getBoolean("no.space.check")) {
                    List<Product> toInstall = Registry.getInstance().getProductsToInstall();
                    HashMap<File, Long> spaceMap = new HashMap<File, Long>();
                    File downloadDataDir = Installer.getInstance().getLocalDirectory();
                    String[] installFiles = new String[toInstall.size() + 1];
                    for (int i = 0; i < toInstall.size(); ++i) {
                        installFiles[i] = toInstall.get(i).getInstallationLocation().getAbsolutePath();
                    }
                    installFiles[installFiles.length - 1] = downloadDataDir.getAbsolutePath();
                    List<File> roots = SystemUtils.getFileSystemRoots(installFiles);
                    LogManager.log("Roots : " + StringUtils.asString(roots));
                    File downloadDataDirRoot = FileUtils.getRoot(downloadDataDir, roots);
                    long downloadSize = 0L;
                    for (Product product : toInstall) {
                        downloadSize += product.getDownloadSize();
                    }
                    spaceMap.put(downloadDataDirRoot, downloadSize);
                    long lastDataSize = 0L;
                    for (Product product : toInstall) {
                        File installLocation = product.getInstallationLocation();
                        File root = FileUtils.getRoot(installLocation, roots);
                        long productSize = product.getRequiredDiskSpace();
                        LogManager.log("    [" + root + "] <- " + installLocation);
                        if (root != null) {
                            Long ddSize = (Long)spaceMap.get(downloadDataDirRoot);
                            spaceMap.put(downloadDataDirRoot, ddSize - lastDataSize);
                            Long size = (Long)spaceMap.get(root);
                            size = (size != null ? size : 0L) + productSize;
                            spaceMap.put(root, size);
                            lastDataSize = product.getDownloadSize();
                            continue;
                        }
                        return StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.ERROR_NON_EXISTENT_ROOT_PROPERTY), product, installLocation);
                    }
                    for (Map.Entry entry : spaceMap.entrySet()) {
                        File root = (File)entry.getKey();
                        try {
                            long requiredSpace;
                            long availableSpace = SystemUtils.getFreeSpace(root);
                            if (availableSpace >= (requiredSpace = (Long)entry.getValue() + 0xA00000L)) continue;
                            return StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.ERROR_NOT_ENOUGH_SPACE_PROPERTY), root, StringUtils.formatSize(requiredSpace - availableSpace));
                        }
                        catch (NativeException e) {
                            ErrorManager.notifyError(this.panel.getProperty(PreInstallSummaryPanel.ERROR_CANNOT_CHECK_SPACE_PROPERTY), e);
                        }
                    }
                }
                List<Product> toUninstall = Registry.getInstance().getProductsToUninstall();
                for (Product product : toUninstall) {
                    if (FileUtils.canWrite(product.getInstallationLocation())) continue;
                    return StringUtils.format(this.panel.getProperty(PreInstallSummaryPanel.ERROR_CANNOT_WRITE_PROPERTY), product, product.getInstallationLocation());
                }
            }
            catch (IOException e) {
                ErrorManager.notifyError(this.panel.getProperty(PreInstallSummaryPanel.ERROR_FSROOTS_PROPERTY), e);
            }
            return null;
        }

        private void initComponents() {
            this.messagePane = new NbiTextPane();
            this.componentsToUninstallPane = new NbiTextPane();
            this.componentsToUninstallLabel = new NbiLabel();
            this.componentsToUninstallLabel.setLabelFor(this.componentsToUninstallPane);
            this.componentsToInstallPane = new NbiTextPane();
            this.componentsToInstallLabel = new NbiLabel();
            this.componentsToInstallLabel.setLabelFor(this.componentsToInstallPane);
            this.downloadSizeLabel = new NbiLabel();
            this.requiredDiskSpaceLabel = new NbiLabel();
            this.spacer = new NbiPanel();
            this.add((Component)this.messagePane, new GridBagConstraints(0, 0, 1, 1, 1.0, 0.0, 10, 1, new Insets(11, 11, 0, 11), 0, 0));
            this.add((Component)this.componentsToUninstallLabel, new GridBagConstraints(0, 1, 1, 1, 1.0, 0.0, 10, 1, new Insets(15, 11, 0, 11), 0, 0));
            this.add((Component)this.componentsToUninstallPane, new GridBagConstraints(0, 2, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 11, 0, 11), 0, 0));
            this.add((Component)this.componentsToInstallLabel, new GridBagConstraints(0, 3, 1, 1, 1.0, 0.0, 10, 1, new Insets(15, 11, 0, 11), 0, 0));
            this.add((Component)this.componentsToInstallPane, new GridBagConstraints(0, 4, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 11, 0, 11), 0, 0));
            this.add((Component)this.downloadSizeLabel, new GridBagConstraints(0, 5, 1, 1, 1.0, 0.0, 10, 1, new Insets(25, 11, 0, 11), 0, 0));
            this.add((Component)this.requiredDiskSpaceLabel, new GridBagConstraints(0, 6, 1, 1, 1.0, 0.0, 10, 1, new Insets(3, 11, 0, 11), 0, 0));
            this.add((Component)this.spacer, new GridBagConstraints(0, 7, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 11, 11, 11), 0, 0));
        }
    }

    public static class PreInstallSummaryPanelUi
    extends ErrorMessagePanel.ErrorMessagePanelUi {
        protected PreInstallSummaryPanel panel;

        public PreInstallSummaryPanelUi(PreInstallSummaryPanel panel) {
            super(panel);
            this.panel = panel;
        }

        @Override
        public SwingUi getSwingUi(SwingContainer container) {
            if (this.swingUi == null) {
                this.swingUi = new PreInstallSummaryPanelSwingUi(this.panel, container);
            }
            return super.getSwingUi(container);
        }
    }
}

