/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans.api.visual.graph;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.netbeans.api.visual.model.ObjectScene;
import org.netbeans.api.visual.widget.Widget;
import org.netbeans.modules.visual.util.GeomUtil;

public abstract class GraphScene<N, E>
extends ObjectScene {
    private HashSet<N> nodes = new HashSet();
    private Set<N> nodesUm = Collections.unmodifiableSet(this.nodes);
    private HashSet<E> edges = new HashSet();
    private Set<E> edgesUm = Collections.unmodifiableSet(this.edges);
    private HashMap<E, N> edgeSourceNodes = new HashMap();
    private HashMap<E, N> edgeTargetNodes = new HashMap();
    private HashMap<N, List<E>> nodeInputEdges = new HashMap();
    private HashMap<N, List<E>> nodeOutputEdges = new HashMap();

    public final Widget addNode(N n) {
        assert (n != null && !this.nodes.contains(n));
        Widget widget = this.attachNodeWidget(n);
        this.nodes.add(n);
        this.nodeInputEdges.put(n, new ArrayList());
        this.nodeOutputEdges.put(n, new ArrayList());
        this.addObject(n, widget);
        this.notifyNodeAdded(n, widget);
        return widget;
    }

    public final void removeNode(N n) {
        assert (n != null && this.nodes.contains(n));
        for (E e : this.findNodeEdges(n, true, false)) {
            this.setEdgeSource(e, null);
        }
        for (E e : this.findNodeEdges(n, false, true)) {
            this.setEdgeTarget(e, null);
        }
        this.nodeInputEdges.remove(n);
        this.nodeOutputEdges.remove(n);
        this.nodes.remove(n);
        Widget widget = this.findWidget(n);
        this.detachNodeWidget(n, widget);
        this.removeObject(n);
    }

    public final void removeNodeWithEdges(N n) {
        for (E e : this.findNodeEdges(n, true, true)) {
            if (!this.isEdge(e)) continue;
            this.removeEdge(e);
        }
        this.removeNode(n);
    }

    public final Collection<N> getNodes() {
        return this.nodesUm;
    }

    public final Widget addEdge(E e) {
        assert (e != null && !this.edges.contains(e));
        Widget widget = this.attachEdgeWidget(e);
        this.edges.add(e);
        this.addObject(e, widget);
        this.notifyEdgeAdded(e, widget);
        return widget;
    }

    public final void removeEdge(E e) {
        assert (e != null && this.edges.contains(e));
        this.setEdgeSource(e, null);
        this.setEdgeTarget(e, null);
        this.edges.remove(e);
        this.edgeSourceNodes.remove(e);
        this.edgeTargetNodes.remove(e);
        Widget widget = this.findWidget(e);
        this.detachEdgeWidget(e, widget);
        this.removeObject(e);
    }

    public final Collection<E> getEdges() {
        return this.edgesUm;
    }

    public final void setEdgeSource(E e, N n) {
        assert (e != null && this.edges.contains(e));
        if (n != null) assert (this.nodes.contains(n));
        N n2 = this.edgeSourceNodes.put(e, n);
        if (GeomUtil.equals(n2, n)) {
            return;
        }
        if (n2 != null) {
            this.nodeOutputEdges.get(n2).remove(e);
        }
        if (n != null) {
            this.nodeOutputEdges.get(n).add(e);
        }
        this.attachEdgeSourceAnchor(e, n2, n);
    }

    public final void setEdgeTarget(E e, N n) {
        assert (e != null && this.edges.contains(e));
        if (n != null) assert (this.nodes.contains(n));
        N n2 = this.edgeTargetNodes.put(e, n);
        if (GeomUtil.equals(n2, n)) {
            return;
        }
        if (n2 != null) {
            this.nodeInputEdges.get(n2).remove(e);
        }
        if (n != null) {
            this.nodeInputEdges.get(n).add(e);
        }
        this.attachEdgeTargetAnchor(e, n2, n);
    }

    public final N getEdgeSource(E e) {
        return this.edgeSourceNodes.get(e);
    }

    public final N getEdgeTarget(E e) {
        return this.edgeTargetNodes.get(e);
    }

    public final Collection<E> findNodeEdges(N n, boolean bl, boolean bl2) {
        assert (this.isNode(n)) : "Node " + n + " does not exist in the scene";
        ArrayList arrayList = new ArrayList();
        if (bl2) {
            arrayList.addAll(this.nodeInputEdges.get(n));
        }
        if (bl) {
            arrayList.addAll(this.nodeOutputEdges.get(n));
        }
        return arrayList;
    }

    public final Collection<E> findEdgesBetween(N n, N n2) {
        assert (this.isNode(n)) : "Source node " + n + " is not in the scene";
        assert (this.isNode(n2)) : "Target node " + n2 + " is not in the scene";
        HashSet<E> hashSet = new HashSet<E>();
        List<E> list = this.nodeInputEdges.get(n2);
        List<E> list2 = this.nodeOutputEdges.get(n);
        for (E e : list) {
            if (!list2.contains(e)) continue;
            hashSet.add(e);
        }
        return hashSet;
    }

    public boolean isNode(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.nodes.contains(object);
    }

    public boolean isEdge(Object object) {
        assert (!(object instanceof Widget)) : "Use findObject method for getting an object assigned to a specific Widget";
        return this.edges.contains(object);
    }

    protected void notifyNodeAdded(N n, Widget widget) {
    }

    protected void notifyEdgeAdded(E e, Widget widget) {
    }

    protected void detachNodeWidget(N n, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected void detachEdgeWidget(E e, Widget widget) {
        if (widget != null) {
            widget.removeFromParent();
        }
    }

    protected abstract Widget attachNodeWidget(N var1);

    protected abstract Widget attachEdgeWidget(E var1);

    protected abstract void attachEdgeSourceAnchor(E var1, N var2, N var3);

    protected abstract void attachEdgeTargetAnchor(E var1, N var2, N var3);

    public static abstract class StringGraph
    extends GraphScene<String, String> {
    }
}

