// Copyright 2016 Google Inc.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// Code generated by protoc-gen-go. DO NOT EDIT.
// versions:
// 	protoc-gen-go v1.26.0
// 	protoc        v3.12.2
// source: google/genomics/v1/variants.proto

package genomics

import (
	context "context"
	reflect "reflect"
	sync "sync"

	_ "google.golang.org/genproto/googleapis/api/annotations"
	longrunning "google.golang.org/genproto/googleapis/longrunning"
	grpc "google.golang.org/grpc"
	codes "google.golang.org/grpc/codes"
	status "google.golang.org/grpc/status"
	protoreflect "google.golang.org/protobuf/reflect/protoreflect"
	protoimpl "google.golang.org/protobuf/runtime/protoimpl"
	emptypb "google.golang.org/protobuf/types/known/emptypb"
	fieldmaskpb "google.golang.org/protobuf/types/known/fieldmaskpb"
	structpb "google.golang.org/protobuf/types/known/structpb"
)

const (
	// Verify that this generated code is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(20 - protoimpl.MinVersion)
	// Verify that runtime/protoimpl is sufficiently up-to-date.
	_ = protoimpl.EnforceVersion(protoimpl.MaxVersion - 20)
)

// Operations to be performed during import on Variant info fields.
// These operations are set for each info field in the info_merge_config
// map of ImportVariantsRequest, which is plumbed down to the
// MergeVariantRequests generated by the import job.
type InfoMergeOperation int32

const (
	InfoMergeOperation_INFO_MERGE_OPERATION_UNSPECIFIED InfoMergeOperation = 0
	// By default, Variant info fields are persisted if the Variant doesn't
	// already exist in the variantset.  If the Variant is equivalent to a
	// Variant already in the variantset, the incoming Variant's info field
	// is ignored in favor of that of the already persisted Variant.
	InfoMergeOperation_IGNORE_NEW InfoMergeOperation = 1
	// This operation removes an info field from the incoming Variant
	// and persists this info field in each of the incoming Variant's Calls.
	InfoMergeOperation_MOVE_TO_CALLS InfoMergeOperation = 2
)

// Enum value maps for InfoMergeOperation.
var (
	InfoMergeOperation_name = map[int32]string{
		0: "INFO_MERGE_OPERATION_UNSPECIFIED",
		1: "IGNORE_NEW",
		2: "MOVE_TO_CALLS",
	}
	InfoMergeOperation_value = map[string]int32{
		"INFO_MERGE_OPERATION_UNSPECIFIED": 0,
		"IGNORE_NEW":                       1,
		"MOVE_TO_CALLS":                    2,
	}
)

func (x InfoMergeOperation) Enum() *InfoMergeOperation {
	p := new(InfoMergeOperation)
	*p = x
	return p
}

func (x InfoMergeOperation) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (InfoMergeOperation) Descriptor() protoreflect.EnumDescriptor {
	return file_google_genomics_v1_variants_proto_enumTypes[0].Descriptor()
}

func (InfoMergeOperation) Type() protoreflect.EnumType {
	return &file_google_genomics_v1_variants_proto_enumTypes[0]
}

func (x InfoMergeOperation) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use InfoMergeOperation.Descriptor instead.
func (InfoMergeOperation) EnumDescriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{0}
}

type VariantSetMetadata_Type int32

const (
	VariantSetMetadata_TYPE_UNSPECIFIED VariantSetMetadata_Type = 0
	VariantSetMetadata_INTEGER          VariantSetMetadata_Type = 1
	VariantSetMetadata_FLOAT            VariantSetMetadata_Type = 2
	VariantSetMetadata_FLAG             VariantSetMetadata_Type = 3
	VariantSetMetadata_CHARACTER        VariantSetMetadata_Type = 4
	VariantSetMetadata_STRING           VariantSetMetadata_Type = 5
)

// Enum value maps for VariantSetMetadata_Type.
var (
	VariantSetMetadata_Type_name = map[int32]string{
		0: "TYPE_UNSPECIFIED",
		1: "INTEGER",
		2: "FLOAT",
		3: "FLAG",
		4: "CHARACTER",
		5: "STRING",
	}
	VariantSetMetadata_Type_value = map[string]int32{
		"TYPE_UNSPECIFIED": 0,
		"INTEGER":          1,
		"FLOAT":            2,
		"FLAG":             3,
		"CHARACTER":        4,
		"STRING":           5,
	}
)

func (x VariantSetMetadata_Type) Enum() *VariantSetMetadata_Type {
	p := new(VariantSetMetadata_Type)
	*p = x
	return p
}

func (x VariantSetMetadata_Type) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (VariantSetMetadata_Type) Descriptor() protoreflect.EnumDescriptor {
	return file_google_genomics_v1_variants_proto_enumTypes[1].Descriptor()
}

func (VariantSetMetadata_Type) Type() protoreflect.EnumType {
	return &file_google_genomics_v1_variants_proto_enumTypes[1]
}

func (x VariantSetMetadata_Type) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use VariantSetMetadata_Type.Descriptor instead.
func (VariantSetMetadata_Type) EnumDescriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{0, 0}
}

type ImportVariantsRequest_Format int32

const (
	ImportVariantsRequest_FORMAT_UNSPECIFIED ImportVariantsRequest_Format = 0
	// VCF (Variant Call Format). The VCF files may be gzip compressed. gVCF is
	// also supported.
	ImportVariantsRequest_FORMAT_VCF ImportVariantsRequest_Format = 1
	// Complete Genomics masterVarBeta format. The masterVarBeta files may
	// be bzip2 compressed.
	ImportVariantsRequest_FORMAT_COMPLETE_GENOMICS ImportVariantsRequest_Format = 2
)

// Enum value maps for ImportVariantsRequest_Format.
var (
	ImportVariantsRequest_Format_name = map[int32]string{
		0: "FORMAT_UNSPECIFIED",
		1: "FORMAT_VCF",
		2: "FORMAT_COMPLETE_GENOMICS",
	}
	ImportVariantsRequest_Format_value = map[string]int32{
		"FORMAT_UNSPECIFIED":       0,
		"FORMAT_VCF":               1,
		"FORMAT_COMPLETE_GENOMICS": 2,
	}
)

func (x ImportVariantsRequest_Format) Enum() *ImportVariantsRequest_Format {
	p := new(ImportVariantsRequest_Format)
	*p = x
	return p
}

func (x ImportVariantsRequest_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ImportVariantsRequest_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_google_genomics_v1_variants_proto_enumTypes[2].Descriptor()
}

func (ImportVariantsRequest_Format) Type() protoreflect.EnumType {
	return &file_google_genomics_v1_variants_proto_enumTypes[2]
}

func (x ImportVariantsRequest_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ImportVariantsRequest_Format.Descriptor instead.
func (ImportVariantsRequest_Format) EnumDescriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{6, 0}
}

type ExportVariantSetRequest_Format int32

const (
	ExportVariantSetRequest_FORMAT_UNSPECIFIED ExportVariantSetRequest_Format = 0
	// Export the data to Google BigQuery.
	ExportVariantSetRequest_FORMAT_BIGQUERY ExportVariantSetRequest_Format = 1
)

// Enum value maps for ExportVariantSetRequest_Format.
var (
	ExportVariantSetRequest_Format_name = map[int32]string{
		0: "FORMAT_UNSPECIFIED",
		1: "FORMAT_BIGQUERY",
	}
	ExportVariantSetRequest_Format_value = map[string]int32{
		"FORMAT_UNSPECIFIED": 0,
		"FORMAT_BIGQUERY":    1,
	}
)

func (x ExportVariantSetRequest_Format) Enum() *ExportVariantSetRequest_Format {
	p := new(ExportVariantSetRequest_Format)
	*p = x
	return p
}

func (x ExportVariantSetRequest_Format) String() string {
	return protoimpl.X.EnumStringOf(x.Descriptor(), protoreflect.EnumNumber(x))
}

func (ExportVariantSetRequest_Format) Descriptor() protoreflect.EnumDescriptor {
	return file_google_genomics_v1_variants_proto_enumTypes[3].Descriptor()
}

func (ExportVariantSetRequest_Format) Type() protoreflect.EnumType {
	return &file_google_genomics_v1_variants_proto_enumTypes[3]
}

func (x ExportVariantSetRequest_Format) Number() protoreflect.EnumNumber {
	return protoreflect.EnumNumber(x)
}

// Deprecated: Use ExportVariantSetRequest_Format.Descriptor instead.
func (ExportVariantSetRequest_Format) EnumDescriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{9, 0}
}

// Metadata describes a single piece of variant call metadata.
// These data include a top level key and either a single value string (value)
// or a list of key-value pairs (info.)
// Value and info are mutually exclusive.
type VariantSetMetadata struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The top-level key.
	Key string `protobuf:"bytes,1,opt,name=key,proto3" json:"key,omitempty"`
	// The value field for simple metadata
	Value string `protobuf:"bytes,2,opt,name=value,proto3" json:"value,omitempty"`
	// User-provided ID field, not enforced by this API.
	// Two or more pieces of structured metadata with identical
	// id and key fields are considered equivalent.
	Id string `protobuf:"bytes,4,opt,name=id,proto3" json:"id,omitempty"`
	// The type of data. Possible types include: Integer, Float,
	// Flag, Character, and String.
	Type VariantSetMetadata_Type `protobuf:"varint,5,opt,name=type,proto3,enum=google.genomics.v1.VariantSetMetadata_Type" json:"type,omitempty"`
	// The number of values that can be included in a field described by this
	// metadata.
	Number string `protobuf:"bytes,8,opt,name=number,proto3" json:"number,omitempty"`
	// A textual description of this metadata.
	Description string `protobuf:"bytes,7,opt,name=description,proto3" json:"description,omitempty"`
	// Remaining structured metadata key-value pairs. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*structpb.ListValue `protobuf:"bytes,3,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *VariantSetMetadata) Reset() {
	*x = VariantSetMetadata{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[0]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VariantSetMetadata) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VariantSetMetadata) ProtoMessage() {}

func (x *VariantSetMetadata) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[0]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VariantSetMetadata.ProtoReflect.Descriptor instead.
func (*VariantSetMetadata) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{0}
}

func (x *VariantSetMetadata) GetKey() string {
	if x != nil {
		return x.Key
	}
	return ""
}

func (x *VariantSetMetadata) GetValue() string {
	if x != nil {
		return x.Value
	}
	return ""
}

func (x *VariantSetMetadata) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VariantSetMetadata) GetType() VariantSetMetadata_Type {
	if x != nil {
		return x.Type
	}
	return VariantSetMetadata_TYPE_UNSPECIFIED
}

func (x *VariantSetMetadata) GetNumber() string {
	if x != nil {
		return x.Number
	}
	return ""
}

func (x *VariantSetMetadata) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

func (x *VariantSetMetadata) GetInfo() map[string]*structpb.ListValue {
	if x != nil {
		return x.Info
	}
	return nil
}

// A variant set is a collection of call sets and variants. It contains summary
// statistics of those contents. A variant set belongs to a dataset.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
type VariantSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The dataset to which this variant set belongs.
	DatasetId string `protobuf:"bytes,1,opt,name=dataset_id,json=datasetId,proto3" json:"dataset_id,omitempty"`
	// The server-generated variant set ID, unique across all variant sets.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// The reference set to which the variant set is mapped. The reference set
	// describes the alignment provenance of the variant set, while the
	// `referenceBounds` describe the shape of the actual variant data. The
	// reference set's reference names are a superset of those found in the
	// `referenceBounds`.
	//
	// For example, given a variant set that is mapped to the GRCh38 reference set
	// and contains a single variant on reference 'X', `referenceBounds` would
	// contain only an entry for 'X', while the associated reference set
	// enumerates all possible references: '1', '2', 'X', 'Y', 'MT', etc.
	ReferenceSetId string `protobuf:"bytes,6,opt,name=reference_set_id,json=referenceSetId,proto3" json:"reference_set_id,omitempty"`
	// A list of all references used by the variants in a variant set
	// with associated coordinate upper bounds for each one.
	ReferenceBounds []*ReferenceBound `protobuf:"bytes,5,rep,name=reference_bounds,json=referenceBounds,proto3" json:"reference_bounds,omitempty"`
	// The metadata associated with this variant set.
	Metadata []*VariantSetMetadata `protobuf:"bytes,4,rep,name=metadata,proto3" json:"metadata,omitempty"`
	// User-specified, mutable name.
	Name string `protobuf:"bytes,7,opt,name=name,proto3" json:"name,omitempty"`
	// A textual description of this variant set.
	Description string `protobuf:"bytes,8,opt,name=description,proto3" json:"description,omitempty"`
}

func (x *VariantSet) Reset() {
	*x = VariantSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[1]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VariantSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VariantSet) ProtoMessage() {}

func (x *VariantSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[1]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VariantSet.ProtoReflect.Descriptor instead.
func (*VariantSet) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{1}
}

func (x *VariantSet) GetDatasetId() string {
	if x != nil {
		return x.DatasetId
	}
	return ""
}

func (x *VariantSet) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *VariantSet) GetReferenceSetId() string {
	if x != nil {
		return x.ReferenceSetId
	}
	return ""
}

func (x *VariantSet) GetReferenceBounds() []*ReferenceBound {
	if x != nil {
		return x.ReferenceBounds
	}
	return nil
}

func (x *VariantSet) GetMetadata() []*VariantSetMetadata {
	if x != nil {
		return x.Metadata
	}
	return nil
}

func (x *VariantSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *VariantSet) GetDescription() string {
	if x != nil {
		return x.Description
	}
	return ""
}

// A variant represents a change in DNA sequence relative to a reference
// sequence. For example, a variant could represent a SNP or an insertion.
// Variants belong to a variant set.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
//
// Each of the calls on a variant represent a determination of genotype with
// respect to that variant. For example, a call might assign probability of 0.32
// to the occurrence of a SNP named rs1234 in a sample named NA12345. A call
// belongs to a call set, which contains related calls typically from one
// sample.
type Variant struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the variant set this variant belongs to.
	VariantSetId string `protobuf:"bytes,15,opt,name=variant_set_id,json=variantSetId,proto3" json:"variant_set_id,omitempty"`
	// The server-generated variant ID, unique across all variants.
	Id string `protobuf:"bytes,2,opt,name=id,proto3" json:"id,omitempty"`
	// Names for the variant, for example a RefSNP ID.
	Names []string `protobuf:"bytes,3,rep,name=names,proto3" json:"names,omitempty"`
	// The date this variant was created, in milliseconds from the epoch.
	Created int64 `protobuf:"varint,12,opt,name=created,proto3" json:"created,omitempty"`
	// The reference on which this variant occurs.
	// (such as `chr20` or `X`)
	ReferenceName string `protobuf:"bytes,14,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// The position at which this variant occurs (0-based).
	// This corresponds to the first base of the string of reference bases.
	Start int64 `protobuf:"varint,16,opt,name=start,proto3" json:"start,omitempty"`
	// The end position (0-based) of this variant. This corresponds to the first
	// base after the last base in the reference allele. So, the length of
	// the reference allele is (end - start). This is useful for variants
	// that don't explicitly give alternate bases, for example large deletions.
	End int64 `protobuf:"varint,13,opt,name=end,proto3" json:"end,omitempty"`
	// The reference bases for this variant. They start at the given
	// position.
	ReferenceBases string `protobuf:"bytes,6,opt,name=reference_bases,json=referenceBases,proto3" json:"reference_bases,omitempty"`
	// The bases that appear instead of the reference bases.
	AlternateBases []string `protobuf:"bytes,7,rep,name=alternate_bases,json=alternateBases,proto3" json:"alternate_bases,omitempty"`
	// A measure of how likely this variant is to be real.
	// A higher value is better.
	Quality float64 `protobuf:"fixed64,8,opt,name=quality,proto3" json:"quality,omitempty"`
	// A list of filters (normally quality filters) this variant has failed.
	// `PASS` indicates this variant has passed all filters.
	Filter []string `protobuf:"bytes,9,rep,name=filter,proto3" json:"filter,omitempty"`
	// A map of additional variant information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*structpb.ListValue `protobuf:"bytes,10,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
	// The variant calls for this particular variant. Each one represents the
	// determination of genotype with respect to this variant.
	Calls []*VariantCall `protobuf:"bytes,11,rep,name=calls,proto3" json:"calls,omitempty"`
}

func (x *Variant) Reset() {
	*x = Variant{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[2]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *Variant) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*Variant) ProtoMessage() {}

func (x *Variant) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[2]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use Variant.ProtoReflect.Descriptor instead.
func (*Variant) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{2}
}

func (x *Variant) GetVariantSetId() string {
	if x != nil {
		return x.VariantSetId
	}
	return ""
}

func (x *Variant) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *Variant) GetNames() []string {
	if x != nil {
		return x.Names
	}
	return nil
}

func (x *Variant) GetCreated() int64 {
	if x != nil {
		return x.Created
	}
	return 0
}

func (x *Variant) GetReferenceName() string {
	if x != nil {
		return x.ReferenceName
	}
	return ""
}

func (x *Variant) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *Variant) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *Variant) GetReferenceBases() string {
	if x != nil {
		return x.ReferenceBases
	}
	return ""
}

func (x *Variant) GetAlternateBases() []string {
	if x != nil {
		return x.AlternateBases
	}
	return nil
}

func (x *Variant) GetQuality() float64 {
	if x != nil {
		return x.Quality
	}
	return 0
}

func (x *Variant) GetFilter() []string {
	if x != nil {
		return x.Filter
	}
	return nil
}

func (x *Variant) GetInfo() map[string]*structpb.ListValue {
	if x != nil {
		return x.Info
	}
	return nil
}

func (x *Variant) GetCalls() []*VariantCall {
	if x != nil {
		return x.Calls
	}
	return nil
}

// A call represents the determination of genotype with respect to a particular
// variant. It may include associated information such as quality and phasing.
// For example, a call might assign a probability of 0.32 to the occurrence of
// a SNP named rs1234 in a call set with the name NA12345.
type VariantCall struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the call set this variant call belongs to.
	CallSetId string `protobuf:"bytes,8,opt,name=call_set_id,json=callSetId,proto3" json:"call_set_id,omitempty"`
	// The name of the call set this variant call belongs to.
	CallSetName string `protobuf:"bytes,9,opt,name=call_set_name,json=callSetName,proto3" json:"call_set_name,omitempty"`
	// The genotype of this variant call. Each value represents either the value
	// of the `referenceBases` field or a 1-based index into
	// `alternateBases`. If a variant had a `referenceBases`
	// value of `T` and an `alternateBases`
	// value of `["A", "C"]`, and the `genotype` was
	// `[2, 1]`, that would mean the call
	// represented the heterozygous value `CA` for this variant.
	// If the `genotype` was instead `[0, 1]`, the
	// represented value would be `TA`. Ordering of the
	// genotype values is important if the `phaseset` is present.
	// If a genotype is not called (that is, a `.` is present in the
	// GT string) -1 is returned.
	Genotype []int32 `protobuf:"varint,7,rep,packed,name=genotype,proto3" json:"genotype,omitempty"`
	// If this field is present, this variant call's genotype ordering implies
	// the phase of the bases and is consistent with any other variant calls in
	// the same reference sequence which have the same phaseset value.
	// When importing data from VCF, if the genotype data was phased but no
	// phase set was specified this field will be set to `*`.
	Phaseset string `protobuf:"bytes,5,opt,name=phaseset,proto3" json:"phaseset,omitempty"`
	// The genotype likelihoods for this variant call. Each array entry
	// represents how likely a specific genotype is for this call. The value
	// ordering is defined by the GL tag in the VCF spec.
	// If Phred-scaled genotype likelihood scores (PL) are available and
	// log10(P) genotype likelihood scores (GL) are not, PL scores are converted
	// to GL scores.  If both are available, PL scores are stored in `info`.
	GenotypeLikelihood []float64 `protobuf:"fixed64,6,rep,packed,name=genotype_likelihood,json=genotypeLikelihood,proto3" json:"genotype_likelihood,omitempty"`
	// A map of additional variant call information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*structpb.ListValue `protobuf:"bytes,2,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *VariantCall) Reset() {
	*x = VariantCall{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[3]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *VariantCall) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*VariantCall) ProtoMessage() {}

func (x *VariantCall) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[3]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use VariantCall.ProtoReflect.Descriptor instead.
func (*VariantCall) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{3}
}

func (x *VariantCall) GetCallSetId() string {
	if x != nil {
		return x.CallSetId
	}
	return ""
}

func (x *VariantCall) GetCallSetName() string {
	if x != nil {
		return x.CallSetName
	}
	return ""
}

func (x *VariantCall) GetGenotype() []int32 {
	if x != nil {
		return x.Genotype
	}
	return nil
}

func (x *VariantCall) GetPhaseset() string {
	if x != nil {
		return x.Phaseset
	}
	return ""
}

func (x *VariantCall) GetGenotypeLikelihood() []float64 {
	if x != nil {
		return x.GenotypeLikelihood
	}
	return nil
}

func (x *VariantCall) GetInfo() map[string]*structpb.ListValue {
	if x != nil {
		return x.Info
	}
	return nil
}

// A call set is a collection of variant calls, typically for one sample. It
// belongs to a variant set.
//
// For more genomics resource definitions, see [Fundamentals of Google
// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
type CallSet struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The server-generated call set ID, unique across all call sets.
	Id string `protobuf:"bytes,1,opt,name=id,proto3" json:"id,omitempty"`
	// The call set name.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The sample ID this call set corresponds to.
	SampleId string `protobuf:"bytes,7,opt,name=sample_id,json=sampleId,proto3" json:"sample_id,omitempty"`
	// The IDs of the variant sets this call set belongs to. This field must
	// have exactly length one, as a call set belongs to a single variant set.
	// This field is repeated for compatibility with the
	// [GA4GH 0.5.1
	// API](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variants.avdl#L76).
	VariantSetIds []string `protobuf:"bytes,6,rep,name=variant_set_ids,json=variantSetIds,proto3" json:"variant_set_ids,omitempty"`
	// The date this call set was created in milliseconds from the epoch.
	Created int64 `protobuf:"varint,5,opt,name=created,proto3" json:"created,omitempty"`
	// A map of additional call set information. This must be of the form
	// map<string, string[]> (string key mapping to a list of string values).
	Info map[string]*structpb.ListValue `protobuf:"bytes,4,rep,name=info,proto3" json:"info,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"bytes,2,opt,name=value,proto3"`
}

func (x *CallSet) Reset() {
	*x = CallSet{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[4]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CallSet) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CallSet) ProtoMessage() {}

func (x *CallSet) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[4]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CallSet.ProtoReflect.Descriptor instead.
func (*CallSet) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{4}
}

func (x *CallSet) GetId() string {
	if x != nil {
		return x.Id
	}
	return ""
}

func (x *CallSet) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *CallSet) GetSampleId() string {
	if x != nil {
		return x.SampleId
	}
	return ""
}

func (x *CallSet) GetVariantSetIds() []string {
	if x != nil {
		return x.VariantSetIds
	}
	return nil
}

func (x *CallSet) GetCreated() int64 {
	if x != nil {
		return x.Created
	}
	return 0
}

func (x *CallSet) GetInfo() map[string]*structpb.ListValue {
	if x != nil {
		return x.Info
	}
	return nil
}

// ReferenceBound records an upper bound for the starting coordinate of
// variants in a particular reference.
type ReferenceBound struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The name of the reference associated with this reference bound.
	ReferenceName string `protobuf:"bytes,1,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// An upper bound (inclusive) on the starting coordinate of any
	// variant in the reference sequence.
	UpperBound int64 `protobuf:"varint,2,opt,name=upper_bound,json=upperBound,proto3" json:"upper_bound,omitempty"`
}

func (x *ReferenceBound) Reset() {
	*x = ReferenceBound{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[5]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ReferenceBound) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ReferenceBound) ProtoMessage() {}

func (x *ReferenceBound) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[5]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ReferenceBound.ProtoReflect.Descriptor instead.
func (*ReferenceBound) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{5}
}

func (x *ReferenceBound) GetReferenceName() string {
	if x != nil {
		return x.ReferenceName
	}
	return ""
}

func (x *ReferenceBound) GetUpperBound() int64 {
	if x != nil {
		return x.UpperBound
	}
	return 0
}

// The variant data import request.
type ImportVariantsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The variant set to which variant data should be imported.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId,proto3" json:"variant_set_id,omitempty"`
	// A list of URIs referencing variant files in Google Cloud Storage. URIs can
	// include wildcards [as described
	// here](https://cloud.google.com/storage/docs/gsutil/addlhelp/WildcardNames).
	// Note that recursive wildcards ('**') are not supported.
	SourceUris []string `protobuf:"bytes,2,rep,name=source_uris,json=sourceUris,proto3" json:"source_uris,omitempty"`
	// The format of the variant data being imported. If unspecified, defaults to
	// to `VCF`.
	Format ImportVariantsRequest_Format `protobuf:"varint,3,opt,name=format,proto3,enum=google.genomics.v1.ImportVariantsRequest_Format" json:"format,omitempty"`
	// Convert reference names to the canonical representation.
	// hg19 haploytypes (those reference names containing "_hap")
	// are not modified in any way.
	// All other reference names are modified according to the following rules:
	// The reference name is capitalized.
	// The "chr" prefix is dropped for all autosomes and sex chromsomes.
	// For example "chr17" becomes "17" and "chrX" becomes "X".
	// All mitochondrial chromosomes ("chrM", "chrMT", etc) become "MT".
	NormalizeReferenceNames bool `protobuf:"varint,5,opt,name=normalize_reference_names,json=normalizeReferenceNames,proto3" json:"normalize_reference_names,omitempty"`
	// A mapping between info field keys and the InfoMergeOperations to
	// be performed on them. This is plumbed down to the MergeVariantRequests
	// generated by the resulting import job.
	InfoMergeConfig map[string]InfoMergeOperation `protobuf:"bytes,6,rep,name=info_merge_config,json=infoMergeConfig,proto3" json:"info_merge_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=google.genomics.v1.InfoMergeOperation"`
}

func (x *ImportVariantsRequest) Reset() {
	*x = ImportVariantsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[6]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportVariantsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportVariantsRequest) ProtoMessage() {}

func (x *ImportVariantsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[6]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportVariantsRequest.ProtoReflect.Descriptor instead.
func (*ImportVariantsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{6}
}

func (x *ImportVariantsRequest) GetVariantSetId() string {
	if x != nil {
		return x.VariantSetId
	}
	return ""
}

func (x *ImportVariantsRequest) GetSourceUris() []string {
	if x != nil {
		return x.SourceUris
	}
	return nil
}

func (x *ImportVariantsRequest) GetFormat() ImportVariantsRequest_Format {
	if x != nil {
		return x.Format
	}
	return ImportVariantsRequest_FORMAT_UNSPECIFIED
}

func (x *ImportVariantsRequest) GetNormalizeReferenceNames() bool {
	if x != nil {
		return x.NormalizeReferenceNames
	}
	return false
}

func (x *ImportVariantsRequest) GetInfoMergeConfig() map[string]InfoMergeOperation {
	if x != nil {
		return x.InfoMergeConfig
	}
	return nil
}

// The variant data import response.
type ImportVariantsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// IDs of the call sets created during the import.
	CallSetIds []string `protobuf:"bytes,1,rep,name=call_set_ids,json=callSetIds,proto3" json:"call_set_ids,omitempty"`
}

func (x *ImportVariantsResponse) Reset() {
	*x = ImportVariantsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[7]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ImportVariantsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ImportVariantsResponse) ProtoMessage() {}

func (x *ImportVariantsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[7]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ImportVariantsResponse.ProtoReflect.Descriptor instead.
func (*ImportVariantsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{7}
}

func (x *ImportVariantsResponse) GetCallSetIds() []string {
	if x != nil {
		return x.CallSetIds
	}
	return nil
}

// The CreateVariantSet request
type CreateVariantSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The variant set to be created. Must have a valid `datasetId`.
	VariantSet *VariantSet `protobuf:"bytes,1,opt,name=variant_set,json=variantSet,proto3" json:"variant_set,omitempty"`
}

func (x *CreateVariantSetRequest) Reset() {
	*x = CreateVariantSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[8]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateVariantSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVariantSetRequest) ProtoMessage() {}

func (x *CreateVariantSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[8]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVariantSetRequest.ProtoReflect.Descriptor instead.
func (*CreateVariantSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{8}
}

func (x *CreateVariantSetRequest) GetVariantSet() *VariantSet {
	if x != nil {
		return x.VariantSet
	}
	return nil
}

// The variant data export request.
type ExportVariantSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the variant set that contains variant data which
	// should be exported. The caller must have READ access to this variant set.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId,proto3" json:"variant_set_id,omitempty"`
	// If provided, only variant call information from the specified call sets
	// will be exported. By default all variant calls are exported.
	CallSetIds []string `protobuf:"bytes,2,rep,name=call_set_ids,json=callSetIds,proto3" json:"call_set_ids,omitempty"`
	// Required. The Google Cloud project ID that owns the destination
	// BigQuery dataset. The caller must have WRITE access to this project.  This
	// project will also own the resulting export job.
	ProjectId string `protobuf:"bytes,3,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The format for the exported data.
	Format ExportVariantSetRequest_Format `protobuf:"varint,4,opt,name=format,proto3,enum=google.genomics.v1.ExportVariantSetRequest_Format" json:"format,omitempty"`
	// Required. The BigQuery dataset to export data to. This dataset must already
	// exist. Note that this is distinct from the Genomics concept of "dataset".
	BigqueryDataset string `protobuf:"bytes,5,opt,name=bigquery_dataset,json=bigqueryDataset,proto3" json:"bigquery_dataset,omitempty"`
	// Required. The BigQuery table to export data to.
	// If the table doesn't exist, it will be created. If it already exists, it
	// will be overwritten.
	BigqueryTable string `protobuf:"bytes,6,opt,name=bigquery_table,json=bigqueryTable,proto3" json:"bigquery_table,omitempty"`
}

func (x *ExportVariantSetRequest) Reset() {
	*x = ExportVariantSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[9]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *ExportVariantSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*ExportVariantSetRequest) ProtoMessage() {}

func (x *ExportVariantSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[9]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use ExportVariantSetRequest.ProtoReflect.Descriptor instead.
func (*ExportVariantSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{9}
}

func (x *ExportVariantSetRequest) GetVariantSetId() string {
	if x != nil {
		return x.VariantSetId
	}
	return ""
}

func (x *ExportVariantSetRequest) GetCallSetIds() []string {
	if x != nil {
		return x.CallSetIds
	}
	return nil
}

func (x *ExportVariantSetRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *ExportVariantSetRequest) GetFormat() ExportVariantSetRequest_Format {
	if x != nil {
		return x.Format
	}
	return ExportVariantSetRequest_FORMAT_UNSPECIFIED
}

func (x *ExportVariantSetRequest) GetBigqueryDataset() string {
	if x != nil {
		return x.BigqueryDataset
	}
	return ""
}

func (x *ExportVariantSetRequest) GetBigqueryTable() string {
	if x != nil {
		return x.BigqueryTable
	}
	return ""
}

// The variant set request.
type GetVariantSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Required. The ID of the variant set.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId,proto3" json:"variant_set_id,omitempty"`
}

func (x *GetVariantSetRequest) Reset() {
	*x = GetVariantSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[10]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVariantSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVariantSetRequest) ProtoMessage() {}

func (x *GetVariantSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[10]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVariantSetRequest.ProtoReflect.Descriptor instead.
func (*GetVariantSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{10}
}

func (x *GetVariantSetRequest) GetVariantSetId() string {
	if x != nil {
		return x.VariantSetId
	}
	return ""
}

// The search variant sets request.
type SearchVariantSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Exactly one dataset ID must be provided here. Only variant sets which
	// belong to this dataset will be returned.
	DatasetIds []string `protobuf:"bytes,1,rep,name=dataset_ids,json=datasetIds,proto3" json:"dataset_ids,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,2,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 1024.
	PageSize int32 `protobuf:"varint,3,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *SearchVariantSetsRequest) Reset() {
	*x = SearchVariantSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[11]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchVariantSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchVariantSetsRequest) ProtoMessage() {}

func (x *SearchVariantSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[11]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchVariantSetsRequest.ProtoReflect.Descriptor instead.
func (*SearchVariantSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{11}
}

func (x *SearchVariantSetsRequest) GetDatasetIds() []string {
	if x != nil {
		return x.DatasetIds
	}
	return nil
}

func (x *SearchVariantSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchVariantSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// The search variant sets response.
type SearchVariantSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The variant sets belonging to the requested dataset.
	VariantSets []*VariantSet `protobuf:"bytes,1,rep,name=variant_sets,json=variantSets,proto3" json:"variant_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchVariantSetsResponse) Reset() {
	*x = SearchVariantSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[12]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchVariantSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchVariantSetsResponse) ProtoMessage() {}

func (x *SearchVariantSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[12]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchVariantSetsResponse.ProtoReflect.Descriptor instead.
func (*SearchVariantSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{12}
}

func (x *SearchVariantSetsResponse) GetVariantSets() []*VariantSet {
	if x != nil {
		return x.VariantSets
	}
	return nil
}

func (x *SearchVariantSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

// The delete variant set request.
type DeleteVariantSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the variant set to be deleted.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId,proto3" json:"variant_set_id,omitempty"`
}

func (x *DeleteVariantSetRequest) Reset() {
	*x = DeleteVariantSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[13]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteVariantSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVariantSetRequest) ProtoMessage() {}

func (x *DeleteVariantSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[13]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVariantSetRequest.ProtoReflect.Descriptor instead.
func (*DeleteVariantSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{13}
}

func (x *DeleteVariantSetRequest) GetVariantSetId() string {
	if x != nil {
		return x.VariantSetId
	}
	return ""
}

type UpdateVariantSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the variant to be updated (must already exist).
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId,proto3" json:"variant_set_id,omitempty"`
	// The new variant data. Only the variant_set.metadata will be considered
	// for update.
	VariantSet *VariantSet `protobuf:"bytes,2,opt,name=variant_set,json=variantSet,proto3" json:"variant_set,omitempty"`
	// An optional mask specifying which fields to update. Supported fields:
	//
	// * [metadata][google.genomics.v1.VariantSet.metadata].
	// * [name][google.genomics.v1.VariantSet.name].
	// * [description][google.genomics.v1.VariantSet.description].
	//
	// Leaving `updateMask` unset is equivalent to specifying all mutable
	// fields.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,5,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateVariantSetRequest) Reset() {
	*x = UpdateVariantSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[14]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateVariantSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVariantSetRequest) ProtoMessage() {}

func (x *UpdateVariantSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[14]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVariantSetRequest.ProtoReflect.Descriptor instead.
func (*UpdateVariantSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{14}
}

func (x *UpdateVariantSetRequest) GetVariantSetId() string {
	if x != nil {
		return x.VariantSetId
	}
	return ""
}

func (x *UpdateVariantSetRequest) GetVariantSet() *VariantSet {
	if x != nil {
		return x.VariantSet
	}
	return nil
}

func (x *UpdateVariantSetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

// The variant search request.
type SearchVariantsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// At most one variant set ID must be provided. Only variants from this
	// variant set will be returned. If omitted, a call set id must be included in
	// the request.
	VariantSetIds []string `protobuf:"bytes,1,rep,name=variant_set_ids,json=variantSetIds,proto3" json:"variant_set_ids,omitempty"`
	// Only return variants which have exactly this name.
	VariantName string `protobuf:"bytes,2,opt,name=variant_name,json=variantName,proto3" json:"variant_name,omitempty"`
	// Only return variant calls which belong to call sets with these ids.
	// Leaving this blank returns all variant calls. If a variant has no
	// calls belonging to any of these call sets, it won't be returned at all.
	CallSetIds []string `protobuf:"bytes,3,rep,name=call_set_ids,json=callSetIds,proto3" json:"call_set_ids,omitempty"`
	// Required. Only return variants in this reference sequence.
	ReferenceName string `protobuf:"bytes,4,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// The beginning of the window (0-based, inclusive) for which
	// overlapping variants should be returned. If unspecified, defaults to 0.
	Start int64 `protobuf:"varint,5,opt,name=start,proto3" json:"start,omitempty"`
	// The end of the window, 0-based exclusive. If unspecified or 0, defaults to
	// the length of the reference.
	End int64 `protobuf:"varint,6,opt,name=end,proto3" json:"end,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,7,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of variants to return in a single page. If unspecified,
	// defaults to 5000. The maximum value is 10000.
	PageSize int32 `protobuf:"varint,8,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
	// The maximum number of calls to return in a single page. Note that this
	// limit may be exceeded in the event that a matching variant contains more
	// calls than the requested maximum. If unspecified, defaults to 5000. The
	// maximum value is 10000.
	MaxCalls int32 `protobuf:"varint,9,opt,name=max_calls,json=maxCalls,proto3" json:"max_calls,omitempty"`
}

func (x *SearchVariantsRequest) Reset() {
	*x = SearchVariantsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[15]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchVariantsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchVariantsRequest) ProtoMessage() {}

func (x *SearchVariantsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[15]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchVariantsRequest.ProtoReflect.Descriptor instead.
func (*SearchVariantsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{15}
}

func (x *SearchVariantsRequest) GetVariantSetIds() []string {
	if x != nil {
		return x.VariantSetIds
	}
	return nil
}

func (x *SearchVariantsRequest) GetVariantName() string {
	if x != nil {
		return x.VariantName
	}
	return ""
}

func (x *SearchVariantsRequest) GetCallSetIds() []string {
	if x != nil {
		return x.CallSetIds
	}
	return nil
}

func (x *SearchVariantsRequest) GetReferenceName() string {
	if x != nil {
		return x.ReferenceName
	}
	return ""
}

func (x *SearchVariantsRequest) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *SearchVariantsRequest) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

func (x *SearchVariantsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchVariantsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

func (x *SearchVariantsRequest) GetMaxCalls() int32 {
	if x != nil {
		return x.MaxCalls
	}
	return 0
}

// The variant search response.
type SearchVariantsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching Variants.
	Variants []*Variant `protobuf:"bytes,1,rep,name=variants,proto3" json:"variants,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchVariantsResponse) Reset() {
	*x = SearchVariantsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[16]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchVariantsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchVariantsResponse) ProtoMessage() {}

func (x *SearchVariantsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[16]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchVariantsResponse.ProtoReflect.Descriptor instead.
func (*SearchVariantsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{16}
}

func (x *SearchVariantsResponse) GetVariants() []*Variant {
	if x != nil {
		return x.Variants
	}
	return nil
}

func (x *SearchVariantsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateVariantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The variant to be created.
	Variant *Variant `protobuf:"bytes,1,opt,name=variant,proto3" json:"variant,omitempty"`
}

func (x *CreateVariantRequest) Reset() {
	*x = CreateVariantRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[17]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateVariantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateVariantRequest) ProtoMessage() {}

func (x *CreateVariantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[17]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateVariantRequest.ProtoReflect.Descriptor instead.
func (*CreateVariantRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{17}
}

func (x *CreateVariantRequest) GetVariant() *Variant {
	if x != nil {
		return x.Variant
	}
	return nil
}

type UpdateVariantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the variant to be updated.
	VariantId string `protobuf:"bytes,1,opt,name=variant_id,json=variantId,proto3" json:"variant_id,omitempty"`
	// The new variant data.
	Variant *Variant `protobuf:"bytes,2,opt,name=variant,proto3" json:"variant,omitempty"`
	// An optional mask specifying which fields to update. At this time, mutable
	// fields are [names][google.genomics.v1.Variant.names] and
	// [info][google.genomics.v1.Variant.info]. Acceptable values are "names" and
	// "info". If unspecified, all mutable fields will be updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateVariantRequest) Reset() {
	*x = UpdateVariantRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[18]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateVariantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateVariantRequest) ProtoMessage() {}

func (x *UpdateVariantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[18]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateVariantRequest.ProtoReflect.Descriptor instead.
func (*UpdateVariantRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{18}
}

func (x *UpdateVariantRequest) GetVariantId() string {
	if x != nil {
		return x.VariantId
	}
	return ""
}

func (x *UpdateVariantRequest) GetVariant() *Variant {
	if x != nil {
		return x.Variant
	}
	return nil
}

func (x *UpdateVariantRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

type DeleteVariantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the variant to be deleted.
	VariantId string `protobuf:"bytes,1,opt,name=variant_id,json=variantId,proto3" json:"variant_id,omitempty"`
}

func (x *DeleteVariantRequest) Reset() {
	*x = DeleteVariantRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[19]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteVariantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteVariantRequest) ProtoMessage() {}

func (x *DeleteVariantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[19]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteVariantRequest.ProtoReflect.Descriptor instead.
func (*DeleteVariantRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{19}
}

func (x *DeleteVariantRequest) GetVariantId() string {
	if x != nil {
		return x.VariantId
	}
	return ""
}

type GetVariantRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the variant.
	VariantId string `protobuf:"bytes,1,opt,name=variant_id,json=variantId,proto3" json:"variant_id,omitempty"`
}

func (x *GetVariantRequest) Reset() {
	*x = GetVariantRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[20]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetVariantRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetVariantRequest) ProtoMessage() {}

func (x *GetVariantRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[20]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetVariantRequest.ProtoReflect.Descriptor instead.
func (*GetVariantRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{20}
}

func (x *GetVariantRequest) GetVariantId() string {
	if x != nil {
		return x.VariantId
	}
	return ""
}

type MergeVariantsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The destination variant set.
	VariantSetId string `protobuf:"bytes,1,opt,name=variant_set_id,json=variantSetId,proto3" json:"variant_set_id,omitempty"`
	// The variants to be merged with existing variants.
	Variants []*Variant `protobuf:"bytes,2,rep,name=variants,proto3" json:"variants,omitempty"`
	// A mapping between info field keys and the InfoMergeOperations to
	// be performed on them.
	InfoMergeConfig map[string]InfoMergeOperation `protobuf:"bytes,3,rep,name=info_merge_config,json=infoMergeConfig,proto3" json:"info_merge_config,omitempty" protobuf_key:"bytes,1,opt,name=key,proto3" protobuf_val:"varint,2,opt,name=value,proto3,enum=google.genomics.v1.InfoMergeOperation"`
}

func (x *MergeVariantsRequest) Reset() {
	*x = MergeVariantsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[21]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *MergeVariantsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*MergeVariantsRequest) ProtoMessage() {}

func (x *MergeVariantsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[21]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use MergeVariantsRequest.ProtoReflect.Descriptor instead.
func (*MergeVariantsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{21}
}

func (x *MergeVariantsRequest) GetVariantSetId() string {
	if x != nil {
		return x.VariantSetId
	}
	return ""
}

func (x *MergeVariantsRequest) GetVariants() []*Variant {
	if x != nil {
		return x.Variants
	}
	return nil
}

func (x *MergeVariantsRequest) GetInfoMergeConfig() map[string]InfoMergeOperation {
	if x != nil {
		return x.InfoMergeConfig
	}
	return nil
}

// The call set search request.
type SearchCallSetsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// Restrict the query to call sets within the given variant sets. At least one
	// ID must be provided.
	VariantSetIds []string `protobuf:"bytes,1,rep,name=variant_set_ids,json=variantSetIds,proto3" json:"variant_set_ids,omitempty"`
	// Only return call sets for which a substring of the name matches this
	// string.
	Name string `protobuf:"bytes,2,opt,name=name,proto3" json:"name,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// To get the next page of results, set this parameter to the value of
	// `nextPageToken` from the previous response.
	PageToken string `protobuf:"bytes,3,opt,name=page_token,json=pageToken,proto3" json:"page_token,omitempty"`
	// The maximum number of results to return in a single page. If unspecified,
	// defaults to 1024.
	PageSize int32 `protobuf:"varint,4,opt,name=page_size,json=pageSize,proto3" json:"page_size,omitempty"`
}

func (x *SearchCallSetsRequest) Reset() {
	*x = SearchCallSetsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[22]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCallSetsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCallSetsRequest) ProtoMessage() {}

func (x *SearchCallSetsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[22]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCallSetsRequest.ProtoReflect.Descriptor instead.
func (*SearchCallSetsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{22}
}

func (x *SearchCallSetsRequest) GetVariantSetIds() []string {
	if x != nil {
		return x.VariantSetIds
	}
	return nil
}

func (x *SearchCallSetsRequest) GetName() string {
	if x != nil {
		return x.Name
	}
	return ""
}

func (x *SearchCallSetsRequest) GetPageToken() string {
	if x != nil {
		return x.PageToken
	}
	return ""
}

func (x *SearchCallSetsRequest) GetPageSize() int32 {
	if x != nil {
		return x.PageSize
	}
	return 0
}

// The call set search response.
type SearchCallSetsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The list of matching call sets.
	CallSets []*CallSet `protobuf:"bytes,1,rep,name=call_sets,json=callSets,proto3" json:"call_sets,omitempty"`
	// The continuation token, which is used to page through large result sets.
	// Provide this value in a subsequent request to return the next page of
	// results. This field will be empty if there aren't any additional results.
	NextPageToken string `protobuf:"bytes,2,opt,name=next_page_token,json=nextPageToken,proto3" json:"next_page_token,omitempty"`
}

func (x *SearchCallSetsResponse) Reset() {
	*x = SearchCallSetsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[23]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *SearchCallSetsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*SearchCallSetsResponse) ProtoMessage() {}

func (x *SearchCallSetsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[23]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use SearchCallSetsResponse.ProtoReflect.Descriptor instead.
func (*SearchCallSetsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{23}
}

func (x *SearchCallSetsResponse) GetCallSets() []*CallSet {
	if x != nil {
		return x.CallSets
	}
	return nil
}

func (x *SearchCallSetsResponse) GetNextPageToken() string {
	if x != nil {
		return x.NextPageToken
	}
	return ""
}

type CreateCallSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The call set to be created.
	CallSet *CallSet `protobuf:"bytes,1,opt,name=call_set,json=callSet,proto3" json:"call_set,omitempty"`
}

func (x *CreateCallSetRequest) Reset() {
	*x = CreateCallSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[24]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *CreateCallSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*CreateCallSetRequest) ProtoMessage() {}

func (x *CreateCallSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[24]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use CreateCallSetRequest.ProtoReflect.Descriptor instead.
func (*CreateCallSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{24}
}

func (x *CreateCallSetRequest) GetCallSet() *CallSet {
	if x != nil {
		return x.CallSet
	}
	return nil
}

type UpdateCallSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the call set to be updated.
	CallSetId string `protobuf:"bytes,1,opt,name=call_set_id,json=callSetId,proto3" json:"call_set_id,omitempty"`
	// The new call set data.
	CallSet *CallSet `protobuf:"bytes,2,opt,name=call_set,json=callSet,proto3" json:"call_set,omitempty"`
	// An optional mask specifying which fields to update. At this time, the only
	// mutable field is [name][google.genomics.v1.CallSet.name]. The only
	// acceptable value is "name". If unspecified, all mutable fields will be
	// updated.
	UpdateMask *fieldmaskpb.FieldMask `protobuf:"bytes,3,opt,name=update_mask,json=updateMask,proto3" json:"update_mask,omitempty"`
}

func (x *UpdateCallSetRequest) Reset() {
	*x = UpdateCallSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[25]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *UpdateCallSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*UpdateCallSetRequest) ProtoMessage() {}

func (x *UpdateCallSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[25]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use UpdateCallSetRequest.ProtoReflect.Descriptor instead.
func (*UpdateCallSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{25}
}

func (x *UpdateCallSetRequest) GetCallSetId() string {
	if x != nil {
		return x.CallSetId
	}
	return ""
}

func (x *UpdateCallSetRequest) GetCallSet() *CallSet {
	if x != nil {
		return x.CallSet
	}
	return nil
}

func (x *UpdateCallSetRequest) GetUpdateMask() *fieldmaskpb.FieldMask {
	if x != nil {
		return x.UpdateMask
	}
	return nil
}

type DeleteCallSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the call set to be deleted.
	CallSetId string `protobuf:"bytes,1,opt,name=call_set_id,json=callSetId,proto3" json:"call_set_id,omitempty"`
}

func (x *DeleteCallSetRequest) Reset() {
	*x = DeleteCallSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[26]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *DeleteCallSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*DeleteCallSetRequest) ProtoMessage() {}

func (x *DeleteCallSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[26]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use DeleteCallSetRequest.ProtoReflect.Descriptor instead.
func (*DeleteCallSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{26}
}

func (x *DeleteCallSetRequest) GetCallSetId() string {
	if x != nil {
		return x.CallSetId
	}
	return ""
}

type GetCallSetRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The ID of the call set.
	CallSetId string `protobuf:"bytes,1,opt,name=call_set_id,json=callSetId,proto3" json:"call_set_id,omitempty"`
}

func (x *GetCallSetRequest) Reset() {
	*x = GetCallSetRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[27]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *GetCallSetRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*GetCallSetRequest) ProtoMessage() {}

func (x *GetCallSetRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[27]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use GetCallSetRequest.ProtoReflect.Descriptor instead.
func (*GetCallSetRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{27}
}

func (x *GetCallSetRequest) GetCallSetId() string {
	if x != nil {
		return x.CallSetId
	}
	return ""
}

// The stream variants request.
type StreamVariantsRequest struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	// The Google Cloud project ID which will be billed
	// for this access. The caller must have WRITE access to this project.
	// Required.
	ProjectId string `protobuf:"bytes,1,opt,name=project_id,json=projectId,proto3" json:"project_id,omitempty"`
	// The variant set ID from which to stream variants.
	VariantSetId string `protobuf:"bytes,2,opt,name=variant_set_id,json=variantSetId,proto3" json:"variant_set_id,omitempty"`
	// Only return variant calls which belong to call sets with these IDs.
	// Leaving this blank returns all variant calls.
	CallSetIds []string `protobuf:"bytes,3,rep,name=call_set_ids,json=callSetIds,proto3" json:"call_set_ids,omitempty"`
	// Required. Only return variants in this reference sequence.
	ReferenceName string `protobuf:"bytes,4,opt,name=reference_name,json=referenceName,proto3" json:"reference_name,omitempty"`
	// The beginning of the window (0-based, inclusive) for which
	// overlapping variants should be returned.
	Start int64 `protobuf:"varint,5,opt,name=start,proto3" json:"start,omitempty"`
	// The end of the window (0-based, exclusive) for which overlapping
	// variants should be returned.
	End int64 `protobuf:"varint,6,opt,name=end,proto3" json:"end,omitempty"`
}

func (x *StreamVariantsRequest) Reset() {
	*x = StreamVariantsRequest{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[28]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamVariantsRequest) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamVariantsRequest) ProtoMessage() {}

func (x *StreamVariantsRequest) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[28]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamVariantsRequest.ProtoReflect.Descriptor instead.
func (*StreamVariantsRequest) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{28}
}

func (x *StreamVariantsRequest) GetProjectId() string {
	if x != nil {
		return x.ProjectId
	}
	return ""
}

func (x *StreamVariantsRequest) GetVariantSetId() string {
	if x != nil {
		return x.VariantSetId
	}
	return ""
}

func (x *StreamVariantsRequest) GetCallSetIds() []string {
	if x != nil {
		return x.CallSetIds
	}
	return nil
}

func (x *StreamVariantsRequest) GetReferenceName() string {
	if x != nil {
		return x.ReferenceName
	}
	return ""
}

func (x *StreamVariantsRequest) GetStart() int64 {
	if x != nil {
		return x.Start
	}
	return 0
}

func (x *StreamVariantsRequest) GetEnd() int64 {
	if x != nil {
		return x.End
	}
	return 0
}

type StreamVariantsResponse struct {
	state         protoimpl.MessageState
	sizeCache     protoimpl.SizeCache
	unknownFields protoimpl.UnknownFields

	Variants []*Variant `protobuf:"bytes,1,rep,name=variants,proto3" json:"variants,omitempty"`
}

func (x *StreamVariantsResponse) Reset() {
	*x = StreamVariantsResponse{}
	if protoimpl.UnsafeEnabled {
		mi := &file_google_genomics_v1_variants_proto_msgTypes[29]
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		ms.StoreMessageInfo(mi)
	}
}

func (x *StreamVariantsResponse) String() string {
	return protoimpl.X.MessageStringOf(x)
}

func (*StreamVariantsResponse) ProtoMessage() {}

func (x *StreamVariantsResponse) ProtoReflect() protoreflect.Message {
	mi := &file_google_genomics_v1_variants_proto_msgTypes[29]
	if protoimpl.UnsafeEnabled && x != nil {
		ms := protoimpl.X.MessageStateOf(protoimpl.Pointer(x))
		if ms.LoadMessageInfo() == nil {
			ms.StoreMessageInfo(mi)
		}
		return ms
	}
	return mi.MessageOf(x)
}

// Deprecated: Use StreamVariantsResponse.ProtoReflect.Descriptor instead.
func (*StreamVariantsResponse) Descriptor() ([]byte, []int) {
	return file_google_genomics_v1_variants_proto_rawDescGZIP(), []int{29}
}

func (x *StreamVariantsResponse) GetVariants() []*Variant {
	if x != nil {
		return x.Variants
	}
	return nil
}

var File_google_genomics_v1_variants_proto protoreflect.FileDescriptor

var file_google_genomics_v1_variants_proto_rawDesc = []byte{
	0x0a, 0x21, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x2e, 0x70, 0x72,
	0x6f, 0x74, 0x6f, 0x12, 0x12, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x61, 0x70, 0x69, 0x2f, 0x61, 0x6e, 0x6e, 0x6f, 0x74, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x73, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x23, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f, 0x6c, 0x6f,
	0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2f, 0x6f, 0x70, 0x65, 0x72, 0x61, 0x74,
	0x69, 0x6f, 0x6e, 0x73, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1b, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x65, 0x6d, 0x70, 0x74,
	0x79, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x20, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2f,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x66, 0x69, 0x65, 0x6c, 0x64, 0x5f, 0x6d,
	0x61, 0x73, 0x6b, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x1a, 0x1c, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2f, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2f, 0x73, 0x74, 0x72, 0x75, 0x63,
	0x74, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x22, 0xbd, 0x03, 0x0a, 0x12, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x12, 0x10,
	0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79,
	0x12, 0x14, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x04, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x3f, 0x0a, 0x04, 0x74, 0x79, 0x70, 0x65, 0x18, 0x05,
	0x20, 0x01, 0x28, 0x0e, 0x32, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x53, 0x65, 0x74, 0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x54, 0x79, 0x70,
	0x65, 0x52, 0x04, 0x74, 0x79, 0x70, 0x65, 0x12, 0x16, 0x0a, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65,
	0x72, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x06, 0x6e, 0x75, 0x6d, 0x62, 0x65, 0x72, 0x12,
	0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x07,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f,
	0x6e, 0x12, 0x44, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x03, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x4d,
	0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72,
	0x79, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a, 0x53, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45,
	0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70,
	0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75,
	0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x59, 0x0a, 0x04,
	0x54, 0x79, 0x70, 0x65, 0x12, 0x14, 0x0a, 0x10, 0x54, 0x59, 0x50, 0x45, 0x5f, 0x55, 0x4e, 0x53,
	0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0b, 0x0a, 0x07, 0x49, 0x4e,
	0x54, 0x45, 0x47, 0x45, 0x52, 0x10, 0x01, 0x12, 0x09, 0x0a, 0x05, 0x46, 0x4c, 0x4f, 0x41, 0x54,
	0x10, 0x02, 0x12, 0x08, 0x0a, 0x04, 0x46, 0x4c, 0x41, 0x47, 0x10, 0x03, 0x12, 0x0d, 0x0a, 0x09,
	0x43, 0x48, 0x41, 0x52, 0x41, 0x43, 0x54, 0x45, 0x52, 0x10, 0x04, 0x12, 0x0a, 0x0a, 0x06, 0x53,
	0x54, 0x52, 0x49, 0x4e, 0x47, 0x10, 0x05, 0x22, 0xae, 0x02, 0x0a, 0x0a, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x64, 0x61, 0x74, 0x61,
	0x73, 0x65, 0x74, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x02, 0x20, 0x01, 0x28,
	0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x28, 0x0a, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12,
	0x4d, 0x0a, 0x10, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x62, 0x6f, 0x75,
	0x6e, 0x64, 0x73, 0x18, 0x05, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x22, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x52,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x52, 0x0f, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x73, 0x12, 0x42,
	0x0a, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x18, 0x04, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74,
	0x4d, 0x65, 0x74, 0x61, 0x64, 0x61, 0x74, 0x61, 0x52, 0x08, 0x6d, 0x65, 0x74, 0x61, 0x64, 0x61,
	0x74, 0x61, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0b, 0x64, 0x65, 0x73, 0x63, 0x72, 0x69,
	0x70, 0x74, 0x69, 0x6f, 0x6e, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x64, 0x65, 0x73,
	0x63, 0x72, 0x69, 0x70, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x89, 0x04, 0x0a, 0x07, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x0f, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69, 0x64, 0x12, 0x14, 0x0a, 0x05, 0x6e, 0x61,
	0x6d, 0x65, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x05, 0x6e, 0x61, 0x6d, 0x65, 0x73,
	0x12, 0x18, 0x0a, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x0c, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x07, 0x63, 0x72, 0x65, 0x61, 0x74, 0x65, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65,
	0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x0e, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d,
	0x65, 0x12, 0x14, 0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x10, 0x20, 0x01, 0x28, 0x03,
	0x52, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x0d,
	0x20, 0x01, 0x28, 0x03, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x12, 0x27, 0x0a, 0x0f, 0x72, 0x65, 0x66,
	0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x5f, 0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x06, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x42, 0x61, 0x73,
	0x65, 0x73, 0x12, 0x27, 0x0a, 0x0f, 0x61, 0x6c, 0x74, 0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x5f,
	0x62, 0x61, 0x73, 0x65, 0x73, 0x18, 0x07, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0e, 0x61, 0x6c, 0x74,
	0x65, 0x72, 0x6e, 0x61, 0x74, 0x65, 0x42, 0x61, 0x73, 0x65, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x71,
	0x75, 0x61, 0x6c, 0x69, 0x74, 0x79, 0x18, 0x08, 0x20, 0x01, 0x28, 0x01, 0x52, 0x07, 0x71, 0x75,
	0x61, 0x6c, 0x69, 0x74, 0x79, 0x12, 0x16, 0x0a, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x18,
	0x09, 0x20, 0x03, 0x28, 0x09, 0x52, 0x06, 0x66, 0x69, 0x6c, 0x74, 0x65, 0x72, 0x12, 0x39, 0x0a,
	0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x0a, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31,
	0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74,
	0x72, 0x79, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x12, 0x35, 0x0a, 0x05, 0x63, 0x61, 0x6c, 0x6c,
	0x73, 0x18, 0x0b, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1f, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x43, 0x61, 0x6c, 0x6c, 0x52, 0x05, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x1a,
	0x53, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x30,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0xce, 0x02, 0x0a, 0x0b, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x43, 0x61, 0x6c, 0x6c, 0x12, 0x1e, 0x0a, 0x0b, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x08, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x53,
	0x65, 0x74, 0x49, 0x64, 0x12, 0x22, 0x0a, 0x0d, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x09, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x63, 0x61, 0x6c,
	0x6c, 0x53, 0x65, 0x74, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x67, 0x65, 0x6e, 0x6f,
	0x74, 0x79, 0x70, 0x65, 0x18, 0x07, 0x20, 0x03, 0x28, 0x05, 0x52, 0x08, 0x67, 0x65, 0x6e, 0x6f,
	0x74, 0x79, 0x70, 0x65, 0x12, 0x1a, 0x0a, 0x08, 0x70, 0x68, 0x61, 0x73, 0x65, 0x73, 0x65, 0x74,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x70, 0x68, 0x61, 0x73, 0x65, 0x73, 0x65, 0x74,
	0x12, 0x2f, 0x0a, 0x13, 0x67, 0x65, 0x6e, 0x6f, 0x74, 0x79, 0x70, 0x65, 0x5f, 0x6c, 0x69, 0x6b,
	0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f, 0x64, 0x18, 0x06, 0x20, 0x03, 0x28, 0x01, 0x52, 0x12, 0x67,
	0x65, 0x6e, 0x6f, 0x74, 0x79, 0x70, 0x65, 0x4c, 0x69, 0x6b, 0x65, 0x6c, 0x69, 0x68, 0x6f, 0x6f,
	0x64, 0x12, 0x3d, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x43, 0x61, 0x6c, 0x6c,
	0x2e, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f,
	0x1a, 0x53, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a,
	0x03, 0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12,
	0x30, 0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75,
	0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x9c, 0x02, 0x0a, 0x07, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65,
	0x74, 0x12, 0x0e, 0x0a, 0x02, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x02, 0x69,
	0x64, 0x12, 0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x04, 0x6e, 0x61, 0x6d, 0x65, 0x12, 0x1b, 0x0a, 0x09, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65, 0x5f,
	0x69, 0x64, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x08, 0x73, 0x61, 0x6d, 0x70, 0x6c, 0x65,
	0x49, 0x64, 0x12, 0x26, 0x0a, 0x0f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x06, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0d, 0x76, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x18, 0x0a, 0x07, 0x63, 0x72,
	0x65, 0x61, 0x74, 0x65, 0x64, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x07, 0x63, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x64, 0x12, 0x39, 0x0a, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x18, 0x04, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x2e,
	0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x52, 0x04, 0x69, 0x6e, 0x66, 0x6f, 0x1a,
	0x53, 0x0a, 0x09, 0x49, 0x6e, 0x66, 0x6f, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03,
	0x6b, 0x65, 0x79, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x30,
	0x0a, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e,
	0x4c, 0x69, 0x73, 0x74, 0x56, 0x61, 0x6c, 0x75, 0x65, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65,
	0x3a, 0x02, 0x38, 0x01, 0x22, 0x58, 0x0a, 0x0e, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63,
	0x65, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65,
	0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x1f, 0x0a,
	0x0b, 0x75, 0x70, 0x70, 0x65, 0x72, 0x5f, 0x62, 0x6f, 0x75, 0x6e, 0x64, 0x18, 0x02, 0x20, 0x01,
	0x28, 0x03, 0x52, 0x0a, 0x75, 0x70, 0x70, 0x65, 0x72, 0x42, 0x6f, 0x75, 0x6e, 0x64, 0x22, 0x8c,
	0x04, 0x0a, 0x15, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x1f,
	0x0a, 0x0b, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x5f, 0x75, 0x72, 0x69, 0x73, 0x18, 0x02, 0x20,
	0x03, 0x28, 0x09, 0x52, 0x0a, 0x73, 0x6f, 0x75, 0x72, 0x63, 0x65, 0x55, 0x72, 0x69, 0x73, 0x12,
	0x48, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0e, 0x32,
	0x30, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61,
	0x74, 0x52, 0x06, 0x66, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x3a, 0x0a, 0x19, 0x6e, 0x6f, 0x72,
	0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x5f, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x73, 0x18, 0x05, 0x20, 0x01, 0x28, 0x08, 0x52, 0x17, 0x6e, 0x6f,
	0x72, 0x6d, 0x61, 0x6c, 0x69, 0x7a, 0x65, 0x52, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65,
	0x4e, 0x61, 0x6d, 0x65, 0x73, 0x12, 0x6a, 0x0a, 0x11, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x6d, 0x65,
	0x72, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x06, 0x20, 0x03, 0x28, 0x0b,
	0x32, 0x3e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x66, 0x6f,
	0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0f, 0x69, 0x6e, 0x66, 0x6f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x1a, 0x6a, 0x0a, 0x14, 0x49, 0x6e, 0x66, 0x6f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3c, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x66, 0x6f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x4e, 0x0a,
	0x06, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x12, 0x16, 0x0a, 0x12, 0x46, 0x4f, 0x52, 0x4d, 0x41,
	0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12,
	0x0e, 0x0a, 0x0a, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x56, 0x43, 0x46, 0x10, 0x01, 0x12,
	0x1c, 0x0a, 0x18, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x43, 0x4f, 0x4d, 0x50, 0x4c, 0x45,
	0x54, 0x45, 0x5f, 0x47, 0x45, 0x4e, 0x4f, 0x4d, 0x49, 0x43, 0x53, 0x10, 0x02, 0x22, 0x3a, 0x0a,
	0x16, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x63, 0x61, 0x6c, 0x6c, 0x5f,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x63,
	0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x49, 0x64, 0x73, 0x22, 0x5a, 0x0a, 0x17, 0x43, 0x72, 0x65,
	0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x3f, 0x0a, 0x0b, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f,
	0x73, 0x65, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x52, 0x0a, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x22, 0xd5, 0x02, 0x0a, 0x17, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x63, 0x61, 0x6c, 0x6c, 0x5f,
	0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x63,
	0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f,
	0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70,
	0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12, 0x4a, 0x0a, 0x06, 0x66, 0x6f, 0x72, 0x6d,
	0x61, 0x74, 0x18, 0x04, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x32, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74, 0x52, 0x06, 0x66, 0x6f,
	0x72, 0x6d, 0x61, 0x74, 0x12, 0x29, 0x0a, 0x10, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79,
	0x5f, 0x64, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0f,
	0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x44, 0x61, 0x74, 0x61, 0x73, 0x65, 0x74, 0x12,
	0x25, 0x0a, 0x0e, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72, 0x79, 0x5f, 0x74, 0x61, 0x62, 0x6c,
	0x65, 0x18, 0x06, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x62, 0x69, 0x67, 0x71, 0x75, 0x65, 0x72,
	0x79, 0x54, 0x61, 0x62, 0x6c, 0x65, 0x22, 0x35, 0x0a, 0x06, 0x46, 0x6f, 0x72, 0x6d, 0x61, 0x74,
	0x12, 0x16, 0x0a, 0x12, 0x46, 0x4f, 0x52, 0x4d, 0x41, 0x54, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45,
	0x43, 0x49, 0x46, 0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x13, 0x0a, 0x0f, 0x46, 0x4f, 0x52, 0x4d,
	0x41, 0x54, 0x5f, 0x42, 0x49, 0x47, 0x51, 0x55, 0x45, 0x52, 0x59, 0x10, 0x01, 0x22, 0x3c, 0x0a,
	0x14, 0x47, 0x65, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x22, 0x77, 0x0a, 0x18, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1f, 0x0a, 0x0b, 0x64, 0x61, 0x74, 0x61, 0x73,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x64, 0x61,
	0x74, 0x61, 0x73, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61,
	0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f,
	0x73, 0x69, 0x7a, 0x65, 0x18, 0x03, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65,
	0x53, 0x69, 0x7a, 0x65, 0x22, 0x86, 0x01, 0x0a, 0x19, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e,
	0x73, 0x65, 0x12, 0x41, 0x0a, 0x0c, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65,
	0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x52, 0x0b, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x53, 0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61,
	0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d,
	0x6e, 0x65, 0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x3f, 0x0a,
	0x17, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09,
	0x52, 0x0c, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x22, 0xbd,
	0x01, 0x0a, 0x17, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01,
	0x28, 0x09, 0x52, 0x0c, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64,
	0x12, 0x3f, 0x0a, 0x0b, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x18,
	0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x52, 0x0a, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65,
	0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b,
	0x18, 0x05, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61,
	0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0xac,
	0x02, 0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28,
	0x09, 0x52, 0x0d, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x73,
	0x12, 0x21, 0x0a, 0x0c, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x6e, 0x61, 0x6d, 0x65,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0b, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x4e,
	0x61, 0x6d, 0x65, 0x12, 0x20, 0x0a, 0x0c, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x5f,
	0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x61, 0x6c, 0x6c, 0x53,
	0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e,
	0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x72,
	0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14, 0x0a, 0x05,
	0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73, 0x74, 0x61,
	0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28, 0x03, 0x52,
	0x03, 0x65, 0x6e, 0x64, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b,
	0x65, 0x6e, 0x18, 0x07, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f,
	0x6b, 0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65,
	0x18, 0x08, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65,
	0x12, 0x1b, 0x0a, 0x09, 0x6d, 0x61, 0x78, 0x5f, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x18, 0x09, 0x20,
	0x01, 0x28, 0x05, 0x52, 0x08, 0x6d, 0x61, 0x78, 0x43, 0x61, 0x6c, 0x6c, 0x73, 0x22, 0x79, 0x0a,
	0x16, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x37, 0x0a, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73,
	0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f,
	0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65, 0x78, 0x74, 0x50,
	0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4d, 0x0a, 0x14, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x35, 0x0a, 0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x18, 0x01, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x07,
	0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x22, 0xa9, 0x01, 0x0a, 0x14, 0x55, 0x70, 0x64, 0x61,
	0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x12,
	0x35, 0x0a, 0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0b,
	0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x07, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x3b, 0x0a, 0x0b, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65,
	0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x46, 0x69,
	0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x4d,
	0x61, 0x73, 0x6b, 0x22, 0x35, 0x0a, 0x14, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1d, 0x0a, 0x0a, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x09, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x22, 0x32, 0x0a, 0x11, 0x47, 0x65,
	0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12,
	0x1d, 0x0a, 0x0a, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20,
	0x01, 0x28, 0x09, 0x52, 0x09, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x49, 0x64, 0x22, 0xcc,
	0x02, 0x0a, 0x14, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x24, 0x0a, 0x0e, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0c, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x37, 0x0a,
	0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x02, 0x20, 0x03, 0x28, 0x0b, 0x32,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x08, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x69, 0x0a, 0x11, 0x69, 0x6e, 0x66, 0x6f, 0x5f, 0x6d,
	0x65, 0x72, 0x67, 0x65, 0x5f, 0x63, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x18, 0x03, 0x20, 0x03, 0x28,
	0x0b, 0x32, 0x3d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x2e, 0x49, 0x6e, 0x66, 0x6f,
	0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79,
	0x52, 0x0f, 0x69, 0x6e, 0x66, 0x6f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x6f, 0x6e, 0x66, 0x69,
	0x67, 0x1a, 0x6a, 0x0a, 0x14, 0x49, 0x6e, 0x66, 0x6f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x43, 0x6f,
	0x6e, 0x66, 0x69, 0x67, 0x45, 0x6e, 0x74, 0x72, 0x79, 0x12, 0x10, 0x0a, 0x03, 0x6b, 0x65, 0x79,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x03, 0x6b, 0x65, 0x79, 0x12, 0x3c, 0x0a, 0x05, 0x76,
	0x61, 0x6c, 0x75, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x0e, 0x32, 0x26, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x49, 0x6e, 0x66, 0x6f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69,
	0x6f, 0x6e, 0x52, 0x05, 0x76, 0x61, 0x6c, 0x75, 0x65, 0x3a, 0x02, 0x38, 0x01, 0x22, 0x8f, 0x01,
	0x0a, 0x15, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x73,
	0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x26, 0x0a, 0x0f, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x09,
	0x52, 0x0d, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12,
	0x12, 0x0a, 0x04, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x04, 0x6e,
	0x61, 0x6d, 0x65, 0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x74, 0x6f, 0x6b, 0x65,
	0x6e, 0x18, 0x03, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b,
	0x65, 0x6e, 0x12, 0x1b, 0x0a, 0x09, 0x70, 0x61, 0x67, 0x65, 0x5f, 0x73, 0x69, 0x7a, 0x65, 0x18,
	0x04, 0x20, 0x01, 0x28, 0x05, 0x52, 0x08, 0x70, 0x61, 0x67, 0x65, 0x53, 0x69, 0x7a, 0x65, 0x22,
	0x7a, 0x0a, 0x16, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x12, 0x38, 0x0a, 0x09, 0x63, 0x61, 0x6c,
	0x6c, 0x5f, 0x73, 0x65, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x52, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x53,
	0x65, 0x74, 0x73, 0x12, 0x26, 0x0a, 0x0f, 0x6e, 0x65, 0x78, 0x74, 0x5f, 0x70, 0x61, 0x67, 0x65,
	0x5f, 0x74, 0x6f, 0x6b, 0x65, 0x6e, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0d, 0x6e, 0x65,
	0x78, 0x74, 0x50, 0x61, 0x67, 0x65, 0x54, 0x6f, 0x6b, 0x65, 0x6e, 0x22, 0x4e, 0x0a, 0x14, 0x43,
	0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x12, 0x36, 0x0a, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x18,
	0x01, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x53,
	0x65, 0x74, 0x52, 0x07, 0x63, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x22, 0xab, 0x01, 0x0a, 0x14,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x0b, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x53,
	0x65, 0x74, 0x49, 0x64, 0x12, 0x36, 0x0a, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x65, 0x74,
	0x18, 0x02, 0x20, 0x01, 0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x6c,
	0x53, 0x65, 0x74, 0x52, 0x07, 0x63, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x12, 0x3b, 0x0a, 0x0b,
	0x75, 0x70, 0x64, 0x61, 0x74, 0x65, 0x5f, 0x6d, 0x61, 0x73, 0x6b, 0x18, 0x03, 0x20, 0x01, 0x28,
	0x0b, 0x32, 0x1a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f,
	0x62, 0x75, 0x66, 0x2e, 0x46, 0x69, 0x65, 0x6c, 0x64, 0x4d, 0x61, 0x73, 0x6b, 0x52, 0x0a, 0x75,
	0x70, 0x64, 0x61, 0x74, 0x65, 0x4d, 0x61, 0x73, 0x6b, 0x22, 0x36, 0x0a, 0x14, 0x44, 0x65, 0x6c,
	0x65, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73,
	0x74, 0x12, 0x1e, 0x0a, 0x0b, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64,
	0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x49,
	0x64, 0x22, 0x33, 0x0a, 0x11, 0x47, 0x65, 0x74, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x52,
	0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x12, 0x1e, 0x0a, 0x0b, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73,
	0x65, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01, 0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x63, 0x61, 0x6c,
	0x6c, 0x53, 0x65, 0x74, 0x49, 0x64, 0x22, 0xcd, 0x01, 0x0a, 0x15, 0x53, 0x74, 0x72, 0x65, 0x61,
	0x6d, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x12, 0x1d, 0x0a, 0x0a, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x5f, 0x69, 0x64, 0x18, 0x01,
	0x20, 0x01, 0x28, 0x09, 0x52, 0x09, 0x70, 0x72, 0x6f, 0x6a, 0x65, 0x63, 0x74, 0x49, 0x64, 0x12,
	0x24, 0x0a, 0x0e, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69,
	0x64, 0x18, 0x02, 0x20, 0x01, 0x28, 0x09, 0x52, 0x0c, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x53, 0x65, 0x74, 0x49, 0x64, 0x12, 0x20, 0x0a, 0x0c, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x65,
	0x74, 0x5f, 0x69, 0x64, 0x73, 0x18, 0x03, 0x20, 0x03, 0x28, 0x09, 0x52, 0x0a, 0x63, 0x61, 0x6c,
	0x6c, 0x53, 0x65, 0x74, 0x49, 0x64, 0x73, 0x12, 0x25, 0x0a, 0x0e, 0x72, 0x65, 0x66, 0x65, 0x72,
	0x65, 0x6e, 0x63, 0x65, 0x5f, 0x6e, 0x61, 0x6d, 0x65, 0x18, 0x04, 0x20, 0x01, 0x28, 0x09, 0x52,
	0x0d, 0x72, 0x65, 0x66, 0x65, 0x72, 0x65, 0x6e, 0x63, 0x65, 0x4e, 0x61, 0x6d, 0x65, 0x12, 0x14,
	0x0a, 0x05, 0x73, 0x74, 0x61, 0x72, 0x74, 0x18, 0x05, 0x20, 0x01, 0x28, 0x03, 0x52, 0x05, 0x73,
	0x74, 0x61, 0x72, 0x74, 0x12, 0x10, 0x0a, 0x03, 0x65, 0x6e, 0x64, 0x18, 0x06, 0x20, 0x01, 0x28,
	0x03, 0x52, 0x03, 0x65, 0x6e, 0x64, 0x22, 0x51, 0x0a, 0x16, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65,
	0x12, 0x37, 0x0a, 0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x18, 0x01, 0x20, 0x03,
	0x28, 0x0b, 0x32, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52,
	0x08, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x2a, 0x5d, 0x0a, 0x12, 0x49, 0x6e, 0x66,
	0x6f, 0x4d, 0x65, 0x72, 0x67, 0x65, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x12,
	0x24, 0x0a, 0x20, 0x49, 0x4e, 0x46, 0x4f, 0x5f, 0x4d, 0x45, 0x52, 0x47, 0x45, 0x5f, 0x4f, 0x50,
	0x45, 0x52, 0x41, 0x54, 0x49, 0x4f, 0x4e, 0x5f, 0x55, 0x4e, 0x53, 0x50, 0x45, 0x43, 0x49, 0x46,
	0x49, 0x45, 0x44, 0x10, 0x00, 0x12, 0x0e, 0x0a, 0x0a, 0x49, 0x47, 0x4e, 0x4f, 0x52, 0x45, 0x5f,
	0x4e, 0x45, 0x57, 0x10, 0x01, 0x12, 0x11, 0x0a, 0x0d, 0x4d, 0x4f, 0x56, 0x45, 0x5f, 0x54, 0x4f,
	0x5f, 0x43, 0x41, 0x4c, 0x4c, 0x53, 0x10, 0x02, 0x32, 0xa5, 0x01, 0x0a, 0x17, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x69, 0x6e, 0x67, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x72,
	0x76, 0x69, 0x63, 0x65, 0x12, 0x89, 0x01, 0x0a, 0x0e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72,
	0x65, 0x61, 0x6d, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1e,
	0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x73, 0x3a, 0x73, 0x74, 0x72, 0x65, 0x61, 0x6d, 0x3a, 0x01, 0x2a, 0x30, 0x01,
	0x32, 0xbd, 0x12, 0x0a, 0x10, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x72, 0x76,
	0x69, 0x63, 0x65, 0x56, 0x31, 0x12, 0x7a, 0x0a, 0x0e, 0x49, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65,
	0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x49, 0x6d, 0x70,
	0x6f, 0x72, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75, 0x65,
	0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67,
	0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67, 0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f,
	0x6e, 0x22, 0x1e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x2f, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x3a, 0x69, 0x6d, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01,
	0x2a, 0x12, 0x85, 0x01, 0x0a, 0x10, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e,
	0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61,
	0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x53, 0x65, 0x74, 0x22, 0x24, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1e, 0x22, 0x0f, 0x2f, 0x76, 0x31,
	0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x65, 0x74, 0x73, 0x3a, 0x0b, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x12, 0x92, 0x01, 0x0a, 0x10, 0x45, 0x78,
	0x70, 0x6f, 0x72, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x12, 0x2b,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x45, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1d, 0x2e, 0x67, 0x6f,
	0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x6c, 0x6f, 0x6e, 0x67, 0x72, 0x75, 0x6e, 0x6e, 0x69, 0x6e, 0x67,
	0x2e, 0x4f, 0x70, 0x65, 0x72, 0x61, 0x74, 0x69, 0x6f, 0x6e, 0x22, 0x32, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x2c, 0x22, 0x27, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x65, 0x78, 0x70, 0x6f, 0x72, 0x74, 0x3a, 0x01, 0x2a, 0x12, 0x83,
	0x01, 0x0a, 0x0d, 0x47, 0x65, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74,
	0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x22, 0x28, 0x82, 0xd3, 0xe4, 0x93,
	0x02, 0x22, 0x12, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73,
	0x65, 0x74, 0x73, 0x2f, 0x7b, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74,
	0x5f, 0x69, 0x64, 0x7d, 0x12, 0x93, 0x01, 0x0a, 0x11, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x73, 0x12, 0x2c, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x73, 0x52,
	0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73, 0x65, 0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x22,
	0x16, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x65, 0x74, 0x73,
	0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01, 0x2a, 0x12, 0x81, 0x01, 0x0a, 0x10, 0x44,
	0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x12,
	0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45,
	0x6d, 0x70, 0x74, 0x79, 0x22, 0x28, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x22, 0x2a, 0x20, 0x2f, 0x76,
	0x31, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x96,
	0x01, 0x0a, 0x10, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x53, 0x65, 0x74, 0x12, 0x2b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e,
	0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74,
	0x1a, 0x1e, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69,
	0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x53, 0x65, 0x74,
	0x22, 0x35, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x2f, 0x32, 0x20, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x76, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x0b, 0x76, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x5f, 0x73, 0x65, 0x74, 0x12, 0x87, 0x01, 0x0a, 0x0e, 0x53, 0x65, 0x61, 0x72,
	0x63, 0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x29, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65,
	0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70, 0x6f, 0x6e, 0x73,
	0x65, 0x22, 0x1e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x22, 0x13, 0x2f, 0x76, 0x31, 0x2f, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x3a, 0x01,
	0x2a, 0x12, 0x75, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61,
	0x6e, 0x74, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f,
	0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67,
	0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76,
	0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x22, 0x1d, 0x82, 0xd3, 0xe4, 0x93, 0x02,
	0x17, 0x22, 0x0c, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x3a,
	0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x82, 0x01, 0x0a, 0x0d, 0x55, 0x70, 0x64,
	0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e,
	0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x52, 0x65, 0x71,
	0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x22, 0x2a, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x24, 0x32, 0x19, 0x2f, 0x76, 0x31, 0x2f, 0x76,
	0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x07, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x74, 0x0a,
	0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x12, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79,
	0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x2a, 0x19, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x5f,
	0x69, 0x64, 0x7d, 0x12, 0x73, 0x0a, 0x0a, 0x47, 0x65, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d,
	0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65, 0x74, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x56, 0x61,
	0x72, 0x69, 0x61, 0x6e, 0x74, 0x22, 0x21, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1b, 0x12, 0x19, 0x2f,
	0x76, 0x31, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x2f, 0x7b, 0x76, 0x61, 0x72,
	0x69, 0x61, 0x6e, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x70, 0x0a, 0x0d, 0x4d, 0x65, 0x72, 0x67,
	0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67,
	0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x4d,
	0x65, 0x72, 0x67, 0x65, 0x56, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74, 0x73, 0x52, 0x65, 0x71, 0x75,
	0x65, 0x73, 0x74, 0x1a, 0x16, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f,
	0x74, 0x6f, 0x62, 0x75, 0x66, 0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x1d, 0x82, 0xd3, 0xe4,
	0x93, 0x02, 0x17, 0x22, 0x12, 0x2f, 0x76, 0x31, 0x2f, 0x76, 0x61, 0x72, 0x69, 0x61, 0x6e, 0x74,
	0x73, 0x3a, 0x6d, 0x65, 0x72, 0x67, 0x65, 0x3a, 0x01, 0x2a, 0x12, 0x87, 0x01, 0x0a, 0x0e, 0x53,
	0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x73, 0x12, 0x29, 0x2e,
	0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e,
	0x76, 0x31, 0x2e, 0x53, 0x65, 0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74,
	0x73, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x2a, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x53, 0x65,
	0x61, 0x72, 0x63, 0x68, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x73, 0x52, 0x65, 0x73, 0x70,
	0x6f, 0x6e, 0x73, 0x65, 0x22, 0x1e, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x18, 0x22, 0x13, 0x2f, 0x76,
	0x31, 0x2f, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x73, 0x65, 0x61, 0x72, 0x63,
	0x68, 0x3a, 0x01, 0x2a, 0x12, 0x76, 0x0a, 0x0d, 0x43, 0x72, 0x65, 0x61, 0x74, 0x65, 0x43, 0x61,
	0x6c, 0x6c, 0x53, 0x65, 0x74, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x72, 0x65, 0x61, 0x74,
	0x65, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x22, 0x1e, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x18, 0x22, 0x0c, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x65,
	0x74, 0x73, 0x3a, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x12, 0x84, 0x01, 0x0a,
	0x0d, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x12, 0x28,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73,
	0x2e, 0x76, 0x31, 0x2e, 0x55, 0x70, 0x64, 0x61, 0x74, 0x65, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65,
	0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61,
	0x6c, 0x6c, 0x53, 0x65, 0x74, 0x22, 0x2c, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x26, 0x32, 0x1a, 0x2f,
	0x76, 0x31, 0x2f, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x61, 0x6c,
	0x6c, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x3a, 0x08, 0x63, 0x61, 0x6c, 0x6c, 0x5f,
	0x73, 0x65, 0x74, 0x12, 0x75, 0x0a, 0x0d, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65, 0x43, 0x61, 0x6c,
	0x6c, 0x53, 0x65, 0x74, 0x12, 0x28, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65,
	0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x44, 0x65, 0x6c, 0x65, 0x74, 0x65,
	0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a, 0x16,
	0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x62, 0x75, 0x66,
	0x2e, 0x45, 0x6d, 0x70, 0x74, 0x79, 0x22, 0x22, 0x82, 0xd3, 0xe4, 0x93, 0x02, 0x1c, 0x2a, 0x1a,
	0x2f, 0x76, 0x31, 0x2f, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x65, 0x74, 0x73, 0x2f, 0x7b, 0x63, 0x61,
	0x6c, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d, 0x12, 0x74, 0x0a, 0x0a, 0x47, 0x65,
	0x74, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x12, 0x25, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c,
	0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x2e, 0x47, 0x65,
	0x74, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x52, 0x65, 0x71, 0x75, 0x65, 0x73, 0x74, 0x1a,
	0x1b, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63,
	0x73, 0x2e, 0x76, 0x31, 0x2e, 0x43, 0x61, 0x6c, 0x6c, 0x53, 0x65, 0x74, 0x22, 0x22, 0x82, 0xd3,
	0xe4, 0x93, 0x02, 0x1c, 0x12, 0x1a, 0x2f, 0x76, 0x31, 0x2f, 0x63, 0x61, 0x6c, 0x6c, 0x73, 0x65,
	0x74, 0x73, 0x2f, 0x7b, 0x63, 0x61, 0x6c, 0x6c, 0x5f, 0x73, 0x65, 0x74, 0x5f, 0x69, 0x64, 0x7d,
	0x42, 0x68, 0x0a, 0x16, 0x63, 0x6f, 0x6d, 0x2e, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x2e, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2e, 0x76, 0x31, 0x42, 0x0d, 0x56, 0x61, 0x72, 0x69,
	0x61, 0x6e, 0x74, 0x73, 0x50, 0x72, 0x6f, 0x74, 0x6f, 0x50, 0x01, 0x5a, 0x3a, 0x67, 0x6f, 0x6f,
	0x67, 0x6c, 0x65, 0x2e, 0x67, 0x6f, 0x6c, 0x61, 0x6e, 0x67, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x67,
	0x65, 0x6e, 0x70, 0x72, 0x6f, 0x74, 0x6f, 0x2f, 0x67, 0x6f, 0x6f, 0x67, 0x6c, 0x65, 0x61, 0x70,
	0x69, 0x73, 0x2f, 0x67, 0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0x2f, 0x76, 0x31, 0x3b, 0x67,
	0x65, 0x6e, 0x6f, 0x6d, 0x69, 0x63, 0x73, 0xf8, 0x01, 0x01, 0x62, 0x06, 0x70, 0x72, 0x6f, 0x74,
	0x6f, 0x33,
}

var (
	file_google_genomics_v1_variants_proto_rawDescOnce sync.Once
	file_google_genomics_v1_variants_proto_rawDescData = file_google_genomics_v1_variants_proto_rawDesc
)

func file_google_genomics_v1_variants_proto_rawDescGZIP() []byte {
	file_google_genomics_v1_variants_proto_rawDescOnce.Do(func() {
		file_google_genomics_v1_variants_proto_rawDescData = protoimpl.X.CompressGZIP(file_google_genomics_v1_variants_proto_rawDescData)
	})
	return file_google_genomics_v1_variants_proto_rawDescData
}

var file_google_genomics_v1_variants_proto_enumTypes = make([]protoimpl.EnumInfo, 4)
var file_google_genomics_v1_variants_proto_msgTypes = make([]protoimpl.MessageInfo, 36)
var file_google_genomics_v1_variants_proto_goTypes = []interface{}{
	(InfoMergeOperation)(0),             // 0: google.genomics.v1.InfoMergeOperation
	(VariantSetMetadata_Type)(0),        // 1: google.genomics.v1.VariantSetMetadata.Type
	(ImportVariantsRequest_Format)(0),   // 2: google.genomics.v1.ImportVariantsRequest.Format
	(ExportVariantSetRequest_Format)(0), // 3: google.genomics.v1.ExportVariantSetRequest.Format
	(*VariantSetMetadata)(nil),          // 4: google.genomics.v1.VariantSetMetadata
	(*VariantSet)(nil),                  // 5: google.genomics.v1.VariantSet
	(*Variant)(nil),                     // 6: google.genomics.v1.Variant
	(*VariantCall)(nil),                 // 7: google.genomics.v1.VariantCall
	(*CallSet)(nil),                     // 8: google.genomics.v1.CallSet
	(*ReferenceBound)(nil),              // 9: google.genomics.v1.ReferenceBound
	(*ImportVariantsRequest)(nil),       // 10: google.genomics.v1.ImportVariantsRequest
	(*ImportVariantsResponse)(nil),      // 11: google.genomics.v1.ImportVariantsResponse
	(*CreateVariantSetRequest)(nil),     // 12: google.genomics.v1.CreateVariantSetRequest
	(*ExportVariantSetRequest)(nil),     // 13: google.genomics.v1.ExportVariantSetRequest
	(*GetVariantSetRequest)(nil),        // 14: google.genomics.v1.GetVariantSetRequest
	(*SearchVariantSetsRequest)(nil),    // 15: google.genomics.v1.SearchVariantSetsRequest
	(*SearchVariantSetsResponse)(nil),   // 16: google.genomics.v1.SearchVariantSetsResponse
	(*DeleteVariantSetRequest)(nil),     // 17: google.genomics.v1.DeleteVariantSetRequest
	(*UpdateVariantSetRequest)(nil),     // 18: google.genomics.v1.UpdateVariantSetRequest
	(*SearchVariantsRequest)(nil),       // 19: google.genomics.v1.SearchVariantsRequest
	(*SearchVariantsResponse)(nil),      // 20: google.genomics.v1.SearchVariantsResponse
	(*CreateVariantRequest)(nil),        // 21: google.genomics.v1.CreateVariantRequest
	(*UpdateVariantRequest)(nil),        // 22: google.genomics.v1.UpdateVariantRequest
	(*DeleteVariantRequest)(nil),        // 23: google.genomics.v1.DeleteVariantRequest
	(*GetVariantRequest)(nil),           // 24: google.genomics.v1.GetVariantRequest
	(*MergeVariantsRequest)(nil),        // 25: google.genomics.v1.MergeVariantsRequest
	(*SearchCallSetsRequest)(nil),       // 26: google.genomics.v1.SearchCallSetsRequest
	(*SearchCallSetsResponse)(nil),      // 27: google.genomics.v1.SearchCallSetsResponse
	(*CreateCallSetRequest)(nil),        // 28: google.genomics.v1.CreateCallSetRequest
	(*UpdateCallSetRequest)(nil),        // 29: google.genomics.v1.UpdateCallSetRequest
	(*DeleteCallSetRequest)(nil),        // 30: google.genomics.v1.DeleteCallSetRequest
	(*GetCallSetRequest)(nil),           // 31: google.genomics.v1.GetCallSetRequest
	(*StreamVariantsRequest)(nil),       // 32: google.genomics.v1.StreamVariantsRequest
	(*StreamVariantsResponse)(nil),      // 33: google.genomics.v1.StreamVariantsResponse
	nil,                                 // 34: google.genomics.v1.VariantSetMetadata.InfoEntry
	nil,                                 // 35: google.genomics.v1.Variant.InfoEntry
	nil,                                 // 36: google.genomics.v1.VariantCall.InfoEntry
	nil,                                 // 37: google.genomics.v1.CallSet.InfoEntry
	nil,                                 // 38: google.genomics.v1.ImportVariantsRequest.InfoMergeConfigEntry
	nil,                                 // 39: google.genomics.v1.MergeVariantsRequest.InfoMergeConfigEntry
	(*fieldmaskpb.FieldMask)(nil),       // 40: google.protobuf.FieldMask
	(*structpb.ListValue)(nil),          // 41: google.protobuf.ListValue
	(*longrunning.Operation)(nil),       // 42: google.longrunning.Operation
	(*emptypb.Empty)(nil),               // 43: google.protobuf.Empty
}
var file_google_genomics_v1_variants_proto_depIdxs = []int32{
	1,  // 0: google.genomics.v1.VariantSetMetadata.type:type_name -> google.genomics.v1.VariantSetMetadata.Type
	34, // 1: google.genomics.v1.VariantSetMetadata.info:type_name -> google.genomics.v1.VariantSetMetadata.InfoEntry
	9,  // 2: google.genomics.v1.VariantSet.reference_bounds:type_name -> google.genomics.v1.ReferenceBound
	4,  // 3: google.genomics.v1.VariantSet.metadata:type_name -> google.genomics.v1.VariantSetMetadata
	35, // 4: google.genomics.v1.Variant.info:type_name -> google.genomics.v1.Variant.InfoEntry
	7,  // 5: google.genomics.v1.Variant.calls:type_name -> google.genomics.v1.VariantCall
	36, // 6: google.genomics.v1.VariantCall.info:type_name -> google.genomics.v1.VariantCall.InfoEntry
	37, // 7: google.genomics.v1.CallSet.info:type_name -> google.genomics.v1.CallSet.InfoEntry
	2,  // 8: google.genomics.v1.ImportVariantsRequest.format:type_name -> google.genomics.v1.ImportVariantsRequest.Format
	38, // 9: google.genomics.v1.ImportVariantsRequest.info_merge_config:type_name -> google.genomics.v1.ImportVariantsRequest.InfoMergeConfigEntry
	5,  // 10: google.genomics.v1.CreateVariantSetRequest.variant_set:type_name -> google.genomics.v1.VariantSet
	3,  // 11: google.genomics.v1.ExportVariantSetRequest.format:type_name -> google.genomics.v1.ExportVariantSetRequest.Format
	5,  // 12: google.genomics.v1.SearchVariantSetsResponse.variant_sets:type_name -> google.genomics.v1.VariantSet
	5,  // 13: google.genomics.v1.UpdateVariantSetRequest.variant_set:type_name -> google.genomics.v1.VariantSet
	40, // 14: google.genomics.v1.UpdateVariantSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	6,  // 15: google.genomics.v1.SearchVariantsResponse.variants:type_name -> google.genomics.v1.Variant
	6,  // 16: google.genomics.v1.CreateVariantRequest.variant:type_name -> google.genomics.v1.Variant
	6,  // 17: google.genomics.v1.UpdateVariantRequest.variant:type_name -> google.genomics.v1.Variant
	40, // 18: google.genomics.v1.UpdateVariantRequest.update_mask:type_name -> google.protobuf.FieldMask
	6,  // 19: google.genomics.v1.MergeVariantsRequest.variants:type_name -> google.genomics.v1.Variant
	39, // 20: google.genomics.v1.MergeVariantsRequest.info_merge_config:type_name -> google.genomics.v1.MergeVariantsRequest.InfoMergeConfigEntry
	8,  // 21: google.genomics.v1.SearchCallSetsResponse.call_sets:type_name -> google.genomics.v1.CallSet
	8,  // 22: google.genomics.v1.CreateCallSetRequest.call_set:type_name -> google.genomics.v1.CallSet
	8,  // 23: google.genomics.v1.UpdateCallSetRequest.call_set:type_name -> google.genomics.v1.CallSet
	40, // 24: google.genomics.v1.UpdateCallSetRequest.update_mask:type_name -> google.protobuf.FieldMask
	6,  // 25: google.genomics.v1.StreamVariantsResponse.variants:type_name -> google.genomics.v1.Variant
	41, // 26: google.genomics.v1.VariantSetMetadata.InfoEntry.value:type_name -> google.protobuf.ListValue
	41, // 27: google.genomics.v1.Variant.InfoEntry.value:type_name -> google.protobuf.ListValue
	41, // 28: google.genomics.v1.VariantCall.InfoEntry.value:type_name -> google.protobuf.ListValue
	41, // 29: google.genomics.v1.CallSet.InfoEntry.value:type_name -> google.protobuf.ListValue
	0,  // 30: google.genomics.v1.ImportVariantsRequest.InfoMergeConfigEntry.value:type_name -> google.genomics.v1.InfoMergeOperation
	0,  // 31: google.genomics.v1.MergeVariantsRequest.InfoMergeConfigEntry.value:type_name -> google.genomics.v1.InfoMergeOperation
	32, // 32: google.genomics.v1.StreamingVariantService.StreamVariants:input_type -> google.genomics.v1.StreamVariantsRequest
	10, // 33: google.genomics.v1.VariantServiceV1.ImportVariants:input_type -> google.genomics.v1.ImportVariantsRequest
	12, // 34: google.genomics.v1.VariantServiceV1.CreateVariantSet:input_type -> google.genomics.v1.CreateVariantSetRequest
	13, // 35: google.genomics.v1.VariantServiceV1.ExportVariantSet:input_type -> google.genomics.v1.ExportVariantSetRequest
	14, // 36: google.genomics.v1.VariantServiceV1.GetVariantSet:input_type -> google.genomics.v1.GetVariantSetRequest
	15, // 37: google.genomics.v1.VariantServiceV1.SearchVariantSets:input_type -> google.genomics.v1.SearchVariantSetsRequest
	17, // 38: google.genomics.v1.VariantServiceV1.DeleteVariantSet:input_type -> google.genomics.v1.DeleteVariantSetRequest
	18, // 39: google.genomics.v1.VariantServiceV1.UpdateVariantSet:input_type -> google.genomics.v1.UpdateVariantSetRequest
	19, // 40: google.genomics.v1.VariantServiceV1.SearchVariants:input_type -> google.genomics.v1.SearchVariantsRequest
	21, // 41: google.genomics.v1.VariantServiceV1.CreateVariant:input_type -> google.genomics.v1.CreateVariantRequest
	22, // 42: google.genomics.v1.VariantServiceV1.UpdateVariant:input_type -> google.genomics.v1.UpdateVariantRequest
	23, // 43: google.genomics.v1.VariantServiceV1.DeleteVariant:input_type -> google.genomics.v1.DeleteVariantRequest
	24, // 44: google.genomics.v1.VariantServiceV1.GetVariant:input_type -> google.genomics.v1.GetVariantRequest
	25, // 45: google.genomics.v1.VariantServiceV1.MergeVariants:input_type -> google.genomics.v1.MergeVariantsRequest
	26, // 46: google.genomics.v1.VariantServiceV1.SearchCallSets:input_type -> google.genomics.v1.SearchCallSetsRequest
	28, // 47: google.genomics.v1.VariantServiceV1.CreateCallSet:input_type -> google.genomics.v1.CreateCallSetRequest
	29, // 48: google.genomics.v1.VariantServiceV1.UpdateCallSet:input_type -> google.genomics.v1.UpdateCallSetRequest
	30, // 49: google.genomics.v1.VariantServiceV1.DeleteCallSet:input_type -> google.genomics.v1.DeleteCallSetRequest
	31, // 50: google.genomics.v1.VariantServiceV1.GetCallSet:input_type -> google.genomics.v1.GetCallSetRequest
	33, // 51: google.genomics.v1.StreamingVariantService.StreamVariants:output_type -> google.genomics.v1.StreamVariantsResponse
	42, // 52: google.genomics.v1.VariantServiceV1.ImportVariants:output_type -> google.longrunning.Operation
	5,  // 53: google.genomics.v1.VariantServiceV1.CreateVariantSet:output_type -> google.genomics.v1.VariantSet
	42, // 54: google.genomics.v1.VariantServiceV1.ExportVariantSet:output_type -> google.longrunning.Operation
	5,  // 55: google.genomics.v1.VariantServiceV1.GetVariantSet:output_type -> google.genomics.v1.VariantSet
	16, // 56: google.genomics.v1.VariantServiceV1.SearchVariantSets:output_type -> google.genomics.v1.SearchVariantSetsResponse
	43, // 57: google.genomics.v1.VariantServiceV1.DeleteVariantSet:output_type -> google.protobuf.Empty
	5,  // 58: google.genomics.v1.VariantServiceV1.UpdateVariantSet:output_type -> google.genomics.v1.VariantSet
	20, // 59: google.genomics.v1.VariantServiceV1.SearchVariants:output_type -> google.genomics.v1.SearchVariantsResponse
	6,  // 60: google.genomics.v1.VariantServiceV1.CreateVariant:output_type -> google.genomics.v1.Variant
	6,  // 61: google.genomics.v1.VariantServiceV1.UpdateVariant:output_type -> google.genomics.v1.Variant
	43, // 62: google.genomics.v1.VariantServiceV1.DeleteVariant:output_type -> google.protobuf.Empty
	6,  // 63: google.genomics.v1.VariantServiceV1.GetVariant:output_type -> google.genomics.v1.Variant
	43, // 64: google.genomics.v1.VariantServiceV1.MergeVariants:output_type -> google.protobuf.Empty
	27, // 65: google.genomics.v1.VariantServiceV1.SearchCallSets:output_type -> google.genomics.v1.SearchCallSetsResponse
	8,  // 66: google.genomics.v1.VariantServiceV1.CreateCallSet:output_type -> google.genomics.v1.CallSet
	8,  // 67: google.genomics.v1.VariantServiceV1.UpdateCallSet:output_type -> google.genomics.v1.CallSet
	43, // 68: google.genomics.v1.VariantServiceV1.DeleteCallSet:output_type -> google.protobuf.Empty
	8,  // 69: google.genomics.v1.VariantServiceV1.GetCallSet:output_type -> google.genomics.v1.CallSet
	51, // [51:70] is the sub-list for method output_type
	32, // [32:51] is the sub-list for method input_type
	32, // [32:32] is the sub-list for extension type_name
	32, // [32:32] is the sub-list for extension extendee
	0,  // [0:32] is the sub-list for field type_name
}

func init() { file_google_genomics_v1_variants_proto_init() }
func file_google_genomics_v1_variants_proto_init() {
	if File_google_genomics_v1_variants_proto != nil {
		return
	}
	if !protoimpl.UnsafeEnabled {
		file_google_genomics_v1_variants_proto_msgTypes[0].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VariantSetMetadata); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[1].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VariantSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[2].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*Variant); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[3].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*VariantCall); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[4].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CallSet); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[5].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ReferenceBound); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[6].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportVariantsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[7].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ImportVariantsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[8].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateVariantSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[9].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*ExportVariantSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[10].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVariantSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[11].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchVariantSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[12].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchVariantSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[13].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteVariantSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[14].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateVariantSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[15].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchVariantsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[16].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchVariantsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[17].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateVariantRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[18].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateVariantRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[19].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteVariantRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[20].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetVariantRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[21].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*MergeVariantsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[22].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCallSetsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[23].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*SearchCallSetsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[24].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*CreateCallSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[25].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*UpdateCallSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[26].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*DeleteCallSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[27].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*GetCallSetRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[28].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamVariantsRequest); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
		file_google_genomics_v1_variants_proto_msgTypes[29].Exporter = func(v interface{}, i int) interface{} {
			switch v := v.(*StreamVariantsResponse); i {
			case 0:
				return &v.state
			case 1:
				return &v.sizeCache
			case 2:
				return &v.unknownFields
			default:
				return nil
			}
		}
	}
	type x struct{}
	out := protoimpl.TypeBuilder{
		File: protoimpl.DescBuilder{
			GoPackagePath: reflect.TypeOf(x{}).PkgPath(),
			RawDescriptor: file_google_genomics_v1_variants_proto_rawDesc,
			NumEnums:      4,
			NumMessages:   36,
			NumExtensions: 0,
			NumServices:   2,
		},
		GoTypes:           file_google_genomics_v1_variants_proto_goTypes,
		DependencyIndexes: file_google_genomics_v1_variants_proto_depIdxs,
		EnumInfos:         file_google_genomics_v1_variants_proto_enumTypes,
		MessageInfos:      file_google_genomics_v1_variants_proto_msgTypes,
	}.Build()
	File_google_genomics_v1_variants_proto = out.File
	file_google_genomics_v1_variants_proto_rawDesc = nil
	file_google_genomics_v1_variants_proto_goTypes = nil
	file_google_genomics_v1_variants_proto_depIdxs = nil
}

// Reference imports to suppress errors if they are not otherwise used.
var _ context.Context
var _ grpc.ClientConnInterface

// This is a compile-time assertion to ensure that this generated file
// is compatible with the grpc package it is being compiled against.
const _ = grpc.SupportPackageIsVersion6

// StreamingVariantServiceClient is the client API for StreamingVariantService service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type StreamingVariantServiceClient interface {
	// Returns a stream of all the variants matching the search request, ordered
	// by reference name, position, and ID.
	StreamVariants(ctx context.Context, in *StreamVariantsRequest, opts ...grpc.CallOption) (StreamingVariantService_StreamVariantsClient, error)
}

type streamingVariantServiceClient struct {
	cc grpc.ClientConnInterface
}

func NewStreamingVariantServiceClient(cc grpc.ClientConnInterface) StreamingVariantServiceClient {
	return &streamingVariantServiceClient{cc}
}

func (c *streamingVariantServiceClient) StreamVariants(ctx context.Context, in *StreamVariantsRequest, opts ...grpc.CallOption) (StreamingVariantService_StreamVariantsClient, error) {
	stream, err := c.cc.NewStream(ctx, &_StreamingVariantService_serviceDesc.Streams[0], "/google.genomics.v1.StreamingVariantService/StreamVariants", opts...)
	if err != nil {
		return nil, err
	}
	x := &streamingVariantServiceStreamVariantsClient{stream}
	if err := x.ClientStream.SendMsg(in); err != nil {
		return nil, err
	}
	if err := x.ClientStream.CloseSend(); err != nil {
		return nil, err
	}
	return x, nil
}

type StreamingVariantService_StreamVariantsClient interface {
	Recv() (*StreamVariantsResponse, error)
	grpc.ClientStream
}

type streamingVariantServiceStreamVariantsClient struct {
	grpc.ClientStream
}

func (x *streamingVariantServiceStreamVariantsClient) Recv() (*StreamVariantsResponse, error) {
	m := new(StreamVariantsResponse)
	if err := x.ClientStream.RecvMsg(m); err != nil {
		return nil, err
	}
	return m, nil
}

// StreamingVariantServiceServer is the server API for StreamingVariantService service.
type StreamingVariantServiceServer interface {
	// Returns a stream of all the variants matching the search request, ordered
	// by reference name, position, and ID.
	StreamVariants(*StreamVariantsRequest, StreamingVariantService_StreamVariantsServer) error
}

// UnimplementedStreamingVariantServiceServer can be embedded to have forward compatible implementations.
type UnimplementedStreamingVariantServiceServer struct {
}

func (*UnimplementedStreamingVariantServiceServer) StreamVariants(*StreamVariantsRequest, StreamingVariantService_StreamVariantsServer) error {
	return status.Errorf(codes.Unimplemented, "method StreamVariants not implemented")
}

func RegisterStreamingVariantServiceServer(s *grpc.Server, srv StreamingVariantServiceServer) {
	s.RegisterService(&_StreamingVariantService_serviceDesc, srv)
}

func _StreamingVariantService_StreamVariants_Handler(srv interface{}, stream grpc.ServerStream) error {
	m := new(StreamVariantsRequest)
	if err := stream.RecvMsg(m); err != nil {
		return err
	}
	return srv.(StreamingVariantServiceServer).StreamVariants(m, &streamingVariantServiceStreamVariantsServer{stream})
}

type StreamingVariantService_StreamVariantsServer interface {
	Send(*StreamVariantsResponse) error
	grpc.ServerStream
}

type streamingVariantServiceStreamVariantsServer struct {
	grpc.ServerStream
}

func (x *streamingVariantServiceStreamVariantsServer) Send(m *StreamVariantsResponse) error {
	return x.ServerStream.SendMsg(m)
}

var _StreamingVariantService_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.StreamingVariantService",
	HandlerType: (*StreamingVariantServiceServer)(nil),
	Methods:     []grpc.MethodDesc{},
	Streams: []grpc.StreamDesc{
		{
			StreamName:    "StreamVariants",
			Handler:       _StreamingVariantService_StreamVariants_Handler,
			ServerStreams: true,
		},
	},
	Metadata: "google/genomics/v1/variants.proto",
}

// VariantServiceV1Client is the client API for VariantServiceV1 service.
//
// For semantics around ctx use and closing/ending streaming RPCs, please refer to https://godoc.org/google.golang.org/grpc#ClientConn.NewStream.
type VariantServiceV1Client interface {
	// Creates variant data by asynchronously importing the provided information.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The variants for import will be merged with any existing variant that
	// matches its reference sequence, start, end, reference bases, and
	// alternative bases. If no such variant exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant, and Variant info fields are merged
	// as specified in
	// [infoMergeConfig][google.genomics.v1.ImportVariantsRequest.info_merge_config].
	// As a special case, for single-sample VCF files, QUAL and FILTER fields will
	// be moved to the call level; these are sometimes interpreted in a
	// call-specific context.
	// Imported VCF headers are appended to the metadata already in a variant set.
	ImportVariants(ctx context.Context, in *ImportVariantsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Creates a new variant set.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The provided variant set must have a valid `datasetId` set - all other
	// fields are optional. Note that the `id` field will be ignored, as this is
	// assigned by the server.
	CreateVariantSet(ctx context.Context, in *CreateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error)
	// Exports variant set data to an external destination.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	ExportVariantSet(ctx context.Context, in *ExportVariantSetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error)
	// Gets a variant set by ID.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariantSet(ctx context.Context, in *GetVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error)
	// Returns a list of all variant sets matching search criteria.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariantSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L49).
	SearchVariantSets(ctx context.Context, in *SearchVariantSetsRequest, opts ...grpc.CallOption) (*SearchVariantSetsResponse, error)
	// Deletes a variant set including all variants, call sets, and calls within.
	// This is not reversible.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariantSet(ctx context.Context, in *DeleteVariantSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Updates a variant set using patch semantics.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	UpdateVariantSet(ctx context.Context, in *UpdateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error)
	// Gets a list of variants matching the criteria.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariants](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L126).
	SearchVariants(ctx context.Context, in *SearchVariantsRequest, opts ...grpc.CallOption) (*SearchVariantsResponse, error)
	// Creates a new variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateVariant(ctx context.Context, in *CreateVariantRequest, opts ...grpc.CallOption) (*Variant, error)
	// Updates a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics. Returns the modified variant without
	// its calls.
	UpdateVariant(ctx context.Context, in *UpdateVariantRequest, opts ...grpc.CallOption) (*Variant, error)
	// Deletes a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariant(ctx context.Context, in *DeleteVariantRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a variant by ID.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariant(ctx context.Context, in *GetVariantRequest, opts ...grpc.CallOption) (*Variant, error)
	// Merges the given variants with existing variants.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Each variant will be
	// merged with an existing variant that matches its reference sequence,
	// start, end, reference bases, and alternative bases. If no such variant
	// exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant. Variant info fields are merged as
	// specified in the
	// [infoMergeConfig][google.genomics.v1.MergeVariantsRequest.info_merge_config]
	// field of the MergeVariantsRequest.
	//
	// Please exercise caution when using this method!  It is easy to introduce
	// mistakes in existing variants and difficult to back out of them.  For
	// example,
	// suppose you were trying to merge a new variant with an existing one and
	// both
	// variants contain calls that belong to callsets with the same callset ID.
	//
	//     // Existing variant - irrelevant fields trimmed for clarity
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     0,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	//     // New variant with conflicting call information
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// The resulting merged variant would overwrite the existing calls with those
	// from the new variant:
	//
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// This may be the desired outcome, but it is up to the user to determine if
	// if that is indeed the case.
	MergeVariants(ctx context.Context, in *MergeVariantsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a list of call sets matching the criteria.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchCallSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L178).
	SearchCallSets(ctx context.Context, in *SearchCallSetsRequest, opts ...grpc.CallOption) (*SearchCallSetsResponse, error)
	// Creates a new call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateCallSet(ctx context.Context, in *CreateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error)
	// Updates a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateCallSet(ctx context.Context, in *UpdateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error)
	// Deletes a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteCallSet(ctx context.Context, in *DeleteCallSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error)
	// Gets a call set by ID.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetCallSet(ctx context.Context, in *GetCallSetRequest, opts ...grpc.CallOption) (*CallSet, error)
}

type variantServiceV1Client struct {
	cc grpc.ClientConnInterface
}

func NewVariantServiceV1Client(cc grpc.ClientConnInterface) VariantServiceV1Client {
	return &variantServiceV1Client{cc}
}

func (c *variantServiceV1Client) ImportVariants(ctx context.Context, in *ImportVariantsRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/ImportVariants", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) CreateVariantSet(ctx context.Context, in *CreateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error) {
	out := new(VariantSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/CreateVariantSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) ExportVariantSet(ctx context.Context, in *ExportVariantSetRequest, opts ...grpc.CallOption) (*longrunning.Operation, error) {
	out := new(longrunning.Operation)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/ExportVariantSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) GetVariantSet(ctx context.Context, in *GetVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error) {
	out := new(VariantSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/GetVariantSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) SearchVariantSets(ctx context.Context, in *SearchVariantSetsRequest, opts ...grpc.CallOption) (*SearchVariantSetsResponse, error) {
	out := new(SearchVariantSetsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/SearchVariantSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) DeleteVariantSet(ctx context.Context, in *DeleteVariantSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/DeleteVariantSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) UpdateVariantSet(ctx context.Context, in *UpdateVariantSetRequest, opts ...grpc.CallOption) (*VariantSet, error) {
	out := new(VariantSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/UpdateVariantSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) SearchVariants(ctx context.Context, in *SearchVariantsRequest, opts ...grpc.CallOption) (*SearchVariantsResponse, error) {
	out := new(SearchVariantsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/SearchVariants", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) CreateVariant(ctx context.Context, in *CreateVariantRequest, opts ...grpc.CallOption) (*Variant, error) {
	out := new(Variant)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/CreateVariant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) UpdateVariant(ctx context.Context, in *UpdateVariantRequest, opts ...grpc.CallOption) (*Variant, error) {
	out := new(Variant)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/UpdateVariant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) DeleteVariant(ctx context.Context, in *DeleteVariantRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/DeleteVariant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) GetVariant(ctx context.Context, in *GetVariantRequest, opts ...grpc.CallOption) (*Variant, error) {
	out := new(Variant)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/GetVariant", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) MergeVariants(ctx context.Context, in *MergeVariantsRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/MergeVariants", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) SearchCallSets(ctx context.Context, in *SearchCallSetsRequest, opts ...grpc.CallOption) (*SearchCallSetsResponse, error) {
	out := new(SearchCallSetsResponse)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/SearchCallSets", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) CreateCallSet(ctx context.Context, in *CreateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error) {
	out := new(CallSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/CreateCallSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) UpdateCallSet(ctx context.Context, in *UpdateCallSetRequest, opts ...grpc.CallOption) (*CallSet, error) {
	out := new(CallSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/UpdateCallSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) DeleteCallSet(ctx context.Context, in *DeleteCallSetRequest, opts ...grpc.CallOption) (*emptypb.Empty, error) {
	out := new(emptypb.Empty)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/DeleteCallSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

func (c *variantServiceV1Client) GetCallSet(ctx context.Context, in *GetCallSetRequest, opts ...grpc.CallOption) (*CallSet, error) {
	out := new(CallSet)
	err := c.cc.Invoke(ctx, "/google.genomics.v1.VariantServiceV1/GetCallSet", in, out, opts...)
	if err != nil {
		return nil, err
	}
	return out, nil
}

// VariantServiceV1Server is the server API for VariantServiceV1 service.
type VariantServiceV1Server interface {
	// Creates variant data by asynchronously importing the provided information.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The variants for import will be merged with any existing variant that
	// matches its reference sequence, start, end, reference bases, and
	// alternative bases. If no such variant exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant, and Variant info fields are merged
	// as specified in
	// [infoMergeConfig][google.genomics.v1.ImportVariantsRequest.info_merge_config].
	// As a special case, for single-sample VCF files, QUAL and FILTER fields will
	// be moved to the call level; these are sometimes interpreted in a
	// call-specific context.
	// Imported VCF headers are appended to the metadata already in a variant set.
	ImportVariants(context.Context, *ImportVariantsRequest) (*longrunning.Operation, error)
	// Creates a new variant set.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// The provided variant set must have a valid `datasetId` set - all other
	// fields are optional. Note that the `id` field will be ignored, as this is
	// assigned by the server.
	CreateVariantSet(context.Context, *CreateVariantSetRequest) (*VariantSet, error)
	// Exports variant set data to an external destination.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	ExportVariantSet(context.Context, *ExportVariantSetRequest) (*longrunning.Operation, error)
	// Gets a variant set by ID.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariantSet(context.Context, *GetVariantSetRequest) (*VariantSet, error)
	// Returns a list of all variant sets matching search criteria.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariantSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L49).
	SearchVariantSets(context.Context, *SearchVariantSetsRequest) (*SearchVariantSetsResponse, error)
	// Deletes a variant set including all variants, call sets, and calls within.
	// This is not reversible.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariantSet(context.Context, *DeleteVariantSetRequest) (*emptypb.Empty, error)
	// Updates a variant set using patch semantics.
	//
	// For the definitions of variant sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	UpdateVariantSet(context.Context, *UpdateVariantSetRequest) (*VariantSet, error)
	// Gets a list of variants matching the criteria.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchVariants](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L126).
	SearchVariants(context.Context, *SearchVariantsRequest) (*SearchVariantsResponse, error)
	// Creates a new variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateVariant(context.Context, *CreateVariantRequest) (*Variant, error)
	// Updates a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics. Returns the modified variant without
	// its calls.
	UpdateVariant(context.Context, *UpdateVariantRequest) (*Variant, error)
	// Deletes a variant.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteVariant(context.Context, *DeleteVariantRequest) (*emptypb.Empty, error)
	// Gets a variant by ID.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetVariant(context.Context, *GetVariantRequest) (*Variant, error)
	// Merges the given variants with existing variants.
	//
	// For the definitions of variants and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Each variant will be
	// merged with an existing variant that matches its reference sequence,
	// start, end, reference bases, and alternative bases. If no such variant
	// exists, a new one will be created.
	//
	// When variants are merged, the call information from the new variant
	// is added to the existing variant. Variant info fields are merged as
	// specified in the
	// [infoMergeConfig][google.genomics.v1.MergeVariantsRequest.info_merge_config]
	// field of the MergeVariantsRequest.
	//
	// Please exercise caution when using this method!  It is easy to introduce
	// mistakes in existing variants and difficult to back out of them.  For
	// example,
	// suppose you were trying to merge a new variant with an existing one and
	// both
	// variants contain calls that belong to callsets with the same callset ID.
	//
	//     // Existing variant - irrelevant fields trimmed for clarity
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     0,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	//     // New variant with conflicting call information
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// The resulting merged variant would overwrite the existing calls with those
	// from the new variant:
	//
	//     {
	//         "variantSetId": "10473108253681171589",
	//         "referenceName": "1",
	//         "start": "10582",
	//         "referenceBases": "G",
	//         "alternateBases": [
	//             "A"
	//         ],
	//         "calls": [
	//             {
	//                 "callSetId": "10473108253681171589-0",
	//                 "callSetName": "CALLSET0",
	//                 "genotype": [
	//                     1,
	//                     1
	//                 ],
	//             }
	//         ]
	//     }
	//
	// This may be the desired outcome, but it is up to the user to determine if
	// if that is indeed the case.
	MergeVariants(context.Context, *MergeVariantsRequest) (*emptypb.Empty, error)
	// Gets a list of call sets matching the criteria.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// Implements
	// [GlobalAllianceApi.searchCallSets](https://github.com/ga4gh/schemas/blob/v0.5.1/src/main/resources/avro/variantmethods.avdl#L178).
	SearchCallSets(context.Context, *SearchCallSetsRequest) (*SearchCallSetsResponse, error)
	// Creates a new call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	CreateCallSet(context.Context, *CreateCallSetRequest) (*CallSet, error)
	// Updates a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	//
	// This method supports patch semantics.
	UpdateCallSet(context.Context, *UpdateCallSetRequest) (*CallSet, error)
	// Deletes a call set.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	DeleteCallSet(context.Context, *DeleteCallSetRequest) (*emptypb.Empty, error)
	// Gets a call set by ID.
	//
	// For the definitions of call sets and other genomics resources, see
	// [Fundamentals of Google
	// Genomics](https://cloud.google.com/genomics/fundamentals-of-google-genomics)
	GetCallSet(context.Context, *GetCallSetRequest) (*CallSet, error)
}

// UnimplementedVariantServiceV1Server can be embedded to have forward compatible implementations.
type UnimplementedVariantServiceV1Server struct {
}

func (*UnimplementedVariantServiceV1Server) ImportVariants(context.Context, *ImportVariantsRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ImportVariants not implemented")
}
func (*UnimplementedVariantServiceV1Server) CreateVariantSet(context.Context, *CreateVariantSetRequest) (*VariantSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVariantSet not implemented")
}
func (*UnimplementedVariantServiceV1Server) ExportVariantSet(context.Context, *ExportVariantSetRequest) (*longrunning.Operation, error) {
	return nil, status.Errorf(codes.Unimplemented, "method ExportVariantSet not implemented")
}
func (*UnimplementedVariantServiceV1Server) GetVariantSet(context.Context, *GetVariantSetRequest) (*VariantSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVariantSet not implemented")
}
func (*UnimplementedVariantServiceV1Server) SearchVariantSets(context.Context, *SearchVariantSetsRequest) (*SearchVariantSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchVariantSets not implemented")
}
func (*UnimplementedVariantServiceV1Server) DeleteVariantSet(context.Context, *DeleteVariantSetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVariantSet not implemented")
}
func (*UnimplementedVariantServiceV1Server) UpdateVariantSet(context.Context, *UpdateVariantSetRequest) (*VariantSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVariantSet not implemented")
}
func (*UnimplementedVariantServiceV1Server) SearchVariants(context.Context, *SearchVariantsRequest) (*SearchVariantsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchVariants not implemented")
}
func (*UnimplementedVariantServiceV1Server) CreateVariant(context.Context, *CreateVariantRequest) (*Variant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateVariant not implemented")
}
func (*UnimplementedVariantServiceV1Server) UpdateVariant(context.Context, *UpdateVariantRequest) (*Variant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateVariant not implemented")
}
func (*UnimplementedVariantServiceV1Server) DeleteVariant(context.Context, *DeleteVariantRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteVariant not implemented")
}
func (*UnimplementedVariantServiceV1Server) GetVariant(context.Context, *GetVariantRequest) (*Variant, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetVariant not implemented")
}
func (*UnimplementedVariantServiceV1Server) MergeVariants(context.Context, *MergeVariantsRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method MergeVariants not implemented")
}
func (*UnimplementedVariantServiceV1Server) SearchCallSets(context.Context, *SearchCallSetsRequest) (*SearchCallSetsResponse, error) {
	return nil, status.Errorf(codes.Unimplemented, "method SearchCallSets not implemented")
}
func (*UnimplementedVariantServiceV1Server) CreateCallSet(context.Context, *CreateCallSetRequest) (*CallSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method CreateCallSet not implemented")
}
func (*UnimplementedVariantServiceV1Server) UpdateCallSet(context.Context, *UpdateCallSetRequest) (*CallSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method UpdateCallSet not implemented")
}
func (*UnimplementedVariantServiceV1Server) DeleteCallSet(context.Context, *DeleteCallSetRequest) (*emptypb.Empty, error) {
	return nil, status.Errorf(codes.Unimplemented, "method DeleteCallSet not implemented")
}
func (*UnimplementedVariantServiceV1Server) GetCallSet(context.Context, *GetCallSetRequest) (*CallSet, error) {
	return nil, status.Errorf(codes.Unimplemented, "method GetCallSet not implemented")
}

func RegisterVariantServiceV1Server(s *grpc.Server, srv VariantServiceV1Server) {
	s.RegisterService(&_VariantServiceV1_serviceDesc, srv)
}

func _VariantServiceV1_ImportVariants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ImportVariantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).ImportVariants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/ImportVariants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).ImportVariants(ctx, req.(*ImportVariantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_CreateVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).CreateVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/CreateVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).CreateVariantSet(ctx, req.(*CreateVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_ExportVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(ExportVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).ExportVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/ExportVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).ExportVariantSet(ctx, req.(*ExportVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_GetVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).GetVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/GetVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).GetVariantSet(ctx, req.(*GetVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_SearchVariantSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchVariantSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).SearchVariantSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/SearchVariantSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).SearchVariantSets(ctx, req.(*SearchVariantSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_DeleteVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).DeleteVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/DeleteVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).DeleteVariantSet(ctx, req.(*DeleteVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_UpdateVariantSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVariantSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).UpdateVariantSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/UpdateVariantSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).UpdateVariantSet(ctx, req.(*UpdateVariantSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_SearchVariants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchVariantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).SearchVariants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/SearchVariants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).SearchVariants(ctx, req.(*SearchVariantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_CreateVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).CreateVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/CreateVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).CreateVariant(ctx, req.(*CreateVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_UpdateVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).UpdateVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/UpdateVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).UpdateVariant(ctx, req.(*UpdateVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_DeleteVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).DeleteVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/DeleteVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).DeleteVariant(ctx, req.(*DeleteVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_GetVariant_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetVariantRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).GetVariant(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/GetVariant",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).GetVariant(ctx, req.(*GetVariantRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_MergeVariants_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(MergeVariantsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).MergeVariants(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/MergeVariants",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).MergeVariants(ctx, req.(*MergeVariantsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_SearchCallSets_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(SearchCallSetsRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).SearchCallSets(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/SearchCallSets",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).SearchCallSets(ctx, req.(*SearchCallSetsRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_CreateCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(CreateCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).CreateCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/CreateCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).CreateCallSet(ctx, req.(*CreateCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_UpdateCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(UpdateCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).UpdateCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/UpdateCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).UpdateCallSet(ctx, req.(*UpdateCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_DeleteCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(DeleteCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).DeleteCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/DeleteCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).DeleteCallSet(ctx, req.(*DeleteCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

func _VariantServiceV1_GetCallSet_Handler(srv interface{}, ctx context.Context, dec func(interface{}) error, interceptor grpc.UnaryServerInterceptor) (interface{}, error) {
	in := new(GetCallSetRequest)
	if err := dec(in); err != nil {
		return nil, err
	}
	if interceptor == nil {
		return srv.(VariantServiceV1Server).GetCallSet(ctx, in)
	}
	info := &grpc.UnaryServerInfo{
		Server:     srv,
		FullMethod: "/google.genomics.v1.VariantServiceV1/GetCallSet",
	}
	handler := func(ctx context.Context, req interface{}) (interface{}, error) {
		return srv.(VariantServiceV1Server).GetCallSet(ctx, req.(*GetCallSetRequest))
	}
	return interceptor(ctx, in, info, handler)
}

var _VariantServiceV1_serviceDesc = grpc.ServiceDesc{
	ServiceName: "google.genomics.v1.VariantServiceV1",
	HandlerType: (*VariantServiceV1Server)(nil),
	Methods: []grpc.MethodDesc{
		{
			MethodName: "ImportVariants",
			Handler:    _VariantServiceV1_ImportVariants_Handler,
		},
		{
			MethodName: "CreateVariantSet",
			Handler:    _VariantServiceV1_CreateVariantSet_Handler,
		},
		{
			MethodName: "ExportVariantSet",
			Handler:    _VariantServiceV1_ExportVariantSet_Handler,
		},
		{
			MethodName: "GetVariantSet",
			Handler:    _VariantServiceV1_GetVariantSet_Handler,
		},
		{
			MethodName: "SearchVariantSets",
			Handler:    _VariantServiceV1_SearchVariantSets_Handler,
		},
		{
			MethodName: "DeleteVariantSet",
			Handler:    _VariantServiceV1_DeleteVariantSet_Handler,
		},
		{
			MethodName: "UpdateVariantSet",
			Handler:    _VariantServiceV1_UpdateVariantSet_Handler,
		},
		{
			MethodName: "SearchVariants",
			Handler:    _VariantServiceV1_SearchVariants_Handler,
		},
		{
			MethodName: "CreateVariant",
			Handler:    _VariantServiceV1_CreateVariant_Handler,
		},
		{
			MethodName: "UpdateVariant",
			Handler:    _VariantServiceV1_UpdateVariant_Handler,
		},
		{
			MethodName: "DeleteVariant",
			Handler:    _VariantServiceV1_DeleteVariant_Handler,
		},
		{
			MethodName: "GetVariant",
			Handler:    _VariantServiceV1_GetVariant_Handler,
		},
		{
			MethodName: "MergeVariants",
			Handler:    _VariantServiceV1_MergeVariants_Handler,
		},
		{
			MethodName: "SearchCallSets",
			Handler:    _VariantServiceV1_SearchCallSets_Handler,
		},
		{
			MethodName: "CreateCallSet",
			Handler:    _VariantServiceV1_CreateCallSet_Handler,
		},
		{
			MethodName: "UpdateCallSet",
			Handler:    _VariantServiceV1_UpdateCallSet_Handler,
		},
		{
			MethodName: "DeleteCallSet",
			Handler:    _VariantServiceV1_DeleteCallSet_Handler,
		},
		{
			MethodName: "GetCallSet",
			Handler:    _VariantServiceV1_GetCallSet_Handler,
		},
	},
	Streams:  []grpc.StreamDesc{},
	Metadata: "google/genomics/v1/variants.proto",
}
