// Code generated by private/model/cli/gen-api/main.go. DO NOT EDIT.

// Package redshiftserverlessiface provides an interface to enable mocking the Redshift Serverless service client
// for testing your code.
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters.
package redshiftserverlessiface

import (
	"github.com/aws/aws-sdk-go/aws"
	"github.com/aws/aws-sdk-go/aws/request"
	"github.com/aws/aws-sdk-go/service/redshiftserverless"
)

// RedshiftServerlessAPI provides an interface to enable mocking the
// redshiftserverless.RedshiftServerless service client's API operation,
// paginators, and waiters. This make unit testing your code that calls out
// to the SDK's service client's calls easier.
//
// The best way to use this interface is so the SDK's service client's calls
// can be stubbed out for unit testing your code with the SDK without needing
// to inject custom request handlers into the SDK's request pipeline.
//
//	// myFunc uses an SDK service client to make a request to
//	// Redshift Serverless.
//	func myFunc(svc redshiftserverlessiface.RedshiftServerlessAPI) bool {
//	    // Make svc.ConvertRecoveryPointToSnapshot request
//	}
//
//	func main() {
//	    sess := session.New()
//	    svc := redshiftserverless.New(sess)
//
//	    myFunc(svc)
//	}
//
// In your _test.go file:
//
//	// Define a mock struct to be used in your unit tests of myFunc.
//	type mockRedshiftServerlessClient struct {
//	    redshiftserverlessiface.RedshiftServerlessAPI
//	}
//	func (m *mockRedshiftServerlessClient) ConvertRecoveryPointToSnapshot(input *redshiftserverless.ConvertRecoveryPointToSnapshotInput) (*redshiftserverless.ConvertRecoveryPointToSnapshotOutput, error) {
//	    // mock response/functionality
//	}
//
//	func TestMyFunc(t *testing.T) {
//	    // Setup Test
//	    mockSvc := &mockRedshiftServerlessClient{}
//
//	    myfunc(mockSvc)
//
//	    // Verify myFunc's functionality
//	}
//
// It is important to note that this interface will have breaking changes
// when the service model is updated and adds new API operations, paginators,
// and waiters. Its suggested to use the pattern above for testing, or using
// tooling to generate mocks to satisfy the interfaces.
type RedshiftServerlessAPI interface {
	ConvertRecoveryPointToSnapshot(*redshiftserverless.ConvertRecoveryPointToSnapshotInput) (*redshiftserverless.ConvertRecoveryPointToSnapshotOutput, error)
	ConvertRecoveryPointToSnapshotWithContext(aws.Context, *redshiftserverless.ConvertRecoveryPointToSnapshotInput, ...request.Option) (*redshiftserverless.ConvertRecoveryPointToSnapshotOutput, error)
	ConvertRecoveryPointToSnapshotRequest(*redshiftserverless.ConvertRecoveryPointToSnapshotInput) (*request.Request, *redshiftserverless.ConvertRecoveryPointToSnapshotOutput)

	CreateEndpointAccess(*redshiftserverless.CreateEndpointAccessInput) (*redshiftserverless.CreateEndpointAccessOutput, error)
	CreateEndpointAccessWithContext(aws.Context, *redshiftserverless.CreateEndpointAccessInput, ...request.Option) (*redshiftserverless.CreateEndpointAccessOutput, error)
	CreateEndpointAccessRequest(*redshiftserverless.CreateEndpointAccessInput) (*request.Request, *redshiftserverless.CreateEndpointAccessOutput)

	CreateNamespace(*redshiftserverless.CreateNamespaceInput) (*redshiftserverless.CreateNamespaceOutput, error)
	CreateNamespaceWithContext(aws.Context, *redshiftserverless.CreateNamespaceInput, ...request.Option) (*redshiftserverless.CreateNamespaceOutput, error)
	CreateNamespaceRequest(*redshiftserverless.CreateNamespaceInput) (*request.Request, *redshiftserverless.CreateNamespaceOutput)

	CreateSnapshot(*redshiftserverless.CreateSnapshotInput) (*redshiftserverless.CreateSnapshotOutput, error)
	CreateSnapshotWithContext(aws.Context, *redshiftserverless.CreateSnapshotInput, ...request.Option) (*redshiftserverless.CreateSnapshotOutput, error)
	CreateSnapshotRequest(*redshiftserverless.CreateSnapshotInput) (*request.Request, *redshiftserverless.CreateSnapshotOutput)

	CreateUsageLimit(*redshiftserverless.CreateUsageLimitInput) (*redshiftserverless.CreateUsageLimitOutput, error)
	CreateUsageLimitWithContext(aws.Context, *redshiftserverless.CreateUsageLimitInput, ...request.Option) (*redshiftserverless.CreateUsageLimitOutput, error)
	CreateUsageLimitRequest(*redshiftserverless.CreateUsageLimitInput) (*request.Request, *redshiftserverless.CreateUsageLimitOutput)

	CreateWorkgroup(*redshiftserverless.CreateWorkgroupInput) (*redshiftserverless.CreateWorkgroupOutput, error)
	CreateWorkgroupWithContext(aws.Context, *redshiftserverless.CreateWorkgroupInput, ...request.Option) (*redshiftserverless.CreateWorkgroupOutput, error)
	CreateWorkgroupRequest(*redshiftserverless.CreateWorkgroupInput) (*request.Request, *redshiftserverless.CreateWorkgroupOutput)

	DeleteEndpointAccess(*redshiftserverless.DeleteEndpointAccessInput) (*redshiftserverless.DeleteEndpointAccessOutput, error)
	DeleteEndpointAccessWithContext(aws.Context, *redshiftserverless.DeleteEndpointAccessInput, ...request.Option) (*redshiftserverless.DeleteEndpointAccessOutput, error)
	DeleteEndpointAccessRequest(*redshiftserverless.DeleteEndpointAccessInput) (*request.Request, *redshiftserverless.DeleteEndpointAccessOutput)

	DeleteNamespace(*redshiftserverless.DeleteNamespaceInput) (*redshiftserverless.DeleteNamespaceOutput, error)
	DeleteNamespaceWithContext(aws.Context, *redshiftserverless.DeleteNamespaceInput, ...request.Option) (*redshiftserverless.DeleteNamespaceOutput, error)
	DeleteNamespaceRequest(*redshiftserverless.DeleteNamespaceInput) (*request.Request, *redshiftserverless.DeleteNamespaceOutput)

	DeleteResourcePolicy(*redshiftserverless.DeleteResourcePolicyInput) (*redshiftserverless.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyWithContext(aws.Context, *redshiftserverless.DeleteResourcePolicyInput, ...request.Option) (*redshiftserverless.DeleteResourcePolicyOutput, error)
	DeleteResourcePolicyRequest(*redshiftserverless.DeleteResourcePolicyInput) (*request.Request, *redshiftserverless.DeleteResourcePolicyOutput)

	DeleteSnapshot(*redshiftserverless.DeleteSnapshotInput) (*redshiftserverless.DeleteSnapshotOutput, error)
	DeleteSnapshotWithContext(aws.Context, *redshiftserverless.DeleteSnapshotInput, ...request.Option) (*redshiftserverless.DeleteSnapshotOutput, error)
	DeleteSnapshotRequest(*redshiftserverless.DeleteSnapshotInput) (*request.Request, *redshiftserverless.DeleteSnapshotOutput)

	DeleteUsageLimit(*redshiftserverless.DeleteUsageLimitInput) (*redshiftserverless.DeleteUsageLimitOutput, error)
	DeleteUsageLimitWithContext(aws.Context, *redshiftserverless.DeleteUsageLimitInput, ...request.Option) (*redshiftserverless.DeleteUsageLimitOutput, error)
	DeleteUsageLimitRequest(*redshiftserverless.DeleteUsageLimitInput) (*request.Request, *redshiftserverless.DeleteUsageLimitOutput)

	DeleteWorkgroup(*redshiftserverless.DeleteWorkgroupInput) (*redshiftserverless.DeleteWorkgroupOutput, error)
	DeleteWorkgroupWithContext(aws.Context, *redshiftserverless.DeleteWorkgroupInput, ...request.Option) (*redshiftserverless.DeleteWorkgroupOutput, error)
	DeleteWorkgroupRequest(*redshiftserverless.DeleteWorkgroupInput) (*request.Request, *redshiftserverless.DeleteWorkgroupOutput)

	GetCredentials(*redshiftserverless.GetCredentialsInput) (*redshiftserverless.GetCredentialsOutput, error)
	GetCredentialsWithContext(aws.Context, *redshiftserverless.GetCredentialsInput, ...request.Option) (*redshiftserverless.GetCredentialsOutput, error)
	GetCredentialsRequest(*redshiftserverless.GetCredentialsInput) (*request.Request, *redshiftserverless.GetCredentialsOutput)

	GetEndpointAccess(*redshiftserverless.GetEndpointAccessInput) (*redshiftserverless.GetEndpointAccessOutput, error)
	GetEndpointAccessWithContext(aws.Context, *redshiftserverless.GetEndpointAccessInput, ...request.Option) (*redshiftserverless.GetEndpointAccessOutput, error)
	GetEndpointAccessRequest(*redshiftserverless.GetEndpointAccessInput) (*request.Request, *redshiftserverless.GetEndpointAccessOutput)

	GetNamespace(*redshiftserverless.GetNamespaceInput) (*redshiftserverless.GetNamespaceOutput, error)
	GetNamespaceWithContext(aws.Context, *redshiftserverless.GetNamespaceInput, ...request.Option) (*redshiftserverless.GetNamespaceOutput, error)
	GetNamespaceRequest(*redshiftserverless.GetNamespaceInput) (*request.Request, *redshiftserverless.GetNamespaceOutput)

	GetRecoveryPoint(*redshiftserverless.GetRecoveryPointInput) (*redshiftserverless.GetRecoveryPointOutput, error)
	GetRecoveryPointWithContext(aws.Context, *redshiftserverless.GetRecoveryPointInput, ...request.Option) (*redshiftserverless.GetRecoveryPointOutput, error)
	GetRecoveryPointRequest(*redshiftserverless.GetRecoveryPointInput) (*request.Request, *redshiftserverless.GetRecoveryPointOutput)

	GetResourcePolicy(*redshiftserverless.GetResourcePolicyInput) (*redshiftserverless.GetResourcePolicyOutput, error)
	GetResourcePolicyWithContext(aws.Context, *redshiftserverless.GetResourcePolicyInput, ...request.Option) (*redshiftserverless.GetResourcePolicyOutput, error)
	GetResourcePolicyRequest(*redshiftserverless.GetResourcePolicyInput) (*request.Request, *redshiftserverless.GetResourcePolicyOutput)

	GetSnapshot(*redshiftserverless.GetSnapshotInput) (*redshiftserverless.GetSnapshotOutput, error)
	GetSnapshotWithContext(aws.Context, *redshiftserverless.GetSnapshotInput, ...request.Option) (*redshiftserverless.GetSnapshotOutput, error)
	GetSnapshotRequest(*redshiftserverless.GetSnapshotInput) (*request.Request, *redshiftserverless.GetSnapshotOutput)

	GetUsageLimit(*redshiftserverless.GetUsageLimitInput) (*redshiftserverless.GetUsageLimitOutput, error)
	GetUsageLimitWithContext(aws.Context, *redshiftserverless.GetUsageLimitInput, ...request.Option) (*redshiftserverless.GetUsageLimitOutput, error)
	GetUsageLimitRequest(*redshiftserverless.GetUsageLimitInput) (*request.Request, *redshiftserverless.GetUsageLimitOutput)

	GetWorkgroup(*redshiftserverless.GetWorkgroupInput) (*redshiftserverless.GetWorkgroupOutput, error)
	GetWorkgroupWithContext(aws.Context, *redshiftserverless.GetWorkgroupInput, ...request.Option) (*redshiftserverless.GetWorkgroupOutput, error)
	GetWorkgroupRequest(*redshiftserverless.GetWorkgroupInput) (*request.Request, *redshiftserverless.GetWorkgroupOutput)

	ListEndpointAccess(*redshiftserverless.ListEndpointAccessInput) (*redshiftserverless.ListEndpointAccessOutput, error)
	ListEndpointAccessWithContext(aws.Context, *redshiftserverless.ListEndpointAccessInput, ...request.Option) (*redshiftserverless.ListEndpointAccessOutput, error)
	ListEndpointAccessRequest(*redshiftserverless.ListEndpointAccessInput) (*request.Request, *redshiftserverless.ListEndpointAccessOutput)

	ListEndpointAccessPages(*redshiftserverless.ListEndpointAccessInput, func(*redshiftserverless.ListEndpointAccessOutput, bool) bool) error
	ListEndpointAccessPagesWithContext(aws.Context, *redshiftserverless.ListEndpointAccessInput, func(*redshiftserverless.ListEndpointAccessOutput, bool) bool, ...request.Option) error

	ListNamespaces(*redshiftserverless.ListNamespacesInput) (*redshiftserverless.ListNamespacesOutput, error)
	ListNamespacesWithContext(aws.Context, *redshiftserverless.ListNamespacesInput, ...request.Option) (*redshiftserverless.ListNamespacesOutput, error)
	ListNamespacesRequest(*redshiftserverless.ListNamespacesInput) (*request.Request, *redshiftserverless.ListNamespacesOutput)

	ListNamespacesPages(*redshiftserverless.ListNamespacesInput, func(*redshiftserverless.ListNamespacesOutput, bool) bool) error
	ListNamespacesPagesWithContext(aws.Context, *redshiftserverless.ListNamespacesInput, func(*redshiftserverless.ListNamespacesOutput, bool) bool, ...request.Option) error

	ListRecoveryPoints(*redshiftserverless.ListRecoveryPointsInput) (*redshiftserverless.ListRecoveryPointsOutput, error)
	ListRecoveryPointsWithContext(aws.Context, *redshiftserverless.ListRecoveryPointsInput, ...request.Option) (*redshiftserverless.ListRecoveryPointsOutput, error)
	ListRecoveryPointsRequest(*redshiftserverless.ListRecoveryPointsInput) (*request.Request, *redshiftserverless.ListRecoveryPointsOutput)

	ListRecoveryPointsPages(*redshiftserverless.ListRecoveryPointsInput, func(*redshiftserverless.ListRecoveryPointsOutput, bool) bool) error
	ListRecoveryPointsPagesWithContext(aws.Context, *redshiftserverless.ListRecoveryPointsInput, func(*redshiftserverless.ListRecoveryPointsOutput, bool) bool, ...request.Option) error

	ListSnapshots(*redshiftserverless.ListSnapshotsInput) (*redshiftserverless.ListSnapshotsOutput, error)
	ListSnapshotsWithContext(aws.Context, *redshiftserverless.ListSnapshotsInput, ...request.Option) (*redshiftserverless.ListSnapshotsOutput, error)
	ListSnapshotsRequest(*redshiftserverless.ListSnapshotsInput) (*request.Request, *redshiftserverless.ListSnapshotsOutput)

	ListSnapshotsPages(*redshiftserverless.ListSnapshotsInput, func(*redshiftserverless.ListSnapshotsOutput, bool) bool) error
	ListSnapshotsPagesWithContext(aws.Context, *redshiftserverless.ListSnapshotsInput, func(*redshiftserverless.ListSnapshotsOutput, bool) bool, ...request.Option) error

	ListTagsForResource(*redshiftserverless.ListTagsForResourceInput) (*redshiftserverless.ListTagsForResourceOutput, error)
	ListTagsForResourceWithContext(aws.Context, *redshiftserverless.ListTagsForResourceInput, ...request.Option) (*redshiftserverless.ListTagsForResourceOutput, error)
	ListTagsForResourceRequest(*redshiftserverless.ListTagsForResourceInput) (*request.Request, *redshiftserverless.ListTagsForResourceOutput)

	ListUsageLimits(*redshiftserverless.ListUsageLimitsInput) (*redshiftserverless.ListUsageLimitsOutput, error)
	ListUsageLimitsWithContext(aws.Context, *redshiftserverless.ListUsageLimitsInput, ...request.Option) (*redshiftserverless.ListUsageLimitsOutput, error)
	ListUsageLimitsRequest(*redshiftserverless.ListUsageLimitsInput) (*request.Request, *redshiftserverless.ListUsageLimitsOutput)

	ListUsageLimitsPages(*redshiftserverless.ListUsageLimitsInput, func(*redshiftserverless.ListUsageLimitsOutput, bool) bool) error
	ListUsageLimitsPagesWithContext(aws.Context, *redshiftserverless.ListUsageLimitsInput, func(*redshiftserverless.ListUsageLimitsOutput, bool) bool, ...request.Option) error

	ListWorkgroups(*redshiftserverless.ListWorkgroupsInput) (*redshiftserverless.ListWorkgroupsOutput, error)
	ListWorkgroupsWithContext(aws.Context, *redshiftserverless.ListWorkgroupsInput, ...request.Option) (*redshiftserverless.ListWorkgroupsOutput, error)
	ListWorkgroupsRequest(*redshiftserverless.ListWorkgroupsInput) (*request.Request, *redshiftserverless.ListWorkgroupsOutput)

	ListWorkgroupsPages(*redshiftserverless.ListWorkgroupsInput, func(*redshiftserverless.ListWorkgroupsOutput, bool) bool) error
	ListWorkgroupsPagesWithContext(aws.Context, *redshiftserverless.ListWorkgroupsInput, func(*redshiftserverless.ListWorkgroupsOutput, bool) bool, ...request.Option) error

	PutResourcePolicy(*redshiftserverless.PutResourcePolicyInput) (*redshiftserverless.PutResourcePolicyOutput, error)
	PutResourcePolicyWithContext(aws.Context, *redshiftserverless.PutResourcePolicyInput, ...request.Option) (*redshiftserverless.PutResourcePolicyOutput, error)
	PutResourcePolicyRequest(*redshiftserverless.PutResourcePolicyInput) (*request.Request, *redshiftserverless.PutResourcePolicyOutput)

	RestoreFromRecoveryPoint(*redshiftserverless.RestoreFromRecoveryPointInput) (*redshiftserverless.RestoreFromRecoveryPointOutput, error)
	RestoreFromRecoveryPointWithContext(aws.Context, *redshiftserverless.RestoreFromRecoveryPointInput, ...request.Option) (*redshiftserverless.RestoreFromRecoveryPointOutput, error)
	RestoreFromRecoveryPointRequest(*redshiftserverless.RestoreFromRecoveryPointInput) (*request.Request, *redshiftserverless.RestoreFromRecoveryPointOutput)

	RestoreFromSnapshot(*redshiftserverless.RestoreFromSnapshotInput) (*redshiftserverless.RestoreFromSnapshotOutput, error)
	RestoreFromSnapshotWithContext(aws.Context, *redshiftserverless.RestoreFromSnapshotInput, ...request.Option) (*redshiftserverless.RestoreFromSnapshotOutput, error)
	RestoreFromSnapshotRequest(*redshiftserverless.RestoreFromSnapshotInput) (*request.Request, *redshiftserverless.RestoreFromSnapshotOutput)

	TagResource(*redshiftserverless.TagResourceInput) (*redshiftserverless.TagResourceOutput, error)
	TagResourceWithContext(aws.Context, *redshiftserverless.TagResourceInput, ...request.Option) (*redshiftserverless.TagResourceOutput, error)
	TagResourceRequest(*redshiftserverless.TagResourceInput) (*request.Request, *redshiftserverless.TagResourceOutput)

	UntagResource(*redshiftserverless.UntagResourceInput) (*redshiftserverless.UntagResourceOutput, error)
	UntagResourceWithContext(aws.Context, *redshiftserverless.UntagResourceInput, ...request.Option) (*redshiftserverless.UntagResourceOutput, error)
	UntagResourceRequest(*redshiftserverless.UntagResourceInput) (*request.Request, *redshiftserverless.UntagResourceOutput)

	UpdateEndpointAccess(*redshiftserverless.UpdateEndpointAccessInput) (*redshiftserverless.UpdateEndpointAccessOutput, error)
	UpdateEndpointAccessWithContext(aws.Context, *redshiftserverless.UpdateEndpointAccessInput, ...request.Option) (*redshiftserverless.UpdateEndpointAccessOutput, error)
	UpdateEndpointAccessRequest(*redshiftserverless.UpdateEndpointAccessInput) (*request.Request, *redshiftserverless.UpdateEndpointAccessOutput)

	UpdateNamespace(*redshiftserverless.UpdateNamespaceInput) (*redshiftserverless.UpdateNamespaceOutput, error)
	UpdateNamespaceWithContext(aws.Context, *redshiftserverless.UpdateNamespaceInput, ...request.Option) (*redshiftserverless.UpdateNamespaceOutput, error)
	UpdateNamespaceRequest(*redshiftserverless.UpdateNamespaceInput) (*request.Request, *redshiftserverless.UpdateNamespaceOutput)

	UpdateSnapshot(*redshiftserverless.UpdateSnapshotInput) (*redshiftserverless.UpdateSnapshotOutput, error)
	UpdateSnapshotWithContext(aws.Context, *redshiftserverless.UpdateSnapshotInput, ...request.Option) (*redshiftserverless.UpdateSnapshotOutput, error)
	UpdateSnapshotRequest(*redshiftserverless.UpdateSnapshotInput) (*request.Request, *redshiftserverless.UpdateSnapshotOutput)

	UpdateUsageLimit(*redshiftserverless.UpdateUsageLimitInput) (*redshiftserverless.UpdateUsageLimitOutput, error)
	UpdateUsageLimitWithContext(aws.Context, *redshiftserverless.UpdateUsageLimitInput, ...request.Option) (*redshiftserverless.UpdateUsageLimitOutput, error)
	UpdateUsageLimitRequest(*redshiftserverless.UpdateUsageLimitInput) (*request.Request, *redshiftserverless.UpdateUsageLimitOutput)

	UpdateWorkgroup(*redshiftserverless.UpdateWorkgroupInput) (*redshiftserverless.UpdateWorkgroupOutput, error)
	UpdateWorkgroupWithContext(aws.Context, *redshiftserverless.UpdateWorkgroupInput, ...request.Option) (*redshiftserverless.UpdateWorkgroupOutput, error)
	UpdateWorkgroupRequest(*redshiftserverless.UpdateWorkgroupInput) (*request.Request, *redshiftserverless.UpdateWorkgroupOutput)
}

var _ RedshiftServerlessAPI = (*redshiftserverless.RedshiftServerless)(nil)
