package scsp

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// GetHotlineAgentDetail invokes the scsp.GetHotlineAgentDetail API synchronously
func (client *Client) GetHotlineAgentDetail(request *GetHotlineAgentDetailRequest) (response *GetHotlineAgentDetailResponse, err error) {
	response = CreateGetHotlineAgentDetailResponse()
	err = client.DoAction(request, response)
	return
}

// GetHotlineAgentDetailWithChan invokes the scsp.GetHotlineAgentDetail API asynchronously
func (client *Client) GetHotlineAgentDetailWithChan(request *GetHotlineAgentDetailRequest) (<-chan *GetHotlineAgentDetailResponse, <-chan error) {
	responseChan := make(chan *GetHotlineAgentDetailResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.GetHotlineAgentDetail(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// GetHotlineAgentDetailWithCallback invokes the scsp.GetHotlineAgentDetail API asynchronously
func (client *Client) GetHotlineAgentDetailWithCallback(request *GetHotlineAgentDetailRequest, callback func(response *GetHotlineAgentDetailResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *GetHotlineAgentDetailResponse
		var err error
		defer close(result)
		response, err = client.GetHotlineAgentDetail(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// GetHotlineAgentDetailRequest is the request struct for api GetHotlineAgentDetail
type GetHotlineAgentDetailRequest struct {
	*requests.RpcRequest
	ClientToken string `position:"Query"`
	InstanceId  string `position:"Query"`
	AccountName string `position:"Query"`
}

// GetHotlineAgentDetailResponse is the response struct for api GetHotlineAgentDetail
type GetHotlineAgentDetailResponse struct {
	*responses.BaseResponse
	Message        string `json:"Message" xml:"Message"`
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Code           string `json:"Code" xml:"Code"`
	Success        bool   `json:"Success" xml:"Success"`
	HttpStatusCode int64  `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Data           Data   `json:"Data" xml:"Data"`
}

// CreateGetHotlineAgentDetailRequest creates a request to invoke GetHotlineAgentDetail API
func CreateGetHotlineAgentDetailRequest() (request *GetHotlineAgentDetailRequest) {
	request = &GetHotlineAgentDetailRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("scsp", "2020-07-02", "GetHotlineAgentDetail", "", "")
	request.Method = requests.GET
	return
}

// CreateGetHotlineAgentDetailResponse creates a response to parse from GetHotlineAgentDetail response
func CreateGetHotlineAgentDetailResponse() (response *GetHotlineAgentDetailResponse) {
	response = &GetHotlineAgentDetailResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
