package quickbi_public

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// QueryUserRoleInfoInWorkspace invokes the quickbi_public.QueryUserRoleInfoInWorkspace API synchronously
func (client *Client) QueryUserRoleInfoInWorkspace(request *QueryUserRoleInfoInWorkspaceRequest) (response *QueryUserRoleInfoInWorkspaceResponse, err error) {
	response = CreateQueryUserRoleInfoInWorkspaceResponse()
	err = client.DoAction(request, response)
	return
}

// QueryUserRoleInfoInWorkspaceWithChan invokes the quickbi_public.QueryUserRoleInfoInWorkspace API asynchronously
func (client *Client) QueryUserRoleInfoInWorkspaceWithChan(request *QueryUserRoleInfoInWorkspaceRequest) (<-chan *QueryUserRoleInfoInWorkspaceResponse, <-chan error) {
	responseChan := make(chan *QueryUserRoleInfoInWorkspaceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.QueryUserRoleInfoInWorkspace(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// QueryUserRoleInfoInWorkspaceWithCallback invokes the quickbi_public.QueryUserRoleInfoInWorkspace API asynchronously
func (client *Client) QueryUserRoleInfoInWorkspaceWithCallback(request *QueryUserRoleInfoInWorkspaceRequest, callback func(response *QueryUserRoleInfoInWorkspaceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *QueryUserRoleInfoInWorkspaceResponse
		var err error
		defer close(result)
		response, err = client.QueryUserRoleInfoInWorkspace(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// QueryUserRoleInfoInWorkspaceRequest is the request struct for api QueryUserRoleInfoInWorkspace
type QueryUserRoleInfoInWorkspaceRequest struct {
	*requests.RpcRequest
	AccessPoint string `position:"Query" name:"AccessPoint"`
	SignType    string `position:"Query" name:"SignType"`
	UserId      string `position:"Query" name:"UserId"`
	WorkspaceId string `position:"Query" name:"WorkspaceId"`
}

// QueryUserRoleInfoInWorkspaceResponse is the response struct for api QueryUserRoleInfoInWorkspace
type QueryUserRoleInfoInWorkspaceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Success   bool   `json:"Success" xml:"Success"`
	Result    Result `json:"Result" xml:"Result"`
}

// CreateQueryUserRoleInfoInWorkspaceRequest creates a request to invoke QueryUserRoleInfoInWorkspace API
func CreateQueryUserRoleInfoInWorkspaceRequest() (request *QueryUserRoleInfoInWorkspaceRequest) {
	request = &QueryUserRoleInfoInWorkspaceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("quickbi-public", "2020-08-03", "QueryUserRoleInfoInWorkspace", "quickbi", "openAPI")
	request.Method = requests.POST
	return
}

// CreateQueryUserRoleInfoInWorkspaceResponse creates a response to parse from QueryUserRoleInfoInWorkspace response
func CreateQueryUserRoleInfoInWorkspaceResponse() (response *QueryUserRoleInfoInWorkspaceResponse) {
	response = &QueryUserRoleInfoInWorkspaceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
