package ots

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListVpcInfoByVpc invokes the ots.ListVpcInfoByVpc API synchronously
// api document: https://help.aliyun.com/api/ots/listvpcinfobyvpc.html
func (client *Client) ListVpcInfoByVpc(request *ListVpcInfoByVpcRequest) (response *ListVpcInfoByVpcResponse, err error) {
	response = CreateListVpcInfoByVpcResponse()
	err = client.DoAction(request, response)
	return
}

// ListVpcInfoByVpcWithChan invokes the ots.ListVpcInfoByVpc API asynchronously
// api document: https://help.aliyun.com/api/ots/listvpcinfobyvpc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVpcInfoByVpcWithChan(request *ListVpcInfoByVpcRequest) (<-chan *ListVpcInfoByVpcResponse, <-chan error) {
	responseChan := make(chan *ListVpcInfoByVpcResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListVpcInfoByVpc(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListVpcInfoByVpcWithCallback invokes the ots.ListVpcInfoByVpc API asynchronously
// api document: https://help.aliyun.com/api/ots/listvpcinfobyvpc.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) ListVpcInfoByVpcWithCallback(request *ListVpcInfoByVpcRequest, callback func(response *ListVpcInfoByVpcResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListVpcInfoByVpcResponse
		var err error
		defer close(result)
		response, err = client.ListVpcInfoByVpc(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListVpcInfoByVpcRequest is the request struct for api ListVpcInfoByVpc
type ListVpcInfoByVpcRequest struct {
	*requests.RpcRequest
	AccessKeyId     string                     `position:"Query" name:"access_key_id"`
	ResourceOwnerId requests.Integer           `position:"Query" name:"ResourceOwnerId"`
	VpcId           string                     `position:"Query" name:"VpcId"`
	PageSize        requests.Integer           `position:"Query" name:"PageSize"`
	PageNum         requests.Integer           `position:"Query" name:"PageNum"`
	TagInfo         *[]ListVpcInfoByVpcTagInfo `position:"Query" name:"TagInfo"  type:"Repeated"`
}

// ListVpcInfoByVpcTagInfo is a repeated param struct in ListVpcInfoByVpcRequest
type ListVpcInfoByVpcTagInfo struct {
	TagValue string `name:"TagValue"`
	TagKey   string `name:"TagKey"`
}

// ListVpcInfoByVpcResponse is the response struct for api ListVpcInfoByVpc
type ListVpcInfoByVpcResponse struct {
	*responses.BaseResponse
	TotalCount int                        `json:"TotalCount" xml:"TotalCount"`
	PageNum    int                        `json:"PageNum" xml:"PageNum"`
	PageSize   int                        `json:"PageSize" xml:"PageSize"`
	RequestId  string                     `json:"RequestId" xml:"RequestId"`
	VpcId      string                     `json:"VpcId" xml:"VpcId"`
	VpcInfos   VpcInfosInListVpcInfoByVpc `json:"VpcInfos" xml:"VpcInfos"`
}

// CreateListVpcInfoByVpcRequest creates a request to invoke ListVpcInfoByVpc API
func CreateListVpcInfoByVpcRequest() (request *ListVpcInfoByVpcRequest) {
	request = &ListVpcInfoByVpcRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Ots", "2016-06-20", "ListVpcInfoByVpc", "ots", "openAPI")
	return
}

// CreateListVpcInfoByVpcResponse creates a response to parse from ListVpcInfoByVpc response
func CreateListVpcInfoByVpcResponse() (response *ListVpcInfoByVpcResponse) {
	response = &ListVpcInfoByVpcResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
