package openanalytics_open

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// RevokePrivileges invokes the openanalytics_open.RevokePrivileges API synchronously
func (client *Client) RevokePrivileges(request *RevokePrivilegesRequest) (response *RevokePrivilegesResponse, err error) {
	response = CreateRevokePrivilegesResponse()
	err = client.DoAction(request, response)
	return
}

// RevokePrivilegesWithChan invokes the openanalytics_open.RevokePrivileges API asynchronously
func (client *Client) RevokePrivilegesWithChan(request *RevokePrivilegesRequest) (<-chan *RevokePrivilegesResponse, <-chan error) {
	responseChan := make(chan *RevokePrivilegesResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.RevokePrivileges(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// RevokePrivilegesWithCallback invokes the openanalytics_open.RevokePrivileges API asynchronously
func (client *Client) RevokePrivilegesWithCallback(request *RevokePrivilegesRequest, callback func(response *RevokePrivilegesResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *RevokePrivilegesResponse
		var err error
		defer close(result)
		response, err = client.RevokePrivileges(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// RevokePrivilegesRequest is the request struct for api RevokePrivileges
type RevokePrivilegesRequest struct {
	*requests.RpcRequest
	PrivilegeBag string `position:"Query" name:"PrivilegeBag"`
}

// RevokePrivilegesResponse is the response struct for api RevokePrivileges
type RevokePrivilegesResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	Message   string `json:"Message" xml:"Message"`
	Data      bool   `json:"Data" xml:"Data"`
	Code      string `json:"Code" xml:"Code"`
	Success   bool   `json:"Success" xml:"Success"`
}

// CreateRevokePrivilegesRequest creates a request to invoke RevokePrivileges API
func CreateRevokePrivilegesRequest() (request *RevokePrivilegesRequest) {
	request = &RevokePrivilegesRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("openanalytics-open", "2020-09-28", "RevokePrivileges", "openanalytics", "openAPI")
	request.Method = requests.POST
	return
}

// CreateRevokePrivilegesResponse creates a response to parse from RevokePrivileges response
func CreateRevokePrivilegesResponse() (response *RevokePrivilegesResponse) {
	response = &RevokePrivilegesResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
