package iot

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DeleteSubscribeRelation invokes the iot.DeleteSubscribeRelation API synchronously
func (client *Client) DeleteSubscribeRelation(request *DeleteSubscribeRelationRequest) (response *DeleteSubscribeRelationResponse, err error) {
	response = CreateDeleteSubscribeRelationResponse()
	err = client.DoAction(request, response)
	return
}

// DeleteSubscribeRelationWithChan invokes the iot.DeleteSubscribeRelation API asynchronously
func (client *Client) DeleteSubscribeRelationWithChan(request *DeleteSubscribeRelationRequest) (<-chan *DeleteSubscribeRelationResponse, <-chan error) {
	responseChan := make(chan *DeleteSubscribeRelationResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DeleteSubscribeRelation(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DeleteSubscribeRelationWithCallback invokes the iot.DeleteSubscribeRelation API asynchronously
func (client *Client) DeleteSubscribeRelationWithCallback(request *DeleteSubscribeRelationRequest, callback func(response *DeleteSubscribeRelationResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DeleteSubscribeRelationResponse
		var err error
		defer close(result)
		response, err = client.DeleteSubscribeRelation(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DeleteSubscribeRelationRequest is the request struct for api DeleteSubscribeRelation
type DeleteSubscribeRelationRequest struct {
	*requests.RpcRequest
	Type          string `position:"Query" name:"Type"`
	IotInstanceId string `position:"Query" name:"IotInstanceId"`
	ProductKey    string `position:"Query" name:"ProductKey"`
	ApiProduct    string `position:"Body" name:"ApiProduct"`
	ApiRevision   string `position:"Body" name:"ApiRevision"`
}

// DeleteSubscribeRelationResponse is the response struct for api DeleteSubscribeRelation
type DeleteSubscribeRelationResponse struct {
	*responses.BaseResponse
	RequestId    string `json:"RequestId" xml:"RequestId"`
	Success      bool   `json:"Success" xml:"Success"`
	Code         string `json:"Code" xml:"Code"`
	ErrorMessage string `json:"ErrorMessage" xml:"ErrorMessage"`
}

// CreateDeleteSubscribeRelationRequest creates a request to invoke DeleteSubscribeRelation API
func CreateDeleteSubscribeRelationRequest() (request *DeleteSubscribeRelationRequest) {
	request = &DeleteSubscribeRelationRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Iot", "2018-01-20", "DeleteSubscribeRelation", "", "")
	request.Method = requests.POST
	return
}

// CreateDeleteSubscribeRelationResponse creates a response to parse from DeleteSubscribeRelation response
func CreateDeleteSubscribeRelationResponse() (response *DeleteSubscribeRelationResponse) {
	response = &DeleteSubscribeRelationResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
