package emr

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// ListResourcePool invokes the emr.ListResourcePool API synchronously
func (client *Client) ListResourcePool(request *ListResourcePoolRequest) (response *ListResourcePoolResponse, err error) {
	response = CreateListResourcePoolResponse()
	err = client.DoAction(request, response)
	return
}

// ListResourcePoolWithChan invokes the emr.ListResourcePool API asynchronously
func (client *Client) ListResourcePoolWithChan(request *ListResourcePoolRequest) (<-chan *ListResourcePoolResponse, <-chan error) {
	responseChan := make(chan *ListResourcePoolResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.ListResourcePool(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// ListResourcePoolWithCallback invokes the emr.ListResourcePool API asynchronously
func (client *Client) ListResourcePoolWithCallback(request *ListResourcePoolRequest, callback func(response *ListResourcePoolResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *ListResourcePoolResponse
		var err error
		defer close(result)
		response, err = client.ListResourcePool(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// ListResourcePoolRequest is the request struct for api ListResourcePool
type ListResourcePoolRequest struct {
	*requests.RpcRequest
	ResourceOwnerId requests.Integer `position:"Query" name:"ResourceOwnerId"`
	ClusterId       string           `position:"Query" name:"ClusterId"`
	PageNumber      requests.Integer `position:"Query" name:"PageNumber"`
	PageSize        requests.Integer `position:"Query" name:"PageSize"`
	PoolType        string           `position:"Query" name:"PoolType"`
}

// ListResourcePoolResponse is the response struct for api ListResourcePool
type ListResourcePoolResponse struct {
	*responses.BaseResponse
	RequestId    string       `json:"RequestId" xml:"RequestId"`
	PageNumber   int          `json:"PageNumber" xml:"PageNumber"`
	PageSize     int          `json:"PageSize" xml:"PageSize"`
	Total        int          `json:"Total" xml:"Total"`
	PoolInfoList PoolInfoList `json:"PoolInfoList" xml:"PoolInfoList"`
}

// CreateListResourcePoolRequest creates a request to invoke ListResourcePool API
func CreateListResourcePoolRequest() (request *ListResourcePoolRequest) {
	request = &ListResourcePoolRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Emr", "2016-04-08", "ListResourcePool", "emr", "openAPI")
	request.Method = requests.POST
	return
}

// CreateListResourcePoolResponse creates a response to parse from ListResourcePool response
func CreateListResourcePoolResponse() (response *ListResourcePoolResponse) {
	response = &ListResourcePoolResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
