package ehpc

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// UpdateQueueConfig invokes the ehpc.UpdateQueueConfig API synchronously
func (client *Client) UpdateQueueConfig(request *UpdateQueueConfigRequest) (response *UpdateQueueConfigResponse, err error) {
	response = CreateUpdateQueueConfigResponse()
	err = client.DoAction(request, response)
	return
}

// UpdateQueueConfigWithChan invokes the ehpc.UpdateQueueConfig API asynchronously
func (client *Client) UpdateQueueConfigWithChan(request *UpdateQueueConfigRequest) (<-chan *UpdateQueueConfigResponse, <-chan error) {
	responseChan := make(chan *UpdateQueueConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.UpdateQueueConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// UpdateQueueConfigWithCallback invokes the ehpc.UpdateQueueConfig API asynchronously
func (client *Client) UpdateQueueConfigWithCallback(request *UpdateQueueConfigRequest, callback func(response *UpdateQueueConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *UpdateQueueConfigResponse
		var err error
		defer close(result)
		response, err = client.UpdateQueueConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// UpdateQueueConfigRequest is the request struct for api UpdateQueueConfig
type UpdateQueueConfigRequest struct {
	*requests.RpcRequest
	QueueName           string `position:"Query" name:"QueueName"`
	ClusterId           string `position:"Query" name:"ClusterId"`
	ResourceGroupId     string `position:"Query" name:"ResourceGroupId"`
	ComputeInstanceType string `position:"Query" name:"ComputeInstanceType"`
}

// UpdateQueueConfigResponse is the response struct for api UpdateQueueConfig
type UpdateQueueConfigResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
}

// CreateUpdateQueueConfigRequest creates a request to invoke UpdateQueueConfig API
func CreateUpdateQueueConfigRequest() (request *UpdateQueueConfigRequest) {
	request = &UpdateQueueConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("EHPC", "2018-04-12", "UpdateQueueConfig", "", "")
	request.Method = requests.GET
	return
}

// CreateUpdateQueueConfigResponse creates a response to parse from UpdateQueueConfig response
func CreateUpdateQueueConfigResponse() (response *UpdateQueueConfigResponse) {
	response = &UpdateQueueConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
