package drds

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDbInstanceDbs invokes the drds.DescribeDbInstanceDbs API synchronously
func (client *Client) DescribeDbInstanceDbs(request *DescribeDbInstanceDbsRequest) (response *DescribeDbInstanceDbsResponse, err error) {
	response = CreateDescribeDbInstanceDbsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDbInstanceDbsWithChan invokes the drds.DescribeDbInstanceDbs API asynchronously
func (client *Client) DescribeDbInstanceDbsWithChan(request *DescribeDbInstanceDbsRequest) (<-chan *DescribeDbInstanceDbsResponse, <-chan error) {
	responseChan := make(chan *DescribeDbInstanceDbsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDbInstanceDbs(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDbInstanceDbsWithCallback invokes the drds.DescribeDbInstanceDbs API asynchronously
func (client *Client) DescribeDbInstanceDbsWithCallback(request *DescribeDbInstanceDbsRequest, callback func(response *DescribeDbInstanceDbsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDbInstanceDbsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDbInstanceDbs(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDbInstanceDbsRequest is the request struct for api DescribeDbInstanceDbs
type DescribeDbInstanceDbsRequest struct {
	*requests.RpcRequest
	DrdsInstanceId string `position:"Query" name:"DrdsInstanceId"`
	Password       string `position:"Query" name:"Password"`
	AccountName    string `position:"Query" name:"AccountName"`
	DbInstanceId   string `position:"Query" name:"DbInstanceId"`
	DbInstType     string `position:"Query" name:"DbInstType"`
}

// DescribeDbInstanceDbsResponse is the response struct for api DescribeDbInstanceDbs
type DescribeDbInstanceDbsResponse struct {
	*responses.BaseResponse
	RequestId string    `json:"RequestId" xml:"RequestId"`
	Success   bool      `json:"Success" xml:"Success"`
	Total     string    `json:"Total" xml:"Total"`
	Databases Databases `json:"Databases" xml:"Databases"`
}

// CreateDescribeDbInstanceDbsRequest creates a request to invoke DescribeDbInstanceDbs API
func CreateDescribeDbInstanceDbsRequest() (request *DescribeDbInstanceDbsRequest) {
	request = &DescribeDbInstanceDbsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Drds", "2019-01-23", "DescribeDbInstanceDbs", "drds", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDbInstanceDbsResponse creates a response to parse from DescribeDbInstanceDbs response
func CreateDescribeDbInstanceDbsResponse() (response *DescribeDbInstanceDbsResponse) {
	response = &DescribeDbInstanceDbsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
