package cloudcallcenter

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// CreateTaobaoOrder invokes the cloudcallcenter.CreateTaobaoOrder API synchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createtaobaoorder.html
func (client *Client) CreateTaobaoOrder(request *CreateTaobaoOrderRequest) (response *CreateTaobaoOrderResponse, err error) {
	response = CreateCreateTaobaoOrderResponse()
	err = client.DoAction(request, response)
	return
}

// CreateTaobaoOrderWithChan invokes the cloudcallcenter.CreateTaobaoOrder API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createtaobaoorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTaobaoOrderWithChan(request *CreateTaobaoOrderRequest) (<-chan *CreateTaobaoOrderResponse, <-chan error) {
	responseChan := make(chan *CreateTaobaoOrderResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.CreateTaobaoOrder(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// CreateTaobaoOrderWithCallback invokes the cloudcallcenter.CreateTaobaoOrder API asynchronously
// api document: https://help.aliyun.com/api/cloudcallcenter/createtaobaoorder.html
// asynchronous document: https://help.aliyun.com/document_detail/66220.html
func (client *Client) CreateTaobaoOrderWithCallback(request *CreateTaobaoOrderRequest, callback func(response *CreateTaobaoOrderResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *CreateTaobaoOrderResponse
		var err error
		defer close(result)
		response, err = client.CreateTaobaoOrder(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// CreateTaobaoOrderRequest is the request struct for api CreateTaobaoOrder
type CreateTaobaoOrderRequest struct {
	*requests.RpcRequest
	TaobaoNick       string           `position:"Query" name:"TaobaoNick"`
	ProdFee          requests.Float   `position:"Query" name:"ProdFee"`
	OrderId          requests.Integer `position:"Query" name:"OrderId"`
	OrderRecordId    requests.Integer `position:"Query" name:"OrderRecordId"`
	TaobaoUid        requests.Integer `position:"Query" name:"TaobaoUid"`
	Type             requests.Integer `position:"Query" name:"type"`
	StartDate        requests.Integer `position:"Query" name:"StartDate"`
	PayDate          requests.Integer `position:"Query" name:"PayDate"`
	ParentOrderId    requests.Integer `position:"Query" name:"ParentOrderId"`
	ArticleCode      string           `position:"Query" name:"ArticleCode"`
	ExpiresIn        requests.Integer `position:"Query" name:"ExpiresIn"`
	FactMoney        requests.Float   `position:"Query" name:"FactMoney"`
	OutcomingAccount requests.Integer `position:"Query" name:"OutcomingAccount"`
	ArticleItemCode  string           `position:"Query" name:"articleItemCode"`
	IncomingAccount  requests.Integer `position:"Query" name:"IncomingAccount"`
	PlanId           requests.Integer `position:"Query" name:"PlanId"`
	Status           requests.Integer `position:"Query" name:"status"`
}

// CreateTaobaoOrderResponse is the response struct for api CreateTaobaoOrder
type CreateTaobaoOrderResponse struct {
	*responses.BaseResponse
	RequestId      string `json:"RequestId" xml:"RequestId"`
	Success        bool   `json:"Success" xml:"Success"`
	Code           string `json:"Code" xml:"Code"`
	Message        string `json:"Message" xml:"Message"`
	HttpStatusCode int    `json:"HttpStatusCode" xml:"HttpStatusCode"`
	Count          int    `json:"Count" xml:"Count"`
}

// CreateCreateTaobaoOrderRequest creates a request to invoke CreateTaobaoOrder API
func CreateCreateTaobaoOrderRequest() (request *CreateTaobaoOrderRequest) {
	request = &CreateTaobaoOrderRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("CloudCallCenter", "2017-07-05", "CreateTaobaoOrder", "", "")
	request.Method = requests.POST
	return
}

// CreateCreateTaobaoOrderResponse creates a response to parse from CreateTaobaoOrder response
func CreateCreateTaobaoOrderResponse() (response *CreateTaobaoOrderResponse) {
	response = &CreateTaobaoOrderResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
