package arms

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// OpenArmsService invokes the arms.OpenArmsService API synchronously
func (client *Client) OpenArmsService(request *OpenArmsServiceRequest) (response *OpenArmsServiceResponse, err error) {
	response = CreateOpenArmsServiceResponse()
	err = client.DoAction(request, response)
	return
}

// OpenArmsServiceWithChan invokes the arms.OpenArmsService API asynchronously
func (client *Client) OpenArmsServiceWithChan(request *OpenArmsServiceRequest) (<-chan *OpenArmsServiceResponse, <-chan error) {
	responseChan := make(chan *OpenArmsServiceResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.OpenArmsService(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// OpenArmsServiceWithCallback invokes the arms.OpenArmsService API asynchronously
func (client *Client) OpenArmsServiceWithCallback(request *OpenArmsServiceRequest, callback func(response *OpenArmsServiceResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *OpenArmsServiceResponse
		var err error
		defer close(result)
		response, err = client.OpenArmsService(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// OpenArmsServiceRequest is the request struct for api OpenArmsService
type OpenArmsServiceRequest struct {
	*requests.RpcRequest
	OwnerId requests.Integer `position:"Query" name:"OwnerId"`
	Type    string           `position:"Query" name:"Type"`
}

// OpenArmsServiceResponse is the response struct for api OpenArmsService
type OpenArmsServiceResponse struct {
	*responses.BaseResponse
	RequestId string `json:"RequestId" xml:"RequestId"`
	OrderId   string `json:"OrderId" xml:"OrderId"`
}

// CreateOpenArmsServiceRequest creates a request to invoke OpenArmsService API
func CreateOpenArmsServiceRequest() (request *OpenArmsServiceRequest) {
	request = &OpenArmsServiceRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("ARMS", "2019-08-08", "OpenArmsService", "", "")
	request.Method = requests.POST
	return
}

// CreateOpenArmsServiceResponse creates a response to parse from OpenArmsService response
func CreateOpenArmsServiceResponse() (response *OpenArmsServiceResponse) {
	response = &OpenArmsServiceResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
