package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDohSubDomainStatistics invokes the alidns.DescribeDohSubDomainStatistics API synchronously
func (client *Client) DescribeDohSubDomainStatistics(request *DescribeDohSubDomainStatisticsRequest) (response *DescribeDohSubDomainStatisticsResponse, err error) {
	response = CreateDescribeDohSubDomainStatisticsResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDohSubDomainStatisticsWithChan invokes the alidns.DescribeDohSubDomainStatistics API asynchronously
func (client *Client) DescribeDohSubDomainStatisticsWithChan(request *DescribeDohSubDomainStatisticsRequest) (<-chan *DescribeDohSubDomainStatisticsResponse, <-chan error) {
	responseChan := make(chan *DescribeDohSubDomainStatisticsResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDohSubDomainStatistics(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDohSubDomainStatisticsWithCallback invokes the alidns.DescribeDohSubDomainStatistics API asynchronously
func (client *Client) DescribeDohSubDomainStatisticsWithCallback(request *DescribeDohSubDomainStatisticsRequest, callback func(response *DescribeDohSubDomainStatisticsResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDohSubDomainStatisticsResponse
		var err error
		defer close(result)
		response, err = client.DescribeDohSubDomainStatistics(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDohSubDomainStatisticsRequest is the request struct for api DescribeDohSubDomainStatistics
type DescribeDohSubDomainStatisticsRequest struct {
	*requests.RpcRequest
	StartDate string `position:"Query" name:"StartDate"`
	EndDate   string `position:"Query" name:"EndDate"`
	SubDomain string `position:"Query" name:"SubDomain"`
	Lang      string `position:"Query" name:"Lang"`
}

// DescribeDohSubDomainStatisticsResponse is the response struct for api DescribeDohSubDomainStatistics
type DescribeDohSubDomainStatisticsResponse struct {
	*responses.BaseResponse
	RequestId  string      `json:"RequestId" xml:"RequestId"`
	Statistics []Statistic `json:"Statistics" xml:"Statistics"`
}

// CreateDescribeDohSubDomainStatisticsRequest creates a request to invoke DescribeDohSubDomainStatistics API
func CreateDescribeDohSubDomainStatisticsRequest() (request *DescribeDohSubDomainStatisticsRequest) {
	request = &DescribeDohSubDomainStatisticsRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDohSubDomainStatistics", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDohSubDomainStatisticsResponse creates a response to parse from DescribeDohSubDomainStatistics response
func CreateDescribeDohSubDomainStatisticsResponse() (response *DescribeDohSubDomainStatisticsResponse) {
	response = &DescribeDohSubDomainStatisticsResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
