package alidns

//Licensed under the Apache License, Version 2.0 (the "License");
//you may not use this file except in compliance with the License.
//You may obtain a copy of the License at
//
//http://www.apache.org/licenses/LICENSE-2.0
//
//Unless required by applicable law or agreed to in writing, software
//distributed under the License is distributed on an "AS IS" BASIS,
//WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
//See the License for the specific language governing permissions and
//limitations under the License.
//
// Code generated by Alibaba Cloud SDK Code Generator.
// Changes may cause incorrect behavior and will be lost if the code is regenerated.

import (
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/requests"
	"github.com/aliyun/alibaba-cloud-sdk-go/sdk/responses"
)

// DescribeDnsGtmAddressPoolAvailableConfig invokes the alidns.DescribeDnsGtmAddressPoolAvailableConfig API synchronously
func (client *Client) DescribeDnsGtmAddressPoolAvailableConfig(request *DescribeDnsGtmAddressPoolAvailableConfigRequest) (response *DescribeDnsGtmAddressPoolAvailableConfigResponse, err error) {
	response = CreateDescribeDnsGtmAddressPoolAvailableConfigResponse()
	err = client.DoAction(request, response)
	return
}

// DescribeDnsGtmAddressPoolAvailableConfigWithChan invokes the alidns.DescribeDnsGtmAddressPoolAvailableConfig API asynchronously
func (client *Client) DescribeDnsGtmAddressPoolAvailableConfigWithChan(request *DescribeDnsGtmAddressPoolAvailableConfigRequest) (<-chan *DescribeDnsGtmAddressPoolAvailableConfigResponse, <-chan error) {
	responseChan := make(chan *DescribeDnsGtmAddressPoolAvailableConfigResponse, 1)
	errChan := make(chan error, 1)
	err := client.AddAsyncTask(func() {
		defer close(responseChan)
		defer close(errChan)
		response, err := client.DescribeDnsGtmAddressPoolAvailableConfig(request)
		if err != nil {
			errChan <- err
		} else {
			responseChan <- response
		}
	})
	if err != nil {
		errChan <- err
		close(responseChan)
		close(errChan)
	}
	return responseChan, errChan
}

// DescribeDnsGtmAddressPoolAvailableConfigWithCallback invokes the alidns.DescribeDnsGtmAddressPoolAvailableConfig API asynchronously
func (client *Client) DescribeDnsGtmAddressPoolAvailableConfigWithCallback(request *DescribeDnsGtmAddressPoolAvailableConfigRequest, callback func(response *DescribeDnsGtmAddressPoolAvailableConfigResponse, err error)) <-chan int {
	result := make(chan int, 1)
	err := client.AddAsyncTask(func() {
		var response *DescribeDnsGtmAddressPoolAvailableConfigResponse
		var err error
		defer close(result)
		response, err = client.DescribeDnsGtmAddressPoolAvailableConfig(request)
		callback(response, err)
		result <- 1
	})
	if err != nil {
		defer close(result)
		callback(nil, err)
		result <- 0
	}
	return result
}

// DescribeDnsGtmAddressPoolAvailableConfigRequest is the request struct for api DescribeDnsGtmAddressPoolAvailableConfig
type DescribeDnsGtmAddressPoolAvailableConfigRequest struct {
	*requests.RpcRequest
	InstanceId   string `position:"Query" name:"InstanceId"`
	UserClientIp string `position:"Query" name:"UserClientIp"`
	Lang         string `position:"Query" name:"Lang"`
}

// DescribeDnsGtmAddressPoolAvailableConfigResponse is the response struct for api DescribeDnsGtmAddressPoolAvailableConfig
type DescribeDnsGtmAddressPoolAvailableConfigResponse struct {
	*responses.BaseResponse
	RequestId      string         `json:"RequestId" xml:"RequestId"`
	AttributeInfos AttributeInfos `json:"AttributeInfos" xml:"AttributeInfos"`
}

// CreateDescribeDnsGtmAddressPoolAvailableConfigRequest creates a request to invoke DescribeDnsGtmAddressPoolAvailableConfig API
func CreateDescribeDnsGtmAddressPoolAvailableConfigRequest() (request *DescribeDnsGtmAddressPoolAvailableConfigRequest) {
	request = &DescribeDnsGtmAddressPoolAvailableConfigRequest{
		RpcRequest: &requests.RpcRequest{},
	}
	request.InitWithApiInfo("Alidns", "2015-01-09", "DescribeDnsGtmAddressPoolAvailableConfig", "alidns", "openAPI")
	request.Method = requests.POST
	return
}

// CreateDescribeDnsGtmAddressPoolAvailableConfigResponse creates a response to parse from DescribeDnsGtmAddressPoolAvailableConfig response
func CreateDescribeDnsGtmAddressPoolAvailableConfigResponse() (response *DescribeDnsGtmAddressPoolAvailableConfigResponse) {
	response = &DescribeDnsGtmAddressPoolAvailableConfigResponse{
		BaseResponse: &responses.BaseResponse{},
	}
	return
}
