# 0.82.2 release notes

**Release date:** 2025-06-17


## Summary

This maintenance release corrects the minimum required macOS version
regression introduced in 0.82.1 plus adds a few minor enhancements and fixes:

- The minimum supported macOS version was raised to **macOS 14 (Sonoma)** in
  0.82.1 by mistake. This is now fixed; DOSBox Staging 0.82.2 requires **macOS
  11 (Big Sur)** or later.

- Fix incorrect handling of read-only directories on Linux and macOS. This
  fixes **DeuTex** (DOOM WAD extractor).

- Fix emulator hanging when quitting DOSBox Staging while rebooting is in
  progress.

- Restarting DOSBox with `CONFIG -R` or the restart hotkey now correctly saves
  the command line history.

- Allow read-only directories to be deleted with the `RMDIR` DOS command on
  Windows.

- Update bundled FreeDOS **XCOPY** to v1.9a.

This release was made possible by everyone who tried 0.82.1, submitted bugs
and pull requests, and tested the updates. Thank you!


??? note "Full PR list of changes"

    - Don't set host permissions for read-only directories on POSIX (#4283)
    - Fix emulator becoming unresponsive if the user exits the app while inside the reboot handler (#4274)
    - Make restart_dosbox() go through the normal shutdown routine (#4368)
    - On Windows, clear the read-only attribute before removing a directory. (#4297)
    - Revert object pool stuff (#4111)
    - Update bundled FreeDOS xcopy.exe to version 1.9a (#4285)


## Installation

This is a drop-in upgrade for users already on [0.82.1](0.82.1.md)---no
configuration changes are necessary.

For those upgrading from an earlier DOSBox Staging version, please follow
these [upgrade instructions](0.82.0.md/#how-to-upgrade) and read the 
earlier release notes to learn about the changes and new features.

First-time users and people migrating from other DOSBox variants should start
by reading the [Getting started guide](../../getting-started/index.md).


## 0.82.2 commit authors

<div class="compact" markdown>

  - FeralChild64
  - johnnovak
  - weirddan455

</div>


## Thank you

We are grateful for all the community contributions and the original DOSBox
project, on which DOSBox Staging is based.
