/*
 * Decompiled with CFR 0.152.
 */
package org.apache.fop.fonts;

import java.net.URISyntaxException;
import java.net.URL;
import java.util.List;
import org.apache.fop.apps.io.InternalResourceResolver;
import org.apache.fop.fonts.EmbedFontInfo;
import org.apache.fop.fonts.FontCache;
import org.apache.fop.fonts.FontEventListener;
import org.apache.fop.fonts.FontManager;
import org.apache.fop.fonts.autodetect.FontInfoFinder;

public class FontAdder {
    private final FontEventListener listener;
    private final InternalResourceResolver resourceResolver;
    private final FontManager manager;

    public FontAdder(FontManager manager, InternalResourceResolver resourceResolver, FontEventListener listener) {
        this.manager = manager;
        this.resourceResolver = resourceResolver;
        this.listener = listener;
    }

    public void add(List<URL> fontURLList, List<EmbedFontInfo> fontInfoList) throws URISyntaxException {
        FontCache cache = this.manager.getFontCache();
        FontInfoFinder finder = new FontInfoFinder();
        finder.setEventListener(this.listener);
        for (URL fontURL : fontURLList) {
            EmbedFontInfo[] embedFontInfos = finder.find(fontURL.toURI(), this.resourceResolver, cache);
            if (embedFontInfos == null) continue;
            for (EmbedFontInfo fontInfo : embedFontInfos) {
                if (fontInfo == null) continue;
                fontInfoList.add(fontInfo);
            }
        }
    }
}

