# Tutorials

In addition to the basic getting started guides, we offer tutorials that aim to
show how you can use Material for MkDocs in different use cases. In contrast to
the getting started guides or the reference documentation, the tutorials show
the breadth of features available in Material for MkDocs but also within
the wider MkDocs ecosystem.

The tutorials guide you through worked examples, so by following them you should
gain not only an understanding of how to use Material for MkDocs, but also
a template for your own projects. For convenience, these templates are also
available as template repositories on GitHub.

[public version]: ../getting-started.md
[creating your site]: ../creating-your-site.md

!!! note "Feedback wanted!"
    The tutorials are a recent addition to our documentation and we are still
    working out what shape they should have in the end. Please [provide any
    feedback you might have in this discussion thread].

    Note, however, that suggestions should be specific and feasible. We want to
    focus on creating more content at the moment, instead of developing a
    specific styling or behaviour for the tutorials. If there are worthwhile
    improvements that we can make through simple customization then we are happy
    to consider those.

[provide any feedback you might have in this discussion thread]: https://github.com/squidfunk/mkdocs-material/discussions/7220

## Blogs
* [Basics](blogs/basic.md) (20 min) <br/>
  covers the basics of setting up a blog, including post metadata.
* [Navigation, pagination, multiple authors](blogs/navigation.md) (30 min)<br/>
  describes how to make it easier for your readers to find content.
* [Engagement and dissemination](blogs/engage.md) (30 min)<br/>
  walks you through ways of increasing engagement with your content.

[:octicons-repo-template-24: Template Repository](https://github.com/mkdocs-material/create-blog)

## Social cards
* [Basics](social/basic.md) (20 min) <br/>
  shows you how to configure Material for MkDocs to create social cards for
  your content.
* [Custom cards](social/custom.md) (15 min)<br/>
  shows you how to design your own custom social cards.

[:octicons-repo-template-24: Template Repository](https://github.com/mkdocs-material/create-social-cards)
