/*
 * Decompiled with CFR 0.152.
 */
package org.gradle.api.internal.artifacts.ivyservice.ivyresolve;

import java.io.File;
import java.time.Duration;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import java.util.stream.Collectors;
import org.gradle.api.artifacts.ComponentMetadataSupplierDetails;
import org.gradle.api.artifacts.ModuleIdentifier;
import org.gradle.api.artifacts.ModuleVersionIdentifier;
import org.gradle.api.artifacts.component.ComponentArtifactIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentIdentifier;
import org.gradle.api.artifacts.component.ModuleComponentSelector;
import org.gradle.api.internal.artifacts.ComponentMetadataProcessor;
import org.gradle.api.internal.artifacts.DefaultModuleVersionIdentifier;
import org.gradle.api.internal.artifacts.ivyservice.CacheExpirationControl;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ChangingValueDependencyResolutionListener;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepository;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleComponentRepositoryAccess;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.ModuleDescriptorHashModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.ivyresolve.RepositoryChainModuleSource;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleMetadataCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.ModuleRepositoryCaches;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ArtifactAtRepositoryKey;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifact;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.CachedArtifacts;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.artifacts.ModuleArtifactsCache;
import org.gradle.api.internal.artifacts.ivyservice.modulecache.dynamicversions.ModuleVersionsCache;
import org.gradle.api.internal.artifacts.ivyservice.resolveengine.artifact.ResolvableArtifact;
import org.gradle.api.internal.artifacts.repositories.resolver.MetadataFetchingCost;
import org.gradle.api.internal.component.ArtifactType;
import org.gradle.internal.action.InstantiatingAction;
import org.gradle.internal.component.external.model.ExternalModuleComponentGraphResolveState;
import org.gradle.internal.component.external.model.ModuleComponentArtifactMetadata;
import org.gradle.internal.component.external.model.ModuleComponentGraphResolveStateFactory;
import org.gradle.internal.component.external.model.ModuleComponentResolveMetadata;
import org.gradle.internal.component.model.ComponentArtifactMetadata;
import org.gradle.internal.component.model.ComponentArtifactResolveMetadata;
import org.gradle.internal.component.model.ComponentOverrideMetadata;
import org.gradle.internal.component.model.ImmutableModuleSources;
import org.gradle.internal.component.model.ModuleSource;
import org.gradle.internal.component.model.ModuleSources;
import org.gradle.internal.component.model.MutableModuleSources;
import org.gradle.internal.hash.HashCode;
import org.gradle.internal.resolve.ArtifactNotFoundException;
import org.gradle.internal.resolve.ArtifactResolveException;
import org.gradle.internal.resolve.result.BuildableArtifactFileResolveResult;
import org.gradle.internal.resolve.result.BuildableArtifactSetResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleComponentMetaDataResolveResult;
import org.gradle.internal.resolve.result.BuildableModuleVersionListingResolveResult;
import org.gradle.internal.resolve.result.DefaultBuildableModuleComponentMetaDataResolveResult;
import org.gradle.util.internal.BuildCommencedTimeProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CachingModuleComponentRepository
implements ModuleComponentRepository<ExternalModuleComponentGraphResolveState> {
    private static final Logger LOGGER = LoggerFactory.getLogger(CachingModuleComponentRepository.class);
    private final ModuleVersionsCache moduleVersionsCache;
    private final ModuleMetadataCache moduleMetadataCache;
    private final ModuleArtifactsCache moduleArtifactsCache;
    private final ModuleArtifactCache moduleArtifactCache;
    private final ModuleComponentRepository<ModuleComponentResolveMetadata> delegate;
    private final ModuleComponentGraphResolveStateFactory resolveStateFactory;
    private final CacheExpirationControl cacheExpirationControl;
    private final BuildCommencedTimeProvider timeProvider;
    private final ComponentMetadataProcessor metadataProcessor;
    private final ChangingValueDependencyResolutionListener listener;
    private final LocateInCacheRepositoryAccess locateInCacheRepositoryAccess = new LocateInCacheRepositoryAccess();
    private final ResolveAndCacheRepositoryAccess resolveAndCacheRepositoryAccess = new ResolveAndCacheRepositoryAccess();

    public CachingModuleComponentRepository(ModuleComponentRepository<ModuleComponentResolveMetadata> delegate, ModuleRepositoryCaches caches, ModuleComponentGraphResolveStateFactory resolveStateFactory, CacheExpirationControl cacheExpirationControl, BuildCommencedTimeProvider timeProvider, ComponentMetadataProcessor metadataProcessor, ChangingValueDependencyResolutionListener listener) {
        this.delegate = delegate;
        this.moduleMetadataCache = caches.moduleMetadataCache;
        this.moduleVersionsCache = caches.moduleVersionsCache;
        this.moduleArtifactsCache = caches.moduleArtifactsCache;
        this.moduleArtifactCache = caches.moduleArtifactCache;
        this.resolveStateFactory = resolveStateFactory;
        this.cacheExpirationControl = cacheExpirationControl;
        this.timeProvider = timeProvider;
        this.metadataProcessor = metadataProcessor;
        this.listener = listener;
    }

    @Override
    public String getId() {
        return this.delegate.getId();
    }

    @Override
    public String getName() {
        return this.delegate.getName();
    }

    public String toString() {
        return this.delegate.toString();
    }

    @Override
    public ModuleComponentRepositoryAccess<ExternalModuleComponentGraphResolveState> getLocalAccess() {
        return this.locateInCacheRepositoryAccess;
    }

    @Override
    public ModuleComponentRepositoryAccess<ExternalModuleComponentGraphResolveState> getRemoteAccess() {
        return this.resolveAndCacheRepositoryAccess;
    }

    @Override
    public Map<ComponentArtifactIdentifier, ResolvableArtifact> getArtifactCache() {
        throw new UnsupportedOperationException();
    }

    @Override
    public InstantiatingAction<ComponentMetadataSupplierDetails> getComponentMetadataSupplier() {
        return this.delegate.getComponentMetadataSupplier();
    }

    private static ModuleDescriptorHashModuleSource findCachingModuleSource(ModuleSources sources) {
        return sources.getSource(ModuleDescriptorHashModuleSource.class).orElseThrow(() -> new RuntimeException("Cannot find expected module source " + ModuleDescriptorHashModuleSource.class.getSimpleName() + " in " + sources));
    }

    private ModuleComponentResolveMetadata attachRepositorySource(ModuleComponentResolveMetadata processedMetadata) {
        RepositoryChainModuleSource moduleSource = new RepositoryChainModuleSource(this.delegate);
        ModuleSources originSources = processedMetadata.getSources();
        ImmutableModuleSources mergedSources = ImmutableModuleSources.of(originSources, (ModuleSource)moduleSource);
        processedMetadata = processedMetadata.withSources(mergedSources);
        return processedMetadata;
    }

    private String cacheKey(ArtifactType artifactType) {
        return "artifacts:" + artifactType.name();
    }

    private ArtifactAtRepositoryKey artifactCacheKey(ComponentArtifactIdentifier id) {
        return new ArtifactAtRepositoryKey(this.delegate.getId(), id);
    }

    private class LocateInCacheRepositoryAccess
    implements ModuleComponentRepositoryAccess<ExternalModuleComponentGraphResolveState> {
        private LocateInCacheRepositoryAccess() {
        }

        public String toString() {
            return "cache lookup for " + CachingModuleComponentRepository.this.delegate;
        }

        @Override
        public void listModuleVersions(ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata, BuildableModuleVersionListingResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getLocalAccess().listModuleVersions(selector, overrideMetadata, result);
            if (result.hasResult()) {
                return;
            }
            this.listModuleVersionsFromCache(selector, result);
        }

        private void listModuleVersionsFromCache(ModuleComponentSelector selector, BuildableModuleVersionListingResolveResult result) {
            ModuleIdentifier moduleId = selector.getModuleIdentifier();
            ModuleVersionsCache.CachedModuleVersionList cachedModuleVersionList = CachingModuleComponentRepository.this.moduleVersionsCache.getCachedModuleResolution(CachingModuleComponentRepository.this.delegate, moduleId);
            if (cachedModuleVersionList != null) {
                Set<String> versionList = cachedModuleVersionList.getModuleVersions();
                Set<ModuleVersionIdentifier> versions = versionList.stream().map(original -> DefaultModuleVersionIdentifier.newId(moduleId, original)).collect(Collectors.toSet());
                CacheExpirationControl.Expiry expiry = CachingModuleComponentRepository.this.cacheExpirationControl.versionListExpiry(moduleId, versions, cachedModuleVersionList.getAge());
                if (expiry.isMustCheck()) {
                    LOGGER.debug("Version listing in dynamic revision cache is expired: will perform fresh resolve of '{}' in '{}'", (Object)selector, (Object)CachingModuleComponentRepository.this.delegate.getName());
                } else {
                    boolean authoritative = cachedModuleVersionList.getAge().toMillis() == 0L;
                    result.listed(versionList);
                    result.setAuthoritative(authoritative);
                    CachingModuleComponentRepository.this.listener.onDynamicVersionSelection(selector, expiry, versions);
                }
            }
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState> result) {
            DefaultBuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> localResult = new DefaultBuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata>();
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveComponentMetaData(moduleComponentIdentifier, requestMetaData, localResult);
            if (localResult.hasResult()) {
                localResult.applyTo(result, CachingModuleComponentRepository.this.resolveStateFactory::stateFor);
                return;
            }
            this.resolveComponentMetaDataFromCache(moduleComponentIdentifier, requestMetaData, result);
        }

        private void resolveComponentMetaDataFromCache(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState> result) {
            ModuleMetadataCache.CachedMetadata cachedMetadata = CachingModuleComponentRepository.this.moduleMetadataCache.getCachedModuleDescriptor(CachingModuleComponentRepository.this.delegate, moduleComponentIdentifier);
            if (cachedMetadata == null) {
                return;
            }
            if (cachedMetadata.isMissing()) {
                if (CachingModuleComponentRepository.this.cacheExpirationControl.missingModuleExpiry(moduleComponentIdentifier, cachedMetadata.getAge()).isMustCheck()) {
                    LOGGER.debug("Cached meta-data for missing module is expired: will perform fresh resolve of '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                    return;
                }
                LOGGER.debug("Detected non-existence of module '{}' in resolver cache '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                result.missing();
                result.setAuthoritative(cachedMetadata.getAge().toMillis() == 0L);
                return;
            }
            ExternalModuleComponentGraphResolveState state = this.getProcessedMetadata(CachingModuleComponentRepository.this.metadataProcessor.getRulesHash(), cachedMetadata);
            if (requestMetaData.isChanging() || state.getMetadata().isChanging()) {
                CacheExpirationControl.Expiry expiry = CachingModuleComponentRepository.this.cacheExpirationControl.changingModuleExpiry(moduleComponentIdentifier, cachedMetadata.getModuleVersion(), cachedMetadata.getAge());
                if (expiry.isMustCheck()) {
                    LOGGER.debug("Cached meta-data for changing module is expired: will perform fresh resolve of '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                    return;
                }
                LOGGER.debug("Found cached version of changing module '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                CachingModuleComponentRepository.this.listener.onChangingModuleResolve(moduleComponentIdentifier, expiry);
            } else if (CachingModuleComponentRepository.this.cacheExpirationControl.moduleExpiry(moduleComponentIdentifier, cachedMetadata.getModuleVersion(), cachedMetadata.getAge()).isMustCheck()) {
                LOGGER.debug("Cached meta-data for module must be refreshed: will perform fresh resolve of '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
                return;
            }
            LOGGER.debug("Using cached module metadata for module '{}' in '{}'", (Object)moduleComponentIdentifier, (Object)CachingModuleComponentRepository.this.delegate.getName());
            result.resolved(state);
            result.setAuthoritative(cachedMetadata.getAge().toMillis() == 0L);
        }

        private ExternalModuleComponentGraphResolveState getProcessedMetadata(int key, ModuleMetadataCache.CachedMetadata cachedMetadata) {
            ExternalModuleComponentGraphResolveState state = cachedMetadata.getProcessedMetadata(key);
            if (state == null) {
                ModuleComponentResolveMetadata metadata = CachingModuleComponentRepository.this.metadataProcessor.processMetadata(cachedMetadata.getMetadata());
                metadata = CachingModuleComponentRepository.this.attachRepositorySource(metadata);
                state = CachingModuleComponentRepository.this.resolveStateFactory.stateFor(metadata);
                cachedMetadata.putProcessedMetadata(key, state);
            }
            return state;
        }

        @Override
        public void resolveArtifactsWithType(ComponentArtifactResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveArtifactsWithType(component, artifactType, result);
            if (result.hasResult()) {
                return;
            }
            this.resolveModuleArtifactsFromCache(CachingModuleComponentRepository.this.cacheKey(artifactType), component, result);
        }

        private void resolveModuleArtifactsFromCache(String contextId, ComponentArtifactResolveMetadata component, BuildableArtifactSetResolveResult result) {
            CachedArtifacts cachedModuleArtifacts = CachingModuleComponentRepository.this.moduleArtifactsCache.getCachedArtifacts(CachingModuleComponentRepository.this.delegate, component.getId(), contextId);
            ModuleSources sources = component.getSources();
            ModuleDescriptorHashModuleSource cachingModuleSource = CachingModuleComponentRepository.findCachingModuleSource(sources);
            HashCode moduleDescriptorHash = cachingModuleSource.getDescriptorHash();
            if (cachedModuleArtifacts != null) {
                if (!CachingModuleComponentRepository.this.cacheExpirationControl.moduleArtifactsExpiry(component.getModuleVersionId(), null, Duration.ofMillis(cachedModuleArtifacts.getAgeMillis()), cachingModuleSource.isChangingModule(), moduleDescriptorHash.equals((Object)cachedModuleArtifacts.getDescriptorHash())).isMustCheck()) {
                    result.resolved(cachedModuleArtifacts.getArtifacts());
                    return;
                }
                LOGGER.debug("Artifact listing has expired: will perform fresh resolve of '{}' for '{}' in '{}'", new Object[]{contextId, component.getModuleVersionId(), CachingModuleComponentRepository.this.delegate.getName()});
            }
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactFileResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getLocalAccess().resolveArtifact(artifact, moduleSources, result);
            if (result.hasResult()) {
                return;
            }
            this.resolveArtifactFromCache(artifact, moduleSources, result);
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            ModuleMetadataCache.CachedMetadata cachedMetadata = CachingModuleComponentRepository.this.moduleMetadataCache.getCachedModuleDescriptor(CachingModuleComponentRepository.this.delegate, moduleComponentIdentifier);
            if (cachedMetadata == null) {
                return this.estimateCostViaRemoteAccess(moduleComponentIdentifier);
            }
            if (cachedMetadata.isMissing()) {
                if (CachingModuleComponentRepository.this.cacheExpirationControl.missingModuleExpiry(moduleComponentIdentifier, cachedMetadata.getAge()).isMustCheck()) {
                    return this.estimateCostViaRemoteAccess(moduleComponentIdentifier);
                }
                return MetadataFetchingCost.CHEAP;
            }
            ExternalModuleComponentGraphResolveState state = this.getProcessedMetadata(CachingModuleComponentRepository.this.metadataProcessor.getRulesHash(), cachedMetadata);
            if (state.getMetadata().isChanging() ? CachingModuleComponentRepository.this.cacheExpirationControl.changingModuleExpiry(moduleComponentIdentifier, cachedMetadata.getModuleVersion(), cachedMetadata.getAge()).isMustCheck() : CachingModuleComponentRepository.this.cacheExpirationControl.moduleExpiry(moduleComponentIdentifier, cachedMetadata.getModuleVersion(), cachedMetadata.getAge()).isMustCheck()) {
                return this.estimateCostViaRemoteAccess(moduleComponentIdentifier);
            }
            return MetadataFetchingCost.FAST;
        }

        private MetadataFetchingCost estimateCostViaRemoteAccess(ModuleComponentIdentifier moduleComponentIdentifier) {
            return CachingModuleComponentRepository.this.delegate.getRemoteAccess().estimateMetadataFetchingCost(moduleComponentIdentifier);
        }

        private void resolveArtifactFromCache(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactFileResolveResult result) {
            CachedArtifact cached = CachingModuleComponentRepository.this.moduleArtifactCache.lookup(CachingModuleComponentRepository.this.artifactCacheKey(artifact.getId()));
            if (cached != null) {
                ModuleDescriptorHashModuleSource moduleSource = CachingModuleComponentRepository.findCachingModuleSource(moduleSources);
                HashCode descriptorHash = moduleSource.getDescriptorHash();
                Duration age = Duration.ofMillis(CachingModuleComponentRepository.this.timeProvider.getCurrentTime() - cached.getCachedAt());
                boolean isChangingModule = moduleSource.isChangingModule();
                ModuleComponentArtifactMetadata moduleComponentArtifactMetadata = (ModuleComponentArtifactMetadata)artifact;
                if (cached.isMissing()) {
                    CacheExpirationControl.Expiry expiry = CachingModuleComponentRepository.this.cacheExpirationControl.artifactExpiry(moduleComponentArtifactMetadata, null, age, isChangingModule, descriptorHash.equals((Object)cached.getDescriptorHash()));
                    if (!expiry.isMustCheck()) {
                        LOGGER.debug("Detected non-existence of artifact '{}' in resolver cache", (Object)artifact);
                        for (String location : cached.attemptedLocations()) {
                            result.attempted(location);
                        }
                        result.notFound(artifact.getId());
                    }
                } else {
                    File cachedArtifactFile = cached.getCachedFile();
                    CacheExpirationControl.Expiry expiry = CachingModuleComponentRepository.this.cacheExpirationControl.artifactExpiry(moduleComponentArtifactMetadata, cachedArtifactFile, age, isChangingModule, descriptorHash.equals((Object)cached.getDescriptorHash()));
                    if (!expiry.isMustCheck()) {
                        LOGGER.debug("Found artifact '{}' in resolver cache: {}", (Object)artifact, (Object)cachedArtifactFile);
                        result.resolved(cachedArtifactFile);
                    }
                }
            }
        }
    }

    private class ResolveAndCacheRepositoryAccess
    implements ModuleComponentRepositoryAccess<ExternalModuleComponentGraphResolveState> {
        private ResolveAndCacheRepositoryAccess() {
        }

        public String toString() {
            return "cache > " + CachingModuleComponentRepository.this.delegate.getRemoteAccess();
        }

        @Override
        public void listModuleVersions(ModuleComponentSelector selector, ComponentOverrideMetadata overrideMetadata, BuildableModuleVersionListingResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().listModuleVersions(selector, overrideMetadata, result);
            switch (result.getState()) {
                case Listed: {
                    ModuleIdentifier moduleId = selector.getModuleIdentifier();
                    Set<String> versionList = result.getVersions();
                    Set<ModuleVersionIdentifier> versions = versionList.stream().map(original -> DefaultModuleVersionIdentifier.newId(moduleId, original)).collect(Collectors.toSet());
                    CachingModuleComponentRepository.this.moduleVersionsCache.cacheModuleVersionList(CachingModuleComponentRepository.this.delegate, moduleId, versionList);
                    CachingModuleComponentRepository.this.listener.onDynamicVersionSelection(selector, CachingModuleComponentRepository.this.cacheExpirationControl.versionListExpiry(moduleId, versions, Duration.ZERO), versions);
                    break;
                }
                case Failed: {
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected state on listModuleVersions: " + (Object)((Object)result.getState()));
                }
            }
        }

        @Override
        public void resolveComponentMetaData(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState> result) {
            this.resolveComponentMetaDataAndCache(moduleComponentIdentifier, requestMetaData, result);
        }

        private void resolveComponentMetaDataAndCache(ModuleComponentIdentifier moduleComponentIdentifier, ComponentOverrideMetadata requestMetaData, BuildableModuleComponentMetaDataResolveResult<ExternalModuleComponentGraphResolveState> result) {
            ComponentOverrideMetadata forced = requestMetaData.withChanging();
            DefaultBuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata> localResult = new DefaultBuildableModuleComponentMetaDataResolveResult<ModuleComponentResolveMetadata>();
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveComponentMetaData(moduleComponentIdentifier, forced, localResult);
            switch (localResult.getState()) {
                case Missing: {
                    CachingModuleComponentRepository.this.moduleMetadataCache.cacheMissing(CachingModuleComponentRepository.this.delegate, moduleComponentIdentifier);
                    localResult.applyTo(result, metadata -> {
                        throw new IllegalStateException();
                    });
                    break;
                }
                case Resolved: {
                    ModuleComponentResolveMetadata resolvedMetadata = (ModuleComponentResolveMetadata)localResult.getMetaData();
                    ModuleMetadataCache.CachedMetadata cachedMetadata = CachingModuleComponentRepository.this.moduleMetadataCache.cacheMetaData(CachingModuleComponentRepository.this.delegate, moduleComponentIdentifier, resolvedMetadata);
                    ModuleComponentResolveMetadata processedMetadata = CachingModuleComponentRepository.this.metadataProcessor.processMetadata(resolvedMetadata);
                    processedMetadata = CachingModuleComponentRepository.this.attachRepositorySource(processedMetadata);
                    if (processedMetadata.isChanging() || requestMetaData.isChanging()) {
                        processedMetadata = this.makeChanging(processedMetadata);
                        CacheExpirationControl.Expiry expiry = CachingModuleComponentRepository.this.cacheExpirationControl.changingModuleExpiry(moduleComponentIdentifier, cachedMetadata.getModuleVersion(), Duration.ZERO);
                        CachingModuleComponentRepository.this.listener.onChangingModuleResolve(moduleComponentIdentifier, expiry);
                    }
                    ExternalModuleComponentGraphResolveState state = CachingModuleComponentRepository.this.resolveStateFactory.stateFor(processedMetadata);
                    cachedMetadata.putProcessedMetadata(CachingModuleComponentRepository.this.metadataProcessor.getRulesHash(), state);
                    localResult.applyTo(result);
                    result.resolved(state);
                    break;
                }
                case Failed: {
                    localResult.applyTo(result, metadata -> {
                        throw new IllegalStateException();
                    });
                    break;
                }
                default: {
                    throw new IllegalStateException("Unexpected resolve state: " + (Object)((Object)result.getState()));
                }
            }
        }

        private ModuleComponentResolveMetadata makeChanging(ModuleComponentResolveMetadata processedMetadata) {
            MutableModuleSources sources = new MutableModuleSources();
            processedMetadata.getSources().withSources(src -> {
                if (src instanceof ModuleDescriptorHashModuleSource) {
                    ModuleDescriptorHashModuleSource changingSource = new ModuleDescriptorHashModuleSource(((ModuleDescriptorHashModuleSource)src).getDescriptorHash(), true);
                    sources.add(changingSource);
                } else {
                    sources.add((ModuleSource)src);
                }
            });
            return processedMetadata.withSources(sources);
        }

        @Override
        public void resolveArtifactsWithType(ComponentArtifactResolveMetadata component, ArtifactType artifactType, BuildableArtifactSetResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveArtifactsWithType(component, artifactType, result);
            if (result.getFailure() == null) {
                ModuleDescriptorHashModuleSource moduleSource = CachingModuleComponentRepository.findCachingModuleSource(component.getSources());
                CachingModuleComponentRepository.this.moduleArtifactsCache.cacheArtifacts(CachingModuleComponentRepository.this.delegate, component.getId(), CachingModuleComponentRepository.this.cacheKey(artifactType), moduleSource.getDescriptorHash(), (Collection)result.getResult());
            }
        }

        @Override
        public void resolveArtifact(ComponentArtifactMetadata artifact, ModuleSources moduleSources, BuildableArtifactFileResolveResult result) {
            CachingModuleComponentRepository.this.delegate.getRemoteAccess().resolveArtifact(artifact, moduleSources, result);
            LOGGER.debug("Downloaded artifact '{}' from resolver: {}", (Object)artifact, (Object)CachingModuleComponentRepository.this.delegate.getName());
            ArtifactResolveException failure = result.getFailure();
            ModuleDescriptorHashModuleSource cachingModuleSource = CachingModuleComponentRepository.findCachingModuleSource(moduleSources);
            if (failure == null) {
                CachingModuleComponentRepository.this.moduleArtifactCache.store(CachingModuleComponentRepository.this.artifactCacheKey(artifact.getId()), result.getResult(), cachingModuleSource.getDescriptorHash());
            } else if (failure instanceof ArtifactNotFoundException) {
                CachingModuleComponentRepository.this.moduleArtifactCache.storeMissing(CachingModuleComponentRepository.this.artifactCacheKey(artifact.getId()), result.getAttempted(), cachingModuleSource.getDescriptorHash());
            }
        }

        @Override
        public MetadataFetchingCost estimateMetadataFetchingCost(ModuleComponentIdentifier moduleComponentIdentifier) {
            return CachingModuleComponentRepository.this.delegate.getLocalAccess().estimateMetadataFetchingCost(moduleComponentIdentifier);
        }
    }
}

