SYD-AES(1)

# NAME

syd-aes - AES-CTR encryption and decryption utility

# SYNOPSIS

*syd-aes* _[-hv]_ _-e|-d_ _-k <key-hex>_ _-i <iv-hex>_ _-t <tag-str>_

# DESCRIPTION

The *syd-aes* utility uses the Linux Kernel Cryptography API to encrypt
and decrypt data using AES-CTR mode. It supports both encryption and
decryption operations, with the key and IV provided as hexadecimal
strings. Given data from standard input, *syd-aes* performs the
specified operation and outputs the result to standard output.
*syd-aes* uses pipes and _splice_(2) to transfer data using zero-copy,
and therefore able to encrypt/decrypt files of arbitrary size.

# OPTIONS

|[ *-h*
:< Display help.
|[ *-v*
:< Enable verbose mode. If standard error is a terminal, print progress
   updates periodically, similar to *dd*(1).
|[ *-e*
:< Encrypt the input data.
|[ *-d*
:< Decrypt the input data.
|[ *-k <key>*
:< Hex-encoded key (256 bits).
|[ *-i <iv>*
:< Hex-encoded IV (128 bits).
|[ *-t <tag>*
:< Information tag for HKDF (optional, max is 255 x 32 = 8160 bytes).

# SEE ALSO

_syd_(1), _syd_(2), _syd_(5), _splice_(2), _syd-key_(1)

*syd* homepage: https://sydbox.exherbo.org/

# AUTHORS

Maintained by Ali Polatel. Up-to-date sources can be found at
https://gitlab.exherbo.org/sydbox/sydbox.git and bugs/patches can be
submitted to https://gitlab.exherbo.org/groups/sydbox/-/issues. Discuss
in #sydbox on Libera Chat or in #sydbox:mailstation.de on Matrix.
