/*
 * Decompiled with CFR 0.152.
 */
package org.signal.libsignal.net;

import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.signal.libsignal.internal.CalledFromNative;
import org.signal.libsignal.internal.CompletableFuture;
import org.signal.libsignal.internal.Native;
import org.signal.libsignal.internal.NativeHandleGuard;
import org.signal.libsignal.internal.NativeTesting;
import org.signal.libsignal.internal.TokioAsyncContext;
import org.signal.libsignal.net.FakeChatServer;
import org.signal.libsignal.net.Network;
import org.signal.libsignal.net.RegisterAccountResponse;
import org.signal.libsignal.net.RegistrationSessionState;
import org.signal.libsignal.protocol.ServiceId;
import org.signal.libsignal.protocol.SignedPublicPreKey;
import org.signal.libsignal.protocol.ecc.ECPublicKey;
import org.signal.libsignal.protocol.kem.KEMPublicKey;

public class RegistrationService
extends NativeHandleGuard.SimpleOwner {
    private TokioAsyncContext tokioAsyncContext;

    public static CompletableFuture<RegistrationService> createSession(Network network, CreateSession createSession) {
        TokioAsyncContext tokioAsyncContext = network.getAsyncContext();
        return tokioAsyncContext.guardedMap(asyncContext -> Native.RegistrationService_CreateSession(asyncContext, createSession, network.getConnectionManager())).thenApply(nativeHandle -> new RegistrationService((long)nativeHandle, tokioAsyncContext));
    }

    public static CompletableFuture<RegistrationService> resumeSession(Network network, String sessionId, String number) {
        TokioAsyncContext tokioAsyncContext = network.getAsyncContext();
        return tokioAsyncContext.guardedMap(asyncContext -> Native.RegistrationService_ResumeSession(asyncContext, sessionId, number, network.getConnectionManager())).thenApply(nativeHandle -> new RegistrationService((long)nativeHandle, tokioAsyncContext));
    }

    public CompletableFuture<Void> requestPushChallenge(String fcmPushToken) {
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_RequestPushChallenge(asyncContextHandle, nativeHandle, fcmPushToken)));
    }

    public CompletableFuture<Void> submitPushChallenge(String pushChallenge) {
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_SubmitPushChallenge(asyncContextHandle, nativeHandle, pushChallenge)));
    }

    public CompletableFuture<Void> requestVerificationCode(VerificationTransport transport, String client, Locale locale) {
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_RequestVerificationCode(asyncContextHandle, nativeHandle, transport.name().toLowerCase(), client, Network.languageCodesForLocale(locale))));
    }

    public CompletableFuture<Void> submitVerificationCode(String code) {
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_SubmitVerificationCode(asyncContextHandle, nativeHandle, code)));
    }

    public CompletableFuture<Void> submitCaptcha(String captchaValue) {
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_SubmitCaptcha(asyncContextHandle, nativeHandle, captchaValue)));
    }

    public CompletableFuture<Map<String, Svr2CredentialsResult>> checkSvr2Credentials(String[] svrTokens) {
        return this.guardedMap(nativeHandle -> this.tokioAsyncContext.guardedMap(asyncContextHandle -> Native.RegistrationService_CheckSvr2Credentials(asyncContextHandle, nativeHandle, svrTokens))).thenApply(result -> {
            Map resultMap = (Map)result;
            return resultMap;
        });
    }

    public String getSessionId() {
        return this.guardedMap(Native::RegistrationService_SessionId);
    }

    public RegistrationSessionState getSessionState() {
        return this.guardedMap(nativeHandle -> new RegistrationSessionState(Native.RegistrationService_RegistrationSession(nativeHandle)));
    }

    public CompletableFuture<RegisterAccountResponse> registerAccount(String accountPassword, boolean skipDeviceTransfer, AccountAttributes accountAttributes, String gcmPushToken, ECPublicKey aciPublicKey, ECPublicKey pniPublicKey, SignedPublicPreKey<ECPublicKey> aciSignedPreKey, SignedPublicPreKey<ECPublicKey> pniSignedPreKey, SignedPublicPreKey<KEMPublicKey> aciPqLastResortPreKey, SignedPublicPreKey<KEMPublicKey> pniPqLastResortPreKey) {
        RegisterAccountRequest request = new RegisterAccountRequest(accountPassword, skipDeviceTransfer, gcmPushToken, aciPublicKey, pniPublicKey, aciSignedPreKey, pniSignedPreKey, aciPqLastResortPreKey, pniPqLastResortPreKey);
        return this.tokioAsyncContext.guardedMap(tokioContext -> accountAttributes.guardedMap(attributesHandle -> this.guardedMap(service -> request.guardedMap(register -> Native.RegistrationService_RegisterAccount(tokioContext, service, register, attributesHandle))))).thenApply(responseHandle -> new RegisterAccountResponse((long)responseHandle));
    }

    public static CompletableFuture<RegisterAccountResponse> reregisterAccount(Network network, String number, String accountPassword, boolean skipDeviceTransfer, AccountAttributes accountAttributes, String gcmPushToken, ECPublicKey aciPublicKey, ECPublicKey pniPublicKey, SignedPublicPreKey<ECPublicKey> aciSignedPreKey, SignedPublicPreKey<ECPublicKey> pniSignedPreKey, SignedPublicPreKey<KEMPublicKey> aciPqLastResortPreKey, SignedPublicPreKey<KEMPublicKey> pniPqLastResortPreKey) {
        RegisterAccountRequest request = new RegisterAccountRequest(accountPassword, skipDeviceTransfer, gcmPushToken, aciPublicKey, pniPublicKey, aciSignedPreKey, pniSignedPreKey, aciPqLastResortPreKey, pniPqLastResortPreKey);
        TokioAsyncContext tokioAsyncContext = network.getAsyncContext();
        return tokioAsyncContext.guardedMap(tokioContext -> accountAttributes.guardedMap(attributesHandle -> request.guardedMap(register -> Native.RegistrationService_ReregisterAccount(tokioContext, network.getConnectionManager(), number, register, attributesHandle)))).thenApply(responseHandle -> new RegisterAccountResponse((long)responseHandle));
    }

    static CompletableFuture<RegistrationService> fakeCreateSession(FakeChatServer fakeServer, CreateSession createSession) {
        TokioAsyncContext asyncContext = fakeServer.getTokioContext();
        return asyncContext.guardedMap(tokioContext -> fakeServer.guardedMap(fakeChat -> NativeTesting.TESTING_FakeRegistrationSession_CreateSession(tokioContext, createSession, fakeChat))).thenApply(registration -> new RegistrationService((long)registration, asyncContext));
    }

    private RegistrationService(long nativeHandle, TokioAsyncContext tokioAsyncContext) {
        super(nativeHandle);
        this.tokioAsyncContext = tokioAsyncContext;
    }

    @Override
    protected void release(long nativeHandle) {
        Native.RegistrationService_Destroy(nativeHandle);
    }

    public record CreateSession(String number, String fcmPushToken, String mcc, String mnc) {
    }

    public static enum VerificationTransport {
        SMS,
        VOICE;

    }

    private static class RegisterAccountRequest
    extends NativeHandleGuard.SimpleOwner {
        public RegisterAccountRequest() {
            super(Native.RegisterAccountRequest_Create());
        }

        public RegisterAccountRequest(String accountPassword, boolean skipDeviceTransfer, String gcmPushToken, ECPublicKey aciPublicKey, ECPublicKey pniPublicKey, SignedPublicPreKey<ECPublicKey> aciSignedPreKey, SignedPublicPreKey<ECPublicKey> pniSignedPreKey, SignedPublicPreKey<KEMPublicKey> aciPqLastResortPreKey, SignedPublicPreKey<KEMPublicKey> pniPqLastResortPreKey) {
            this();
            int ACI = ServiceId.Kind.ACI.ordinal();
            int PNI = ServiceId.Kind.PNI.ordinal();
            this.guardedRun(requestHandle -> {
                Native.RegisterAccountRequest_SetAccountPassword(requestHandle, accountPassword);
                Native.RegisterAccountRequest_SetGcmPushToken(requestHandle, gcmPushToken);
                aciPublicKey.guardedRun(handle -> Native.RegisterAccountRequest_SetIdentityPublicKey(requestHandle, ACI, handle));
                pniPublicKey.guardedRun(handle -> Native.RegisterAccountRequest_SetIdentityPublicKey(requestHandle, PNI, handle));
                Native.RegisterAccountRequest_SetIdentitySignedPreKey(requestHandle, ACI, aciSignedPreKey);
                Native.RegisterAccountRequest_SetIdentitySignedPreKey(requestHandle, PNI, pniSignedPreKey);
                Native.RegisterAccountRequest_SetIdentityPqLastResortPreKey(requestHandle, ACI, aciPqLastResortPreKey);
                Native.RegisterAccountRequest_SetIdentityPqLastResortPreKey(requestHandle, PNI, pniPqLastResortPreKey);
                if (skipDeviceTransfer) {
                    Native.RegisterAccountRequest_SetSkipDeviceTransfer(requestHandle);
                }
            });
        }

        @Override
        protected void release(long nativeHandle) {
            Native.RegisterAccountRequest_Destroy(nativeHandle);
        }
    }

    public static class AccountAttributes
    extends NativeHandleGuard.SimpleOwner {
        public AccountAttributes(byte[] recoveryPassword, int aciRegistrationId, int pniRegistrationId, String registrationLock, byte[] unidentifiedAccessKey, boolean unrestrictedUnidentifiedAccess, Set<String> capabilities, boolean discoverableByPhoneNumber) {
            super(Native.RegistrationAccountAttributes_Create(recoveryPassword, aciRegistrationId, pniRegistrationId, registrationLock, unidentifiedAccessKey, unrestrictedUnidentifiedAccess, capabilities.toArray(String[]::new), discoverableByPhoneNumber));
        }

        @Override
        protected void release(long nativeHandle) {
            Native.RegistrationAccountAttributes_Destroy(nativeHandle);
        }
    }

    @CalledFromNative
    public static enum Svr2CredentialsResult {
        MATCH,
        NO_MATCH,
        INVALID;

    }
}

