/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.IOException;
import java.lang.runtime.SwitchBootstraps;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.IOErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.json.JsonSendMessageResult;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.manager.api.GroupId;
import org.asamk.signal.manager.api.GroupInviteLinkUrl;
import org.asamk.signal.manager.api.InactiveGroupLinkException;
import org.asamk.signal.manager.api.Pair;
import org.asamk.signal.manager.api.PendingAdminApprovalException;
import org.asamk.signal.manager.api.SendGroupMessageResults;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;
import org.asamk.signal.util.SendMessageResultUtils;

public class JoinGroupCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "joinGroup";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Join a group via an invitation link.");
        subparser.addArgument(new String[]{"--uri"}).required(true).help("Specify the uri with the group invitation link.");
    }

    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        GroupInviteLinkUrl linkUrl;
        String uri = ns.getString("uri");
        try {
            linkUrl = GroupInviteLinkUrl.fromUri((String)uri);
        }
        catch (GroupInviteLinkUrl.InvalidGroupLinkException e) {
            throw new UserErrorException("Group link is invalid: " + e.getMessage());
        }
        catch (GroupInviteLinkUrl.UnknownGroupLinkVersionException e) {
            throw new UserErrorException("Group link was created with an incompatible version: " + e.getMessage());
        }
        if (linkUrl == null) {
            throw new UserErrorException("Link is not a signal group invitation link");
        }
        try {
            Pair results = m.joinGroup(linkUrl);
            GroupId newGroupId = (GroupId)results.first();
            OutputWriter outputWriter2 = outputWriter;
            Objects.requireNonNull(outputWriter2);
            OutputWriter outputWriter3 = outputWriter2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{JsonWriter.class, PlainTextWriter.class}, (Object)outputWriter3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    JsonWriter writer = (JsonWriter)outputWriter3;
                    List<JsonSendMessageResult> jsonResults = SendMessageResultUtils.getJsonSendMessageResults(((SendGroupMessageResults)results.second()).results());
                    if (!m.getGroup(newGroupId).isMember()) {
                        writer.write(Map.of("timestamp", ((SendGroupMessageResults)results.second()).timestamp(), "results", jsonResults, "groupId", newGroupId.toBase64(), "onlyRequested", true));
                        break;
                    }
                    writer.write(Map.of("timestamp", ((SendGroupMessageResults)results.second()).timestamp(), "results", jsonResults, "groupId", newGroupId.toBase64()));
                    break;
                }
                case 1: {
                    PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                    if (!m.getGroup(newGroupId).isMember()) {
                        writer.println("Requested to join group \"{}\"", newGroupId.toBase64());
                    } else {
                        writer.println("Joined group \"{}\"", newGroupId.toBase64());
                    }
                    List<String> errors = SendMessageResultUtils.getErrorMessagesFromSendMessageResults(((SendGroupMessageResults)results.second()).results());
                    SendMessageResultUtils.printSendMessageResultErrors(writer, errors);
                    writer.println("{}", ((SendGroupMessageResults)results.second()).timestamp());
                }
            }
        }
        catch (IOException e) {
            throw new IOErrorException("Failed to send message: " + e.getMessage() + " (" + e.getClass().getSimpleName() + ")", e);
        }
        catch (InactiveGroupLinkException e) {
            throw new UserErrorException("Group link is not valid: " + e.getMessage());
        }
        catch (PendingAdminApprovalException e) {
            throw new UserErrorException("Pending admin approval: " + e.getMessage());
        }
    }
}

