/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.commands;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.lang.runtime.SwitchBootstraps;
import java.util.Base64;
import java.util.Objects;
import net.sourceforge.argparse4j.inf.MutuallyExclusiveGroup;
import net.sourceforge.argparse4j.inf.Namespace;
import net.sourceforge.argparse4j.inf.Subparser;
import org.asamk.signal.commands.JsonRpcLocalCommand;
import org.asamk.signal.commands.exceptions.CommandException;
import org.asamk.signal.commands.exceptions.UnexpectedErrorException;
import org.asamk.signal.commands.exceptions.UserErrorException;
import org.asamk.signal.json.JsonAttachmentData;
import org.asamk.signal.manager.Manager;
import org.asamk.signal.output.JsonWriter;
import org.asamk.signal.output.OutputWriter;
import org.asamk.signal.output.PlainTextWriter;

public class GetAttachmentCommand
implements JsonRpcLocalCommand {
    @Override
    public String getName() {
        return "getAttachment";
    }

    @Override
    public void attachToSubparser(Subparser subparser) {
        subparser.help("Retrieve an already downloaded attachment base64 encoded.");
        subparser.addArgument(new String[]{"--id"}).required(true).help("The ID of the attachment file.");
        MutuallyExclusiveGroup mut = subparser.addMutuallyExclusiveGroup().required(true);
        mut.addArgument(new String[]{"--recipient"}).help("Sender of the attachment");
        mut.addArgument(new String[]{"-g", "--group-id"}).help("Group in which the attachment was received");
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public void handleCommand(Namespace ns, Manager m, OutputWriter outputWriter) throws CommandException {
        String id = ns.getString("id");
        try (InputStream attachment = m.retrieveAttachment(id);){
            byte[] bytes = attachment.readAllBytes();
            String base64 = Base64.getEncoder().encodeToString(bytes);
            OutputWriter outputWriter2 = outputWriter;
            Objects.requireNonNull(outputWriter2);
            OutputWriter outputWriter3 = outputWriter2;
            int n = 0;
            switch (SwitchBootstraps.typeSwitch("typeSwitch", new Object[]{PlainTextWriter.class, JsonWriter.class}, (Object)outputWriter3, n)) {
                default: {
                    throw new MatchException(null, null);
                }
                case 0: {
                    PlainTextWriter writer = (PlainTextWriter)outputWriter3;
                    writer.println(base64, new Object[0]);
                    return;
                }
                case 1: {
                    JsonWriter writer = (JsonWriter)outputWriter3;
                    writer.write(new JsonAttachmentData(base64));
                    return;
                }
            }
        }
        catch (FileNotFoundException ex) {
            throw new UserErrorException("Could not find attachment with ID: " + id, ex);
        }
        catch (IOException ex) {
            throw new UnexpectedErrorException("An error occurred reading attachment: " + id, ex);
        }
    }
}

