/*
 * Decompiled with CFR 0.152.
 */
package org.signal.core.util;

import com.google.i18n.phonenumbers.NumberParseException;
import com.google.i18n.phonenumbers.PhoneNumberUtil;
import com.google.i18n.phonenumbers.Phonenumber;
import com.google.i18n.phonenumbers.ShortNumberInfo;
import java.util.Locale;
import java.util.Optional;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import kotlin.Metadata;
import kotlin.collections.SetsKt;
import kotlin.jvm.JvmStatic;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.text.Regex;
import kotlin.text.StringsKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.signal.core.util.BidiUtil;
import org.signal.core.util.StringExtensionsKt;
import org.signal.core.util.logging.Log;

@Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000N\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010\b\n\u0002\b\u0002\n\u0002\u0010\"\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u000b\b\u00c6\u0002\u0018\u00002\u00020\u0001:\u0001*B\t\b\u0002\u00a2\u0006\u0004\b\u0002\u0010\u0003J\u000e\u0010\u0012\u001a\u00020\u00132\u0006\u0010\u0014\u001a\u00020\u0005J\u000e\u0010\u0015\u001a\u00020\u00132\u0006\u0010\u0016\u001a\u00020\u0005J\u001a\u0010\u0017\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\u00052\b\u0010\u0019\u001a\u0004\u0018\u00010\u0005H\u0007J\u0018\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0007J\u0018\u0010\u001c\u001a\b\u0012\u0004\u0012\u00020\u00050\u001d2\b\u0010\u0016\u001a\u0004\u0018\u00010\u0005H\u0007J\u001a\u0010\u001e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J.\u0010\u001f\u001a\u0004\u0018\u00010\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0016\u001a\u00020\u00052\u0006\u0010\u0019\u001a\u00020\u0005H\u0002J\u001a\u0010\"\u001a\u0004\u0018\u00010\u00052\u0006\u0010#\u001a\u00020\u00052\u0006\u0010\u0018\u001a\u00020\fH\u0002J$\u0010$\u001a\u00020\u00052\b\u0010\u0014\u001a\u0004\u0018\u00010 2\b\u0010!\u001a\u0004\u0018\u00010\u00052\u0006\u0010%\u001a\u00020\u0005H\u0002J\f\u0010&\u001a\u00020\u0005*\u00020\u0005H\u0002J\f\u0010'\u001a\u00020\u0005*\u00020\u0005H\u0002J\f\u0010(\u001a\u00020\u0005*\u00020\u0005H\u0002J\f\u0010)\u001a\u00020\u0005*\u00020\u0005H\u0002R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0006\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0007\u001a\u00020\u0005X\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\b\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\n\u001a\u00020\tX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u000b\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u000e\u0010\r\u001a\u00020\fX\u0082T\u00a2\u0006\u0002\n\u0000R\u0014\u0010\u000e\u001a\b\u0012\u0004\u0012\u00020\f0\u000fX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0010\u001a\u00020\u0011X\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006+"}, d2={"Lorg/signal/core/util/E164Util;", "", "<init>", "()V", "TAG", "", "COUNTRY_CODE_BR", "COUNTRY_CODE_US", "US_NO_AREACODE", "Ljava/util/regex/Pattern;", "BR_NO_AREACODE", "COUNTRY_CODE_US_INT", "", "COUNTRY_CODE_UK_INT", "NATIONAL_FORMAT_COUNTRY_CODES", "", "INVALID_CHARACTERS_REGEX", "Lkotlin/text/Regex;", "createFormatterForE164", "Lorg/signal/core/util/E164Util$Formatter;", "localNumber", "createFormatterForRegionCode", "regionCode", "formatAsE164WithCountryCodeForDisplay", "countryCode", "input", "isValidNumberForRegistration", "", "getRegionDisplayName", "Ljava/util/Optional;", "formatAsE164WithCountryCode", "formatAsE164WithRegionCode", "Lcom/google/i18n/phonenumbers/Phonenumber$PhoneNumber;", "localAreaCode", "parseAreaCode", "e164Number", "applyAreaCodeRules", "testNumber", "numbersOnly", "e164CharsOnly", "stripLeadingZerosFromInput", "stripLeadingZerosFromE164", "Formatter", "core-util-jvm"})
@SourceDebugExtension(value={"SMAP\nE164Util.kt\nKotlin\n*S Kotlin\n*F\n+ 1 E164Util.kt\norg/signal/core/util/E164Util\n+ 2 _Strings.kt\nkotlin/text/StringsKt___StringsKt\n*L\n1#1,297:1\n434#2:298\n507#2,5:299\n434#2:304\n507#2,5:305\n*S KotlinDebug\n*F\n+ 1 E164Util.kt\norg/signal/core/util/E164Util\n*L\n211#1:298\n211#1:299,5\n215#1:304\n215#1:305,5\n*E\n"})
public final class E164Util {
    @NotNull
    public static final E164Util INSTANCE = new E164Util();
    @NotNull
    private static final String TAG = Log.tag(Reflection.getOrCreateKotlinClass(E164Util.class));
    @NotNull
    private static final String COUNTRY_CODE_BR = "55";
    @NotNull
    private static final String COUNTRY_CODE_US = "1";
    @NotNull
    private static final Pattern US_NO_AREACODE;
    @NotNull
    private static final Pattern BR_NO_AREACODE;
    private static final int COUNTRY_CODE_US_INT = 1;
    private static final int COUNTRY_CODE_UK_INT = 44;
    @NotNull
    private static final Set<Integer> NATIONAL_FORMAT_COUNTRY_CODES;
    @NotNull
    private static final Regex INVALID_CHARACTERS_REGEX;

    private E164Util() {
    }

    @NotNull
    public final Formatter createFormatterForE164(@NotNull String localNumber) {
        Intrinsics.checkNotNullParameter((Object)localNumber, (String)"localNumber");
        Phonenumber.PhoneNumber phoneNumber = PhoneNumberUtil.getInstance().parse((CharSequence)localNumber, null);
        String string = PhoneNumberUtil.getInstance().getRegionCodeForNumber(phoneNumber);
        if (string == null) {
            string = PhoneNumberUtil.getInstance().getRegionCodeForCountryCode(phoneNumber.getCountryCode());
        }
        String regionCode = string;
        String areaCode = this.parseAreaCode(localNumber, phoneNumber.getCountryCode());
        Intrinsics.checkNotNull((Object)regionCode);
        return new Formatter(phoneNumber, areaCode, regionCode);
    }

    @NotNull
    public final Formatter createFormatterForRegionCode(@NotNull String regionCode) {
        Intrinsics.checkNotNullParameter((Object)regionCode, (String)"regionCode");
        return new Formatter(null, null, regionCode);
    }

    @JvmStatic
    @NotNull
    public static final String formatAsE164WithCountryCodeForDisplay(@NotNull String countryCode, @Nullable String input) {
        String input2;
        String result;
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        String string = input;
        if (string == null) {
            string = "";
        }
        if ((result = INSTANCE.formatAsE164WithCountryCode(countryCode, input2 = string)) != null) {
            return result;
        }
        CharSequence charSequence = INSTANCE.numbersOnly(countryCode);
        Regex regex = new Regex("^0*");
        String string2 = "";
        String cleanCountryCode = regex.replace(charSequence, string2);
        String cleanNumber = INSTANCE.numbersOnly(input2);
        return "+" + cleanCountryCode + cleanNumber;
    }

    @JvmStatic
    public static final boolean isValidNumberForRegistration(@NotNull String countryCode, @NotNull String input) {
        Intrinsics.checkNotNullParameter((Object)countryCode, (String)"countryCode");
        Intrinsics.checkNotNullParameter((Object)input, (String)"input");
        if (!PhoneNumberUtil.getInstance().isPossibleNumber((CharSequence)input, countryCode)) {
            Log.w(TAG, "Failed isPossibleNumber()");
            return false;
        }
        if (Intrinsics.areEqual((Object)COUNTRY_CODE_US, (Object)countryCode) && !Pattern.matches("^\\+1[0-9]{10}$", input)) {
            Log.w(TAG, "Failed US number format check");
            return false;
        }
        if (Intrinsics.areEqual((Object)COUNTRY_CODE_BR, (Object)countryCode) && !Pattern.matches("^\\+55[0-9]{2}9?[0-9]{8}$", input)) {
            Log.w(TAG, "Failed Brazil number format check");
            return false;
        }
        CharSequence charSequence = input;
        return new Regex("^\\+[1-9][0-9]{6,14}$").matches(charSequence);
    }

    @JvmStatic
    @NotNull
    public static final Optional<String> getRegionDisplayName(@Nullable String regionCode) {
        if (regionCode == null || Intrinsics.areEqual((Object)regionCode, (Object)"ZZ") || Intrinsics.areEqual((Object)regionCode, (Object)"001")) {
            Optional<String> optional = Optional.empty();
            Intrinsics.checkNotNullExpressionValue(optional, (String)"empty(...)");
            return optional;
        }
        String displayCountry = StringExtensionsKt.nullIfBlank(new Locale("", regionCode).getDisplayCountry(Locale.getDefault()));
        Optional<String> optional = Optional.ofNullable(displayCountry);
        Intrinsics.checkNotNullExpressionValue(optional, (String)"ofNullable(...)");
        return optional;
    }

    private final String formatAsE164WithCountryCode(String countryCode, String input) {
        String string;
        try {
            int countryCodeInt = Integer.parseInt(countryCode);
            string = PhoneNumberUtil.getInstance().getRegionCodeForCountryCode(countryCodeInt);
        }
        catch (NumberFormatException e) {
            return null;
        }
        String regionCode = string;
        Intrinsics.checkNotNull((Object)regionCode);
        return this.formatAsE164WithRegionCode(null, null, regionCode, input);
    }

    private final String formatAsE164WithRegionCode(Phonenumber.PhoneNumber localNumber, String localAreaCode, String regionCode, String input) {
        try {
            boolean isShortCode;
            char[] cArray;
            String correctedInput = this.stripLeadingZerosFromInput(this.e164CharsOnly(input));
            char[] cArray2 = new char[]{'0'};
            if (StringsKt.trimStart((String)correctedInput, (char[])cArray2).length() < 3) {
                return null;
            }
            String withAreaCodeRules = this.applyAreaCodeRules(localNumber, localAreaCode, correctedInput);
            Phonenumber.PhoneNumber phoneNumber = PhoneNumberUtil.getInstance().parse((CharSequence)withAreaCodeRules, regionCode);
            Intrinsics.checkNotNullExpressionValue((Object)phoneNumber, (String)"parse(...)");
            Phonenumber.PhoneNumber parsedNumber = phoneNumber;
            boolean bl = ShortNumberInfo.getInstance().isValidShortNumberForRegion(parsedNumber, regionCode) || StringsKt.trimStart((String)withAreaCodeRules, (char[])(cArray = new char[]{'+'})).length() <= 6 ? true : (isShortCode = false);
            if (isShortCode) {
                return this.stripLeadingZerosFromE164(this.numbersOnly(correctedInput));
            }
            String string = PhoneNumberUtil.getInstance().format(parsedNumber, PhoneNumberUtil.PhoneNumberFormat.E164);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"format(...)");
            return this.stripLeadingZerosFromE164(string);
        }
        catch (NumberParseException e) {
            return null;
        }
    }

    private final String parseAreaCode(String e164Number, int countryCode) {
        switch (countryCode) {
            case 1: {
                String string = e164Number.substring(2, 5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
            case 55: {
                String string = e164Number.substring(3, 5);
                Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
                return string;
            }
        }
        return null;
    }

    private final String applyAreaCodeRules(Phonenumber.PhoneNumber localNumber, String localAreaCode, String testNumber) {
        Matcher matcher;
        if (localNumber == null || localAreaCode == null) {
            return testNumber;
        }
        switch (localNumber.getCountryCode()) {
            case 1: {
                Matcher matcher2 = US_NO_AREACODE.matcher(testNumber);
                break;
            }
            case 55: {
                Matcher matcher2 = BR_NO_AREACODE.matcher(testNumber);
                break;
            }
            default: {
                Matcher matcher2 = matcher = null;
            }
        }
        if (matcher != null && matcher.matches()) {
            return localAreaCode + matcher.group();
        }
        return testNumber;
    }

    /*
     * WARNING - void declaration
     */
    private final String numbersOnly(String $this$numbersOnly) {
        void $this$filterTo$iv$iv;
        String $this$filter$iv = $this$numbersOnly;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!Character.isDigit(it)) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return ((StringBuilder)destination$iv$iv).toString();
    }

    /*
     * WARNING - void declaration
     */
    private final String e164CharsOnly(String $this$e164CharsOnly) {
        void $this$filterTo$iv$iv;
        String $this$filter$iv = $this$e164CharsOnly;
        boolean $i$f$filter = false;
        CharSequence charSequence = $this$filter$iv;
        Appendable destination$iv$iv = new StringBuilder();
        boolean $i$f$filterTo = false;
        int n = $this$filterTo$iv$iv.length();
        for (int index$iv$iv = 0; index$iv$iv < n; ++index$iv$iv) {
            char element$iv$iv;
            char it = element$iv$iv = $this$filterTo$iv$iv.charAt(index$iv$iv);
            boolean bl = false;
            if (!(Character.isDigit(it) || it == '+')) continue;
            destination$iv$iv.append(element$iv$iv);
        }
        return ((StringBuilder)destination$iv$iv).toString();
    }

    private final String stripLeadingZerosFromInput(String $this$stripLeadingZerosFromInput) {
        Object object;
        if (StringsKt.startsWith$default((String)$this$stripLeadingZerosFromInput, (String)"+0", (boolean)false, (int)2, null)) {
            String string = $this$stripLeadingZerosFromInput.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            char[] cArray = new char[]{'0'};
            object = "+" + StringsKt.trimStart((String)string, (char[])cArray);
        } else {
            object = $this$stripLeadingZerosFromInput;
        }
        return object;
    }

    private final String stripLeadingZerosFromE164(String $this$stripLeadingZerosFromE164) {
        Object object;
        if (StringsKt.startsWith$default((String)$this$stripLeadingZerosFromE164, (String)"0", (boolean)false, (int)2, null)) {
            char[] cArray = new char[]{'0'};
            object = StringsKt.trimStart((String)$this$stripLeadingZerosFromE164, (char[])cArray);
        } else if (StringsKt.startsWith$default((String)$this$stripLeadingZerosFromE164, (String)"+0", (boolean)false, (int)2, null)) {
            String string = $this$stripLeadingZerosFromE164.substring(1);
            Intrinsics.checkNotNullExpressionValue((Object)string, (String)"substring(...)");
            char[] cArray = new char[]{'0'};
            object = "+" + StringsKt.trimStart((String)string, (char[])cArray);
        } else {
            object = $this$stripLeadingZerosFromE164;
        }
        return object;
    }

    static {
        Pattern pattern = Pattern.compile("^(\\d{7})$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern, (String)"compile(...)");
        US_NO_AREACODE = pattern;
        Pattern pattern2 = Pattern.compile("^(9?\\d{8})$");
        Intrinsics.checkNotNullExpressionValue((Object)pattern2, (String)"compile(...)");
        BR_NO_AREACODE = pattern2;
        Object[] objectArray = new Integer[]{1, 44};
        NATIONAL_FORMAT_COUNTRY_CODES = SetsKt.setOf((Object[])objectArray);
        INVALID_CHARACTERS_REGEX = new Regex("[a-zA-Z]");
    }

    @Metadata(mv={2, 1, 0}, k=1, xi=48, d1={"\u0000\u0018\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0002\b\f\u0018\u00002\u00020\u0001B#\u0012\b\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u0012\b\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u0012\u0006\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\u0004\b\u0007\u0010\bJ\u0010\u0010\u000e\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u000f\u001a\u00020\u0005J\u000e\u0010\u0010\u001a\u00020\u00052\u0006\u0010\u000f\u001a\u00020\u0005R\u0013\u0010\u0002\u001a\u0004\u0018\u00010\u0003\u00a2\u0006\b\n\u0000\u001a\u0004\b\t\u0010\nR\u0013\u0010\u0004\u001a\u0004\u0018\u00010\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000b\u0010\fR\u0011\u0010\u0006\u001a\u00020\u0005\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\f\u00a8\u0006\u0011"}, d2={"Lorg/signal/core/util/E164Util$Formatter;", "", "localNumber", "Lcom/google/i18n/phonenumbers/Phonenumber$PhoneNumber;", "localAreaCode", "", "localRegionCode", "<init>", "(Lcom/google/i18n/phonenumbers/Phonenumber$PhoneNumber;Ljava/lang/String;Ljava/lang/String;)V", "getLocalNumber", "()Lcom/google/i18n/phonenumbers/Phonenumber$PhoneNumber;", "getLocalAreaCode", "()Ljava/lang/String;", "getLocalRegionCode", "formatAsE164", "input", "prettyPrint", "core-util-jvm"})
    public static final class Formatter {
        @Nullable
        private final Phonenumber.PhoneNumber localNumber;
        @Nullable
        private final String localAreaCode;
        @NotNull
        private final String localRegionCode;

        public Formatter(@Nullable Phonenumber.PhoneNumber localNumber, @Nullable String localAreaCode, @NotNull String localRegionCode) {
            Intrinsics.checkNotNullParameter((Object)localRegionCode, (String)"localRegionCode");
            this.localNumber = localNumber;
            this.localAreaCode = localAreaCode;
            this.localRegionCode = localRegionCode;
        }

        @Nullable
        public final Phonenumber.PhoneNumber getLocalNumber() {
            return this.localNumber;
        }

        @Nullable
        public final String getLocalAreaCode() {
            return this.localAreaCode;
        }

        @NotNull
        public final String getLocalRegionCode() {
            return this.localRegionCode;
        }

        @Nullable
        public final String formatAsE164(@NotNull String input) {
            String string;
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            if (INVALID_CHARACTERS_REGEX.containsMatchIn((CharSequence)input)) {
                return null;
            }
            String formatted = INSTANCE.formatAsE164WithRegionCode(this.localNumber, this.localAreaCode, this.localRegionCode, input);
            if (formatted == null && StringsKt.startsWith$default((String)input, (String)"+", (boolean)false, (int)2, null)) {
                String string2 = input.substring(1);
                Intrinsics.checkNotNullExpressionValue((Object)string2, (String)"substring(...)");
                string = this.formatAsE164(string2);
            } else {
                string = formatted;
            }
            return string;
        }

        @NotNull
        public final String prettyPrint(@NotNull String input) {
            Intrinsics.checkNotNullParameter((Object)input, (String)"input");
            try {
                String string;
                Phonenumber.PhoneNumber phoneNumber = PhoneNumberUtil.getInstance().parse((CharSequence)input, this.localRegionCode);
                Intrinsics.checkNotNullExpressionValue((Object)phoneNumber, (String)"parse(...)");
                Phonenumber.PhoneNumber parsedNumber = phoneNumber;
                if (this.localNumber != null && this.localNumber.getCountryCode() == parsedNumber.getCountryCode() && NATIONAL_FORMAT_COUNTRY_CODES.contains(this.localNumber.getCountryCode())) {
                    String string2 = PhoneNumberUtil.getInstance().format(parsedNumber, PhoneNumberUtil.PhoneNumberFormat.NATIONAL);
                    Intrinsics.checkNotNull((Object)string2);
                    string = string2;
                } else {
                    String string3 = PhoneNumberUtil.getInstance().format(parsedNumber, PhoneNumberUtil.PhoneNumberFormat.INTERNATIONAL);
                    Intrinsics.checkNotNull((Object)string3);
                    string = string3;
                }
                return string;
            }
            catch (NumberParseException e) {
                String string;
                Log.w(TAG, "Failed to format number: " + e);
                String raw = string = input;
                return BidiUtil.forceLtr(BidiUtil.isolateBidi(raw));
            }
        }
    }
}

