/*
 * Decompiled with CFR 0.152.
 */
package org.asamk.signal.manager.syncStorage;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Optional;
import okio.ByteString;
import org.asamk.signal.manager.api.GroupIdV2;
import org.asamk.signal.manager.groups.GroupUtils;
import org.asamk.signal.manager.storage.SignalAccount;
import org.asamk.signal.manager.storage.groups.GroupInfoV2;
import org.asamk.signal.manager.syncStorage.DefaultStorageRecordProcessor;
import org.asamk.signal.manager.syncStorage.StorageRecordUpdate;
import org.asamk.signal.manager.syncStorage.StorageSyncModels;
import org.asamk.signal.manager.util.KeyUtils;
import org.jetbrains.annotations.NotNull;
import org.signal.libsignal.zkgroup.InvalidInputException;
import org.signal.libsignal.zkgroup.groups.GroupMasterKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.whispersystems.signalservice.api.storage.SignalGroupV2Record;
import org.whispersystems.signalservice.api.storage.StorageId;
import org.whispersystems.signalservice.internal.storage.protos.GroupV2Record;

public final class GroupV2RecordProcessor
extends DefaultStorageRecordProcessor<SignalGroupV2Record> {
    private static final Logger logger = LoggerFactory.getLogger(GroupV2RecordProcessor.class);
    private final SignalAccount account;
    private final Connection connection;

    public GroupV2RecordProcessor(SignalAccount account, Connection connection) {
        this.account = account;
        this.connection = connection;
    }

    @Override
    protected boolean isInvalid(SignalGroupV2Record remote) {
        return remote.getProto().masterKey.size() != 32;
    }

    @Override
    protected Optional<SignalGroupV2Record> getMatching(SignalGroupV2Record remote) throws SQLException {
        GroupIdV2 id = GroupUtils.getGroupIdV2(GroupV2RecordProcessor.getGroupMasterKeyOrThrow(remote.getProto().masterKey));
        GroupInfoV2 group = this.account.getGroupStore().getGroup(this.connection, id);
        if (group == null) {
            return Optional.empty();
        }
        StorageId storageId = this.account.getGroupStore().getGroupStorageId(this.connection, id);
        return Optional.of(new SignalGroupV2Record(storageId, StorageSyncModels.localToRemoteRecord(group)));
    }

    @Override
    protected SignalGroupV2Record merge(SignalGroupV2Record remoteRecord, SignalGroupV2Record localRecord) {
        GroupV2Record remote = remoteRecord.getProto();
        GroupV2Record local = localRecord.getProto();
        GroupV2Record.Builder mergedBuilder = remote.newBuilder().masterKey(remote.masterKey).blocked(remote.blocked).whitelisted(remote.whitelisted).archived(remote.archived).markedUnread(remote.markedUnread).mutedUntilTimestamp(remote.mutedUntilTimestamp).dontNotifyForMentionsIfMuted(remote.dontNotifyForMentionsIfMuted).hideStory(remote.hideStory).storySendMode(remote.storySendMode).avatarColor(remote.avatarColor);
        GroupV2Record merged = mergedBuilder.build();
        boolean matchesRemote = GroupV2RecordProcessor.doProtosMatch(merged, remote);
        if (matchesRemote) {
            return remoteRecord;
        }
        boolean matchesLocal = GroupV2RecordProcessor.doProtosMatch(merged, local);
        if (matchesLocal) {
            return localRecord;
        }
        return new SignalGroupV2Record(StorageId.forGroupV2((byte[])KeyUtils.createRawStorageId()), mergedBuilder.build());
    }

    @Override
    protected void insertLocal(SignalGroupV2Record record) throws SQLException {
        StorageRecordUpdate<SignalGroupV2Record> update = new StorageRecordUpdate<SignalGroupV2Record>(null, record);
        this.updateLocal(update);
    }

    @Override
    protected void updateLocal(StorageRecordUpdate<SignalGroupV2Record> update) throws SQLException {
        SignalGroupV2Record groupV2Record = update.newRecord();
        GroupV2Record groupV2Proto = groupV2Record.getProto();
        GroupMasterKey groupMasterKey = GroupV2RecordProcessor.getGroupMasterKeyOrThrow(groupV2Proto.masterKey);
        GroupInfoV2 group = this.account.getGroupStore().getGroupOrPartialMigrate(this.connection, groupMasterKey);
        group.setBlocked(groupV2Proto.blocked);
        group.setProfileSharingEnabled(groupV2Proto.whitelisted);
        this.account.getGroupStore().updateGroup(this.connection, group);
        this.account.getGroupStore().storeStorageRecord(this.connection, group.getGroupId(), groupV2Record.getId(), groupV2Proto.encode());
    }

    @NotNull
    private static GroupMasterKey getGroupMasterKeyOrThrow(ByteString masterKey) {
        try {
            return new GroupMasterKey(masterKey.toByteArray());
        }
        catch (InvalidInputException e) {
            throw new AssertionError((Object)e);
        }
    }

    @Override
    public int compare(SignalGroupV2Record lhs, SignalGroupV2Record rhs) {
        if (lhs.getProto().masterKey.equals((Object)rhs.getProto().masterKey)) {
            return 0;
        }
        return 1;
    }

    private static boolean doProtosMatch(GroupV2Record merged, GroupV2Record other) {
        return Arrays.equals(merged.encode(), other.encode());
    }
}

