/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.internal.configuration;

import java.util.Collections;
import java.util.List;
import java.util.Optional;
import okhttp3.ConnectionSpec;
import org.whispersystems.signalservice.api.push.TrustStore;

public class SignalUrl {
    private final String url;
    private final Optional<String> hostHeader;
    private final Optional<ConnectionSpec> connectionSpec;
    private TrustStore trustStore;

    public SignalUrl(String url, TrustStore trustStore) {
        this(url, null, trustStore, null);
    }

    public SignalUrl(String url, String hostHeader, TrustStore trustStore, ConnectionSpec connectionSpec) {
        this.url = url;
        this.hostHeader = Optional.ofNullable(hostHeader);
        this.trustStore = trustStore;
        this.connectionSpec = Optional.ofNullable(connectionSpec);
    }

    public Optional<String> getHostHeader() {
        return this.hostHeader;
    }

    public String getUrl() {
        return this.url;
    }

    public TrustStore getTrustStore() {
        return this.trustStore;
    }

    public Optional<List<ConnectionSpec>> getConnectionSpecs() {
        return this.connectionSpec.isPresent() ? Optional.of(Collections.singletonList(this.connectionSpec.get())) : Optional.empty();
    }
}

