/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import java.util.Optional;
import org.signal.libsignal.protocol.InvalidMessageException;
import org.whispersystems.signalservice.api.messages.SignalServiceGroup;
import org.whispersystems.signalservice.api.messages.SignalServiceGroupV2;

public final class SignalServiceGroupContext {
    private final Optional<SignalServiceGroup> groupV1;
    private final Optional<SignalServiceGroupV2> groupV2;

    private SignalServiceGroupContext(SignalServiceGroup groupV1) {
        this.groupV1 = Optional.of(groupV1);
        this.groupV2 = Optional.empty();
    }

    private SignalServiceGroupContext(SignalServiceGroupV2 groupV2) {
        this.groupV1 = Optional.empty();
        this.groupV2 = Optional.of(groupV2);
    }

    public Optional<SignalServiceGroup> getGroupV1() {
        return this.groupV1;
    }

    public Optional<SignalServiceGroupV2> getGroupV2() {
        return this.groupV2;
    }

    static Optional<SignalServiceGroupContext> createOptional(SignalServiceGroup groupV1, SignalServiceGroupV2 groupV2) throws InvalidMessageException {
        return Optional.ofNullable(SignalServiceGroupContext.create(groupV1, groupV2));
    }

    public static SignalServiceGroupContext create(SignalServiceGroup groupV1, SignalServiceGroupV2 groupV2) throws InvalidMessageException {
        if (groupV1 == null && groupV2 == null) {
            return null;
        }
        if (groupV1 != null && groupV2 != null) {
            throw new InvalidMessageException("Message cannot have both V1 and V2 group contexts.");
        }
        if (groupV1 != null) {
            return new SignalServiceGroupContext(groupV1);
        }
        return new SignalServiceGroupContext(groupV2);
    }

    public SignalServiceGroup.Type getGroupV1Type() {
        if (this.groupV1.isPresent()) {
            return this.groupV1.get().getType();
        }
        return null;
    }
}

