/*
 * Decompiled with CFR 0.152.
 */
package org.whispersystems.signalservice.api.messages;

import java.util.List;
import java.util.Optional;
import org.whispersystems.signalservice.api.messages.SignalServiceAttachment;
import org.whispersystems.signalservice.api.push.SignalServiceAddress;

public class SignalServiceGroup {
    private final byte[] groupId;
    private final Type type;
    private final Optional<String> name;
    private final Optional<List<SignalServiceAddress>> members;
    private final Optional<SignalServiceAttachment> avatar;

    public SignalServiceGroup(byte[] groupId) {
        this(Type.DELIVER, groupId, null, null, null);
    }

    public SignalServiceGroup(Type type, byte[] groupId, String name, List<SignalServiceAddress> members, SignalServiceAttachment avatar) {
        this.type = type;
        this.groupId = groupId;
        this.name = Optional.ofNullable(name);
        this.members = Optional.ofNullable(members);
        this.avatar = Optional.ofNullable(avatar);
    }

    public byte[] getGroupId() {
        return this.groupId;
    }

    public Type getType() {
        return this.type;
    }

    public Optional<String> getName() {
        return this.name;
    }

    public Optional<List<SignalServiceAddress>> getMembers() {
        return this.members;
    }

    public Optional<SignalServiceAttachment> getAvatar() {
        return this.avatar;
    }

    public static Builder newUpdateBuilder() {
        return new Builder(Type.UPDATE);
    }

    public static Builder newBuilder(Type type) {
        return new Builder(type);
    }

    public static enum Type {
        UNKNOWN,
        UPDATE,
        DELIVER,
        QUIT,
        REQUEST_INFO;

    }

    public static class Builder {
        private Type type;
        private byte[] id;
        private String name;
        private List<SignalServiceAddress> members;
        private SignalServiceAttachment avatar;

        private Builder(Type type) {
            this.type = type;
        }

        public Builder withId(byte[] id) {
            this.id = id;
            return this;
        }

        public Builder withName(String name) {
            this.name = name;
            return this;
        }

        public Builder withMembers(List<SignalServiceAddress> members) {
            this.members = members;
            return this;
        }

        public Builder withAvatar(SignalServiceAttachment avatar) {
            this.avatar = avatar;
            return this;
        }

        public SignalServiceGroup build() {
            if (this.id == null) {
                throw new IllegalArgumentException("No group ID specified!");
            }
            if (this.type == Type.UPDATE && this.name == null && this.members == null && this.avatar == null) {
                throw new IllegalArgumentException("Group update with no updates!");
            }
            return new SignalServiceGroup(this.type, this.id, this.name, this.members, this.avatar);
        }
    }
}

