// $Id$

// Fish Supper
// Copyright 2006, 2007, 2009, 2010 Matthew Clarke <mafferyew@googlemail.com>
//
// This file is part of Fish Supper.
//
// Fish Supper is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Fish Supper is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Fish Supper.  If not, see <http://www.gnu.org/licenses/>.




#ifndef Star_particle_system_h
#define Star_particle_system_h




#include <iostream>
#include "SDL.h"
#include "constants.h"
#include "enums.h"
#include "FS_gfx.h"
#include <tr1/memory>




extern std::tr1::shared_ptr<FS::FS_gfx> gfx_ptr;




namespace FS
{
    
// FIXME: This class should be made more general so
// that different types of particle system can be sub-classed
// from it.
class Star_particle_system
{
    public:
            
        Star_particle_system();
        ~Star_particle_system();
        
        void activate(int t, SDL_Rect box);
        
        // Calling stop() means the system won't launch any new
        // particles but it will continue to update existing ones
        // until they've all died out.
        void stop(int t);
        
        // Is this system in use and therefore in need of updates?
        bool is_active() const { return active; }
        
        bool is_stopped() const { return stopped; }
        
        void update(int time_passed, SDL_Rect box/*, PlayDisplay * pd*/);

    private:
            
        static const int MAX_STARS = 20;
        // launch a new star every n ms:
        static const int LAUNCH_INTERVAL = 30; 
        static const int STAR_WIDTH = 30;
        static const int STAR_HEIGHT = 30;
        // This is a float so that we get floating-point division in update.
        static const float lifespan = 1500.0;   // in ms
    
        // A particle is basically a lightweight sprite.
        // Unlike a usual sprite, we don't need to worry about
        // collisions. In the case of 'star' particles, no need
        // to track movement either.
        struct StarParticle
        {
            int x;
            int y;
            int start_time;
            bool active;
        }; // struct StarParticle
        
        bool active;
        bool stopped;
        int start_time;
        int num_stars;
        
        StarParticle my_stars[MAX_STARS];
        
        void launch_new_star(int t, SDL_Rect box);
        
}; // class Star_particle_system

} // namespace FS    




#endif
