//! This file has been automatically generated by `objc2`'s `header-translator`.
//! DO NOT EDIT
use objc2::__framework_prelude::*;
use objc2_foundation::*;

use crate::*;

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLIOCompressionMethod(pub NSInteger);
impl MTLIOCompressionMethod {
    #[doc(alias = "MTLIOCompressionMethodZlib")]
    pub const Zlib: Self = Self(0);
    #[doc(alias = "MTLIOCompressionMethodLZFSE")]
    pub const LZFSE: Self = Self(1);
    #[doc(alias = "MTLIOCompressionMethodLZ4")]
    pub const LZ4: Self = Self(2);
    #[doc(alias = "MTLIOCompressionMethodLZMA")]
    pub const LZMA: Self = Self(3);
    #[doc(alias = "MTLIOCompressionMethodLZBitmap")]
    pub const LZBitmap: Self = Self(4);
}

unsafe impl Encode for MTLIOCompressionMethod {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLIOCompressionMethod {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

extern "C" {
    pub fn MTLCreateSystemDefaultDevice() -> *mut ProtocolObject<dyn MTLDevice>;
}

extern "C" {
    pub fn MTLCopyAllDevices() -> NonNull<NSArray<ProtocolObject<dyn MTLDevice>>>;
}

// NS_TYPED_ENUM
pub type MTLDeviceNotificationName = NSString;

extern "C" {
    pub static MTLDeviceWasAddedNotification: &'static MTLDeviceNotificationName;
}

extern "C" {
    pub static MTLDeviceRemovalRequestedNotification: &'static MTLDeviceNotificationName;
}

extern "C" {
    pub static MTLDeviceWasRemovedNotification: &'static MTLDeviceNotificationName;
}

#[cfg(feature = "block2")]
pub type MTLDeviceNotificationHandler = *mut block2::Block<
    dyn Fn(NonNull<ProtocolObject<dyn MTLDevice>>, NonNull<MTLDeviceNotificationName>),
>;

extern "C" {
    pub fn MTLRemoveDeviceObserver(observer: &NSObject);
}

// NS_ENUM
#[deprecated = "Use MTLGPUFamily instead"]
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLFeatureSet(pub NSUInteger);
impl MTLFeatureSet {
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily1_v1")]
    pub const _iOS_GPUFamily1_v1: Self = Self(0);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily2_v1")]
    pub const _iOS_GPUFamily2_v1: Self = Self(1);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily1_v2")]
    pub const _iOS_GPUFamily1_v2: Self = Self(2);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily2_v2")]
    pub const _iOS_GPUFamily2_v2: Self = Self(3);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily3_v1")]
    pub const _iOS_GPUFamily3_v1: Self = Self(4);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily1_v3")]
    pub const _iOS_GPUFamily1_v3: Self = Self(5);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily2_v3")]
    pub const _iOS_GPUFamily2_v3: Self = Self(6);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily3_v2")]
    pub const _iOS_GPUFamily3_v2: Self = Self(7);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily1_v4")]
    pub const _iOS_GPUFamily1_v4: Self = Self(8);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily2_v4")]
    pub const _iOS_GPUFamily2_v4: Self = Self(9);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily3_v3")]
    pub const _iOS_GPUFamily3_v3: Self = Self(10);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily4_v1")]
    pub const _iOS_GPUFamily4_v1: Self = Self(11);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily1_v5")]
    pub const _iOS_GPUFamily1_v5: Self = Self(12);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily2_v5")]
    pub const _iOS_GPUFamily2_v5: Self = Self(13);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily3_v4")]
    pub const _iOS_GPUFamily3_v4: Self = Self(14);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily4_v2")]
    pub const _iOS_GPUFamily4_v2: Self = Self(15);
    #[doc(alias = "MTLFeatureSet_iOS_GPUFamily5_v1")]
    pub const _iOS_GPUFamily5_v1: Self = Self(16);
    #[doc(alias = "MTLFeatureSet_macOS_GPUFamily1_v1")]
    pub const _macOS_GPUFamily1_v1: Self = Self(10000);
    #[doc(alias = "MTLFeatureSet_OSX_GPUFamily1_v1")]
    pub const _OSX_GPUFamily1_v1: Self = Self(MTLFeatureSet::_macOS_GPUFamily1_v1.0);
    #[doc(alias = "MTLFeatureSet_macOS_GPUFamily1_v2")]
    pub const _macOS_GPUFamily1_v2: Self = Self(10001);
    #[doc(alias = "MTLFeatureSet_OSX_GPUFamily1_v2")]
    pub const _OSX_GPUFamily1_v2: Self = Self(MTLFeatureSet::_macOS_GPUFamily1_v2.0);
    #[doc(alias = "MTLFeatureSet_macOS_ReadWriteTextureTier2")]
    pub const _macOS_ReadWriteTextureTier2: Self = Self(10002);
    #[doc(alias = "MTLFeatureSet_OSX_ReadWriteTextureTier2")]
    pub const _OSX_ReadWriteTextureTier2: Self =
        Self(MTLFeatureSet::_macOS_ReadWriteTextureTier2.0);
    #[doc(alias = "MTLFeatureSet_macOS_GPUFamily1_v3")]
    pub const _macOS_GPUFamily1_v3: Self = Self(10003);
    #[doc(alias = "MTLFeatureSet_macOS_GPUFamily1_v4")]
    pub const _macOS_GPUFamily1_v4: Self = Self(10004);
    #[doc(alias = "MTLFeatureSet_macOS_GPUFamily2_v1")]
    pub const _macOS_GPUFamily2_v1: Self = Self(10005);
    #[doc(alias = "MTLFeatureSet_tvOS_GPUFamily1_v1")]
    pub const _tvOS_GPUFamily1_v1: Self = Self(30000);
    #[doc(alias = "MTLFeatureSet_TVOS_GPUFamily1_v1")]
    pub const _TVOS_GPUFamily1_v1: Self = Self(MTLFeatureSet::_tvOS_GPUFamily1_v1.0);
    #[doc(alias = "MTLFeatureSet_tvOS_GPUFamily1_v2")]
    pub const _tvOS_GPUFamily1_v2: Self = Self(30001);
    #[doc(alias = "MTLFeatureSet_tvOS_GPUFamily1_v3")]
    pub const _tvOS_GPUFamily1_v3: Self = Self(30002);
    #[doc(alias = "MTLFeatureSet_tvOS_GPUFamily2_v1")]
    pub const _tvOS_GPUFamily2_v1: Self = Self(30003);
    #[doc(alias = "MTLFeatureSet_tvOS_GPUFamily1_v4")]
    pub const _tvOS_GPUFamily1_v4: Self = Self(30004);
    #[doc(alias = "MTLFeatureSet_tvOS_GPUFamily2_v2")]
    pub const _tvOS_GPUFamily2_v2: Self = Self(30005);
}

unsafe impl Encode for MTLFeatureSet {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLFeatureSet {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLGPUFamily(pub NSInteger);
impl MTLGPUFamily {
    #[doc(alias = "MTLGPUFamilyApple1")]
    pub const Apple1: Self = Self(1001);
    #[doc(alias = "MTLGPUFamilyApple2")]
    pub const Apple2: Self = Self(1002);
    #[doc(alias = "MTLGPUFamilyApple3")]
    pub const Apple3: Self = Self(1003);
    #[doc(alias = "MTLGPUFamilyApple4")]
    pub const Apple4: Self = Self(1004);
    #[doc(alias = "MTLGPUFamilyApple5")]
    pub const Apple5: Self = Self(1005);
    #[doc(alias = "MTLGPUFamilyApple6")]
    pub const Apple6: Self = Self(1006);
    #[doc(alias = "MTLGPUFamilyApple7")]
    pub const Apple7: Self = Self(1007);
    #[doc(alias = "MTLGPUFamilyApple8")]
    pub const Apple8: Self = Self(1008);
    #[doc(alias = "MTLGPUFamilyApple9")]
    pub const Apple9: Self = Self(1009);
    #[deprecated]
    #[doc(alias = "MTLGPUFamilyMac1")]
    pub const Mac1: Self = Self(2001);
    #[doc(alias = "MTLGPUFamilyMac2")]
    pub const Mac2: Self = Self(2002);
    #[doc(alias = "MTLGPUFamilyCommon1")]
    pub const Common1: Self = Self(3001);
    #[doc(alias = "MTLGPUFamilyCommon2")]
    pub const Common2: Self = Self(3002);
    #[doc(alias = "MTLGPUFamilyCommon3")]
    pub const Common3: Self = Self(3003);
    #[deprecated]
    #[doc(alias = "MTLGPUFamilyMacCatalyst1")]
    pub const MacCatalyst1: Self = Self(4001);
    #[deprecated]
    #[doc(alias = "MTLGPUFamilyMacCatalyst2")]
    pub const MacCatalyst2: Self = Self(4002);
    #[doc(alias = "MTLGPUFamilyMetal3")]
    pub const Metal3: Self = Self(5001);
}

unsafe impl Encode for MTLGPUFamily {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLGPUFamily {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLDeviceLocation(pub NSUInteger);
impl MTLDeviceLocation {
    #[doc(alias = "MTLDeviceLocationBuiltIn")]
    pub const BuiltIn: Self = Self(0);
    #[doc(alias = "MTLDeviceLocationSlot")]
    pub const Slot: Self = Self(1);
    #[doc(alias = "MTLDeviceLocationExternal")]
    pub const External: Self = Self(2);
    #[doc(alias = "MTLDeviceLocationUnspecified")]
    pub const Unspecified: Self = Self(NSUIntegerMax as _);
}

unsafe impl Encode for MTLDeviceLocation {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLDeviceLocation {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_OPTIONS
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLPipelineOption(pub NSUInteger);
bitflags::bitflags! {
    impl MTLPipelineOption: NSUInteger {
        #[doc(alias = "MTLPipelineOptionNone")]
        const None = 0;
        #[doc(alias = "MTLPipelineOptionArgumentInfo")]
        const ArgumentInfo = 1<<0;
        #[doc(alias = "MTLPipelineOptionBufferTypeInfo")]
        const BufferTypeInfo = 1<<1;
        #[doc(alias = "MTLPipelineOptionFailOnBinaryArchiveMiss")]
        const FailOnBinaryArchiveMiss = 1<<2;
    }
}

unsafe impl Encode for MTLPipelineOption {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLPipelineOption {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLReadWriteTextureTier(pub NSUInteger);
impl MTLReadWriteTextureTier {
    #[doc(alias = "MTLReadWriteTextureTierNone")]
    pub const None: Self = Self(0);
    pub const MTLReadWriteTextureTier1: Self = Self(1);
    pub const MTLReadWriteTextureTier2: Self = Self(2);
}

unsafe impl Encode for MTLReadWriteTextureTier {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLReadWriteTextureTier {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLArgumentBuffersTier(pub NSUInteger);
impl MTLArgumentBuffersTier {
    pub const MTLArgumentBuffersTier1: Self = Self(0);
    pub const MTLArgumentBuffersTier2: Self = Self(1);
}

unsafe impl Encode for MTLArgumentBuffersTier {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLArgumentBuffersTier {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLSparseTextureRegionAlignmentMode(pub NSUInteger);
impl MTLSparseTextureRegionAlignmentMode {
    #[doc(alias = "MTLSparseTextureRegionAlignmentModeOutward")]
    pub const Outward: Self = Self(0);
    #[doc(alias = "MTLSparseTextureRegionAlignmentModeInward")]
    pub const Inward: Self = Self(1);
}

unsafe impl Encode for MTLSparseTextureRegionAlignmentMode {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLSparseTextureRegionAlignmentMode {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLSparsePageSize(pub NSInteger);
impl MTLSparsePageSize {
    pub const MTLSparsePageSize16: Self = Self(101);
    pub const MTLSparsePageSize64: Self = Self(102);
    pub const MTLSparsePageSize256: Self = Self(103);
}

unsafe impl Encode for MTLSparsePageSize {
    const ENCODING: Encoding = NSInteger::ENCODING;
}

unsafe impl RefEncode for MTLSparsePageSize {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLAccelerationStructureSizes {
    pub accelerationStructureSize: NSUInteger,
    pub buildScratchBufferSize: NSUInteger,
    pub refitScratchBufferSize: NSUInteger,
}

unsafe impl Encode for MTLAccelerationStructureSizes {
    const ENCODING: Encoding = Encoding::Struct(
        "?",
        &[
            <NSUInteger>::ENCODING,
            <NSUInteger>::ENCODING,
            <NSUInteger>::ENCODING,
        ],
    );
}

unsafe impl RefEncode for MTLAccelerationStructureSizes {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

// NS_ENUM
#[repr(transparent)]
#[derive(Clone, Copy, Debug, PartialEq, Eq, Hash, PartialOrd, Ord)]
pub struct MTLCounterSamplingPoint(pub NSUInteger);
impl MTLCounterSamplingPoint {
    #[doc(alias = "MTLCounterSamplingPointAtStageBoundary")]
    pub const AtStageBoundary: Self = Self(0);
    #[doc(alias = "MTLCounterSamplingPointAtDrawBoundary")]
    pub const AtDrawBoundary: Self = Self(1);
    #[doc(alias = "MTLCounterSamplingPointAtDispatchBoundary")]
    pub const AtDispatchBoundary: Self = Self(2);
    #[doc(alias = "MTLCounterSamplingPointAtTileDispatchBoundary")]
    pub const AtTileDispatchBoundary: Self = Self(3);
    #[doc(alias = "MTLCounterSamplingPointAtBlitBoundary")]
    pub const AtBlitBoundary: Self = Self(4);
}

unsafe impl Encode for MTLCounterSamplingPoint {
    const ENCODING: Encoding = NSUInteger::ENCODING;
}

unsafe impl RefEncode for MTLCounterSamplingPoint {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[repr(C)]
#[derive(Clone, Copy, Debug, PartialEq)]
pub struct MTLSizeAndAlign {
    pub size: NSUInteger,
    pub align: NSUInteger,
}

unsafe impl Encode for MTLSizeAndAlign {
    const ENCODING: Encoding =
        Encoding::Struct("?", &[<NSUInteger>::ENCODING, <NSUInteger>::ENCODING]);
}

unsafe impl RefEncode for MTLSizeAndAlign {
    const ENCODING_REF: Encoding = Encoding::Pointer(&Self::ENCODING);
}

#[cfg(all(feature = "MTLLibrary", feature = "block2"))]
pub type MTLNewLibraryCompletionHandler =
    *mut block2::Block<dyn Fn(*mut ProtocolObject<dyn MTLLibrary>, *mut NSError)>;

#[cfg(all(feature = "MTLRenderPipeline", feature = "block2"))]
pub type MTLNewRenderPipelineStateCompletionHandler =
    *mut block2::Block<dyn Fn(*mut ProtocolObject<dyn MTLRenderPipelineState>, *mut NSError)>;

#[cfg(all(feature = "MTLRenderPipeline", feature = "block2"))]
pub type MTLNewRenderPipelineStateWithReflectionCompletionHandler = *mut block2::Block<
    dyn Fn(
        *mut ProtocolObject<dyn MTLRenderPipelineState>,
        *mut MTLRenderPipelineReflection,
        *mut NSError,
    ),
>;

#[cfg(all(feature = "MTLComputePipeline", feature = "block2"))]
pub type MTLNewComputePipelineStateCompletionHandler =
    *mut block2::Block<dyn Fn(*mut ProtocolObject<dyn MTLComputePipelineState>, *mut NSError)>;

#[cfg(all(feature = "MTLComputePipeline", feature = "block2"))]
pub type MTLNewComputePipelineStateWithReflectionCompletionHandler = *mut block2::Block<
    dyn Fn(
        *mut ProtocolObject<dyn MTLComputePipelineState>,
        *mut MTLComputePipelineReflection,
        *mut NSError,
    ),
>;

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLArgumentDescriptor;

    unsafe impl ClassType for MTLArgumentDescriptor {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLArgumentDescriptor {}

unsafe impl NSObjectProtocol for MTLArgumentDescriptor {}

extern_methods!(
    unsafe impl MTLArgumentDescriptor {
        #[method_id(@__retain_semantics Other argumentDescriptor)]
        pub fn argumentDescriptor() -> Retained<MTLArgumentDescriptor>;

        #[cfg(feature = "MTLArgument")]
        #[method(dataType)]
        pub unsafe fn dataType(&self) -> MTLDataType;

        #[cfg(feature = "MTLArgument")]
        #[method(setDataType:)]
        pub fn setDataType(&self, data_type: MTLDataType);

        #[method(index)]
        pub unsafe fn index(&self) -> NSUInteger;

        #[method(setIndex:)]
        pub fn setIndex(&self, index: NSUInteger);

        #[method(arrayLength)]
        pub unsafe fn arrayLength(&self) -> NSUInteger;

        #[method(setArrayLength:)]
        pub unsafe fn setArrayLength(&self, array_length: NSUInteger);

        #[cfg(feature = "MTLArgument")]
        #[method(access)]
        pub unsafe fn access(&self) -> MTLBindingAccess;

        #[cfg(feature = "MTLArgument")]
        #[method(setAccess:)]
        pub fn setAccess(&self, access: MTLBindingAccess);

        #[cfg(feature = "MTLTexture")]
        #[method(textureType)]
        pub unsafe fn textureType(&self) -> MTLTextureType;

        #[cfg(feature = "MTLTexture")]
        #[method(setTextureType:)]
        pub fn setTextureType(&self, texture_type: MTLTextureType);

        #[method(constantBlockAlignment)]
        pub unsafe fn constantBlockAlignment(&self) -> NSUInteger;

        #[method(setConstantBlockAlignment:)]
        pub unsafe fn setConstantBlockAlignment(&self, constant_block_alignment: NSUInteger);
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLArgumentDescriptor {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

extern_class!(
    #[derive(Debug, PartialEq, Eq, Hash)]
    pub struct MTLArchitecture;

    unsafe impl ClassType for MTLArchitecture {
        type Super = NSObject;
        type Mutability = InteriorMutable;
    }
);

unsafe impl NSCopying for MTLArchitecture {}

unsafe impl NSObjectProtocol for MTLArchitecture {}

extern_methods!(
    unsafe impl MTLArchitecture {
        #[method_id(@__retain_semantics Other name)]
        pub unsafe fn name(&self) -> Retained<NSString>;
    }
);

extern_methods!(
    /// Methods declared on superclass `NSObject`
    unsafe impl MTLArchitecture {
        #[method_id(@__retain_semantics Init init)]
        pub unsafe fn init(this: Allocated<Self>) -> Retained<Self>;

        #[method_id(@__retain_semantics New new)]
        pub unsafe fn new() -> Retained<Self>;
    }
);

pub type MTLTimestamp = u64;

extern_protocol!(
    pub unsafe trait MTLDevice: NSObjectProtocol + IsRetainable {
        #[method_id(@__retain_semantics Other name)]
        fn name(&self) -> Retained<NSString>;

        #[method(registryID)]
        fn registryID(&self) -> u64;

        #[method_id(@__retain_semantics Other architecture)]
        unsafe fn architecture(&self) -> Retained<MTLArchitecture>;

        #[cfg(feature = "MTLTypes")]
        #[method(maxThreadsPerThreadgroup)]
        fn maxThreadsPerThreadgroup(&self) -> MTLSize;

        #[method(isLowPower)]
        fn isLowPower(&self) -> bool;

        #[method(isHeadless)]
        fn isHeadless(&self) -> bool;

        #[method(isRemovable)]
        fn isRemovable(&self) -> bool;

        #[method(hasUnifiedMemory)]
        fn hasUnifiedMemory(&self) -> bool;

        #[method(recommendedMaxWorkingSetSize)]
        fn recommendedMaxWorkingSetSize(&self) -> u64;

        #[method(location)]
        fn location(&self) -> MTLDeviceLocation;

        #[method(locationNumber)]
        fn locationNumber(&self) -> NSUInteger;

        #[method(maxTransferRate)]
        fn maxTransferRate(&self) -> u64;

        #[method(isDepth24Stencil8PixelFormatSupported)]
        fn isDepth24Stencil8PixelFormatSupported(&self) -> bool;

        #[method(readWriteTextureSupport)]
        fn readWriteTextureSupport(&self) -> MTLReadWriteTextureTier;

        #[method(argumentBuffersSupport)]
        fn argumentBuffersSupport(&self) -> MTLArgumentBuffersTier;

        #[method(areRasterOrderGroupsSupported)]
        unsafe fn areRasterOrderGroupsSupported(&self) -> bool;

        #[method(supports32BitFloatFiltering)]
        fn supports32BitFloatFiltering(&self) -> bool;

        #[method(supports32BitMSAA)]
        fn supports32BitMSAA(&self) -> bool;

        #[method(supportsQueryTextureLOD)]
        fn supportsQueryTextureLOD(&self) -> bool;

        #[method(supportsBCTextureCompression)]
        fn supportsBCTextureCompression(&self) -> bool;

        #[method(supportsPullModelInterpolation)]
        fn supportsPullModelInterpolation(&self) -> bool;

        #[deprecated]
        #[method(areBarycentricCoordsSupported)]
        unsafe fn areBarycentricCoordsSupported(&self) -> bool;

        #[method(supportsShaderBarycentricCoordinates)]
        fn supportsShaderBarycentricCoordinates(&self) -> bool;

        #[method(currentAllocatedSize)]
        fn currentAllocatedSize(&self) -> NSUInteger;

        #[cfg(feature = "MTLCommandQueue")]
        #[method_id(@__retain_semantics New newCommandQueue)]
        fn newCommandQueue(&self) -> Option<Retained<ProtocolObject<dyn MTLCommandQueue>>>;

        #[cfg(feature = "MTLCommandQueue")]
        #[method_id(@__retain_semantics New newCommandQueueWithMaxCommandBufferCount:)]
        fn newCommandQueueWithMaxCommandBufferCount(
            &self,
            max_command_buffer_count: NSUInteger,
        ) -> Option<Retained<ProtocolObject<dyn MTLCommandQueue>>>;

        #[cfg(feature = "MTLTexture")]
        #[method(heapTextureSizeAndAlignWithDescriptor:)]
        fn heapTextureSizeAndAlignWithDescriptor(
            &self,
            desc: &MTLTextureDescriptor,
        ) -> MTLSizeAndAlign;

        #[cfg(feature = "MTLResource")]
        #[method(heapBufferSizeAndAlignWithLength:options:)]
        fn heapBufferSizeAndAlignWithLength_options(
            &self,
            length: NSUInteger,
            options: MTLResourceOptions,
        ) -> MTLSizeAndAlign;

        #[cfg(feature = "MTLHeap")]
        #[method_id(@__retain_semantics New newHeapWithDescriptor:)]
        fn newHeapWithDescriptor(
            &self,
            descriptor: &MTLHeapDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLHeap>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics New newBufferWithLength:options:)]
        fn newBufferWithLength_options(
            &self,
            length: NSUInteger,
            options: MTLResourceOptions,
        ) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics New newBufferWithBytes:length:options:)]
        unsafe fn newBufferWithBytes_length_options(
            &self,
            pointer: NonNull<c_void>,
            length: NSUInteger,
            options: MTLResourceOptions,
        ) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(all(feature = "MTLBuffer", feature = "MTLResource", feature = "block2"))]
        #[method_id(@__retain_semantics New newBufferWithBytesNoCopy:length:options:deallocator:)]
        unsafe fn newBufferWithBytesNoCopy_length_options_deallocator(
            &self,
            pointer: NonNull<c_void>,
            length: NSUInteger,
            options: MTLResourceOptions,
            deallocator: Option<&block2::Block<dyn Fn(NonNull<c_void>, NSUInteger)>>,
        ) -> Option<Retained<ProtocolObject<dyn MTLBuffer>>>;

        #[cfg(feature = "MTLDepthStencil")]
        #[method_id(@__retain_semantics New newDepthStencilStateWithDescriptor:)]
        fn newDepthStencilStateWithDescriptor(
            &self,
            descriptor: &MTLDepthStencilDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLDepthStencilState>>>;

        #[cfg(all(feature = "MTLResource", feature = "MTLTexture"))]
        #[method_id(@__retain_semantics New newTextureWithDescriptor:)]
        fn newTextureWithDescriptor(
            &self,
            descriptor: &MTLTextureDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLTexture>>>;

        #[cfg(all(feature = "MTLResource", feature = "MTLTexture"))]
        #[method_id(@__retain_semantics New newSharedTextureWithDescriptor:)]
        unsafe fn newSharedTextureWithDescriptor(
            &self,
            descriptor: &MTLTextureDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLTexture>>>;

        #[cfg(all(feature = "MTLResource", feature = "MTLTexture"))]
        #[method_id(@__retain_semantics New newSharedTextureWithHandle:)]
        unsafe fn newSharedTextureWithHandle(
            &self,
            shared_handle: &MTLSharedTextureHandle,
        ) -> Option<Retained<ProtocolObject<dyn MTLTexture>>>;

        #[cfg(feature = "MTLSampler")]
        #[method_id(@__retain_semantics New newSamplerStateWithDescriptor:)]
        fn newSamplerStateWithDescriptor(
            &self,
            descriptor: &MTLSamplerDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLSamplerState>>>;

        #[cfg(feature = "MTLLibrary")]
        #[method_id(@__retain_semantics New newDefaultLibrary)]
        fn newDefaultLibrary(&self) -> Option<Retained<ProtocolObject<dyn MTLLibrary>>>;

        #[cfg(feature = "MTLLibrary")]
        #[method_id(@__retain_semantics New newDefaultLibraryWithBundle:error:_)]
        unsafe fn newDefaultLibraryWithBundle_error(
            &self,
            bundle: &NSBundle,
        ) -> Result<Retained<ProtocolObject<dyn MTLLibrary>>, Retained<NSError>>;

        #[cfg(feature = "MTLLibrary")]
        #[deprecated = "Use -newLibraryWithURL:error: instead"]
        #[method_id(@__retain_semantics New newLibraryWithFile:error:_)]
        fn newLibraryWithFile_error(
            &self,
            filepath: &NSString,
        ) -> Result<Retained<ProtocolObject<dyn MTLLibrary>>, Retained<NSError>>;

        #[cfg(feature = "MTLLibrary")]
        #[method_id(@__retain_semantics New newLibraryWithURL:error:_)]
        unsafe fn newLibraryWithURL_error(
            &self,
            url: &NSURL,
        ) -> Result<Retained<ProtocolObject<dyn MTLLibrary>>, Retained<NSError>>;

        #[cfg(feature = "MTLLibrary")]
        #[method_id(@__retain_semantics New newLibraryWithSource:options:error:_)]
        fn newLibraryWithSource_options_error(
            &self,
            source: &NSString,
            options: Option<&MTLCompileOptions>,
        ) -> Result<Retained<ProtocolObject<dyn MTLLibrary>>, Retained<NSError>>;

        #[cfg(all(feature = "MTLLibrary", feature = "block2"))]
        #[method(newLibraryWithSource:options:completionHandler:)]
        unsafe fn newLibraryWithSource_options_completionHandler(
            &self,
            source: &NSString,
            options: Option<&MTLCompileOptions>,
            completion_handler: MTLNewLibraryCompletionHandler,
        );

        #[cfg(all(feature = "MTLFunctionStitching", feature = "MTLLibrary"))]
        #[method_id(@__retain_semantics New newLibraryWithStitchedDescriptor:error:_)]
        unsafe fn newLibraryWithStitchedDescriptor_error(
            &self,
            descriptor: &MTLStitchedLibraryDescriptor,
        ) -> Result<Retained<ProtocolObject<dyn MTLLibrary>>, Retained<NSError>>;

        #[cfg(all(
            feature = "MTLFunctionStitching",
            feature = "MTLLibrary",
            feature = "block2"
        ))]
        #[method(newLibraryWithStitchedDescriptor:completionHandler:)]
        unsafe fn newLibraryWithStitchedDescriptor_completionHandler(
            &self,
            descriptor: &MTLStitchedLibraryDescriptor,
            completion_handler: MTLNewLibraryCompletionHandler,
        );

        #[cfg(feature = "MTLRenderPipeline")]
        #[method_id(@__retain_semantics New newRenderPipelineStateWithDescriptor:error:_)]
        fn newRenderPipelineStateWithDescriptor_error(
            &self,
            descriptor: &MTLRenderPipelineDescriptor,
        ) -> Result<Retained<ProtocolObject<dyn MTLRenderPipelineState>>, Retained<NSError>>;

        #[cfg(all(feature = "MTLRenderPipeline", feature = "block2"))]
        #[method(newRenderPipelineStateWithDescriptor:completionHandler:)]
        unsafe fn newRenderPipelineStateWithDescriptor_completionHandler(
            &self,
            descriptor: &MTLRenderPipelineDescriptor,
            completion_handler: MTLNewRenderPipelineStateCompletionHandler,
        );

        #[cfg(all(feature = "MTLRenderPipeline", feature = "block2"))]
        #[method(newRenderPipelineStateWithDescriptor:options:completionHandler:)]
        unsafe fn newRenderPipelineStateWithDescriptor_options_completionHandler(
            &self,
            descriptor: &MTLRenderPipelineDescriptor,
            options: MTLPipelineOption,
            completion_handler: MTLNewRenderPipelineStateWithReflectionCompletionHandler,
        );

        #[cfg(all(feature = "MTLComputePipeline", feature = "MTLLibrary"))]
        #[method_id(@__retain_semantics New newComputePipelineStateWithFunction:error:_)]
        fn newComputePipelineStateWithFunction_error(
            &self,
            compute_function: &ProtocolObject<dyn MTLFunction>,
        ) -> Result<Retained<ProtocolObject<dyn MTLComputePipelineState>>, Retained<NSError>>;

        #[cfg(all(
            feature = "MTLComputePipeline",
            feature = "MTLLibrary",
            feature = "block2"
        ))]
        #[method(newComputePipelineStateWithFunction:completionHandler:)]
        unsafe fn newComputePipelineStateWithFunction_completionHandler(
            &self,
            compute_function: &ProtocolObject<dyn MTLFunction>,
            completion_handler: MTLNewComputePipelineStateCompletionHandler,
        );

        #[cfg(all(
            feature = "MTLComputePipeline",
            feature = "MTLLibrary",
            feature = "block2"
        ))]
        #[method(newComputePipelineStateWithFunction:options:completionHandler:)]
        unsafe fn newComputePipelineStateWithFunction_options_completionHandler(
            &self,
            compute_function: &ProtocolObject<dyn MTLFunction>,
            options: MTLPipelineOption,
            completion_handler: MTLNewComputePipelineStateWithReflectionCompletionHandler,
        );

        #[cfg(all(feature = "MTLComputePipeline", feature = "block2"))]
        #[method(newComputePipelineStateWithDescriptor:options:completionHandler:)]
        unsafe fn newComputePipelineStateWithDescriptor_options_completionHandler(
            &self,
            descriptor: &MTLComputePipelineDescriptor,
            options: MTLPipelineOption,
            completion_handler: MTLNewComputePipelineStateWithReflectionCompletionHandler,
        );

        #[cfg(feature = "MTLFence")]
        #[method_id(@__retain_semantics New newFence)]
        fn newFence(&self) -> Option<Retained<ProtocolObject<dyn MTLFence>>>;

        #[deprecated = "Use supportsFamily instead"]
        #[method(supportsFeatureSet:)]
        fn supportsFeatureSet(&self, feature_set: MTLFeatureSet) -> bool;

        #[method(supportsFamily:)]
        fn supportsFamily(&self, gpu_family: MTLGPUFamily) -> bool;

        #[method(supportsTextureSampleCount:)]
        fn supportsTextureSampleCount(&self, sample_count: NSUInteger) -> bool;

        #[cfg(feature = "MTLPixelFormat")]
        #[method(minimumLinearTextureAlignmentForPixelFormat:)]
        fn minimumLinearTextureAlignmentForPixelFormat(&self, format: MTLPixelFormat)
            -> NSUInteger;

        #[cfg(feature = "MTLPixelFormat")]
        #[method(minimumTextureBufferAlignmentForPixelFormat:)]
        fn minimumTextureBufferAlignmentForPixelFormat(&self, format: MTLPixelFormat)
            -> NSUInteger;

        #[cfg(all(feature = "MTLRenderPipeline", feature = "block2"))]
        #[method(newRenderPipelineStateWithTileDescriptor:options:completionHandler:)]
        unsafe fn newRenderPipelineStateWithTileDescriptor_options_completionHandler(
            &self,
            descriptor: &MTLTileRenderPipelineDescriptor,
            options: MTLPipelineOption,
            completion_handler: MTLNewRenderPipelineStateWithReflectionCompletionHandler,
        );

        #[cfg(all(feature = "MTLRenderPipeline", feature = "block2"))]
        #[method(newRenderPipelineStateWithMeshDescriptor:options:completionHandler:)]
        unsafe fn newRenderPipelineStateWithMeshDescriptor_options_completionHandler(
            &self,
            descriptor: &MTLMeshRenderPipelineDescriptor,
            options: MTLPipelineOption,
            completion_handler: MTLNewRenderPipelineStateWithReflectionCompletionHandler,
        );

        #[method(maxThreadgroupMemoryLength)]
        fn maxThreadgroupMemoryLength(&self) -> NSUInteger;

        #[method(maxArgumentBufferSamplerCount)]
        fn maxArgumentBufferSamplerCount(&self) -> NSUInteger;

        #[method(areProgrammableSamplePositionsSupported)]
        unsafe fn areProgrammableSamplePositionsSupported(&self) -> bool;

        #[cfg(feature = "MTLTypes")]
        #[method(getDefaultSamplePositions:count:)]
        unsafe fn getDefaultSamplePositions_count(
            &self,
            positions: NonNull<MTLSamplePosition>,
            count: NSUInteger,
        );

        #[cfg(feature = "MTLArgumentEncoder")]
        #[method_id(@__retain_semantics New newArgumentEncoderWithArguments:)]
        fn newArgumentEncoderWithArguments(
            &self,
            arguments: &NSArray<MTLArgumentDescriptor>,
        ) -> Option<Retained<ProtocolObject<dyn MTLArgumentEncoder>>>;

        #[method(supportsRasterizationRateMapWithLayerCount:)]
        unsafe fn supportsRasterizationRateMapWithLayerCount(
            &self,
            layer_count: NSUInteger,
        ) -> bool;

        #[cfg(feature = "MTLRasterizationRate")]
        #[method_id(@__retain_semantics New newRasterizationRateMapWithDescriptor:)]
        unsafe fn newRasterizationRateMapWithDescriptor(
            &self,
            descriptor: &MTLRasterizationRateMapDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLRasterizationRateMap>>>;

        #[cfg(all(feature = "MTLIndirectCommandBuffer", feature = "MTLResource"))]
        #[method_id(@__retain_semantics New newIndirectCommandBufferWithDescriptor:maxCommandCount:options:)]
        unsafe fn newIndirectCommandBufferWithDescriptor_maxCommandCount_options(
            &self,
            descriptor: &MTLIndirectCommandBufferDescriptor,
            max_count: NSUInteger,
            options: MTLResourceOptions,
        ) -> Option<Retained<ProtocolObject<dyn MTLIndirectCommandBuffer>>>;

        #[cfg(feature = "MTLEvent")]
        #[method_id(@__retain_semantics New newEvent)]
        fn newEvent(&self) -> Option<Retained<ProtocolObject<dyn MTLEvent>>>;

        #[cfg(feature = "MTLEvent")]
        #[method_id(@__retain_semantics New newSharedEvent)]
        fn newSharedEvent(&self) -> Option<Retained<ProtocolObject<dyn MTLSharedEvent>>>;

        #[cfg(feature = "MTLEvent")]
        #[method_id(@__retain_semantics New newSharedEventWithHandle:)]
        unsafe fn newSharedEventWithHandle(
            &self,
            shared_event_handle: &MTLSharedEventHandle,
        ) -> Option<Retained<ProtocolObject<dyn MTLSharedEvent>>>;

        #[method(peerGroupID)]
        unsafe fn peerGroupID(&self) -> u64;

        #[method(peerIndex)]
        unsafe fn peerIndex(&self) -> u32;

        #[method(peerCount)]
        unsafe fn peerCount(&self) -> u32;

        #[cfg(feature = "MTLIOCommandQueue")]
        #[deprecated]
        #[method_id(@__retain_semantics New newIOHandleWithURL:error:_)]
        unsafe fn newIOHandleWithURL_error(
            &self,
            url: &NSURL,
        ) -> Result<Retained<ProtocolObject<dyn MTLIOFileHandle>>, Retained<NSError>>;

        #[cfg(feature = "MTLIOCommandQueue")]
        #[method_id(@__retain_semantics New newIOCommandQueueWithDescriptor:error:_)]
        unsafe fn newIOCommandQueueWithDescriptor_error(
            &self,
            descriptor: &MTLIOCommandQueueDescriptor,
        ) -> Result<Retained<ProtocolObject<dyn MTLIOCommandQueue>>, Retained<NSError>>;

        #[cfg(feature = "MTLIOCommandQueue")]
        #[deprecated]
        #[method_id(@__retain_semantics New newIOHandleWithURL:compressionMethod:error:_)]
        unsafe fn newIOHandleWithURL_compressionMethod_error(
            &self,
            url: &NSURL,
            compression_method: MTLIOCompressionMethod,
        ) -> Result<Retained<ProtocolObject<dyn MTLIOFileHandle>>, Retained<NSError>>;

        #[cfg(feature = "MTLIOCommandQueue")]
        #[method_id(@__retain_semantics New newIOFileHandleWithURL:error:_)]
        unsafe fn newIOFileHandleWithURL_error(
            &self,
            url: &NSURL,
        ) -> Result<Retained<ProtocolObject<dyn MTLIOFileHandle>>, Retained<NSError>>;

        #[cfg(feature = "MTLIOCommandQueue")]
        #[method_id(@__retain_semantics New newIOFileHandleWithURL:compressionMethod:error:_)]
        unsafe fn newIOFileHandleWithURL_compressionMethod_error(
            &self,
            url: &NSURL,
            compression_method: MTLIOCompressionMethod,
        ) -> Result<Retained<ProtocolObject<dyn MTLIOFileHandle>>, Retained<NSError>>;

        #[cfg(all(
            feature = "MTLPixelFormat",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        #[method(sparseTileSizeWithTextureType:pixelFormat:sampleCount:)]
        unsafe fn sparseTileSizeWithTextureType_pixelFormat_sampleCount(
            &self,
            texture_type: MTLTextureType,
            pixel_format: MTLPixelFormat,
            sample_count: NSUInteger,
        ) -> MTLSize;

        #[method(sparseTileSizeInBytes)]
        unsafe fn sparseTileSizeInBytes(&self) -> NSUInteger;

        #[cfg(feature = "MTLTypes")]
        #[optional]
        #[method(convertSparsePixelRegions:toTileRegions:withTileSize:alignmentMode:numRegions:)]
        unsafe fn convertSparsePixelRegions_toTileRegions_withTileSize_alignmentMode_numRegions(
            &self,
            pixel_regions: NonNull<MTLRegion>,
            tile_regions: NonNull<MTLRegion>,
            tile_size: MTLSize,
            mode: MTLSparseTextureRegionAlignmentMode,
            num_regions: NSUInteger,
        );

        #[cfg(feature = "MTLTypes")]
        #[optional]
        #[method(convertSparseTileRegions:toPixelRegions:withTileSize:numRegions:)]
        unsafe fn convertSparseTileRegions_toPixelRegions_withTileSize_numRegions(
            &self,
            tile_regions: NonNull<MTLRegion>,
            pixel_regions: NonNull<MTLRegion>,
            tile_size: MTLSize,
            num_regions: NSUInteger,
        );

        #[method(sparseTileSizeInBytesForSparsePageSize:)]
        unsafe fn sparseTileSizeInBytesForSparsePageSize(
            &self,
            sparse_page_size: MTLSparsePageSize,
        ) -> NSUInteger;

        #[cfg(all(
            feature = "MTLPixelFormat",
            feature = "MTLTexture",
            feature = "MTLTypes"
        ))]
        #[method(sparseTileSizeWithTextureType:pixelFormat:sampleCount:sparsePageSize:)]
        unsafe fn sparseTileSizeWithTextureType_pixelFormat_sampleCount_sparsePageSize(
            &self,
            texture_type: MTLTextureType,
            pixel_format: MTLPixelFormat,
            sample_count: NSUInteger,
            sparse_page_size: MTLSparsePageSize,
        ) -> MTLSize;

        #[method(maxBufferLength)]
        fn maxBufferLength(&self) -> NSUInteger;

        #[cfg(feature = "MTLCounters")]
        #[method_id(@__retain_semantics Other counterSets)]
        unsafe fn counterSets(
            &self,
        ) -> Option<Retained<NSArray<ProtocolObject<dyn MTLCounterSet>>>>;

        #[cfg(feature = "MTLCounters")]
        #[method_id(@__retain_semantics New newCounterSampleBufferWithDescriptor:error:_)]
        unsafe fn newCounterSampleBufferWithDescriptor_error(
            &self,
            descriptor: &MTLCounterSampleBufferDescriptor,
        ) -> Result<Retained<ProtocolObject<dyn MTLCounterSampleBuffer>>, Retained<NSError>>;

        #[method(sampleTimestamps:gpuTimestamp:)]
        unsafe fn sampleTimestamps_gpuTimestamp(
            &self,
            cpu_timestamp: NonNull<MTLTimestamp>,
            gpu_timestamp: NonNull<MTLTimestamp>,
        );

        #[cfg(all(feature = "MTLArgument", feature = "MTLArgumentEncoder"))]
        #[method_id(@__retain_semantics New newArgumentEncoderWithBufferBinding:)]
        unsafe fn newArgumentEncoderWithBufferBinding(
            &self,
            buffer_binding: &ProtocolObject<dyn MTLBufferBinding>,
        ) -> Retained<ProtocolObject<dyn MTLArgumentEncoder>>;

        #[method(supportsCounterSampling:)]
        fn supportsCounterSampling(&self, sampling_point: MTLCounterSamplingPoint) -> bool;

        #[method(supportsVertexAmplificationCount:)]
        fn supportsVertexAmplificationCount(&self, count: NSUInteger) -> bool;

        #[method(supportsDynamicLibraries)]
        fn supportsDynamicLibraries(&self) -> bool;

        #[method(supportsRenderDynamicLibraries)]
        unsafe fn supportsRenderDynamicLibraries(&self) -> bool;

        #[cfg(all(feature = "MTLDynamicLibrary", feature = "MTLLibrary"))]
        #[method_id(@__retain_semantics New newDynamicLibrary:error:_)]
        fn newDynamicLibrary_error(
            &self,
            library: &ProtocolObject<dyn MTLLibrary>,
        ) -> Result<Retained<ProtocolObject<dyn MTLDynamicLibrary>>, Retained<NSError>>;

        #[cfg(feature = "MTLDynamicLibrary")]
        #[method_id(@__retain_semantics New newDynamicLibraryWithURL:error:_)]
        fn newDynamicLibraryWithURL_error(
            &self,
            url: &NSURL,
        ) -> Result<Retained<ProtocolObject<dyn MTLDynamicLibrary>>, Retained<NSError>>;

        #[cfg(feature = "MTLBinaryArchive")]
        #[method_id(@__retain_semantics New newBinaryArchiveWithDescriptor:error:_)]
        fn newBinaryArchiveWithDescriptor_error(
            &self,
            descriptor: &MTLBinaryArchiveDescriptor,
        ) -> Result<Retained<ProtocolObject<dyn MTLBinaryArchive>>, Retained<NSError>>;

        #[method(supportsRaytracing)]
        fn supportsRaytracing(&self) -> bool;

        #[cfg(feature = "MTLAccelerationStructure")]
        #[method(accelerationStructureSizesWithDescriptor:)]
        fn accelerationStructureSizesWithDescriptor(
            &self,
            descriptor: &MTLAccelerationStructureDescriptor,
        ) -> MTLAccelerationStructureSizes;

        #[cfg(all(feature = "MTLAccelerationStructure", feature = "MTLResource"))]
        #[method_id(@__retain_semantics New newAccelerationStructureWithSize:)]
        fn newAccelerationStructureWithSize(
            &self,
            size: NSUInteger,
        ) -> Option<Retained<ProtocolObject<dyn MTLAccelerationStructure>>>;

        #[cfg(all(feature = "MTLAccelerationStructure", feature = "MTLResource"))]
        #[method_id(@__retain_semantics New newAccelerationStructureWithDescriptor:)]
        unsafe fn newAccelerationStructureWithDescriptor(
            &self,
            descriptor: &MTLAccelerationStructureDescriptor,
        ) -> Option<Retained<ProtocolObject<dyn MTLAccelerationStructure>>>;

        #[method(heapAccelerationStructureSizeAndAlignWithSize:)]
        unsafe fn heapAccelerationStructureSizeAndAlignWithSize(
            &self,
            size: NSUInteger,
        ) -> MTLSizeAndAlign;

        #[cfg(feature = "MTLAccelerationStructure")]
        #[method(heapAccelerationStructureSizeAndAlignWithDescriptor:)]
        unsafe fn heapAccelerationStructureSizeAndAlignWithDescriptor(
            &self,
            descriptor: &MTLAccelerationStructureDescriptor,
        ) -> MTLSizeAndAlign;

        #[method(supportsFunctionPointers)]
        fn supportsFunctionPointers(&self) -> bool;

        #[method(supportsFunctionPointersFromRender)]
        unsafe fn supportsFunctionPointersFromRender(&self) -> bool;

        #[method(supportsRaytracingFromRender)]
        unsafe fn supportsRaytracingFromRender(&self) -> bool;

        #[method(supportsPrimitiveMotionBlur)]
        unsafe fn supportsPrimitiveMotionBlur(&self) -> bool;

        #[method(shouldMaximizeConcurrentCompilation)]
        unsafe fn shouldMaximizeConcurrentCompilation(&self) -> bool;

        #[method(setShouldMaximizeConcurrentCompilation:)]
        unsafe fn setShouldMaximizeConcurrentCompilation(
            &self,
            should_maximize_concurrent_compilation: bool,
        );

        #[method(maximumConcurrentCompilationTaskCount)]
        unsafe fn maximumConcurrentCompilationTaskCount(&self) -> NSUInteger;
    }

    unsafe impl ProtocolType for dyn MTLDevice {}
);
