// Copyright (c) 2020, NVIDIA CORPORATION. All rights reserved.
//
// Licensed under the Apache License, Version 2.0 (the "License");
// you may not use this file except in compliance with the License.
// You may obtain a copy of the License at
//
//     http://www.apache.org/licenses/LICENSE-2.0
//
// Unless required by applicable law or agreed to in writing, software
// distributed under the License is distributed on an "AS IS" BASIS,
// WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
// See the License for the specific language governing permissions and
// limitations under the License.

// WARNING: THIS FILE WAS AUTOMATICALLY GENERATED.
// Code generated by https://git.io/c-for-go. DO NOT EDIT.

package nvml

/*
#cgo linux LDFLAGS: -Wl,--export-dynamic -Wl,--unresolved-symbols=ignore-in-object-files
#cgo darwin LDFLAGS: -Wl,-undefined,dynamic_lookup
#cgo CFLAGS: -DNVML_NO_UNVERSIONED_FUNC_DEFS=1
#include "nvml.h"
#include <stdlib.h>
#include "cgo_helpers.h"
*/
import "C"

const (
	// NO_UNVERSIONED_FUNC_DEFS as defined in go-nvml/<predefine>:24
	NO_UNVERSIONED_FUNC_DEFS = 1
	// API_VERSION as defined in nvml/nvml.h
	API_VERSION = 12
	// API_VERSION_STR as defined in nvml/nvml.h
	API_VERSION_STR = "12"
	// VALUE_NOT_AVAILABLE as defined in nvml/nvml.h
	VALUE_NOT_AVAILABLE = -1
	// DEVICE_PCI_BUS_ID_BUFFER_SIZE as defined in nvml/nvml.h
	DEVICE_PCI_BUS_ID_BUFFER_SIZE = 32
	// DEVICE_PCI_BUS_ID_BUFFER_V2_SIZE as defined in nvml/nvml.h
	DEVICE_PCI_BUS_ID_BUFFER_V2_SIZE = 16
	// DEVICE_PCI_BUS_ID_LEGACY_FMT as defined in nvml/nvml.h
	DEVICE_PCI_BUS_ID_LEGACY_FMT = "%04X:%02X:%02X.0"
	// DEVICE_PCI_BUS_ID_FMT as defined in nvml/nvml.h
	DEVICE_PCI_BUS_ID_FMT = "%08X:%02X:%02X.0"
	// NVLINK_MAX_LINKS as defined in nvml/nvml.h
	NVLINK_MAX_LINKS = 18
	// TOPOLOGY_CPU as defined in nvml/nvml.h
	TOPOLOGY_CPU = 0
	// MAX_PHYSICAL_BRIDGE as defined in nvml/nvml.h
	MAX_PHYSICAL_BRIDGE = 128
	// MAX_THERMAL_SENSORS_PER_GPU as defined in nvml/nvml.h
	MAX_THERMAL_SENSORS_PER_GPU = 3
	// DEVICE_UUID_ASCII_LEN as defined in nvml/nvml.h
	DEVICE_UUID_ASCII_LEN = 41
	// DEVICE_UUID_BINARY_LEN as defined in nvml/nvml.h
	DEVICE_UUID_BINARY_LEN = 16
	// FlagDefault as defined in nvml/nvml.h
	FlagDefault = 0
	// FlagForce as defined in nvml/nvml.h
	FlagForce = 1
	// SINGLE_BIT_ECC as defined in nvml/nvml.h
	SINGLE_BIT_ECC = 0
	// DOUBLE_BIT_ECC as defined in nvml/nvml.h
	DOUBLE_BIT_ECC = 0
	// MAX_GPU_PERF_PSTATES as defined in nvml/nvml.h
	MAX_GPU_PERF_PSTATES = 16
	// PERF_MODES_BUFFER_SIZE as defined in nvml/nvml.h
	PERF_MODES_BUFFER_SIZE = 2048
	// GSP_FIRMWARE_VERSION_BUF_SIZE as defined in nvml/nvml.h
	GSP_FIRMWARE_VERSION_BUF_SIZE = 64
	// DEVICE_ARCH_KEPLER as defined in nvml/nvml.h
	DEVICE_ARCH_KEPLER = 2
	// DEVICE_ARCH_MAXWELL as defined in nvml/nvml.h
	DEVICE_ARCH_MAXWELL = 3
	// DEVICE_ARCH_PASCAL as defined in nvml/nvml.h
	DEVICE_ARCH_PASCAL = 4
	// DEVICE_ARCH_VOLTA as defined in nvml/nvml.h
	DEVICE_ARCH_VOLTA = 5
	// DEVICE_ARCH_TURING as defined in nvml/nvml.h
	DEVICE_ARCH_TURING = 6
	// DEVICE_ARCH_AMPERE as defined in nvml/nvml.h
	DEVICE_ARCH_AMPERE = 7
	// DEVICE_ARCH_ADA as defined in nvml/nvml.h
	DEVICE_ARCH_ADA = 8
	// DEVICE_ARCH_HOPPER as defined in nvml/nvml.h
	DEVICE_ARCH_HOPPER = 9
	// DEVICE_ARCH_BLACKWELL as defined in nvml/nvml.h
	DEVICE_ARCH_BLACKWELL = 10
	// DEVICE_ARCH_T23X as defined in nvml/nvml.h
	DEVICE_ARCH_T23X = 11
	// DEVICE_ARCH_UNKNOWN as defined in nvml/nvml.h
	DEVICE_ARCH_UNKNOWN = 4294967295
	// BUS_TYPE_UNKNOWN as defined in nvml/nvml.h
	BUS_TYPE_UNKNOWN = 0
	// BUS_TYPE_PCI as defined in nvml/nvml.h
	BUS_TYPE_PCI = 1
	// BUS_TYPE_PCIE as defined in nvml/nvml.h
	BUS_TYPE_PCIE = 2
	// BUS_TYPE_FPCI as defined in nvml/nvml.h
	BUS_TYPE_FPCI = 3
	// BUS_TYPE_AGP as defined in nvml/nvml.h
	BUS_TYPE_AGP = 4
	// FAN_POLICY_TEMPERATURE_CONTINOUS_SW as defined in nvml/nvml.h
	FAN_POLICY_TEMPERATURE_CONTINOUS_SW = 0
	// FAN_POLICY_MANUAL as defined in nvml/nvml.h
	FAN_POLICY_MANUAL = 1
	// POWER_SOURCE_AC as defined in nvml/nvml.h
	POWER_SOURCE_AC = 0
	// POWER_SOURCE_BATTERY as defined in nvml/nvml.h
	POWER_SOURCE_BATTERY = 1
	// POWER_SOURCE_UNDERSIZED as defined in nvml/nvml.h
	POWER_SOURCE_UNDERSIZED = 2
	// PCIE_LINK_MAX_SPEED_INVALID as defined in nvml/nvml.h
	PCIE_LINK_MAX_SPEED_INVALID = 0
	// PCIE_LINK_MAX_SPEED_2500MBPS as defined in nvml/nvml.h
	PCIE_LINK_MAX_SPEED_2500MBPS = 1
	// PCIE_LINK_MAX_SPEED_5000MBPS as defined in nvml/nvml.h
	PCIE_LINK_MAX_SPEED_5000MBPS = 2
	// PCIE_LINK_MAX_SPEED_8000MBPS as defined in nvml/nvml.h
	PCIE_LINK_MAX_SPEED_8000MBPS = 3
	// PCIE_LINK_MAX_SPEED_16000MBPS as defined in nvml/nvml.h
	PCIE_LINK_MAX_SPEED_16000MBPS = 4
	// PCIE_LINK_MAX_SPEED_32000MBPS as defined in nvml/nvml.h
	PCIE_LINK_MAX_SPEED_32000MBPS = 5
	// PCIE_LINK_MAX_SPEED_64000MBPS as defined in nvml/nvml.h
	PCIE_LINK_MAX_SPEED_64000MBPS = 6
	// ADAPTIVE_CLOCKING_INFO_STATUS_DISABLED as defined in nvml/nvml.h
	ADAPTIVE_CLOCKING_INFO_STATUS_DISABLED = 0
	// ADAPTIVE_CLOCKING_INFO_STATUS_ENABLED as defined in nvml/nvml.h
	ADAPTIVE_CLOCKING_INFO_STATUS_ENABLED = 1
	// MAX_GPU_UTILIZATIONS as defined in nvml/nvml.h
	MAX_GPU_UTILIZATIONS = 8
	// PCIE_ATOMICS_CAP_FETCHADD32 as defined in nvml/nvml.h
	PCIE_ATOMICS_CAP_FETCHADD32 = 1
	// PCIE_ATOMICS_CAP_FETCHADD64 as defined in nvml/nvml.h
	PCIE_ATOMICS_CAP_FETCHADD64 = 2
	// PCIE_ATOMICS_CAP_SWAP32 as defined in nvml/nvml.h
	PCIE_ATOMICS_CAP_SWAP32 = 4
	// PCIE_ATOMICS_CAP_SWAP64 as defined in nvml/nvml.h
	PCIE_ATOMICS_CAP_SWAP64 = 8
	// PCIE_ATOMICS_CAP_CAS32 as defined in nvml/nvml.h
	PCIE_ATOMICS_CAP_CAS32 = 16
	// PCIE_ATOMICS_CAP_CAS64 as defined in nvml/nvml.h
	PCIE_ATOMICS_CAP_CAS64 = 32
	// PCIE_ATOMICS_CAP_CAS128 as defined in nvml/nvml.h
	PCIE_ATOMICS_CAP_CAS128 = 64
	// PCIE_ATOMICS_OPS_MAX as defined in nvml/nvml.h
	PCIE_ATOMICS_OPS_MAX = 7
	// POWER_SCOPE_GPU as defined in nvml/nvml.h
	POWER_SCOPE_GPU = 0
	// POWER_SCOPE_MODULE as defined in nvml/nvml.h
	POWER_SCOPE_MODULE = 1
	// POWER_SCOPE_MEMORY as defined in nvml/nvml.h
	POWER_SCOPE_MEMORY = 2
	// GRID_LICENSE_EXPIRY_NOT_AVAILABLE as defined in nvml/nvml.h
	GRID_LICENSE_EXPIRY_NOT_AVAILABLE = 0
	// GRID_LICENSE_EXPIRY_INVALID as defined in nvml/nvml.h
	GRID_LICENSE_EXPIRY_INVALID = 1
	// GRID_LICENSE_EXPIRY_VALID as defined in nvml/nvml.h
	GRID_LICENSE_EXPIRY_VALID = 2
	// GRID_LICENSE_EXPIRY_NOT_APPLICABLE as defined in nvml/nvml.h
	GRID_LICENSE_EXPIRY_NOT_APPLICABLE = 3
	// GRID_LICENSE_EXPIRY_PERMANENT as defined in nvml/nvml.h
	GRID_LICENSE_EXPIRY_PERMANENT = 4
	// GRID_LICENSE_BUFFER_SIZE as defined in nvml/nvml.h
	GRID_LICENSE_BUFFER_SIZE = 128
	// VGPU_NAME_BUFFER_SIZE as defined in nvml/nvml.h
	VGPU_NAME_BUFFER_SIZE = 64
	// GRID_LICENSE_FEATURE_MAX_COUNT as defined in nvml/nvml.h
	GRID_LICENSE_FEATURE_MAX_COUNT = 3
	// INVALID_VGPU_PLACEMENT_ID as defined in nvml/nvml.h
	INVALID_VGPU_PLACEMENT_ID = 65535
	// VGPU_PGPU_HETEROGENEOUS_MODE as defined in nvml/nvml.h
	VGPU_PGPU_HETEROGENEOUS_MODE = 0
	// VGPU_PGPU_HOMOGENEOUS_MODE as defined in nvml/nvml.h
	VGPU_PGPU_HOMOGENEOUS_MODE = 1
	// VGPU_SCHEDULER_POLICY_UNKNOWN as defined in nvml/nvml.h
	VGPU_SCHEDULER_POLICY_UNKNOWN = 0
	// VGPU_SCHEDULER_POLICY_BEST_EFFORT as defined in nvml/nvml.h
	VGPU_SCHEDULER_POLICY_BEST_EFFORT = 1
	// VGPU_SCHEDULER_POLICY_EQUAL_SHARE as defined in nvml/nvml.h
	VGPU_SCHEDULER_POLICY_EQUAL_SHARE = 2
	// VGPU_SCHEDULER_POLICY_FIXED_SHARE as defined in nvml/nvml.h
	VGPU_SCHEDULER_POLICY_FIXED_SHARE = 3
	// SUPPORTED_VGPU_SCHEDULER_POLICY_COUNT as defined in nvml/nvml.h
	SUPPORTED_VGPU_SCHEDULER_POLICY_COUNT = 3
	// SCHEDULER_SW_MAX_LOG_ENTRIES as defined in nvml/nvml.h
	SCHEDULER_SW_MAX_LOG_ENTRIES = 200
	// VGPU_SCHEDULER_ARR_DEFAULT as defined in nvml/nvml.h
	VGPU_SCHEDULER_ARR_DEFAULT = 0
	// VGPU_SCHEDULER_ARR_DISABLE as defined in nvml/nvml.h
	VGPU_SCHEDULER_ARR_DISABLE = 1
	// VGPU_SCHEDULER_ARR_ENABLE as defined in nvml/nvml.h
	VGPU_SCHEDULER_ARR_ENABLE = 2
	// VGPU_SCHEDULER_ENGINE_TYPE_GRAPHICS as defined in nvml/nvml.h
	VGPU_SCHEDULER_ENGINE_TYPE_GRAPHICS = 1
	// GRID_LICENSE_STATE_UNKNOWN as defined in nvml/nvml.h
	GRID_LICENSE_STATE_UNKNOWN = 0
	// GRID_LICENSE_STATE_UNINITIALIZED as defined in nvml/nvml.h
	GRID_LICENSE_STATE_UNINITIALIZED = 1
	// GRID_LICENSE_STATE_UNLICENSED_UNRESTRICTED as defined in nvml/nvml.h
	GRID_LICENSE_STATE_UNLICENSED_UNRESTRICTED = 2
	// GRID_LICENSE_STATE_UNLICENSED_RESTRICTED as defined in nvml/nvml.h
	GRID_LICENSE_STATE_UNLICENSED_RESTRICTED = 3
	// GRID_LICENSE_STATE_UNLICENSED as defined in nvml/nvml.h
	GRID_LICENSE_STATE_UNLICENSED = 4
	// GRID_LICENSE_STATE_LICENSED as defined in nvml/nvml.h
	GRID_LICENSE_STATE_LICENSED = 5
	// FI_DEV_ECC_CURRENT as defined in nvml/nvml.h
	FI_DEV_ECC_CURRENT = 1
	// FI_DEV_ECC_PENDING as defined in nvml/nvml.h
	FI_DEV_ECC_PENDING = 2
	// FI_DEV_ECC_SBE_VOL_TOTAL as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_VOL_TOTAL = 3
	// FI_DEV_ECC_DBE_VOL_TOTAL as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_VOL_TOTAL = 4
	// FI_DEV_ECC_SBE_AGG_TOTAL as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_AGG_TOTAL = 5
	// FI_DEV_ECC_DBE_AGG_TOTAL as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_AGG_TOTAL = 6
	// FI_DEV_ECC_SBE_VOL_L1 as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_VOL_L1 = 7
	// FI_DEV_ECC_DBE_VOL_L1 as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_VOL_L1 = 8
	// FI_DEV_ECC_SBE_VOL_L2 as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_VOL_L2 = 9
	// FI_DEV_ECC_DBE_VOL_L2 as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_VOL_L2 = 10
	// FI_DEV_ECC_SBE_VOL_DEV as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_VOL_DEV = 11
	// FI_DEV_ECC_DBE_VOL_DEV as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_VOL_DEV = 12
	// FI_DEV_ECC_SBE_VOL_REG as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_VOL_REG = 13
	// FI_DEV_ECC_DBE_VOL_REG as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_VOL_REG = 14
	// FI_DEV_ECC_SBE_VOL_TEX as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_VOL_TEX = 15
	// FI_DEV_ECC_DBE_VOL_TEX as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_VOL_TEX = 16
	// FI_DEV_ECC_DBE_VOL_CBU as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_VOL_CBU = 17
	// FI_DEV_ECC_SBE_AGG_L1 as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_AGG_L1 = 18
	// FI_DEV_ECC_DBE_AGG_L1 as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_AGG_L1 = 19
	// FI_DEV_ECC_SBE_AGG_L2 as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_AGG_L2 = 20
	// FI_DEV_ECC_DBE_AGG_L2 as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_AGG_L2 = 21
	// FI_DEV_ECC_SBE_AGG_DEV as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_AGG_DEV = 22
	// FI_DEV_ECC_DBE_AGG_DEV as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_AGG_DEV = 23
	// FI_DEV_ECC_SBE_AGG_REG as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_AGG_REG = 24
	// FI_DEV_ECC_DBE_AGG_REG as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_AGG_REG = 25
	// FI_DEV_ECC_SBE_AGG_TEX as defined in nvml/nvml.h
	FI_DEV_ECC_SBE_AGG_TEX = 26
	// FI_DEV_ECC_DBE_AGG_TEX as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_AGG_TEX = 27
	// FI_DEV_ECC_DBE_AGG_CBU as defined in nvml/nvml.h
	FI_DEV_ECC_DBE_AGG_CBU = 28
	// FI_DEV_RETIRED_SBE as defined in nvml/nvml.h
	FI_DEV_RETIRED_SBE = 29
	// FI_DEV_RETIRED_DBE as defined in nvml/nvml.h
	FI_DEV_RETIRED_DBE = 30
	// FI_DEV_RETIRED_PENDING as defined in nvml/nvml.h
	FI_DEV_RETIRED_PENDING = 31
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L0 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L0 = 32
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L1 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L1 = 33
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L2 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L2 = 34
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L3 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L3 = 35
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L4 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L4 = 36
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L5 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L5 = 37
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_TOTAL as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_TOTAL = 38
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L0 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L0 = 39
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L1 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L1 = 40
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L2 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L2 = 41
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L3 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L3 = 42
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L4 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L4 = 43
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L5 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L5 = 44
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_TOTAL as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_TOTAL = 45
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L0 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L0 = 46
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L1 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L1 = 47
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L2 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L2 = 48
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L3 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L3 = 49
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L4 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L4 = 50
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L5 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L5 = 51
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_TOTAL as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_TOTAL = 52
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L0 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L0 = 53
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L1 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L1 = 54
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L2 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L2 = 55
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L3 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L3 = 56
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L4 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L4 = 57
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L5 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L5 = 58
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_TOTAL as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_TOTAL = 59
	// FI_DEV_NVLINK_BANDWIDTH_C0_L0 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L0 = 60
	// FI_DEV_NVLINK_BANDWIDTH_C0_L1 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L1 = 61
	// FI_DEV_NVLINK_BANDWIDTH_C0_L2 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L2 = 62
	// FI_DEV_NVLINK_BANDWIDTH_C0_L3 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L3 = 63
	// FI_DEV_NVLINK_BANDWIDTH_C0_L4 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L4 = 64
	// FI_DEV_NVLINK_BANDWIDTH_C0_L5 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L5 = 65
	// FI_DEV_NVLINK_BANDWIDTH_C0_TOTAL as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_TOTAL = 66
	// FI_DEV_NVLINK_BANDWIDTH_C1_L0 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L0 = 67
	// FI_DEV_NVLINK_BANDWIDTH_C1_L1 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L1 = 68
	// FI_DEV_NVLINK_BANDWIDTH_C1_L2 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L2 = 69
	// FI_DEV_NVLINK_BANDWIDTH_C1_L3 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L3 = 70
	// FI_DEV_NVLINK_BANDWIDTH_C1_L4 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L4 = 71
	// FI_DEV_NVLINK_BANDWIDTH_C1_L5 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L5 = 72
	// FI_DEV_NVLINK_BANDWIDTH_C1_TOTAL as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_TOTAL = 73
	// FI_DEV_PERF_POLICY_POWER as defined in nvml/nvml.h
	FI_DEV_PERF_POLICY_POWER = 74
	// FI_DEV_PERF_POLICY_THERMAL as defined in nvml/nvml.h
	FI_DEV_PERF_POLICY_THERMAL = 75
	// FI_DEV_PERF_POLICY_SYNC_BOOST as defined in nvml/nvml.h
	FI_DEV_PERF_POLICY_SYNC_BOOST = 76
	// FI_DEV_PERF_POLICY_BOARD_LIMIT as defined in nvml/nvml.h
	FI_DEV_PERF_POLICY_BOARD_LIMIT = 77
	// FI_DEV_PERF_POLICY_LOW_UTILIZATION as defined in nvml/nvml.h
	FI_DEV_PERF_POLICY_LOW_UTILIZATION = 78
	// FI_DEV_PERF_POLICY_RELIABILITY as defined in nvml/nvml.h
	FI_DEV_PERF_POLICY_RELIABILITY = 79
	// FI_DEV_PERF_POLICY_TOTAL_APP_CLOCKS as defined in nvml/nvml.h
	FI_DEV_PERF_POLICY_TOTAL_APP_CLOCKS = 80
	// FI_DEV_PERF_POLICY_TOTAL_BASE_CLOCKS as defined in nvml/nvml.h
	FI_DEV_PERF_POLICY_TOTAL_BASE_CLOCKS = 81
	// FI_DEV_MEMORY_TEMP as defined in nvml/nvml.h
	FI_DEV_MEMORY_TEMP = 82
	// FI_DEV_TOTAL_ENERGY_CONSUMPTION as defined in nvml/nvml.h
	FI_DEV_TOTAL_ENERGY_CONSUMPTION = 83
	// FI_DEV_NVLINK_SPEED_MBPS_L0 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L0 = 84
	// FI_DEV_NVLINK_SPEED_MBPS_L1 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L1 = 85
	// FI_DEV_NVLINK_SPEED_MBPS_L2 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L2 = 86
	// FI_DEV_NVLINK_SPEED_MBPS_L3 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L3 = 87
	// FI_DEV_NVLINK_SPEED_MBPS_L4 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L4 = 88
	// FI_DEV_NVLINK_SPEED_MBPS_L5 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L5 = 89
	// FI_DEV_NVLINK_SPEED_MBPS_COMMON as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_COMMON = 90
	// FI_DEV_NVLINK_LINK_COUNT as defined in nvml/nvml.h
	FI_DEV_NVLINK_LINK_COUNT = 91
	// FI_DEV_RETIRED_PENDING_SBE as defined in nvml/nvml.h
	FI_DEV_RETIRED_PENDING_SBE = 92
	// FI_DEV_RETIRED_PENDING_DBE as defined in nvml/nvml.h
	FI_DEV_RETIRED_PENDING_DBE = 93
	// FI_DEV_PCIE_REPLAY_COUNTER as defined in nvml/nvml.h
	FI_DEV_PCIE_REPLAY_COUNTER = 94
	// FI_DEV_PCIE_REPLAY_ROLLOVER_COUNTER as defined in nvml/nvml.h
	FI_DEV_PCIE_REPLAY_ROLLOVER_COUNTER = 95
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L6 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L6 = 96
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L7 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L7 = 97
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L8 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L8 = 98
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L9 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L9 = 99
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L10 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L10 = 100
	// FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L11 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_FLIT_ERROR_COUNT_L11 = 101
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L6 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L6 = 102
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L7 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L7 = 103
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L8 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L8 = 104
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L9 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L9 = 105
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L10 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L10 = 106
	// FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L11 as defined in nvml/nvml.h
	FI_DEV_NVLINK_CRC_DATA_ERROR_COUNT_L11 = 107
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L6 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L6 = 108
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L7 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L7 = 109
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L8 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L8 = 110
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L9 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L9 = 111
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L10 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L10 = 112
	// FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L11 as defined in nvml/nvml.h
	FI_DEV_NVLINK_REPLAY_ERROR_COUNT_L11 = 113
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L6 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L6 = 114
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L7 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L7 = 115
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L8 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L8 = 116
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L9 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L9 = 117
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L10 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L10 = 118
	// FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L11 as defined in nvml/nvml.h
	FI_DEV_NVLINK_RECOVERY_ERROR_COUNT_L11 = 119
	// FI_DEV_NVLINK_BANDWIDTH_C0_L6 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L6 = 120
	// FI_DEV_NVLINK_BANDWIDTH_C0_L7 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L7 = 121
	// FI_DEV_NVLINK_BANDWIDTH_C0_L8 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L8 = 122
	// FI_DEV_NVLINK_BANDWIDTH_C0_L9 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L9 = 123
	// FI_DEV_NVLINK_BANDWIDTH_C0_L10 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L10 = 124
	// FI_DEV_NVLINK_BANDWIDTH_C0_L11 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C0_L11 = 125
	// FI_DEV_NVLINK_BANDWIDTH_C1_L6 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L6 = 126
	// FI_DEV_NVLINK_BANDWIDTH_C1_L7 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L7 = 127
	// FI_DEV_NVLINK_BANDWIDTH_C1_L8 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L8 = 128
	// FI_DEV_NVLINK_BANDWIDTH_C1_L9 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L9 = 129
	// FI_DEV_NVLINK_BANDWIDTH_C1_L10 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L10 = 130
	// FI_DEV_NVLINK_BANDWIDTH_C1_L11 as defined in nvml/nvml.h
	FI_DEV_NVLINK_BANDWIDTH_C1_L11 = 131
	// FI_DEV_NVLINK_SPEED_MBPS_L6 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L6 = 132
	// FI_DEV_NVLINK_SPEED_MBPS_L7 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L7 = 133
	// FI_DEV_NVLINK_SPEED_MBPS_L8 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L8 = 134
	// FI_DEV_NVLINK_SPEED_MBPS_L9 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L9 = 135
	// FI_DEV_NVLINK_SPEED_MBPS_L10 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L10 = 136
	// FI_DEV_NVLINK_SPEED_MBPS_L11 as defined in nvml/nvml.h
	FI_DEV_NVLINK_SPEED_MBPS_L11 = 137
	// FI_DEV_NVLINK_THROUGHPUT_DATA_TX as defined in nvml/nvml.h
	FI_DEV_NVLINK_THROUGHPUT_DATA_TX = 138
	// FI_DEV_NVLINK_THROUGHPUT_DATA_RX as defined in nvml/nvml.h
	FI_DEV_NVLINK_THROUGHPUT_DATA_RX = 139
	// FI_DEV_NVLINK_THROUGHPUT_RAW_TX as defined in nvml/nvml.h
	FI_DEV_NVLINK_THROUGHPUT_RAW_TX = 140
	// FI_DEV_NVLINK_THROUGHPUT_RAW_RX as defined in nvml/nvml.h
	FI_DEV_NVLINK_THROUGHPUT_RAW_RX = 141
	// FI_DEV_REMAPPED_COR as defined in nvml/nvml.h
	FI_DEV_REMAPPED_COR = 142
	// FI_DEV_REMAPPED_UNC as defined in nvml/nvml.h
	FI_DEV_REMAPPED_UNC = 143
	// FI_DEV_REMAPPED_PENDING as defined in nvml/nvml.h
	FI_DEV_REMAPPED_PENDING = 144
	// FI_DEV_REMAPPED_FAILURE as defined in nvml/nvml.h
	FI_DEV_REMAPPED_FAILURE = 145
	// FI_DEV_NVLINK_REMOTE_NVLINK_ID as defined in nvml/nvml.h
	FI_DEV_NVLINK_REMOTE_NVLINK_ID = 146
	// FI_DEV_NVSWITCH_CONNECTED_LINK_COUNT as defined in nvml/nvml.h
	FI_DEV_NVSWITCH_CONNECTED_LINK_COUNT = 147
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L0 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L0 = 148
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L1 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L1 = 149
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L2 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L2 = 150
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L3 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L3 = 151
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L4 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L4 = 152
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L5 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L5 = 153
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L6 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L6 = 154
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L7 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L7 = 155
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L8 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L8 = 156
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L9 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L9 = 157
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L10 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L10 = 158
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L11 as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_L11 = 159
	// FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_TOTAL as defined in nvml/nvml.h
	FI_DEV_NVLINK_ECC_DATA_ERROR_COUNT_TOTAL = 160
	// FI_DEV_NVLINK_ERROR_DL_REPLAY as defined in nvml/nvml.h
	FI_DEV_NVLINK_ERROR_DL_REPLAY = 161
	// FI_DEV_NVLINK_ERROR_DL_RECOVERY as defined in nvml/nvml.h
	FI_DEV_NVLINK_ERROR_DL_RECOVERY = 162
	// FI_DEV_NVLINK_ERROR_DL_CRC as defined in nvml/nvml.h
	FI_DEV_NVLINK_ERROR_DL_CRC = 163
	// FI_DEV_NVLINK_GET_SPEED as defined in nvml/nvml.h
	FI_DEV_NVLINK_GET_SPEED = 164
	// FI_DEV_NVLINK_GET_STATE as defined in nvml/nvml.h
	FI_DEV_NVLINK_GET_STATE = 165
	// FI_DEV_NVLINK_GET_VERSION as defined in nvml/nvml.h
	FI_DEV_NVLINK_GET_VERSION = 166
	// FI_DEV_NVLINK_GET_POWER_STATE as defined in nvml/nvml.h
	FI_DEV_NVLINK_GET_POWER_STATE = 167
	// FI_DEV_NVLINK_GET_POWER_THRESHOLD as defined in nvml/nvml.h
	FI_DEV_NVLINK_GET_POWER_THRESHOLD = 168
	// FI_DEV_PCIE_L0_TO_RECOVERY_COUNTER as defined in nvml/nvml.h
	FI_DEV_PCIE_L0_TO_RECOVERY_COUNTER = 169
	// FI_DEV_C2C_LINK_COUNT as defined in nvml/nvml.h
	FI_DEV_C2C_LINK_COUNT = 170
	// FI_DEV_C2C_LINK_GET_STATUS as defined in nvml/nvml.h
	FI_DEV_C2C_LINK_GET_STATUS = 171
	// FI_DEV_C2C_LINK_GET_MAX_BW as defined in nvml/nvml.h
	FI_DEV_C2C_LINK_GET_MAX_BW = 172
	// FI_DEV_PCIE_COUNT_CORRECTABLE_ERRORS as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_CORRECTABLE_ERRORS = 173
	// FI_DEV_PCIE_COUNT_NAKS_RECEIVED as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_NAKS_RECEIVED = 174
	// FI_DEV_PCIE_COUNT_RECEIVER_ERROR as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_RECEIVER_ERROR = 175
	// FI_DEV_PCIE_COUNT_BAD_TLP as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_BAD_TLP = 176
	// FI_DEV_PCIE_COUNT_NAKS_SENT as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_NAKS_SENT = 177
	// FI_DEV_PCIE_COUNT_BAD_DLLP as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_BAD_DLLP = 178
	// FI_DEV_PCIE_COUNT_NON_FATAL_ERROR as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_NON_FATAL_ERROR = 179
	// FI_DEV_PCIE_COUNT_FATAL_ERROR as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_FATAL_ERROR = 180
	// FI_DEV_PCIE_COUNT_UNSUPPORTED_REQ as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_UNSUPPORTED_REQ = 181
	// FI_DEV_PCIE_COUNT_LCRC_ERROR as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_LCRC_ERROR = 182
	// FI_DEV_PCIE_COUNT_LANE_ERROR as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_LANE_ERROR = 183
	// FI_DEV_IS_RESETLESS_MIG_SUPPORTED as defined in nvml/nvml.h
	FI_DEV_IS_RESETLESS_MIG_SUPPORTED = 184
	// FI_DEV_POWER_AVERAGE as defined in nvml/nvml.h
	FI_DEV_POWER_AVERAGE = 185
	// FI_DEV_POWER_INSTANT as defined in nvml/nvml.h
	FI_DEV_POWER_INSTANT = 186
	// FI_DEV_POWER_MIN_LIMIT as defined in nvml/nvml.h
	FI_DEV_POWER_MIN_LIMIT = 187
	// FI_DEV_POWER_MAX_LIMIT as defined in nvml/nvml.h
	FI_DEV_POWER_MAX_LIMIT = 188
	// FI_DEV_POWER_DEFAULT_LIMIT as defined in nvml/nvml.h
	FI_DEV_POWER_DEFAULT_LIMIT = 189
	// FI_DEV_POWER_CURRENT_LIMIT as defined in nvml/nvml.h
	FI_DEV_POWER_CURRENT_LIMIT = 190
	// FI_DEV_ENERGY as defined in nvml/nvml.h
	FI_DEV_ENERGY = 191
	// FI_DEV_POWER_REQUESTED_LIMIT as defined in nvml/nvml.h
	FI_DEV_POWER_REQUESTED_LIMIT = 192
	// FI_DEV_TEMPERATURE_SHUTDOWN_TLIMIT as defined in nvml/nvml.h
	FI_DEV_TEMPERATURE_SHUTDOWN_TLIMIT = 193
	// FI_DEV_TEMPERATURE_SLOWDOWN_TLIMIT as defined in nvml/nvml.h
	FI_DEV_TEMPERATURE_SLOWDOWN_TLIMIT = 194
	// FI_DEV_TEMPERATURE_MEM_MAX_TLIMIT as defined in nvml/nvml.h
	FI_DEV_TEMPERATURE_MEM_MAX_TLIMIT = 195
	// FI_DEV_TEMPERATURE_GPU_MAX_TLIMIT as defined in nvml/nvml.h
	FI_DEV_TEMPERATURE_GPU_MAX_TLIMIT = 196
	// FI_DEV_PCIE_COUNT_TX_BYTES as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_TX_BYTES = 197
	// FI_DEV_PCIE_COUNT_RX_BYTES as defined in nvml/nvml.h
	FI_DEV_PCIE_COUNT_RX_BYTES = 198
	// FI_DEV_IS_MIG_MODE_INDEPENDENT_MIG_QUERY_CAPABLE as defined in nvml/nvml.h
	FI_DEV_IS_MIG_MODE_INDEPENDENT_MIG_QUERY_CAPABLE = 199
	// FI_DEV_NVLINK_GET_POWER_THRESHOLD_MAX as defined in nvml/nvml.h
	FI_DEV_NVLINK_GET_POWER_THRESHOLD_MAX = 200
	// FI_DEV_NVLINK_COUNT_XMIT_PACKETS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_XMIT_PACKETS = 201
	// FI_DEV_NVLINK_COUNT_XMIT_BYTES as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_XMIT_BYTES = 202
	// FI_DEV_NVLINK_COUNT_RCV_PACKETS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_RCV_PACKETS = 203
	// FI_DEV_NVLINK_COUNT_RCV_BYTES as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_RCV_BYTES = 204
	// FI_DEV_NVLINK_COUNT_VL15_DROPPED as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_VL15_DROPPED = 205
	// FI_DEV_NVLINK_COUNT_MALFORMED_PACKET_ERRORS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_MALFORMED_PACKET_ERRORS = 206
	// FI_DEV_NVLINK_COUNT_BUFFER_OVERRUN_ERRORS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_BUFFER_OVERRUN_ERRORS = 207
	// FI_DEV_NVLINK_COUNT_RCV_ERRORS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_RCV_ERRORS = 208
	// FI_DEV_NVLINK_COUNT_RCV_REMOTE_ERRORS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_RCV_REMOTE_ERRORS = 209
	// FI_DEV_NVLINK_COUNT_RCV_GENERAL_ERRORS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_RCV_GENERAL_ERRORS = 210
	// FI_DEV_NVLINK_COUNT_LOCAL_LINK_INTEGRITY_ERRORS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_LOCAL_LINK_INTEGRITY_ERRORS = 211
	// FI_DEV_NVLINK_COUNT_XMIT_DISCARDS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_XMIT_DISCARDS = 212
	// FI_DEV_NVLINK_COUNT_LINK_RECOVERY_SUCCESSFUL_EVENTS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_LINK_RECOVERY_SUCCESSFUL_EVENTS = 213
	// FI_DEV_NVLINK_COUNT_LINK_RECOVERY_FAILED_EVENTS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_LINK_RECOVERY_FAILED_EVENTS = 214
	// FI_DEV_NVLINK_COUNT_LINK_RECOVERY_EVENTS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_LINK_RECOVERY_EVENTS = 215
	// FI_DEV_NVLINK_COUNT_RAW_BER_LANE0 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_RAW_BER_LANE0 = 216
	// FI_DEV_NVLINK_COUNT_RAW_BER_LANE1 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_RAW_BER_LANE1 = 217
	// FI_DEV_NVLINK_COUNT_RAW_BER as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_RAW_BER = 218
	// FI_DEV_NVLINK_COUNT_EFFECTIVE_ERRORS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_EFFECTIVE_ERRORS = 219
	// FI_DEV_NVLINK_COUNT_EFFECTIVE_BER as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_EFFECTIVE_BER = 220
	// FI_DEV_NVLINK_COUNT_SYMBOL_ERRORS as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_SYMBOL_ERRORS = 221
	// FI_DEV_NVLINK_COUNT_SYMBOL_BER as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_SYMBOL_BER = 222
	// FI_DEV_NVLINK_GET_POWER_THRESHOLD_MIN as defined in nvml/nvml.h
	FI_DEV_NVLINK_GET_POWER_THRESHOLD_MIN = 223
	// FI_DEV_NVLINK_GET_POWER_THRESHOLD_UNITS as defined in nvml/nvml.h
	FI_DEV_NVLINK_GET_POWER_THRESHOLD_UNITS = 224
	// FI_DEV_NVLINK_GET_POWER_THRESHOLD_SUPPORTED as defined in nvml/nvml.h
	FI_DEV_NVLINK_GET_POWER_THRESHOLD_SUPPORTED = 225
	// FI_DEV_RESET_STATUS as defined in nvml/nvml.h
	FI_DEV_RESET_STATUS = 226
	// FI_DEV_DRAIN_AND_RESET_STATUS as defined in nvml/nvml.h
	FI_DEV_DRAIN_AND_RESET_STATUS = 227
	// FI_DEV_PCIE_OUTBOUND_ATOMICS_MASK as defined in nvml/nvml.h
	FI_DEV_PCIE_OUTBOUND_ATOMICS_MASK = 228
	// FI_DEV_PCIE_INBOUND_ATOMICS_MASK as defined in nvml/nvml.h
	FI_DEV_PCIE_INBOUND_ATOMICS_MASK = 229
	// FI_DEV_GET_GPU_RECOVERY_ACTION as defined in nvml/nvml.h
	FI_DEV_GET_GPU_RECOVERY_ACTION = 230
	// FI_DEV_C2C_LINK_ERROR_INTR as defined in nvml/nvml.h
	FI_DEV_C2C_LINK_ERROR_INTR = 231
	// FI_DEV_C2C_LINK_ERROR_REPLAY as defined in nvml/nvml.h
	FI_DEV_C2C_LINK_ERROR_REPLAY = 232
	// FI_DEV_C2C_LINK_ERROR_REPLAY_B2B as defined in nvml/nvml.h
	FI_DEV_C2C_LINK_ERROR_REPLAY_B2B = 233
	// FI_DEV_C2C_LINK_POWER_STATE as defined in nvml/nvml.h
	FI_DEV_C2C_LINK_POWER_STATE = 234
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_0 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_0 = 235
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_1 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_1 = 236
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_2 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_2 = 237
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_3 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_3 = 238
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_4 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_4 = 239
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_5 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_5 = 240
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_6 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_6 = 241
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_7 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_7 = 242
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_8 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_8 = 243
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_9 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_9 = 244
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_10 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_10 = 245
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_11 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_11 = 246
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_12 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_12 = 247
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_13 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_13 = 248
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_14 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_14 = 249
	// FI_DEV_NVLINK_COUNT_FEC_HISTORY_15 as defined in nvml/nvml.h
	FI_DEV_NVLINK_COUNT_FEC_HISTORY_15 = 250
	// FI_DEV_CLOCKS_EVENT_REASON_SW_POWER_CAP as defined in nvml/nvml.h
	FI_DEV_CLOCKS_EVENT_REASON_SW_POWER_CAP = 74
	// FI_DEV_CLOCKS_EVENT_REASON_SYNC_BOOST as defined in nvml/nvml.h
	FI_DEV_CLOCKS_EVENT_REASON_SYNC_BOOST = 76
	// FI_DEV_CLOCKS_EVENT_REASON_SW_THERM_SLOWDOWN as defined in nvml/nvml.h
	FI_DEV_CLOCKS_EVENT_REASON_SW_THERM_SLOWDOWN = 251
	// FI_DEV_CLOCKS_EVENT_REASON_HW_THERM_SLOWDOWN as defined in nvml/nvml.h
	FI_DEV_CLOCKS_EVENT_REASON_HW_THERM_SLOWDOWN = 252
	// FI_DEV_CLOCKS_EVENT_REASON_HW_POWER_BRAKE_SLOWDOWN as defined in nvml/nvml.h
	FI_DEV_CLOCKS_EVENT_REASON_HW_POWER_BRAKE_SLOWDOWN = 253
	// FI_DEV_POWER_SYNC_BALANCING_FREQ as defined in nvml/nvml.h
	FI_DEV_POWER_SYNC_BALANCING_FREQ = 254
	// FI_DEV_POWER_SYNC_BALANCING_AF as defined in nvml/nvml.h
	FI_DEV_POWER_SYNC_BALANCING_AF = 255
	// FI_PWR_SMOOTHING_ENABLED as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_ENABLED = 256
	// FI_PWR_SMOOTHING_PRIV_LVL as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_PRIV_LVL = 257
	// FI_PWR_SMOOTHING_IMM_RAMP_DOWN_ENABLED as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_IMM_RAMP_DOWN_ENABLED = 258
	// FI_PWR_SMOOTHING_APPLIED_TMP_CEIL as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_APPLIED_TMP_CEIL = 259
	// FI_PWR_SMOOTHING_APPLIED_TMP_FLOOR as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_APPLIED_TMP_FLOOR = 260
	// FI_PWR_SMOOTHING_MAX_PERCENT_TMP_FLOOR_SETTING as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_MAX_PERCENT_TMP_FLOOR_SETTING = 261
	// FI_PWR_SMOOTHING_MIN_PERCENT_TMP_FLOOR_SETTING as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_MIN_PERCENT_TMP_FLOOR_SETTING = 262
	// FI_PWR_SMOOTHING_HW_CIRCUITRY_PERCENT_LIFETIME_REMAINING as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_HW_CIRCUITRY_PERCENT_LIFETIME_REMAINING = 263
	// FI_PWR_SMOOTHING_MAX_NUM_PRESET_PROFILES as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_MAX_NUM_PRESET_PROFILES = 264
	// FI_PWR_SMOOTHING_PROFILE_PERCENT_TMP_FLOOR as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_PROFILE_PERCENT_TMP_FLOOR = 265
	// FI_PWR_SMOOTHING_PROFILE_RAMP_UP_RATE as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_PROFILE_RAMP_UP_RATE = 266
	// FI_PWR_SMOOTHING_PROFILE_RAMP_DOWN_RATE as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_PROFILE_RAMP_DOWN_RATE = 267
	// FI_PWR_SMOOTHING_PROFILE_RAMP_DOWN_HYST_VAL as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_PROFILE_RAMP_DOWN_HYST_VAL = 268
	// FI_PWR_SMOOTHING_ACTIVE_PRESET_PROFILE as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_ACTIVE_PRESET_PROFILE = 269
	// FI_PWR_SMOOTHING_ADMIN_OVERRIDE_PERCENT_TMP_FLOOR as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_ADMIN_OVERRIDE_PERCENT_TMP_FLOOR = 270
	// FI_PWR_SMOOTHING_ADMIN_OVERRIDE_RAMP_UP_RATE as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_ADMIN_OVERRIDE_RAMP_UP_RATE = 271
	// FI_PWR_SMOOTHING_ADMIN_OVERRIDE_RAMP_DOWN_RATE as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_ADMIN_OVERRIDE_RAMP_DOWN_RATE = 272
	// FI_PWR_SMOOTHING_ADMIN_OVERRIDE_RAMP_DOWN_HYST_VAL as defined in nvml/nvml.h
	FI_PWR_SMOOTHING_ADMIN_OVERRIDE_RAMP_DOWN_HYST_VAL = 273
	// FI_MAX as defined in nvml/nvml.h
	FI_MAX = 274
	// NVLINK_LOW_POWER_THRESHOLD_UNIT_100US as defined in nvml/nvml.h
	NVLINK_LOW_POWER_THRESHOLD_UNIT_100US = 0
	// NVLINK_LOW_POWER_THRESHOLD_UNIT_50US as defined in nvml/nvml.h
	NVLINK_LOW_POWER_THRESHOLD_UNIT_50US = 1
	// NVLINK_POWER_STATE_HIGH_SPEED as defined in nvml/nvml.h
	NVLINK_POWER_STATE_HIGH_SPEED = 0
	// NVLINK_POWER_STATE_LOW as defined in nvml/nvml.h
	NVLINK_POWER_STATE_LOW = 1
	// NVLINK_LOW_POWER_THRESHOLD_MIN as defined in nvml/nvml.h
	NVLINK_LOW_POWER_THRESHOLD_MIN = 1
	// NVLINK_LOW_POWER_THRESHOLD_MAX as defined in nvml/nvml.h
	NVLINK_LOW_POWER_THRESHOLD_MAX = 8191
	// NVLINK_LOW_POWER_THRESHOLD_RESET as defined in nvml/nvml.h
	NVLINK_LOW_POWER_THRESHOLD_RESET = 4294967295
	// NVLINK_LOW_POWER_THRESHOLD_DEFAULT as defined in nvml/nvml.h
	NVLINK_LOW_POWER_THRESHOLD_DEFAULT = 4294967295
	// C2C_POWER_STATE_FULL_POWER as defined in nvml/nvml.h
	C2C_POWER_STATE_FULL_POWER = 0
	// C2C_POWER_STATE_LOW_POWER as defined in nvml/nvml.h
	C2C_POWER_STATE_LOW_POWER = 1
	// EventTypeNone as defined in nvml/nvml.h
	EventTypeNone = 0
	// EventTypeSingleBitEccError as defined in nvml/nvml.h
	EventTypeSingleBitEccError = 1
	// EventTypeDoubleBitEccError as defined in nvml/nvml.h
	EventTypeDoubleBitEccError = 2
	// EventTypePState as defined in nvml/nvml.h
	EventTypePState = 4
	// EventTypeXidCriticalError as defined in nvml/nvml.h
	EventTypeXidCriticalError = 8
	// EventTypeClock as defined in nvml/nvml.h
	EventTypeClock = 16
	// EventTypePowerSourceChange as defined in nvml/nvml.h
	EventTypePowerSourceChange = 128
	// EventMigConfigChange as defined in nvml/nvml.h
	EventMigConfigChange = 256
	// EventTypeSingleBitEccErrorStorm as defined in nvml/nvml.h
	EventTypeSingleBitEccErrorStorm = 512
	// EventTypeDramRetirementEvent as defined in nvml/nvml.h
	EventTypeDramRetirementEvent = 1024
	// EventTypeDramRetirementFailure as defined in nvml/nvml.h
	EventTypeDramRetirementFailure = 2048
	// EventTypeNonFatalPoisonError as defined in nvml/nvml.h
	EventTypeNonFatalPoisonError = 4096
	// EventTypeFatalPoisonError as defined in nvml/nvml.h
	EventTypeFatalPoisonError = 8192
	// EventTypeGpuUnavailableError as defined in nvml/nvml.h
	EventTypeGpuUnavailableError = 16384
	// EventTypeGpuRecoveryAction as defined in nvml/nvml.h
	EventTypeGpuRecoveryAction = 32768
	// EventTypeAll as defined in nvml/nvml.h
	EventTypeAll = 65439
	// SystemEventTypeGpuDriverUnbind as defined in nvml/nvml.h
	SystemEventTypeGpuDriverUnbind = 1
	// SystemEventTypeGpuDriverBind as defined in nvml/nvml.h
	SystemEventTypeGpuDriverBind = 2
	// SystemEventTypeCount as defined in nvml/nvml.h
	SystemEventTypeCount = 2
	// ClocksEventReasonGpuIdle as defined in nvml/nvml.h
	ClocksEventReasonGpuIdle = 1
	// ClocksEventReasonApplicationsClocksSetting as defined in nvml/nvml.h
	ClocksEventReasonApplicationsClocksSetting = 2
	// ClocksThrottleReasonUserDefinedClocks as defined in nvml/nvml.h
	ClocksThrottleReasonUserDefinedClocks = 2
	// ClocksEventReasonSwPowerCap as defined in nvml/nvml.h
	ClocksEventReasonSwPowerCap = 4
	// ClocksThrottleReasonHwSlowdown as defined in nvml/nvml.h
	ClocksThrottleReasonHwSlowdown = 8
	// ClocksEventReasonSyncBoost as defined in nvml/nvml.h
	ClocksEventReasonSyncBoost = 16
	// ClocksEventReasonSwThermalSlowdown as defined in nvml/nvml.h
	ClocksEventReasonSwThermalSlowdown = 32
	// ClocksThrottleReasonHwThermalSlowdown as defined in nvml/nvml.h
	ClocksThrottleReasonHwThermalSlowdown = 64
	// ClocksThrottleReasonHwPowerBrakeSlowdown as defined in nvml/nvml.h
	ClocksThrottleReasonHwPowerBrakeSlowdown = 128
	// ClocksEventReasonDisplayClockSetting as defined in nvml/nvml.h
	ClocksEventReasonDisplayClockSetting = 256
	// ClocksEventReasonNone as defined in nvml/nvml.h
	ClocksEventReasonNone = 0
	// ClocksEventReasonAll as defined in nvml/nvml.h
	ClocksEventReasonAll = 511
	// ClocksThrottleReasonGpuIdle as defined in nvml/nvml.h
	ClocksThrottleReasonGpuIdle = 1
	// ClocksThrottleReasonApplicationsClocksSetting as defined in nvml/nvml.h
	ClocksThrottleReasonApplicationsClocksSetting = 2
	// ClocksThrottleReasonSyncBoost as defined in nvml/nvml.h
	ClocksThrottleReasonSyncBoost = 16
	// ClocksThrottleReasonSwPowerCap as defined in nvml/nvml.h
	ClocksThrottleReasonSwPowerCap = 4
	// ClocksThrottleReasonSwThermalSlowdown as defined in nvml/nvml.h
	ClocksThrottleReasonSwThermalSlowdown = 32
	// ClocksThrottleReasonDisplayClockSetting as defined in nvml/nvml.h
	ClocksThrottleReasonDisplayClockSetting = 256
	// ClocksThrottleReasonNone as defined in nvml/nvml.h
	ClocksThrottleReasonNone = 0
	// ClocksThrottleReasonAll as defined in nvml/nvml.h
	ClocksThrottleReasonAll = 511
	// NVFBC_SESSION_FLAG_DIFFMAP_ENABLED as defined in nvml/nvml.h
	NVFBC_SESSION_FLAG_DIFFMAP_ENABLED = 1
	// NVFBC_SESSION_FLAG_CLASSIFICATIONMAP_ENABLED as defined in nvml/nvml.h
	NVFBC_SESSION_FLAG_CLASSIFICATIONMAP_ENABLED = 2
	// NVFBC_SESSION_FLAG_CAPTURE_WITH_WAIT_NO_WAIT as defined in nvml/nvml.h
	NVFBC_SESSION_FLAG_CAPTURE_WITH_WAIT_NO_WAIT = 4
	// NVFBC_SESSION_FLAG_CAPTURE_WITH_WAIT_INFINITE as defined in nvml/nvml.h
	NVFBC_SESSION_FLAG_CAPTURE_WITH_WAIT_INFINITE = 8
	// NVFBC_SESSION_FLAG_CAPTURE_WITH_WAIT_TIMEOUT as defined in nvml/nvml.h
	NVFBC_SESSION_FLAG_CAPTURE_WITH_WAIT_TIMEOUT = 16
	// CC_SYSTEM_CPU_CAPS_NONE as defined in nvml/nvml.h
	CC_SYSTEM_CPU_CAPS_NONE = 0
	// CC_SYSTEM_CPU_CAPS_AMD_SEV as defined in nvml/nvml.h
	CC_SYSTEM_CPU_CAPS_AMD_SEV = 1
	// CC_SYSTEM_CPU_CAPS_INTEL_TDX as defined in nvml/nvml.h
	CC_SYSTEM_CPU_CAPS_INTEL_TDX = 2
	// CC_SYSTEM_CPU_CAPS_AMD_SEV_SNP as defined in nvml/nvml.h
	CC_SYSTEM_CPU_CAPS_AMD_SEV_SNP = 3
	// CC_SYSTEM_CPU_CAPS_AMD_SNP_VTOM as defined in nvml/nvml.h
	CC_SYSTEM_CPU_CAPS_AMD_SNP_VTOM = 4
	// CC_SYSTEM_GPUS_CC_NOT_CAPABLE as defined in nvml/nvml.h
	CC_SYSTEM_GPUS_CC_NOT_CAPABLE = 0
	// CC_SYSTEM_GPUS_CC_CAPABLE as defined in nvml/nvml.h
	CC_SYSTEM_GPUS_CC_CAPABLE = 1
	// CC_SYSTEM_DEVTOOLS_MODE_OFF as defined in nvml/nvml.h
	CC_SYSTEM_DEVTOOLS_MODE_OFF = 0
	// CC_SYSTEM_DEVTOOLS_MODE_ON as defined in nvml/nvml.h
	CC_SYSTEM_DEVTOOLS_MODE_ON = 1
	// CC_SYSTEM_ENVIRONMENT_UNAVAILABLE as defined in nvml/nvml.h
	CC_SYSTEM_ENVIRONMENT_UNAVAILABLE = 0
	// CC_SYSTEM_ENVIRONMENT_SIM as defined in nvml/nvml.h
	CC_SYSTEM_ENVIRONMENT_SIM = 1
	// CC_SYSTEM_ENVIRONMENT_PROD as defined in nvml/nvml.h
	CC_SYSTEM_ENVIRONMENT_PROD = 2
	// CC_SYSTEM_FEATURE_DISABLED as defined in nvml/nvml.h
	CC_SYSTEM_FEATURE_DISABLED = 0
	// CC_SYSTEM_FEATURE_ENABLED as defined in nvml/nvml.h
	CC_SYSTEM_FEATURE_ENABLED = 1
	// CC_SYSTEM_MULTIGPU_NONE as defined in nvml/nvml.h
	CC_SYSTEM_MULTIGPU_NONE = 0
	// CC_SYSTEM_MULTIGPU_PROTECTED_PCIE as defined in nvml/nvml.h
	CC_SYSTEM_MULTIGPU_PROTECTED_PCIE = 1
	// CC_ACCEPTING_CLIENT_REQUESTS_FALSE as defined in nvml/nvml.h
	CC_ACCEPTING_CLIENT_REQUESTS_FALSE = 0
	// CC_ACCEPTING_CLIENT_REQUESTS_TRUE as defined in nvml/nvml.h
	CC_ACCEPTING_CLIENT_REQUESTS_TRUE = 1
	// GPU_CERT_CHAIN_SIZE as defined in nvml/nvml.h
	GPU_CERT_CHAIN_SIZE = 4096
	// GPU_ATTESTATION_CERT_CHAIN_SIZE as defined in nvml/nvml.h
	GPU_ATTESTATION_CERT_CHAIN_SIZE = 5120
	// CC_GPU_CEC_NONCE_SIZE as defined in nvml/nvml.h
	CC_GPU_CEC_NONCE_SIZE = 32
	// CC_GPU_ATTESTATION_REPORT_SIZE as defined in nvml/nvml.h
	CC_GPU_ATTESTATION_REPORT_SIZE = 8192
	// CC_GPU_CEC_ATTESTATION_REPORT_SIZE as defined in nvml/nvml.h
	CC_GPU_CEC_ATTESTATION_REPORT_SIZE = 4096
	// CC_CEC_ATTESTATION_REPORT_NOT_PRESENT as defined in nvml/nvml.h
	CC_CEC_ATTESTATION_REPORT_NOT_PRESENT = 0
	// CC_CEC_ATTESTATION_REPORT_PRESENT as defined in nvml/nvml.h
	CC_CEC_ATTESTATION_REPORT_PRESENT = 1
	// CC_KEY_ROTATION_THRESHOLD_ATTACKER_ADVANTAGE_MIN as defined in nvml/nvml.h
	CC_KEY_ROTATION_THRESHOLD_ATTACKER_ADVANTAGE_MIN = 50
	// CC_KEY_ROTATION_THRESHOLD_ATTACKER_ADVANTAGE_MAX as defined in nvml/nvml.h
	CC_KEY_ROTATION_THRESHOLD_ATTACKER_ADVANTAGE_MAX = 65
	// GPU_FABRIC_UUID_LEN as defined in nvml/nvml.h
	GPU_FABRIC_UUID_LEN = 16
	// GPU_FABRIC_STATE_NOT_SUPPORTED as defined in nvml/nvml.h
	GPU_FABRIC_STATE_NOT_SUPPORTED = 0
	// GPU_FABRIC_STATE_NOT_STARTED as defined in nvml/nvml.h
	GPU_FABRIC_STATE_NOT_STARTED = 1
	// GPU_FABRIC_STATE_IN_PROGRESS as defined in nvml/nvml.h
	GPU_FABRIC_STATE_IN_PROGRESS = 2
	// GPU_FABRIC_STATE_COMPLETED as defined in nvml/nvml.h
	GPU_FABRIC_STATE_COMPLETED = 3
	// GPU_FABRIC_HEALTH_MASK_DEGRADED_BW_NOT_SUPPORTED as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_DEGRADED_BW_NOT_SUPPORTED = 0
	// GPU_FABRIC_HEALTH_MASK_DEGRADED_BW_TRUE as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_DEGRADED_BW_TRUE = 1
	// GPU_FABRIC_HEALTH_MASK_DEGRADED_BW_FALSE as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_DEGRADED_BW_FALSE = 2
	// GPU_FABRIC_HEALTH_MASK_SHIFT_DEGRADED_BW as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_SHIFT_DEGRADED_BW = 0
	// GPU_FABRIC_HEALTH_MASK_WIDTH_DEGRADED_BW as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_WIDTH_DEGRADED_BW = 3
	// GPU_FABRIC_HEALTH_MASK_ROUTE_RECOVERY_NOT_SUPPORTED as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_ROUTE_RECOVERY_NOT_SUPPORTED = 0
	// GPU_FABRIC_HEALTH_MASK_ROUTE_RECOVERY_TRUE as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_ROUTE_RECOVERY_TRUE = 1
	// GPU_FABRIC_HEALTH_MASK_ROUTE_RECOVERY_FALSE as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_ROUTE_RECOVERY_FALSE = 2
	// GPU_FABRIC_HEALTH_MASK_SHIFT_ROUTE_RECOVERY as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_SHIFT_ROUTE_RECOVERY = 2
	// GPU_FABRIC_HEALTH_MASK_WIDTH_ROUTE_RECOVERY as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_WIDTH_ROUTE_RECOVERY = 3
	// GPU_FABRIC_HEALTH_MASK_ROUTE_UNHEALTHY_NOT_SUPPORTED as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_ROUTE_UNHEALTHY_NOT_SUPPORTED = 0
	// GPU_FABRIC_HEALTH_MASK_ROUTE_UNHEALTHY_TRUE as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_ROUTE_UNHEALTHY_TRUE = 1
	// GPU_FABRIC_HEALTH_MASK_ROUTE_UNHEALTHY_FALSE as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_ROUTE_UNHEALTHY_FALSE = 2
	// GPU_FABRIC_HEALTH_MASK_SHIFT_ROUTE_UNHEALTHY as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_SHIFT_ROUTE_UNHEALTHY = 4
	// GPU_FABRIC_HEALTH_MASK_WIDTH_ROUTE_UNHEALTHY as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_WIDTH_ROUTE_UNHEALTHY = 3
	// GPU_FABRIC_HEALTH_MASK_ACCESS_TIMEOUT_RECOVERY_NOT_SUPPORTED as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_ACCESS_TIMEOUT_RECOVERY_NOT_SUPPORTED = 0
	// GPU_FABRIC_HEALTH_MASK_ACCESS_TIMEOUT_RECOVERY_TRUE as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_ACCESS_TIMEOUT_RECOVERY_TRUE = 1
	// GPU_FABRIC_HEALTH_MASK_ACCESS_TIMEOUT_RECOVERY_FALSE as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_ACCESS_TIMEOUT_RECOVERY_FALSE = 2
	// GPU_FABRIC_HEALTH_MASK_SHIFT_ACCESS_TIMEOUT_RECOVERY as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_SHIFT_ACCESS_TIMEOUT_RECOVERY = 6
	// GPU_FABRIC_HEALTH_MASK_WIDTH_ACCESS_TIMEOUT_RECOVERY as defined in nvml/nvml.h
	GPU_FABRIC_HEALTH_MASK_WIDTH_ACCESS_TIMEOUT_RECOVERY = 3
	// INIT_FLAG_NO_GPUS as defined in nvml/nvml.h
	INIT_FLAG_NO_GPUS = 1
	// INIT_FLAG_NO_ATTACH as defined in nvml/nvml.h
	INIT_FLAG_NO_ATTACH = 2
	// DEVICE_INFOROM_VERSION_BUFFER_SIZE as defined in nvml/nvml.h
	DEVICE_INFOROM_VERSION_BUFFER_SIZE = 16
	// DEVICE_UUID_BUFFER_SIZE as defined in nvml/nvml.h
	DEVICE_UUID_BUFFER_SIZE = 80
	// DEVICE_UUID_V2_BUFFER_SIZE as defined in nvml/nvml.h
	DEVICE_UUID_V2_BUFFER_SIZE = 96
	// DEVICE_PART_NUMBER_BUFFER_SIZE as defined in nvml/nvml.h
	DEVICE_PART_NUMBER_BUFFER_SIZE = 80
	// SYSTEM_DRIVER_VERSION_BUFFER_SIZE as defined in nvml/nvml.h
	SYSTEM_DRIVER_VERSION_BUFFER_SIZE = 80
	// SYSTEM_NVML_VERSION_BUFFER_SIZE as defined in nvml/nvml.h
	SYSTEM_NVML_VERSION_BUFFER_SIZE = 80
	// DEVICE_NAME_BUFFER_SIZE as defined in nvml/nvml.h
	DEVICE_NAME_BUFFER_SIZE = 64
	// DEVICE_NAME_V2_BUFFER_SIZE as defined in nvml/nvml.h
	DEVICE_NAME_V2_BUFFER_SIZE = 96
	// DEVICE_SERIAL_BUFFER_SIZE as defined in nvml/nvml.h
	DEVICE_SERIAL_BUFFER_SIZE = 30
	// DEVICE_VBIOS_VERSION_BUFFER_SIZE as defined in nvml/nvml.h
	DEVICE_VBIOS_VERSION_BUFFER_SIZE = 32
	// AFFINITY_SCOPE_NODE as defined in nvml/nvml.h
	AFFINITY_SCOPE_NODE = 0
	// AFFINITY_SCOPE_SOCKET as defined in nvml/nvml.h
	AFFINITY_SCOPE_SOCKET = 1
	// NVLINK_BER_MANTISSA_SHIFT as defined in nvml/nvml.h
	NVLINK_BER_MANTISSA_SHIFT = 8
	// NVLINK_BER_MANTISSA_WIDTH as defined in nvml/nvml.h
	NVLINK_BER_MANTISSA_WIDTH = 15
	// NVLINK_BER_EXP_SHIFT as defined in nvml/nvml.h
	NVLINK_BER_EXP_SHIFT = 0
	// NVLINK_BER_EXP_WIDTH as defined in nvml/nvml.h
	NVLINK_BER_EXP_WIDTH = 255
	// NVLINK_STATE_INACTIVE as defined in nvml/nvml.h
	NVLINK_STATE_INACTIVE = 0
	// NVLINK_STATE_ACTIVE as defined in nvml/nvml.h
	NVLINK_STATE_ACTIVE = 1
	// NVLINK_STATE_SLEEP as defined in nvml/nvml.h
	NVLINK_STATE_SLEEP = 2
	// NVLINK_TOTAL_SUPPORTED_BW_MODES as defined in nvml/nvml.h
	NVLINK_TOTAL_SUPPORTED_BW_MODES = 23
	// DEVICE_MIG_DISABLE as defined in nvml/nvml.h
	DEVICE_MIG_DISABLE = 0
	// DEVICE_MIG_ENABLE as defined in nvml/nvml.h
	DEVICE_MIG_ENABLE = 1
	// GPU_INSTANCE_PROFILE_1_SLICE as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_1_SLICE = 0
	// GPU_INSTANCE_PROFILE_2_SLICE as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_2_SLICE = 1
	// GPU_INSTANCE_PROFILE_3_SLICE as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_3_SLICE = 2
	// GPU_INSTANCE_PROFILE_4_SLICE as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_4_SLICE = 3
	// GPU_INSTANCE_PROFILE_7_SLICE as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_7_SLICE = 4
	// GPU_INSTANCE_PROFILE_8_SLICE as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_8_SLICE = 5
	// GPU_INSTANCE_PROFILE_6_SLICE as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_6_SLICE = 6
	// GPU_INSTANCE_PROFILE_1_SLICE_REV1 as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_1_SLICE_REV1 = 7
	// GPU_INSTANCE_PROFILE_2_SLICE_REV1 as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_2_SLICE_REV1 = 8
	// GPU_INSTANCE_PROFILE_1_SLICE_REV2 as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_1_SLICE_REV2 = 9
	// GPU_INSTANCE_PROFILE_1_SLICE_GFX as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_1_SLICE_GFX = 10
	// GPU_INSTANCE_PROFILE_2_SLICE_GFX as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_2_SLICE_GFX = 11
	// GPU_INSTANCE_PROFILE_4_SLICE_GFX as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_4_SLICE_GFX = 12
	// GPU_INSTANCE_PROFILE_1_SLICE_NO_ME as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_1_SLICE_NO_ME = 13
	// GPU_INSTANCE_PROFILE_2_SLICE_NO_ME as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_2_SLICE_NO_ME = 14
	// GPU_INSTANCE_PROFILE_1_SLICE_ALL_ME as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_1_SLICE_ALL_ME = 15
	// GPU_INSTANCE_PROFILE_2_SLICE_ALL_ME as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_2_SLICE_ALL_ME = 16
	// GPU_INSTANCE_PROFILE_COUNT as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_COUNT = 17
	// GPU_INSTANCE_PROFILE_CAPS_P2P as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_CAPS_P2P = 1
	// GPU_INTSTANCE_PROFILE_CAPS_P2P as defined in nvml/nvml.h
	GPU_INTSTANCE_PROFILE_CAPS_P2P = 1
	// GPU_INSTANCE_PROFILE_CAPS_GFX as defined in nvml/nvml.h
	GPU_INSTANCE_PROFILE_CAPS_GFX = 2
	// COMPUTE_INSTANCE_PROFILE_CAPS_GFX as defined in nvml/nvml.h
	COMPUTE_INSTANCE_PROFILE_CAPS_GFX = 1
	// COMPUTE_INSTANCE_PROFILE_1_SLICE as defined in nvml/nvml.h
	COMPUTE_INSTANCE_PROFILE_1_SLICE = 0
	// COMPUTE_INSTANCE_PROFILE_2_SLICE as defined in nvml/nvml.h
	COMPUTE_INSTANCE_PROFILE_2_SLICE = 1
	// COMPUTE_INSTANCE_PROFILE_3_SLICE as defined in nvml/nvml.h
	COMPUTE_INSTANCE_PROFILE_3_SLICE = 2
	// COMPUTE_INSTANCE_PROFILE_4_SLICE as defined in nvml/nvml.h
	COMPUTE_INSTANCE_PROFILE_4_SLICE = 3
	// COMPUTE_INSTANCE_PROFILE_7_SLICE as defined in nvml/nvml.h
	COMPUTE_INSTANCE_PROFILE_7_SLICE = 4
	// COMPUTE_INSTANCE_PROFILE_8_SLICE as defined in nvml/nvml.h
	COMPUTE_INSTANCE_PROFILE_8_SLICE = 5
	// COMPUTE_INSTANCE_PROFILE_6_SLICE as defined in nvml/nvml.h
	COMPUTE_INSTANCE_PROFILE_6_SLICE = 6
	// COMPUTE_INSTANCE_PROFILE_1_SLICE_REV1 as defined in nvml/nvml.h
	COMPUTE_INSTANCE_PROFILE_1_SLICE_REV1 = 7
	// COMPUTE_INSTANCE_PROFILE_COUNT as defined in nvml/nvml.h
	COMPUTE_INSTANCE_PROFILE_COUNT = 8
	// COMPUTE_INSTANCE_ENGINE_PROFILE_SHARED as defined in nvml/nvml.h
	COMPUTE_INSTANCE_ENGINE_PROFILE_SHARED = 0
	// COMPUTE_INSTANCE_ENGINE_PROFILE_COUNT as defined in nvml/nvml.h
	COMPUTE_INSTANCE_ENGINE_PROFILE_COUNT = 1
	// GPM_METRICS_GET_VERSION as defined in nvml/nvml.h
	GPM_METRICS_GET_VERSION = 1
	// GPM_SUPPORT_VERSION as defined in nvml/nvml.h
	GPM_SUPPORT_VERSION = 1
	// DEV_CAP_EGM as defined in nvml/nvml.h
	DEV_CAP_EGM = 1
	// WORKLOAD_POWER_MAX_PROFILES as defined in nvml/nvml.h
	WORKLOAD_POWER_MAX_PROFILES = 255
	// POWER_SMOOTHING_MAX_NUM_PROFILES as defined in nvml/nvml.h
	POWER_SMOOTHING_MAX_NUM_PROFILES = 5
	// POWER_SMOOTHING_NUM_PROFILE_PARAMS as defined in nvml/nvml.h
	POWER_SMOOTHING_NUM_PROFILE_PARAMS = 4
	// POWER_SMOOTHING_ADMIN_OVERRIDE_NOT_SET as defined in nvml/nvml.h
	POWER_SMOOTHING_ADMIN_OVERRIDE_NOT_SET = 4294967295
	// POWER_SMOOTHING_PROFILE_PARAM_PERCENT_TMP_FLOOR as defined in nvml/nvml.h
	POWER_SMOOTHING_PROFILE_PARAM_PERCENT_TMP_FLOOR = 0
	// POWER_SMOOTHING_PROFILE_PARAM_RAMP_UP_RATE as defined in nvml/nvml.h
	POWER_SMOOTHING_PROFILE_PARAM_RAMP_UP_RATE = 1
	// POWER_SMOOTHING_PROFILE_PARAM_RAMP_DOWN_RATE as defined in nvml/nvml.h
	POWER_SMOOTHING_PROFILE_PARAM_RAMP_DOWN_RATE = 2
	// POWER_SMOOTHING_PROFILE_PARAM_RAMP_DOWN_HYSTERESIS as defined in nvml/nvml.h
	POWER_SMOOTHING_PROFILE_PARAM_RAMP_DOWN_HYSTERESIS = 3
)

// BridgeChipType as declared in nvml/nvml.h
type BridgeChipType int32

// BridgeChipType enumeration from nvml/nvml.h
const (
	BRIDGE_CHIP_PLX  BridgeChipType = iota
	BRIDGE_CHIP_BRO4 BridgeChipType = 1
)

// NvLinkUtilizationCountUnits as declared in nvml/nvml.h
type NvLinkUtilizationCountUnits int32

// NvLinkUtilizationCountUnits enumeration from nvml/nvml.h
const (
	NVLINK_COUNTER_UNIT_CYCLES   NvLinkUtilizationCountUnits = iota
	NVLINK_COUNTER_UNIT_PACKETS  NvLinkUtilizationCountUnits = 1
	NVLINK_COUNTER_UNIT_BYTES    NvLinkUtilizationCountUnits = 2
	NVLINK_COUNTER_UNIT_RESERVED NvLinkUtilizationCountUnits = 3
	NVLINK_COUNTER_UNIT_COUNT    NvLinkUtilizationCountUnits = 4
)

// NvLinkUtilizationCountPktTypes as declared in nvml/nvml.h
type NvLinkUtilizationCountPktTypes int32

// NvLinkUtilizationCountPktTypes enumeration from nvml/nvml.h
const (
	NVLINK_COUNTER_PKTFILTER_NOP        NvLinkUtilizationCountPktTypes = 1
	NVLINK_COUNTER_PKTFILTER_READ       NvLinkUtilizationCountPktTypes = 2
	NVLINK_COUNTER_PKTFILTER_WRITE      NvLinkUtilizationCountPktTypes = 4
	NVLINK_COUNTER_PKTFILTER_RATOM      NvLinkUtilizationCountPktTypes = 8
	NVLINK_COUNTER_PKTFILTER_NRATOM     NvLinkUtilizationCountPktTypes = 16
	NVLINK_COUNTER_PKTFILTER_FLUSH      NvLinkUtilizationCountPktTypes = 32
	NVLINK_COUNTER_PKTFILTER_RESPDATA   NvLinkUtilizationCountPktTypes = 64
	NVLINK_COUNTER_PKTFILTER_RESPNODATA NvLinkUtilizationCountPktTypes = 128
	NVLINK_COUNTER_PKTFILTER_ALL        NvLinkUtilizationCountPktTypes = 255
)

// NvLinkCapability as declared in nvml/nvml.h
type NvLinkCapability int32

// NvLinkCapability enumeration from nvml/nvml.h
const (
	NVLINK_CAP_P2P_SUPPORTED  NvLinkCapability = iota
	NVLINK_CAP_SYSMEM_ACCESS  NvLinkCapability = 1
	NVLINK_CAP_P2P_ATOMICS    NvLinkCapability = 2
	NVLINK_CAP_SYSMEM_ATOMICS NvLinkCapability = 3
	NVLINK_CAP_SLI_BRIDGE     NvLinkCapability = 4
	NVLINK_CAP_VALID          NvLinkCapability = 5
	NVLINK_CAP_COUNT          NvLinkCapability = 6
)

// NvLinkErrorCounter as declared in nvml/nvml.h
type NvLinkErrorCounter int32

// NvLinkErrorCounter enumeration from nvml/nvml.h
const (
	NVLINK_ERROR_DL_REPLAY   NvLinkErrorCounter = iota
	NVLINK_ERROR_DL_RECOVERY NvLinkErrorCounter = 1
	NVLINK_ERROR_DL_CRC_FLIT NvLinkErrorCounter = 2
	NVLINK_ERROR_DL_CRC_DATA NvLinkErrorCounter = 3
	NVLINK_ERROR_DL_ECC_DATA NvLinkErrorCounter = 4
	NVLINK_ERROR_COUNT       NvLinkErrorCounter = 5
)

// IntNvLinkDeviceType as declared in nvml/nvml.h
type IntNvLinkDeviceType int32

// IntNvLinkDeviceType enumeration from nvml/nvml.h
const (
	NVLINK_DEVICE_TYPE_GPU     IntNvLinkDeviceType = iota
	NVLINK_DEVICE_TYPE_IBMNPU  IntNvLinkDeviceType = 1
	NVLINK_DEVICE_TYPE_SWITCH  IntNvLinkDeviceType = 2
	NVLINK_DEVICE_TYPE_UNKNOWN IntNvLinkDeviceType = 255
)

// GpuTopologyLevel as declared in nvml/nvml.h
type GpuTopologyLevel int32

// GpuTopologyLevel enumeration from nvml/nvml.h
const (
	TOPOLOGY_INTERNAL   GpuTopologyLevel = iota
	TOPOLOGY_SINGLE     GpuTopologyLevel = 10
	TOPOLOGY_MULTIPLE   GpuTopologyLevel = 20
	TOPOLOGY_HOSTBRIDGE GpuTopologyLevel = 30
	TOPOLOGY_NODE       GpuTopologyLevel = 40
	TOPOLOGY_SYSTEM     GpuTopologyLevel = 50
)

// GpuP2PStatus as declared in nvml/nvml.h
type GpuP2PStatus int32

// GpuP2PStatus enumeration from nvml/nvml.h
const (
	P2P_STATUS_OK                         GpuP2PStatus = iota
	P2P_STATUS_CHIPSET_NOT_SUPPORED       GpuP2PStatus = 1
	P2P_STATUS_CHIPSET_NOT_SUPPORTED      GpuP2PStatus = 1
	P2P_STATUS_GPU_NOT_SUPPORTED          GpuP2PStatus = 2
	P2P_STATUS_IOH_TOPOLOGY_NOT_SUPPORTED GpuP2PStatus = 3
	P2P_STATUS_DISABLED_BY_REGKEY         GpuP2PStatus = 4
	P2P_STATUS_NOT_SUPPORTED              GpuP2PStatus = 5
	P2P_STATUS_UNKNOWN                    GpuP2PStatus = 6
)

// GpuP2PCapsIndex as declared in nvml/nvml.h
type GpuP2PCapsIndex int32

// GpuP2PCapsIndex enumeration from nvml/nvml.h
const (
	P2P_CAPS_INDEX_READ    GpuP2PCapsIndex = iota
	P2P_CAPS_INDEX_WRITE   GpuP2PCapsIndex = 1
	P2P_CAPS_INDEX_NVLINK  GpuP2PCapsIndex = 2
	P2P_CAPS_INDEX_ATOMICS GpuP2PCapsIndex = 3
	P2P_CAPS_INDEX_PCI     GpuP2PCapsIndex = 4
	P2P_CAPS_INDEX_PROP    GpuP2PCapsIndex = 4
	P2P_CAPS_INDEX_UNKNOWN GpuP2PCapsIndex = 5
)

// SamplingType as declared in nvml/nvml.h
type SamplingType int32

// SamplingType enumeration from nvml/nvml.h
const (
	TOTAL_POWER_SAMPLES        SamplingType = iota
	GPU_UTILIZATION_SAMPLES    SamplingType = 1
	MEMORY_UTILIZATION_SAMPLES SamplingType = 2
	ENC_UTILIZATION_SAMPLES    SamplingType = 3
	DEC_UTILIZATION_SAMPLES    SamplingType = 4
	PROCESSOR_CLK_SAMPLES      SamplingType = 5
	MEMORY_CLK_SAMPLES         SamplingType = 6
	MODULE_POWER_SAMPLES       SamplingType = 7
	JPG_UTILIZATION_SAMPLES    SamplingType = 8
	OFA_UTILIZATION_SAMPLES    SamplingType = 9
	SAMPLINGTYPE_COUNT         SamplingType = 10
)

// PcieUtilCounter as declared in nvml/nvml.h
type PcieUtilCounter int32

// PcieUtilCounter enumeration from nvml/nvml.h
const (
	PCIE_UTIL_TX_BYTES PcieUtilCounter = iota
	PCIE_UTIL_RX_BYTES PcieUtilCounter = 1
	PCIE_UTIL_COUNT    PcieUtilCounter = 2
)

// ValueType as declared in nvml/nvml.h
type ValueType int32

// ValueType enumeration from nvml/nvml.h
const (
	VALUE_TYPE_DOUBLE             ValueType = iota
	VALUE_TYPE_UNSIGNED_INT       ValueType = 1
	VALUE_TYPE_UNSIGNED_LONG      ValueType = 2
	VALUE_TYPE_UNSIGNED_LONG_LONG ValueType = 3
	VALUE_TYPE_SIGNED_LONG_LONG   ValueType = 4
	VALUE_TYPE_SIGNED_INT         ValueType = 5
	VALUE_TYPE_UNSIGNED_SHORT     ValueType = 6
	VALUE_TYPE_COUNT              ValueType = 7
)

// PerfPolicyType as declared in nvml/nvml.h
type PerfPolicyType int32

// PerfPolicyType enumeration from nvml/nvml.h
const (
	PERF_POLICY_POWER             PerfPolicyType = iota
	PERF_POLICY_THERMAL           PerfPolicyType = 1
	PERF_POLICY_SYNC_BOOST        PerfPolicyType = 2
	PERF_POLICY_BOARD_LIMIT       PerfPolicyType = 3
	PERF_POLICY_LOW_UTILIZATION   PerfPolicyType = 4
	PERF_POLICY_RELIABILITY       PerfPolicyType = 5
	PERF_POLICY_TOTAL_APP_CLOCKS  PerfPolicyType = 10
	PERF_POLICY_TOTAL_BASE_CLOCKS PerfPolicyType = 11
	PERF_POLICY_COUNT             PerfPolicyType = 12
)

// CoolerControl as declared in nvml/nvml.h
type CoolerControl int32

// CoolerControl enumeration from nvml/nvml.h
const (
	THERMAL_COOLER_SIGNAL_NONE     CoolerControl = iota
	THERMAL_COOLER_SIGNAL_TOGGLE   CoolerControl = 1
	THERMAL_COOLER_SIGNAL_VARIABLE CoolerControl = 2
	THERMAL_COOLER_SIGNAL_COUNT    CoolerControl = 3
)

// CoolerTarget as declared in nvml/nvml.h
type CoolerTarget int32

// CoolerTarget enumeration from nvml/nvml.h
const (
	THERMAL_COOLER_TARGET_NONE         CoolerTarget = 1
	THERMAL_COOLER_TARGET_GPU          CoolerTarget = 2
	THERMAL_COOLER_TARGET_MEMORY       CoolerTarget = 4
	THERMAL_COOLER_TARGET_POWER_SUPPLY CoolerTarget = 8
	THERMAL_COOLER_TARGET_GPU_RELATED  CoolerTarget = 14
)

// EnableState as declared in nvml/nvml.h
type EnableState int32

// EnableState enumeration from nvml/nvml.h
const (
	FEATURE_DISABLED EnableState = iota
	FEATURE_ENABLED  EnableState = 1
)

// BrandType as declared in nvml/nvml.h
type BrandType int32

// BrandType enumeration from nvml/nvml.h
const (
	BRAND_UNKNOWN             BrandType = iota
	BRAND_QUADRO              BrandType = 1
	BRAND_TESLA               BrandType = 2
	BRAND_NVS                 BrandType = 3
	BRAND_GRID                BrandType = 4
	BRAND_GEFORCE             BrandType = 5
	BRAND_TITAN               BrandType = 6
	BRAND_NVIDIA_VAPPS        BrandType = 7
	BRAND_NVIDIA_VPC          BrandType = 8
	BRAND_NVIDIA_VCS          BrandType = 9
	BRAND_NVIDIA_VWS          BrandType = 10
	BRAND_NVIDIA_CLOUD_GAMING BrandType = 11
	BRAND_NVIDIA_VGAMING      BrandType = 11
	BRAND_QUADRO_RTX          BrandType = 12
	BRAND_NVIDIA_RTX          BrandType = 13
	BRAND_NVIDIA              BrandType = 14
	BRAND_GEFORCE_RTX         BrandType = 15
	BRAND_TITAN_RTX           BrandType = 16
	BRAND_COUNT               BrandType = 17
)

// TemperatureThresholds as declared in nvml/nvml.h
type TemperatureThresholds int32

// TemperatureThresholds enumeration from nvml/nvml.h
const (
	TEMPERATURE_THRESHOLD_SHUTDOWN      TemperatureThresholds = iota
	TEMPERATURE_THRESHOLD_SLOWDOWN      TemperatureThresholds = 1
	TEMPERATURE_THRESHOLD_MEM_MAX       TemperatureThresholds = 2
	TEMPERATURE_THRESHOLD_GPU_MAX       TemperatureThresholds = 3
	TEMPERATURE_THRESHOLD_ACOUSTIC_MIN  TemperatureThresholds = 4
	TEMPERATURE_THRESHOLD_ACOUSTIC_CURR TemperatureThresholds = 5
	TEMPERATURE_THRESHOLD_ACOUSTIC_MAX  TemperatureThresholds = 6
	TEMPERATURE_THRESHOLD_GPS_CURR      TemperatureThresholds = 7
	TEMPERATURE_THRESHOLD_COUNT         TemperatureThresholds = 8
)

// TemperatureSensors as declared in nvml/nvml.h
type TemperatureSensors int32

// TemperatureSensors enumeration from nvml/nvml.h
const (
	TEMPERATURE_GPU   TemperatureSensors = iota
	TEMPERATURE_COUNT TemperatureSensors = 1
)

// ComputeMode as declared in nvml/nvml.h
type ComputeMode int32

// ComputeMode enumeration from nvml/nvml.h
const (
	COMPUTEMODE_DEFAULT           ComputeMode = iota
	COMPUTEMODE_EXCLUSIVE_THREAD  ComputeMode = 1
	COMPUTEMODE_PROHIBITED        ComputeMode = 2
	COMPUTEMODE_EXCLUSIVE_PROCESS ComputeMode = 3
	COMPUTEMODE_COUNT             ComputeMode = 4
)

// MemoryErrorType as declared in nvml/nvml.h
type MemoryErrorType int32

// MemoryErrorType enumeration from nvml/nvml.h
const (
	MEMORY_ERROR_TYPE_CORRECTED   MemoryErrorType = iota
	MEMORY_ERROR_TYPE_UNCORRECTED MemoryErrorType = 1
	MEMORY_ERROR_TYPE_COUNT       MemoryErrorType = 2
)

// NvlinkVersion as declared in nvml/nvml.h
type NvlinkVersion int32

// NvlinkVersion enumeration from nvml/nvml.h
const (
	NVLINK_VERSION_INVALID NvlinkVersion = iota
	NVLINK_VERSION_1_0     NvlinkVersion = 1
	NVLINK_VERSION_2_0     NvlinkVersion = 2
	NVLINK_VERSION_2_2     NvlinkVersion = 3
	NVLINK_VERSION_3_0     NvlinkVersion = 4
	NVLINK_VERSION_3_1     NvlinkVersion = 5
	NVLINK_VERSION_4_0     NvlinkVersion = 6
	NVLINK_VERSION_5_0     NvlinkVersion = 7
)

// EccCounterType as declared in nvml/nvml.h
type EccCounterType int32

// EccCounterType enumeration from nvml/nvml.h
const (
	VOLATILE_ECC           EccCounterType = iota
	AGGREGATE_ECC          EccCounterType = 1
	ECC_COUNTER_TYPE_COUNT EccCounterType = 2
)

// ClockType as declared in nvml/nvml.h
type ClockType int32

// ClockType enumeration from nvml/nvml.h
const (
	CLOCK_GRAPHICS ClockType = iota
	CLOCK_SM       ClockType = 1
	CLOCK_MEM      ClockType = 2
	CLOCK_VIDEO    ClockType = 3
	CLOCK_COUNT    ClockType = 4
)

// ClockId as declared in nvml/nvml.h
type ClockId int32

// ClockId enumeration from nvml/nvml.h
const (
	CLOCK_ID_CURRENT            ClockId = iota
	CLOCK_ID_APP_CLOCK_TARGET   ClockId = 1
	CLOCK_ID_APP_CLOCK_DEFAULT  ClockId = 2
	CLOCK_ID_CUSTOMER_BOOST_MAX ClockId = 3
	CLOCK_ID_COUNT              ClockId = 4
)

// DriverModel as declared in nvml/nvml.h
type DriverModel int32

// DriverModel enumeration from nvml/nvml.h
const (
	DRIVER_WDDM DriverModel = iota
	DRIVER_WDM  DriverModel = 1
	DRIVER_MCDM DriverModel = 2
)

// Pstates as declared in nvml/nvml.h
type Pstates int32

// Pstates enumeration from nvml/nvml.h
const (
	PSTATE_0       Pstates = iota
	PSTATE_1       Pstates = 1
	PSTATE_2       Pstates = 2
	PSTATE_3       Pstates = 3
	PSTATE_4       Pstates = 4
	PSTATE_5       Pstates = 5
	PSTATE_6       Pstates = 6
	PSTATE_7       Pstates = 7
	PSTATE_8       Pstates = 8
	PSTATE_9       Pstates = 9
	PSTATE_10      Pstates = 10
	PSTATE_11      Pstates = 11
	PSTATE_12      Pstates = 12
	PSTATE_13      Pstates = 13
	PSTATE_14      Pstates = 14
	PSTATE_15      Pstates = 15
	PSTATE_UNKNOWN Pstates = 32
)

// GpuOperationMode as declared in nvml/nvml.h
type GpuOperationMode int32

// GpuOperationMode enumeration from nvml/nvml.h
const (
	GOM_ALL_ON  GpuOperationMode = iota
	GOM_COMPUTE GpuOperationMode = 1
	GOM_LOW_DP  GpuOperationMode = 2
)

// InforomObject as declared in nvml/nvml.h
type InforomObject int32

// InforomObject enumeration from nvml/nvml.h
const (
	INFOROM_OEM   InforomObject = iota
	INFOROM_ECC   InforomObject = 1
	INFOROM_POWER InforomObject = 2
	INFOROM_DEN   InforomObject = 3
	INFOROM_COUNT InforomObject = 4
)

// Return as declared in nvml/nvml.h
type Return int32

// Return enumeration from nvml/nvml.h
const (
	SUCCESS                         Return = iota
	ERROR_UNINITIALIZED             Return = 1
	ERROR_INVALID_ARGUMENT          Return = 2
	ERROR_NOT_SUPPORTED             Return = 3
	ERROR_NO_PERMISSION             Return = 4
	ERROR_ALREADY_INITIALIZED       Return = 5
	ERROR_NOT_FOUND                 Return = 6
	ERROR_INSUFFICIENT_SIZE         Return = 7
	ERROR_INSUFFICIENT_POWER        Return = 8
	ERROR_DRIVER_NOT_LOADED         Return = 9
	ERROR_TIMEOUT                   Return = 10
	ERROR_IRQ_ISSUE                 Return = 11
	ERROR_LIBRARY_NOT_FOUND         Return = 12
	ERROR_FUNCTION_NOT_FOUND        Return = 13
	ERROR_CORRUPTED_INFOROM         Return = 14
	ERROR_GPU_IS_LOST               Return = 15
	ERROR_RESET_REQUIRED            Return = 16
	ERROR_OPERATING_SYSTEM          Return = 17
	ERROR_LIB_RM_VERSION_MISMATCH   Return = 18
	ERROR_IN_USE                    Return = 19
	ERROR_MEMORY                    Return = 20
	ERROR_NO_DATA                   Return = 21
	ERROR_VGPU_ECC_NOT_SUPPORTED    Return = 22
	ERROR_INSUFFICIENT_RESOURCES    Return = 23
	ERROR_FREQ_NOT_SUPPORTED        Return = 24
	ERROR_ARGUMENT_VERSION_MISMATCH Return = 25
	ERROR_DEPRECATED                Return = 26
	ERROR_NOT_READY                 Return = 27
	ERROR_GPU_NOT_FOUND             Return = 28
	ERROR_INVALID_STATE             Return = 29
	ERROR_UNKNOWN                   Return = 999
)

// MemoryLocation as declared in nvml/nvml.h
type MemoryLocation int32

// MemoryLocation enumeration from nvml/nvml.h
const (
	MEMORY_LOCATION_L1_CACHE       MemoryLocation = iota
	MEMORY_LOCATION_L2_CACHE       MemoryLocation = 1
	MEMORY_LOCATION_DRAM           MemoryLocation = 2
	MEMORY_LOCATION_DEVICE_MEMORY  MemoryLocation = 2
	MEMORY_LOCATION_REGISTER_FILE  MemoryLocation = 3
	MEMORY_LOCATION_TEXTURE_MEMORY MemoryLocation = 4
	MEMORY_LOCATION_TEXTURE_SHM    MemoryLocation = 5
	MEMORY_LOCATION_CBU            MemoryLocation = 6
	MEMORY_LOCATION_SRAM           MemoryLocation = 7
	MEMORY_LOCATION_COUNT          MemoryLocation = 8
)

// PageRetirementCause as declared in nvml/nvml.h
type PageRetirementCause int32

// PageRetirementCause enumeration from nvml/nvml.h
const (
	PAGE_RETIREMENT_CAUSE_MULTIPLE_SINGLE_BIT_ECC_ERRORS PageRetirementCause = iota
	PAGE_RETIREMENT_CAUSE_DOUBLE_BIT_ECC_ERROR           PageRetirementCause = 1
	PAGE_RETIREMENT_CAUSE_COUNT                          PageRetirementCause = 2
)

// RestrictedAPI as declared in nvml/nvml.h
type RestrictedAPI int32

// RestrictedAPI enumeration from nvml/nvml.h
const (
	RESTRICTED_API_SET_APPLICATION_CLOCKS  RestrictedAPI = iota
	RESTRICTED_API_SET_AUTO_BOOSTED_CLOCKS RestrictedAPI = 1
	RESTRICTED_API_COUNT                   RestrictedAPI = 2
)

// GpuUtilizationDomainId as declared in nvml/nvml.h
type GpuUtilizationDomainId int32

// GpuUtilizationDomainId enumeration from nvml/nvml.h
const (
	GPU_UTILIZATION_DOMAIN_GPU GpuUtilizationDomainId = iota
	GPU_UTILIZATION_DOMAIN_FB  GpuUtilizationDomainId = 1
	GPU_UTILIZATION_DOMAIN_VID GpuUtilizationDomainId = 2
	GPU_UTILIZATION_DOMAIN_BUS GpuUtilizationDomainId = 3
)

// GpuVirtualizationMode as declared in nvml/nvml.h
type GpuVirtualizationMode int32

// GpuVirtualizationMode enumeration from nvml/nvml.h
const (
	GPU_VIRTUALIZATION_MODE_NONE        GpuVirtualizationMode = iota
	GPU_VIRTUALIZATION_MODE_PASSTHROUGH GpuVirtualizationMode = 1
	GPU_VIRTUALIZATION_MODE_VGPU        GpuVirtualizationMode = 2
	GPU_VIRTUALIZATION_MODE_HOST_VGPU   GpuVirtualizationMode = 3
	GPU_VIRTUALIZATION_MODE_HOST_VSGA   GpuVirtualizationMode = 4
)

// HostVgpuMode as declared in nvml/nvml.h
type HostVgpuMode int32

// HostVgpuMode enumeration from nvml/nvml.h
const (
	HOST_VGPU_MODE_NON_SRIOV HostVgpuMode = iota
	HOST_VGPU_MODE_SRIOV     HostVgpuMode = 1
)

// VgpuVmIdType as declared in nvml/nvml.h
type VgpuVmIdType int32

// VgpuVmIdType enumeration from nvml/nvml.h
const (
	VGPU_VM_ID_DOMAIN_ID VgpuVmIdType = iota
	VGPU_VM_ID_UUID      VgpuVmIdType = 1
)

// VgpuGuestInfoState as declared in nvml/nvml.h
type VgpuGuestInfoState int32

// VgpuGuestInfoState enumeration from nvml/nvml.h
const (
	VGPU_INSTANCE_GUEST_INFO_STATE_UNINITIALIZED VgpuGuestInfoState = iota
	VGPU_INSTANCE_GUEST_INFO_STATE_INITIALIZED   VgpuGuestInfoState = 1
)

// VgpuCapability as declared in nvml/nvml.h
type VgpuCapability int32

// VgpuCapability enumeration from nvml/nvml.h
const (
	VGPU_CAP_NVLINK_P2P           VgpuCapability = iota
	VGPU_CAP_GPUDIRECT            VgpuCapability = 1
	VGPU_CAP_MULTI_VGPU_EXCLUSIVE VgpuCapability = 2
	VGPU_CAP_EXCLUSIVE_TYPE       VgpuCapability = 3
	VGPU_CAP_EXCLUSIVE_SIZE       VgpuCapability = 4
	VGPU_CAP_COUNT                VgpuCapability = 5
)

// VgpuDriverCapability as declared in nvml/nvml.h
type VgpuDriverCapability int32

// VgpuDriverCapability enumeration from nvml/nvml.h
const (
	VGPU_DRIVER_CAP_HETEROGENEOUS_MULTI_VGPU VgpuDriverCapability = iota
	VGPU_DRIVER_CAP_WARM_UPDATE              VgpuDriverCapability = 1
	VGPU_DRIVER_CAP_COUNT                    VgpuDriverCapability = 2
)

// DeviceVgpuCapability as declared in nvml/nvml.h
type DeviceVgpuCapability int32

// DeviceVgpuCapability enumeration from nvml/nvml.h
const (
	DEVICE_VGPU_CAP_FRACTIONAL_MULTI_VGPU            DeviceVgpuCapability = iota
	DEVICE_VGPU_CAP_HETEROGENEOUS_TIMESLICE_PROFILES DeviceVgpuCapability = 1
	DEVICE_VGPU_CAP_HETEROGENEOUS_TIMESLICE_SIZES    DeviceVgpuCapability = 2
	DEVICE_VGPU_CAP_READ_DEVICE_BUFFER_BW            DeviceVgpuCapability = 3
	DEVICE_VGPU_CAP_WRITE_DEVICE_BUFFER_BW           DeviceVgpuCapability = 4
	DEVICE_VGPU_CAP_DEVICE_STREAMING                 DeviceVgpuCapability = 5
	DEVICE_VGPU_CAP_MINI_QUARTER_GPU                 DeviceVgpuCapability = 6
	DEVICE_VGPU_CAP_COMPUTE_MEDIA_ENGINE_GPU         DeviceVgpuCapability = 7
	DEVICE_VGPU_CAP_WARM_UPDATE                      DeviceVgpuCapability = 8
	DEVICE_VGPU_CAP_HOMOGENEOUS_PLACEMENTS           DeviceVgpuCapability = 9
	DEVICE_VGPU_CAP_MIG_TIMESLICING_SUPPORTED        DeviceVgpuCapability = 10
	DEVICE_VGPU_CAP_MIG_TIMESLICING_ENABLED          DeviceVgpuCapability = 11
	DEVICE_VGPU_CAP_COUNT                            DeviceVgpuCapability = 12
)

// DeviceGpuRecoveryAction as declared in nvml/nvml.h
type DeviceGpuRecoveryAction int32

// DeviceGpuRecoveryAction enumeration from nvml/nvml.h
const (
	GPU_RECOVERY_ACTION_NONE            DeviceGpuRecoveryAction = iota
	GPU_RECOVERY_ACTION_GPU_RESET       DeviceGpuRecoveryAction = 1
	GPU_RECOVERY_ACTION_NODE_REBOOT     DeviceGpuRecoveryAction = 2
	GPU_RECOVERY_ACTION_DRAIN_P2P       DeviceGpuRecoveryAction = 3
	GPU_RECOVERY_ACTION_DRAIN_AND_RESET DeviceGpuRecoveryAction = 4
)

// FanState as declared in nvml/nvml.h
type FanState int32

// FanState enumeration from nvml/nvml.h
const (
	FAN_NORMAL FanState = iota
	FAN_FAILED FanState = 1
)

// LedColor as declared in nvml/nvml.h
type LedColor int32

// LedColor enumeration from nvml/nvml.h
const (
	LED_COLOR_GREEN LedColor = iota
	LED_COLOR_AMBER LedColor = 1
)

// EncoderType as declared in nvml/nvml.h
type EncoderType int32

// EncoderType enumeration from nvml/nvml.h
const (
	ENCODER_QUERY_H264    EncoderType = iota
	ENCODER_QUERY_HEVC    EncoderType = 1
	ENCODER_QUERY_AV1     EncoderType = 2
	ENCODER_QUERY_UNKNOWN EncoderType = 255
)

// FBCSessionType as declared in nvml/nvml.h
type FBCSessionType int32

// FBCSessionType enumeration from nvml/nvml.h
const (
	FBC_SESSION_TYPE_UNKNOWN FBCSessionType = iota
	FBC_SESSION_TYPE_TOSYS   FBCSessionType = 1
	FBC_SESSION_TYPE_CUDA    FBCSessionType = 2
	FBC_SESSION_TYPE_VID     FBCSessionType = 3
	FBC_SESSION_TYPE_HWENC   FBCSessionType = 4
)

// DetachGpuState as declared in nvml/nvml.h
type DetachGpuState int32

// DetachGpuState enumeration from nvml/nvml.h
const (
	DETACH_GPU_KEEP   DetachGpuState = iota
	DETACH_GPU_REMOVE DetachGpuState = 1
)

// PcieLinkState as declared in nvml/nvml.h
type PcieLinkState int32

// PcieLinkState enumeration from nvml/nvml.h
const (
	PCIE_LINK_KEEP      PcieLinkState = iota
	PCIE_LINK_SHUT_DOWN PcieLinkState = 1
)

// ClockLimitId as declared in nvml/nvml.h
type ClockLimitId int32

// ClockLimitId enumeration from nvml/nvml.h
const (
	CLOCK_LIMIT_ID_RANGE_START ClockLimitId = -256
	CLOCK_LIMIT_ID_TDP         ClockLimitId = -255
	CLOCK_LIMIT_ID_UNLIMITED   ClockLimitId = -254
)

// VgpuVmCompatibility as declared in nvml/nvml.h
type VgpuVmCompatibility int32

// VgpuVmCompatibility enumeration from nvml/nvml.h
const (
	VGPU_VM_COMPATIBILITY_NONE      VgpuVmCompatibility = iota
	VGPU_VM_COMPATIBILITY_COLD      VgpuVmCompatibility = 1
	VGPU_VM_COMPATIBILITY_HIBERNATE VgpuVmCompatibility = 2
	VGPU_VM_COMPATIBILITY_SLEEP     VgpuVmCompatibility = 4
	VGPU_VM_COMPATIBILITY_LIVE      VgpuVmCompatibility = 8
)

// VgpuPgpuCompatibilityLimitCode as declared in nvml/nvml.h
type VgpuPgpuCompatibilityLimitCode int32

// VgpuPgpuCompatibilityLimitCode enumeration from nvml/nvml.h
const (
	VGPU_COMPATIBILITY_LIMIT_NONE         VgpuPgpuCompatibilityLimitCode = iota
	VGPU_COMPATIBILITY_LIMIT_HOST_DRIVER  VgpuPgpuCompatibilityLimitCode = 1
	VGPU_COMPATIBILITY_LIMIT_GUEST_DRIVER VgpuPgpuCompatibilityLimitCode = 2
	VGPU_COMPATIBILITY_LIMIT_GPU          VgpuPgpuCompatibilityLimitCode = 4
	VGPU_COMPATIBILITY_LIMIT_OTHER        VgpuPgpuCompatibilityLimitCode = -2147483648
)

// ThermalTarget as declared in nvml/nvml.h
type ThermalTarget int32

// ThermalTarget enumeration from nvml/nvml.h
const (
	THERMAL_TARGET_NONE         ThermalTarget = iota
	THERMAL_TARGET_GPU          ThermalTarget = 1
	THERMAL_TARGET_MEMORY       ThermalTarget = 2
	THERMAL_TARGET_POWER_SUPPLY ThermalTarget = 4
	THERMAL_TARGET_BOARD        ThermalTarget = 8
	THERMAL_TARGET_VCD_BOARD    ThermalTarget = 9
	THERMAL_TARGET_VCD_INLET    ThermalTarget = 10
	THERMAL_TARGET_VCD_OUTLET   ThermalTarget = 11
	THERMAL_TARGET_ALL          ThermalTarget = 15
	THERMAL_TARGET_UNKNOWN      ThermalTarget = -1
)

// ThermalController as declared in nvml/nvml.h
type ThermalController int32

// ThermalController enumeration from nvml/nvml.h
const (
	THERMAL_CONTROLLER_NONE            ThermalController = iota
	THERMAL_CONTROLLER_GPU_INTERNAL    ThermalController = 1
	THERMAL_CONTROLLER_ADM1032         ThermalController = 2
	THERMAL_CONTROLLER_ADT7461         ThermalController = 3
	THERMAL_CONTROLLER_MAX6649         ThermalController = 4
	THERMAL_CONTROLLER_MAX1617         ThermalController = 5
	THERMAL_CONTROLLER_LM99            ThermalController = 6
	THERMAL_CONTROLLER_LM89            ThermalController = 7
	THERMAL_CONTROLLER_LM64            ThermalController = 8
	THERMAL_CONTROLLER_G781            ThermalController = 9
	THERMAL_CONTROLLER_ADT7473         ThermalController = 10
	THERMAL_CONTROLLER_SBMAX6649       ThermalController = 11
	THERMAL_CONTROLLER_VBIOSEVT        ThermalController = 12
	THERMAL_CONTROLLER_OS              ThermalController = 13
	THERMAL_CONTROLLER_NVSYSCON_CANOAS ThermalController = 14
	THERMAL_CONTROLLER_NVSYSCON_E551   ThermalController = 15
	THERMAL_CONTROLLER_MAX6649R        ThermalController = 16
	THERMAL_CONTROLLER_ADT7473S        ThermalController = 17
	THERMAL_CONTROLLER_UNKNOWN         ThermalController = -1
)

// UUIDType as declared in nvml/nvml.h
type UUIDType int32

// UUIDType enumeration from nvml/nvml.h
const (
	UUID_TYPE_NONE   UUIDType = iota
	UUID_TYPE_ASCII  UUIDType = 1
	UUID_TYPE_BINARY UUIDType = 2
)

// GridLicenseFeatureCode as declared in nvml/nvml.h
type GridLicenseFeatureCode int32

// GridLicenseFeatureCode enumeration from nvml/nvml.h
const (
	GRID_LICENSE_FEATURE_CODE_UNKNOWN      GridLicenseFeatureCode = iota
	GRID_LICENSE_FEATURE_CODE_VGPU         GridLicenseFeatureCode = 1
	GRID_LICENSE_FEATURE_CODE_NVIDIA_RTX   GridLicenseFeatureCode = 2
	GRID_LICENSE_FEATURE_CODE_VWORKSTATION GridLicenseFeatureCode = 2
	GRID_LICENSE_FEATURE_CODE_GAMING       GridLicenseFeatureCode = 3
	GRID_LICENSE_FEATURE_CODE_COMPUTE      GridLicenseFeatureCode = 4
)

// GpmMetricId as declared in nvml/nvml.h
type GpmMetricId int32

// GpmMetricId enumeration from nvml/nvml.h
const (
	GPM_METRIC_GRAPHICS_UTIL               GpmMetricId = 1
	GPM_METRIC_SM_UTIL                     GpmMetricId = 2
	GPM_METRIC_SM_OCCUPANCY                GpmMetricId = 3
	GPM_METRIC_INTEGER_UTIL                GpmMetricId = 4
	GPM_METRIC_ANY_TENSOR_UTIL             GpmMetricId = 5
	GPM_METRIC_DFMA_TENSOR_UTIL            GpmMetricId = 6
	GPM_METRIC_HMMA_TENSOR_UTIL            GpmMetricId = 7
	GPM_METRIC_IMMA_TENSOR_UTIL            GpmMetricId = 9
	GPM_METRIC_DRAM_BW_UTIL                GpmMetricId = 10
	GPM_METRIC_FP64_UTIL                   GpmMetricId = 11
	GPM_METRIC_FP32_UTIL                   GpmMetricId = 12
	GPM_METRIC_FP16_UTIL                   GpmMetricId = 13
	GPM_METRIC_PCIE_TX_PER_SEC             GpmMetricId = 20
	GPM_METRIC_PCIE_RX_PER_SEC             GpmMetricId = 21
	GPM_METRIC_NVDEC_0_UTIL                GpmMetricId = 30
	GPM_METRIC_NVDEC_1_UTIL                GpmMetricId = 31
	GPM_METRIC_NVDEC_2_UTIL                GpmMetricId = 32
	GPM_METRIC_NVDEC_3_UTIL                GpmMetricId = 33
	GPM_METRIC_NVDEC_4_UTIL                GpmMetricId = 34
	GPM_METRIC_NVDEC_5_UTIL                GpmMetricId = 35
	GPM_METRIC_NVDEC_6_UTIL                GpmMetricId = 36
	GPM_METRIC_NVDEC_7_UTIL                GpmMetricId = 37
	GPM_METRIC_NVJPG_0_UTIL                GpmMetricId = 40
	GPM_METRIC_NVJPG_1_UTIL                GpmMetricId = 41
	GPM_METRIC_NVJPG_2_UTIL                GpmMetricId = 42
	GPM_METRIC_NVJPG_3_UTIL                GpmMetricId = 43
	GPM_METRIC_NVJPG_4_UTIL                GpmMetricId = 44
	GPM_METRIC_NVJPG_5_UTIL                GpmMetricId = 45
	GPM_METRIC_NVJPG_6_UTIL                GpmMetricId = 46
	GPM_METRIC_NVJPG_7_UTIL                GpmMetricId = 47
	GPM_METRIC_NVOFA_0_UTIL                GpmMetricId = 50
	GPM_METRIC_NVOFA_1_UTIL                GpmMetricId = 51
	GPM_METRIC_NVLINK_TOTAL_RX_PER_SEC     GpmMetricId = 60
	GPM_METRIC_NVLINK_TOTAL_TX_PER_SEC     GpmMetricId = 61
	GPM_METRIC_NVLINK_L0_RX_PER_SEC        GpmMetricId = 62
	GPM_METRIC_NVLINK_L0_TX_PER_SEC        GpmMetricId = 63
	GPM_METRIC_NVLINK_L1_RX_PER_SEC        GpmMetricId = 64
	GPM_METRIC_NVLINK_L1_TX_PER_SEC        GpmMetricId = 65
	GPM_METRIC_NVLINK_L2_RX_PER_SEC        GpmMetricId = 66
	GPM_METRIC_NVLINK_L2_TX_PER_SEC        GpmMetricId = 67
	GPM_METRIC_NVLINK_L3_RX_PER_SEC        GpmMetricId = 68
	GPM_METRIC_NVLINK_L3_TX_PER_SEC        GpmMetricId = 69
	GPM_METRIC_NVLINK_L4_RX_PER_SEC        GpmMetricId = 70
	GPM_METRIC_NVLINK_L4_TX_PER_SEC        GpmMetricId = 71
	GPM_METRIC_NVLINK_L5_RX_PER_SEC        GpmMetricId = 72
	GPM_METRIC_NVLINK_L5_TX_PER_SEC        GpmMetricId = 73
	GPM_METRIC_NVLINK_L6_RX_PER_SEC        GpmMetricId = 74
	GPM_METRIC_NVLINK_L6_TX_PER_SEC        GpmMetricId = 75
	GPM_METRIC_NVLINK_L7_RX_PER_SEC        GpmMetricId = 76
	GPM_METRIC_NVLINK_L7_TX_PER_SEC        GpmMetricId = 77
	GPM_METRIC_NVLINK_L8_RX_PER_SEC        GpmMetricId = 78
	GPM_METRIC_NVLINK_L8_TX_PER_SEC        GpmMetricId = 79
	GPM_METRIC_NVLINK_L9_RX_PER_SEC        GpmMetricId = 80
	GPM_METRIC_NVLINK_L9_TX_PER_SEC        GpmMetricId = 81
	GPM_METRIC_NVLINK_L10_RX_PER_SEC       GpmMetricId = 82
	GPM_METRIC_NVLINK_L10_TX_PER_SEC       GpmMetricId = 83
	GPM_METRIC_NVLINK_L11_RX_PER_SEC       GpmMetricId = 84
	GPM_METRIC_NVLINK_L11_TX_PER_SEC       GpmMetricId = 85
	GPM_METRIC_NVLINK_L12_RX_PER_SEC       GpmMetricId = 86
	GPM_METRIC_NVLINK_L12_TX_PER_SEC       GpmMetricId = 87
	GPM_METRIC_NVLINK_L13_RX_PER_SEC       GpmMetricId = 88
	GPM_METRIC_NVLINK_L13_TX_PER_SEC       GpmMetricId = 89
	GPM_METRIC_NVLINK_L14_RX_PER_SEC       GpmMetricId = 90
	GPM_METRIC_NVLINK_L14_TX_PER_SEC       GpmMetricId = 91
	GPM_METRIC_NVLINK_L15_RX_PER_SEC       GpmMetricId = 92
	GPM_METRIC_NVLINK_L15_TX_PER_SEC       GpmMetricId = 93
	GPM_METRIC_NVLINK_L16_RX_PER_SEC       GpmMetricId = 94
	GPM_METRIC_NVLINK_L16_TX_PER_SEC       GpmMetricId = 95
	GPM_METRIC_NVLINK_L17_RX_PER_SEC       GpmMetricId = 96
	GPM_METRIC_NVLINK_L17_TX_PER_SEC       GpmMetricId = 97
	GPM_METRIC_C2C_TOTAL_TX_PER_SEC        GpmMetricId = 100
	GPM_METRIC_C2C_TOTAL_RX_PER_SEC        GpmMetricId = 101
	GPM_METRIC_C2C_DATA_TX_PER_SEC         GpmMetricId = 102
	GPM_METRIC_C2C_DATA_RX_PER_SEC         GpmMetricId = 103
	GPM_METRIC_C2C_LINK0_TOTAL_TX_PER_SEC  GpmMetricId = 104
	GPM_METRIC_C2C_LINK0_TOTAL_RX_PER_SEC  GpmMetricId = 105
	GPM_METRIC_C2C_LINK0_DATA_TX_PER_SEC   GpmMetricId = 106
	GPM_METRIC_C2C_LINK0_DATA_RX_PER_SEC   GpmMetricId = 107
	GPM_METRIC_C2C_LINK1_TOTAL_TX_PER_SEC  GpmMetricId = 108
	GPM_METRIC_C2C_LINK1_TOTAL_RX_PER_SEC  GpmMetricId = 109
	GPM_METRIC_C2C_LINK1_DATA_TX_PER_SEC   GpmMetricId = 110
	GPM_METRIC_C2C_LINK1_DATA_RX_PER_SEC   GpmMetricId = 111
	GPM_METRIC_C2C_LINK2_TOTAL_TX_PER_SEC  GpmMetricId = 112
	GPM_METRIC_C2C_LINK2_TOTAL_RX_PER_SEC  GpmMetricId = 113
	GPM_METRIC_C2C_LINK2_DATA_TX_PER_SEC   GpmMetricId = 114
	GPM_METRIC_C2C_LINK2_DATA_RX_PER_SEC   GpmMetricId = 115
	GPM_METRIC_C2C_LINK3_TOTAL_TX_PER_SEC  GpmMetricId = 116
	GPM_METRIC_C2C_LINK3_TOTAL_RX_PER_SEC  GpmMetricId = 117
	GPM_METRIC_C2C_LINK3_DATA_TX_PER_SEC   GpmMetricId = 118
	GPM_METRIC_C2C_LINK3_DATA_RX_PER_SEC   GpmMetricId = 119
	GPM_METRIC_C2C_LINK4_TOTAL_TX_PER_SEC  GpmMetricId = 120
	GPM_METRIC_C2C_LINK4_TOTAL_RX_PER_SEC  GpmMetricId = 121
	GPM_METRIC_C2C_LINK4_DATA_TX_PER_SEC   GpmMetricId = 122
	GPM_METRIC_C2C_LINK4_DATA_RX_PER_SEC   GpmMetricId = 123
	GPM_METRIC_C2C_LINK5_TOTAL_TX_PER_SEC  GpmMetricId = 124
	GPM_METRIC_C2C_LINK5_TOTAL_RX_PER_SEC  GpmMetricId = 125
	GPM_METRIC_C2C_LINK5_DATA_TX_PER_SEC   GpmMetricId = 126
	GPM_METRIC_C2C_LINK5_DATA_RX_PER_SEC   GpmMetricId = 127
	GPM_METRIC_C2C_LINK6_TOTAL_TX_PER_SEC  GpmMetricId = 128
	GPM_METRIC_C2C_LINK6_TOTAL_RX_PER_SEC  GpmMetricId = 129
	GPM_METRIC_C2C_LINK6_DATA_TX_PER_SEC   GpmMetricId = 130
	GPM_METRIC_C2C_LINK6_DATA_RX_PER_SEC   GpmMetricId = 131
	GPM_METRIC_C2C_LINK7_TOTAL_TX_PER_SEC  GpmMetricId = 132
	GPM_METRIC_C2C_LINK7_TOTAL_RX_PER_SEC  GpmMetricId = 133
	GPM_METRIC_C2C_LINK7_DATA_TX_PER_SEC   GpmMetricId = 134
	GPM_METRIC_C2C_LINK7_DATA_RX_PER_SEC   GpmMetricId = 135
	GPM_METRIC_C2C_LINK8_TOTAL_TX_PER_SEC  GpmMetricId = 136
	GPM_METRIC_C2C_LINK8_TOTAL_RX_PER_SEC  GpmMetricId = 137
	GPM_METRIC_C2C_LINK8_DATA_TX_PER_SEC   GpmMetricId = 138
	GPM_METRIC_C2C_LINK8_DATA_RX_PER_SEC   GpmMetricId = 139
	GPM_METRIC_C2C_LINK9_TOTAL_TX_PER_SEC  GpmMetricId = 140
	GPM_METRIC_C2C_LINK9_TOTAL_RX_PER_SEC  GpmMetricId = 141
	GPM_METRIC_C2C_LINK9_DATA_TX_PER_SEC   GpmMetricId = 142
	GPM_METRIC_C2C_LINK9_DATA_RX_PER_SEC   GpmMetricId = 143
	GPM_METRIC_C2C_LINK10_TOTAL_TX_PER_SEC GpmMetricId = 144
	GPM_METRIC_C2C_LINK10_TOTAL_RX_PER_SEC GpmMetricId = 145
	GPM_METRIC_C2C_LINK10_DATA_TX_PER_SEC  GpmMetricId = 146
	GPM_METRIC_C2C_LINK10_DATA_RX_PER_SEC  GpmMetricId = 147
	GPM_METRIC_C2C_LINK11_TOTAL_TX_PER_SEC GpmMetricId = 148
	GPM_METRIC_C2C_LINK11_TOTAL_RX_PER_SEC GpmMetricId = 149
	GPM_METRIC_C2C_LINK11_DATA_TX_PER_SEC  GpmMetricId = 150
	GPM_METRIC_C2C_LINK11_DATA_RX_PER_SEC  GpmMetricId = 151
	GPM_METRIC_C2C_LINK12_TOTAL_TX_PER_SEC GpmMetricId = 152
	GPM_METRIC_C2C_LINK12_TOTAL_RX_PER_SEC GpmMetricId = 153
	GPM_METRIC_C2C_LINK12_DATA_TX_PER_SEC  GpmMetricId = 154
	GPM_METRIC_C2C_LINK12_DATA_RX_PER_SEC  GpmMetricId = 155
	GPM_METRIC_C2C_LINK13_TOTAL_TX_PER_SEC GpmMetricId = 156
	GPM_METRIC_C2C_LINK13_TOTAL_RX_PER_SEC GpmMetricId = 157
	GPM_METRIC_C2C_LINK13_DATA_TX_PER_SEC  GpmMetricId = 158
	GPM_METRIC_C2C_LINK13_DATA_RX_PER_SEC  GpmMetricId = 159
	GPM_METRIC_HOSTMEM_CACHE_HIT           GpmMetricId = 160
	GPM_METRIC_HOSTMEM_CACHE_MISS          GpmMetricId = 161
	GPM_METRIC_PEERMEM_CACHE_HIT           GpmMetricId = 162
	GPM_METRIC_PEERMEM_CACHE_MISS          GpmMetricId = 163
	GPM_METRIC_DRAM_CACHE_HIT              GpmMetricId = 164
	GPM_METRIC_DRAM_CACHE_MISS             GpmMetricId = 165
	GPM_METRIC_NVENC_0_UTIL                GpmMetricId = 166
	GPM_METRIC_NVENC_1_UTIL                GpmMetricId = 167
	GPM_METRIC_NVENC_2_UTIL                GpmMetricId = 168
	GPM_METRIC_NVENC_3_UTIL                GpmMetricId = 169
	GPM_METRIC_GR0_CTXSW_CYCLES_ELAPSED    GpmMetricId = 170
	GPM_METRIC_GR0_CTXSW_CYCLES_ACTIVE     GpmMetricId = 171
	GPM_METRIC_GR0_CTXSW_REQUESTS          GpmMetricId = 172
	GPM_METRIC_GR0_CTXSW_CYCLES_PER_REQ    GpmMetricId = 173
	GPM_METRIC_GR0_CTXSW_ACTIVE_PCT        GpmMetricId = 174
	GPM_METRIC_GR1_CTXSW_CYCLES_ELAPSED    GpmMetricId = 175
	GPM_METRIC_GR1_CTXSW_CYCLES_ACTIVE     GpmMetricId = 176
	GPM_METRIC_GR1_CTXSW_REQUESTS          GpmMetricId = 177
	GPM_METRIC_GR1_CTXSW_CYCLES_PER_REQ    GpmMetricId = 178
	GPM_METRIC_GR1_CTXSW_ACTIVE_PCT        GpmMetricId = 179
	GPM_METRIC_GR2_CTXSW_CYCLES_ELAPSED    GpmMetricId = 180
	GPM_METRIC_GR2_CTXSW_CYCLES_ACTIVE     GpmMetricId = 181
	GPM_METRIC_GR2_CTXSW_REQUESTS          GpmMetricId = 182
	GPM_METRIC_GR2_CTXSW_CYCLES_PER_REQ    GpmMetricId = 183
	GPM_METRIC_GR2_CTXSW_ACTIVE_PCT        GpmMetricId = 184
	GPM_METRIC_GR3_CTXSW_CYCLES_ELAPSED    GpmMetricId = 185
	GPM_METRIC_GR3_CTXSW_CYCLES_ACTIVE     GpmMetricId = 186
	GPM_METRIC_GR3_CTXSW_REQUESTS          GpmMetricId = 187
	GPM_METRIC_GR3_CTXSW_CYCLES_PER_REQ    GpmMetricId = 188
	GPM_METRIC_GR3_CTXSW_ACTIVE_PCT        GpmMetricId = 189
	GPM_METRIC_GR4_CTXSW_CYCLES_ELAPSED    GpmMetricId = 190
	GPM_METRIC_GR4_CTXSW_CYCLES_ACTIVE     GpmMetricId = 191
	GPM_METRIC_GR4_CTXSW_REQUESTS          GpmMetricId = 192
	GPM_METRIC_GR4_CTXSW_CYCLES_PER_REQ    GpmMetricId = 193
	GPM_METRIC_GR4_CTXSW_ACTIVE_PCT        GpmMetricId = 194
	GPM_METRIC_GR5_CTXSW_CYCLES_ELAPSED    GpmMetricId = 195
	GPM_METRIC_GR5_CTXSW_CYCLES_ACTIVE     GpmMetricId = 196
	GPM_METRIC_GR5_CTXSW_REQUESTS          GpmMetricId = 197
	GPM_METRIC_GR5_CTXSW_CYCLES_PER_REQ    GpmMetricId = 198
	GPM_METRIC_GR5_CTXSW_ACTIVE_PCT        GpmMetricId = 199
	GPM_METRIC_GR6_CTXSW_CYCLES_ELAPSED    GpmMetricId = 200
	GPM_METRIC_GR6_CTXSW_CYCLES_ACTIVE     GpmMetricId = 201
	GPM_METRIC_GR6_CTXSW_REQUESTS          GpmMetricId = 202
	GPM_METRIC_GR6_CTXSW_CYCLES_PER_REQ    GpmMetricId = 203
	GPM_METRIC_GR6_CTXSW_ACTIVE_PCT        GpmMetricId = 204
	GPM_METRIC_GR7_CTXSW_CYCLES_ELAPSED    GpmMetricId = 205
	GPM_METRIC_GR7_CTXSW_CYCLES_ACTIVE     GpmMetricId = 206
	GPM_METRIC_GR7_CTXSW_REQUESTS          GpmMetricId = 207
	GPM_METRIC_GR7_CTXSW_CYCLES_PER_REQ    GpmMetricId = 208
	GPM_METRIC_GR7_CTXSW_ACTIVE_PCT        GpmMetricId = 209
	GPM_METRIC_MAX                         GpmMetricId = 210
)

// PowerProfileType as declared in nvml/nvml.h
type PowerProfileType int32

// PowerProfileType enumeration from nvml/nvml.h
const (
	POWER_PROFILE_MAX_P         PowerProfileType = iota
	POWER_PROFILE_MAX_Q         PowerProfileType = 1
	POWER_PROFILE_COMPUTE       PowerProfileType = 2
	POWER_PROFILE_MEMORY_BOUND  PowerProfileType = 3
	POWER_PROFILE_NETWORK       PowerProfileType = 4
	POWER_PROFILE_BALANCED      PowerProfileType = 5
	POWER_PROFILE_LLM_INFERENCE PowerProfileType = 6
	POWER_PROFILE_LLM_TRAINING  PowerProfileType = 7
	POWER_PROFILE_RBM           PowerProfileType = 8
	POWER_PROFILE_DCPCIE        PowerProfileType = 9
	POWER_PROFILE_HMMA_SPARSE   PowerProfileType = 10
	POWER_PROFILE_HMMA_DENSE    PowerProfileType = 11
	POWER_PROFILE_SYNC_BALANCED PowerProfileType = 12
	POWER_PROFILE_HPC           PowerProfileType = 13
	POWER_PROFILE_MIG           PowerProfileType = 14
	POWER_PROFILE_MAX           PowerProfileType = 15
)
