/*
 * Decompiled with CFR 0.152.
 */
package org.apache.tools.ant.taskdefs;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import org.apache.tools.ant.AntClassLoader;
import org.apache.tools.ant.BuildException;
import org.apache.tools.ant.Task;
import org.apache.tools.ant.types.Path;
import org.apache.tools.ant.types.Reference;

public abstract class Definer
extends Task {
    private String name;
    private String value;
    private Path classpath;
    private File file;
    private String resource;
    private boolean reverseLoader = false;

    public void setReverseLoader(boolean bl) {
        this.reverseLoader = bl;
        this.log("The reverseloader attribute is DEPRECATED. It will be removed", 1);
    }

    public void setClasspath(Path path) {
        if (this.classpath == null) {
            this.classpath = path;
        } else {
            this.classpath.append(path);
        }
    }

    public Path createClasspath() {
        if (this.classpath == null) {
            this.classpath = new Path(this.project);
        }
        return this.classpath.createPath();
    }

    public void setClasspathRef(Reference reference) {
        this.createClasspath().setRefid(reference);
    }

    public void execute() throws BuildException {
        AntClassLoader antClassLoader = this.createLoader();
        if (this.file == null && this.resource == null) {
            if (this.name == null || this.value == null) {
                String string = "name or classname attributes of " + this.getTaskName() + " element " + "are undefined";
                throw new BuildException(string);
            }
            this.addDefinition(antClassLoader, this.name, this.value);
        } else {
            try {
                if (this.name != null || this.value != null) {
                    String string = "You must not specify name or value together with file or resource.";
                    throw new BuildException(string, this.location);
                }
                if (this.file != null && this.resource != null) {
                    String string = "You must not specify both, file and resource.";
                    throw new BuildException(string, this.location);
                }
                Properties properties = new Properties();
                InputStream inputStream = null;
                if (this.file != null) {
                    this.log("Loading definitions from file " + this.file, 3);
                    inputStream = new FileInputStream(this.file);
                    if (inputStream == null) {
                        this.log("Could not load definitions from file " + this.file + ". It doesn't exist.", 1);
                    }
                }
                if (this.resource != null) {
                    this.log("Loading definitions from resource " + this.resource, 3);
                    inputStream = antClassLoader.getResourceAsStream(this.resource);
                    if (inputStream == null) {
                        this.log("Could not load definitions from resource " + this.resource + ". It could not be found.", 1);
                    }
                }
                if (inputStream != null) {
                    properties.load(inputStream);
                    Enumeration enumeration = ((Hashtable)properties).keys();
                    while (enumeration.hasMoreElements()) {
                        String string = (String)enumeration.nextElement();
                        String string2 = properties.getProperty(string);
                        this.addDefinition(antClassLoader, string, string2);
                    }
                }
            }
            catch (IOException iOException) {
                throw new BuildException(iOException, this.location);
            }
        }
    }

    private void addDefinition(ClassLoader classLoader, String string, String string2) {
        try {
            Class<?> clazz = classLoader.loadClass(string2);
            AntClassLoader.initializeClass(clazz);
            this.addDefinition(string, clazz);
        }
        catch (ClassNotFoundException classNotFoundException) {
            String string3 = this.getTaskName() + " class " + string2 + " cannot be found";
            throw new BuildException(string3, classNotFoundException, this.location);
        }
        catch (NoClassDefFoundError noClassDefFoundError) {
            String string4 = this.getTaskName() + " class " + string2 + " cannot be found";
            throw new BuildException(string4, noClassDefFoundError, this.location);
        }
    }

    private AntClassLoader createLoader() {
        AntClassLoader antClassLoader = null;
        antClassLoader = this.classpath != null ? new AntClassLoader(this.project, this.classpath, !this.reverseLoader) : new AntClassLoader(this.project, Path.systemClasspath, !this.reverseLoader);
        antClassLoader.addSystemPackageRoot("org.apache.tools.ant");
        return antClassLoader;
    }

    public void setFile(File file) {
        this.file = file;
    }

    public void setResource(String string) {
        this.resource = string;
    }

    public void setName(String string) {
        this.name = string;
    }

    public String getClassname() {
        return this.value;
    }

    public void setClassname(String string) {
        this.value = string;
    }

    protected abstract void addDefinition(String var1, Class var2);
}

