/* automatically generated by rust-bindgen 0.70.1 */

// Copyright (C) 2024 Advanced Micro Devices. All rights reserved.
//
// Permission is hereby granted, free of charge, to any person obtaining a copy of
// this software and associated documentation files (the "Software"), to deal in
// the Software without restriction, including without limitation the rights to
// use, copy, modify, merge, publish, distribute, sublicense, and/or sell copies of
// the Software, and to permit persons to whom the Software is furnished to do so,
// subject to the following conditions:
//
// The above copyright notice and this permission notice shall be included in all
// copies or substantial portions of the Software.
//
// THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
// IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, FITNESS
// FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE AUTHORS OR
// COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER LIABILITY, WHETHER
// IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM, OUT OF OR IN
// CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE SOFTWARE.

#![allow(non_upper_case_globals)]

#[repr(C)]
#[derive(Copy, Clone, Debug, Default, Eq, Hash, Ord, PartialEq, PartialOrd)]
pub struct __BindgenBitfieldUnit<Storage> {
    storage: Storage,
}
impl<Storage> __BindgenBitfieldUnit<Storage> {
    #[inline]
    pub const fn new(storage: Storage) -> Self {
        Self { storage }
    }
}
impl<Storage> __BindgenBitfieldUnit<Storage>
where
    Storage: AsRef<[u8]> + AsMut<[u8]>,
{
    #[inline]
    pub fn get_bit(&self, index: usize) -> bool {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = self.storage.as_ref()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        byte & mask == mask
    }
    #[inline]
    pub fn set_bit(&mut self, index: usize, val: bool) {
        debug_assert!(index / 8 < self.storage.as_ref().len());
        let byte_index = index / 8;
        let byte = &mut self.storage.as_mut()[byte_index];
        let bit_index = if cfg!(target_endian = "big") {
            7 - (index % 8)
        } else {
            index % 8
        };
        let mask = 1 << bit_index;
        if val {
            *byte |= mask;
        } else {
            *byte &= !mask;
        }
    }
    #[inline]
    pub fn get(&self, bit_offset: usize, bit_width: u8) -> u64 {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        let mut val = 0;
        for i in 0..(bit_width as usize) {
            if self.get_bit(i + bit_offset) {
                let index = if cfg!(target_endian = "big") {
                    bit_width as usize - 1 - i
                } else {
                    i
                };
                val |= 1 << index;
            }
        }
        val
    }
    #[inline]
    pub fn set(&mut self, bit_offset: usize, bit_width: u8, val: u64) {
        debug_assert!(bit_width <= 64);
        debug_assert!(bit_offset / 8 < self.storage.as_ref().len());
        debug_assert!((bit_offset + (bit_width as usize)) / 8 <= self.storage.as_ref().len());
        for i in 0..(bit_width as usize) {
            let mask = 1 << i;
            let val_bit_is_set = val & mask == mask;
            let index = if cfg!(target_endian = "big") {
                bit_width as usize - 1 - i
            } else {
                i
            };
            self.set_bit(index + bit_offset, val_bit_is_set);
        }
    }
}
pub const AMDSMI_MAX_MM_IP_COUNT: u32 = 8;
pub const AMDSMI_MAX_STRING_LENGTH: u32 = 256;
pub const AMDSMI_MAX_DEVICES: u32 = 32;
pub const AMDSMI_MAX_CONTAINER_TYPE: u32 = 2;
pub const AMDSMI_MAX_CACHE_TYPES: u32 = 10;
pub const AMDSMI_MAX_NUM_XGMI_PHYSICAL_LINK: u32 = 64;
pub const AMDSMI_MAX_ACCELERATOR_PROFILE: u32 = 32;
pub const AMDSMI_MAX_CP_PROFILE_RESOURCES: u32 = 32;
pub const AMDSMI_MAX_ACCELERATOR_PARTITIONS: u32 = 8;
pub const AMDSMI_GPU_UUID_SIZE: u32 = 38;
pub const AMDSMI_NUM_HBM_INSTANCES: u32 = 4;
pub const AMDSMI_MAX_NUM_VCN: u32 = 4;
pub const AMDSMI_MAX_NUM_CLKS: u32 = 4;
pub const AMDSMI_MAX_NUM_XGMI_LINKS: u32 = 8;
pub const AMDSMI_MAX_NUM_GFX_CLKS: u32 = 8;
pub const AMDSMI_MAX_AID: u32 = 4;
pub const AMDSMI_MAX_ENGINES: u32 = 8;
pub const AMDSMI_MAX_NUM_JPEG: u32 = 32;
pub const AMDSMI_MAX_NUM_XCC: u32 = 8;
pub const AMDSMI_MAX_NUM_XCP: u32 = 8;
pub const AMDSMI_TIME_FORMAT: &[u8; 20] = b"%02d:%02d:%02d.%03d\0";
pub const AMDSMI_DATE_FORMAT: &[u8; 35] = b"%04d-%02d-%02d:%02d:%02d:%02d.%03d\0";
pub const AMDSMI_LIB_VERSION_MAJOR: u32 = 26;
pub const AMDSMI_LIB_VERSION_MINOR: u32 = 0;
pub const AMDSMI_LIB_VERSION_RELEASE: u32 = 2;
pub const AMDSMI_MAX_NUM_FREQUENCIES: u32 = 33;
pub const AMDSMI_MAX_FAN_SPEED: u32 = 255;
pub const AMDSMI_NUM_VOLTAGE_CURVE_POINTS: u32 = 3;
pub const AMDSMI_MAX_UTILIZATION_VALUES: u32 = 4;
pub const AMDSMI_MAX_NUM_PM_POLICIES: u32 = 32;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiInitFlagsT {
    AmdsmiInitAllProcessors = 4294967295,
    AmdsmiInitAmdCpus = 1,
    AmdsmiInitAmdGpus = 2,
    AmdsmiInitNonAmdCpus = 4,
    AmdsmiInitNonAmdGpus = 8,
    AmdsmiInitAmdApus = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiMmIpT {
    AmdsmiMmUvd = 0,
    AmdsmiMmVce = 1,
    AmdsmiMmVcn = 2,
    AmdsmiMmMax = 3,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiContainerTypesT {
    AmdsmiContainerLxc = 0,
    AmdsmiContainerDocker = 1,
}
pub type AmdsmiProcessorHandle = *mut ::std::os::raw::c_void;
pub type AmdsmiSocketHandle = *mut ::std::os::raw::c_void;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum ProcessorTypeT {
    AmdsmiProcessorTypeUnknown = 0,
    AmdsmiProcessorTypeAmdGpu = 1,
    AmdsmiProcessorTypeAmdCpu = 2,
    AmdsmiProcessorTypeNonAmdGpu = 3,
    AmdsmiProcessorTypeNonAmdCpu = 4,
    AmdsmiProcessorTypeAmdCpuCore = 5,
    AmdsmiProcessorTypeAmdApu = 6,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiStatusT {
    AmdsmiStatusSuccess = 0,
    AmdsmiStatusInval = 1,
    AmdsmiStatusNotSupported = 2,
    AmdsmiStatusNotYetImplemented = 3,
    AmdsmiStatusFailLoadModule = 4,
    AmdsmiStatusFailLoadSymbol = 5,
    AmdsmiStatusDrmError = 6,
    AmdsmiStatusApiFailed = 7,
    AmdsmiStatusTimeout = 8,
    AmdsmiStatusRetry = 9,
    AmdsmiStatusNoPerm = 10,
    AmdsmiStatusInterrupt = 11,
    AmdsmiStatusIo = 12,
    AmdsmiStatusAddressFault = 13,
    AmdsmiStatusFileError = 14,
    AmdsmiStatusOutOfResources = 15,
    AmdsmiStatusInternalException = 16,
    AmdsmiStatusInputOutOfBounds = 17,
    AmdsmiStatusInitError = 18,
    AmdsmiStatusRefcountOverflow = 19,
    AmdsmiStatusBusy = 30,
    AmdsmiStatusNotFound = 31,
    AmdsmiStatusNotInit = 32,
    AmdsmiStatusNoSlot = 33,
    AmdsmiStatusDriverNotLoaded = 34,
    AmdsmiStatusNoData = 40,
    AmdsmiStatusInsufficientSize = 41,
    AmdsmiStatusUnexpectedSize = 42,
    AmdsmiStatusUnexpectedData = 43,
    AmdsmiStatusNonAmdCpu = 44,
    AmdsmiStatusNoEnergyDrv = 45,
    AmdsmiStatusNoMsrDrv = 46,
    AmdsmiStatusNoHsmpDrv = 47,
    AmdsmiStatusNoHsmpSup = 48,
    AmdsmiStatusNoHsmpMsgSup = 49,
    AmdsmiStatusHsmpTimeout = 50,
    AmdsmiStatusNoDrv = 51,
    AmdsmiStatusFileNotFound = 52,
    AmdsmiStatusArgPtrNull = 53,
    AmdsmiStatusAmdgpuRestartErr = 54,
    AmdsmiStatusSettingUnavailable = 55,
    AmdsmiStatusMapError = 4294967294,
    AmdsmiStatusUnknownError = 4294967295,
}
impl AmdsmiClkTypeT {
    pub const AmdsmiClkTypeFirst: AmdsmiClkTypeT = AmdsmiClkTypeT::AmdsmiClkTypeSys;
}
impl AmdsmiClkTypeT {
    pub const AmdsmiClkTypeGfx: AmdsmiClkTypeT = AmdsmiClkTypeT::AmdsmiClkTypeSys;
}
impl AmdsmiClkTypeT {
    pub const AmdsmiClkTypeMax: AmdsmiClkTypeT = AmdsmiClkTypeT::AmdsmiClkTypeDclk1;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiClkTypeT {
    AmdsmiClkTypeSys = 0,
    AmdsmiClkTypeDf = 1,
    AmdsmiClkTypeDcef = 2,
    AmdsmiClkTypeSoc = 3,
    AmdsmiClkTypeMem = 4,
    AmdsmiClkTypePcie = 5,
    AmdsmiClkTypeVclk0 = 6,
    AmdsmiClkTypeVclk1 = 7,
    AmdsmiClkTypeDclk0 = 8,
    AmdsmiClkTypeDclk1 = 9,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiAcceleratorPartitionTypeT {
    AmdsmiAcceleratorPartitionInvalid = 0,
    AmdsmiAcceleratorPartitionSpx = 1,
    AmdsmiAcceleratorPartitionDpx = 2,
    AmdsmiAcceleratorPartitionTpx = 3,
    AmdsmiAcceleratorPartitionQpx = 4,
    AmdsmiAcceleratorPartitionCpx = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiComputePartitionTypeT {
    AmdsmiComputePartitionInvalid = 0,
    AmdsmiComputePartitionSpx = 1,
    AmdsmiComputePartitionDpx = 2,
    AmdsmiComputePartitionTpx = 3,
    AmdsmiComputePartitionQpx = 4,
    AmdsmiComputePartitionCpx = 5,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiMemoryPartitionTypeT {
    AmdsmiMemoryPartitionUnknown = 0,
    AmdsmiMemoryPartitionNps1 = 1,
    AmdsmiMemoryPartitionNps2 = 2,
    AmdsmiMemoryPartitionNps4 = 3,
    AmdsmiMemoryPartitionNps8 = 4,
}
impl AmdsmiTemperatureTypeT {
    pub const AmdsmiTemperatureTypeFirst: AmdsmiTemperatureTypeT =
        AmdsmiTemperatureTypeT::AmdsmiTemperatureTypeEdge;
}
impl AmdsmiTemperatureTypeT {
    pub const AmdsmiTemperatureTypeJunction: AmdsmiTemperatureTypeT =
        AmdsmiTemperatureTypeT::AmdsmiTemperatureTypeHotspot;
}
impl AmdsmiTemperatureTypeT {
    pub const AmdsmiTemperatureTypeMax: AmdsmiTemperatureTypeT =
        AmdsmiTemperatureTypeT::AmdsmiTemperatureTypePlx;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiTemperatureTypeT {
    AmdsmiTemperatureTypeEdge = 0,
    AmdsmiTemperatureTypeHotspot = 1,
    AmdsmiTemperatureTypeVram = 2,
    AmdsmiTemperatureTypeHbm0 = 3,
    AmdsmiTemperatureTypeHbm1 = 4,
    AmdsmiTemperatureTypeHbm2 = 5,
    AmdsmiTemperatureTypeHbm3 = 6,
    AmdsmiTemperatureTypePlx = 7,
}
impl AmdsmiFwBlockT {
    pub const AmdsmiFwIdFirst: AmdsmiFwBlockT = AmdsmiFwBlockT::AmdsmiFwIdSmu;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiFwBlockT {
    AmdsmiFwIdSmu = 1,
    AmdsmiFwIdCpCe = 2,
    AmdsmiFwIdCpPfp = 3,
    AmdsmiFwIdCpMe = 4,
    AmdsmiFwIdCpMecJt1 = 5,
    AmdsmiFwIdCpMecJt2 = 6,
    AmdsmiFwIdCpMec1 = 7,
    AmdsmiFwIdCpMec2 = 8,
    AmdsmiFwIdRlc = 9,
    AmdsmiFwIdSdma0 = 10,
    AmdsmiFwIdSdma1 = 11,
    AmdsmiFwIdSdma2 = 12,
    AmdsmiFwIdSdma3 = 13,
    AmdsmiFwIdSdma4 = 14,
    AmdsmiFwIdSdma5 = 15,
    AmdsmiFwIdSdma6 = 16,
    AmdsmiFwIdSdma7 = 17,
    AmdsmiFwIdVcn = 18,
    AmdsmiFwIdUvd = 19,
    AmdsmiFwIdVce = 20,
    AmdsmiFwIdIsp = 21,
    AmdsmiFwIdDmcuEram = 22,
    AmdsmiFwIdDmcuIsr = 23,
    AmdsmiFwIdRlcRestoreListGpmMem = 24,
    AmdsmiFwIdRlcRestoreListSrmMem = 25,
    AmdsmiFwIdRlcRestoreListCntl = 26,
    AmdsmiFwIdRlcV = 27,
    AmdsmiFwIdMmsch = 28,
    AmdsmiFwIdPspSysdrv = 29,
    AmdsmiFwIdPspSosdrv = 30,
    AmdsmiFwIdPspToc = 31,
    AmdsmiFwIdPspKeydb = 32,
    AmdsmiFwIdDfc = 33,
    AmdsmiFwIdPspSpl = 34,
    AmdsmiFwIdDrvCap = 35,
    AmdsmiFwIdMc = 36,
    AmdsmiFwIdPspBl = 37,
    AmdsmiFwIdCpPm4 = 38,
    AmdsmiFwIdRlcP = 39,
    AmdsmiFwIdSecPolicyStage2 = 40,
    AmdsmiFwIdRegAccessWhitelist = 41,
    AmdsmiFwIdImuDram = 42,
    AmdsmiFwIdImuIram = 43,
    AmdsmiFwIdSdmaTh0 = 44,
    AmdsmiFwIdSdmaTh1 = 45,
    AmdsmiFwIdCpMes = 46,
    AmdsmiFwIdMesKiq = 47,
    AmdsmiFwIdMesStack = 48,
    AmdsmiFwIdMesThread1 = 49,
    AmdsmiFwIdMesThread1Stack = 50,
    AmdsmiFwIdRlx6 = 51,
    AmdsmiFwIdRlx6DramBoot = 52,
    AmdsmiFwIdRs64Me = 53,
    AmdsmiFwIdRs64MeP0Data = 54,
    AmdsmiFwIdRs64MeP1Data = 55,
    AmdsmiFwIdRs64Pfp = 56,
    AmdsmiFwIdRs64PfpP0Data = 57,
    AmdsmiFwIdRs64PfpP1Data = 58,
    AmdsmiFwIdRs64Mec = 59,
    AmdsmiFwIdRs64MecP0Data = 60,
    AmdsmiFwIdRs64MecP1Data = 61,
    AmdsmiFwIdRs64MecP2Data = 62,
    AmdsmiFwIdRs64MecP3Data = 63,
    AmdsmiFwIdPptable = 64,
    AmdsmiFwIdPspSoc = 65,
    AmdsmiFwIdPspDbg = 66,
    AmdsmiFwIdPspIntf = 67,
    AmdsmiFwIdRlx6Core1 = 68,
    AmdsmiFwIdRlx6DramBootCore1 = 69,
    AmdsmiFwIdRlcvLx7 = 70,
    AmdsmiFwIdRlcSaveRestoreList = 71,
    AmdsmiFwIdAsd = 72,
    AmdsmiFwIdTaRas = 73,
    AmdsmiFwIdTaXgmi = 74,
    AmdsmiFwIdRlcSrlg = 75,
    AmdsmiFwIdRlcSrls = 76,
    AmdsmiFwIdPm = 77,
    AmdsmiFwIdDmcu = 78,
    AmdsmiFwIdMax = 79,
}
impl AmdsmiVramTypeT {
    pub const AmdsmiVramTypeMax: AmdsmiVramTypeT = AmdsmiVramTypeT::AmdsmiVramTypeGddr7;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiVramTypeT {
    AmdsmiVramTypeUnknown = 0,
    AmdsmiVramTypeHbm = 1,
    AmdsmiVramTypeHbm2 = 2,
    AmdsmiVramTypeHbm2e = 3,
    AmdsmiVramTypeHbm3 = 4,
    AmdsmiVramTypeDdr2 = 10,
    AmdsmiVramTypeDdr3 = 11,
    AmdsmiVramTypeDdr4 = 12,
    AmdsmiVramTypeGddr1 = 17,
    AmdsmiVramTypeGddr2 = 18,
    AmdsmiVramTypeGddr3 = 19,
    AmdsmiVramTypeGddr4 = 20,
    AmdsmiVramTypeGddr5 = 21,
    AmdsmiVramTypeGddr6 = 22,
    AmdsmiVramTypeGddr7 = 23,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiVramVendorTypeT {
    AmdsmiVramVendorPlaceholder0 = 0,
    AmdsmiVramVendorSamsung = 1,
    AmdsmiVramVendorInfineon = 2,
    AmdsmiVramVendorElpida = 3,
    AmdsmiVramVendorEtron = 4,
    AmdsmiVramVendorNanya = 5,
    AmdsmiVramVendorHynix = 6,
    AmdsmiVramVendorMosel = 7,
    AmdsmiVramVendorWinbond = 8,
    AmdsmiVramVendorEsmt = 9,
    AmdsmiVramVendorPlaceholder1 = 10,
    AmdsmiVramVendorPlaceholder2 = 11,
    AmdsmiVramVendorPlaceholder3 = 12,
    AmdsmiVramVendorPlaceholder4 = 13,
    AmdsmiVramVendorPlaceholder5 = 14,
    AmdsmiVramVendorMicron = 15,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiRangeT {
    pub lower_bound: u64,
    pub upper_bound: u64,
    pub reserved: [u64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiRangeT"][::std::mem::size_of::<AmdsmiRangeT>() - 32usize];
    ["Alignment of AmdsmiRangeT"][::std::mem::align_of::<AmdsmiRangeT>() - 8usize];
    ["Offset of field: AmdsmiRangeT::lower_bound"]
        [::std::mem::offset_of!(AmdsmiRangeT, lower_bound) - 0usize];
    ["Offset of field: AmdsmiRangeT::upper_bound"]
        [::std::mem::offset_of!(AmdsmiRangeT, upper_bound) - 8usize];
    ["Offset of field: AmdsmiRangeT::reserved"]
        [::std::mem::offset_of!(AmdsmiRangeT, reserved) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiXgmiInfoT {
    pub xgmi_lanes: u8,
    pub xgmi_hive_id: u64,
    pub xgmi_node_id: u64,
    pub index: u32,
    pub reserved: [u32; 9usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiXgmiInfoT"][::std::mem::size_of::<AmdsmiXgmiInfoT>() - 64usize];
    ["Alignment of AmdsmiXgmiInfoT"][::std::mem::align_of::<AmdsmiXgmiInfoT>() - 8usize];
    ["Offset of field: AmdsmiXgmiInfoT::xgmi_lanes"]
        [::std::mem::offset_of!(AmdsmiXgmiInfoT, xgmi_lanes) - 0usize];
    ["Offset of field: AmdsmiXgmiInfoT::xgmi_hive_id"]
        [::std::mem::offset_of!(AmdsmiXgmiInfoT, xgmi_hive_id) - 8usize];
    ["Offset of field: AmdsmiXgmiInfoT::xgmi_node_id"]
        [::std::mem::offset_of!(AmdsmiXgmiInfoT, xgmi_node_id) - 16usize];
    ["Offset of field: AmdsmiXgmiInfoT::index"]
        [::std::mem::offset_of!(AmdsmiXgmiInfoT, index) - 24usize];
    ["Offset of field: AmdsmiXgmiInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiXgmiInfoT, reserved) - 28usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiVramUsageT {
    pub vram_total: u32,
    pub vram_used: u32,
    pub reserved: [u32; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiVramUsageT"][::std::mem::size_of::<AmdsmiVramUsageT>() - 16usize];
    ["Alignment of AmdsmiVramUsageT"][::std::mem::align_of::<AmdsmiVramUsageT>() - 4usize];
    ["Offset of field: AmdsmiVramUsageT::vram_total"]
        [::std::mem::offset_of!(AmdsmiVramUsageT, vram_total) - 0usize];
    ["Offset of field: AmdsmiVramUsageT::vram_used"]
        [::std::mem::offset_of!(AmdsmiVramUsageT, vram_used) - 4usize];
    ["Offset of field: AmdsmiVramUsageT::reserved"]
        [::std::mem::offset_of!(AmdsmiVramUsageT, reserved) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiViolationStatusT {
    pub reference_timestamp: u64,
    pub violation_timestamp: u64,
    pub acc_counter: u64,
    pub acc_prochot_thrm: u64,
    pub acc_ppt_pwr: u64,
    pub acc_socket_thrm: u64,
    pub acc_vr_thrm: u64,
    pub acc_hbm_thrm: u64,
    pub per_prochot_thrm: u64,
    pub per_ppt_pwr: u64,
    pub per_socket_thrm: u64,
    pub per_vr_thrm: u64,
    pub per_hbm_thrm: u64,
    pub active_prochot_thrm: u8,
    pub active_ppt_pwr: u8,
    pub active_socket_thrm: u8,
    pub active_vr_thrm: u8,
    pub active_hbm_thrm: u8,
    pub reserved: [u64; 30usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiViolationStatusT"][::std::mem::size_of::<AmdsmiViolationStatusT>() - 352usize];
    ["Alignment of AmdsmiViolationStatusT"]
        [::std::mem::align_of::<AmdsmiViolationStatusT>() - 8usize];
    ["Offset of field: AmdsmiViolationStatusT::reference_timestamp"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, reference_timestamp) - 0usize];
    ["Offset of field: AmdsmiViolationStatusT::violation_timestamp"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, violation_timestamp) - 8usize];
    ["Offset of field: AmdsmiViolationStatusT::acc_counter"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, acc_counter) - 16usize];
    ["Offset of field: AmdsmiViolationStatusT::acc_prochot_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, acc_prochot_thrm) - 24usize];
    ["Offset of field: AmdsmiViolationStatusT::acc_ppt_pwr"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, acc_ppt_pwr) - 32usize];
    ["Offset of field: AmdsmiViolationStatusT::acc_socket_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, acc_socket_thrm) - 40usize];
    ["Offset of field: AmdsmiViolationStatusT::acc_vr_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, acc_vr_thrm) - 48usize];
    ["Offset of field: AmdsmiViolationStatusT::acc_hbm_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, acc_hbm_thrm) - 56usize];
    ["Offset of field: AmdsmiViolationStatusT::per_prochot_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, per_prochot_thrm) - 64usize];
    ["Offset of field: AmdsmiViolationStatusT::per_ppt_pwr"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, per_ppt_pwr) - 72usize];
    ["Offset of field: AmdsmiViolationStatusT::per_socket_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, per_socket_thrm) - 80usize];
    ["Offset of field: AmdsmiViolationStatusT::per_vr_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, per_vr_thrm) - 88usize];
    ["Offset of field: AmdsmiViolationStatusT::per_hbm_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, per_hbm_thrm) - 96usize];
    ["Offset of field: AmdsmiViolationStatusT::active_prochot_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, active_prochot_thrm) - 104usize];
    ["Offset of field: AmdsmiViolationStatusT::active_ppt_pwr"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, active_ppt_pwr) - 105usize];
    ["Offset of field: AmdsmiViolationStatusT::active_socket_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, active_socket_thrm) - 106usize];
    ["Offset of field: AmdsmiViolationStatusT::active_vr_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, active_vr_thrm) - 107usize];
    ["Offset of field: AmdsmiViolationStatusT::active_hbm_thrm"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, active_hbm_thrm) - 108usize];
    ["Offset of field: AmdsmiViolationStatusT::reserved"]
        [::std::mem::offset_of!(AmdsmiViolationStatusT, reserved) - 112usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiFrequencyRangeT {
    pub supported_freq_range: AmdsmiRangeT,
    pub current_freq_range: AmdsmiRangeT,
    pub reserved: [u32; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiFrequencyRangeT"][::std::mem::size_of::<AmdsmiFrequencyRangeT>() - 96usize];
    ["Alignment of AmdsmiFrequencyRangeT"]
        [::std::mem::align_of::<AmdsmiFrequencyRangeT>() - 8usize];
    ["Offset of field: AmdsmiFrequencyRangeT::supported_freq_range"]
        [::std::mem::offset_of!(AmdsmiFrequencyRangeT, supported_freq_range) - 0usize];
    ["Offset of field: AmdsmiFrequencyRangeT::current_freq_range"]
        [::std::mem::offset_of!(AmdsmiFrequencyRangeT, current_freq_range) - 32usize];
    ["Offset of field: AmdsmiFrequencyRangeT::reserved"]
        [::std::mem::offset_of!(AmdsmiFrequencyRangeT, reserved) - 64usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union AmdsmiBdfT {
    pub __bindgen_anon_1: AmdsmiBdfTBindgenTy1,
    pub as_uint: u64,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiBdfTBindgenTy1 {
    pub _bitfield_align_1: [u64; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 8usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiBdfTBindgenTy1"][::std::mem::size_of::<AmdsmiBdfTBindgenTy1>() - 8usize];
    ["Alignment of AmdsmiBdfTBindgenTy1"][::std::mem::align_of::<AmdsmiBdfTBindgenTy1>() - 8usize];
};
impl AmdsmiBdfTBindgenTy1 {
    #[inline]
    pub fn function_number(&self) -> u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 3u8) as u64) }
    }
    #[inline]
    pub fn set_function_number(&mut self, val: u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 3u8, val as u64)
        }
    }
    #[inline]
    pub fn device_number(&self) -> u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 5u8) as u64) }
    }
    #[inline]
    pub fn set_device_number(&mut self, val: u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 5u8, val as u64)
        }
    }
    #[inline]
    pub fn bus_number(&self) -> u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(8usize, 8u8) as u64) }
    }
    #[inline]
    pub fn set_bus_number(&mut self, val: u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(8usize, 8u8, val as u64)
        }
    }
    #[inline]
    pub fn domain_number(&self) -> u64 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(16usize, 48u8) as u64) }
    }
    #[inline]
    pub fn set_domain_number(&mut self, val: u64) {
        unsafe {
            let val: u64 = ::std::mem::transmute(val);
            self._bitfield_1.set(16usize, 48u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        function_number: u64,
        device_number: u64,
        bus_number: u64,
        domain_number: u64,
    ) -> __BindgenBitfieldUnit<[u8; 8usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 8usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 3u8, {
            let function_number: u64 = unsafe { ::std::mem::transmute(function_number) };
            function_number as u64
        });
        __bindgen_bitfield_unit.set(3usize, 5u8, {
            let device_number: u64 = unsafe { ::std::mem::transmute(device_number) };
            device_number as u64
        });
        __bindgen_bitfield_unit.set(8usize, 8u8, {
            let bus_number: u64 = unsafe { ::std::mem::transmute(bus_number) };
            bus_number as u64
        });
        __bindgen_bitfield_unit.set(16usize, 48u8, {
            let domain_number: u64 = unsafe { ::std::mem::transmute(domain_number) };
            domain_number as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiBdfT"][::std::mem::size_of::<AmdsmiBdfT>() - 8usize];
    ["Alignment of AmdsmiBdfT"][::std::mem::align_of::<AmdsmiBdfT>() - 8usize];
    ["Offset of field: AmdsmiBdfT::as_uint"][::std::mem::offset_of!(AmdsmiBdfT, as_uint) - 0usize];
};
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiCardFormFactorT {
    AmdsmiCardFormFactorPcie = 0,
    AmdsmiCardFormFactorOam = 1,
    AmdsmiCardFormFactorCem = 2,
    AmdsmiCardFormFactorUnknown = 3,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiPcieInfoT {
    pub pcie_static: AmdsmiPcieInfoTPcieStatic,
    pub pcie_metric: AmdsmiPcieInfoTPcieMetric,
    pub reserved: [u64; 32usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiPcieInfoTPcieStatic {
    pub max_pcie_width: u16,
    pub max_pcie_speed: u32,
    pub pcie_interface_version: u32,
    pub slot_type: AmdsmiCardFormFactorT,
    pub reserved: [u64; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiPcieInfoTPcieStatic"]
        [::std::mem::size_of::<AmdsmiPcieInfoTPcieStatic>() - 96usize];
    ["Alignment of AmdsmiPcieInfoTPcieStatic"]
        [::std::mem::align_of::<AmdsmiPcieInfoTPcieStatic>() - 8usize];
    ["Offset of field: AmdsmiPcieInfoTPcieStatic::max_pcie_width"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieStatic, max_pcie_width) - 0usize];
    ["Offset of field: AmdsmiPcieInfoTPcieStatic::max_pcie_speed"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieStatic, max_pcie_speed) - 4usize];
    ["Offset of field: AmdsmiPcieInfoTPcieStatic::pcie_interface_version"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieStatic, pcie_interface_version) - 8usize];
    ["Offset of field: AmdsmiPcieInfoTPcieStatic::slot_type"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieStatic, slot_type) - 12usize];
    ["Offset of field: AmdsmiPcieInfoTPcieStatic::reserved"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieStatic, reserved) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiPcieInfoTPcieMetric {
    pub pcie_width: u16,
    pub pcie_speed: u32,
    pub pcie_bandwidth: u32,
    pub pcie_replay_count: u64,
    pub pcie_l0_to_recovery_count: u64,
    pub pcie_replay_roll_over_count: u64,
    pub pcie_nak_sent_count: u64,
    pub pcie_nak_received_count: u64,
    pub pcie_lc_perf_other_end_recovery_count: u32,
    pub reserved: [u64; 12usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiPcieInfoTPcieMetric"]
        [::std::mem::size_of::<AmdsmiPcieInfoTPcieMetric>() - 160usize];
    ["Alignment of AmdsmiPcieInfoTPcieMetric"]
        [::std::mem::align_of::<AmdsmiPcieInfoTPcieMetric>() - 8usize];
    ["Offset of field: AmdsmiPcieInfoTPcieMetric::pcie_width"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieMetric, pcie_width) - 0usize];
    ["Offset of field: AmdsmiPcieInfoTPcieMetric::pcie_speed"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieMetric, pcie_speed) - 4usize];
    ["Offset of field: AmdsmiPcieInfoTPcieMetric::pcie_bandwidth"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieMetric, pcie_bandwidth) - 8usize];
    ["Offset of field: AmdsmiPcieInfoTPcieMetric::pcie_replay_count"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieMetric, pcie_replay_count) - 16usize];
    ["Offset of field: AmdsmiPcieInfoTPcieMetric::pcie_l0_to_recovery_count"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieMetric, pcie_l0_to_recovery_count) - 24usize];
    ["Offset of field: AmdsmiPcieInfoTPcieMetric::pcie_replay_roll_over_count"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieMetric, pcie_replay_roll_over_count) - 32usize];
    ["Offset of field: AmdsmiPcieInfoTPcieMetric::pcie_nak_sent_count"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieMetric, pcie_nak_sent_count) - 40usize];
    ["Offset of field: AmdsmiPcieInfoTPcieMetric::pcie_nak_received_count"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieMetric, pcie_nak_received_count) - 48usize];
    ["Offset of field: AmdsmiPcieInfoTPcieMetric::pcie_lc_perf_other_end_recovery_count"][::std::mem::offset_of!(
        AmdsmiPcieInfoTPcieMetric,
        pcie_lc_perf_other_end_recovery_count
    )
        - 56usize];
    ["Offset of field: AmdsmiPcieInfoTPcieMetric::reserved"]
        [::std::mem::offset_of!(AmdsmiPcieInfoTPcieMetric, reserved) - 64usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiPcieInfoT"][::std::mem::size_of::<AmdsmiPcieInfoT>() - 512usize];
    ["Alignment of AmdsmiPcieInfoT"][::std::mem::align_of::<AmdsmiPcieInfoT>() - 8usize];
    ["Offset of field: AmdsmiPcieInfoT::pcie_static"]
        [::std::mem::offset_of!(AmdsmiPcieInfoT, pcie_static) - 0usize];
    ["Offset of field: AmdsmiPcieInfoT::pcie_metric"]
        [::std::mem::offset_of!(AmdsmiPcieInfoT, pcie_metric) - 96usize];
    ["Offset of field: AmdsmiPcieInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiPcieInfoT, reserved) - 256usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiPowerCapInfoT {
    pub power_cap: u64,
    pub default_power_cap: u64,
    pub dpm_cap: u64,
    pub min_power_cap: u64,
    pub max_power_cap: u64,
    pub reserved: [u64; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiPowerCapInfoT"][::std::mem::size_of::<AmdsmiPowerCapInfoT>() - 64usize];
    ["Alignment of AmdsmiPowerCapInfoT"][::std::mem::align_of::<AmdsmiPowerCapInfoT>() - 8usize];
    ["Offset of field: AmdsmiPowerCapInfoT::power_cap"]
        [::std::mem::offset_of!(AmdsmiPowerCapInfoT, power_cap) - 0usize];
    ["Offset of field: AmdsmiPowerCapInfoT::default_power_cap"]
        [::std::mem::offset_of!(AmdsmiPowerCapInfoT, default_power_cap) - 8usize];
    ["Offset of field: AmdsmiPowerCapInfoT::dpm_cap"]
        [::std::mem::offset_of!(AmdsmiPowerCapInfoT, dpm_cap) - 16usize];
    ["Offset of field: AmdsmiPowerCapInfoT::min_power_cap"]
        [::std::mem::offset_of!(AmdsmiPowerCapInfoT, min_power_cap) - 24usize];
    ["Offset of field: AmdsmiPowerCapInfoT::max_power_cap"]
        [::std::mem::offset_of!(AmdsmiPowerCapInfoT, max_power_cap) - 32usize];
    ["Offset of field: AmdsmiPowerCapInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiPowerCapInfoT, reserved) - 40usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiVbiosInfoT {
    pub name: [::std::os::raw::c_char; 256usize],
    pub build_date: [::std::os::raw::c_char; 256usize],
    pub part_number: [::std::os::raw::c_char; 256usize],
    pub version: [::std::os::raw::c_char; 256usize],
    pub reserved: [u64; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiVbiosInfoT"][::std::mem::size_of::<AmdsmiVbiosInfoT>() - 1056usize];
    ["Alignment of AmdsmiVbiosInfoT"][::std::mem::align_of::<AmdsmiVbiosInfoT>() - 8usize];
    ["Offset of field: AmdsmiVbiosInfoT::name"]
        [::std::mem::offset_of!(AmdsmiVbiosInfoT, name) - 0usize];
    ["Offset of field: AmdsmiVbiosInfoT::build_date"]
        [::std::mem::offset_of!(AmdsmiVbiosInfoT, build_date) - 256usize];
    ["Offset of field: AmdsmiVbiosInfoT::part_number"]
        [::std::mem::offset_of!(AmdsmiVbiosInfoT, part_number) - 512usize];
    ["Offset of field: AmdsmiVbiosInfoT::version"]
        [::std::mem::offset_of!(AmdsmiVbiosInfoT, version) - 768usize];
    ["Offset of field: AmdsmiVbiosInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiVbiosInfoT, reserved) - 1024usize];
};
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiCachePropertyTypeT {
    AmdsmiCachePropertyEnabled = 1,
    AmdsmiCachePropertyDataCache = 2,
    AmdsmiCachePropertyInstCache = 4,
    AmdsmiCachePropertyCpuCache = 8,
    AmdsmiCachePropertySimdCache = 16,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiGpuCacheInfoT {
    pub num_cache_types: u32,
    pub cache: [AmdsmiGpuCacheInfoTCache; 10usize],
    pub reserved: [u32; 15usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiGpuCacheInfoTCache {
    pub cache_properties: u32,
    pub cache_size: u32,
    pub cache_level: u32,
    pub max_num_cu_shared: u32,
    pub num_cache_instance: u32,
    pub reserved: [u32; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiGpuCacheInfoTCache"]
        [::std::mem::size_of::<AmdsmiGpuCacheInfoTCache>() - 32usize];
    ["Alignment of AmdsmiGpuCacheInfoTCache"]
        [::std::mem::align_of::<AmdsmiGpuCacheInfoTCache>() - 4usize];
    ["Offset of field: AmdsmiGpuCacheInfoTCache::cache_properties"]
        [::std::mem::offset_of!(AmdsmiGpuCacheInfoTCache, cache_properties) - 0usize];
    ["Offset of field: AmdsmiGpuCacheInfoTCache::cache_size"]
        [::std::mem::offset_of!(AmdsmiGpuCacheInfoTCache, cache_size) - 4usize];
    ["Offset of field: AmdsmiGpuCacheInfoTCache::cache_level"]
        [::std::mem::offset_of!(AmdsmiGpuCacheInfoTCache, cache_level) - 8usize];
    ["Offset of field: AmdsmiGpuCacheInfoTCache::max_num_cu_shared"]
        [::std::mem::offset_of!(AmdsmiGpuCacheInfoTCache, max_num_cu_shared) - 12usize];
    ["Offset of field: AmdsmiGpuCacheInfoTCache::num_cache_instance"]
        [::std::mem::offset_of!(AmdsmiGpuCacheInfoTCache, num_cache_instance) - 16usize];
    ["Offset of field: AmdsmiGpuCacheInfoTCache::reserved"]
        [::std::mem::offset_of!(AmdsmiGpuCacheInfoTCache, reserved) - 20usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiGpuCacheInfoT"][::std::mem::size_of::<AmdsmiGpuCacheInfoT>() - 384usize];
    ["Alignment of AmdsmiGpuCacheInfoT"][::std::mem::align_of::<AmdsmiGpuCacheInfoT>() - 4usize];
    ["Offset of field: AmdsmiGpuCacheInfoT::num_cache_types"]
        [::std::mem::offset_of!(AmdsmiGpuCacheInfoT, num_cache_types) - 0usize];
    ["Offset of field: AmdsmiGpuCacheInfoT::cache"]
        [::std::mem::offset_of!(AmdsmiGpuCacheInfoT, cache) - 4usize];
    ["Offset of field: AmdsmiGpuCacheInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiGpuCacheInfoT, reserved) - 324usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiFwInfoT {
    pub num_fw_info: u8,
    pub fw_info_list: [AmdsmiFwInfoTFwInfoList; 79usize],
    pub reserved: [u32; 7usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiFwInfoTFwInfoList {
    pub fw_id: AmdsmiFwBlockT,
    pub fw_version: u64,
    pub reserved: [u64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiFwInfoTFwInfoList"][::std::mem::size_of::<AmdsmiFwInfoTFwInfoList>() - 32usize];
    ["Alignment of AmdsmiFwInfoTFwInfoList"]
        [::std::mem::align_of::<AmdsmiFwInfoTFwInfoList>() - 8usize];
    ["Offset of field: AmdsmiFwInfoTFwInfoList::fw_id"]
        [::std::mem::offset_of!(AmdsmiFwInfoTFwInfoList, fw_id) - 0usize];
    ["Offset of field: AmdsmiFwInfoTFwInfoList::fw_version"]
        [::std::mem::offset_of!(AmdsmiFwInfoTFwInfoList, fw_version) - 8usize];
    ["Offset of field: AmdsmiFwInfoTFwInfoList::reserved"]
        [::std::mem::offset_of!(AmdsmiFwInfoTFwInfoList, reserved) - 16usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiFwInfoT"][::std::mem::size_of::<AmdsmiFwInfoT>() - 2568usize];
    ["Alignment of AmdsmiFwInfoT"][::std::mem::align_of::<AmdsmiFwInfoT>() - 8usize];
    ["Offset of field: AmdsmiFwInfoT::num_fw_info"]
        [::std::mem::offset_of!(AmdsmiFwInfoT, num_fw_info) - 0usize];
    ["Offset of field: AmdsmiFwInfoT::fw_info_list"]
        [::std::mem::offset_of!(AmdsmiFwInfoT, fw_info_list) - 8usize];
    ["Offset of field: AmdsmiFwInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiFwInfoT, reserved) - 2536usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiAsicInfoT {
    pub market_name: [::std::os::raw::c_char; 256usize],
    pub vendor_id: u32,
    pub vendor_name: [::std::os::raw::c_char; 256usize],
    pub subvendor_id: u32,
    pub device_id: u64,
    pub rev_id: u32,
    pub asic_serial: [::std::os::raw::c_char; 256usize],
    pub oam_id: u32,
    pub num_of_compute_units: u32,
    pub target_graphics_version: u64,
    pub subsystem_id: u32,
    pub reserved: [u32; 21usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiAsicInfoT"][::std::mem::size_of::<AmdsmiAsicInfoT>() - 896usize];
    ["Alignment of AmdsmiAsicInfoT"][::std::mem::align_of::<AmdsmiAsicInfoT>() - 8usize];
    ["Offset of field: AmdsmiAsicInfoT::market_name"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, market_name) - 0usize];
    ["Offset of field: AmdsmiAsicInfoT::vendor_id"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, vendor_id) - 256usize];
    ["Offset of field: AmdsmiAsicInfoT::vendor_name"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, vendor_name) - 260usize];
    ["Offset of field: AmdsmiAsicInfoT::subvendor_id"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, subvendor_id) - 516usize];
    ["Offset of field: AmdsmiAsicInfoT::device_id"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, device_id) - 520usize];
    ["Offset of field: AmdsmiAsicInfoT::rev_id"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, rev_id) - 528usize];
    ["Offset of field: AmdsmiAsicInfoT::asic_serial"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, asic_serial) - 532usize];
    ["Offset of field: AmdsmiAsicInfoT::oam_id"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, oam_id) - 788usize];
    ["Offset of field: AmdsmiAsicInfoT::num_of_compute_units"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, num_of_compute_units) - 792usize];
    ["Offset of field: AmdsmiAsicInfoT::target_graphics_version"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, target_graphics_version) - 800usize];
    ["Offset of field: AmdsmiAsicInfoT::subsystem_id"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, subsystem_id) - 808usize];
    ["Offset of field: AmdsmiAsicInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiAsicInfoT, reserved) - 812usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiKfdInfoT {
    pub kfd_id: u64,
    pub node_id: u32,
    pub current_partition_id: u32,
    pub reserved: [u32; 12usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiKfdInfoT"][::std::mem::size_of::<AmdsmiKfdInfoT>() - 64usize];
    ["Alignment of AmdsmiKfdInfoT"][::std::mem::align_of::<AmdsmiKfdInfoT>() - 8usize];
    ["Offset of field: AmdsmiKfdInfoT::kfd_id"]
        [::std::mem::offset_of!(AmdsmiKfdInfoT, kfd_id) - 0usize];
    ["Offset of field: AmdsmiKfdInfoT::node_id"]
        [::std::mem::offset_of!(AmdsmiKfdInfoT, node_id) - 8usize];
    ["Offset of field: AmdsmiKfdInfoT::current_partition_id"]
        [::std::mem::offset_of!(AmdsmiKfdInfoT, current_partition_id) - 12usize];
    ["Offset of field: AmdsmiKfdInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiKfdInfoT, reserved) - 16usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub union AmdsmiNpsCapsT {
    pub nps_flags: AmdsmiNpsCapsTNpsFlags,
    pub nps_cap_mask: u32,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiNpsCapsTNpsFlags {
    pub _bitfield_align_1: [u32; 0],
    pub _bitfield_1: __BindgenBitfieldUnit<[u8; 4usize]>,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiNpsCapsTNpsFlags"][::std::mem::size_of::<AmdsmiNpsCapsTNpsFlags>() - 4usize];
    ["Alignment of AmdsmiNpsCapsTNpsFlags"]
        [::std::mem::align_of::<AmdsmiNpsCapsTNpsFlags>() - 4usize];
};
impl AmdsmiNpsCapsTNpsFlags {
    #[inline]
    pub fn nps1_cap(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(0usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nps1_cap(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(0usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nps2_cap(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(1usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nps2_cap(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(1usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nps4_cap(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(2usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nps4_cap(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(2usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn nps8_cap(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(3usize, 1u8) as u32) }
    }
    #[inline]
    pub fn set_nps8_cap(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(3usize, 1u8, val as u64)
        }
    }
    #[inline]
    pub fn reserved(&self) -> u32 {
        unsafe { ::std::mem::transmute(self._bitfield_1.get(4usize, 28u8) as u32) }
    }
    #[inline]
    pub fn set_reserved(&mut self, val: u32) {
        unsafe {
            let val: u32 = ::std::mem::transmute(val);
            self._bitfield_1.set(4usize, 28u8, val as u64)
        }
    }
    #[inline]
    pub fn new_bitfield_1(
        nps1_cap: u32,
        nps2_cap: u32,
        nps4_cap: u32,
        nps8_cap: u32,
        reserved: u32,
    ) -> __BindgenBitfieldUnit<[u8; 4usize]> {
        let mut __bindgen_bitfield_unit: __BindgenBitfieldUnit<[u8; 4usize]> = Default::default();
        __bindgen_bitfield_unit.set(0usize, 1u8, {
            let nps1_cap: u32 = unsafe { ::std::mem::transmute(nps1_cap) };
            nps1_cap as u64
        });
        __bindgen_bitfield_unit.set(1usize, 1u8, {
            let nps2_cap: u32 = unsafe { ::std::mem::transmute(nps2_cap) };
            nps2_cap as u64
        });
        __bindgen_bitfield_unit.set(2usize, 1u8, {
            let nps4_cap: u32 = unsafe { ::std::mem::transmute(nps4_cap) };
            nps4_cap as u64
        });
        __bindgen_bitfield_unit.set(3usize, 1u8, {
            let nps8_cap: u32 = unsafe { ::std::mem::transmute(nps8_cap) };
            nps8_cap as u64
        });
        __bindgen_bitfield_unit.set(4usize, 28u8, {
            let reserved: u32 = unsafe { ::std::mem::transmute(reserved) };
            reserved as u64
        });
        __bindgen_bitfield_unit
    }
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiNpsCapsT"][::std::mem::size_of::<AmdsmiNpsCapsT>() - 4usize];
    ["Alignment of AmdsmiNpsCapsT"][::std::mem::align_of::<AmdsmiNpsCapsT>() - 4usize];
    ["Offset of field: AmdsmiNpsCapsT::nps_flags"]
        [::std::mem::offset_of!(AmdsmiNpsCapsT, nps_flags) - 0usize];
    ["Offset of field: AmdsmiNpsCapsT::nps_cap_mask"]
        [::std::mem::offset_of!(AmdsmiNpsCapsT, nps_cap_mask) - 0usize];
};
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AmdsmiAcceleratorPartitionProfileT {
    pub profile_type: AmdsmiAcceleratorPartitionTypeT,
    pub num_partitions: u32,
    pub memory_caps: AmdsmiNpsCapsT,
    pub profile_index: u32,
    pub num_resources: u32,
    pub resources: [[u32; 32usize]; 8usize],
    pub reserved: [u64; 13usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiAcceleratorPartitionProfileT"]
        [::std::mem::size_of::<AmdsmiAcceleratorPartitionProfileT>() - 1152usize];
    ["Alignment of AmdsmiAcceleratorPartitionProfileT"]
        [::std::mem::align_of::<AmdsmiAcceleratorPartitionProfileT>() - 8usize];
    ["Offset of field: AmdsmiAcceleratorPartitionProfileT::profile_type"]
        [::std::mem::offset_of!(AmdsmiAcceleratorPartitionProfileT, profile_type) - 0usize];
    ["Offset of field: AmdsmiAcceleratorPartitionProfileT::num_partitions"]
        [::std::mem::offset_of!(AmdsmiAcceleratorPartitionProfileT, num_partitions) - 4usize];
    ["Offset of field: AmdsmiAcceleratorPartitionProfileT::memory_caps"]
        [::std::mem::offset_of!(AmdsmiAcceleratorPartitionProfileT, memory_caps) - 8usize];
    ["Offset of field: AmdsmiAcceleratorPartitionProfileT::profile_index"]
        [::std::mem::offset_of!(AmdsmiAcceleratorPartitionProfileT, profile_index) - 12usize];
    ["Offset of field: AmdsmiAcceleratorPartitionProfileT::num_resources"]
        [::std::mem::offset_of!(AmdsmiAcceleratorPartitionProfileT, num_resources) - 16usize];
    ["Offset of field: AmdsmiAcceleratorPartitionProfileT::resources"]
        [::std::mem::offset_of!(AmdsmiAcceleratorPartitionProfileT, resources) - 20usize];
    ["Offset of field: AmdsmiAcceleratorPartitionProfileT::reserved"]
        [::std::mem::offset_of!(AmdsmiAcceleratorPartitionProfileT, reserved) - 1048usize];
};
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiLinkTypeT {
    AmdsmiLinkTypeInternal = 0,
    AmdsmiLinkTypeXgmi = 1,
    AmdsmiLinkTypePcie = 2,
    AmdsmiLinkTypeNotApplicable = 3,
    AmdsmiLinkTypeUnknown = 4,
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AmdsmiLinkMetricsT {
    pub num_links: u32,
    pub links: [AmdsmiLinkMetricsTLinks; 64usize],
    pub reserved: [u64; 7usize],
}
#[repr(C)]
#[derive(Copy, Clone)]
pub struct AmdsmiLinkMetricsTLinks {
    pub bdf: AmdsmiBdfT,
    pub bit_rate: u32,
    pub max_bandwidth: u32,
    pub link_type: AmdsmiLinkTypeT,
    pub read: u64,
    pub write: u64,
    pub reserved: [u64; 2usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiLinkMetricsTLinks"][::std::mem::size_of::<AmdsmiLinkMetricsTLinks>() - 56usize];
    ["Alignment of AmdsmiLinkMetricsTLinks"]
        [::std::mem::align_of::<AmdsmiLinkMetricsTLinks>() - 8usize];
    ["Offset of field: AmdsmiLinkMetricsTLinks::bdf"]
        [::std::mem::offset_of!(AmdsmiLinkMetricsTLinks, bdf) - 0usize];
    ["Offset of field: AmdsmiLinkMetricsTLinks::bit_rate"]
        [::std::mem::offset_of!(AmdsmiLinkMetricsTLinks, bit_rate) - 8usize];
    ["Offset of field: AmdsmiLinkMetricsTLinks::max_bandwidth"]
        [::std::mem::offset_of!(AmdsmiLinkMetricsTLinks, max_bandwidth) - 12usize];
    ["Offset of field: AmdsmiLinkMetricsTLinks::link_type"]
        [::std::mem::offset_of!(AmdsmiLinkMetricsTLinks, link_type) - 16usize];
    ["Offset of field: AmdsmiLinkMetricsTLinks::read"]
        [::std::mem::offset_of!(AmdsmiLinkMetricsTLinks, read) - 24usize];
    ["Offset of field: AmdsmiLinkMetricsTLinks::write"]
        [::std::mem::offset_of!(AmdsmiLinkMetricsTLinks, write) - 32usize];
    ["Offset of field: AmdsmiLinkMetricsTLinks::reserved"]
        [::std::mem::offset_of!(AmdsmiLinkMetricsTLinks, reserved) - 40usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiLinkMetricsT"][::std::mem::size_of::<AmdsmiLinkMetricsT>() - 3648usize];
    ["Alignment of AmdsmiLinkMetricsT"][::std::mem::align_of::<AmdsmiLinkMetricsT>() - 8usize];
    ["Offset of field: AmdsmiLinkMetricsT::num_links"]
        [::std::mem::offset_of!(AmdsmiLinkMetricsT, num_links) - 0usize];
    ["Offset of field: AmdsmiLinkMetricsT::links"]
        [::std::mem::offset_of!(AmdsmiLinkMetricsT, links) - 8usize];
    ["Offset of field: AmdsmiLinkMetricsT::reserved"]
        [::std::mem::offset_of!(AmdsmiLinkMetricsT, reserved) - 3592usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiVramInfoT {
    pub vram_type: AmdsmiVramTypeT,
    pub vram_vendor: AmdsmiVramVendorTypeT,
    pub vram_size: u64,
    pub vram_bit_width: u32,
    pub reserved: [u64; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiVramInfoT"][::std::mem::size_of::<AmdsmiVramInfoT>() - 64usize];
    ["Alignment of AmdsmiVramInfoT"][::std::mem::align_of::<AmdsmiVramInfoT>() - 8usize];
    ["Offset of field: AmdsmiVramInfoT::vram_type"]
        [::std::mem::offset_of!(AmdsmiVramInfoT, vram_type) - 0usize];
    ["Offset of field: AmdsmiVramInfoT::vram_vendor"]
        [::std::mem::offset_of!(AmdsmiVramInfoT, vram_vendor) - 4usize];
    ["Offset of field: AmdsmiVramInfoT::vram_size"]
        [::std::mem::offset_of!(AmdsmiVramInfoT, vram_size) - 8usize];
    ["Offset of field: AmdsmiVramInfoT::vram_bit_width"]
        [::std::mem::offset_of!(AmdsmiVramInfoT, vram_bit_width) - 16usize];
    ["Offset of field: AmdsmiVramInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiVramInfoT, reserved) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiDriverInfoT {
    pub driver_version: [::std::os::raw::c_char; 256usize],
    pub driver_date: [::std::os::raw::c_char; 256usize],
    pub driver_name: [::std::os::raw::c_char; 256usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiDriverInfoT"][::std::mem::size_of::<AmdsmiDriverInfoT>() - 768usize];
    ["Alignment of AmdsmiDriverInfoT"][::std::mem::align_of::<AmdsmiDriverInfoT>() - 1usize];
    ["Offset of field: AmdsmiDriverInfoT::driver_version"]
        [::std::mem::offset_of!(AmdsmiDriverInfoT, driver_version) - 0usize];
    ["Offset of field: AmdsmiDriverInfoT::driver_date"]
        [::std::mem::offset_of!(AmdsmiDriverInfoT, driver_date) - 256usize];
    ["Offset of field: AmdsmiDriverInfoT::driver_name"]
        [::std::mem::offset_of!(AmdsmiDriverInfoT, driver_name) - 512usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiBoardInfoT {
    pub model_number: [::std::os::raw::c_char; 256usize],
    pub product_serial: [::std::os::raw::c_char; 256usize],
    pub fru_id: [::std::os::raw::c_char; 256usize],
    pub product_name: [::std::os::raw::c_char; 256usize],
    pub manufacturer_name: [::std::os::raw::c_char; 256usize],
    pub reserved: [u64; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiBoardInfoT"][::std::mem::size_of::<AmdsmiBoardInfoT>() - 1536usize];
    ["Alignment of AmdsmiBoardInfoT"][::std::mem::align_of::<AmdsmiBoardInfoT>() - 8usize];
    ["Offset of field: AmdsmiBoardInfoT::model_number"]
        [::std::mem::offset_of!(AmdsmiBoardInfoT, model_number) - 0usize];
    ["Offset of field: AmdsmiBoardInfoT::product_serial"]
        [::std::mem::offset_of!(AmdsmiBoardInfoT, product_serial) - 256usize];
    ["Offset of field: AmdsmiBoardInfoT::fru_id"]
        [::std::mem::offset_of!(AmdsmiBoardInfoT, fru_id) - 512usize];
    ["Offset of field: AmdsmiBoardInfoT::product_name"]
        [::std::mem::offset_of!(AmdsmiBoardInfoT, product_name) - 768usize];
    ["Offset of field: AmdsmiBoardInfoT::manufacturer_name"]
        [::std::mem::offset_of!(AmdsmiBoardInfoT, manufacturer_name) - 1024usize];
    ["Offset of field: AmdsmiBoardInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiBoardInfoT, reserved) - 1280usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiPowerInfoT {
    pub current_socket_power: u32,
    pub average_socket_power: u32,
    pub gfx_voltage: u32,
    pub soc_voltage: u32,
    pub mem_voltage: u32,
    pub power_limit: u32,
    pub reserved: [u32; 11usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiPowerInfoT"][::std::mem::size_of::<AmdsmiPowerInfoT>() - 68usize];
    ["Alignment of AmdsmiPowerInfoT"][::std::mem::align_of::<AmdsmiPowerInfoT>() - 4usize];
    ["Offset of field: AmdsmiPowerInfoT::current_socket_power"]
        [::std::mem::offset_of!(AmdsmiPowerInfoT, current_socket_power) - 0usize];
    ["Offset of field: AmdsmiPowerInfoT::average_socket_power"]
        [::std::mem::offset_of!(AmdsmiPowerInfoT, average_socket_power) - 4usize];
    ["Offset of field: AmdsmiPowerInfoT::gfx_voltage"]
        [::std::mem::offset_of!(AmdsmiPowerInfoT, gfx_voltage) - 8usize];
    ["Offset of field: AmdsmiPowerInfoT::soc_voltage"]
        [::std::mem::offset_of!(AmdsmiPowerInfoT, soc_voltage) - 12usize];
    ["Offset of field: AmdsmiPowerInfoT::mem_voltage"]
        [::std::mem::offset_of!(AmdsmiPowerInfoT, mem_voltage) - 16usize];
    ["Offset of field: AmdsmiPowerInfoT::power_limit"]
        [::std::mem::offset_of!(AmdsmiPowerInfoT, power_limit) - 20usize];
    ["Offset of field: AmdsmiPowerInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiPowerInfoT, reserved) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiClkInfoT {
    pub clk: u32,
    pub min_clk: u32,
    pub max_clk: u32,
    pub clk_locked: u8,
    pub clk_deep_sleep: u8,
    pub reserved: [u32; 4usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiClkInfoT"][::std::mem::size_of::<AmdsmiClkInfoT>() - 32usize];
    ["Alignment of AmdsmiClkInfoT"][::std::mem::align_of::<AmdsmiClkInfoT>() - 4usize];
    ["Offset of field: AmdsmiClkInfoT::clk"][::std::mem::offset_of!(AmdsmiClkInfoT, clk) - 0usize];
    ["Offset of field: AmdsmiClkInfoT::min_clk"]
        [::std::mem::offset_of!(AmdsmiClkInfoT, min_clk) - 4usize];
    ["Offset of field: AmdsmiClkInfoT::max_clk"]
        [::std::mem::offset_of!(AmdsmiClkInfoT, max_clk) - 8usize];
    ["Offset of field: AmdsmiClkInfoT::clk_locked"]
        [::std::mem::offset_of!(AmdsmiClkInfoT, clk_locked) - 12usize];
    ["Offset of field: AmdsmiClkInfoT::clk_deep_sleep"]
        [::std::mem::offset_of!(AmdsmiClkInfoT, clk_deep_sleep) - 13usize];
    ["Offset of field: AmdsmiClkInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiClkInfoT, reserved) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiEngineUsageT {
    pub gfx_activity: u32,
    pub umc_activity: u32,
    pub mm_activity: u32,
    pub reserved: [u32; 13usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiEngineUsageT"][::std::mem::size_of::<AmdsmiEngineUsageT>() - 64usize];
    ["Alignment of AmdsmiEngineUsageT"][::std::mem::align_of::<AmdsmiEngineUsageT>() - 4usize];
    ["Offset of field: AmdsmiEngineUsageT::gfx_activity"]
        [::std::mem::offset_of!(AmdsmiEngineUsageT, gfx_activity) - 0usize];
    ["Offset of field: AmdsmiEngineUsageT::umc_activity"]
        [::std::mem::offset_of!(AmdsmiEngineUsageT, umc_activity) - 4usize];
    ["Offset of field: AmdsmiEngineUsageT::mm_activity"]
        [::std::mem::offset_of!(AmdsmiEngineUsageT, mm_activity) - 8usize];
    ["Offset of field: AmdsmiEngineUsageT::reserved"]
        [::std::mem::offset_of!(AmdsmiEngineUsageT, reserved) - 12usize];
};
pub type AmdsmiProcessHandleT = u32;
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiProcInfoT {
    pub name: [::std::os::raw::c_char; 256usize],
    pub pid: AmdsmiProcessHandleT,
    pub mem: u64,
    pub engine_usage: AmdsmiProcInfoTEngineUsage,
    pub memory_usage: AmdsmiProcInfoTMemoryUsage,
    pub container_name: [::std::os::raw::c_char; 256usize],
    pub reserved: [u32; 12usize],
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiProcInfoTEngineUsage {
    pub gfx: u64,
    pub enc: u64,
    pub reserved: [u32; 12usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiProcInfoTEngineUsage"]
        [::std::mem::size_of::<AmdsmiProcInfoTEngineUsage>() - 64usize];
    ["Alignment of AmdsmiProcInfoTEngineUsage"]
        [::std::mem::align_of::<AmdsmiProcInfoTEngineUsage>() - 8usize];
    ["Offset of field: AmdsmiProcInfoTEngineUsage::gfx"]
        [::std::mem::offset_of!(AmdsmiProcInfoTEngineUsage, gfx) - 0usize];
    ["Offset of field: AmdsmiProcInfoTEngineUsage::enc"]
        [::std::mem::offset_of!(AmdsmiProcInfoTEngineUsage, enc) - 8usize];
    ["Offset of field: AmdsmiProcInfoTEngineUsage::reserved"]
        [::std::mem::offset_of!(AmdsmiProcInfoTEngineUsage, reserved) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiProcInfoTMemoryUsage {
    pub gtt_mem: u64,
    pub cpu_mem: u64,
    pub vram_mem: u64,
    pub reserved: [u32; 10usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiProcInfoTMemoryUsage"]
        [::std::mem::size_of::<AmdsmiProcInfoTMemoryUsage>() - 64usize];
    ["Alignment of AmdsmiProcInfoTMemoryUsage"]
        [::std::mem::align_of::<AmdsmiProcInfoTMemoryUsage>() - 8usize];
    ["Offset of field: AmdsmiProcInfoTMemoryUsage::gtt_mem"]
        [::std::mem::offset_of!(AmdsmiProcInfoTMemoryUsage, gtt_mem) - 0usize];
    ["Offset of field: AmdsmiProcInfoTMemoryUsage::cpu_mem"]
        [::std::mem::offset_of!(AmdsmiProcInfoTMemoryUsage, cpu_mem) - 8usize];
    ["Offset of field: AmdsmiProcInfoTMemoryUsage::vram_mem"]
        [::std::mem::offset_of!(AmdsmiProcInfoTMemoryUsage, vram_mem) - 16usize];
    ["Offset of field: AmdsmiProcInfoTMemoryUsage::reserved"]
        [::std::mem::offset_of!(AmdsmiProcInfoTMemoryUsage, reserved) - 24usize];
};
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiProcInfoT"][::std::mem::size_of::<AmdsmiProcInfoT>() - 704usize];
    ["Alignment of AmdsmiProcInfoT"][::std::mem::align_of::<AmdsmiProcInfoT>() - 8usize];
    ["Offset of field: AmdsmiProcInfoT::name"]
        [::std::mem::offset_of!(AmdsmiProcInfoT, name) - 0usize];
    ["Offset of field: AmdsmiProcInfoT::pid"]
        [::std::mem::offset_of!(AmdsmiProcInfoT, pid) - 256usize];
    ["Offset of field: AmdsmiProcInfoT::mem"]
        [::std::mem::offset_of!(AmdsmiProcInfoT, mem) - 264usize];
    ["Offset of field: AmdsmiProcInfoT::engine_usage"]
        [::std::mem::offset_of!(AmdsmiProcInfoT, engine_usage) - 272usize];
    ["Offset of field: AmdsmiProcInfoT::memory_usage"]
        [::std::mem::offset_of!(AmdsmiProcInfoT, memory_usage) - 336usize];
    ["Offset of field: AmdsmiProcInfoT::container_name"]
        [::std::mem::offset_of!(AmdsmiProcInfoT, container_name) - 400usize];
    ["Offset of field: AmdsmiProcInfoT::reserved"]
        [::std::mem::offset_of!(AmdsmiProcInfoT, reserved) - 656usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiP2pCapabilityT {
    pub is_iolink_coherent: u8,
    pub is_iolink_atomics_32bit: u8,
    pub is_iolink_atomics_64bit: u8,
    pub is_iolink_dma: u8,
    pub is_iolink_bi_directional: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiP2pCapabilityT"][::std::mem::size_of::<AmdsmiP2pCapabilityT>() - 5usize];
    ["Alignment of AmdsmiP2pCapabilityT"][::std::mem::align_of::<AmdsmiP2pCapabilityT>() - 1usize];
    ["Offset of field: AmdsmiP2pCapabilityT::is_iolink_coherent"]
        [::std::mem::offset_of!(AmdsmiP2pCapabilityT, is_iolink_coherent) - 0usize];
    ["Offset of field: AmdsmiP2pCapabilityT::is_iolink_atomics_32bit"]
        [::std::mem::offset_of!(AmdsmiP2pCapabilityT, is_iolink_atomics_32bit) - 1usize];
    ["Offset of field: AmdsmiP2pCapabilityT::is_iolink_atomics_64bit"]
        [::std::mem::offset_of!(AmdsmiP2pCapabilityT, is_iolink_atomics_64bit) - 2usize];
    ["Offset of field: AmdsmiP2pCapabilityT::is_iolink_dma"]
        [::std::mem::offset_of!(AmdsmiP2pCapabilityT, is_iolink_dma) - 3usize];
    ["Offset of field: AmdsmiP2pCapabilityT::is_iolink_bi_directional"]
        [::std::mem::offset_of!(AmdsmiP2pCapabilityT, is_iolink_bi_directional) - 4usize];
};
impl AmdsmiDevPerfLevelT {
    pub const AmdsmiDevPerfLevelFirst: AmdsmiDevPerfLevelT =
        AmdsmiDevPerfLevelT::AmdsmiDevPerfLevelAuto;
}
impl AmdsmiDevPerfLevelT {
    pub const AmdsmiDevPerfLevelLast: AmdsmiDevPerfLevelT =
        AmdsmiDevPerfLevelT::AmdsmiDevPerfLevelDeterminism;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiDevPerfLevelT {
    AmdsmiDevPerfLevelAuto = 0,
    AmdsmiDevPerfLevelLow = 1,
    AmdsmiDevPerfLevelHigh = 2,
    AmdsmiDevPerfLevelManual = 3,
    AmdsmiDevPerfLevelStableStd = 4,
    AmdsmiDevPerfLevelStablePeak = 5,
    AmdsmiDevPerfLevelStableMinMclk = 6,
    AmdsmiDevPerfLevelStableMinSclk = 7,
    AmdsmiDevPerfLevelDeterminism = 8,
    AmdsmiDevPerfLevelUnknown = 256,
}
pub type AmdsmiEventHandleT = usize;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiEventGroupT {
    AmdsmiEvntGrpXgmi = 0,
    AmdsmiEvntGrpXgmiDataOut = 10,
    AmdsmiEvntGrpInvalid = 4294967295,
}
impl AmdsmiEventTypeT {
    pub const AmdsmiEvntXgmiFirst: AmdsmiEventTypeT = AmdsmiEventTypeT::AmdsmiEvntFirst;
}
impl AmdsmiEventTypeT {
    pub const AmdsmiEvntXgmi0NopTx: AmdsmiEventTypeT = AmdsmiEventTypeT::AmdsmiEvntFirst;
}
impl AmdsmiEventTypeT {
    pub const AmdsmiEvntXgmiLast: AmdsmiEventTypeT = AmdsmiEventTypeT::AmdsmiEvntXgmi1BeatsTx;
}
impl AmdsmiEventTypeT {
    pub const AmdsmiEvntXgmiDataOut0: AmdsmiEventTypeT =
        AmdsmiEventTypeT::AmdsmiEvntXgmiDataOutFirst;
}
impl AmdsmiEventTypeT {
    pub const AmdsmiEvntXgmiDataOutLast: AmdsmiEventTypeT =
        AmdsmiEventTypeT::AmdsmiEvntXgmiDataOut5;
}
impl AmdsmiEventTypeT {
    pub const AmdsmiEvntLast: AmdsmiEventTypeT = AmdsmiEventTypeT::AmdsmiEvntXgmiDataOut5;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiEventTypeT {
    AmdsmiEvntFirst = 0,
    AmdsmiEvntXgmi0RequestTx = 1,
    AmdsmiEvntXgmi0ResponseTx = 2,
    AmdsmiEvntXgmi0BeatsTx = 3,
    AmdsmiEvntXgmi1NopTx = 4,
    AmdsmiEvntXgmi1RequestTx = 5,
    AmdsmiEvntXgmi1ResponseTx = 6,
    AmdsmiEvntXgmi1BeatsTx = 7,
    AmdsmiEvntXgmiDataOutFirst = 10,
    AmdsmiEvntXgmiDataOut1 = 11,
    AmdsmiEvntXgmiDataOut2 = 12,
    AmdsmiEvntXgmiDataOut3 = 13,
    AmdsmiEvntXgmiDataOut4 = 14,
    AmdsmiEvntXgmiDataOut5 = 15,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiCounterCommandT {
    AmdsmiCntrCmdStart = 0,
    AmdsmiCntrCmdStop = 1,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiCounterValueT {
    pub value: u64,
    pub time_enabled: u64,
    pub time_running: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiCounterValueT"][::std::mem::size_of::<AmdsmiCounterValueT>() - 24usize];
    ["Alignment of AmdsmiCounterValueT"][::std::mem::align_of::<AmdsmiCounterValueT>() - 8usize];
    ["Offset of field: AmdsmiCounterValueT::value"]
        [::std::mem::offset_of!(AmdsmiCounterValueT, value) - 0usize];
    ["Offset of field: AmdsmiCounterValueT::time_enabled"]
        [::std::mem::offset_of!(AmdsmiCounterValueT, time_enabled) - 8usize];
    ["Offset of field: AmdsmiCounterValueT::time_running"]
        [::std::mem::offset_of!(AmdsmiCounterValueT, time_running) - 16usize];
};
impl AmdsmiEvtNotificationTypeT {
    pub const AmdsmiEvtNotifFirst: AmdsmiEvtNotificationTypeT =
        AmdsmiEvtNotificationTypeT::AmdsmiEvtNotifVmfault;
}
impl AmdsmiEvtNotificationTypeT {
    pub const AmdsmiEvtNotifLast: AmdsmiEvtNotificationTypeT =
        AmdsmiEvtNotificationTypeT::AmdsmiEvtNotifRingHang;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiEvtNotificationTypeT {
    AmdsmiEvtNotifNone = 0,
    AmdsmiEvtNotifVmfault = 1,
    AmdsmiEvtNotifThermalThrottle = 2,
    AmdsmiEvtNotifGpuPreReset = 3,
    AmdsmiEvtNotifGpuPostReset = 4,
    AmdsmiEvtNotifRingHang = 5,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiEvtNotificationDataT {
    pub processor_handle: AmdsmiProcessorHandle,
    pub event: AmdsmiEvtNotificationTypeT,
    pub message: [::std::os::raw::c_char; 64usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiEvtNotificationDataT"]
        [::std::mem::size_of::<AmdsmiEvtNotificationDataT>() - 80usize];
    ["Alignment of AmdsmiEvtNotificationDataT"]
        [::std::mem::align_of::<AmdsmiEvtNotificationDataT>() - 8usize];
    ["Offset of field: AmdsmiEvtNotificationDataT::processor_handle"]
        [::std::mem::offset_of!(AmdsmiEvtNotificationDataT, processor_handle) - 0usize];
    ["Offset of field: AmdsmiEvtNotificationDataT::event"]
        [::std::mem::offset_of!(AmdsmiEvtNotificationDataT, event) - 8usize];
    ["Offset of field: AmdsmiEvtNotificationDataT::message"]
        [::std::mem::offset_of!(AmdsmiEvtNotificationDataT, message) - 12usize];
};
impl AmdsmiTemperatureMetricT {
    pub const AmdsmiTempFirst: AmdsmiTemperatureMetricT =
        AmdsmiTemperatureMetricT::AmdsmiTempCurrent;
}
impl AmdsmiTemperatureMetricT {
    pub const AmdsmiTempLast: AmdsmiTemperatureMetricT =
        AmdsmiTemperatureMetricT::AmdsmiTempHighest;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiTemperatureMetricT {
    AmdsmiTempCurrent = 0,
    AmdsmiTempMax = 1,
    AmdsmiTempMin = 2,
    AmdsmiTempMaxHyst = 3,
    AmdsmiTempMinHyst = 4,
    AmdsmiTempCritical = 5,
    AmdsmiTempCriticalHyst = 6,
    AmdsmiTempEmergency = 7,
    AmdsmiTempEmergencyHyst = 8,
    AmdsmiTempCritMin = 9,
    AmdsmiTempCritMinHyst = 10,
    AmdsmiTempOffset = 11,
    AmdsmiTempLowest = 12,
    AmdsmiTempHighest = 13,
}
impl AmdsmiVoltageMetricT {
    pub const AmdsmiVoltFirst: AmdsmiVoltageMetricT = AmdsmiVoltageMetricT::AmdsmiVoltCurrent;
}
impl AmdsmiVoltageMetricT {
    pub const AmdsmiVoltLast: AmdsmiVoltageMetricT = AmdsmiVoltageMetricT::AmdsmiVoltHighest;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiVoltageMetricT {
    AmdsmiVoltCurrent = 0,
    AmdsmiVoltMax = 1,
    AmdsmiVoltMinCrit = 2,
    AmdsmiVoltMin = 3,
    AmdsmiVoltMaxCrit = 4,
    AmdsmiVoltAverage = 5,
    AmdsmiVoltLowest = 6,
    AmdsmiVoltHighest = 7,
}
impl AmdsmiVoltageTypeT {
    pub const AmdsmiVoltTypeVddgfx: AmdsmiVoltageTypeT = AmdsmiVoltageTypeT::AmdsmiVoltTypeFirst;
}
impl AmdsmiVoltageTypeT {
    pub const AmdsmiVoltTypeLast: AmdsmiVoltageTypeT = AmdsmiVoltageTypeT::AmdsmiVoltTypeFirst;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiVoltageTypeT {
    AmdsmiVoltTypeFirst = 0,
    AmdsmiVoltTypeInvalid = 4294967295,
}
impl AmdsmiPowerProfilePresetMasksT {
    pub const AmdsmiPwrProfPrstLast: AmdsmiPowerProfilePresetMasksT =
        AmdsmiPowerProfilePresetMasksT::AmdsmiPwrProfPrstBootupDefault;
}
#[repr(u64)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiPowerProfilePresetMasksT {
    AmdsmiPwrProfPrstCustomMask = 1,
    AmdsmiPwrProfPrstVideoMask = 2,
    AmdsmiPwrProfPrstPowerSavingMask = 4,
    AmdsmiPwrProfPrstComputeMask = 8,
    AmdsmiPwrProfPrstVrMask = 16,
    AmdsmiPwrProfPrst3dFullScrMask = 32,
    AmdsmiPwrProfPrstBootupDefault = 64,
    AmdsmiPwrProfPrstInvalid = 18446744073709551615,
}
impl AmdsmiGpuBlockT {
    pub const AmdsmiGpuBlockUmc: AmdsmiGpuBlockT = AmdsmiGpuBlockT::AmdsmiGpuBlockFirst;
}
impl AmdsmiGpuBlockT {
    pub const AmdsmiGpuBlockLast: AmdsmiGpuBlockT = AmdsmiGpuBlockT::AmdsmiGpuBlockMpio;
}
#[repr(u64)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiGpuBlockT {
    AmdsmiGpuBlockInvalid = 0,
    AmdsmiGpuBlockFirst = 1,
    AmdsmiGpuBlockSdma = 2,
    AmdsmiGpuBlockGfx = 4,
    AmdsmiGpuBlockMmhub = 8,
    AmdsmiGpuBlockAthub = 16,
    AmdsmiGpuBlockPcieBif = 32,
    AmdsmiGpuBlockHdp = 64,
    AmdsmiGpuBlockXgmiWafl = 128,
    AmdsmiGpuBlockDf = 256,
    AmdsmiGpuBlockSmn = 512,
    AmdsmiGpuBlockSem = 1024,
    AmdsmiGpuBlockMp0 = 2048,
    AmdsmiGpuBlockMp1 = 4096,
    AmdsmiGpuBlockFuse = 8192,
    AmdsmiGpuBlockMca = 16384,
    AmdsmiGpuBlockVcn = 32768,
    AmdsmiGpuBlockJpeg = 65536,
    AmdsmiGpuBlockIh = 131072,
    AmdsmiGpuBlockMpio = 262144,
    AmdsmiGpuBlockReserved = 9223372036854775808,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiClkLimitTypeT {
    ClkLimitMin = 0,
    ClkLimitMax = 1,
}
impl AmdsmiRasErrStateT {
    pub const AmdsmiRasErrStateLast: AmdsmiRasErrStateT =
        AmdsmiRasErrStateT::AmdsmiRasErrStateEnabled;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiRasErrStateT {
    AmdsmiRasErrStateNone = 0,
    AmdsmiRasErrStateDisabled = 1,
    AmdsmiRasErrStateParity = 2,
    AmdsmiRasErrStateSingC = 3,
    AmdsmiRasErrStateMultUc = 4,
    AmdsmiRasErrStatePoison = 5,
    AmdsmiRasErrStateEnabled = 6,
    AmdsmiRasErrStateInvalid = 4294967295,
}
impl AmdsmiMemoryTypeT {
    pub const AmdsmiMemTypeVram: AmdsmiMemoryTypeT = AmdsmiMemoryTypeT::AmdsmiMemTypeFirst;
}
impl AmdsmiMemoryTypeT {
    pub const AmdsmiMemTypeLast: AmdsmiMemoryTypeT = AmdsmiMemoryTypeT::AmdsmiMemTypeGtt;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiMemoryTypeT {
    AmdsmiMemTypeFirst = 0,
    AmdsmiMemTypeVisVram = 1,
    AmdsmiMemTypeGtt = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiFreqIndT {
    AmdsmiFreqIndMin = 0,
    AmdsmiFreqIndMax = 1,
    AmdsmiFreqIndInvalid = 4294967295,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiXgmiStatusT {
    AmdsmiXgmiStatusNoErrors = 0,
    AmdsmiXgmiStatusError = 1,
    AmdsmiXgmiStatusMultipleErrors = 2,
}
pub type AmdsmiBitFieldT = u64;
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiMemoryPageStatusT {
    AmdsmiMemPageStatusReserved = 0,
    AmdsmiMemPageStatusPending = 1,
    AmdsmiMemPageStatusUnreservable = 2,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiIoLinkTypeT {
    AmdsmiIolinkTypeUndefined = 0,
    AmdsmiIolinkTypePciexpress = 1,
    AmdsmiIolinkTypeXgmi = 2,
    AmdsmiIolinkTypeNumiolinktypes = 3,
    AmdsmiIolinkTypeSize = 4294967295,
}
impl AmdsmiUtilizationCounterTypeT {
    pub const AmdsmiCoarseGrainGfxActivity: AmdsmiUtilizationCounterTypeT =
        AmdsmiUtilizationCounterTypeT::AmdsmiUtilizationCounterFirst;
}
impl AmdsmiUtilizationCounterTypeT {
    pub const AmdsmiUtilizationCounterLast: AmdsmiUtilizationCounterTypeT =
        AmdsmiUtilizationCounterTypeT::AmdsmiFineDecoderActivity;
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiUtilizationCounterTypeT {
    AmdsmiUtilizationCounterFirst = 0,
    AmdsmiCoarseGrainMemActivity = 1,
    AmdsmiCoarseDecoderActivity = 2,
    AmdsmiFineGrainGfxActivity = 100,
    AmdsmiFineGrainMemActivity = 101,
    AmdsmiFineDecoderActivity = 102,
}
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiPowerTypeT {
    AmdsmiAveragePower = 0,
    AmdsmiCurrentPower = 1,
    AmdsmiInvalidPower = 4294967295,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiUtilizationCounterT {
    pub type_: AmdsmiUtilizationCounterTypeT,
    pub value: u64,
    pub fine_value: [u64; 4usize],
    pub fine_value_count: u16,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiUtilizationCounterT"]
        [::std::mem::size_of::<AmdsmiUtilizationCounterT>() - 56usize];
    ["Alignment of AmdsmiUtilizationCounterT"]
        [::std::mem::align_of::<AmdsmiUtilizationCounterT>() - 8usize];
    ["Offset of field: AmdsmiUtilizationCounterT::type_"]
        [::std::mem::offset_of!(AmdsmiUtilizationCounterT, type_) - 0usize];
    ["Offset of field: AmdsmiUtilizationCounterT::value"]
        [::std::mem::offset_of!(AmdsmiUtilizationCounterT, value) - 8usize];
    ["Offset of field: AmdsmiUtilizationCounterT::fine_value"]
        [::std::mem::offset_of!(AmdsmiUtilizationCounterT, fine_value) - 16usize];
    ["Offset of field: AmdsmiUtilizationCounterT::fine_value_count"]
        [::std::mem::offset_of!(AmdsmiUtilizationCounterT, fine_value_count) - 48usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiRetiredPageRecordT {
    pub page_address: u64,
    pub page_size: u64,
    pub status: AmdsmiMemoryPageStatusT,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiRetiredPageRecordT"]
        [::std::mem::size_of::<AmdsmiRetiredPageRecordT>() - 24usize];
    ["Alignment of AmdsmiRetiredPageRecordT"]
        [::std::mem::align_of::<AmdsmiRetiredPageRecordT>() - 8usize];
    ["Offset of field: AmdsmiRetiredPageRecordT::page_address"]
        [::std::mem::offset_of!(AmdsmiRetiredPageRecordT, page_address) - 0usize];
    ["Offset of field: AmdsmiRetiredPageRecordT::page_size"]
        [::std::mem::offset_of!(AmdsmiRetiredPageRecordT, page_size) - 8usize];
    ["Offset of field: AmdsmiRetiredPageRecordT::status"]
        [::std::mem::offset_of!(AmdsmiRetiredPageRecordT, status) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiPowerProfileStatusT {
    pub available_profiles: AmdsmiBitFieldT,
    pub current: AmdsmiPowerProfilePresetMasksT,
    pub num_profiles: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiPowerProfileStatusT"]
        [::std::mem::size_of::<AmdsmiPowerProfileStatusT>() - 24usize];
    ["Alignment of AmdsmiPowerProfileStatusT"]
        [::std::mem::align_of::<AmdsmiPowerProfileStatusT>() - 8usize];
    ["Offset of field: AmdsmiPowerProfileStatusT::available_profiles"]
        [::std::mem::offset_of!(AmdsmiPowerProfileStatusT, available_profiles) - 0usize];
    ["Offset of field: AmdsmiPowerProfileStatusT::current"]
        [::std::mem::offset_of!(AmdsmiPowerProfileStatusT, current) - 8usize];
    ["Offset of field: AmdsmiPowerProfileStatusT::num_profiles"]
        [::std::mem::offset_of!(AmdsmiPowerProfileStatusT, num_profiles) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiFrequenciesT {
    pub has_deep_sleep: bool,
    pub num_supported: u32,
    pub current: u32,
    pub frequency: [u64; 33usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiFrequenciesT"][::std::mem::size_of::<AmdsmiFrequenciesT>() - 280usize];
    ["Alignment of AmdsmiFrequenciesT"][::std::mem::align_of::<AmdsmiFrequenciesT>() - 8usize];
    ["Offset of field: AmdsmiFrequenciesT::has_deep_sleep"]
        [::std::mem::offset_of!(AmdsmiFrequenciesT, has_deep_sleep) - 0usize];
    ["Offset of field: AmdsmiFrequenciesT::num_supported"]
        [::std::mem::offset_of!(AmdsmiFrequenciesT, num_supported) - 4usize];
    ["Offset of field: AmdsmiFrequenciesT::current"]
        [::std::mem::offset_of!(AmdsmiFrequenciesT, current) - 8usize];
    ["Offset of field: AmdsmiFrequenciesT::frequency"]
        [::std::mem::offset_of!(AmdsmiFrequenciesT, frequency) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiDpmPolicyEntryT {
    pub policy_id: u32,
    pub policy_description: [::std::os::raw::c_char; 256usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiDpmPolicyEntryT"][::std::mem::size_of::<AmdsmiDpmPolicyEntryT>() - 36usize];
    ["Alignment of AmdsmiDpmPolicyEntryT"]
        [::std::mem::align_of::<AmdsmiDpmPolicyEntryT>() - 4usize];
    ["Offset of field: AmdsmiDpmPolicyEntryT::policy_id"]
        [::std::mem::offset_of!(AmdsmiDpmPolicyEntryT, policy_id) - 0usize];
    ["Offset of field: AmdsmiDpmPolicyEntryT::policy_description"]
        [::std::mem::offset_of!(AmdsmiDpmPolicyEntryT, policy_description) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiDpmPolicyT {
    pub num_supported: u32,
    pub current: u32,
    pub policies: [AmdsmiDpmPolicyEntryT; 32usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiDpmPolicyT"][::std::mem::size_of::<AmdsmiDpmPolicyT>() - 1160usize];
    ["Alignment of AmdsmiDpmPolicyT"][::std::mem::align_of::<AmdsmiDpmPolicyT>() - 4usize];
    ["Offset of field: AmdsmiDpmPolicyT::num_supported"]
        [::std::mem::offset_of!(AmdsmiDpmPolicyT, num_supported) - 0usize];
    ["Offset of field: AmdsmiDpmPolicyT::current"]
        [::std::mem::offset_of!(AmdsmiDpmPolicyT, current) - 4usize];
    ["Offset of field: AmdsmiDpmPolicyT::policies"]
        [::std::mem::offset_of!(AmdsmiDpmPolicyT, policies) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiPcieBandwidthT {
    pub transfer_rate: AmdsmiFrequenciesT,
    pub lanes: [u32; 33usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiPcieBandwidthT"][::std::mem::size_of::<AmdsmiPcieBandwidthT>() - 416usize];
    ["Alignment of AmdsmiPcieBandwidthT"][::std::mem::align_of::<AmdsmiPcieBandwidthT>() - 8usize];
    ["Offset of field: AmdsmiPcieBandwidthT::transfer_rate"]
        [::std::mem::offset_of!(AmdsmiPcieBandwidthT, transfer_rate) - 0usize];
    ["Offset of field: AmdsmiPcieBandwidthT::lanes"]
        [::std::mem::offset_of!(AmdsmiPcieBandwidthT, lanes) - 280usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiVersionT {
    pub year: u32,
    pub major: u32,
    pub minor: u32,
    pub release: u32,
    pub build: *const ::std::os::raw::c_char,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiVersionT"][::std::mem::size_of::<AmdsmiVersionT>() - 24usize];
    ["Alignment of AmdsmiVersionT"][::std::mem::align_of::<AmdsmiVersionT>() - 8usize];
    ["Offset of field: AmdsmiVersionT::year"]
    ["Offset of field: AmdsmiVersionT::major"]
        [::std::mem::offset_of!(AmdsmiVersionT, major) - 4usize];
    ["Offset of field: AmdsmiVersionT::minor"]
        [::std::mem::offset_of!(AmdsmiVersionT, minor) - 8usize];
    ["Offset of field: AmdsmiVersionT::release"]
        [::std::mem::offset_of!(AmdsmiVersionT, release) - 12usize];
    ["Offset of field: AmdsmiVersionT::build"]
        [::std::mem::offset_of!(AmdsmiVersionT, build) - 16usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiOdVddcPointT {
    pub frequency: u64,
    pub voltage: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiOdVddcPointT"][::std::mem::size_of::<AmdsmiOdVddcPointT>() - 16usize];
    ["Alignment of AmdsmiOdVddcPointT"][::std::mem::align_of::<AmdsmiOdVddcPointT>() - 8usize];
    ["Offset of field: AmdsmiOdVddcPointT::frequency"]
        [::std::mem::offset_of!(AmdsmiOdVddcPointT, frequency) - 0usize];
    ["Offset of field: AmdsmiOdVddcPointT::voltage"]
        [::std::mem::offset_of!(AmdsmiOdVddcPointT, voltage) - 8usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiFreqVoltRegionT {
    pub freq_range: AmdsmiRangeT,
    pub volt_range: AmdsmiRangeT,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiFreqVoltRegionT"][::std::mem::size_of::<AmdsmiFreqVoltRegionT>() - 64usize];
    ["Alignment of AmdsmiFreqVoltRegionT"]
        [::std::mem::align_of::<AmdsmiFreqVoltRegionT>() - 8usize];
    ["Offset of field: AmdsmiFreqVoltRegionT::freq_range"]
        [::std::mem::offset_of!(AmdsmiFreqVoltRegionT, freq_range) - 0usize];
    ["Offset of field: AmdsmiFreqVoltRegionT::volt_range"]
        [::std::mem::offset_of!(AmdsmiFreqVoltRegionT, volt_range) - 32usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiOdVoltCurveT {
    pub vc_points: [AmdsmiOdVddcPointT; 3usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiOdVoltCurveT"][::std::mem::size_of::<AmdsmiOdVoltCurveT>() - 48usize];
    ["Alignment of AmdsmiOdVoltCurveT"][::std::mem::align_of::<AmdsmiOdVoltCurveT>() - 8usize];
    ["Offset of field: AmdsmiOdVoltCurveT::vc_points"]
        [::std::mem::offset_of!(AmdsmiOdVoltCurveT, vc_points) - 0usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiOdVoltFreqDataT {
    pub curr_sclk_range: AmdsmiRangeT,
    pub curr_mclk_range: AmdsmiRangeT,
    pub sclk_freq_limits: AmdsmiRangeT,
    pub mclk_freq_limits: AmdsmiRangeT,
    pub curve: AmdsmiOdVoltCurveT,
    pub num_regions: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiOdVoltFreqDataT"][::std::mem::size_of::<AmdsmiOdVoltFreqDataT>() - 184usize];
    ["Alignment of AmdsmiOdVoltFreqDataT"]
        [::std::mem::align_of::<AmdsmiOdVoltFreqDataT>() - 8usize];
    ["Offset of field: AmdsmiOdVoltFreqDataT::curr_sclk_range"]
        [::std::mem::offset_of!(AmdsmiOdVoltFreqDataT, curr_sclk_range) - 0usize];
    ["Offset of field: AmdsmiOdVoltFreqDataT::curr_mclk_range"]
        [::std::mem::offset_of!(AmdsmiOdVoltFreqDataT, curr_mclk_range) - 32usize];
    ["Offset of field: AmdsmiOdVoltFreqDataT::sclk_freq_limits"]
        [::std::mem::offset_of!(AmdsmiOdVoltFreqDataT, sclk_freq_limits) - 64usize];
    ["Offset of field: AmdsmiOdVoltFreqDataT::mclk_freq_limits"]
        [::std::mem::offset_of!(AmdsmiOdVoltFreqDataT, mclk_freq_limits) - 96usize];
    ["Offset of field: AmdsmiOdVoltFreqDataT::curve"]
        [::std::mem::offset_of!(AmdsmiOdVoltFreqDataT, curve) - 128usize];
    ["Offset of field: AmdsmiOdVoltFreqDataT::num_regions"]
        [::std::mem::offset_of!(AmdsmiOdVoltFreqDataT, num_regions) - 176usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdMetricsTableHeaderT {
    pub structure_size: u16,
    pub format_revision: u8,
    pub content_revision: u8,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdMetricsTableHeaderT"][::std::mem::size_of::<AmdMetricsTableHeaderT>() - 4usize];
    ["Alignment of AmdMetricsTableHeaderT"]
        [::std::mem::align_of::<AmdMetricsTableHeaderT>() - 2usize];
    ["Offset of field: AmdMetricsTableHeaderT::structure_size"]
        [::std::mem::offset_of!(AmdMetricsTableHeaderT, structure_size) - 0usize];
    ["Offset of field: AmdMetricsTableHeaderT::format_revision"]
        [::std::mem::offset_of!(AmdMetricsTableHeaderT, format_revision) - 2usize];
    ["Offset of field: AmdMetricsTableHeaderT::content_revision"]
        [::std::mem::offset_of!(AmdMetricsTableHeaderT, content_revision) - 3usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiGpuXcpMetricsT {
    pub gfx_busy_inst: [u32; 8usize],
    pub jpeg_busy: [u16; 32usize],
    pub vcn_busy: [u16; 4usize],
    pub gfx_busy_acc: [u64; 8usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiGpuXcpMetricsT"][::std::mem::size_of::<AmdsmiGpuXcpMetricsT>() - 168usize];
    ["Alignment of AmdsmiGpuXcpMetricsT"][::std::mem::align_of::<AmdsmiGpuXcpMetricsT>() - 8usize];
    ["Offset of field: AmdsmiGpuXcpMetricsT::gfx_busy_inst"]
        [::std::mem::offset_of!(AmdsmiGpuXcpMetricsT, gfx_busy_inst) - 0usize];
    ["Offset of field: AmdsmiGpuXcpMetricsT::jpeg_busy"]
        [::std::mem::offset_of!(AmdsmiGpuXcpMetricsT, jpeg_busy) - 32usize];
    ["Offset of field: AmdsmiGpuXcpMetricsT::vcn_busy"]
        [::std::mem::offset_of!(AmdsmiGpuXcpMetricsT, vcn_busy) - 96usize];
    ["Offset of field: AmdsmiGpuXcpMetricsT::gfx_busy_acc"]
        [::std::mem::offset_of!(AmdsmiGpuXcpMetricsT, gfx_busy_acc) - 104usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiGpuMetricsT {
    pub common_header: AmdMetricsTableHeaderT,
    pub temperature_edge: u16,
    pub temperature_hotspot: u16,
    pub temperature_mem: u16,
    pub temperature_vrgfx: u16,
    pub temperature_vrsoc: u16,
    pub temperature_vrmem: u16,
    pub average_gfx_activity: u16,
    pub average_umc_activity: u16,
    pub average_mm_activity: u16,
    pub average_socket_power: u16,
    pub energy_accumulator: u64,
    pub system_clock_counter: u64,
    pub average_gfxclk_frequency: u16,
    pub average_socclk_frequency: u16,
    pub average_uclk_frequency: u16,
    pub average_vclk0_frequency: u16,
    pub average_dclk0_frequency: u16,
    pub average_vclk1_frequency: u16,
    pub average_dclk1_frequency: u16,
    pub current_gfxclk: u16,
    pub current_socclk: u16,
    pub current_uclk: u16,
    pub current_vclk0: u16,
    pub current_dclk0: u16,
    pub current_vclk1: u16,
    pub current_dclk1: u16,
    pub throttle_status: u32,
    pub current_fan_speed: u16,
    pub pcie_link_width: u16,
    pub pcie_link_speed: u16,
    pub gfx_activity_acc: u32,
    pub mem_activity_acc: u32,
    pub temperature_hbm: [u16; 4usize],
    pub firmware_timestamp: u64,
    pub voltage_soc: u16,
    pub voltage_gfx: u16,
    pub voltage_mem: u16,
    pub indep_throttle_status: u64,
    pub current_socket_power: u16,
    pub vcn_activity: [u16; 4usize],
    pub gfxclk_lock_status: u32,
    pub xgmi_link_width: u16,
    pub xgmi_link_speed: u16,
    pub pcie_bandwidth_acc: u64,
    pub pcie_bandwidth_inst: u64,
    pub pcie_l0_to_recov_count_acc: u64,
    pub pcie_replay_count_acc: u64,
    pub pcie_replay_rover_count_acc: u64,
    pub xgmi_read_data_acc: [u64; 8usize],
    pub xgmi_write_data_acc: [u64; 8usize],
    pub current_gfxclks: [u16; 8usize],
    pub current_socclks: [u16; 4usize],
    pub current_vclk0s: [u16; 4usize],
    pub current_dclk0s: [u16; 4usize],
    pub jpeg_activity: [u16; 32usize],
    pub pcie_nak_sent_count_acc: u32,
    pub pcie_nak_rcvd_count_acc: u32,
    pub accumulation_counter: u64,
    pub prochot_residency_acc: u64,
    pub ppt_residency_acc: u64,
    pub socket_thm_residency_acc: u64,
    pub vr_thm_residency_acc: u64,
    pub hbm_thm_residency_acc: u64,
    pub num_partition: u16,
    pub xcp_stats: [AmdsmiGpuXcpMetricsT; 8usize],
    pub pcie_lc_perf_other_end_recovery: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiGpuMetricsT"][::std::mem::size_of::<AmdsmiGpuMetricsT>() - 1832usize];
    ["Alignment of AmdsmiGpuMetricsT"][::std::mem::align_of::<AmdsmiGpuMetricsT>() - 8usize];
    ["Offset of field: AmdsmiGpuMetricsT::common_header"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, common_header) - 0usize];
    ["Offset of field: AmdsmiGpuMetricsT::temperature_edge"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, temperature_edge) - 4usize];
    ["Offset of field: AmdsmiGpuMetricsT::temperature_hotspot"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, temperature_hotspot) - 6usize];
    ["Offset of field: AmdsmiGpuMetricsT::temperature_mem"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, temperature_mem) - 8usize];
    ["Offset of field: AmdsmiGpuMetricsT::temperature_vrgfx"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, temperature_vrgfx) - 10usize];
    ["Offset of field: AmdsmiGpuMetricsT::temperature_vrsoc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, temperature_vrsoc) - 12usize];
    ["Offset of field: AmdsmiGpuMetricsT::temperature_vrmem"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, temperature_vrmem) - 14usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_gfx_activity"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_gfx_activity) - 16usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_umc_activity"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_umc_activity) - 18usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_mm_activity"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_mm_activity) - 20usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_socket_power"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_socket_power) - 22usize];
    ["Offset of field: AmdsmiGpuMetricsT::energy_accumulator"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, energy_accumulator) - 24usize];
    ["Offset of field: AmdsmiGpuMetricsT::system_clock_counter"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, system_clock_counter) - 32usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_gfxclk_frequency"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_gfxclk_frequency) - 40usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_socclk_frequency"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_socclk_frequency) - 42usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_uclk_frequency"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_uclk_frequency) - 44usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_vclk0_frequency"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_vclk0_frequency) - 46usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_dclk0_frequency"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_dclk0_frequency) - 48usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_vclk1_frequency"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_vclk1_frequency) - 50usize];
    ["Offset of field: AmdsmiGpuMetricsT::average_dclk1_frequency"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, average_dclk1_frequency) - 52usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_gfxclk"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_gfxclk) - 54usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_socclk"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_socclk) - 56usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_uclk"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_uclk) - 58usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_vclk0"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_vclk0) - 60usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_dclk0"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_dclk0) - 62usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_vclk1"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_vclk1) - 64usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_dclk1"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_dclk1) - 66usize];
    ["Offset of field: AmdsmiGpuMetricsT::throttle_status"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, throttle_status) - 68usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_fan_speed"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_fan_speed) - 72usize];
    ["Offset of field: AmdsmiGpuMetricsT::pcie_link_width"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, pcie_link_width) - 74usize];
    ["Offset of field: AmdsmiGpuMetricsT::pcie_link_speed"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, pcie_link_speed) - 76usize];
    ["Offset of field: AmdsmiGpuMetricsT::gfx_activity_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, gfx_activity_acc) - 80usize];
    ["Offset of field: AmdsmiGpuMetricsT::mem_activity_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, mem_activity_acc) - 84usize];
    ["Offset of field: AmdsmiGpuMetricsT::temperature_hbm"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, temperature_hbm) - 88usize];
    ["Offset of field: AmdsmiGpuMetricsT::firmware_timestamp"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, firmware_timestamp) - 96usize];
    ["Offset of field: AmdsmiGpuMetricsT::voltage_soc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, voltage_soc) - 104usize];
    ["Offset of field: AmdsmiGpuMetricsT::voltage_gfx"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, voltage_gfx) - 106usize];
    ["Offset of field: AmdsmiGpuMetricsT::voltage_mem"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, voltage_mem) - 108usize];
    ["Offset of field: AmdsmiGpuMetricsT::indep_throttle_status"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, indep_throttle_status) - 112usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_socket_power"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_socket_power) - 120usize];
    ["Offset of field: AmdsmiGpuMetricsT::vcn_activity"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, vcn_activity) - 122usize];
    ["Offset of field: AmdsmiGpuMetricsT::gfxclk_lock_status"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, gfxclk_lock_status) - 132usize];
    ["Offset of field: AmdsmiGpuMetricsT::xgmi_link_width"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, xgmi_link_width) - 136usize];
    ["Offset of field: AmdsmiGpuMetricsT::xgmi_link_speed"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, xgmi_link_speed) - 138usize];
    ["Offset of field: AmdsmiGpuMetricsT::pcie_bandwidth_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, pcie_bandwidth_acc) - 144usize];
    ["Offset of field: AmdsmiGpuMetricsT::pcie_bandwidth_inst"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, pcie_bandwidth_inst) - 152usize];
    ["Offset of field: AmdsmiGpuMetricsT::pcie_l0_to_recov_count_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, pcie_l0_to_recov_count_acc) - 160usize];
    ["Offset of field: AmdsmiGpuMetricsT::pcie_replay_count_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, pcie_replay_count_acc) - 168usize];
    ["Offset of field: AmdsmiGpuMetricsT::pcie_replay_rover_count_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, pcie_replay_rover_count_acc) - 176usize];
    ["Offset of field: AmdsmiGpuMetricsT::xgmi_read_data_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, xgmi_read_data_acc) - 184usize];
    ["Offset of field: AmdsmiGpuMetricsT::xgmi_write_data_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, xgmi_write_data_acc) - 248usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_gfxclks"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_gfxclks) - 312usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_socclks"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_socclks) - 328usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_vclk0s"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_vclk0s) - 336usize];
    ["Offset of field: AmdsmiGpuMetricsT::current_dclk0s"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, current_dclk0s) - 344usize];
    ["Offset of field: AmdsmiGpuMetricsT::jpeg_activity"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, jpeg_activity) - 352usize];
    ["Offset of field: AmdsmiGpuMetricsT::pcie_nak_sent_count_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, pcie_nak_sent_count_acc) - 416usize];
    ["Offset of field: AmdsmiGpuMetricsT::pcie_nak_rcvd_count_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, pcie_nak_rcvd_count_acc) - 420usize];
    ["Offset of field: AmdsmiGpuMetricsT::accumulation_counter"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, accumulation_counter) - 424usize];
    ["Offset of field: AmdsmiGpuMetricsT::prochot_residency_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, prochot_residency_acc) - 432usize];
    ["Offset of field: AmdsmiGpuMetricsT::ppt_residency_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, ppt_residency_acc) - 440usize];
    ["Offset of field: AmdsmiGpuMetricsT::socket_thm_residency_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, socket_thm_residency_acc) - 448usize];
    ["Offset of field: AmdsmiGpuMetricsT::vr_thm_residency_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, vr_thm_residency_acc) - 456usize];
    ["Offset of field: AmdsmiGpuMetricsT::hbm_thm_residency_acc"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, hbm_thm_residency_acc) - 464usize];
    ["Offset of field: AmdsmiGpuMetricsT::num_partition"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, num_partition) - 472usize];
    ["Offset of field: AmdsmiGpuMetricsT::xcp_stats"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, xcp_stats) - 480usize];
    ["Offset of field: AmdsmiGpuMetricsT::pcie_lc_perf_other_end_recovery"]
        [::std::mem::offset_of!(AmdsmiGpuMetricsT, pcie_lc_perf_other_end_recovery) - 1824usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiNameValueT {
    pub name: [::std::os::raw::c_char; 64usize],
    pub value: u64,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiNameValueT"][::std::mem::size_of::<AmdsmiNameValueT>() - 72usize];
    ["Alignment of AmdsmiNameValueT"][::std::mem::align_of::<AmdsmiNameValueT>() - 8usize];
    ["Offset of field: AmdsmiNameValueT::name"]
        [::std::mem::offset_of!(AmdsmiNameValueT, name) - 0usize];
    ["Offset of field: AmdsmiNameValueT::value"]
        [::std::mem::offset_of!(AmdsmiNameValueT, value) - 64usize];
};
#[repr(u32)]
#[derive(Debug, Copy, Clone, Hash, PartialEq, Eq)]
pub enum AmdsmiRegTypeT {
    AmdsmiRegXgmi = 0,
    AmdsmiRegWafl = 1,
    AmdsmiRegPcie = 2,
    AmdsmiRegUsr = 3,
    AmdsmiRegUsr1 = 4,
}
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiRasFeatureT {
    pub ras_eeprom_version: u32,
    pub ecc_correction_schema_flag: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiRasFeatureT"][::std::mem::size_of::<AmdsmiRasFeatureT>() - 8usize];
    ["Alignment of AmdsmiRasFeatureT"][::std::mem::align_of::<AmdsmiRasFeatureT>() - 4usize];
    ["Offset of field: AmdsmiRasFeatureT::ras_eeprom_version"]
        [::std::mem::offset_of!(AmdsmiRasFeatureT, ras_eeprom_version) - 0usize];
    ["Offset of field: AmdsmiRasFeatureT::ecc_correction_schema_flag"]
        [::std::mem::offset_of!(AmdsmiRasFeatureT, ecc_correction_schema_flag) - 4usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiErrorCountT {
    pub correctable_count: u64,
    pub uncorrectable_count: u64,
    pub deferred_count: u64,
    pub reserved: [u64; 5usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiErrorCountT"][::std::mem::size_of::<AmdsmiErrorCountT>() - 64usize];
    ["Alignment of AmdsmiErrorCountT"][::std::mem::align_of::<AmdsmiErrorCountT>() - 8usize];
    ["Offset of field: AmdsmiErrorCountT::correctable_count"]
        [::std::mem::offset_of!(AmdsmiErrorCountT, correctable_count) - 0usize];
    ["Offset of field: AmdsmiErrorCountT::uncorrectable_count"]
        [::std::mem::offset_of!(AmdsmiErrorCountT, uncorrectable_count) - 8usize];
    ["Offset of field: AmdsmiErrorCountT::deferred_count"]
        [::std::mem::offset_of!(AmdsmiErrorCountT, deferred_count) - 16usize];
    ["Offset of field: AmdsmiErrorCountT::reserved"]
        [::std::mem::offset_of!(AmdsmiErrorCountT, reserved) - 24usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiProcessInfoT {
    pub process_id: u32,
    pub vram_usage: u64,
    pub sdma_usage: u64,
    pub cu_occupancy: u32,
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiProcessInfoT"][::std::mem::size_of::<AmdsmiProcessInfoT>() - 32usize];
    ["Alignment of AmdsmiProcessInfoT"][::std::mem::align_of::<AmdsmiProcessInfoT>() - 8usize];
    ["Offset of field: AmdsmiProcessInfoT::process_id"]
        [::std::mem::offset_of!(AmdsmiProcessInfoT, process_id) - 0usize];
    ["Offset of field: AmdsmiProcessInfoT::vram_usage"]
        [::std::mem::offset_of!(AmdsmiProcessInfoT, vram_usage) - 4usize];
    ["Offset of field: AmdsmiProcessInfoT::sdma_usage"]
        [::std::mem::offset_of!(AmdsmiProcessInfoT, sdma_usage) - 12usize];
    ["Offset of field: AmdsmiProcessInfoT::cu_occupancy"]
        [::std::mem::offset_of!(AmdsmiProcessInfoT, cu_occupancy) - 20usize];
};
#[repr(C)]
#[derive(Debug, Copy, Clone)]
pub struct AmdsmiTopologyNearestT {
    pub count: u32,
    pub processor_list: [AmdsmiProcessorHandle; 32usize],
    pub reserved: [u64; 15usize],
}
#[allow(clippy::unnecessary_operation, clippy::identity_op)]
const _: () = {
    ["Size of AmdsmiTopologyNearestT"][::std::mem::size_of::<AmdsmiTopologyNearestT>() - 384usize];
    ["Alignment of AmdsmiTopologyNearestT"]
        [::std::mem::align_of::<AmdsmiTopologyNearestT>() - 8usize];
    ["Offset of field: AmdsmiTopologyNearestT::count"]
        [::std::mem::offset_of!(AmdsmiTopologyNearestT, count) - 0usize];
    ["Offset of field: AmdsmiTopologyNearestT::processor_list"]
        [::std::mem::offset_of!(AmdsmiTopologyNearestT, processor_list) - 8usize];
    ["Offset of field: AmdsmiTopologyNearestT::reserved"]
        [::std::mem::offset_of!(AmdsmiTopologyNearestT, reserved) - 264usize];
};
extern "C" {
    pub fn amdsmi_init(init_flags: u64) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_shut_down() -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_socket_handles(
        socket_count: *mut u32,
        socket_handles: *mut AmdsmiSocketHandle,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_socket_info(
        socket_handle: AmdsmiSocketHandle,
        len: usize,
        name: *mut ::std::os::raw::c_char,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_processor_handles(
        socket_handle: AmdsmiSocketHandle,
        processor_count: *mut u32,
        processor_handles: *mut AmdsmiProcessorHandle,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_processor_type(
        processor_handle: AmdsmiProcessorHandle,
        processor_type: *mut ProcessorTypeT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_processor_handle_from_bdf(
        bdf: AmdsmiBdfT,
        processor_handle: *mut AmdsmiProcessorHandle,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_id(
        processor_handle: AmdsmiProcessorHandle,
        id: *mut u16,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_revision(
        processor_handle: AmdsmiProcessorHandle,
        revision: *mut u16,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_vendor_name(
        processor_handle: AmdsmiProcessorHandle,
        name: *mut ::std::os::raw::c_char,
        len: usize,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_vram_vendor(
        processor_handle: AmdsmiProcessorHandle,
        brand: *mut ::std::os::raw::c_char,
        len: u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_subsystem_id(
        processor_handle: AmdsmiProcessorHandle,
        id: *mut u16,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_subsystem_name(
        processor_handle: AmdsmiProcessorHandle,
        name: *mut ::std::os::raw::c_char,
        len: usize,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_pci_bandwidth(
        processor_handle: AmdsmiProcessorHandle,
        bandwidth: *mut AmdsmiPcieBandwidthT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_bdf_id(
        processor_handle: AmdsmiProcessorHandle,
        bdfid: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_topo_numa_affinity(
        processor_handle: AmdsmiProcessorHandle,
        numa_node: *mut i32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_pci_throughput(
        processor_handle: AmdsmiProcessorHandle,
        sent: *mut u64,
        received: *mut u64,
        max_pkt_sz: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_pci_replay_counter(
        processor_handle: AmdsmiProcessorHandle,
        counter: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_pci_bandwidth(
        processor_handle: AmdsmiProcessorHandle,
        bw_bitmask: u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_energy_count(
        processor_handle: AmdsmiProcessorHandle,
        energy_accumulator: *mut u64,
        counter_resolution: *mut f32,
        timestamp: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_power_cap(
        processor_handle: AmdsmiProcessorHandle,
        sensor_ind: u32,
        cap: u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_power_profile(
        processor_handle: AmdsmiProcessorHandle,
        reserved: u32,
        profile: AmdsmiPowerProfilePresetMasksT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_memory_total(
        processor_handle: AmdsmiProcessorHandle,
        mem_type: AmdsmiMemoryTypeT,
        total: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_memory_usage(
        processor_handle: AmdsmiProcessorHandle,
        mem_type: AmdsmiMemoryTypeT,
        used: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_bad_page_info(
        processor_handle: AmdsmiProcessorHandle,
        num_pages: *mut u32,
        info: *mut AmdsmiRetiredPageRecordT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_ras_feature_info(
        processor_handle: AmdsmiProcessorHandle,
        ras_feature: *mut AmdsmiRasFeatureT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_ras_block_features_enabled(
        processor_handle: AmdsmiProcessorHandle,
        block: AmdsmiGpuBlockT,
        state: *mut AmdsmiRasErrStateT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_memory_reserved_pages(
        processor_handle: AmdsmiProcessorHandle,
        num_pages: *mut u32,
        records: *mut AmdsmiRetiredPageRecordT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_fan_rpms(
        processor_handle: AmdsmiProcessorHandle,
        sensor_ind: u32,
        speed: *mut i64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_fan_speed(
        processor_handle: AmdsmiProcessorHandle,
        sensor_ind: u32,
        speed: *mut i64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_fan_speed_max(
        processor_handle: AmdsmiProcessorHandle,
        sensor_ind: u32,
        max_speed: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_temp_metric(
        processor_handle: AmdsmiProcessorHandle,
        sensor_type: AmdsmiTemperatureTypeT,
        metric: AmdsmiTemperatureMetricT,
        temperature: *mut i64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_cache_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiGpuCacheInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_volt_metric(
        processor_handle: AmdsmiProcessorHandle,
        sensor_type: AmdsmiVoltageTypeT,
        metric: AmdsmiVoltageMetricT,
        voltage: *mut i64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_reset_gpu_fan(
        processor_handle: AmdsmiProcessorHandle,
        sensor_ind: u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_fan_speed(
        processor_handle: AmdsmiProcessorHandle,
        sensor_ind: u32,
        speed: u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_busy_percent(
        processor_handle: AmdsmiProcessorHandle,
        gpu_busy_percent: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_utilization_count(
        processor_handle: AmdsmiProcessorHandle,
        utilization_counters: *mut AmdsmiUtilizationCounterT,
        count: u32,
        timestamp: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_perf_level(
        processor_handle: AmdsmiProcessorHandle,
        perf: *mut AmdsmiDevPerfLevelT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_perf_determinism_mode(
        processor_handle: AmdsmiProcessorHandle,
        clkvalue: u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_overdrive_level(
        processor_handle: AmdsmiProcessorHandle,
        od: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_mem_overdrive_level(
        processor_handle: AmdsmiProcessorHandle,
        od: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_clk_freq(
        processor_handle: AmdsmiProcessorHandle,
        clk_type: AmdsmiClkTypeT,
        f: *mut AmdsmiFrequenciesT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_reset_gpu(processor_handle: AmdsmiProcessorHandle) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_od_volt_info(
        processor_handle: AmdsmiProcessorHandle,
        odv: *mut AmdsmiOdVoltFreqDataT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_metrics_header_info(
        processor_handle: AmdsmiProcessorHandle,
        header_value: *mut AmdMetricsTableHeaderT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_metrics_info(
        processor_handle: AmdsmiProcessorHandle,
        pgpu_metrics: *mut AmdsmiGpuMetricsT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_pm_metrics_info(
        processor_handle: AmdsmiProcessorHandle,
        pm_metrics: *mut *mut AmdsmiNameValueT,
        num_of_metrics: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_reg_table_info(
        processor_handle: AmdsmiProcessorHandle,
        reg_type: AmdsmiRegTypeT,
        reg_metrics: *mut *mut AmdsmiNameValueT,
        num_of_metrics: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_clk_range(
        processor_handle: AmdsmiProcessorHandle,
        minclkvalue: u64,
        maxclkvalue: u64,
        clkType: AmdsmiClkTypeT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_clk_limit(
        processor_handle: AmdsmiProcessorHandle,
        clk_type: AmdsmiClkTypeT,
        limit_type: AmdsmiClkLimitTypeT,
        clk_value: u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_free_name_value_pairs(p: *mut ::std::os::raw::c_void);
}
extern "C" {
    pub fn amdsmi_set_gpu_od_clk_info(
        processor_handle: AmdsmiProcessorHandle,
        level: AmdsmiFreqIndT,
        clkvalue: u64,
        clkType: AmdsmiClkTypeT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_od_volt_info(
        processor_handle: AmdsmiProcessorHandle,
        vpoint: u32,
        clkvalue: u64,
        voltvalue: u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_od_volt_curve_regions(
        processor_handle: AmdsmiProcessorHandle,
        num_regions: *mut u32,
        buffer: *mut AmdsmiFreqVoltRegionT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_power_profile_presets(
        processor_handle: AmdsmiProcessorHandle,
        sensor_ind: u32,
        status: *mut AmdsmiPowerProfileStatusT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_perf_level(
        processor_handle: AmdsmiProcessorHandle,
        perf_lvl: AmdsmiDevPerfLevelT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_overdrive_level(
        processor_handle: AmdsmiProcessorHandle,
        od: u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_clk_freq(
        processor_handle: AmdsmiProcessorHandle,
        clk_type: AmdsmiClkTypeT,
        freq_bitmask: u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_soc_pstate(
        processor_handle: AmdsmiProcessorHandle,
        policy: *mut AmdsmiDpmPolicyT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_soc_pstate(
        processor_handle: AmdsmiProcessorHandle,
        policy_id: u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_xgmi_plpd(
        processor_handle: AmdsmiProcessorHandle,
        xgmi_plpd: *mut AmdsmiDpmPolicyT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_xgmi_plpd(
        processor_handle: AmdsmiProcessorHandle,
        plpd_id: u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_process_isolation(
        processor_handle: AmdsmiProcessorHandle,
        pisolate: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_process_isolation(
        processor_handle: AmdsmiProcessorHandle,
        pisolate: u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_clean_gpu_local_data(processor_handle: AmdsmiProcessorHandle) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_lib_version(version: *mut AmdsmiVersionT) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_ecc_count(
        processor_handle: AmdsmiProcessorHandle,
        block: AmdsmiGpuBlockT,
        ec: *mut AmdsmiErrorCountT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_ecc_enabled(
        processor_handle: AmdsmiProcessorHandle,
        enabled_blocks: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_ecc_status(
        processor_handle: AmdsmiProcessorHandle,
        block: AmdsmiGpuBlockT,
        state: *mut AmdsmiRasErrStateT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_status_code_to_string(
        status: AmdsmiStatusT,
        status_string: *mut *const ::std::os::raw::c_char,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_gpu_counter_group_supported(
        processor_handle: AmdsmiProcessorHandle,
        group: AmdsmiEventGroupT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_gpu_create_counter(
        processor_handle: AmdsmiProcessorHandle,
        type_: AmdsmiEventTypeT,
        evnt_handle: *mut AmdsmiEventHandleT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_gpu_destroy_counter(evnt_handle: AmdsmiEventHandleT) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_gpu_control_counter(
        evt_handle: AmdsmiEventHandleT,
        cmd: AmdsmiCounterCommandT,
        cmd_args: *mut ::std::os::raw::c_void,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_gpu_read_counter(
        evt_handle: AmdsmiEventHandleT,
        value: *mut AmdsmiCounterValueT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_available_counters(
        processor_handle: AmdsmiProcessorHandle,
        grp: AmdsmiEventGroupT,
        available: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_compute_process_info(
        procs: *mut AmdsmiProcessInfoT,
        num_items: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_compute_process_info_by_pid(
        pid: u32,
        proc_: *mut AmdsmiProcessInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_compute_process_gpus(
        pid: u32,
        dv_indices: *mut u32,
        num_devices: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_gpu_xgmi_error_status(
        processor_handle: AmdsmiProcessorHandle,
        status: *mut AmdsmiXgmiStatusT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_reset_gpu_xgmi_error(processor_handle: AmdsmiProcessorHandle) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_link_metrics(
        processor_handle: AmdsmiProcessorHandle,
        link_metrics: *mut AmdsmiLinkMetricsT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_topo_get_numa_node_number(
        processor_handle: AmdsmiProcessorHandle,
        numa_node: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_topo_get_link_weight(
        processor_handle_src: AmdsmiProcessorHandle,
        processor_handle_dst: AmdsmiProcessorHandle,
        weight: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_minmax_bandwidth_between_processors(
        processor_handle_src: AmdsmiProcessorHandle,
        processor_handle_dst: AmdsmiProcessorHandle,
        min_bandwidth: *mut u64,
        max_bandwidth: *mut u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_topo_get_link_type(
        processor_handle_src: AmdsmiProcessorHandle,
        processor_handle_dst: AmdsmiProcessorHandle,
        hops: *mut u64,
        type_: *mut AmdsmiIoLinkTypeT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_is_P2P_accessible(
        processor_handle_src: AmdsmiProcessorHandle,
        processor_handle_dst: AmdsmiProcessorHandle,
        accessible: *mut bool,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_topo_get_p2p_status(
        processor_handle_src: AmdsmiProcessorHandle,
        processor_handle_dst: AmdsmiProcessorHandle,
        type_: *mut AmdsmiIoLinkTypeT,
        cap: *mut AmdsmiP2pCapabilityT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_compute_partition(
        processor_handle: AmdsmiProcessorHandle,
        compute_partition: *mut ::std::os::raw::c_char,
        len: u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_compute_partition(
        processor_handle: AmdsmiProcessorHandle,
        compute_partition: AmdsmiComputePartitionTypeT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_memory_partition(
        processor_handle: AmdsmiProcessorHandle,
        memory_partition: *mut ::std::os::raw::c_char,
        len: u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_memory_partition(
        processor_handle: AmdsmiProcessorHandle,
        memory_partition: AmdsmiMemoryPartitionTypeT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_accelerator_partition_profile(
        processor_handle: AmdsmiProcessorHandle,
        profile: *mut AmdsmiAcceleratorPartitionProfileT,
        partition_id: *mut u32,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_init_gpu_event_notification(
        processor_handle: AmdsmiProcessorHandle,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_set_gpu_event_notification_mask(
        processor_handle: AmdsmiProcessorHandle,
        mask: u64,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_event_notification(
        timeout_ms: ::std::os::raw::c_int,
        num_elem: *mut u32,
        data: *mut AmdsmiEvtNotificationDataT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_stop_gpu_event_notification(
        processor_handle: AmdsmiProcessorHandle,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_device_bdf(
        processor_handle: AmdsmiProcessorHandle,
        bdf: *mut AmdsmiBdfT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_device_uuid(
        processor_handle: AmdsmiProcessorHandle,
        uuid_length: *mut ::std::os::raw::c_uint,
        uuid: *mut ::std::os::raw::c_char,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_driver_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiDriverInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_asic_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiAsicInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_kfd_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiKfdInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_vram_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiVramInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_board_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiBoardInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_power_cap_info(
        processor_handle: AmdsmiProcessorHandle,
        sensor_ind: u32,
        info: *mut AmdsmiPowerCapInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_pcie_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiPcieInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_xgmi_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiXgmiInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_fw_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiFwInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_vbios_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiVbiosInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_activity(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiEngineUsageT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_power_info(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiPowerInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_is_gpu_power_management_enabled(
        processor_handle: AmdsmiProcessorHandle,
        enabled: *mut bool,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_clock_info(
        processor_handle: AmdsmiProcessorHandle,
        clk_type: AmdsmiClkTypeT,
        info: *mut AmdsmiClkInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_vram_usage(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiVramUsageT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_violation_status(
        processor_handle: AmdsmiProcessorHandle,
        info: *mut AmdsmiViolationStatusT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_process_list(
        processor_handle: AmdsmiProcessorHandle,
        max_processes: *mut u32,
        list: *mut AmdsmiProcInfoT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_gpu_total_ecc_count(
        processor_handle: AmdsmiProcessorHandle,
        ec: *mut AmdsmiErrorCountT,
    ) -> AmdsmiStatusT;
}
extern "C" {
    pub fn amdsmi_get_link_topology_nearest(
        processor_handle: AmdsmiProcessorHandle,
        link_type: AmdsmiLinkTypeT,
        topology_nearest_info: *mut AmdsmiTopologyNearestT,
    ) -> AmdsmiStatusT;
}
