;; $test code for library list(written by M.Hroi)

(import "test")
(import "list")
(import "cxr")
(import "seq")
(import "combination")

;; cxr
($test (caar '((a b) (c d) (e f))) A)
($test (cadr '((a b) (c d) (e f))) (C D))
($test (cdar '((a b) (c d) (e f))) (B))
($test (cddr '((a b) (c d) (e f))) ((E F)))
;; ommited cXXXr cXXXXr
($test (first '(a b c d e f)) A)
($test (second '(a b c d e f)) B)
($test (third '(a b c d e f)) C)
($test (fourth '(a b c d e f)) D)
($test (fifth '(a b c d e f)) E)
($test (sixth '(a b c d e f g h i j)) F)
($test (seventh '(a b c d e f g h i j)) G)
($test (eigthth '(a b c d e f g h i j)) h)
($test (ninth '(a b c d e f g h i j)) i)
($test (tenth '(a b c d e f g h i j)) j)

;;list
($test (last-pair '(a b c d e f)) (F))
($test (last '(a b c d e f)) F)
($test (take '(a b c d e f) 3) (A B C))
($test (drop '(a b c d e f) 3) (D E F))
($test (take '(a b c d e f) 6) (A B C D E F))
($test (drop '(a b c d e f) 6) NIL)
($test (revappend '(a b c) '(d e f)) (C B A D E F))
($test (revappend nil '(d e f)) (D E F))
($test (revappend '(a b c) nil) (C B A))
($test (iota 1 10) (1 2 3 4 5 6 7 8 9 10))
($test (iota 1 1) (1))
($test (iota 1 0) NIL)
($test (remove-duplicates '(a b c a b c d a b c d e)) (A B C D E))
($test (remove-duplicates '(a b c d e f)) (A B C D E F))
(defun evenp (x)
    (= (mod x 2) 0) )

(defun xcons (a b)
    (cons b a) )

($test (member-if (lambda (x) (= (mod x 2) 0)) '(1 2 3 4 5 6 7 8)) (2 3 4 5 6 7 8))
($test (member-if (lambda (x) (= (mod x 2) 0)) '(1 3 5 7 9)) NIL)
($test (member-if-not (lambda (x) (= (mod x 2) 0)) '(1 2 3 4 5 6 7 8)) (1 2 3 4 5 6 7 8))
($test (member-if-not (lambda (x) (= (mod x 2) 1)) '(1 3 5 7 9)) NIL)
($test (fold-left #'+ 0 (iota 1 10)) 55)
($test (fold-right #'+ 0 (iota 1 10)) 55)
($test (fold-left (lambda (a x y) (cons (cons x y) a)) nil '(1 2 3 4) '(5 6 7 8)) ((4 . 8) (3 . 7) (2 . 6) (1 . 5)))
($test (fold-right (lambda (a x y) (cons (cons x y) a)) nil '(1 2 3 4) '(5 6 7 8)) ((1 . 5) (2 . 6) (3 . 7) (4 . 8)))
($test (partition (lambda (x) (= (mod x 2) 0)) (iota 1 10)) ((2 4 6 8 10) (1 3 5 7 9)))
($test (partition (lambda (x) (= (mod x 2) 1)) (iota 1 10)) ((1 3 5 7 9) (2 4 6 8 10)))
($test (partition (lambda (x) (<= x 5)) (iota 1 10)) ((1 2 3 4 5) (6 7 8 9 10)))
($test (partition (lambda (x) (> x 5)) (iota 1 10)) ((6 7 8 9 10) (1 2 3 4 5)))
($test (any #'< '(1 3 5) '(2 1 0)) T)
($test (any #'< '(1 3 5) '(0 1 0)) NIL)
($test (any #'evenp '(1 3 4 5)) T)
($test (any #'evenp '(1 3 5)) NIL)
($test (any (lambda (x) (<= x 5)) '(5 6 7 8 9)) T)
($test (any (lambda (x) (<= x 5)) '(6 7 8 9 10)) NIL)
($test (any #'<= '(5 6 7 8 9) '(5 4 3 2 1)) T)
($test (any #'<= '(5 6 7 8 9) '(4 3 2 1 0)) NIL)
($test (all (lambda (x) (<= 5 x)) '(5 6 7 8 9)) T)
($test (all (lambda (x) (<= 5 x)) '(5 6 7 8 0)) NIL)
($test (all #'<= '(1 2 3 4 5) '(6 7 8 9 10)) T)
($test (all #'<= '(1 2 3 4 5) '(6 7 8 9 0)) NIL)
($test (union '(1 2 3 4) '(3 4 5 6)) (1 2 3 4 5 6))
($test (intersection '(1 2 3 4) '(3 4 5 6)) (3 4))
($test (difference '(1 2 3 4) '(3 4 5 6)) (1 2))
($test (subsetp '(1 2) '(1 2 3 4)) T)
($test (subsetp '(1 2 5) '(1 2 3 4)) NIL)

;;;seq

($test (remove 'a '(a b a b c a b c d)) (B B C B C D))
($test (remove 'a #(a b a b c a b c d)) #(B B C B C D))
($test (remove #\a "ababcabcd") "bbcbcd")
($test (remove-if #'evenp '(1 2 3 4 5 6 7 8 9)) (1 3 5 7 9))
($test (remove-if-not #'evenp #(1 2 3 4 5 6 7 8 9)) #(2 4 6 8))
($test (substitute 'z 'a '(a b a b c a b c d)) (Z B Z B C Z B C D))
($test (substitute 'z 'a #(a b a b c a b c d)) #(Z B Z B C Z B C D))
($test (substitute #\z #\a "ababcabcd") "zbzbczbcd")
($test (substitute-if 0 #'evenp '(1 2 3 4 5 6 7 8 9)) (1 0 3 0 5 0 7 0 9))
($test (substitute-if-not 0 #'evenp #(1 2 3 4 5 6 7 8 9)) #(0 2 0 4 0 6 0 8 0))
($test (list->vector '(1 2 3 4 5)) #(1 2 3 4 5))
($test (list->string '(#\1 #\2 #\3 #\4 #\5)) "12345")
($test (vector->list #(1 2 3 4 5)) (1 2 3 4 5))
($test (vector->string #(#\1 #\2 #\3 #\4 #\5)) "12345")
($test (string->list "12345") (#\1 #\2 #\3 #\4 #\5))
($test (string->vector "12345") #(#\1 #\2 #\3 #\4 #\5))
($test (find 3 '(1 2 3 4 5 6 7 8)) 3)
($test (find 9 '(1 2 3 4 5 6 7 8)) NIL)
($test (find 3 #(1 2 3 4 5 6 7 8)) 3)
($test (find 9 #(1 2 3 4 5 6 7 8)) NIL)
($test (find #\3 "12345678") #\3)
($test (find #\9 "12345678") NIL)
($eval (defun evenp (x) (= (mod x 2) 0)))
($eval (defun oddp (x) (= (mod x 2) 1)))
($test (find-if #'evenp '(1 2 3 4 5 6 7 8)) 2)
($test (find-if-not #'evenp '(1 2 3 4 5 6 7 8)) 1)
($test (find-if #'evenp #(1 2 3 4 5 6 7 8)) 2)
($test (find-if-not #'evenp #(1 2 3 4 5 6 7 8)) 1)
($test (position 3 '(1 2 3 4 5 6 7 8)) 2)
($test (position 9 '(1 2 3 4 5 6 7 8)) -1)
($test (position 3 #(1 2 3 4 5 6 7 8)) 2)
($test (position 9 #(1 2 3 4 5 6 7 8)) -1)
($test (position #\3 "12345678") 2)
($test (position #\9 "12345678") -1)
($test (position-if #'oddp '(1 2 3 4 5 6 7 8)) 0)
($test (position-if-not #'oddp #(1 2 3 4 5 6 7 8)) 1)
($test (count 3 '(1 2 1 2 3 1 2 3 4)) 2)
($test (count 0 '(1 2 1 2 3 1 2 3 4)) 0)
($test (count 3 #(1 2 1 2 3 1 2 3 4)) 2)
($test (count 0 #(1 2 1 2 3 1 2 3 4)) 0)
($test (count #\3 "121231234") 2)
($test (count #\0 "121231234") 0)
($test (count-if #'evenp '(1 2 1 2 3 1 2 3 4)) 4)
($test (count-if-not #'evenp #(1 2 1 2 3 1 2 3 4)) 5)
($test (concatenate '<list> '(1 2 3 4) #(5 6 7 8) "abcd") (1 2 3 4 5 6 7 8 #\a #\b #\c #\d))
($test (concatenate '<general-vector> '(1 2 3 4) #(5 6 7 8) "abcd") #(1 2 3 4 5 6 7 8 #\a #\b #\c #\d))
($test (concatenate '<string> '(#\1 #\2 #\3 #\4) #(#\5 #\6 #\7 #\8) "abcd") "12345678abcd")
($test (map '<list> #'list '(1 2 3 4) #(5 6 7 8) "abcd") ((1 5 #\a) (2 6 #\b) (3 7 #\c) (4 8 #\d)))
($test (map '<general-vector> #'list '(1 2 3 4) #(5 6 7 8) "abcd") #((1 5 #\a) (2 6 #\b) (3 7 #\c) (4 8 #\d)) equal)
($test (map '<string> (lambda (x y) (if (char< x y) x y)) "AbCd" "aBcD") "ABCD")
($test (reduce (lambda (a x y z) (cons (list x y z) a)) nil '(1 2 3 4) #(5 6 7 8) "abcd") ((4 8 #\d) (3 7 #\c) (2 6 #\b) (1 5 #\a)))
($test (reduce-right (lambda (a x y z) (cons (list x y z) a)) nil '(1 2 3 4) #(5 6 7 8) "abcd") ((1 5 #\a) (2 6 #\b) (3 7 #\c) (4 8 #\d)))
($test (some #'evenp #(1 3 5 7 9)) NIL)
($test (some #'evenp #(1 3 5 7 8 9)) T)
($test (some #'= '(1 2 3 4) #(7 6 5 4)) T)
($test (some #'= '(1 2 3 4) #(7 6 5 8)) NIL)
($test (some #'char= "abcd" "ABCd") T)
($test (some #'char= "abcd" "ABCD") NIL)
($test (every #'oddp '(1 3 5 7 9)) T)
($test (every #'oddp '(1 3 5 7 9 10)) NIL)
($test (every #'= '(1 2 3 4) #(1 2 3 4)) T)
($test (every #'= '(1 2 3 4) #(1 2 3 5)) NIL)
($test (every #'char= "abcd" "abcd") T)
($test (every #'char= "abcd" "abcD") NIL)


;; combination
($test (selects '(1 2 3)) ((1 2 3) (2 1 3) (3 1 2)))
($test (selects '(a b c d)) ((A B C D) (B A C D) (C A B D) (D A B C)))
($test (permutations 3 '(1 2 3)) ((1 2 3) (1 3 2) (2 1 3) (2 3 1) (3 1 2) (3 2 1)))
($test (permutations 3 '(a b c d))
    ((A B C) (A B D) (A C B) (A C D) (A D B) (A D C) (B A C) (B A D) 
    (B C A) (B C D) (B D A) (B D C) (C A B) (C A D) (C B A) (C B D) 
    (C D A) (C D B) (D A B) (D A C) (D B A) (D B C) (D C A) (D C B)))
($test (permutations-with-repetition 2 '(1 2 3))
    ((1 1) (1 2) (1 3) (2 1) (2 2) (2 3) (3 1) (3 2) (3 3)))
($test (permutations-with-repetition 2 '(a b c d))
    ((A A) (A B) (A C) (A D) (B A) (B B) (B C) (B D) (C A) (C B) (C C) (C D) (D A) (D B) (D C) (D D)))
($test (combination-number 4 2) 6)
($test (combination-number 5 3) 10)
($test (combination-number 100 50) 100891344545564193334812497256)
($test (combinations 2 '(1 2 3 4))
    ((1 2) (1 3) (1 4) (2 3) (2 4) (3 4)))
($test (combinations 3 '(a b c d e))
    ((A B C) (A B D) (A B E) (A C D) (A C E) (A D E) (B C D) (B C E) (B D E) (C D E)))
($test (combinations-with-repetition 2 '(1 2 3))
    ((1 1) (1 2) (1 3) (2 2) (2 3) (3 3)))
($test (combinations-with-repetition 3 '(a b c d))
    ((A A A) (A A B) (A A C) (A A D) (A B B) (A B C) (A B D) (A C C) (A C D) (A D D) 
     (B B B) (B B C) (B B D) (B C C) (B C D) (B D D) (C C C) (C C D) (C D D) (D D D)))    
(format (standard-output) "ALl $tests are done!~%")
