// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>A content block that contains both generated text and associated citation information. This block type is returned when document citations are enabled, providing traceability between the generated content and the source documents that informed the response.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct CitationsContentBlock {
    /// <p>The generated content that is supported by the associated citations.</p>
    pub content: ::std::option::Option<::std::vec::Vec<crate::types::CitationGeneratedContent>>,
    /// <p>An array of citations that reference the source documents used to generate the associated content.</p>
    pub citations: ::std::option::Option<::std::vec::Vec<crate::types::Citation>>,
}
impl CitationsContentBlock {
    /// <p>The generated content that is supported by the associated citations.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.content.is_none()`.
    pub fn content(&self) -> &[crate::types::CitationGeneratedContent] {
        self.content.as_deref().unwrap_or_default()
    }
    /// <p>An array of citations that reference the source documents used to generate the associated content.</p>
    ///
    /// If no value was sent for this field, a default will be set. If you want to determine if no value was sent, use `.citations.is_none()`.
    pub fn citations(&self) -> &[crate::types::Citation] {
        self.citations.as_deref().unwrap_or_default()
    }
}
impl CitationsContentBlock {
    /// Creates a new builder-style object to manufacture [`CitationsContentBlock`](crate::types::CitationsContentBlock).
    pub fn builder() -> crate::types::builders::CitationsContentBlockBuilder {
        crate::types::builders::CitationsContentBlockBuilder::default()
    }
}

/// A builder for [`CitationsContentBlock`](crate::types::CitationsContentBlock).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct CitationsContentBlockBuilder {
    pub(crate) content: ::std::option::Option<::std::vec::Vec<crate::types::CitationGeneratedContent>>,
    pub(crate) citations: ::std::option::Option<::std::vec::Vec<crate::types::Citation>>,
}
impl CitationsContentBlockBuilder {
    /// Appends an item to `content`.
    ///
    /// To override the contents of this collection use [`set_content`](Self::set_content).
    ///
    /// <p>The generated content that is supported by the associated citations.</p>
    pub fn content(mut self, input: crate::types::CitationGeneratedContent) -> Self {
        let mut v = self.content.unwrap_or_default();
        v.push(input);
        self.content = ::std::option::Option::Some(v);
        self
    }
    /// <p>The generated content that is supported by the associated citations.</p>
    pub fn set_content(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::CitationGeneratedContent>>) -> Self {
        self.content = input;
        self
    }
    /// <p>The generated content that is supported by the associated citations.</p>
    pub fn get_content(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::CitationGeneratedContent>> {
        &self.content
    }
    /// Appends an item to `citations`.
    ///
    /// To override the contents of this collection use [`set_citations`](Self::set_citations).
    ///
    /// <p>An array of citations that reference the source documents used to generate the associated content.</p>
    pub fn citations(mut self, input: crate::types::Citation) -> Self {
        let mut v = self.citations.unwrap_or_default();
        v.push(input);
        self.citations = ::std::option::Option::Some(v);
        self
    }
    /// <p>An array of citations that reference the source documents used to generate the associated content.</p>
    pub fn set_citations(mut self, input: ::std::option::Option<::std::vec::Vec<crate::types::Citation>>) -> Self {
        self.citations = input;
        self
    }
    /// <p>An array of citations that reference the source documents used to generate the associated content.</p>
    pub fn get_citations(&self) -> &::std::option::Option<::std::vec::Vec<crate::types::Citation>> {
        &self.citations
    }
    /// Consumes the builder and constructs a [`CitationsContentBlock`](crate::types::CitationsContentBlock).
    pub fn build(self) -> crate::types::CitationsContentBlock {
        crate::types::CitationsContentBlock {
            content: self.content,
            citations: self.citations,
        }
    }
}
