// Code generated by software.amazon.smithy.rust.codegen.smithy-rs. DO NOT EDIT.

/// <p>The starting position in the data stream from which to start streaming.</p>
#[non_exhaustive]
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::fmt::Debug)]
pub struct StartingPosition {
    /// <p>You can set the starting position to one of the following values:</p>
    /// <p><code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number specified in the <code>SequenceNumber</code> field.</p>
    /// <p><code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence number specified in the <code>SequenceNumber</code> field.</p>
    /// <p><code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the <code>Timestamp</code> field.</p>
    /// <p><code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest data record in the shard.</p>
    /// <p><code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always read the most recent data in the shard.</p>
    pub r#type: crate::types::ShardIteratorType,
    /// <p>The sequence number of the data record in the shard from which to start streaming. To specify a sequence number, set <code>StartingPosition</code> to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>.</p>
    pub sequence_number: ::std::option::Option<::std::string::String>,
    /// <p>The time stamp of the data record from which to start reading. To specify a time stamp, set <code>StartingPosition</code> to <code>Type AT_TIMESTAMP</code>. A time stamp is the Unix epoch date with precision in milliseconds. For example, <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact time stamp does not exist, records will be streamed from the next (later) record. If the time stamp is older than the current trim horizon, records will be streamed from the oldest untrimmed data record (<code>TRIM_HORIZON</code>).</p>
    pub timestamp: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl StartingPosition {
    /// <p>You can set the starting position to one of the following values:</p>
    /// <p><code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number specified in the <code>SequenceNumber</code> field.</p>
    /// <p><code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence number specified in the <code>SequenceNumber</code> field.</p>
    /// <p><code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the <code>Timestamp</code> field.</p>
    /// <p><code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest data record in the shard.</p>
    /// <p><code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always read the most recent data in the shard.</p>
    pub fn r#type(&self) -> &crate::types::ShardIteratorType {
        &self.r#type
    }
    /// <p>The sequence number of the data record in the shard from which to start streaming. To specify a sequence number, set <code>StartingPosition</code> to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>.</p>
    pub fn sequence_number(&self) -> ::std::option::Option<&str> {
        self.sequence_number.as_deref()
    }
    /// <p>The time stamp of the data record from which to start reading. To specify a time stamp, set <code>StartingPosition</code> to <code>Type AT_TIMESTAMP</code>. A time stamp is the Unix epoch date with precision in milliseconds. For example, <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact time stamp does not exist, records will be streamed from the next (later) record. If the time stamp is older than the current trim horizon, records will be streamed from the oldest untrimmed data record (<code>TRIM_HORIZON</code>).</p>
    pub fn timestamp(&self) -> ::std::option::Option<&::aws_smithy_types::DateTime> {
        self.timestamp.as_ref()
    }
}
impl StartingPosition {
    /// Creates a new builder-style object to manufacture [`StartingPosition`](crate::types::StartingPosition).
    pub fn builder() -> crate::types::builders::StartingPositionBuilder {
        crate::types::builders::StartingPositionBuilder::default()
    }
}

/// A builder for [`StartingPosition`](crate::types::StartingPosition).
#[derive(::std::clone::Clone, ::std::cmp::PartialEq, ::std::default::Default, ::std::fmt::Debug)]
#[non_exhaustive]
pub struct StartingPositionBuilder {
    pub(crate) r#type: ::std::option::Option<crate::types::ShardIteratorType>,
    pub(crate) sequence_number: ::std::option::Option<::std::string::String>,
    pub(crate) timestamp: ::std::option::Option<::aws_smithy_types::DateTime>,
}
impl StartingPositionBuilder {
    /// <p>You can set the starting position to one of the following values:</p>
    /// <p><code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number specified in the <code>SequenceNumber</code> field.</p>
    /// <p><code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence number specified in the <code>SequenceNumber</code> field.</p>
    /// <p><code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the <code>Timestamp</code> field.</p>
    /// <p><code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest data record in the shard.</p>
    /// <p><code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always read the most recent data in the shard.</p>
    /// This field is required.
    pub fn r#type(mut self, input: crate::types::ShardIteratorType) -> Self {
        self.r#type = ::std::option::Option::Some(input);
        self
    }
    /// <p>You can set the starting position to one of the following values:</p>
    /// <p><code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number specified in the <code>SequenceNumber</code> field.</p>
    /// <p><code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence number specified in the <code>SequenceNumber</code> field.</p>
    /// <p><code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the <code>Timestamp</code> field.</p>
    /// <p><code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest data record in the shard.</p>
    /// <p><code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always read the most recent data in the shard.</p>
    pub fn set_type(mut self, input: ::std::option::Option<crate::types::ShardIteratorType>) -> Self {
        self.r#type = input;
        self
    }
    /// <p>You can set the starting position to one of the following values:</p>
    /// <p><code>AT_SEQUENCE_NUMBER</code>: Start streaming from the position denoted by the sequence number specified in the <code>SequenceNumber</code> field.</p>
    /// <p><code>AFTER_SEQUENCE_NUMBER</code>: Start streaming right after the position denoted by the sequence number specified in the <code>SequenceNumber</code> field.</p>
    /// <p><code>AT_TIMESTAMP</code>: Start streaming from the position denoted by the time stamp specified in the <code>Timestamp</code> field.</p>
    /// <p><code>TRIM_HORIZON</code>: Start streaming at the last untrimmed record in the shard, which is the oldest data record in the shard.</p>
    /// <p><code>LATEST</code>: Start streaming just after the most recent record in the shard, so that you always read the most recent data in the shard.</p>
    pub fn get_type(&self) -> &::std::option::Option<crate::types::ShardIteratorType> {
        &self.r#type
    }
    /// <p>The sequence number of the data record in the shard from which to start streaming. To specify a sequence number, set <code>StartingPosition</code> to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>.</p>
    pub fn sequence_number(mut self, input: impl ::std::convert::Into<::std::string::String>) -> Self {
        self.sequence_number = ::std::option::Option::Some(input.into());
        self
    }
    /// <p>The sequence number of the data record in the shard from which to start streaming. To specify a sequence number, set <code>StartingPosition</code> to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>.</p>
    pub fn set_sequence_number(mut self, input: ::std::option::Option<::std::string::String>) -> Self {
        self.sequence_number = input;
        self
    }
    /// <p>The sequence number of the data record in the shard from which to start streaming. To specify a sequence number, set <code>StartingPosition</code> to <code>AT_SEQUENCE_NUMBER</code> or <code>AFTER_SEQUENCE_NUMBER</code>.</p>
    pub fn get_sequence_number(&self) -> &::std::option::Option<::std::string::String> {
        &self.sequence_number
    }
    /// <p>The time stamp of the data record from which to start reading. To specify a time stamp, set <code>StartingPosition</code> to <code>Type AT_TIMESTAMP</code>. A time stamp is the Unix epoch date with precision in milliseconds. For example, <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact time stamp does not exist, records will be streamed from the next (later) record. If the time stamp is older than the current trim horizon, records will be streamed from the oldest untrimmed data record (<code>TRIM_HORIZON</code>).</p>
    pub fn timestamp(mut self, input: ::aws_smithy_types::DateTime) -> Self {
        self.timestamp = ::std::option::Option::Some(input);
        self
    }
    /// <p>The time stamp of the data record from which to start reading. To specify a time stamp, set <code>StartingPosition</code> to <code>Type AT_TIMESTAMP</code>. A time stamp is the Unix epoch date with precision in milliseconds. For example, <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact time stamp does not exist, records will be streamed from the next (later) record. If the time stamp is older than the current trim horizon, records will be streamed from the oldest untrimmed data record (<code>TRIM_HORIZON</code>).</p>
    pub fn set_timestamp(mut self, input: ::std::option::Option<::aws_smithy_types::DateTime>) -> Self {
        self.timestamp = input;
        self
    }
    /// <p>The time stamp of the data record from which to start reading. To specify a time stamp, set <code>StartingPosition</code> to <code>Type AT_TIMESTAMP</code>. A time stamp is the Unix epoch date with precision in milliseconds. For example, <code>2016-04-04T19:58:46.480-00:00</code> or <code>1459799926.480</code>. If a record with this exact time stamp does not exist, records will be streamed from the next (later) record. If the time stamp is older than the current trim horizon, records will be streamed from the oldest untrimmed data record (<code>TRIM_HORIZON</code>).</p>
    pub fn get_timestamp(&self) -> &::std::option::Option<::aws_smithy_types::DateTime> {
        &self.timestamp
    }
    /// Consumes the builder and constructs a [`StartingPosition`](crate::types::StartingPosition).
    /// This method will fail if any of the following fields are not set:
    /// - [`r#type`](crate::types::builders::StartingPositionBuilder::type)
    pub fn build(self) -> ::std::result::Result<crate::types::StartingPosition, ::aws_smithy_types::error::operation::BuildError> {
        ::std::result::Result::Ok(crate::types::StartingPosition {
            r#type: self.r#type.ok_or_else(|| {
                ::aws_smithy_types::error::operation::BuildError::missing_field(
                    "r#type",
                    "r#type was not specified but it is required when building StartingPosition",
                )
            })?,
            sequence_number: self.sequence_number,
            timestamp: self.timestamp,
        })
    }
}
