/* -*- Mode: C++; tab-width: 8; indent-tabs-mode: nil; c-basic-offset: 2 -*- */
/* vim: set ts=8 sts=2 et sw=2 tw=80: */
/* This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/. */

#include "nsNSSIOLayer.h"
#include "sslproto.h"
#include "sslerr.h"

#include "nsICertStorage.h"
#include "cert_storage/src/cert_storage.h"
#include "nsServiceManagerUtils.h"

#include "nsString.h"
#include "mozilla/Attributes.h"

#include "gtest/gtest.h"

/* The following buffers are generated by encoding a sequence of integers from
   0 to 100 using the corresponding encoding mechanism.

  They could be re-generated using the following script:

  generateZlibBuf():
    import zlib
    import brotli
    import zstd

    for i in range(100):
      a.append(i)

    encodedBufferExampleZlib = list(zlib.compress(bytes(a)))
    encodedBufferExampleBrotli = list(brotli.compress(bytes(a)))
    encodedBufferExampleZstd = list(zstd.compress(bytes(a)))
*/

uint8_t encodedBufferExampleZlib[108] = {
    0x78, 0x9c, 0x63, 0x60, 0x64, 0x62, 0x66, 0x61, 0x65, 0x63, 0xe7, 0xe0,
    0xe4, 0xe2, 0xe6, 0xe1, 0xe5, 0xe3, 0x17, 0x10, 0x14, 0x12, 0x16, 0x11,
    0x15, 0x13, 0x97, 0x90, 0x94, 0x92, 0x96, 0x91, 0x95, 0x93, 0x57, 0x50,
    0x54, 0x52, 0x56, 0x51, 0x55, 0x53, 0xd7, 0xd0, 0xd4, 0xd2, 0xd6, 0xd1,
    0xd5, 0xd3, 0x37, 0x30, 0x34, 0x32, 0x36, 0x31, 0x35, 0x33, 0xb7, 0xb0,
    0xb4, 0xb2, 0xb6, 0xb1, 0xb5, 0xb3, 0x77, 0x70, 0x74, 0x72, 0x76, 0x71,
    0x75, 0x73, 0xf7, 0xf0, 0xf4, 0xf2, 0xf6, 0xf1, 0xf5, 0xf3, 0x0f, 0x08,
    0x0c, 0x0a, 0x0e, 0x09, 0x0d, 0x0b, 0x8f, 0x88, 0x8c, 0x8a, 0x8e, 0x89,
    0x8d, 0x8b, 0x4f, 0x48, 0x4c, 0x4a, 0x06, 0x00, 0x8b, 0x7c, 0x13, 0x57,
};

uint8_t encodedBufferExampleBrotli[73] = {
    0x1b, 0x63, 0x0,  0xe8, 0x65, 0x60, 0x9e, 0x29, 0x8f, 0xd2, 0x59,
    0x86, 0xc8, 0x54, 0x48, 0x4c, 0xb0, 0x89, 0x63, 0x77, 0x7f, 0x0,
    0x40, 0x8,  0x46, 0x50, 0xc,  0x27, 0x48, 0x8a, 0x66, 0x58, 0x8e,
    0x17, 0x44, 0x49, 0x56, 0x54, 0x4d, 0x37, 0x4c, 0xcb, 0x76, 0x5c,
    0xcf, 0xf,  0xc2, 0x28, 0x4e, 0xd2, 0x2c, 0x2f, 0xca, 0xaa, 0x6e,
    0xda, 0xae, 0x1f, 0xc6, 0x69, 0x5e, 0xd6, 0x6d, 0x3f, 0xce, 0xeb,
    0x7e, 0x5e, 0xef, 0xcf, 0xf7, 0xf7, 0x7};

uint8_t encodedBufferExampleZstd[113] = {
    0x28, 0xb5, 0x2f, 0xfd, 0x24, 0x64, 0x21, 0x03, 0x00, 0x00, 0x01, 0x02,
    0x03, 0x04, 0x05, 0x06, 0x07, 0x08, 0x09, 0x0a, 0x0b, 0x0c, 0x0d, 0x0e,
    0x0f, 0x10, 0x11, 0x12, 0x13, 0x14, 0x15, 0x16, 0x17, 0x18, 0x19, 0x1a,
    0x1b, 0x1c, 0x1d, 0x1e, 0x1f, 0x20, 0x21, 0x22, 0x23, 0x24, 0x25, 0x26,
    0x27, 0x28, 0x29, 0x2a, 0x2b, 0x2c, 0x2d, 0x2e, 0x2f, 0x30, 0x31, 0x32,
    0x33, 0x34, 0x35, 0x36, 0x37, 0x38, 0x39, 0x3a, 0x3b, 0x3c, 0x3d, 0x3e,
    0x3f, 0x40, 0x41, 0x42, 0x43, 0x44, 0x45, 0x46, 0x47, 0x48, 0x49, 0x4a,
    0x4b, 0x4c, 0x4d, 0x4e, 0x4f, 0x50, 0x51, 0x52, 0x53, 0x54, 0x55, 0x56,
    0x57, 0x58, 0x59, 0x5a, 0x5b, 0x5c, 0x5d, 0x5e, 0x5f, 0x60, 0x61, 0x62,
    0x63, 0x97, 0x65, 0x16, 0x32};

// Test case using mozilla.org and generated using abridged-certs-rs
uint8_t encodedBufferExampleAbridged[1145] = {
    0x41, 0xdc, 0x13, 0x00, 0x30, 0xc3, 0xd3, 0xcd, 0x3f, 0x75, 0x13, 0xf4,
    0x6a, 0x6b, 0x60, 0x03, 0xe9, 0x4f, 0x61, 0xf0, 0xa6, 0xae, 0xa7, 0x1e,
    0x86, 0x19, 0x87, 0xff, 0xe8, 0xd5, 0xf8, 0x11, 0x07, 0x98, 0xe0, 0x3b,
    0xf4, 0x05, 0x32, 0x0b, 0x0c, 0xc3, 0xd2, 0x6d, 0x0e, 0xc4, 0x3e, 0x23,
    0x28, 0xb5, 0x02, 0x95, 0xde, 0x6e, 0x04, 0x41, 0xd8, 0x17, 0x08, 0x7b,
    0x0e, 0x0a, 0xb0, 0xc7, 0xa0, 0x00, 0x3d, 0xdd, 0x87, 0x22, 0x30, 0x82,
    0xb0, 0x62, 0xb9, 0xb4, 0x67, 0x25, 0x4d, 0x53, 0x5b, 0x57, 0x06, 0xaa,
    0x75, 0xdf, 0xdf, 0x11, 0xe9, 0x8d, 0x7e, 0x09, 0x18, 0x70, 0x1a, 0xd9,
    0x12, 0xb3, 0x92, 0xef, 0x0c, 0x30, 0x4c, 0x47, 0x80, 0x00, 0x89, 0x48,
    0x07, 0x68, 0x70, 0xd4, 0x19, 0xc3, 0xd9, 0x10, 0x67, 0x47, 0x22, 0x27,
    0x60, 0x97, 0x5e, 0x5a, 0x36, 0x06, 0xab, 0xe0, 0x24, 0xa9, 0x44, 0x61,
    0xe3, 0x98, 0xc0, 0x84, 0xf4, 0xb8, 0x24, 0x43, 0x80, 0x2e, 0x71, 0x50,
    0x06, 0x82, 0x5c, 0x0c, 0x24, 0x15, 0x40, 0x22, 0x92, 0x01, 0x50, 0x21,
    0x01, 0x55, 0x0f, 0xc1, 0xc8, 0x09, 0xb2, 0x07, 0xe0, 0x24, 0xb2, 0x03,
    0x56, 0x17, 0x8e, 0x2e, 0x89, 0xa8, 0xba, 0x2a, 0x80, 0x02, 0x58, 0xf4,
    0x0a, 0x00, 0x8e, 0xd0, 0x02, 0x98, 0x09, 0xd2, 0x99, 0xb4, 0x48, 0x01,
    0xfd, 0x5e, 0xe8, 0xa4, 0xc5, 0x83, 0xbb, 0x99, 0x1f, 0x27, 0xfa, 0x0a,
    0x3c, 0xd8, 0xfc, 0xdf, 0x41, 0xd6, 0x20, 0x8f, 0xbd, 0xfc, 0x54, 0x67,
    0x7a, 0xd5, 0x90, 0xf4, 0xbc, 0x44, 0x26, 0x89, 0x48, 0x7d, 0xcf, 0x88,
    0xc6, 0xb1, 0xb1, 0xf0, 0x4a, 0xc7, 0xcc, 0x3f, 0x72, 0xcd, 0xa9, 0x06,
    0xc6, 0x67, 0xef, 0x98, 0xb5, 0x28, 0x7a, 0x1b, 0x09, 0x5d, 0xa9, 0xce,
    0x96, 0xc1, 0x43, 0x9b, 0x87, 0xec, 0x17, 0x36, 0x9e, 0x08, 0xf3, 0x9a,
    0xc4, 0x95, 0x9d, 0x5a, 0x85, 0x4e, 0xe6, 0xe9, 0x5c, 0xff, 0xe8, 0x12,
    0xb0, 0xfc, 0x83, 0x2a, 0x6a, 0xf5, 0xe7, 0xda, 0xdd, 0x3f, 0xc4, 0xe5,
    0xfb, 0x2a, 0x2d, 0xcf, 0xe0, 0xdf, 0x5f, 0xb4, 0x1d, 0xbf, 0xcf, 0xba,
    0xf0, 0xb6, 0xdc, 0x4e, 0x92, 0x29, 0x7d, 0x72, 0xa6, 0x7c, 0xa4, 0x36,
    0xf3, 0x9a, 0xad, 0x6f, 0x30, 0x9f, 0x9f, 0x6b, 0xdd, 0x8d, 0x9c, 0x97,
    0x76, 0x0d, 0xaa, 0xcc, 0x57, 0x6d, 0x0e, 0xf3, 0x50, 0xdf, 0x85, 0x63,
    0x8f, 0xcc, 0xdf, 0x58, 0x61, 0x53, 0xc8, 0xff, 0x25, 0xa6, 0x93, 0x9f,
    0xdc, 0x6d, 0x79, 0x34, 0xcb, 0x2f, 0xdd, 0x60, 0x8d, 0x3b, 0xc8, 0x20,
    0xbc, 0xbb, 0x69, 0xec, 0x27, 0xf8, 0xb4, 0x30, 0x9f, 0x72, 0xa7, 0x2b,
    0x87, 0xf8, 0x64, 0xe0, 0x50, 0xf8, 0x71, 0xe9, 0x14, 0x5b, 0x4a, 0xd7,
    0x03, 0xc1, 0x75, 0x13, 0x5d, 0x41, 0xfa, 0x97, 0xde, 0xc5, 0xeb, 0x1b,
    0xb1, 0x36, 0xd2, 0xe7, 0xff, 0xe6, 0x49, 0x9e, 0x49, 0x7d, 0x9d, 0x20,
    0x7f, 0x89, 0x55, 0xf5, 0x51, 0xfe, 0x12, 0x83, 0xc8, 0xd3, 0xd1, 0x75,
    0x2a, 0x82, 0xc7, 0x3d, 0x56, 0x7e, 0x4b, 0x7a, 0x11, 0xa7, 0x9a, 0x9a,
    0xfe, 0xdf, 0xbf, 0x18, 0x9f, 0x55, 0x5c, 0x0c, 0x27, 0x0b, 0x53, 0xeb,
    0x90, 0x28, 0x32, 0xa2, 0xe9, 0xf9, 0x15, 0x1d, 0x4f, 0xce, 0xf5, 0x22,
    0x28, 0x0c, 0xc1, 0x83, 0x05, 0x08, 0x03, 0x28, 0x40, 0x68, 0x00, 0x23,
    0x8e, 0x3a, 0x0b, 0x30, 0xc1, 0xf0, 0x7f, 0x0c, 0x43, 0x11, 0x42, 0x1f,
    0x10, 0x60, 0x59, 0x02, 0x8b, 0x52, 0x9e, 0x5a, 0x0e, 0x87, 0x09, 0x04,
    0x2a, 0x14, 0x9e, 0xd9, 0x08, 0xa0, 0x37, 0xa1, 0xd9, 0x5c, 0x5c, 0x04,
    0x40, 0x0d, 0x30, 0xce, 0xc6, 0xd8, 0x93, 0xf8, 0x48, 0x03, 0x27, 0x45,
    0xe8, 0x8b, 0x6c, 0xbb, 0x2d, 0x47, 0xcc, 0xce, 0xcf, 0x17, 0x5c, 0x68,
    0xd6, 0xb5, 0x04, 0x42, 0xb8, 0x26, 0x86, 0x71, 0x03, 0xce, 0x3c, 0x76,
    0x76, 0xc5, 0x45, 0xae, 0x55, 0x37, 0x97, 0xd3, 0x33, 0x76, 0x34, 0x94,
    0x67, 0x42, 0xb3, 0xdd, 0x95, 0xec, 0x07, 0xc7, 0x80, 0xf3, 0xee, 0x19,
    0x18, 0xc6, 0xcc, 0x81, 0x29, 0x10, 0x59, 0xf3, 0x00, 0x5c, 0xc2, 0xf1,
    0xf2, 0xfb, 0x09, 0xca, 0x8a, 0xb1, 0xbf, 0x8a, 0x55, 0x02, 0x13, 0x22,
    0x2c, 0x88, 0x9a, 0x91, 0x90, 0x12, 0x4e, 0x5c, 0xb8, 0xad, 0x04, 0x38,
    0xcf, 0x2e, 0x65, 0xc1, 0x98, 0x00, 0x43, 0x41, 0x76, 0xd0, 0x6c, 0xba,
    0x2a, 0x61, 0x8c, 0x1e, 0xd0, 0x02, 0x6a, 0x1c, 0x0f, 0xcd, 0xa7, 0x87,
    0x11, 0xb8, 0xbf, 0x0b, 0x86, 0xd3, 0xca, 0xe1, 0x30, 0x06, 0x5f, 0x4b,
    0x47, 0x30, 0x04, 0xcb, 0xff, 0x8a, 0xe5, 0x7f, 0x82, 0x3e, 0x40, 0x29,
    0xd0, 0xbb, 0xb3, 0x17, 0x82, 0xae, 0xde, 0xe6, 0x3d, 0x77, 0xd4, 0x6b,
    0xb5, 0x7b, 0xe9, 0x2c, 0xdb, 0x00, 0xa9, 0xd4, 0x24, 0x6b, 0xeb, 0xcd,
    0xbd, 0x43, 0x7b, 0x33, 0x77, 0x93, 0x78, 0xa1, 0xe5, 0x4e, 0x08, 0x82,
    0xab, 0x27, 0xa2, 0xbb, 0x58, 0x20, 0x08, 0x43, 0x21, 0x53, 0x60, 0x8c,
    0x08, 0x87, 0xf6, 0x10, 0x62, 0xcb, 0x97, 0x6a, 0x3b, 0xe6, 0xde, 0x2e,
    0xaf, 0x30, 0x66, 0x7a, 0xe0, 0xd2, 0xaf, 0xd4, 0xc5, 0xa6, 0x4b, 0xfe,
    0x4f, 0x2b, 0x9b, 0xf6, 0x2d, 0x09, 0x34, 0xfc, 0xcc, 0x44, 0x44, 0xa0,
    0x6f, 0x13, 0xc5, 0x27, 0xf8, 0xfa, 0x5f, 0xdc, 0xd0, 0x89, 0x11, 0x5d,
    0xab, 0xfb, 0xb9, 0x21, 0x9e, 0x3c, 0x3a, 0x1d, 0xf0, 0xad, 0xf3, 0x7f,
    0x56, 0x42, 0xe9, 0x59, 0xeb, 0xa1, 0x89, 0x03, 0x03, 0x3a, 0xac, 0xe5,
    0x98, 0x9a, 0xac, 0xab, 0xb0, 0x9e, 0x67, 0x53, 0x09, 0x3c, 0xf1, 0x7f,
    0x14, 0xad, 0xd0, 0x1b, 0xb6, 0x87, 0x5f, 0x8e, 0x6f, 0x43, 0x0c, 0x0a,
    0x09, 0xb1, 0x0f, 0x7f, 0x5d, 0xe1, 0x02, 0xa1, 0xe7, 0xc8, 0x6a, 0xd6,
    0xae, 0xa1, 0x83, 0x3b, 0x7d, 0x1c, 0xe2, 0xed, 0x2b, 0x9a, 0x1d, 0x0d,
    0xcf, 0xbb, 0x6f, 0x7d, 0x94, 0x19, 0x57, 0xbc, 0x63, 0xdd, 0xeb, 0xc3,
    0xf2, 0x34, 0xdd, 0x65, 0x28, 0xb5, 0xf3, 0x1f, 0x9e, 0x1e, 0xf8, 0x4d,
    0xff, 0x4b, 0xeb, 0x2b, 0xad, 0xfd, 0x35, 0x87, 0x8b, 0x26, 0x4f, 0x18,
    0x9f, 0xd0, 0x97, 0xb5, 0x24, 0x8b, 0x57, 0xf1, 0xea, 0xdc, 0x78, 0x8d,
    0xb3, 0x0a, 0xfc, 0xbb, 0xe6, 0x52, 0x36, 0x08, 0xdd, 0x17, 0x84, 0x21,
    0x9f, 0xa2, 0x85, 0xc7, 0x0d, 0xbc, 0x9b, 0xd8, 0x0d, 0x9a, 0x67, 0xf6,
    0x6e, 0x93, 0x63, 0xc0, 0xb4, 0xf8, 0xd5, 0x89, 0xcb, 0xa2, 0x6d, 0x1c,
    0xf1, 0xfb, 0xdf, 0x7d, 0x54, 0x1f, 0x7d, 0xff, 0xfa, 0xdc, 0xec, 0x8c,
    0x16, 0xaf, 0xac, 0xc1, 0xaa, 0xbc, 0x8c, 0xb4, 0xf9, 0xe7, 0x63, 0x71,
    0x75, 0x11, 0x93, 0xd5, 0xc5, 0x49, 0xcd, 0x32, 0x3f, 0x82, 0x74, 0x1c,
    0xfe, 0xb6, 0x29, 0x2f, 0xb5, 0x4c, 0x1e, 0xd5, 0x5e, 0x51, 0x61, 0x94,
    0xfb, 0x54, 0x43, 0xda, 0x6e, 0xfd, 0xfe, 0x2a, 0x3c, 0x79, 0x35, 0xeb,
    0x88, 0xec, 0x2f, 0x97, 0x7b, 0x65, 0xe7, 0xd4, 0xfc, 0x07, 0x44, 0x12,
    0x05, 0xce, 0x50, 0x05, 0xb7, 0x4e, 0x2c, 0x48, 0x37, 0x3e, 0x20, 0x1b,
    0x5e, 0x69, 0x38, 0x62, 0x11, 0x62, 0x7e, 0x56, 0x9b, 0xca, 0x18, 0xb5,
    0x9b, 0x8e, 0xe1, 0x48, 0x8b, 0x30, 0x3c, 0xff, 0xed, 0xdc, 0x00, 0xff,
    0x0f, 0x69, 0xf8, 0xb9, 0x99, 0x59, 0xbf, 0x59, 0xff, 0xae, 0xb2, 0x96,
    0x48, 0xcc, 0xcf, 0xbf, 0x79, 0xc2, 0x39, 0x95, 0xf1, 0x4a, 0xc2, 0xeb,
    0xaa, 0x97, 0x29, 0x2e, 0x72, 0xf9, 0xcb, 0x7f, 0x6f, 0x03, 0xe9, 0xcb,
    0xef, 0x1f, 0x88, 0x69, 0x86, 0x3c, 0x67, 0x97, 0x7c, 0xe8, 0x4c, 0x7f,
    0xbc, 0xe5, 0x3c, 0x46, 0x6c, 0xeb, 0xa2, 0x14, 0x3f, 0xa1, 0xfd, 0xce,
    0x92, 0x25, 0x9d, 0xfe, 0x32, 0xfd, 0x94, 0x96, 0x47, 0xb8, 0x04, 0x75,
    0x0b, 0xda, 0x77, 0xb4, 0x17, 0xa7, 0x56, 0xe3, 0xbf, 0x3e, 0x3d, 0xee,
    0x15, 0xc6, 0xc6, 0x77, 0x6a, 0x0f, 0x0d, 0xe5, 0x90, 0x79, 0xfd, 0xef,
    0xd6, 0xcb, 0x78, 0x89, 0x11, 0xf7, 0xb4, 0x07, 0x72, 0x5d, 0x3b, 0x0e,
    0x1c, 0x9a, 0xbb, 0x94, 0x8d, 0xb4, 0x6c, 0xf2, 0x83, 0x9c, 0xc5, 0x25,
    0xfe, 0xf3, 0x30, 0x03, 0x4f, 0x70, 0x97, 0x17, 0x34, 0xc4, 0xd0, 0xff,
    0x98, 0x09, 0x04, 0x19, 0x03};

uint8_t decodedBufferExampleAbridged[2575] = {
    0x00, 0x00, 0x0a, 0x0b, 0x00, 0x04, 0xe7, 0x30, 0x82, 0x04, 0xe3, 0x30,
    0x82, 0x03, 0xcb, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x12, 0x04, 0x7f,
    0x0a, 0xcd, 0x26, 0x47, 0x77, 0x97, 0xb6, 0xa2, 0x8d, 0x3e, 0xef, 0xdc,
    0x21, 0x9f, 0x6d, 0xe9, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86,
    0xf7, 0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x32, 0x31, 0x0b, 0x30,
    0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x16,
    0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x0d, 0x4c, 0x65, 0x74,
    0x27, 0x73, 0x20, 0x45, 0x6e, 0x63, 0x72, 0x79, 0x70, 0x74, 0x31, 0x0b,
    0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x02, 0x52, 0x33, 0x30,
    0x1e, 0x17, 0x0d, 0x32, 0x34, 0x30, 0x32, 0x31, 0x35, 0x30, 0x30, 0x34,
    0x32, 0x30, 0x36, 0x5a, 0x17, 0x0d, 0x32, 0x34, 0x30, 0x35, 0x31, 0x35,
    0x30, 0x30, 0x34, 0x32, 0x30, 0x35, 0x5a, 0x30, 0x16, 0x31, 0x14, 0x30,
    0x12, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13, 0x0b, 0x6d, 0x6f, 0x7a, 0x69,
    0x6c, 0x6c, 0x61, 0x2e, 0x6f, 0x72, 0x67, 0x30, 0x82, 0x01, 0x22, 0x30,
    0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01,
    0x05, 0x00, 0x03, 0x82, 0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02,
    0x82, 0x01, 0x01, 0x00, 0xc9, 0x4a, 0xe0, 0xdd, 0x7b, 0xf1, 0xaa, 0xa0,
    0x82, 0x5a, 0x13, 0x61, 0xee, 0x00, 0x4d, 0x30, 0x80, 0x14, 0x89, 0xca,
    0x9b, 0x79, 0x8c, 0xa4, 0x28, 0xb1, 0x25, 0x7b, 0x32, 0x31, 0x08, 0xde,
    0x44, 0x09, 0x53, 0x93, 0x83, 0xd4, 0x9a, 0xae, 0xfe, 0x35, 0x8e, 0xca,
    0x92, 0x0e, 0xe6, 0xee, 0x10, 0x3b, 0x40, 0x3f, 0xba, 0x72, 0x9c, 0x77,
    0x55, 0x4b, 0x65, 0xa4, 0xbb, 0xc3, 0x14, 0xd0, 0xba, 0xe4, 0x20, 0x1a,
    0x46, 0x70, 0x88, 0xca, 0xb7, 0x00, 0xc9, 0x80, 0x3d, 0xd7, 0xf1, 0x56,
    0x62, 0xb5, 0xf8, 0x07, 0x6c, 0xb7, 0xf9, 0xb8, 0xdd, 0xfc, 0x31, 0xb5,
    0xdf, 0x34, 0x96, 0xe6, 0x01, 0xfb, 0xf4, 0x3c, 0x53, 0xf7, 0xaf, 0x56,
    0x1a, 0x96, 0xdb, 0x74, 0x29, 0x87, 0xe4, 0xcc, 0x89, 0xa6, 0x8f, 0x7b,
    0xd6, 0x4f, 0x5f, 0x65, 0x1b, 0x60, 0x57, 0x90, 0xd8, 0x7e, 0xe9, 0x50,
    0x92, 0x36, 0x10, 0xd5, 0x4e, 0xc3, 0x80, 0x03, 0x5f, 0xb2, 0xc6, 0xe2,
    0x49, 0xec, 0x4c, 0x04, 0xac, 0x02, 0xff, 0xb4, 0x0f, 0xc9, 0xf2, 0x59,
    0x4f, 0x19, 0x3a, 0x89, 0xd2, 0xd8, 0x12, 0x70, 0xc2, 0x7a, 0x05, 0xee,
    0xd9, 0x45, 0x60, 0x1e, 0xe5, 0x83, 0x81, 0x40, 0xdc, 0x9c, 0x7e, 0x31,
    0xe4, 0xa2, 0xc3, 0x20, 0xe3, 0x87, 0xac, 0x13, 0x76, 0x9c, 0xe0, 0x1e,
    0xb9, 0x46, 0x3e, 0x1e, 0x0c, 0xe9, 0x5d, 0x85, 0xb9, 0xba, 0x6f, 0x4e,
    0x28, 0xcf, 0xfd, 0x80, 0x26, 0xcc, 0x77, 0xeb, 0x72, 0x2c, 0xd2, 0x12,
    0x36, 0xe2, 0x81, 0xb4, 0x0d, 0x21, 0xe5, 0xa7, 0xb9, 0x07, 0x05, 0x5a,
    0xde, 0x12, 0x1c, 0x4b, 0x0c, 0x21, 0x54, 0x8e, 0x8e, 0xa1, 0xfb, 0xfa,
    0x0e, 0xe6, 0x8a, 0xd1, 0x69, 0x35, 0x20, 0x08, 0x3d, 0x32, 0x40, 0x29,
    0x22, 0x79, 0x81, 0x8a, 0x9a, 0xe4, 0xce, 0x9f, 0x02, 0x03, 0x01, 0x00,
    0x01, 0xa3, 0x82, 0x02, 0x0d, 0x30, 0x82, 0x02, 0x09, 0x30, 0x0e, 0x06,
    0x03, 0x55, 0x1d, 0x0f, 0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x05,
    0xa0, 0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x25, 0x04, 0x16, 0x30, 0x14,
    0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05, 0x07, 0x03, 0x01, 0x06, 0x08,
    0x2b, 0x06, 0x01, 0x05, 0x05, 0x07, 0x03, 0x02, 0x30, 0x0c, 0x06, 0x03,
    0x55, 0x1d, 0x13, 0x01, 0x01, 0xff, 0x04, 0x02, 0x30, 0x00, 0x30, 0x1d,
    0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x74, 0x1b, 0x32,
    0xa2, 0xc9, 0x21, 0x0c, 0x84, 0x4f, 0x9d, 0x4b, 0xa6, 0x48, 0xcf, 0xb1,
    0x82, 0xd0, 0x95, 0x3e, 0x4b, 0x30, 0x1f, 0x06, 0x03, 0x55, 0x1d, 0x23,
    0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x14, 0x2e, 0xb3, 0x17, 0xb7, 0x58,
    0x56, 0xcb, 0xae, 0x50, 0x09, 0x40, 0xe6, 0x1f, 0xaf, 0x9d, 0x8b, 0x14,
    0xc2, 0xc6, 0x30, 0x55, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05, 0x05, 0x07,
    0x01, 0x01, 0x04, 0x49, 0x30, 0x47, 0x30, 0x21, 0x06, 0x08, 0x2b, 0x06,
    0x01, 0x05, 0x05, 0x07, 0x30, 0x01, 0x86, 0x15, 0x68, 0x74, 0x74, 0x70,
    0x3a, 0x2f, 0x2f, 0x72, 0x33, 0x2e, 0x6f, 0x2e, 0x6c, 0x65, 0x6e, 0x63,
    0x72, 0x2e, 0x6f, 0x72, 0x67, 0x30, 0x22, 0x06, 0x08, 0x2b, 0x06, 0x01,
    0x05, 0x05, 0x07, 0x30, 0x02, 0x86, 0x16, 0x68, 0x74, 0x74, 0x70, 0x3a,
    0x2f, 0x2f, 0x72, 0x33, 0x2e, 0x69, 0x2e, 0x6c, 0x65, 0x6e, 0x63, 0x72,
    0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x30, 0x16, 0x06, 0x03, 0x55, 0x1d, 0x11,
    0x04, 0x0f, 0x30, 0x0d, 0x82, 0x0b, 0x6d, 0x6f, 0x7a, 0x69, 0x6c, 0x6c,
    0x61, 0x2e, 0x6f, 0x72, 0x67, 0x30, 0x13, 0x06, 0x03, 0x55, 0x1d, 0x20,
    0x04, 0x0c, 0x30, 0x0a, 0x30, 0x08, 0x06, 0x06, 0x67, 0x81, 0x0c, 0x01,
    0x02, 0x01, 0x30, 0x82, 0x01, 0x04, 0x06, 0x0a, 0x2b, 0x06, 0x01, 0x04,
    0x01, 0xd6, 0x79, 0x02, 0x04, 0x02, 0x04, 0x81, 0xf5, 0x04, 0x81, 0xf2,
    0x00, 0xf0, 0x00, 0x76, 0x00, 0xee, 0xcd, 0xd0, 0x64, 0xd5, 0xdb, 0x1a,
    0xce, 0xc5, 0x5c, 0xb7, 0x9d, 0xb4, 0xcd, 0x13, 0xa2, 0x32, 0x87, 0x46,
    0x7c, 0xbc, 0xec, 0xde, 0xc3, 0x51, 0x48, 0x59, 0x46, 0x71, 0x1f, 0xb5,
    0x9b, 0x00, 0x00, 0x01, 0x8d, 0xaa, 0x6d, 0x9c, 0x11, 0x00, 0x00, 0x04,
    0x03, 0x00, 0x47, 0x30, 0x45, 0x02, 0x20, 0x67, 0x9e, 0x05, 0x6f, 0x89,
    0xb4, 0x8f, 0x9a, 0xb0, 0xed, 0xb5, 0xb6, 0x0e, 0x7b, 0x5a, 0x06, 0x28,
    0xea, 0x38, 0x23, 0xad, 0x86, 0xff, 0xad, 0x33, 0x47, 0xa0, 0xb4, 0x1d,
    0x92, 0xf9, 0x7b, 0x02, 0x21, 0x00, 0xf6, 0xaa, 0x85, 0xc8, 0x1b, 0xa1,
    0xe8, 0xd8, 0x3d, 0x6e, 0x22, 0xb8, 0x90, 0xf9, 0xba, 0x24, 0x75, 0xa7,
    0xad, 0x62, 0xf6, 0x9b, 0xff, 0x7c, 0x72, 0x87, 0xcd, 0x4d, 0xa4, 0xaa,
    0xc2, 0x42, 0x00, 0x76, 0x00, 0x3b, 0x53, 0x77, 0x75, 0x3e, 0x2d, 0xb9,
    0x80, 0x4e, 0x8b, 0x30, 0x5b, 0x06, 0xfe, 0x40, 0x3b, 0x67, 0xd8, 0x4f,
    0xc3, 0xf4, 0xc7, 0xbd, 0x00, 0x0d, 0x2d, 0x72, 0x6f, 0xe1, 0xfa, 0xd4,
    0x17, 0x00, 0x00, 0x01, 0x8d, 0xaa, 0x6d, 0x9e, 0xc4, 0x00, 0x00, 0x04,
    0x03, 0x00, 0x47, 0x30, 0x45, 0x02, 0x20, 0x12, 0x9c, 0xa4, 0xc2, 0xdc,
    0xa0, 0x15, 0x24, 0x99, 0xb6, 0x3a, 0x9a, 0x92, 0xe7, 0x9d, 0xda, 0xf1,
    0x29, 0xa9, 0x2e, 0xdc, 0x4d, 0x9f, 0x5e, 0x11, 0xe5, 0x79, 0x56, 0xa4,
    0x77, 0x9b, 0xfe, 0x02, 0x21, 0x00, 0xa2, 0xfb, 0x0c, 0xfa, 0x3b, 0xf5,
    0x0a, 0x51, 0xd6, 0x52, 0xd1, 0x46, 0xe4, 0x0e, 0xe4, 0x0c, 0x88, 0x96,
    0x75, 0x24, 0x8c, 0x1a, 0x3d, 0xd8, 0xeb, 0x06, 0x12, 0x1d, 0xfe, 0xd6,
    0x56, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d,
    0x01, 0x01, 0x0b, 0x05, 0x00, 0x03, 0x82, 0x01, 0x01, 0x00, 0x5e, 0x84,
    0xb2, 0xe3, 0x92, 0x1a, 0xbb, 0x04, 0xd8, 0x09, 0xe6, 0x51, 0x58, 0xab,
    0xa8, 0x30, 0x47, 0x85, 0xea, 0xc8, 0xd3, 0x22, 0x98, 0x15, 0x71, 0xc1,
    0xf7, 0x5e, 0x36, 0xe2, 0xf7, 0xf5, 0xe7, 0x48, 0xcc, 0x3b, 0x1a, 0x2a,
    0x42, 0xb7, 0x2c, 0x29, 0x28, 0x49, 0xf3, 0xc6, 0x70, 0x90, 0x6a, 0xab,
    0x8d, 0x85, 0x74, 0x95, 0x29, 0xf8, 0x64, 0x3d, 0x52, 0xfd, 0x98, 0x33,
    0xb4, 0x96, 0xab, 0xc5, 0x3c, 0xb6, 0x34, 0x0e, 0x2b, 0xf2, 0x8e, 0x32,
    0xbd, 0x97, 0xf7, 0xea, 0x69, 0x75, 0xb7, 0x7c, 0xc4, 0x2a, 0xfa, 0x56,
    0xde, 0x88, 0xce, 0x37, 0x61, 0xa2, 0x21, 0x73, 0x1d, 0xcc, 0x07, 0x65,
    0x97, 0xaa, 0xb2, 0x28, 0x93, 0xe0, 0x35, 0x43, 0xd4, 0x92, 0xc4, 0x4a,
    0x66, 0x49, 0xcd, 0x3c, 0x07, 0x45, 0x03, 0x50, 0xad, 0x6e, 0x15, 0x78,
    0x6a, 0x43, 0xcf, 0xf6, 0xce, 0xa2, 0x1c, 0xf8, 0x28, 0x01, 0xe7, 0x48,
    0x48, 0xa1, 0x48, 0xa1, 0xbf, 0x33, 0x3b, 0x21, 0x6e, 0xf9, 0xfd, 0x80,
    0x20, 0x7e, 0x8b, 0x71, 0x2f, 0x20, 0xb9, 0x36, 0xd3, 0x40, 0x56, 0x2b,
    0x81, 0xb5, 0xfd, 0xdb, 0x30, 0x28, 0xd3, 0xef, 0xe0, 0x23, 0x3a, 0x66,
    0xe7, 0x14, 0x26, 0xe1, 0x55, 0x0c, 0xc7, 0x96, 0xcf, 0x04, 0x31, 0x98,
    0x9c, 0x40, 0x85, 0xe4, 0x0a, 0xf7, 0x11, 0x7c, 0x28, 0x79, 0xe9, 0x79,
    0xca, 0x3b, 0x5a, 0x69, 0x25, 0x08, 0x96, 0x03, 0xa0, 0xc5, 0x9f, 0x06,
    0x08, 0x37, 0x1c, 0xd7, 0xad, 0xa9, 0x5c, 0x68, 0x13, 0x1b, 0xca, 0xc0,
    0x03, 0x67, 0x15, 0x29, 0xeb, 0xfe, 0xda, 0xe9, 0x71, 0x25, 0xa6, 0x59,
    0x78, 0xe0, 0x2b, 0x9c, 0xbe, 0x52, 0x15, 0x3a, 0xbf, 0x40, 0xba, 0x78,
    0x7d, 0x35, 0xe0, 0x7e, 0xb3, 0xb4, 0x1c, 0xcf, 0x01, 0x0d, 0x19, 0x65,
    0x9c, 0x5c, 0x00, 0x00, 0x00, 0x05, 0x1a, 0x30, 0x82, 0x05, 0x16, 0x30,
    0x82, 0x02, 0xfe, 0xa0, 0x03, 0x02, 0x01, 0x02, 0x02, 0x11, 0x00, 0x91,
    0x2b, 0x08, 0x4a, 0xcf, 0x0c, 0x18, 0xa7, 0x53, 0xf6, 0xd6, 0x2e, 0x25,
    0xa7, 0x5f, 0x5a, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7,
    0x0d, 0x01, 0x01, 0x0b, 0x05, 0x00, 0x30, 0x4f, 0x31, 0x0b, 0x30, 0x09,
    0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02, 0x55, 0x53, 0x31, 0x29, 0x30,
    0x27, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13, 0x20, 0x49, 0x6e, 0x74, 0x65,
    0x72, 0x6e, 0x65, 0x74, 0x20, 0x53, 0x65, 0x63, 0x75, 0x72, 0x69, 0x74,
    0x79, 0x20, 0x52, 0x65, 0x73, 0x65, 0x61, 0x72, 0x63, 0x68, 0x20, 0x47,
    0x72, 0x6f, 0x75, 0x70, 0x31, 0x15, 0x30, 0x13, 0x06, 0x03, 0x55, 0x04,
    0x03, 0x13, 0x0c, 0x49, 0x53, 0x52, 0x47, 0x20, 0x52, 0x6f, 0x6f, 0x74,
    0x20, 0x58, 0x31, 0x30, 0x1e, 0x17, 0x0d, 0x32, 0x30, 0x30, 0x39, 0x30,
    0x34, 0x30, 0x30, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x17, 0x0d, 0x32, 0x35,
    0x30, 0x39, 0x31, 0x35, 0x31, 0x36, 0x30, 0x30, 0x30, 0x30, 0x5a, 0x30,
    0x32, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x06, 0x13, 0x02,
    0x55, 0x53, 0x31, 0x16, 0x30, 0x14, 0x06, 0x03, 0x55, 0x04, 0x0a, 0x13,
    0x0d, 0x4c, 0x65, 0x74, 0x27, 0x73, 0x20, 0x45, 0x6e, 0x63, 0x72, 0x79,
    0x70, 0x74, 0x31, 0x0b, 0x30, 0x09, 0x06, 0x03, 0x55, 0x04, 0x03, 0x13,
    0x02, 0x52, 0x33, 0x30, 0x82, 0x01, 0x22, 0x30, 0x0d, 0x06, 0x09, 0x2a,
    0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01, 0x01, 0x01, 0x05, 0x00, 0x03, 0x82,
    0x01, 0x0f, 0x00, 0x30, 0x82, 0x01, 0x0a, 0x02, 0x82, 0x01, 0x01, 0x00,
    0xbb, 0x02, 0x15, 0x28, 0xcc, 0xf6, 0xa0, 0x94, 0xd3, 0x0f, 0x12, 0xec,
    0x8d, 0x55, 0x92, 0xc3, 0xf8, 0x82, 0xf1, 0x99, 0xa6, 0x7a, 0x42, 0x88,
    0xa7, 0x5d, 0x26, 0xaa, 0xb5, 0x2b, 0xb9, 0xc5, 0x4c, 0xb1, 0xaf, 0x8e,
    0x6b, 0xf9, 0x75, 0xc8, 0xa3, 0xd7, 0x0f, 0x47, 0x94, 0x14, 0x55, 0x35,
    0x57, 0x8c, 0x9e, 0xa8, 0xa2, 0x39, 0x19, 0xf5, 0x82, 0x3c, 0x42, 0xa9,
    0x4e, 0x6e, 0xf5, 0x3b, 0xc3, 0x2e, 0xdb, 0x8d, 0xc0, 0xb0, 0x5c, 0xf3,
    0x59, 0x38, 0xe7, 0xed, 0xcf, 0x69, 0xf0, 0x5a, 0x0b, 0x1b, 0xbe, 0xc0,
    0x94, 0x24, 0x25, 0x87, 0xfa, 0x37, 0x71, 0xb3, 0x13, 0xe7, 0x1c, 0xac,
    0xe1, 0x9b, 0xef, 0xdb, 0xe4, 0x3b, 0x45, 0x52, 0x45, 0x96, 0xa9, 0xc1,
    0x53, 0xce, 0x34, 0xc8, 0x52, 0xee, 0xb5, 0xae, 0xed, 0x8f, 0xde, 0x60,
    0x70, 0xe2, 0xa5, 0x54, 0xab, 0xb6, 0x6d, 0x0e, 0x97, 0xa5, 0x40, 0x34,
    0x6b, 0x2b, 0xd3, 0xbc, 0x66, 0xeb, 0x66, 0x34, 0x7c, 0xfa, 0x6b, 0x8b,
    0x8f, 0x57, 0x29, 0x99, 0xf8, 0x30, 0x17, 0x5d, 0xba, 0x72, 0x6f, 0xfb,
    0x81, 0xc5, 0xad, 0xd2, 0x86, 0x58, 0x3d, 0x17, 0xc7, 0xe7, 0x09, 0xbb,
    0xf1, 0x2b, 0xf7, 0x86, 0xdc, 0xc1, 0xda, 0x71, 0x5d, 0xd4, 0x46, 0xe3,
    0xcc, 0xad, 0x25, 0xc1, 0x88, 0xbc, 0x60, 0x67, 0x75, 0x66, 0xb3, 0xf1,
    0x18, 0xf7, 0xa2, 0x5c, 0xe6, 0x53, 0xff, 0x3a, 0x88, 0xb6, 0x47, 0xa5,
    0xff, 0x13, 0x18, 0xea, 0x98, 0x09, 0x77, 0x3f, 0x9d, 0x53, 0xf9, 0xcf,
    0x01, 0xe5, 0xf5, 0xa6, 0x70, 0x17, 0x14, 0xaf, 0x63, 0xa4, 0xff, 0x99,
    0xb3, 0x93, 0x9d, 0xdc, 0x53, 0xa7, 0x06, 0xfe, 0x48, 0x85, 0x1d, 0xa1,
    0x69, 0xae, 0x25, 0x75, 0xbb, 0x13, 0xcc, 0x52, 0x03, 0xf5, 0xed, 0x51,
    0xa1, 0x8b, 0xdb, 0x15, 0x02, 0x03, 0x01, 0x00, 0x01, 0xa3, 0x82, 0x01,
    0x08, 0x30, 0x82, 0x01, 0x04, 0x30, 0x0e, 0x06, 0x03, 0x55, 0x1d, 0x0f,
    0x01, 0x01, 0xff, 0x04, 0x04, 0x03, 0x02, 0x01, 0x86, 0x30, 0x1d, 0x06,
    0x03, 0x55, 0x1d, 0x25, 0x04, 0x16, 0x30, 0x14, 0x06, 0x08, 0x2b, 0x06,
    0x01, 0x05, 0x05, 0x07, 0x03, 0x02, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05,
    0x05, 0x07, 0x03, 0x01, 0x30, 0x12, 0x06, 0x03, 0x55, 0x1d, 0x13, 0x01,
    0x01, 0xff, 0x04, 0x08, 0x30, 0x06, 0x01, 0x01, 0xff, 0x02, 0x01, 0x00,
    0x30, 0x1d, 0x06, 0x03, 0x55, 0x1d, 0x0e, 0x04, 0x16, 0x04, 0x14, 0x14,
    0x2e, 0xb3, 0x17, 0xb7, 0x58, 0x56, 0xcb, 0xae, 0x50, 0x09, 0x40, 0xe6,
    0x1f, 0xaf, 0x9d, 0x8b, 0x14, 0xc2, 0xc6, 0x30, 0x1f, 0x06, 0x03, 0x55,
    0x1d, 0x23, 0x04, 0x18, 0x30, 0x16, 0x80, 0x14, 0x79, 0xb4, 0x59, 0xe6,
    0x7b, 0xb6, 0xe5, 0xe4, 0x01, 0x73, 0x80, 0x08, 0x88, 0xc8, 0x1a, 0x58,
    0xf6, 0xe9, 0x9b, 0x6e, 0x30, 0x32, 0x06, 0x08, 0x2b, 0x06, 0x01, 0x05,
    0x05, 0x07, 0x01, 0x01, 0x04, 0x26, 0x30, 0x24, 0x30, 0x22, 0x06, 0x08,
    0x2b, 0x06, 0x01, 0x05, 0x05, 0x07, 0x30, 0x02, 0x86, 0x16, 0x68, 0x74,
    0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x78, 0x31, 0x2e, 0x69, 0x2e, 0x6c, 0x65,
    0x6e, 0x63, 0x72, 0x2e, 0x6f, 0x72, 0x67, 0x2f, 0x30, 0x27, 0x06, 0x03,
    0x55, 0x1d, 0x1f, 0x04, 0x20, 0x30, 0x1e, 0x30, 0x1c, 0xa0, 0x1a, 0xa0,
    0x18, 0x86, 0x16, 0x68, 0x74, 0x74, 0x70, 0x3a, 0x2f, 0x2f, 0x78, 0x31,
    0x2e, 0x63, 0x2e, 0x6c, 0x65, 0x6e, 0x63, 0x72, 0x2e, 0x6f, 0x72, 0x67,
    0x2f, 0x30, 0x22, 0x06, 0x03, 0x55, 0x1d, 0x20, 0x04, 0x1b, 0x30, 0x19,
    0x30, 0x08, 0x06, 0x06, 0x67, 0x81, 0x0c, 0x01, 0x02, 0x01, 0x30, 0x0d,
    0x06, 0x0b, 0x2b, 0x06, 0x01, 0x04, 0x01, 0x82, 0xdf, 0x13, 0x01, 0x01,
    0x01, 0x30, 0x0d, 0x06, 0x09, 0x2a, 0x86, 0x48, 0x86, 0xf7, 0x0d, 0x01,
    0x01, 0x0b, 0x05, 0x00, 0x03, 0x82, 0x02, 0x01, 0x00, 0x85, 0xca, 0x4e,
    0x47, 0x3e, 0xa3, 0xf7, 0x85, 0x44, 0x85, 0xbc, 0xd5, 0x67, 0x78, 0xb2,
    0x98, 0x63, 0xad, 0x75, 0x4d, 0x1e, 0x96, 0x3d, 0x33, 0x65, 0x72, 0x54,
    0x2d, 0x81, 0xa0, 0xea, 0xc3, 0xed, 0xf8, 0x20, 0xbf, 0x5f, 0xcc, 0xb7,
    0x70, 0x00, 0xb7, 0x6e, 0x3b, 0xf6, 0x5e, 0x94, 0xde, 0xe4, 0x20, 0x9f,
    0xa6, 0xef, 0x8b, 0xb2, 0x03, 0xe7, 0xa2, 0xb5, 0x16, 0x3c, 0x91, 0xce,
    0xb4, 0xed, 0x39, 0x02, 0xe7, 0x7c, 0x25, 0x8a, 0x47, 0xe6, 0x65, 0x6e,
    0x3f, 0x46, 0xf4, 0xd9, 0xf0, 0xce, 0x94, 0x2b, 0xee, 0x54, 0xce, 0x12,
    0xbc, 0x8c, 0x27, 0x4b, 0xb8, 0xc1, 0x98, 0x2f, 0xa2, 0xaf, 0xcd, 0x71,
    0x91, 0x4a, 0x08, 0xb7, 0xc8, 0xb8, 0x23, 0x7b, 0x04, 0x2d, 0x08, 0xf9,
    0x08, 0x57, 0x3e, 0x83, 0xd9, 0x04, 0x33, 0x0a, 0x47, 0x21, 0x78, 0x09,
    0x82, 0x27, 0xc3, 0x2a, 0xc8, 0x9b, 0xb9, 0xce, 0x5c, 0xf2, 0x64, 0xc8,
    0xc0, 0xbe, 0x79, 0xc0, 0x4f, 0x8e, 0x6d, 0x44, 0x0c, 0x5e, 0x92, 0xbb,
    0x2e, 0xf7, 0x8b, 0x10, 0xe1, 0xe8, 0x1d, 0x44, 0x29, 0xdb, 0x59, 0x20,
    0xed, 0x63, 0xb9, 0x21, 0xf8, 0x12, 0x26, 0x94, 0x93, 0x57, 0xa0, 0x1d,
    0x65, 0x04, 0xc1, 0x0a, 0x22, 0xae, 0x10, 0x0d, 0x43, 0x97, 0xa1, 0x18,
    0x1f, 0x7e, 0xe0, 0xe0, 0x86, 0x37, 0xb5, 0x5a, 0xb1, 0xbd, 0x30, 0xbf,
    0x87, 0x6e, 0x2b, 0x2a, 0xff, 0x21, 0x4e, 0x1b, 0x05, 0xc3, 0xf5, 0x18,
    0x97, 0xf0, 0x5e, 0xac, 0xc3, 0xa5, 0xb8, 0x6a, 0xf0, 0x2e, 0xbc, 0x3b,
    0x33, 0xb9, 0xee, 0x4b, 0xde, 0xcc, 0xfc, 0xe4, 0xaf, 0x84, 0x0b, 0x86,
    0x3f, 0xc0, 0x55, 0x43, 0x36, 0xf6, 0x68, 0xe1, 0x36, 0x17, 0x6a, 0x8e,
    0x99, 0xd1, 0xff, 0xa5, 0x40, 0xa7, 0x34, 0xb7, 0xc0, 0xd0, 0x63, 0x39,
    0x35, 0x39, 0x75, 0x6e, 0xf2, 0xba, 0x76, 0xc8, 0x93, 0x02, 0xe9, 0xa9,
    0x4b, 0x6c, 0x17, 0xce, 0x0c, 0x02, 0xd9, 0xbd, 0x81, 0xfb, 0x9f, 0xb7,
    0x68, 0xd4, 0x06, 0x65, 0xb3, 0x82, 0x3d, 0x77, 0x53, 0xf8, 0x8e, 0x79,
    0x03, 0xad, 0x0a, 0x31, 0x07, 0x75, 0x2a, 0x43, 0xd8, 0x55, 0x97, 0x72,
    0xc4, 0x29, 0x0e, 0xf7, 0xc4, 0x5d, 0x4e, 0xc8, 0xae, 0x46, 0x84, 0x30,
    0xd7, 0xf2, 0x85, 0x5f, 0x18, 0xa1, 0x79, 0xbb, 0xe7, 0x5e, 0x70, 0x8b,
    0x07, 0xe1, 0x86, 0x93, 0xc3, 0xb9, 0x8f, 0xdc, 0x61, 0x71, 0x25, 0x2a,
    0xaf, 0xdf, 0xed, 0x25, 0x50, 0x52, 0x68, 0x8b, 0x92, 0xdc, 0xe5, 0xd6,
    0xb5, 0xe3, 0xda, 0x7d, 0xd0, 0x87, 0x6c, 0x84, 0x21, 0x31, 0xae, 0x82,
    0xf5, 0xfb, 0xb9, 0xab, 0xc8, 0x89, 0x17, 0x3d, 0xe1, 0x4c, 0xe5, 0x38,
    0x0e, 0xf6, 0xbd, 0x2b, 0xbd, 0x96, 0x81, 0x14, 0xeb, 0xd5, 0xdb, 0x3d,
    0x20, 0xa7, 0x7e, 0x59, 0xd3, 0xe2, 0xf8, 0x58, 0xf9, 0x5b, 0xb8, 0x48,
    0xcd, 0xfe, 0x5c, 0x4f, 0x16, 0x29, 0xfe, 0x1e, 0x55, 0x23, 0xaf, 0xc8,
    0x11, 0xb0, 0x8d, 0xea, 0x7c, 0x93, 0x90, 0x17, 0x2f, 0xfd, 0xac, 0xa2,
    0x09, 0x47, 0x46, 0x3f, 0xf0, 0xe9, 0xb0, 0xb7, 0xff, 0x28, 0x4d, 0x68,
    0x32, 0xd6, 0x67, 0x5e, 0x1e, 0x69, 0xa3, 0x93, 0xb8, 0xf5, 0x9d, 0x8b,
    0x2f, 0x0b, 0xd2, 0x52, 0x43, 0xa6, 0x6f, 0x32, 0x57, 0x65, 0x4d, 0x32,
    0x81, 0xdf, 0x38, 0x53, 0x85, 0x5d, 0x7e, 0x5d, 0x66, 0x29, 0xea, 0xb8,
    0xdd, 0xe4, 0x95, 0xb5, 0xcd, 0xb5, 0x56, 0x12, 0x42, 0xcd, 0xc4, 0x4e,
    0xc6, 0x25, 0x38, 0x44, 0x50, 0x6d, 0xec, 0xce, 0x00, 0x55, 0x18, 0xfe,
    0xe9, 0x49, 0x64, 0xd4, 0x4e, 0xca, 0x97, 0x9c, 0xb4, 0x5b, 0xc0, 0x73,
    0xa8, 0xab, 0xb8, 0x47, 0xc2, 0x00, 0x00};

struct CertificateCompressionTestCase {
  uint8_t* encodedBuf;
  unsigned int encodedBufLen;
  unsigned int decodedBufLen;
  SECStatus (*decode)(const SECItem* input, unsigned char* output,
                      size_t outputLen, size_t* usedLen);
};

static const CertificateCompressionTestCase CertificateCompressionTestCases[] =
    {{encodedBufferExampleZlib, sizeof(encodedBufferExampleZlib), 100,
      zlibCertificateDecode},
     {encodedBufferExampleBrotli, sizeof(encodedBufferExampleBrotli), 100,
      brotliCertificateDecode},
     {encodedBufferExampleZstd, sizeof(encodedBufferExampleZstd), 100,
      zstdCertificateDecode},
     {encodedBufferExampleAbridged, sizeof(encodedBufferExampleAbridged), 2575,
      abridgedCertificateDecode}};

class psm_CertificateCompression
    : public ::testing::Test,
      public ::testing::WithParamInterface<CertificateCompressionTestCase> {};

TEST_P(psm_CertificateCompression, DecoderCorrectlyDecodes) {
  const CertificateCompressionTestCase& testCase(GetParam());
  if (testCase.decode == abridgedCertificateDecode) {
    // Abridged Tests has a specific test below. GTEST_SKIP causes errors in CI.
    return;
  }
  SECItem encodedItem = {siBuffer, testCase.encodedBuf, testCase.encodedBufLen};
  std::unique_ptr<uint8_t[]> decodedEncodedBuffer =
      std::make_unique<uint8_t[]>(testCase.decodedBufLen);
  size_t usedLen = 0;

  SECStatus rv = testCase.decode(&encodedItem, decodedEncodedBuffer.get(),
                                 testCase.decodedBufLen, &usedLen);
  ASSERT_EQ(SECSuccess, rv);

  ASSERT_EQ(usedLen, testCase.decodedBufLen);
  for (size_t i = 0; i < usedLen; i++) {
    ASSERT_EQ(decodedEncodedBuffer.get()[i], i);
  }
}

TEST_F(psm_CertificateCompression, TestAbridgedCertsRoundTrip) {
  SECItem encodedItem = {siBuffer, encodedBufferExampleAbridged, 1145};
  std::unique_ptr<uint8_t[]> decodedEncodedBuffer =
      std::make_unique<uint8_t[]>(2575);
  std::fill_n(decodedEncodedBuffer.get(), 2575, 0);

  size_t usedLen = 0;

  nsCOMPtr<nsICertStorage> cert_storage(do_GetService(NS_CERT_STORAGE_CID));
  ASSERT_TRUE(cert_storage != nullptr);

  nsCString der(
      "MIIFFjCCAv6gAwIBAgIRAJErCErPDBinU/"
      "bWLiWnX1owDQYJKoZIhvcNAQELBQAwTzELMAkGA1UEBhMCVVMxKTAnBgNVBAoTIEludGVybm"
      "V0IFNlY3VyaXR5IFJlc2VhcmNoIEdyb3VwMRUwEwYDVQQDEwxJU1JHIFJvb3QgWDEwHhcNMj"
      "AwOTA0MDAwMDAwWhcNMjUwOTE1MTYwMDAwWjAyMQswCQYDVQQGEwJVUzEWMBQGA1UEChMNTG"
      "V0J3MgRW5jcnlwdDELMAkGA1UEAxMCUjMwggEiMA0GCSqGSIb3DQEBAQUAA4IBDwAwggEKAo"
      "IBAQC7AhUozPaglNMPEuyNVZLD+ILxmaZ6QoinXSaqtSu5xUyxr45r+"
      "XXIo9cPR5QUVTVXjJ6oojkZ9YI8QqlObvU7wy7bjcCwXPNZOOftz2nwWgsbvsCUJCWH+"
      "jdxsxPnHKzhm+/"
      "b5DtFUkWWqcFTzjTIUu61ru2P3mBw4qVUq7ZtDpelQDRrK9O8ZutmNHz6a4uPVymZ+"
      "DAXXbpyb/uBxa3Shlg9F8fnCbvxK/eG3MHacV3URuPMrSXBiLxgZ3Vms/EY96Jc5lP/"
      "Ooi2R6X/ExjqmAl3P51T+c8B5fWmcBcUr2Ok/5mzk53cU6cG/"
      "kiFHaFpriV1uxPMUgP17VGhi9sVAgMBAAGjggEIMIIBBDAOBgNVHQ8BAf8EBAMCAYYwHQYDV"
      "R0lBBYwFAYIKwYBBQUHAwIGCCsGAQUFBwMBMBIGA1UdEwEB/"
      "wQIMAYBAf8CAQAwHQYDVR0OBBYEFBQusxe3WFbLrlAJQOYfr52LFMLGMB8GA1UdIwQYMBaAF"
      "Hm0WeZ7tuXkAXOACIjIGlj26ZtuMDIGCCsGAQUFBwEBBCYwJDAiBggrBgEFBQcwAoYWaHR0c"
      "DovL3gxLmkubGVuY3Iub3JnLzAnBgNVHR8EIDAeMBygGqAYhhZodHRwOi8veDEuYy5sZW5jc"
      "i5vcmcvMCIGA1UdIAQbMBkwCAYGZ4EMAQIBMA0GCysGAQQBgt8TAQEBMA0GCSqGSIb3DQEBC"
      "wUAA4ICAQCFyk5HPqP3hUSFvNVneLKYY611TR6WPTNlclQtgaDqw+34IL9fzLdwALduO/"
      "ZelN7kIJ+m74uyA+eitRY8kc607TkC53wlikfmZW4/"
      "RvTZ8M6UK+"
      "5UzhK8jCdLuMGYL6KvzXGRSgi3yLgjewQtCPkIVz6D2QQzCkcheAmCJ8MqyJu5zlzyZMjAvn"
      "nAT45tRAxekrsu94sQ4egdRCnbWSDtY7kh+"
      "BImlJNXoB1lBMEKIq4QDUOXoRgffuDghje1WrG9ML+Hbisq/"
      "yFOGwXD9RiX8F6sw6W4avAuvDszue5L3sz85K+EC4Y/"
      "wFVDNvZo4TYXao6Z0f+"
      "lQKc0t8DQYzk1OXVu8rp2yJMC6alLbBfODALZvYH7n7do1AZls4I9d1P4jnkDrQoxB3UqQ9h"
      "Vl3LEKQ73xF1OyK5GhDDX8oVfGKF5u+decIsH4YaTw7mP3GFxJSqv3+"
      "0lUFJoi5Lc5da149p90IdshCExroL1+7mryIkXPeFM5TgO9r0rvZaBFOvV2z0gp35Z0+"
      "L4WPlbuEjN/lxPFin+HlUjr8gRsI3qfJOQFy/9rKIJR0Y/8Omwt/"
      "8oTWgy1mdeHmmjk7j1nYsvC9JSQ6ZvMldlTTKB3zhThV1+"
      "XWYp6rjd5JW1zbVWEkLNxE7GJThEUG3szgBVGP7pSWTUTsqXnLRbwHOoq7hHwg==");
  nsCString subject("VGhpc0ZpZWxkSXNudFVzZWQ=");  // Base64("ThisFieldIsntUsed")
  nsresult outcome = cert_storage->TestHelperAddCert(der, subject, 4);
  ASSERT_TRUE(NS_SUCCEEDED(outcome));

  SECStatus rv = abridgedCertificateDecode(
      &encodedItem, decodedEncodedBuffer.get(), 2575, &usedLen);
  ASSERT_EQ(SECSuccess, rv);
  ASSERT_EQ(usedLen, 2575ULL);
  for (size_t i = 0; i < usedLen; i++) {
    ASSERT_EQ(decodedEncodedBuffer.get()[i], decodedBufferExampleAbridged[i]);
  }
}

TEST_P(psm_CertificateCompression, DecodingFailsEmptyInputItem) {
  const CertificateCompressionTestCase& testCase(GetParam());
  uint8_t decodedEncodedBuffer[500] = {0};
  size_t usedLen = 0;
  /* nullptr instead of input */
  SECStatus rv = testCase.decode(nullptr, decodedEncodedBuffer,
                                 sizeof(decodedEncodedBuffer), &usedLen);
  ASSERT_EQ(SECFailure, rv);
}

TEST_P(psm_CertificateCompression, DecodingFailsEmptyInput) {
  const CertificateCompressionTestCase& testCase(GetParam());
  SECItem encodedItem = {siBuffer, nullptr,
                         (unsigned int)sizeof(encodedBufferExampleZlib)};
  uint8_t decodedEncodedBuffer[500] = {0};
  size_t usedLen = 0;
  /* nullptr instead of input.data */
  SECStatus rv = testCase.decode(&encodedItem, decodedEncodedBuffer,
                                 sizeof(decodedEncodedBuffer), &usedLen);
  ASSERT_EQ(SECFailure, rv);
}

TEST_P(psm_CertificateCompression, DecodingFails0LenInput) {
  const CertificateCompressionTestCase& testCase(GetParam());
  SECItem encodedItem = {siBuffer, encodedBufferExampleZlib, 0};
  uint8_t decodedEncodedBuffer[500] = {0};
  size_t usedLen = 0;
  /* 0 instead of input.len*/
  SECStatus rv = testCase.decode(&encodedItem, decodedEncodedBuffer,
                                 sizeof(decodedEncodedBuffer), &usedLen);
  ASSERT_EQ(SECFailure, rv);
}

TEST_P(psm_CertificateCompression, DecodingFailsEmptyBuffer) {
  const CertificateCompressionTestCase& testCase(GetParam());
  unsigned char encodedBuffer[500] = {0};
  SECItem encodedItem = {siBuffer, encodedBuffer, 500};
  uint8_t decodedEncodedBuffer[500] = {0};
  size_t usedLen = 0;
  /* Empty buffer will return an error if decoded. */
  SECStatus rv = testCase.decode(&encodedItem, decodedEncodedBuffer,
                                 sizeof(decodedEncodedBuffer), &usedLen);
  ASSERT_EQ(SECFailure, rv);
}

TEST_P(psm_CertificateCompression, DecodingFailsNullOutput) {
  const CertificateCompressionTestCase& testCase(GetParam());
  SECItem encodedItem = {siBuffer, encodedBufferExampleZlib,
                         (unsigned int)sizeof(encodedBufferExampleZlib)};
  uint8_t decodedEncodedBuffer[5] = {0};
  size_t usedLen = 0;
  /* Empty buffer will return an error if decoded. */
  SECStatus rv = testCase.decode(&encodedItem, nullptr,
                                 sizeof(decodedEncodedBuffer), &usedLen);
  ASSERT_EQ(SECFailure, rv);
}

TEST_P(psm_CertificateCompression, DecodingFailsOutputTooSmall) {
  const CertificateCompressionTestCase& testCase(GetParam());
  SECItem encodedItem = {siBuffer, encodedBufferExampleZlib,
                         (unsigned int)sizeof(encodedBufferExampleZlib)};
  uint8_t decodedEncodedBuffer[5] = {0};
  size_t usedLen = 0;
  /* Empty buffer will return an error if decoded. */
  SECStatus rv = testCase.decode(&encodedItem, decodedEncodedBuffer,
                                 sizeof(decodedEncodedBuffer), &usedLen);
  ASSERT_EQ(SECFailure, rv);
}

INSTANTIATE_TEST_SUITE_P(psm_CertificateCompression, psm_CertificateCompression,
                         ::testing::ValuesIn(CertificateCompressionTestCases));
