
				/* My Subs - replacement for G06AC asm routines, 
					and emulation of SuperPaint frame buffer hardware 
					-- R. Shoup, 9/05 */


#include <windows.h>
#include "G06DEFS.H"
#include "IOX.H"
#include "MyDefs.h"
extern void MyTextF();

WIN cFBWin;		/* current Win for read/write */
uword cMode;	/* current Mode for read/write */


							/* overlay buffer */
char OvPix[FBHeight][FBWidth];		/* overlay pixels */
struct { word full; word mode; word x; word y; word w; word h; } ovlyst; /* state */

void resovly()	{			/* restore overlay */
	int x,y; byte v, val;

	if (!ovlyst.full) return;

	ovlyst.full = 0;
	for (y=ovlyst.y; y<ovlyst.y+ovlyst.h; y++) { 
		for (x=ovlyst.x; x<ovlyst.x+ovlyst.w; x++) {
			v = MyPix[FBHeight-1-y][x]; val = OvPix[y][x];
			if (ovlyst.mode&OVQ0) v = (v&0x0f) | (val&0xf0);
			if (ovlyst.mode&OVQ1) v = (v&0xf0) | (val&0x0f);
			MyPix[FBHeight-1-y][x] = v; 
		}
	}
	MyInvalidate(ovlyst.mode&OVQ0?MenuFB:CanvFB, ovlyst.x, ovlyst.y, ovlyst.w, ovlyst.h);
}

void savovly()	{			/* save overlay */
	int x,y;

	resovly();		/* restore previous, if any */

	ovlyst.mode = cMode; 
	ovlyst.x = cFBWin.XORIG - cFBWin.XOFF; ovlyst.y = cFBWin.YORIG - cFBWin.YOFF; 
	ovlyst.w = cFBWin.W; ovlyst.h = cFBWin.H;
	for (y=ovlyst.y; y<ovlyst.y+ovlyst.h; y++) { 
		for (x=ovlyst.x; x<ovlyst.x+ovlyst.w; x++) {
			OvPix[y][x] = MyPix[FBHeight-1-y][x];	/* save all 8 bits */
		}
	}
	ovlyst.full = 1;
}


void WrFBRun(POS P, byte val, byte run) {		/* write a run to cur FB window */
	word x,y,i,r=run,m=cMode&OVBOTHQ; byte v;

	x = cFBWin.XORIG - cFBWin.XOFF + P.X; 
	y = cFBWin.YORIG - cFBWin.YOFF + P.Y; 
	for (i=0; i<r; i++,x++) { 
		v = MyPix[FBHeight-1-y][x]; 
		if (m==OVQ0) v = (v&0x0f) | (val<<4&0xf0);
		else if (m==OVQ1) v = (v&0xf0) | (val&0x0f);
		else if (m==OVBOTHQ) v = val&0xff;
		MyPix[FBHeight-1-y][x] = v; 
	}
}

void RdFBRun(POS P, byte *pval, byte *prun) {	/* read a run from cur FB window */
	word x,y,r,m=cMode&OVBOTHQ; byte v1,v2;

	resovly();
	x = cFBWin.XORIG - cFBWin.XOFF + P.X; 
	y = cFBWin.YORIG - cFBWin.YOFF + P.Y; 
	v1 = MyPix[FBHeight-1-y][x++]; 
	if (m==OVQ0) v1 >>= 4; 
	else if (m==OVQ1) v1 &= 0x0f;
	else if (m==OVBOTHQ) v1 &= 0xff;

	r = 1;
	do { 
		v2 = MyPix[FBHeight-1-y][x++]; 
		if (m==OVQ0) v2 >>= 4; 
		else if (m==OVQ1) v2 &= 0x0f;
		else if (m==OVBOTHQ) v2 &= 0xff;
	} while (v2==v1 && ++r<255);
	*pval = v1; *prun = (byte)r;
}


void WrFBPix(mode,x,y,val)	{	/* write FB raw pixel */
	byte v; word m=mode&OVBOTHQ;

	v = MyPix[FBHeight-1-y][x];
	if (m==OVQ0) v = (v&0x0f) | (val<<4&0xf0);
	else if (m==OVQ1) v = (v&0xf0) | (val&0x0f);
	else if (m==OVBOTHQ) v = val&0xff;
	MyPix[FBHeight-1-y][x] = v;
}


void RdFBPix(mode,x,y,pval)		/* read FB raw pixel */
	byte *pval;
{
	byte v; word m=mode&OVBOTHQ;

	resovly();
	v = MyPix[FBHeight-1-y][x];
	if (m==OVQ0) v >>= 4; 
	else if (m==OVQ1) v &= 0x0f;
	else if (m==OVBOTHQ) v &= 0xff;
	*pval = v;
}


				/* assembly code routines */

							/* prepare to read or write */
void SETWRRUNS(WIN W, word MODE) {
	cFBWin = W;					/* save window */
	cMode = MODE;				/* save mode bits */
	if (!(MODE & ~OVBOTHQ)) savovly();
	else resovly();
}

							/* write runs to cur FB win */
void WRITERUNS(word *Xtab, RUNCODE *Runtab, word Field) {
	POS P; word y; byte v, len;

	for (y=0; y<cFBWin.H; y++) {
		if (Field>=0 && (y&1)!=Field) continue;
		v = Runtab[y].VALUE; len = Runtab[y].RUN;
		P.X = Xtab[y]; P.Y = y;
		Xtab[y] += len;
		if (VALTRANSTAB) {
			if (VALTRANSTAB[v].ISNULL) continue;
			else v = VALTRANSTAB[v].VALUE;
		} 
		WrFBRun(P, v, len); 
	}
	MyUpdate(cMode&OVQ1?CanvFB:MenuFB);		/* display it (and slow down) */
}

							/* read runs from cur FB win */
word READRUNS(word *Xtab, RUNCODE *Runtab, word Field) {
	POS P; word y,maxlen, any=0; byte v, len;

	for (y=0; y<cFBWin.H; y++) {
		if (Field>=0 && (y&1)!=Field) continue;
		P.X = Xtab[y]; P.Y = y;
		if (P.X >= cFBWin.W) continue;
		RdFBRun(P, &v, &len);
		maxlen = cFBWin.W-P.X;
		if (maxlen < len) len = (byte)maxlen;
		Runtab[y].VALUE = v; Runtab[y].RUN = len;
		VALTRANSTAB[v].VALUE = v; VALTRANSTAB[v].ISNULL = 0;
		Xtab[y] += len; any = 1;
	}
	return (any);		/* something read */
}


int LbDownl = 0;	// button down last time

							/* get tablet pos and status */
void RTABLET(POS *pP, PENSTAT *pS) {
	EnterCriticalSection(&EvLock);
	pP->X = TXPos*2+16;			// use mouse, 2x+16 to match tablet coords
	pP->Y = (PMHEIGHT-TYPos)*2+16;
	pS->DOWN = LbDown;			// use mouse left button
	pS->PROX = (Tfb == Focfb);	// if tablet is in focus win
	pS->PUSH = LbDown && !LbDownl;
	pS->PULL = !LbDown && LbDownl;
	LbDownl = LbDown;
	LeaveCriticalSection(&EvLock);
	resovly(); MyUpdate(-1);
}

							/* read a pixel from Pos P */
word RPMPOINT(POS P, word mode) {
	word v,x,y, m=mode&OVBOTHQ;

	resovly();
	x = P.X; y = P.Y;
	v = MyPix[FBHeight-1-y][x];
	if (m==OVQ0) v >>= 4; 
	else if (m==OVQ1) v &= 0x0f;
	else if (m==OVBOTHQ) v &= 0xff;
	return v;
}

							/* read a run from cur FB win */
void RPMRUN(POS P, byte *pval, byte *prun) {
	RdFBRun(P, pval, prun);
}

							/* write a run to cur FB win */
void WPMRUN(POS P, byte val, byte run) {
	WrFBRun(P, val, run);
}

							/* external I/O to PM and others */
word EXIO(int AC0, word CODE) {
//	if (CODE==(XXDOA+XXPM2)) 
//		SetFBFocus(AC0?MenuFB:CanvFB);
	if (CODE==(XXDOA+XXPM4)) 
		CMapMode = AC0>>12;	// 0=>Q0&Q1, 010=>Q1, 014=>Q0
	return 0;
}


char Dvec[1000];
							/* dynamic vector */
char * DYNAVEC(int Len) {
	return Dvec;
}

							/* wait for next vertical interval */
void PMVIWAIT() {
	int a, i;
	for (i=0; i<10000; i++) a = i*2;
}

							/* set the CMap */
void SETCOLORMAP(COLOR *Ctab, int nC) {
	int i, v;

	for (i=0; i<nC; i++) { 
		v = Ctab[i].VALUE;
		MyCMap[v].rgbRed = (byte)Ctab[i].RED;	
		MyCMap[v].rgbGreen = (byte)Ctab[i].GREEN;
		MyCMap[v].rgbBlue = (byte)Ctab[i].BLUE;
	}
	MyUpdate(-1);		/* display and slow it down */
}

							/* read the CMap */
void READCOLORMAP(COLOR *Ctab, int nC) {
	int i, v;

	for (i=0; i<nC; i++) { 
		v = Ctab[i].VALUE;
		Ctab[i].RED = MyCMap[v].rgbRed;	
		Ctab[i].GREEN = MyCMap[v].rgbGreen;
		Ctab[i].BLUE = MyCMap[v].rgbBlue;
	}
}


void MyTextF(WIN W,byte val) {		// SP text function kludge
	char s[200]; byte *p,v,v0; int x,y,w,h,i;
	extern int curX;

	MyTextOut(TermFB,TermXo,TermYo,"Text: ");
	MyTypein(TermFB,s);		// get text and echo
	
	p = FB[TermFB].pFBbm;
	for (y=0; y<20; y++) {
		i = (TermYo-4+y)*FB[TermFB].w+TermXo+8*6;
		for (x=0; x<curX; x++) { 
			v = p[i++]>>4;
			if (v) {
				v0 = MyPix[FBHeight-1-W.YORIG-y][W.XORIG+x];
				MyPix[FBHeight-1-W.YORIG-y][W.XORIG+x] = v0&0xf0 | val&0x0f;
			}
		}
	}

	MyUpdate(CanvFB);
}


void NOWORK() {		/* stub for stuff that doesn't work yet */
	WRITEFORM(1,0,"Sorry, function not available");
}


void swapbytes(unsigned short *p, int nw) {	// swap bytes in words
	int i;
	for (i=0; i<nw; i++) { 
		p[i] = ((p[i]&0xff)<<8)+(p[i]>>8); 
	}
}



