

				/* floating point routines */


#include "G06defs.h"


double fpAC[10];		/* flpt accumulators */

void FLD(int a1, int a2) {		/* flpt load */
	fpAC[a1] = fpAC[a2];
}

void FST() {		/* flpt store? */
}

int  FTR(int a) {				/* flpt translate? to int */
	return (int)fpAC[a];
}

void FLDI(int a, int i) {		/* flpt load integer */
	fpAC[a] = i;
}

void FNEG(int a) {				/* flpt negate */
	fpAC[a] = -fpAC[a];
}

void FAD(int a1, int a2) {		/* flpt add */
	fpAC[a1] += fpAC[a2];
}

void FSB(int a1, int a2) {		/* flpt subtract */
	fpAC[a1] -= fpAC[a2];
}

void FML(int a1, int a2) {		/* flpt multiply */
	fpAC[a1] *= fpAC[a2];
}

void FDV(int a1, int a2) {		/* flpt divide */
	fpAC[a1] /= fpAC[a2];
}

int  FCM(int a1, int a2) {		/* flpt compare */
	if (fpAC[a1] > fpAC[a2]) return +1;
	else if (fpAC[a1] < fpAC[a2]) return -1;
	else return 0;
}

int  FSN(int a1) {				/* flpt sign? */
	return (fpAC[a1] >= 0);
}

void FLDV() {		/* flpt load? */
}

void FSTV() {		/* flpt store? */
}

