/*
** is-comp.c source module for comparison function of IS
*/

#include <stdio.h>
#include <string.h>
#include "is.h"

int is_comp(char *str1, char *cond, char *str2)
{  
   extern int date_cmp(char *, char *);    /* compares dates   */
   extern int num_cmp(char *, char *);     /* compares 'numeric' strings   */

   int ret, result;
   int i = 0, dcount = 0;
   static char digits[] = {"0123456789"};
   char *cond_lwr;

   cond_lwr = strlwr(strdup(cond));

   /*
   ** dates, numbers and literal strings need to be compared differently... so
   ** check for two dates - if both are dates compare YYMMDD format else
   ** check for two 'numeric' strings - if so compare as numbers else
   ** compare the two strings as literal strings
   ** anyway, the result will be 0 if they are equal, < 0 if str1 is
   ** less than str2, > 0 if str1 is greater than str2
   ** that way, the same code can determine the relationship of any arguments
   */

   if((str1[2] == '/' && str1[5] == '/') || (str1[2] == '-' && str1[5] == '-'))
   {
       if(strlen(str1) == 8)
           ++dcount;
   }
   if((str2[2] == '/' && str2[5] == '/') || (str2[2] == '-' && str2[5] == '-'))
   {
       if(strlen(str2) == 8)
           ++dcount;
   }
   if(dcount == 2)
       result = date_cmp(str1, str2);
   else
   {
       if((strspn(str1, digits) == strlen(str1)) &&
          (strspn(str2, digits) == strlen(str2)))
       {
           result = num_cmp(str1, str2);
       }
       else
           result = strcmp(str1, str2);
   }

   if(((strcmp(cond_lwr, "eq")) == 0) && (result == 0))
       ret = TRUE;
   else if(((strcmp(cond_lwr, "gt")) == 0) && (result > 0))
       ret = TRUE;
   else if(((strcmp(cond_lwr, "lt")) == 0) && (result < 0))
       ret = TRUE;
   else if(((strcmp(cond_lwr, "neq")) == 0) && (result != 0))
       ret = TRUE;
   else if(((strcmp(cond_lwr, "ngt")) == 0) && (result <= 0))
       ret = TRUE;
   else if(((strcmp(cond_lwr, "nlt")) == 0) && (result >= 0))
       ret = TRUE;
   else if(((strcmp(cond_lwr, "le")) == 0) && (result <= 0)) 
       ret = TRUE;
   else if(((strcmp(cond_lwr, "ge")) == 0) && (result >= 0))
       ret = TRUE;
   else if(((strcmp(cond_lwr, "nle")) == 0) && (result > 0))
       ret = TRUE;
   else if(((strcmp(cond_lwr, "nge")) == 0) && (result < 0))
       ret = TRUE;
   else
       ret = FALSE;

   return(ret);
}

