/***************************************************************

	FV_OS1.C  --    Fast Video routines
			for Simple Software.

			Implementation for Osborne 1
			utilizing direct RAM video manipulation.

			The use of Simple Software is governed by the
			"Simple Software User Agreement" (see file
			SS.DOC).

			Copyright (c) 1989, Ted A. Campbell

			Bywater Software
			Box 4023
			Duke Station,
			Durham, NC  27706

***************************************************************/

#include "fv.h"

/**************************************************************

	FUNCTION:       fv_init()

	DESCRIPTION:    This function provides any initialization
			necessary for the video system.

	INPUT:          none.

	RETURNS:        none.

**************************************************************/

fv_init()
	{
	}

/**************************************************************

	FUNCTION:       fv_deinit()

	DESCRIPTION:    This function should provide any
			deinitialization necessary for the
			video system, i.e., it should return
			the video system to its default state.

	INPUT:          none.

	RETURNS:        none.

**************************************************************/

fv_deinit()
	{
	}

/**************************************************************

	FUNCTION:       fv_cls()

	DESCRIPTION:    This function clears the screen.

	INPUT:          none.

	RETURNS:        none.

	NOTE:           The function simply outputs the Osborne
			clear-screen code (1AH).

**************************************************************/

fv_cls()
	{
	putchar( 0x1a );
	fflush( stdout );
	}

/**************************************************************

	FUNCTION:       fv_adr()

	DESCRIPTION:    This function addresses the cursor to a
			specific line and column on the video
			screen.

	INPUT:          <line> and <column> denote the position
			to  which the cursor is to be addressed.

	RETURNS:        none.

	NOTE:           The function simply utilizes the Osborne
			escape sequence to address the cursor
			(this sequence is common to the ADM3A
			terminal, and many CP/M computers use it.)

**************************************************************/

fv_adr( line, column )
	int line, column;
	{
	printf( "\033=%c%c", line + 0x20, column + 0x20 );
	}

/**************************************************************

	FUNCTION:       fv_cachr()

	DESCRIPTION:    This function prints a specified character
			on the screen at a specified location with
			a specified video attribute.

	INPUT:          <line> and <column> denote the position
			at which the character is to be printed;
			<chr> is the ASCII code for the character,
			and <attribute> gives the simple software
			FV convention for the video attribute
			to be set (see FV.H).

	RETURNS:        none.

	NOTE:           The character is poked into RAM and the high
			bit is set if the special character attributes
			are requested.  On the Osborne 1, this means
			underlining, what is not altogether desirable,
			but the dim video attributes are hidden in
			an alternative bank of RAM.  Good luck.

**************************************************************/

fv_cachr( line, column, chr, attribute )
	int line, chr, column, attribute;
	{
	unsigned int mask;
	char *p;
	mask = 0;
	if ( attribute == FV_SPEC1 )
		{
		mask = 128;
		}
	if ( attribute == FV_SPEC2 )
		{
		mask = 128;
		}
	p = 0xf000 + ( line * 128 ) + column;
	*p = chr | mask;
	}

/**************************************************************

	FUNCTION:       fv_castr()

	DESCRIPTION:    This function places a specified string
			on the video screen at a specified posi-
			tion with a specified attribute.

	INPUT:          <line> and <column> denote the starting
			position for the string; <string> is a
			pointer to a buffer holding the string,
			and <attribute> gives the Simple Software
			FV convention for the video attribute
			for the string (see FV.H).

	RETURNS:        none.

**************************************************************/

fv_castr( line, column, string, attribute )
	int line, column, attribute;
	char *string;
	{
	char *pointer;
	int c;
	c = column;
	pointer = string;
	while( *pointer != 0 )
		{
		fv_cachr( line, c, *pointer, attribute );
		++c;
		++pointer;
		}
	}

/**************************************************************

	FUNCTION:       fv_cfill()

	DESCRIPTION:    This function fills a specified rectangular
			area of the screen with a specified character
			with a specified attribute.

	INPUT:          <top>, <left>, <bottom>, and <right>
			denote the coordinates for the rectangular
			area to be filled.  <character> is the character
			with which the area is to be filled, and
			<attribute> is the video attribute to be
			attached to the character.

	RETURNS:        none.

**************************************************************/

fv_cfill( top, left, bottom, right, character, attribute )
	int top, left, bottom, right, character, attribute;
	{
	int l, c;
	l = top;
	c = left;
	while( l <= bottom )
		{
		while( c <= right )
			{
			fv_cachr( l, c, character, attribute );
			++c;
			}
		c = left;
		++l;
		}
	}

